<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WyomingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '83001',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4728000',
                'longitude' => '-110.7582000',
                'city' => 'Jackson',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82435',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.7487000',
                'longitude' => '-108.7548000',
                'city' => 'Powell',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82834',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Buffalo',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82601',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Casper',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82414',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Cody',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82001',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Cheyenne',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82633',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Douglas',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82930',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Evanston',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82716',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Gillette',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82901',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.5911000',
                'longitude' => '-109.2131000',
                'city' => 'Rock Springs',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82007',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1382000',
                'longitude' => '-104.8150000',
                'city' => 'Cheyenne',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82005',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1382000',
                'longitude' => '-104.8150000',
                'city' => 'Ft Warren Afb',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82646',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8502000',
                'longitude' => '-106.3229000',
                'city' => 'Natrona',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82227',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7581000',
                'longitude' => '-104.4407000',
                'city' => 'Manville',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82070',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Laramie',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82301',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Rawlins',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82615',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8413000',
                'longitude' => '-106.3263000',
                'city' => 'Shirley Basin',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82801',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Sheridan',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82941',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8597000',
                'longitude' => '-109.8556000',
                'city' => 'Pinedale',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82609',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8502000',
                'longitude' => '-106.3229000',
                'city' => 'Casper',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82636',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8502000',
                'longitude' => '-106.3229000',
                'city' => 'Evansville',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82604',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8502000',
                'longitude' => '-106.3229000',
                'city' => 'Casper',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82644',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8502000',
                'longitude' => '-106.3229000',
                'city' => 'Mills',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82201',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Wheatland',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83110',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7235000',
                'longitude' => '-110.9302000',
                'city' => 'Afton',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82501',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Riverton',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82190',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.5624000',
                'longitude' => '-110.3907000',
                'city' => 'Yellowstone National Park',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82935',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Green River',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82009',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1813000',
                'longitude' => '-104.0667000',
                'city' => 'Cheyenne',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82082',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1813000',
                'longitude' => '-104.0667000',
                'city' => 'Pine Bluffs',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82050',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.4160000',
                'longitude' => '-104.0974000',
                'city' => 'Albin',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82081',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.4160000',
                'longitude' => '-104.0974000',
                'city' => 'Meriden',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83113',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4728000',
                'longitude' => '-110.7582000',
                'city' => 'Big Piney',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82718',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.2926000',
                'longitude' => '-105.4886000',
                'city' => 'Gillette',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82602',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8502000',
                'longitude' => '-106.3229000',
                'city' => 'Casper',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82637',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8413000',
                'longitude' => '-106.3263000',
                'city' => 'Glenrock',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83114',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.0823000',
                'longitude' => '-110.9593000',
                'city' => 'Cokeville',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82932',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.1061000',
                'longitude' => '-109.4307000',
                'city' => 'Farson',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82729',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.4080000',
                'longitude' => '-104.3726000',
                'city' => 'Sundance',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82336',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7858000',
                'longitude' => '-107.2396000',
                'city' => 'Wamsutter',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82334',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7858000',
                'longitude' => '-107.2396000',
                'city' => 'Sinclair',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82327',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.8699000',
                'longitude' => '-106.5639000',
                'city' => 'Hanna',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82331',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.4552000',
                'longitude' => '-106.8009000',
                'city' => 'Saratoga',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82325',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.2089000',
                'longitude' => '-106.7907000',
                'city' => 'Encampment',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82520',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8313000',
                'longitude' => '-108.7339000',
                'city' => 'Lander',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82514',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8347000',
                'longitude' => '-108.7263000',
                'city' => 'Fort Washakie',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82515',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8347000',
                'longitude' => '-108.7263000',
                'city' => 'Hudson',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82222',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7601000',
                'longitude' => '-104.4542000',
                'city' => 'Lance Creek',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82225',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7601000',
                'longitude' => '-104.4542000',
                'city' => 'Lusk',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82242',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7601000',
                'longitude' => '-104.4542000',
                'city' => 'Van Tassell',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82224',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7601000',
                'longitude' => '-104.4542000',
                'city' => 'Lost Springs',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82838',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '45.1243000',
                'longitude' => '-107.3915000',
                'city' => 'Parkman',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82401',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.0162000',
                'longitude' => '-107.9548000',
                'city' => 'Worland',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82324',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.6842000',
                'longitude' => '-106.4108000',
                'city' => 'Elk Mountain',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82943',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.5821000',
                'longitude' => '-109.2161000',
                'city' => 'Reliance',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83422',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.7232000',
                'longitude' => '-111.1095000',
                'city' => 'Driggs',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82442',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.0335000',
                'longitude' => '-107.4485000',
                'city' => 'Ten Sleep',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82925',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8597000',
                'longitude' => '-109.8556000',
                'city' => 'Cora',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82083',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7442000',
                'longitude' => '-105.9739000',
                'city' => 'Rock River',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82329',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.8987000',
                'longitude' => '-106.2020000',
                'city' => 'Medicine Bow',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82321',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.0384000',
                'longitude' => '-107.6601000',
                'city' => 'Baggs',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82323',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.0384000',
                'longitude' => '-107.6601000',
                'city' => 'Dixon',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82332',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.0384000',
                'longitude' => '-107.6601000',
                'city' => 'Savery',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83123',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.2619000',
                'longitude' => '-110.1937000',
                'city' => 'La Barge',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82721',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.2633000',
                'longitude' => '-104.9470000',
                'city' => 'Moorcroft',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82240',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.0653000',
                'longitude' => '-104.1835000',
                'city' => 'Torrington',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82426',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Greybull',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82003',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7580000',
                'longitude' => '-104.8218000',
                'city' => 'Cheyenne',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82210',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7580000',
                'longitude' => '-104.8218000',
                'city' => 'Chugwater',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82410',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Basin',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82635',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4109000',
                'longitude' => '-106.2770000',
                'city' => 'Edgerton',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82640',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4109000',
                'longitude' => '-106.2770000',
                'city' => 'Linch',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82643',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4109000',
                'longitude' => '-106.2770000',
                'city' => 'Midwest',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82513',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.5348000',
                'longitude' => '-109.6303000',
                'city' => 'Dubois',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82732',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.7578000',
                'longitude' => '-105.4838000',
                'city' => 'Wright',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82723',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.9787000',
                'longitude' => '-104.4193000',
                'city' => 'Osage',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82730',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.9787000',
                'longitude' => '-104.4193000',
                'city' => 'Upton',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82714',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6840000',
                'longitude' => '-104.5979000',
                'city' => 'Devils Tower',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82711',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6840000',
                'longitude' => '-104.5979000',
                'city' => 'Alva',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82720',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6840000',
                'longitude' => '-104.5979000',
                'city' => 'Hulett',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82701',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.0966000',
                'longitude' => '-104.6235000',
                'city' => 'Newcastle',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82432',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.2487000',
                'longitude' => '-107.6004000',
                'city' => 'Manderson',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82428',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.2487000',
                'longitude' => '-107.6004000',
                'city' => 'Hyattville',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82443',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.6402000',
                'longitude' => '-108.2065000',
                'city' => 'Thermopolis',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82512',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.3094000',
                'longitude' => '-109.1917000',
                'city' => 'Crowheart',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82244',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.0653000',
                'longitude' => '-104.1835000',
                'city' => 'Yoder',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82217',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.0653000',
                'longitude' => '-104.1835000',
                'city' => 'Hawk Springs',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82923',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8597000',
                'longitude' => '-109.8556000',
                'city' => 'Boulder',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82310',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.5015000',
                'longitude' => '-107.8075000',
                'city' => 'Jeffrey City',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83013',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.8679000',
                'longitude' => '-110.5825000',
                'city' => 'Moran',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82060',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1925000',
                'longitude' => '-104.3611000',
                'city' => 'Hillsdale',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82053',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1925000',
                'longitude' => '-104.3611000',
                'city' => 'Burns',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82054',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1925000',
                'longitude' => '-104.3611000',
                'city' => 'Carpenter',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82412',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8347000',
                'longitude' => '-108.3916000',
                'city' => 'Byron',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82420',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8347000',
                'longitude' => '-108.3916000',
                'city' => 'Cowley',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82431',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8347000',
                'longitude' => '-108.3916000',
                'city' => 'Lovell',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83101',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7937000',
                'longitude' => '-110.5427000',
                'city' => 'Kemmerer',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83452',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.7232000',
                'longitude' => '-111.1095000',
                'city' => 'Tetonia',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82712',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.4931000',
                'longitude' => '-103.8665000',
                'city' => 'Beulah',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '59008',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.9279000',
                'longitude' => '-109.1776000',
                'city' => 'Belfry',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83128',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.9794000',
                'longitude' => '-111.0245000',
                'city' => 'Alpine',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82844',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8984000',
                'longitude' => '-107.2081000',
                'city' => 'Wolf',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82836',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8984000',
                'longitude' => '-107.2081000',
                'city' => 'Dayton',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82839',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8984000',
                'longitude' => '-107.2081000',
                'city' => 'Ranchester',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '57735',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.3004000',
                'longitude' => '-103.8123000',
                'city' => 'Edgemont',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82423',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.9663000',
                'longitude' => '-108.6190000',
                'city' => 'Frannie',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82421',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.9663000',
                'longitude' => '-108.6190000',
                'city' => 'Deaver',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82833',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.7970000',
                'longitude' => '-106.9578000',
                'city' => 'Big Horn',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82717',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.3039000',
                'longitude' => '-105.4508000',
                'city' => 'Gillette',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82727',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.2908000',
                'longitude' => '-105.5027000',
                'city' => 'Rozet',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82842',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8002000',
                'longitude' => '-106.9499000',
                'city' => 'Story',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82832',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8002000',
                'longitude' => '-106.9499000',
                'city' => 'Banner',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83002',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4728000',
                'longitude' => '-110.7582000',
                'city' => 'Jackson',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82072',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.3101000',
                'longitude' => '-105.5932000',
                'city' => 'Laramie',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82649',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.2318000',
                'longitude' => '-108.1101000',
                'city' => 'Shoshoni',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83014',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4783000',
                'longitude' => '-110.7630000',
                'city' => 'Wilson',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83025',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4783000',
                'longitude' => '-110.7630000',
                'city' => 'Teton Village',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82213',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.5032000',
                'longitude' => '-105.0266000',
                'city' => 'Glendo',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82837',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6559000',
                'longitude' => '-106.1308000',
                'city' => 'Leiter',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82725',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6559000',
                'longitude' => '-106.1308000',
                'city' => 'Recluse',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82831',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6559000',
                'longitude' => '-106.1308000',
                'city' => 'Arvada',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82835',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8337000',
                'longitude' => '-106.8771000',
                'city' => 'Clearmont',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82845',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.8337000',
                'longitude' => '-106.8771000',
                'city' => 'Wyarno',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82639',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.7099000',
                'longitude' => '-106.6357000',
                'city' => 'Kaycee',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83012',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4783000',
                'longitude' => '-110.7630000',
                'city' => 'Moose',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82922',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.4728000',
                'longitude' => '-110.7582000',
                'city' => 'Bondurant',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82055',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.3101000',
                'longitude' => '-105.5932000',
                'city' => 'Centennial',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82937',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.2749000',
                'longitude' => '-110.3335000',
                'city' => 'Lyman',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '59025',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '45.0238000',
                'longitude' => '-106.8459000',
                'city' => 'Decker',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82440',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.7543000',
                'longitude' => '-108.7595000',
                'city' => 'Ralston',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82073',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.3101000',
                'longitude' => '-105.5932000',
                'city' => 'Laramie',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82434',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.4715000',
                'longitude' => '-108.4065000',
                'city' => 'Otto',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82422',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.4715000',
                'longitude' => '-108.4065000',
                'city' => 'Emblem',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82433',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.4715000',
                'longitude' => '-108.4065000',
                'city' => 'Meeteetse',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82411',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.4715000',
                'longitude' => '-108.4065000',
                'city' => 'Burlington',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82441',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.4867000',
                'longitude' => '-108.0511000',
                'city' => 'Shell',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82071',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.3101000',
                'longitude' => '-105.5932000',
                'city' => 'Laramie',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82061',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1338000',
                'longitude' => '-104.8168000',
                'city' => 'Horse Creek',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82059',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.1338000',
                'longitude' => '-104.8168000',
                'city' => 'Granite Canon',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82939',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.2749000',
                'longitude' => '-110.3335000',
                'city' => 'Mountain View',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82933',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.2749000',
                'longitude' => '-110.3335000',
                'city' => 'Fort Bridger',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82944',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.2749000',
                'longitude' => '-110.3335000',
                'city' => 'Robertson',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82936',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.2749000',
                'longitude' => '-110.3335000',
                'city' => 'Lonetree',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82931',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.2677000',
                'longitude' => '-110.9671000',
                'city' => 'Evanston',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83116',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7927000',
                'longitude' => '-110.5368000',
                'city' => 'Diamondville',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83124',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.7927000',
                'longitude' => '-110.5368000',
                'city' => 'Opal',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82221',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.6398000',
                'longitude' => '-104.1649000',
                'city' => 'Lagrange',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82215',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.2702000',
                'longitude' => '-104.7383000',
                'city' => 'Hartville',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82214',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.2702000',
                'longitude' => '-104.7383000',
                'city' => 'Guernsey',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82212',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.1352000',
                'longitude' => '-104.3402000',
                'city' => 'Fort Laramie',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82223',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.1352000',
                'longitude' => '-104.3402000',
                'city' => 'Lingle',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82243',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.1352000',
                'longitude' => '-104.3402000',
                'city' => 'Veteran',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82523',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.0222000',
                'longitude' => '-108.3843000',
                'city' => 'Pavillion',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82516',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.0222000',
                'longitude' => '-108.3843000',
                'city' => 'Kinnear',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83115',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.8597000',
                'longitude' => '-109.8556000',
                'city' => 'Daniel',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82929',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.5291000',
                'longitude' => '-109.4666000',
                'city' => 'Little America',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82938',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '41.0024000',
                'longitude' => '-109.7188000',
                'city' => 'Mc Kinnon',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82642',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '43.2362000',
                'longitude' => '-108.1085000',
                'city' => 'Lysite',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '59311',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '45.0292000',
                'longitude' => '-104.4113000',
                'city' => 'Alzada',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83120',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.9794000',
                'longitude' => '-111.0245000',
                'city' => 'Freedom',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83112',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.9794000',
                'longitude' => '-111.0245000',
                'city' => 'Bedford',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83127',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.9794000',
                'longitude' => '-111.0245000',
                'city' => 'Thayne',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83118',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.9794000',
                'longitude' => '-111.0245000',
                'city' => 'Etna',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83119',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7235000',
                'longitude' => '-110.9302000',
                'city' => 'Fairview',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83111',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7235000',
                'longitude' => '-110.9302000',
                'city' => 'Auburn',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83126',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7235000',
                'longitude' => '-110.9302000',
                'city' => 'Smoot',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '83122',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '42.7235000',
                'longitude' => '-110.9302000',
                'city' => 'Grover',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '57717',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6729000',
                'longitude' => '-103.8490000',
                'city' => 'Belle Fourche',
                'full_state' => 'Wyoming',
            ],
            [
                'zip' => '82710',
                'country_code' => 'US',
                'state' => 'WY',
                'latitude' => '44.6729000',
                'longitude' => '-103.8490000',
                'city' => 'Aladdin',
                'full_state' => 'Wyoming',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
