<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class VirginiaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '24382',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9510000',
                'longitude' => '-81.0859000',
                'city' => 'Wytheville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24641',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0998000',
                'longitude' => '-81.8011000',
                'city' => 'Richlands',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24258',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5488000',
                'longitude' => '-82.5574000',
                'city' => 'Hiltons',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24251',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5488000',
                'longitude' => '-82.5574000',
                'city' => 'Gate City',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24202',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5931000',
                'longitude' => '-82.1851000',
                'city' => 'Bristol',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24211',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7157000',
                'longitude' => '-81.9851000',
                'city' => 'Abingdon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24315',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1020000',
                'longitude' => '-81.1176000',
                'city' => 'Bland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24333',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6651000',
                'longitude' => '-80.9238000',
                'city' => 'Galax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24354',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8324000',
                'longitude' => '-81.5207000',
                'city' => 'Marion',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24226',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2071000',
                'longitude' => '-82.2898000',
                'city' => 'Clinchco',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24220',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2071000',
                'longitude' => '-82.2898000',
                'city' => 'Birchleaf',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24273',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9332000',
                'longitude' => '-82.6324000',
                'city' => 'Norton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24363',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5937000',
                'longitude' => '-81.3333000',
                'city' => 'Mouth Of Wilson',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24120',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7350000',
                'longitude' => '-80.4096000',
                'city' => 'Meadows Of Dan',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24084',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9486000',
                'longitude' => '-81.0811000',
                'city' => 'Dublin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24112',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6904000',
                'longitude' => '-79.8757000',
                'city' => 'Martinsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24290',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5449000',
                'longitude' => '-82.5604000',
                'city' => 'Weber City',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24185',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7761000',
                'longitude' => '-80.2554000',
                'city' => 'Woolwine',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24381',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6651000',
                'longitude' => '-80.9238000',
                'city' => 'Woodlawn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24330',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6651000',
                'longitude' => '-80.9238000',
                'city' => 'Fries',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24614',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2764000',
                'longitude' => '-82.0973000',
                'city' => 'Grundy',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24605',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2576000',
                'longitude' => '-81.2677000',
                'city' => 'Bluefield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24368',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8935000',
                'longitude' => '-81.2730000',
                'city' => 'Rural Retreat',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24053',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6005000',
                'longitude' => '-80.5080000',
                'city' => 'Ararat',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24076',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6005000',
                'longitude' => '-80.5080000',
                'city' => 'Claudville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24089',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6904000',
                'longitude' => '-79.8757000',
                'city' => 'Fieldale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24078',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6904000',
                'longitude' => '-79.8757000',
                'city' => 'Collinsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24634',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2592000',
                'longitude' => '-81.9290000',
                'city' => 'Pilgrims Knob',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24631',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2592000',
                'longitude' => '-81.9290000',
                'city' => 'Oakwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24657',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2592000',
                'longitude' => '-81.9290000',
                'city' => 'Whitewood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24317',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5910000',
                'longitude' => '-80.6583000',
                'city' => 'Cana',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24343',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7590000',
                'longitude' => '-80.7355000',
                'city' => 'Hillsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24210',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7157000',
                'longitude' => '-81.9851000',
                'city' => 'Abingdon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24348',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6244000',
                'longitude' => '-81.1562000',
                'city' => 'Independence',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24312',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8493000',
                'longitude' => '-80.9150000',
                'city' => 'Austinville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24293',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9796000',
                'longitude' => '-82.5839000',
                'city' => 'Wise',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24630',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2546000',
                'longitude' => '-81.2835000',
                'city' => 'North Tazewell',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24613',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2546000',
                'longitude' => '-81.2835000',
                'city' => 'Falls Mills',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24263',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6912000',
                'longitude' => '-83.1099000',
                'city' => 'Jonesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24281',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6912000',
                'longitude' => '-83.1099000',
                'city' => 'Rose Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24218',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6912000',
                'longitude' => '-83.1099000',
                'city' => 'Ben Hur',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24221',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6912000',
                'longitude' => '-83.1099000',
                'city' => 'Blackwater',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24168',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7000000',
                'longitude' => '-79.9155000',
                'city' => 'Stanleytown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24277',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8018000',
                'longitude' => '-83.0618000',
                'city' => 'Pennington Gap',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24282',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8018000',
                'longitude' => '-83.0618000',
                'city' => 'Saint Charles',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24292',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6540000',
                'longitude' => '-81.6415000',
                'city' => 'Whitetop',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24378',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6540000',
                'longitude' => '-81.6415000',
                'city' => 'Troutdale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24236',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6540000',
                'longitude' => '-81.6415000',
                'city' => 'Damascus',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24283',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9428000',
                'longitude' => '-82.4641000',
                'city' => 'Saint Paul',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24230',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9428000',
                'longitude' => '-82.4641000',
                'city' => 'Coeburn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24325',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7146000',
                'longitude' => '-80.5405000',
                'city' => 'Dugspur',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24352',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7146000',
                'longitude' => '-80.5405000',
                'city' => 'Laurel Fork',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24328',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7146000',
                'longitude' => '-80.5405000',
                'city' => 'Fancy Gap',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24266',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8971000',
                'longitude' => '-82.0829000',
                'city' => 'Lebanon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24319',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7869000',
                'longitude' => '-81.7687000',
                'city' => 'Chilhowie',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24340',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7869000',
                'longitude' => '-81.7687000',
                'city' => 'Glade Spring',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24244',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7248000',
                'longitude' => '-82.8001000',
                'city' => 'Duffield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24248',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6591000',
                'longitude' => '-83.3919000',
                'city' => 'Ewing',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24250',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6777000',
                'longitude' => '-82.5694000',
                'city' => 'Fort Blackmore',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24270',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5931000',
                'longitude' => '-82.1851000',
                'city' => 'Mendota',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24201',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5931000',
                'longitude' => '-82.1851000',
                'city' => 'Bristol',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24245',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8319000',
                'longitude' => '-82.4666000',
                'city' => 'Dungannon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24608',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1000000',
                'longitude' => '-81.3421000',
                'city' => 'Burkes Garden',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24361',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6357000',
                'longitude' => '-81.7913000',
                'city' => 'Meadowview',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24271',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7479000',
                'longitude' => '-82.4166000',
                'city' => 'Nickelsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24272',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9756000',
                'longitude' => '-82.2987000',
                'city' => 'Nora',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24237',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9756000',
                'longitude' => '-82.2987000',
                'city' => 'Dante',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24377',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8834000',
                'longitude' => '-81.7640000',
                'city' => 'Tannersville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24316',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8834000',
                'longitude' => '-81.7640000',
                'city' => 'Broadford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24370',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8834000',
                'longitude' => '-81.7640000',
                'city' => 'Saltville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24639',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2105000',
                'longitude' => '-82.0060000',
                'city' => 'Raven',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24656',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2105000',
                'longitude' => '-82.0060000',
                'city' => 'Vansant',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24624',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2105000',
                'longitude' => '-82.0060000',
                'city' => 'Keen Mountain',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24646',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2105000',
                'longitude' => '-82.0060000',
                'city' => 'Rowe',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24627',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2105000',
                'longitude' => '-82.0060000',
                'city' => 'Mavisdale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24318',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0182000',
                'longitude' => '-81.3392000',
                'city' => 'Ceres',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24246',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8675000',
                'longitude' => '-82.7740000',
                'city' => 'East Stone Gap',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24219',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8675000',
                'longitude' => '-82.7740000',
                'city' => 'Big Stone Gap',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24603',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3398000',
                'longitude' => '-82.1838000',
                'city' => 'Big Rock',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24607',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3051000',
                'longitude' => '-82.1776000',
                'city' => 'Breaks',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24628',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3051000',
                'longitude' => '-82.1776000',
                'city' => 'Maxie',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24243',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7586000',
                'longitude' => '-83.0271000',
                'city' => 'Dryden',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24265',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7586000',
                'longitude' => '-83.0271000',
                'city' => 'Keokee',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24215',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9014000',
                'longitude' => '-82.7889000',
                'city' => 'Andover',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24216',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9014000',
                'longitude' => '-82.7889000',
                'city' => 'Appalachia',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24658',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4223000',
                'longitude' => '-82.0209000',
                'city' => 'Wolford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24620',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4223000',
                'longitude' => '-82.0209000',
                'city' => 'Hurley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24360',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9759000',
                'longitude' => '-80.9518000',
                'city' => 'Max Meadows',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24609',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0934000',
                'longitude' => '-81.7992000',
                'city' => 'Cedar Bluff',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24637',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0934000',
                'longitude' => '-81.7992000',
                'city' => 'Pounding Mill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24323',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9510000',
                'longitude' => '-81.0859000',
                'city' => 'Crockett',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24374',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8292000',
                'longitude' => '-81.1004000',
                'city' => 'Speedwell',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24350',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8292000',
                'longitude' => '-81.1004000',
                'city' => 'Ivanhoe',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24322',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8292000',
                'longitude' => '-81.1004000',
                'city' => 'Cripple Creek',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24055',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7600000',
                'longitude' => '-79.9901000',
                'city' => 'Bassett',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24133',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7600000',
                'longitude' => '-79.9901000',
                'city' => 'Patrick Springs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24102',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7600000',
                'longitude' => '-79.9901000',
                'city' => 'Henry',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24054',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6904000',
                'longitude' => '-79.8757000',
                'city' => 'Axton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24324',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9696000',
                'longitude' => '-80.9499000',
                'city' => 'Draper',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24148',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6595000',
                'longitude' => '-79.7102000',
                'city' => 'Ridgeway',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24326',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7332000',
                'longitude' => '-81.2007000',
                'city' => 'Elk Creek',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24375',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7731000',
                'longitude' => '-81.4116000',
                'city' => 'Sugar Grove',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24069',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8324000',
                'longitude' => '-81.5207000',
                'city' => 'Cascade',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24311',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8896000',
                'longitude' => '-81.2760000',
                'city' => 'Atkins',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24314',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1020000',
                'longitude' => '-81.1176000',
                'city' => 'Bastian',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24082',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6408000',
                'longitude' => '-80.2671000',
                'city' => 'Critz',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24171',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6408000',
                'longitude' => '-80.2671000',
                'city' => 'Stuart',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24165',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6408000',
                'longitude' => '-80.2671000',
                'city' => 'Spencer',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24366',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2437000',
                'longitude' => '-81.1092000',
                'city' => 'Rocky Gap',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24224',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8429000',
                'longitude' => '-82.2246000',
                'city' => 'Castlewood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24351',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5969000',
                'longitude' => '-80.6806000',
                'city' => 'Lambsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24347',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8579000',
                'longitude' => '-80.7597000',
                'city' => 'Hiwassee',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24313',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8579000',
                'longitude' => '-80.7597000',
                'city' => 'Barren Springs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24279',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1231000',
                'longitude' => '-82.6035000',
                'city' => 'Pound',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24269',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1611000',
                'longitude' => '-82.3596000',
                'city' => 'Mc Clure',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24256',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1611000',
                'longitude' => '-82.3596000',
                'city' => 'Haysi',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24228',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1611000',
                'longitude' => '-82.3596000',
                'city' => 'Clintwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24239',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1099000',
                'longitude' => '-82.1548000',
                'city' => 'Davenport',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24217',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1099000',
                'longitude' => '-82.1548000',
                'city' => 'Bee',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24260',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1099000',
                'longitude' => '-82.1548000',
                'city' => 'Honaker',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24649',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0165000',
                'longitude' => '-81.9708000',
                'city' => 'Swords Creek',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24280',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9601000',
                'longitude' => '-81.9325000',
                'city' => 'Rosedale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24622',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1859000',
                'longitude' => '-81.7897000',
                'city' => 'Jewell Ridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24225',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9010000',
                'longitude' => '-82.0799000',
                'city' => 'Cleveland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24088',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7761000',
                'longitude' => '-80.2554000',
                'city' => 'Ferrum',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24327',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7609000',
                'longitude' => '-81.8703000',
                'city' => 'Emory',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24635',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3041000',
                'longitude' => '-81.3400000',
                'city' => 'Pocahontas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24606',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3041000',
                'longitude' => '-81.3400000',
                'city' => 'Boissevain',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24177',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7350000',
                'longitude' => '-80.4096000',
                'city' => 'Vesta',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24612',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0934000',
                'longitude' => '-81.7992000',
                'city' => 'Doran',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24651',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0934000',
                'longitude' => '-81.7992000',
                'city' => 'Tazewell',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24602',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0934000',
                'longitude' => '-81.7992000',
                'city' => 'Bandy',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24503',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4074000',
                'longitude' => '-79.1398000',
                'city' => 'Lynchburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24501',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4074000',
                'longitude' => '-79.1398000',
                'city' => 'Lynchburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22904',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Charlottesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24586',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5815000',
                'longitude' => '-79.3918000',
                'city' => 'Ringgold',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24540',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5815000',
                'longitude' => '-79.3918000',
                'city' => 'Danville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22932',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0665000',
                'longitude' => '-78.7015000',
                'city' => 'Crozet',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23055',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Fork Union',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22963',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8606000',
                'longitude' => '-78.2675000',
                'city' => 'Palmyra',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24590',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Scottsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23917',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6681000',
                'longitude' => '-78.3919000',
                'city' => 'Boydton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22903',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Charlottesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22902',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Charlottesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22911',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Charlottesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22901',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Charlottesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24592',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7017000',
                'longitude' => '-78.8994000',
                'city' => 'South Boston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23901',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2431000',
                'longitude' => '-78.4604000',
                'city' => 'Farmville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23947',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2431000',
                'longitude' => '-78.4604000',
                'city' => 'Keysville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23923',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2431000',
                'longitude' => '-78.4604000',
                'city' => 'Charlotte Court House',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23943',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2431000',
                'longitude' => '-78.4604000',
                'city' => 'Hampden Sydney',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23954',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2431000',
                'longitude' => '-78.4604000',
                'city' => 'Meherrin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22949',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7572000',
                'longitude' => '-78.8768000',
                'city' => 'Lovingston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24541',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5815000',
                'longitude' => '-79.3918000',
                'city' => 'Danville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24528',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0445000',
                'longitude' => '-78.9482000',
                'city' => 'Brookneal',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24502',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3623000',
                'longitude' => '-79.2111000',
                'city' => 'Lynchburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22908',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Charlottesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22959',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'North Garden',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22947',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Keswick',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23897',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9435000',
                'longitude' => '-77.4019000',
                'city' => 'Yale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23882',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9435000',
                'longitude' => '-77.4019000',
                'city' => 'Stony Creek',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23867',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9435000',
                'longitude' => '-77.4019000',
                'city' => 'Jarratt',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23805',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9435000',
                'longitude' => '-77.4019000',
                'city' => 'Petersburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23830',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9435000',
                'longitude' => '-77.4019000',
                'city' => 'Carson',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23890',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9435000',
                'longitude' => '-77.4019000',
                'city' => 'Waverly',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23920',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7254000',
                'longitude' => '-78.1316000',
                'city' => 'Brodnax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23950',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7254000',
                'longitude' => '-78.1316000',
                'city' => 'La Crosse',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24522',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2606000',
                'longitude' => '-78.6809000',
                'city' => 'Appomattox',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23963',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2606000',
                'longitude' => '-78.6809000',
                'city' => 'Red House',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23958',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2606000',
                'longitude' => '-78.6809000',
                'city' => 'Pamplin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23934',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2606000',
                'longitude' => '-78.6809000',
                'city' => 'Cullen',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23959',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2606000',
                'longitude' => '-78.6809000',
                'city' => 'Phenix',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23927',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5539000',
                'longitude' => '-78.3627000',
                'city' => 'Clarksville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22969',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7585000',
                'longitude' => '-78.8688000',
                'city' => 'Schuyler',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22971',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7585000',
                'longitude' => '-78.8688000',
                'city' => 'Shipman',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24521',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7585000',
                'longitude' => '-78.8688000',
                'city' => 'Amherst',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24599',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7585000',
                'longitude' => '-78.8688000',
                'city' => 'Wingina',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22922',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7585000',
                'longitude' => '-78.8688000',
                'city' => 'Arrington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22938',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7585000',
                'longitude' => '-78.8688000',
                'city' => 'Faber',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22964',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7171000',
                'longitude' => '-79.0211000',
                'city' => 'Piney River',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22967',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7171000',
                'longitude' => '-79.0211000',
                'city' => 'Roseland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22976',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7171000',
                'longitude' => '-79.0211000',
                'city' => 'Tyro',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24517',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1634000',
                'longitude' => '-79.0709000',
                'city' => 'Altavista',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24538',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1634000',
                'longitude' => '-79.0709000',
                'city' => 'Concord',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24569',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1634000',
                'longitude' => '-79.0709000',
                'city' => 'Long Island',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24554',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1634000',
                'longitude' => '-79.0709000',
                'city' => 'Gladys',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22937',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8023000',
                'longitude' => '-78.4911000',
                'city' => 'Esmont',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22946',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8023000',
                'longitude' => '-78.4911000',
                'city' => 'Keene',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24562',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8023000',
                'longitude' => '-78.4911000',
                'city' => 'Howardsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23930',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0720000',
                'longitude' => '-78.0075000',
                'city' => 'Crewe',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23824',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0720000',
                'longitude' => '-78.0075000',
                'city' => 'Blackstone',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22974',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Troy',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23944',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0720000',
                'longitude' => '-78.0075000',
                'city' => 'Kenbridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24536',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5318000',
                'longitude' => '-79.3605000',
                'city' => 'Coleman Falls',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24523',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5318000',
                'longitude' => '-79.3605000',
                'city' => 'Bedford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24526',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5318000',
                'longitude' => '-79.3605000',
                'city' => 'Big Island',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24574',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5318000',
                'longitude' => '-79.3605000',
                'city' => 'Monroe',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24571',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1148000',
                'longitude' => '-79.2822000',
                'city' => 'Lynch Station',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24550',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1148000',
                'longitude' => '-79.2822000',
                'city' => 'Evington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23966',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3004000',
                'longitude' => '-78.3919000',
                'city' => 'Rice',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23942',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3004000',
                'longitude' => '-78.3919000',
                'city' => 'Green Bay',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24551',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3966000',
                'longitude' => '-79.2244000',
                'city' => 'Forest',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23974',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9911000',
                'longitude' => '-78.2345000',
                'city' => 'Victoria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23821',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8669000',
                'longitude' => '-77.8823000',
                'city' => 'Alberta',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24557',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1019000',
                'longitude' => '-79.2996000',
                'city' => 'Gretna',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24563',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1019000',
                'longitude' => '-79.2996000',
                'city' => 'Hurt',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22958',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9146000',
                'longitude' => '-78.9473000',
                'city' => 'Nellysford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24588',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2778000',
                'longitude' => '-79.1012000',
                'city' => 'Rustburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24504',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2778000',
                'longitude' => '-79.1012000',
                'city' => 'Lynchburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23879',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6923000',
                'longitude' => '-77.5401000',
                'city' => 'Skippers',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23847',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6923000',
                'longitude' => '-77.5401000',
                'city' => 'Emporia',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23856',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6923000',
                'longitude' => '-77.5401000',
                'city' => 'Freeman',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24597',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9347000',
                'longitude' => '-79.0105000',
                'city' => 'Vernon Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24565',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9347000',
                'longitude' => '-79.0105000',
                'city' => 'Java',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24577',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9347000',
                'longitude' => '-79.0105000',
                'city' => 'Nathalie',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24558',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9347000',
                'longitude' => '-79.0105000',
                'city' => 'Halifax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24593',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3556000',
                'longitude' => '-78.8304000',
                'city' => 'Spout Spring',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22920',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8932000',
                'longitude' => '-78.8746000',
                'city' => 'Afton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23924',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7965000',
                'longitude' => '-78.4578000',
                'city' => 'Chase City',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23968',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7965000',
                'longitude' => '-78.4578000',
                'city' => 'Skipwith',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24529',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6211000',
                'longitude' => '-78.5611000',
                'city' => 'Buffalo Junction',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24580',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6211000',
                'longitude' => '-78.5611000',
                'city' => 'Nelson',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24576',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0445000',
                'longitude' => '-78.9482000',
                'city' => 'Naruna',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24595',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5553000',
                'longitude' => '-79.0787000',
                'city' => 'Sweet Briar',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24572',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4501000',
                'longitude' => '-79.2220000',
                'city' => 'Madison Heights',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23909',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3004000',
                'longitude' => '-78.3919000',
                'city' => 'Farmville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24566',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7102000',
                'longitude' => '-79.3768000',
                'city' => 'Keeling',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24549',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7102000',
                'longitude' => '-79.3768000',
                'city' => 'Dry Fork',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24527',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8252000',
                'longitude' => '-79.4055000',
                'city' => 'Blairs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24531',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8252000',
                'longitude' => '-79.4055000',
                'city' => 'Chatham',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24539',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9347000',
                'longitude' => '-79.0105000',
                'city' => 'Crystal Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23915',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7254000',
                'longitude' => '-78.1316000',
                'city' => 'Baskerville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23970',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7254000',
                'longitude' => '-78.1316000',
                'city' => 'South Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23962',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8341000',
                'longitude' => '-78.7360000',
                'city' => 'Randolph',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23967',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8341000',
                'longitude' => '-78.7360000',
                'city' => 'Saxe',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24589',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8341000',
                'longitude' => '-78.7360000',
                'city' => 'Scottsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24534',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8341000',
                'longitude' => '-78.7360000',
                'city' => 'Clover',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '27705',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7017000',
                'longitude' => '-78.8994000',
                'city' => 'Durham',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22973',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3008000',
                'longitude' => '-78.4339000',
                'city' => 'Stanardsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23093',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8606000',
                'longitude' => '-78.2675000',
                'city' => 'Louisa',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24520',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7017000',
                'longitude' => '-78.8994000',
                'city' => 'Alton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24598',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7017000',
                'longitude' => '-78.8994000',
                'city' => 'Virgilina',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23868',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7562000',
                'longitude' => '-77.8509000',
                'city' => 'Lawrenceville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23803',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8044000',
                'longitude' => '-77.4715000',
                'city' => 'Petersburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23922',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1740000',
                'longitude' => '-78.1233000',
                'city' => 'Burkeville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23937',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9948000',
                'longitude' => '-78.6038000',
                'city' => 'Drakes Branch',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23936',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3066000',
                'longitude' => '-78.5598000',
                'city' => 'Dillwyn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23960',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3066000',
                'longitude' => '-78.5598000',
                'city' => 'Prospect',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23857',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6076000',
                'longitude' => '-77.8719000',
                'city' => 'Gasburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23887',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6076000',
                'longitude' => '-77.8719000',
                'city' => 'Valentines',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23893',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6076000',
                'longitude' => '-77.8719000',
                'city' => 'White Plains',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23004',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6828000',
                'longitude' => '-78.3479000',
                'city' => 'Arvonia',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23123',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6828000',
                'longitude' => '-78.3479000',
                'city' => 'New Canton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23084',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8606000',
                'longitude' => '-78.2675000',
                'city' => 'Kents Store',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23038',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8606000',
                'longitude' => '-78.2675000',
                'city' => 'Columbia',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23845',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5957000',
                'longitude' => '-78.0744000',
                'city' => 'Ebony',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23919',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5957000',
                'longitude' => '-78.0744000',
                'city' => 'Bracey',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24139',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9486000',
                'longitude' => '-79.3621000',
                'city' => 'Pittsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23829',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7070000',
                'longitude' => '-77.2026000',
                'city' => 'Capron',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23844',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7070000',
                'longitude' => '-77.2026000',
                'city' => 'Drewryville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23827',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7070000',
                'longitude' => '-77.2026000',
                'city' => 'Boykins',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23837',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7070000',
                'longitude' => '-77.2026000',
                'city' => 'Courtland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23938',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9591000',
                'longitude' => '-78.1230000',
                'city' => 'Dundas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23952',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9911000',
                'longitude' => '-78.2345000',
                'city' => 'Lunenburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24530',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7113000',
                'longitude' => '-79.5259000',
                'city' => 'Callands',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23976',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8205000',
                'longitude' => '-78.5961000',
                'city' => 'Wylliesburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23964',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8205000',
                'longitude' => '-78.5961000',
                'city' => 'Red Oak',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24594',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6237000',
                'longitude' => '-79.0443000',
                'city' => 'Sutherlin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22931',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Covesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22940',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0665000',
                'longitude' => '-78.7015000',
                'city' => 'Free Union',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23022',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7589000',
                'longitude' => '-78.2627000',
                'city' => 'Bremo Bluff',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23843',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7600000',
                'longitude' => '-77.8477000',
                'city' => 'Dolphin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23015',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Beaverdam',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24483',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6690000',
                'longitude' => '-79.2133000',
                'city' => 'Vesuvius',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24161',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9545000',
                'longitude' => '-79.5420000',
                'city' => 'Sandy Level',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24137',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9545000',
                'longitude' => '-79.5420000',
                'city' => 'Penhook',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24553',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5463000',
                'longitude' => '-78.8302000',
                'city' => 'Gladstone',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22968',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3008000',
                'longitude' => '-78.4339000',
                'city' => 'Ruckersville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22727',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3008000',
                'longitude' => '-78.4339000',
                'city' => 'Madison',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23889',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8605000',
                'longitude' => '-77.8808000',
                'city' => 'Warfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23876',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8605000',
                'longitude' => '-77.8808000',
                'city' => 'Rawlings',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22906',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Charlottesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24060',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Blacksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22980',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0336000',
                'longitude' => '-78.4916000',
                'city' => 'Waynesboro',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22923',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0794000',
                'longitude' => '-78.4739000',
                'city' => 'Barboursville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22936',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0794000',
                'longitude' => '-78.4739000',
                'city' => 'Earlysville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23921',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5507000',
                'longitude' => '-78.5561000',
                'city' => 'Buckingham',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23040',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5431000',
                'longitude' => '-78.4583000',
                'city' => 'Cumberland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22935',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3008000',
                'longitude' => '-78.4339000',
                'city' => 'Dyke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24061',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2334000',
                'longitude' => '-80.4175000',
                'city' => 'Blacksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24015',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24128',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2932000',
                'longitude' => '-80.4929000',
                'city' => 'Newport',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24013',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24016',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23117',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0078000',
                'longitude' => '-77.9108000',
                'city' => 'Mineral',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22407',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3016000',
                'longitude' => '-77.4664000',
                'city' => 'Fredericksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22408',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3016000',
                'longitude' => '-77.4664000',
                'city' => 'Fredericksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22801',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4478000',
                'longitude' => '-78.8640000',
                'city' => 'Harrisonburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22803',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4478000',
                'longitude' => '-78.8640000',
                'city' => 'Harrisonburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22802',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4503000',
                'longitude' => '-78.8689000',
                'city' => 'Harrisonburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22714',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4697000',
                'longitude' => '-78.0004000',
                'city' => 'Brandy Station',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22729',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4697000',
                'longitude' => '-78.0004000',
                'city' => 'Mitchells',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22939',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1520000',
                'longitude' => '-79.0772000',
                'city' => 'Fishersville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24401',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1520000',
                'longitude' => '-79.0772000',
                'city' => 'Staunton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22701',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4697000',
                'longitude' => '-78.0004000',
                'city' => 'Culpeper',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22555',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3016000',
                'longitude' => '-77.4664000',
                'city' => 'Stafford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22712',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4697000',
                'longitude' => '-78.0004000',
                'city' => 'Bealeton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20115',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4697000',
                'longitude' => '-78.0004000',
                'city' => 'Marshall',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24018',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24153',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Salem',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24073',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Christiansburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24014',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24011',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24001',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2704000',
                'longitude' => '-79.9444000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22026',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3016000',
                'longitude' => '-77.4664000',
                'city' => 'Dumfries',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22747',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7194000',
                'longitude' => '-78.1599000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24555',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6356000',
                'longitude' => '-79.5514000',
                'city' => 'Glasgow',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24579',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6356000',
                'longitude' => '-79.5514000',
                'city' => 'Natural Bridge Station',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24141',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1340000',
                'longitude' => '-80.5768000',
                'city' => 'Radford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22664',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8803000',
                'longitude' => '-78.5101000',
                'city' => 'Woodstock',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22841',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2875000',
                'longitude' => '-78.9149000',
                'city' => 'Mount Crawford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24467',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2875000',
                'longitude' => '-78.9149000',
                'city' => 'Mount Sidney',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24471',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2875000',
                'longitude' => '-78.9149000',
                'city' => 'Port Republic',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24486',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2875000',
                'longitude' => '-78.9149000',
                'city' => 'Weyers Cave',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22812',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3839000',
                'longitude' => '-78.9739000',
                'city' => 'Bridgewater',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24151',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9938000',
                'longitude' => '-79.8927000',
                'city' => 'Rocky Mount',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22554',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4195000',
                'longitude' => '-77.4068000',
                'city' => 'Stafford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22835',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6668000',
                'longitude' => '-78.4597000',
                'city' => 'Luray',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22401',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1994000',
                'longitude' => '-79.0097000',
                'city' => 'Fredericksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24482',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1994000',
                'longitude' => '-79.0097000',
                'city' => 'Verona',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24437',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1994000',
                'longitude' => '-79.0097000',
                'city' => 'Fort Defiance',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22603',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1869000',
                'longitude' => '-78.1669000',
                'city' => 'Winchester',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22602',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1869000',
                'longitude' => '-78.1669000',
                'city' => 'Winchester',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24431',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2623000',
                'longitude' => '-78.8241000',
                'city' => 'Crimora',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24441',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2623000',
                'longitude' => '-78.8241000',
                'city' => 'Grottoes',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20118',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8595000',
                'longitude' => '-77.7754000',
                'city' => 'Middleburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20198',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8595000',
                'longitude' => '-77.7754000',
                'city' => 'The Plains',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24066',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5324000',
                'longitude' => '-79.6784000',
                'city' => 'Buchanan',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24019',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5324000',
                'longitude' => '-79.6784000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24162',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1358000',
                'longitude' => '-80.4064000',
                'city' => 'Shawsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24149',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1358000',
                'longitude' => '-80.4064000',
                'city' => 'Riner',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24450',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6287000',
                'longitude' => '-79.4743000',
                'city' => 'Lexington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24416',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6287000',
                'longitude' => '-79.4743000',
                'city' => 'Buena Vista',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24435',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7329000',
                'longitude' => '-79.3475000',
                'city' => 'Fairfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24017',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3124000',
                'longitude' => '-79.9518000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24012',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3124000',
                'longitude' => '-79.9518000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24087',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1716000',
                'longitude' => '-80.2417000',
                'city' => 'Elliston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22832',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4174000',
                'longitude' => '-78.8054000',
                'city' => 'Keezletown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22601',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7187000',
                'longitude' => '-77.7916000',
                'city' => 'Winchester',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20187',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7187000',
                'longitude' => '-77.7916000',
                'city' => 'Warrenton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22405',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3016000',
                'longitude' => '-77.4664000',
                'city' => 'Fredericksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24484',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1219000',
                'longitude' => '-79.8943000',
                'city' => 'Warm Springs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22827',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1520000',
                'longitude' => '-79.0772000',
                'city' => 'Elkton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22448',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3530000',
                'longitude' => '-77.0461000',
                'city' => 'Dahlgren',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22728',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4032000',
                'longitude' => '-77.5628000',
                'city' => 'Midland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22720',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4032000',
                'longitude' => '-77.5628000',
                'city' => 'Goldvein',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22406',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4032000',
                'longitude' => '-77.5628000',
                'city' => 'Fredericksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22840',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3693000',
                'longitude' => '-78.7338000',
                'city' => 'Mc Gaheysville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22846',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3693000',
                'longitude' => '-78.7338000',
                'city' => 'Penn Laird',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24578',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6356000',
                'longitude' => '-79.5514000',
                'city' => 'Natural Bridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24104',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1835000',
                'longitude' => '-79.5626000',
                'city' => 'Huddleston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24095',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1835000',
                'longitude' => '-79.5626000',
                'city' => 'Goodview',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24121',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1835000',
                'longitude' => '-79.5626000',
                'city' => 'Moneta',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22849',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4063000',
                'longitude' => '-78.6253000',
                'city' => 'Shenandoah',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22630',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9253000',
                'longitude' => '-78.1947000',
                'city' => 'Front Royal',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22960',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2399000',
                'longitude' => '-78.0986000',
                'city' => 'Orange',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24179',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2680000',
                'longitude' => '-79.9395000',
                'city' => 'Vinton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20186',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7187000',
                'longitude' => '-77.7916000',
                'city' => 'Warrenton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24440',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0323000',
                'longitude' => '-79.0580000',
                'city' => 'Greenville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24477',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0323000',
                'longitude' => '-79.0580000',
                'city' => 'Stuarts Draft',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22943',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8218000',
                'longitude' => '-78.5673000',
                'city' => 'Greenwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23225',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2680000',
                'longitude' => '-79.9395000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22824',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8218000',
                'longitude' => '-78.5673000',
                'city' => 'Edinburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22652',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8218000',
                'longitude' => '-78.5673000',
                'city' => 'Fort Valley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24184',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1162000',
                'longitude' => '-79.9516000',
                'city' => 'Wirtz',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24067',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1162000',
                'longitude' => '-79.9516000',
                'city' => 'Callaway',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24065',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1162000',
                'longitude' => '-79.9516000',
                'city' => 'Boones Mill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24479',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2060000',
                'longitude' => '-79.1925000',
                'city' => 'Swoope',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24421',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2060000',
                'longitude' => '-79.1925000',
                'city' => 'Churchville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20141',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1410000',
                'longitude' => '-77.7213000',
                'city' => 'Round Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20132',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1410000',
                'longitude' => '-77.7213000',
                'city' => 'Purcellville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20160',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1410000',
                'longitude' => '-77.7213000',
                'city' => 'Lincoln',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20131',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1410000',
                'longitude' => '-77.7213000',
                'city' => 'Philomont',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20158',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1410000',
                'longitude' => '-77.7213000',
                'city' => 'Hamilton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20175',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1410000',
                'longitude' => '-77.7213000',
                'city' => 'Leesburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20137',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7149000',
                'longitude' => '-77.7949000',
                'city' => 'Broad Run',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20106',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7149000',
                'longitude' => '-77.7949000',
                'city' => 'Amissville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24472',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9341000',
                'longitude' => '-79.3133000',
                'city' => 'Raphine',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24415',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9341000',
                'longitude' => '-79.3133000',
                'city' => 'Brownsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24459',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9341000',
                'longitude' => '-79.3133000',
                'city' => 'Middlebrook',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24473',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9341000',
                'longitude' => '-79.3133000',
                'city' => 'Rockbridge Baths',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20119',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7149000',
                'longitude' => '-77.7949000',
                'city' => 'Catlett',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22843',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3337000',
                'longitude' => '-79.0999000',
                'city' => 'Mount Solon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24009',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2680000',
                'longitude' => '-79.9395000',
                'city' => 'Roanoke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24124',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3326000',
                'longitude' => '-80.8089000',
                'city' => 'Narrows',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24469',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2011000',
                'longitude' => '-78.8965000',
                'city' => 'New Hope',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20144',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8639000',
                'longitude' => '-77.8570000',
                'city' => 'Delaplane',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22639',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8639000',
                'longitude' => '-77.8570000',
                'city' => 'Hume',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22643',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8639000',
                'longitude' => '-77.8570000',
                'city' => 'Markham',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22642',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8639000',
                'longitude' => '-77.8570000',
                'city' => 'Linden',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20128',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8639000',
                'longitude' => '-77.8570000',
                'city' => 'Orlean',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20140',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8639000',
                'longitude' => '-77.8570000',
                'city' => 'Rectortown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24464',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9260000',
                'longitude' => '-79.2020000',
                'city' => 'Montebello',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24476',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9260000',
                'longitude' => '-79.2020000',
                'city' => 'Steeles Tavern',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24138',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1320000',
                'longitude' => '-80.4094000',
                'city' => 'Pilot',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24070',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3704000',
                'longitude' => '-80.0764000',
                'city' => 'Catawba',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24175',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3704000',
                'longitude' => '-80.0764000',
                'city' => 'Troutville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24433',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3323000',
                'longitude' => '-79.4920000',
                'city' => 'Doe Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24442',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3323000',
                'longitude' => '-79.4920000',
                'city' => 'Head Waters',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24487',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3323000',
                'longitude' => '-79.4920000',
                'city' => 'Williamsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24458',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3323000',
                'longitude' => '-79.4920000',
                'city' => 'Mc Dowell',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22508',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4332000',
                'longitude' => '-77.8269000',
                'city' => 'Locust Grove',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22726',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4332000',
                'longitude' => '-77.8269000',
                'city' => 'Lignum',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22741',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4332000',
                'longitude' => '-77.8269000',
                'city' => 'Stevensburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22736',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4332000',
                'longitude' => '-77.8269000',
                'city' => 'Richardsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22718',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4332000',
                'longitude' => '-77.8269000',
                'city' => 'Elkwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24176',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9982000',
                'longitude' => '-79.7322000',
                'city' => 'Union Hall',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22972',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1348000',
                'longitude' => '-78.1815000',
                'city' => 'Somerset',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22715',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3742000',
                'longitude' => '-78.2588000',
                'city' => 'Brightwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22709',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3742000',
                'longitude' => '-78.2588000',
                'city' => 'Aroda',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24092',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9938000',
                'longitude' => '-79.8927000',
                'city' => 'Glade Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24101',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2415000',
                'longitude' => '-79.9197000',
                'city' => 'Hardy',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22102',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4478000',
                'longitude' => '-78.8640000',
                'city' => 'Mc Lean',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22657',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9475000',
                'longitude' => '-78.4381000',
                'city' => 'Strasburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22660',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9475000',
                'longitude' => '-78.4381000',
                'city' => 'Toms Brook',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22644',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9475000',
                'longitude' => '-78.4381000',
                'city' => 'Maurertown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22654',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9475000',
                'longitude' => '-78.4381000',
                'city' => 'Star Tannery',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22742',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5384000',
                'longitude' => '-77.8065000',
                'city' => 'Sumerduck',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22734',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5384000',
                'longitude' => '-77.8065000',
                'city' => 'Remington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24301',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0499000',
                'longitude' => '-80.7859000',
                'city' => 'Pulaski',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22733',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1520000',
                'longitude' => '-79.0772000',
                'city' => 'Rapidan',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23024',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1358000',
                'longitude' => '-80.4064000',
                'city' => 'Bumpass',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20184',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9683000',
                'longitude' => '-77.7300000',
                'city' => 'Upperville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22924',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0372000',
                'longitude' => '-78.7611000',
                'city' => 'Batesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22641',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9919000',
                'longitude' => '-78.3644000',
                'city' => 'Strasburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24468',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4167000',
                'longitude' => '-79.5824000',
                'city' => 'Mustoe',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24465',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4167000',
                'longitude' => '-79.5824000',
                'city' => 'Monterey',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24090',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5020000',
                'longitude' => '-79.8748000',
                'city' => 'Fincastle',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24413',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4998000',
                'longitude' => '-79.5415000',
                'city' => 'Blue Grass',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22847',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7469000',
                'longitude' => '-78.6455000',
                'city' => 'Quicksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22844',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7469000',
                'longitude' => '-78.6455000',
                'city' => 'New Market',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22842',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7469000',
                'longitude' => '-78.6455000',
                'city' => 'Mount Jackson',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22553',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1986000',
                'longitude' => '-77.5843000',
                'city' => 'Spotsylvania',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22624',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1869000',
                'longitude' => '-78.1669000',
                'city' => 'Clear Brook',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22656',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1869000',
                'longitude' => '-78.1669000',
                'city' => 'Stephenson',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24083',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2680000',
                'longitude' => '-79.9395000',
                'city' => 'Daleville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22485',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3016000',
                'longitude' => '-77.4664000',
                'city' => 'King George',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '25401',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1869000',
                'longitude' => '-78.1669000',
                'city' => 'Martinsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22735',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4563000',
                'longitude' => '-78.1108000',
                'city' => 'Reva',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22948',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4563000',
                'longitude' => '-78.1108000',
                'city' => 'Locust Dale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22725',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4563000',
                'longitude' => '-78.1108000',
                'city' => 'Leon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24127',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3034000',
                'longitude' => '-80.4916000',
                'city' => 'New Castle',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22713',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4563000',
                'longitude' => '-78.1108000',
                'city' => 'Boston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22740',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4563000',
                'longitude' => '-78.1108000',
                'city' => 'Sperryville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20117',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1139000',
                'longitude' => '-77.8380000',
                'city' => 'Middleburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20135',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1139000',
                'longitude' => '-77.8380000',
                'city' => 'Bluemont',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24426',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7940000',
                'longitude' => '-80.2908000',
                'city' => 'Covington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24085',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5005000',
                'longitude' => '-79.9789000',
                'city' => 'Eagle Rock',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24130',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5005000',
                'longitude' => '-79.9789000',
                'city' => 'Oriskany',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22807',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4503000',
                'longitude' => '-78.8689000',
                'city' => 'Harrisonburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20176',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1078000',
                'longitude' => '-77.5644000',
                'city' => 'Leesburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22565',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1466000',
                'longitude' => '-77.6011000',
                'city' => 'Thornburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22534',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1466000',
                'longitude' => '-77.6011000',
                'city' => 'Partlow',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22580',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1466000',
                'longitude' => '-77.6011000',
                'city' => 'Woodford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24556',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3367000',
                'longitude' => '-79.5209000',
                'city' => 'Goode',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24174',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3367000',
                'longitude' => '-79.5209000',
                'city' => 'Thaxton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20130',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9949000',
                'longitude' => '-77.8851000',
                'city' => 'Paris',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24380',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7784000',
                'longitude' => '-80.4094000',
                'city' => 'Willis',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24091',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7784000',
                'longitude' => '-80.4094000',
                'city' => 'Floyd',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24150',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3266000',
                'longitude' => '-80.7320000',
                'city' => 'Ripplemead',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22610',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9253000',
                'longitude' => '-78.1947000',
                'city' => 'Bentonville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24086',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3196000',
                'longitude' => '-80.6423000',
                'city' => 'Eggleston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24136',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3196000',
                'longitude' => '-80.6423000',
                'city' => 'Pembroke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22640',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9253000',
                'longitude' => '-78.1947000',
                'city' => 'Huntly',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22623',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9253000',
                'longitude' => '-78.1947000',
                'city' => 'Chester Gap',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24132',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1340000',
                'longitude' => '-80.5768000',
                'city' => 'Parrott',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24062',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1340000',
                'longitude' => '-80.5768000',
                'city' => 'Blacksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22402',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3530000',
                'longitude' => '-77.0461000',
                'city' => 'Fredericksburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24079',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0363000',
                'longitude' => '-80.2125000',
                'city' => 'Copper Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24072',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0363000',
                'longitude' => '-80.2125000',
                'city' => 'Check',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22851',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4902000',
                'longitude' => '-78.6174000',
                'city' => 'Stanley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22942',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2480000',
                'longitude' => '-78.1134000',
                'city' => 'Gordonsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22738',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2480000',
                'longitude' => '-78.1134000',
                'city' => 'Rochelle',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20134',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1994000',
                'longitude' => '-77.7271000',
                'city' => 'Purcellville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20180',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1994000',
                'longitude' => '-77.7271000',
                'city' => 'Lovettsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22627',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7194000',
                'longitude' => '-78.1599000',
                'city' => 'Flint Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22732',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2480000',
                'longitude' => '-78.1134000',
                'city' => 'Radiant',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24126',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1081000',
                'longitude' => '-80.6862000',
                'city' => 'Newbern',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24460',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9990000',
                'longitude' => '-79.8351000',
                'city' => 'Millboro',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22567',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2507000',
                'longitude' => '-77.9625000',
                'city' => 'Unionville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24147',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3326000',
                'longitude' => '-80.8089000',
                'city' => 'Rich Creek',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24093',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3326000',
                'longitude' => '-80.8089000',
                'city' => 'Glen Lyn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22719',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3742000',
                'longitude' => '-78.2588000',
                'city' => 'Etlan',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22650',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6668000',
                'longitude' => '-78.4597000',
                'city' => 'Rileyville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22471',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4032000',
                'longitude' => '-77.5628000',
                'city' => 'Hartwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20139',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6339000',
                'longitude' => '-77.6737000',
                'city' => 'Casanova',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20138',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6339000',
                'longitude' => '-77.6737000',
                'city' => 'Calverton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24105',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8655000',
                'longitude' => '-80.5170000',
                'city' => 'Indian Valley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22821',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3839000',
                'longitude' => '-78.9739000',
                'city' => 'Dayton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24142',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1340000',
                'longitude' => '-80.5768000',
                'city' => 'Radford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22834',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5279000',
                'longitude' => '-78.8595000',
                'city' => 'Linville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22850',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5279000',
                'longitude' => '-78.8595000',
                'city' => 'Singers Glen',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22646',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0937000',
                'longitude' => '-78.0627000',
                'city' => 'Millwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22620',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0937000',
                'longitude' => '-78.0627000',
                'city' => 'Boyce',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22663',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0937000',
                'longitude' => '-78.0627000',
                'city' => 'White Post',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24412',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9990000',
                'longitude' => '-79.8351000',
                'city' => 'Bacova',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24445',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9990000',
                'longitude' => '-79.8351000',
                'city' => 'Hot Springs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22820',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7628000',
                'longitude' => '-78.9422000',
                'city' => 'Criders',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22830',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7628000',
                'longitude' => '-78.9422000',
                'city' => 'Fulks Run',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22811',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7628000',
                'longitude' => '-78.9422000',
                'city' => 'Bergton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22542',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2701000',
                'longitude' => '-77.9466000',
                'city' => 'Rhoadesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22433',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.2701000',
                'longitude' => '-77.9466000',
                'city' => 'Burr Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22810',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8065000',
                'longitude' => '-78.7711000',
                'city' => 'Basye',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22815',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8065000',
                'longitude' => '-78.7711000',
                'city' => 'Broadway',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22845',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8065000',
                'longitude' => '-78.7711000',
                'city' => 'Orkney Springs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22637',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.2128000',
                'longitude' => '-78.3012000',
                'city' => 'Gore',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24422',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8184000',
                'longitude' => '-79.8233000',
                'city' => 'Clifton Forge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24457',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8184000',
                'longitude' => '-79.8233000',
                'city' => 'Low Moor',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22655',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0867000',
                'longitude' => '-78.2183000',
                'city' => 'Stephens City',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22831',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4665000',
                'longitude' => '-78.9745000',
                'city' => 'Hinton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22645',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0829000',
                'longitude' => '-78.2216000',
                'city' => 'Middletown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23192',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9575000',
                'longitude' => '-77.7853000',
                'city' => 'Montpelier',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20197',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1895000',
                'longitude' => '-77.6140000',
                'city' => 'Waterford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20129',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1895000',
                'longitude' => '-77.6140000',
                'city' => 'Paeonian Springs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22625',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.3184000',
                'longitude' => '-78.2933000',
                'city' => 'Cross Junction',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24064',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2674000',
                'longitude' => '-79.7894000',
                'city' => 'Blue Ridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22853',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6132000',
                'longitude' => '-78.8014000',
                'city' => 'Timberville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24131',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5675000',
                'longitude' => '-80.2612000',
                'city' => 'Paint Bank',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24134',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3266000',
                'longitude' => '-80.7320000',
                'city' => 'Pearisburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24167',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3266000',
                'longitude' => '-80.7320000',
                'city' => 'Staffordsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22711',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4569000',
                'longitude' => '-78.3008000',
                'city' => 'Banco',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22722',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4569000',
                'longitude' => '-78.3008000',
                'city' => 'Haywood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22743',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.4569000',
                'longitude' => '-78.3008000',
                'city' => 'Syria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24059',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2248000',
                'longitude' => '-80.0151000',
                'city' => 'Bent Mountain',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22737',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6106000',
                'longitude' => '-77.9847000',
                'city' => 'Rixeyville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22724',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6106000',
                'longitude' => '-77.9847000',
                'city' => 'Jeffersonton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22716',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6106000',
                'longitude' => '-77.9847000',
                'city' => 'Castleton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24485',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1982000',
                'longitude' => '-79.4010000',
                'city' => 'West Augusta',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24432',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1982000',
                'longitude' => '-79.4010000',
                'city' => 'Deerfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22952',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0661000',
                'longitude' => '-78.8904000',
                'city' => 'Lyndhurst',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24178',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2674000',
                'longitude' => '-79.7894000',
                'city' => 'Villamont',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24122',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2674000',
                'longitude' => '-79.7894000',
                'city' => 'Montvale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22730',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3805000',
                'longitude' => '-78.2604000',
                'city' => 'Oakpark',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22721',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3805000',
                'longitude' => '-78.2604000',
                'city' => 'Graves Mill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22723',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3805000',
                'longitude' => '-78.2604000',
                'city' => 'Hood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22731',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3805000',
                'longitude' => '-78.2604000',
                'city' => 'Pratts',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22748',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.3805000',
                'longitude' => '-78.2604000',
                'city' => 'Wolftown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22611',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1517000',
                'longitude' => '-77.9835000',
                'city' => 'Berryville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24077',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4192000',
                'longitude' => '-79.8729000',
                'city' => 'Cloverdale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22749',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6561000',
                'longitude' => '-78.2286000',
                'city' => 'Woodville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24439',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0811000',
                'longitude' => '-79.3862000',
                'city' => 'Goshen',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24411',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0811000',
                'longitude' => '-79.3862000',
                'city' => 'Augusta Springs',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '24430',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0811000',
                'longitude' => '-79.3862000',
                'city' => 'Craigsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22027',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9003000',
                'longitude' => '-77.2684000',
                'city' => 'Dunn Loring',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22180',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9003000',
                'longitude' => '-77.2684000',
                'city' => 'Vienna',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20194',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9639000',
                'longitude' => '-77.3981000',
                'city' => 'Reston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20171',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9639000',
                'longitude' => '-77.3981000',
                'city' => 'Herndon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20170',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9639000',
                'longitude' => '-77.3981000',
                'city' => 'Herndon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20190',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9639000',
                'longitude' => '-77.3981000',
                'city' => 'Reston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22205',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22046',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Falls Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22213',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20110',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7515000',
                'longitude' => '-77.4783000',
                'city' => 'Manassas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22181',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Vienna',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20120',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Centreville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22211',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Fort Myer',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22214',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20164',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Sterling',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20169',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8114000',
                'longitude' => '-77.6324000',
                'city' => 'Haymarket',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22182',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9003000',
                'longitude' => '-77.2684000',
                'city' => 'Vienna',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22031',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8731000',
                'longitude' => '-77.2281000',
                'city' => 'Fairfax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20109',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7515000',
                'longitude' => '-77.4783000',
                'city' => 'Manassas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20111',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7515000',
                'longitude' => '-77.4783000',
                'city' => 'Manassas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22201',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22193',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6330000',
                'longitude' => '-77.3189000',
                'city' => 'Woodbridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22203',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22033',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Fairfax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20121',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8411000',
                'longitude' => '-77.4279000',
                'city' => 'Centreville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22209',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9010000',
                'longitude' => '-77.0315000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22152',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7206000',
                'longitude' => '-77.2130000',
                'city' => 'Springfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22153',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7206000',
                'longitude' => '-77.2130000',
                'city' => 'Springfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22043',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9275000',
                'longitude' => '-77.2156000',
                'city' => 'Falls Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20112',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6610000',
                'longitude' => '-77.4438000',
                'city' => 'Manassas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22172',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5520000',
                'longitude' => '-77.3332000',
                'city' => 'Triangle',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22314',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8214000',
                'longitude' => '-77.0593000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22003',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8214000',
                'longitude' => '-77.0593000',
                'city' => 'Annandale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22030',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8588000',
                'longitude' => '-77.3051000',
                'city' => 'Fairfax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22124',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8588000',
                'longitude' => '-77.3051000',
                'city' => 'Oakton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20166',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0273000',
                'longitude' => '-77.3921000',
                'city' => 'Sterling',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22066',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0273000',
                'longitude' => '-77.3921000',
                'city' => 'Great Falls',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20165',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0273000',
                'longitude' => '-77.3921000',
                'city' => 'Sterling',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22101',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9299000',
                'longitude' => '-77.1992000',
                'city' => 'Mc Lean',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22042',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8731000',
                'longitude' => '-77.2281000',
                'city' => 'Falls Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22304',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8119000',
                'longitude' => '-77.1036000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22312',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8119000',
                'longitude' => '-77.1036000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22150',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7820000',
                'longitude' => '-77.1515000',
                'city' => 'Springfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22315',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7820000',
                'longitude' => '-77.1515000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22032',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8588000',
                'longitude' => '-77.3051000',
                'city' => 'Fairfax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20740',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'College Park',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22191',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5482000',
                'longitude' => '-77.3365000',
                'city' => 'Woodbridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22134',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5482000',
                'longitude' => '-77.3365000',
                'city' => 'Quantico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20124',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8409000',
                'longitude' => '-77.4067000',
                'city' => 'Clifton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20151',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8409000',
                'longitude' => '-77.4067000',
                'city' => 'Chantilly',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20191',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8409000',
                'longitude' => '-77.4067000',
                'city' => 'Reston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22207',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8854000',
                'longitude' => '-77.0955000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22204',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8854000',
                'longitude' => '-77.0955000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22206',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8854000',
                'longitude' => '-77.0955000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22202',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8854000',
                'longitude' => '-77.0955000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22192',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6844000',
                'longitude' => '-77.2593000',
                'city' => 'Woodbridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22044',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9663000',
                'longitude' => '-77.3817000',
                'city' => 'Falls Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22039',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8178000',
                'longitude' => '-77.2700000',
                'city' => 'Fairfax Station',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22015',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8178000',
                'longitude' => '-77.2700000',
                'city' => 'Burke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20122',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Centreville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22151',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8202000',
                'longitude' => '-77.1606000',
                'city' => 'Springfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22041',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8202000',
                'longitude' => '-77.1606000',
                'city' => 'Falls Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20136',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7515000',
                'longitude' => '-77.4783000',
                'city' => 'Bristow',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20041',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9632000',
                'longitude' => '-77.4488000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20152',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9632000',
                'longitude' => '-77.4488000',
                'city' => 'Chantilly',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20105',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9632000',
                'longitude' => '-77.4488000',
                'city' => 'Aldie',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20852',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9003000',
                'longitude' => '-77.2684000',
                'city' => 'Rockville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22183',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.0273000',
                'longitude' => '-77.3921000',
                'city' => 'Vienna',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22301',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8119000',
                'longitude' => '-77.1036000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '21403',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9663000',
                'longitude' => '-77.3817000',
                'city' => 'Annapolis',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '21401',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9663000',
                'longitude' => '-77.3817000',
                'city' => 'Annapolis',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22302',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8854000',
                'longitude' => '-77.0955000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22079',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6844000',
                'longitude' => '-77.2593000',
                'city' => 'Lorton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22305',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8214000',
                'longitude' => '-77.0593000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22230',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8437000',
                'longitude' => '-77.1111000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22310',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7820000',
                'longitude' => '-77.1515000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22307',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20113',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Manassas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22311',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8202000',
                'longitude' => '-77.1606000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22303',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7977000',
                'longitude' => '-77.0876000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22035',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8409000',
                'longitude' => '-77.4067000',
                'city' => 'Fairfax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22331',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7977000',
                'longitude' => '-77.0876000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22306',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7977000',
                'longitude' => '-77.0876000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20182',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Nokesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22308',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22116',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Merrifield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22309',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7279000',
                'longitude' => '-77.0923000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22060',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7279000',
                'longitude' => '-77.0923000',
                'city' => 'Fort Belvoir',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22009',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Burke',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20155',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Gainesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20001',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8645000',
                'longitude' => '-77.0568000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22332',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7977000',
                'longitude' => '-77.0876000',
                'city' => 'Alexandria',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20147',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Ashburn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20195',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Reston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22194',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Woodbridge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22161',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8178000',
                'longitude' => '-77.2700000',
                'city' => 'Springfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22125',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6679000',
                'longitude' => '-77.2596000',
                'city' => 'Occoquan',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20177',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8816000',
                'longitude' => '-77.0989000',
                'city' => 'Leesburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20148',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9513000',
                'longitude' => '-77.5308000',
                'city' => 'Ashburn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20163',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9458000',
                'longitude' => '-77.0632000',
                'city' => 'Sterling',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20016',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20181',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.6990000',
                'longitude' => '-77.5670000',
                'city' => 'Nokesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22135',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.5237000',
                'longitude' => '-77.3012000',
                'city' => 'Quantico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20101',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9632000',
                'longitude' => '-77.4488000',
                'city' => 'Dulles',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22121',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.7279000',
                'longitude' => '-77.0923000',
                'city' => 'Mount Vernon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20301',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8709000',
                'longitude' => '-77.0583000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20350',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8709000',
                'longitude' => '-77.0583000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20050',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8709000',
                'longitude' => '-77.0583000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20330',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8709000',
                'longitude' => '-77.0583000',
                'city' => 'Washington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20172',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '39.1205000',
                'longitude' => '-77.5675000',
                'city' => 'Herndon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20143',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8139000',
                'longitude' => '-77.6372000',
                'city' => 'Catharpin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20108',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Manassas',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20904',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8926000',
                'longitude' => '-77.1607000',
                'city' => 'Silver Spring',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22227',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.8645000',
                'longitude' => '-77.0568000',
                'city' => 'Arlington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22038',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9663000',
                'longitude' => '-77.3817000',
                'city' => 'Fairfax',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23235',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9498000',
                'longitude' => '-77.3820000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '20146',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.9632000',
                'longitude' => '-77.4488000',
                'city' => 'Ashburn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23708',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Portsmouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23510',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23517',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8520000',
                'longitude' => '-76.2915000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23507',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8520000',
                'longitude' => '-76.2915000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23709',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8333000',
                'longitude' => '-76.3079000',
                'city' => 'Portsmouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23321',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6274000',
                'longitude' => '-76.2085000',
                'city' => 'Chesapeake',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23322',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6274000',
                'longitude' => '-76.2085000',
                'city' => 'Chesapeake',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23603',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2662000',
                'longitude' => '-76.7068000',
                'city' => 'Newport News',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23188',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2662000',
                'longitude' => '-76.7068000',
                'city' => 'Williamsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23452',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8246000',
                'longitude' => '-76.0638000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23320',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8246000',
                'longitude' => '-76.0638000',
                'city' => 'Chesapeake',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23502',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8246000',
                'longitude' => '-76.0638000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23323',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7153000',
                'longitude' => '-76.2363000',
                'city' => 'Chesapeake',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23454',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8246000',
                'longitude' => '-76.0638000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23460',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8246000',
                'longitude' => '-76.0638000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23519',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8520000',
                'longitude' => '-76.2915000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23461',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7588000',
                'longitude' => '-76.0656000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23185',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2662000',
                'longitude' => '-76.7068000',
                'city' => 'Williamsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23464',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23325',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Chesapeake',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23324',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Chesapeake',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23456',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23451',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23462',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23503',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23455',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23505',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23606',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Newport News',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23602',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Newport News',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23601',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Newport News',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23607',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Newport News',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23605',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Newport News',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23693',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Yorktown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23666',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23665',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23501',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23463',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23529',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23513',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8894000',
                'longitude' => '-76.2588000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23090',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1467000',
                'longitude' => '-76.3906000',
                'city' => 'Lightfoot',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23224',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9827000',
                'longitude' => '-76.4360000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23168',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1388000',
                'longitude' => '-76.5167000',
                'city' => 'Toano',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23604',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1388000',
                'longitude' => '-76.5167000',
                'city' => 'Fort Eustis',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23608',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1388000',
                'longitude' => '-76.5167000',
                'city' => 'Newport News',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23436',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9194000',
                'longitude' => '-76.5122000',
                'city' => 'Suffolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23314',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9194000',
                'longitude' => '-76.5122000',
                'city' => 'Carrollton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23433',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9194000',
                'longitude' => '-76.5122000',
                'city' => 'Suffolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23668',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9943000',
                'longitude' => '-76.4469000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23487',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8051000',
                'longitude' => '-76.7368000',
                'city' => 'Windsor',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23898',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8077000',
                'longitude' => '-76.7415000',
                'city' => 'Zuni',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23661',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9801000',
                'longitude' => '-76.4313000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23504',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23518',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23663',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0253000',
                'longitude' => '-76.3427000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23669',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0253000',
                'longitude' => '-76.3427000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23432',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8534000',
                'longitude' => '-76.5835000',
                'city' => 'Suffolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23430',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8534000',
                'longitude' => '-76.5835000',
                'city' => 'Smithfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23434',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8534000',
                'longitude' => '-76.5835000',
                'city' => 'Suffolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23453',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.7509000',
                'longitude' => '-76.0516000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23846',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0535000',
                'longitude' => '-76.9054000',
                'city' => 'Elberon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23839',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0535000',
                'longitude' => '-76.9054000',
                'city' => 'Dendron',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23435',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Suffolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23704',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8400000',
                'longitude' => '-76.3299000',
                'city' => 'Portsmouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23883',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1400000',
                'longitude' => '-76.8306000',
                'city' => 'Surry',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23690',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1388000',
                'longitude' => '-76.5167000',
                'city' => 'Yorktown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23692',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1388000',
                'longitude' => '-76.5167000',
                'city' => 'Yorktown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23881',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1362000',
                'longitude' => '-76.8338000',
                'city' => 'Spring Grove',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23457',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6274000',
                'longitude' => '-76.2085000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23417',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Onancock',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23480',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Wachapreague',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23418',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Onley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23301',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Accomac',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23421',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Parksley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23450',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9827000',
                'longitude' => '-76.4360000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23851',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6732000',
                'longitude' => '-76.9197000',
                'city' => 'Franklin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23511',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9156000',
                'longitude' => '-76.3058000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23520',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9156000',
                'longitude' => '-76.3058000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23509',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23310',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2688000',
                'longitude' => '-75.9805000',
                'city' => 'Cape Charles',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23429',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2688000',
                'longitude' => '-75.9805000',
                'city' => 'Seaview',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23419',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2688000',
                'longitude' => '-75.9805000',
                'city' => 'Oyster',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23313',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2688000',
                'longitude' => '-75.9805000',
                'city' => 'Capeville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23316',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2688000',
                'longitude' => '-75.9805000',
                'city' => 'Cheriton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23443',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2688000',
                'longitude' => '-75.9805000',
                'city' => 'Townsend',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23702',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8333000',
                'longitude' => '-76.3079000',
                'city' => 'Portsmouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23336',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9321000',
                'longitude' => '-75.3781000',
                'city' => 'Chincoteague Island',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23701',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8250000',
                'longitude' => '-76.2732000',
                'city' => 'Portsmouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23707',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8250000',
                'longitude' => '-76.2732000',
                'city' => 'Portsmouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23307',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3491000',
                'longitude' => '-75.9444000',
                'city' => 'Birdsnest',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23866',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9810000',
                'longitude' => '-76.6332000',
                'city' => 'Ivor',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23397',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9810000',
                'longitude' => '-76.6332000',
                'city' => 'Isle Of Wight',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23471',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8333000',
                'longitude' => '-76.3079000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23350',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Exmore',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23420',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Painter',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23413',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Nassawadox',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23306',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Belle Haven',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23423',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Quinby',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23398',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Jamesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23341',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Craddockville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23508',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9156000',
                'longitude' => '-76.3058000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23523',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8149000',
                'longitude' => '-76.2750000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23354',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Franktown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23389',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Harborton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23422',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5325000',
                'longitude' => '-75.8231000',
                'city' => 'Pungoteague',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23521',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8959000',
                'longitude' => '-76.1411000',
                'city' => 'Norfolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23187',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2662000',
                'longitude' => '-76.7068000',
                'city' => 'Williamsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23703',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8655000',
                'longitude' => '-76.4055000',
                'city' => 'Portsmouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23315',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6758000',
                'longitude' => '-76.9244000',
                'city' => 'Carrsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23878',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6758000',
                'longitude' => '-76.9244000',
                'city' => 'Sedley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23437',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.6758000',
                'longitude' => '-76.9244000',
                'city' => 'Suffolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23089',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3832000',
                'longitude' => '-76.8083000',
                'city' => 'Lanexa',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23011',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3832000',
                'longitude' => '-76.8083000',
                'city' => 'Barhamsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23696',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1467000',
                'longitude' => '-76.3906000',
                'city' => 'Seaford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23467',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Virginia Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23223',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.8483000',
                'longitude' => '-76.2948000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23874',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5852000',
                'longitude' => '-77.2025000',
                'city' => 'Newsoms',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23828',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5852000',
                'longitude' => '-77.2025000',
                'city' => 'Branchville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23357',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7850000',
                'longitude' => '-75.6543000',
                'city' => 'Greenbush',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23412',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7850000',
                'longitude' => '-75.6543000',
                'city' => 'Modest Town',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23414',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7850000',
                'longitude' => '-75.6543000',
                'city' => 'Nelsonia',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23308',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7850000',
                'longitude' => '-75.6543000',
                'city' => 'Bloxom',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23405',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3554000',
                'longitude' => '-75.9458000',
                'city' => 'Machipongo',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23347',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3554000',
                'longitude' => '-75.9458000',
                'city' => 'Eastville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23442',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8900000',
                'longitude' => '-75.5521000',
                'city' => 'Temperanceville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23651',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0253000',
                'longitude' => '-76.3427000',
                'city' => 'Fort Monroe',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23662',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1388000',
                'longitude' => '-76.5167000',
                'city' => 'Poquoson',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23441',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Tasley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23401',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Keller',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23410',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7077000',
                'longitude' => '-75.7366000',
                'city' => 'Melfa',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23426',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Sanford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23409',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Mears',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23415',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'New Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23427',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Saxis',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23356',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Greenbackville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23359',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Hallwood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23395',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Horntown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23303',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Atlantic',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23416',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Oak Hall',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23337',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Wallops Island',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23407',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Mappsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23483',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8836000',
                'longitude' => '-75.5508000',
                'city' => 'Wattsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23664',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0579000',
                'longitude' => '-76.3212000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23888',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9075000',
                'longitude' => '-76.8920000',
                'city' => 'Wakefield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23681',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0946000',
                'longitude' => '-76.3872000',
                'city' => 'Hampton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23899',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2256000',
                'longitude' => '-76.9661000',
                'city' => 'Claremont',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23072',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1388000',
                'longitude' => '-76.5167000',
                'city' => 'Hayes',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23440',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8279000',
                'longitude' => '-75.9913000',
                'city' => 'Tangier',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23438',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.5888000',
                'longitude' => '-76.6870000',
                'city' => 'Suffolk',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23232',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23298',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23222',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6436000',
                'longitude' => '-77.4376000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23228',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6436000',
                'longitude' => '-77.4376000',
                'city' => 'Henrico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23227',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23226',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23230',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23221',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23220',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23236',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4691000',
                'longitude' => '-77.5245000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23061',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4166000',
                'longitude' => '-76.5261000',
                'city' => 'Gloucester',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22443',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1843000',
                'longitude' => '-77.0021000',
                'city' => 'Colonial Beach',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22520',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1843000',
                'longitude' => '-77.0021000',
                'city' => 'Montross',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23219',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23234',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3578000',
                'longitude' => '-77.4312000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23150',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3578000',
                'longitude' => '-77.4312000',
                'city' => 'Sandston',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23294',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6383000',
                'longitude' => '-77.5613000',
                'city' => 'Henrico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23233',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6383000',
                'longitude' => '-77.5613000',
                'city' => 'Henrico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23060',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6383000',
                'longitude' => '-77.5613000',
                'city' => 'Glen Allen',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23229',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6383000',
                'longitude' => '-77.5613000',
                'city' => 'Henrico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23059',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6383000',
                'longitude' => '-77.5613000',
                'city' => 'Glen Allen',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23113',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Midlothian',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23231',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5161000',
                'longitude' => '-77.3862000',
                'city' => 'Henrico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23005',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8166000',
                'longitude' => '-77.4710000',
                'city' => 'Ashland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23047',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8166000',
                'longitude' => '-77.4710000',
                'city' => 'Doswell',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23249',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5085000',
                'longitude' => '-77.5257000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23836',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3578000',
                'longitude' => '-77.4312000',
                'city' => 'Chester',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23116',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6123000',
                'longitude' => '-77.3593000',
                'city' => 'Mechanicsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23112',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4994000',
                'longitude' => '-77.6523000',
                'city' => 'Midlothian',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23114',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4994000',
                'longitude' => '-77.6523000',
                'city' => 'Midlothian',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22560',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9220000',
                'longitude' => '-76.8572000',
                'city' => 'Tappahannock',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23111',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Mechanicsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23885',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1643000',
                'longitude' => '-77.6868000',
                'city' => 'Sutherland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23833',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1643000',
                'longitude' => '-77.6868000',
                'city' => 'Church Road',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23840',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1643000',
                'longitude' => '-77.6868000',
                'city' => 'Dewitt',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23850',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1643000',
                'longitude' => '-77.6868000',
                'city' => 'Ford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23894',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.1643000',
                'longitude' => '-77.6868000',
                'city' => 'Wilsons',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23237',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4407000',
                'longitude' => '-77.4719000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23832',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4407000',
                'longitude' => '-77.4719000',
                'city' => 'Chesterfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23261',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4407000',
                'longitude' => '-77.4719000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23218',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4691000',
                'longitude' => '-77.5245000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23149',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6079000',
                'longitude' => '-76.5903000',
                'city' => 'Saluda',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23173',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5898000',
                'longitude' => '-77.5329000',
                'city' => 'University Of Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22572',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9586000',
                'longitude' => '-76.7613000',
                'city' => 'Warsaw',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23075',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6239000',
                'longitude' => '-77.5036000',
                'city' => 'Henrico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22460',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9586000',
                'longitude' => '-76.7613000',
                'city' => 'Farnham',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22472',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9586000',
                'longitude' => '-76.7613000',
                'city' => 'Haynesville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23139',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Powhatan',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23146',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Rockville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23069',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Hanover',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23831',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Chester',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23269',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5563000',
                'longitude' => '-77.4707000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23027',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6555000',
                'longitude' => '-78.0990000',
                'city' => 'Cartersville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23109',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4330000',
                'longitude' => '-76.3145000',
                'city' => 'Mathews',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22548',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8897000',
                'longitude' => '-76.6661000',
                'city' => 'Sharps',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23141',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Quinton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23014',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5417000',
                'longitude' => '-77.9165000',
                'city' => 'Beaumont',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23160',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5417000',
                'longitude' => '-77.9165000',
                'city' => 'State Farm',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23801',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Fort Lee',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23050',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4166000',
                'longitude' => '-76.5261000',
                'city' => 'Dutton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23128',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4166000',
                'longitude' => '-76.5261000',
                'city' => 'North',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23860',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3080000',
                'longitude' => '-77.2783000',
                'city' => 'Hopewell',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23838',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3578000',
                'longitude' => '-77.4312000',
                'city' => 'Chesterfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22578',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7094000',
                'longitude' => '-76.3807000',
                'city' => 'White Stone',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22576',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7094000',
                'longitude' => '-76.3807000',
                'city' => 'Weems',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22503',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7094000',
                'longitude' => '-76.3807000',
                'city' => 'Lancaster',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22473',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7094000',
                'longitude' => '-76.3807000',
                'city' => 'Heathsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22482',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7094000',
                'longitude' => '-76.3807000',
                'city' => 'Kilmarnock',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22480',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6821000',
                'longitude' => '-76.4119000',
                'city' => 'Irvington',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22504',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9284000',
                'longitude' => '-76.8587000',
                'city' => 'Laneview',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22476',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9284000',
                'longitude' => '-76.8587000',
                'city' => 'Hustle',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22436',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9284000',
                'longitude' => '-76.8587000',
                'city' => 'Caret',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22454',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9284000',
                'longitude' => '-76.8587000',
                'city' => 'Dunnsville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22437',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9284000',
                'longitude' => '-76.8587000',
                'city' => 'Center Cross',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22438',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9284000',
                'longitude' => '-76.8587000',
                'city' => 'Champlain',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22501',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0154000',
                'longitude' => '-77.5525000',
                'city' => 'Ladysmith',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22546',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0154000',
                'longitude' => '-77.5525000',
                'city' => 'Ruther Glen',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23875',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3068000',
                'longitude' => '-77.2863000',
                'city' => 'Prince George',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22432',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8492000',
                'longitude' => '-76.2706000',
                'city' => 'Burgess',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22539',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.8492000',
                'longitude' => '-76.2706000',
                'city' => 'Reedville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23065',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7354000',
                'longitude' => '-78.0522000',
                'city' => 'Gum Spring',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23063',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7354000',
                'longitude' => '-78.0522000',
                'city' => 'Goochland',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23067',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7354000',
                'longitude' => '-78.0522000',
                'city' => 'Hadensville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23153',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7354000',
                'longitude' => '-78.0522000',
                'city' => 'Sandy Hook',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23842',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3068000',
                'longitude' => '-77.2863000',
                'city' => 'Disputanta',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22507',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7765000',
                'longitude' => '-76.5123000',
                'city' => 'Lively',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23841',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.0809000',
                'longitude' => '-77.5838000',
                'city' => 'Dinwiddie',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22524',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0723000',
                'longitude' => '-76.6537000',
                'city' => 'Mount Holly',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22442',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0723000',
                'longitude' => '-76.6537000',
                'city' => 'Coles Point',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22488',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0723000',
                'longitude' => '-76.6537000',
                'city' => 'Kinsale',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22469',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0723000',
                'longitude' => '-76.6537000',
                'city' => 'Hague',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23872',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '36.9815000',
                'longitude' => '-77.7165000',
                'city' => 'Mc Kenney',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23834',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2623000',
                'longitude' => '-77.4082000',
                'city' => 'Colonial Heights',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23009',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Aylett',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23255',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Henrico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22511',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9704000',
                'longitude' => '-76.5593000',
                'city' => 'Lottsburg',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22435',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9704000',
                'longitude' => '-76.5593000',
                'city' => 'Callao',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23102',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6787000',
                'longitude' => '-77.8837000',
                'city' => 'Maidens',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23030',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4384000',
                'longitude' => '-77.0397000',
                'city' => 'Charles City',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23002',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3412000',
                'longitude' => '-77.9749000',
                'city' => 'Amelia Court House',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23083',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3412000',
                'longitude' => '-77.9749000',
                'city' => 'Jetersville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23103',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6013000',
                'longitude' => '-77.6980000',
                'city' => 'Manakin Sabot',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22579',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.9004000',
                'longitude' => '-76.4237000',
                'city' => 'Wicomico Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23120',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3980000',
                'longitude' => '-77.6899000',
                'city' => 'Moseley',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22514',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0490000',
                'longitude' => '-77.3470000',
                'city' => 'Milford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22427',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.0527000',
                'longitude' => '-77.3437000',
                'city' => 'Bowling Green',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23131',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2665000',
                'longitude' => '-76.4961000',
                'city' => 'Ordinary',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23001',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2665000',
                'longitude' => '-76.4961000',
                'city' => 'Achilles',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23062',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2665000',
                'longitude' => '-76.4961000',
                'city' => 'Gloucester Point',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23184',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2665000',
                'longitude' => '-76.4961000',
                'city' => 'Wicomico',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23018',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.2665000',
                'longitude' => '-76.4961000',
                'city' => 'Bena',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23183',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4129000',
                'longitude' => '-76.5294000',
                'city' => 'White Marsh',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23178',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4129000',
                'longitude' => '-76.5294000',
                'city' => 'Ware Neck',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23119',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Moon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23064',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Grimstead',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23125',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'New Point',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23025',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Cardinal',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23076',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Hudgins',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23021',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Bohannon',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23068',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Hallieford',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23138',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Port Haywood',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23066',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Gwynn',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23035',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Cobbs Creek',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23056',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Foster',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23163',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.4319000',
                'longitude' => '-76.3225000',
                'city' => 'Susan',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22538',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1703000',
                'longitude' => '-77.1916000',
                'city' => 'Rappahannock Academy',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '22535',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '38.1703000',
                'longitude' => '-77.1916000',
                'city' => 'Port Royal',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23129',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7231000',
                'longitude' => '-77.6778000',
                'city' => 'Oilville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23175',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6012000',
                'longitude' => '-76.5680000',
                'city' => 'Urbanna',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23169',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6012000',
                'longitude' => '-76.5680000',
                'city' => 'Topping',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23092',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6012000',
                'longitude' => '-76.5680000',
                'city' => 'Locust Hill',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23180',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6012000',
                'longitude' => '-76.5680000',
                'city' => 'Water View',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23079',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6012000',
                'longitude' => '-76.5680000',
                'city' => 'Jamaica',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23032',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6012000',
                'longitude' => '-76.5680000',
                'city' => 'Church View',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23181',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7391000',
                'longitude' => '-77.1230000',
                'city' => 'West Point',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23086',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7391000',
                'longitude' => '-77.1230000',
                'city' => 'King William',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23126',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7391000',
                'longitude' => '-77.1230000',
                'city' => 'Newtown',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23148',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7391000',
                'longitude' => '-77.1230000',
                'city' => 'Saint Stephens Church',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23177',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7391000',
                'longitude' => '-77.1230000',
                'city' => 'Walkerton',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23106',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.7391000',
                'longitude' => '-77.1230000',
                'city' => 'Manquin',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23240',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23176',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5502000',
                'longitude' => '-76.3449000',
                'city' => 'Wake',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23070',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5502000',
                'longitude' => '-76.3449000',
                'city' => 'Hardyville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23043',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5502000',
                'longitude' => '-76.3449000',
                'city' => 'Deltaville',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23071',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5502000',
                'longitude' => '-76.3449000',
                'city' => 'Hartfield',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23124',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6392000',
                'longitude' => '-77.2659000',
                'city' => 'New Kent',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23039',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.6027000',
                'longitude' => '-77.7108000',
                'city' => 'Crozier',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23110',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5395000',
                'longitude' => '-76.7490000',
                'city' => 'Mattaponi',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23108',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5395000',
                'longitude' => '-76.7490000',
                'city' => 'Mascot',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23156',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5395000',
                'longitude' => '-76.7490000',
                'city' => 'Shacklefords',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23085',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5395000',
                'longitude' => '-76.7490000',
                'city' => 'King And Queen Court House',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23091',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5395000',
                'longitude' => '-76.7490000',
                'city' => 'Little Plymouth',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23284',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.5420000',
                'longitude' => '-77.4340000',
                'city' => 'Richmond',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23140',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3411000',
                'longitude' => '-77.0748000',
                'city' => 'Providence Forge',
                'full_state' => 'Virginia',
            ],
            [
                'zip' => '23147',
                'country_code' => 'US',
                'state' => 'VA',
                'latitude' => '37.3411000',
                'longitude' => '-77.0748000',
                'city' => 'Ruthville',
                'full_state' => 'Virginia',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
