<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class VermontSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '5820',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7308000',
                'longitude' => '-72.3805000',
                'city' => 'Albany',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5250',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.0736000',
                'longitude' => '-73.1572000',
                'city' => 'Arlington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5821',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2961000',
                'longitude' => '-72.0551000',
                'city' => 'Barnet',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5641',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1988000',
                'longitude' => '-72.5004000',
                'city' => 'Barre',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5875',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7502000',
                'longitude' => '-72.1768000',
                'city' => 'West Glover',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5101',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1333000',
                'longitude' => '-72.4465000',
                'city' => 'Bellows Falls',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5201',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.8821000',
                'longitude' => '-73.1962000',
                'city' => 'Bennington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5858',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7574000',
                'longitude' => '-71.6319000',
                'city' => 'North Concord',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5345',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.9958000',
                'longitude' => '-72.6526000',
                'city' => 'Newfane',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5033',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9932000',
                'longitude' => '-72.1281000',
                'city' => 'Bradford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5682',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Worcester',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5602',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Montpelier',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5648',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Calais',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5651',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'East Montpelier',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5660',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Moretown',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5153',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3856000',
                'longitude' => '-72.6345000',
                'city' => 'Proctorsville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5142',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3856000',
                'longitude' => '-72.6345000',
                'city' => 'Cavendish',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5149',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3856000',
                'longitude' => '-72.6345000',
                'city' => 'Ludlow',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5828',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4124000',
                'longitude' => '-72.1362000',
                'city' => 'Danville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5089',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4812000',
                'longitude' => '-72.3842000',
                'city' => 'Windsor',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5255',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.2539000',
                'longitude' => '-73.0979000',
                'city' => 'Manchester Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5253',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.2539000',
                'longitude' => '-73.0979000',
                'city' => 'East Dorset',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5650',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3657000',
                'longitude' => '-72.4351000',
                'city' => 'East Calais',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5403',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4769000',
                'longitude' => '-73.2066000',
                'city' => 'South Burlington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5495',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4769000',
                'longitude' => '-73.2066000',
                'city' => 'Williston',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5032',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8320000',
                'longitude' => '-72.6334000',
                'city' => 'Bethel',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5068',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8320000',
                'longitude' => '-72.6334000',
                'city' => 'South Royalton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5746',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8320000',
                'longitude' => '-72.6334000',
                'city' => 'Gaysville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5031',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8320000',
                'longitude' => '-72.6334000',
                'city' => 'Barnard',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5772',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8320000',
                'longitude' => '-72.6334000',
                'city' => 'Stockbridge',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5777',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4852000',
                'longitude' => '-73.1187000',
                'city' => 'West Rutland',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5773',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4852000',
                'longitude' => '-73.1187000',
                'city' => 'Wallingford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5757',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4852000',
                'longitude' => '-73.1187000',
                'city' => 'Middletown Springs',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5701',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6080000',
                'longitude' => '-72.9768000',
                'city' => 'Rutland',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '3062',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6080000',
                'longitude' => '-72.9768000',
                'city' => 'Nashua',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5446',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4769000',
                'longitude' => '-73.2066000',
                'city' => 'Colchester',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5055',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'Norwich',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5052',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'North Hartland',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5671',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3423000',
                'longitude' => '-72.7556000',
                'city' => 'Waterbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5676',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3423000',
                'longitude' => '-72.7556000',
                'city' => 'Waterbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5454',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6652000',
                'longitude' => '-73.0130000',
                'city' => 'Fairfax',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5051',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0826000',
                'longitude' => '-72.0598000',
                'city' => 'Newbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5677',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3423000',
                'longitude' => '-72.7556000',
                'city' => 'Waterbury Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5062',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4549000',
                'longitude' => '-72.5421000',
                'city' => 'Reading',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5301',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.8552000',
                'longitude' => '-72.5587000',
                'city' => 'Brattleboro',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5733',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8023000',
                'longitude' => '-73.0858000',
                'city' => 'Brandon',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5745',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8023000',
                'longitude' => '-73.0858000',
                'city' => 'Forest Dale',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5769',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8023000',
                'longitude' => '-73.0858000',
                'city' => 'Salisbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5871',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1988000',
                'longitude' => '-72.5004000',
                'city' => 'West Burke',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5354',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.8552000',
                'longitude' => '-72.5587000',
                'city' => 'Vernon',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5672',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4666000',
                'longitude' => '-72.6879000',
                'city' => 'Stowe',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5344',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.8552000',
                'longitude' => '-72.5587000',
                'city' => 'Marlboro',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5476',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9944000',
                'longitude' => '-72.6743000',
                'city' => 'Richford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5742',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4484000',
                'longitude' => '-72.8785000',
                'city' => 'East Wallingford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5730',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4484000',
                'longitude' => '-72.8785000',
                'city' => 'Belmont',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5758',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4484000',
                'longitude' => '-72.8785000',
                'city' => 'Mount Holly',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5151',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3763000',
                'longitude' => '-72.5162000',
                'city' => 'Perkinsville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5143',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3763000',
                'longitude' => '-72.5162000',
                'city' => 'Chester',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5156',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3763000',
                'longitude' => '-72.5162000',
                'city' => 'Springfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5401',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4769000',
                'longitude' => '-73.2066000',
                'city' => 'Burlington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5482',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4769000',
                'longitude' => '-73.2066000',
                'city' => 'Shelburne',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5735',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5915000',
                'longitude' => '-73.2674000',
                'city' => 'Castleton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5750',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5915000',
                'longitude' => '-73.2674000',
                'city' => 'Hydeville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5764',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5915000',
                'longitude' => '-73.2674000',
                'city' => 'Poultney',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5732',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5915000',
                'longitude' => '-73.2674000',
                'city' => 'Bomoseen',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5743',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5915000',
                'longitude' => '-73.2674000',
                'city' => 'Fair Haven',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5902',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9882000',
                'longitude' => '-71.5437000',
                'city' => 'Beecher Falls',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5903',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9882000',
                'longitude' => '-71.5437000',
                'city' => 'Canaan',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5765',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6643000',
                'longitude' => '-73.0358000',
                'city' => 'Proctor',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5649',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1988000',
                'longitude' => '-72.5004000',
                'city' => 'East Barre',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5647',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1988000',
                'longitude' => '-72.5004000',
                'city' => 'Cabot',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5760',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.7089000',
                'longitude' => '-73.1878000',
                'city' => 'Orwell',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5819',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4180000',
                'longitude' => '-72.0229000',
                'city' => 'Saint Johnsbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5041',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0387000',
                'longitude' => '-72.5981000',
                'city' => 'East Randolph',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5036',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0387000',
                'longitude' => '-72.5981000',
                'city' => 'Brookfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5666',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'North Montpelier',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5047',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'Hartford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5059',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'Quechee',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5088',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'Wilder',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5001',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'White River Junction',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5048',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'Hartland',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5824',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4314000',
                'longitude' => '-71.8923000',
                'city' => 'Concord',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5483',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9775000',
                'longitude' => '-72.9161000',
                'city' => 'Sheldon',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5459',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9775000',
                'longitude' => '-72.9161000',
                'city' => 'Highgate Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5457',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9775000',
                'longitude' => '-72.9161000',
                'city' => 'Franklin',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5741',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5202000',
                'longitude' => '-73.2327000',
                'city' => 'East Poultney',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5494',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4948000',
                'longitude' => '-73.1135000',
                'city' => 'Westford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5452',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4948000',
                'longitude' => '-73.1135000',
                'city' => 'Essex Junction',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5739',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3472000',
                'longitude' => '-72.9967000',
                'city' => 'Danby',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5774',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4161000',
                'longitude' => '-73.2016000',
                'city' => 'Wells',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5084',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6481000',
                'longitude' => '-72.3200000',
                'city' => 'West Hartford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5343',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1374000',
                'longitude' => '-72.8814000',
                'city' => 'Jamaica',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5340',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1374000',
                'longitude' => '-72.8814000',
                'city' => 'Bondville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5155',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1374000',
                'longitude' => '-72.8814000',
                'city' => 'South Londonderry',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5360',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1374000',
                'longitude' => '-72.8814000',
                'city' => 'West Wardsboro',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5061',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0387000',
                'longitude' => '-72.5981000',
                'city' => 'Randolph Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5470',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4314000',
                'longitude' => '-71.8923000',
                'city' => 'Montgomery',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5478',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8144000',
                'longitude' => '-73.0833000',
                'city' => 'Saint Albans',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5829',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9572000',
                'longitude' => '-72.1291000',
                'city' => 'Derby',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5830',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9976000',
                'longitude' => '-72.1074000',
                'city' => 'Derby Line',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5363',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.8663000',
                'longitude' => '-72.8725000',
                'city' => 'Wilmington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5667',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2785000',
                'longitude' => '-72.4353000',
                'city' => 'Plainfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5855',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9381000',
                'longitude' => '-72.2092000',
                'city' => 'Newport',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5251',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3476000',
                'longitude' => '-73.1720000',
                'city' => 'Dorset',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5761',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3476000',
                'longitude' => '-73.1720000',
                'city' => 'Pawlet',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5768',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3476000',
                'longitude' => '-73.1720000',
                'city' => 'Rupert',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5471',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8769000',
                'longitude' => '-72.6099000',
                'city' => 'Montgomery Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5859',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9967000',
                'longitude' => '-72.4070000',
                'city' => 'North Troy',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5840',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4913000',
                'longitude' => '-71.5673000',
                'city' => 'Granby',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5906',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4913000',
                'longitude' => '-71.5673000',
                'city' => 'Lunenburg',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5905',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4913000',
                'longitude' => '-71.5673000',
                'city' => 'Guildhall',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5477',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4049000',
                'longitude' => '-72.9935000',
                'city' => 'Richmond',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5067',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6282000',
                'longitude' => '-72.5199000',
                'city' => 'South Pomfret',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5073',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6282000',
                'longitude' => '-72.5199000',
                'city' => 'Taftsville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5058',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'Post Mills',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5075',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'Thetford Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5079',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'Vershire',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5054',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'North Thetford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5074',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'Thetford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5043',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'East Thetford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5045',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'Fairlee',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5083',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9074000',
                'longitude' => '-72.1515000',
                'city' => 'West Fairlee',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5857',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9345000',
                'longitude' => '-72.2133000',
                'city' => 'Newport Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5825',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9345000',
                'longitude' => '-72.2133000',
                'city' => 'Coventry',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5473',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6452000',
                'longitude' => '-72.8308000',
                'city' => 'North Ferrisburgh',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5404',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4912000',
                'longitude' => '-73.1907000',
                'city' => 'Winooski',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5450',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9057000',
                'longitude' => '-72.8079000',
                'city' => 'Enosburg Falls',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5341',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.9895000',
                'longitude' => '-72.6516000',
                'city' => 'East Dover',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5362',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.9895000',
                'longitude' => '-72.6516000',
                'city' => 'Williamsville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5351',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.9895000',
                'longitude' => '-72.6516000',
                'city' => 'South Newfane',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5753',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0124000',
                'longitude' => '-73.1617000',
                'city' => 'Middlebury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5254',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1770000',
                'longitude' => '-73.0536000',
                'city' => 'Manchester',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5353',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.9895000',
                'longitude' => '-72.6516000',
                'city' => 'Townshend',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5358',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.7965000',
                'longitude' => '-72.8209000',
                'city' => 'West Halifax',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5342',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.7965000',
                'longitude' => '-72.8209000',
                'city' => 'Jacksonville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5361',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.7965000',
                'longitude' => '-72.8209000',
                'city' => 'Whitingham',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5458',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7045000',
                'longitude' => '-73.3043000',
                'city' => 'Grand Isle',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5474',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7045000',
                'longitude' => '-73.3043000',
                'city' => 'North Hero',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5486',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7045000',
                'longitude' => '-73.3043000',
                'city' => 'South Hero',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5262',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.0736000',
                'longitude' => '-73.1572000',
                'city' => 'Shaftsbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5252',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.0736000',
                'longitude' => '-73.1572000',
                'city' => 'East Arlington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5154',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1333000',
                'longitude' => '-72.4465000',
                'city' => 'Saxtons River',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5158',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1333000',
                'longitude' => '-72.4465000',
                'city' => 'Westminster',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5472',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0124000',
                'longitude' => '-73.1617000',
                'city' => 'New Haven',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5740',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0124000',
                'longitude' => '-73.1617000',
                'city' => 'East Middlebury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5766',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0124000',
                'longitude' => '-73.1617000',
                'city' => 'Ripton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5872',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8152000',
                'longitude' => '-71.8784000',
                'city' => 'West Charleston',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5346',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.9747000',
                'longitude' => '-72.5242000',
                'city' => 'Putney',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5776',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.2617000',
                'longitude' => '-73.2249000',
                'city' => 'West Rupert',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5038',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9896000',
                'longitude' => '-72.4497000',
                'city' => 'Chelsea',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5441',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7848000',
                'longitude' => '-72.8623000',
                'city' => 'Bakersfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5751',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6671000',
                'longitude' => '-72.7833000',
                'city' => 'Killington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5350',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.7691000',
                'longitude' => '-72.9455000',
                'city' => 'Readsboro',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5469',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3074000',
                'longitude' => '-73.2561000',
                'city' => 'Monkton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5445',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3074000',
                'longitude' => '-73.2561000',
                'city' => 'Charlotte',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5456',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3074000',
                'longitude' => '-73.2561000',
                'city' => 'Ferrisburgh',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5862',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3532000',
                'longitude' => '-72.3510000',
                'city' => 'Peacham',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5658',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3532000',
                'longitude' => '-72.3510000',
                'city' => 'Marshfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5851',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5357000',
                'longitude' => '-72.0036000',
                'city' => 'Lyndonville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5081',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0939000',
                'longitude' => '-72.1205000',
                'city' => 'Wells River',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5069',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0939000',
                'longitude' => '-72.1205000',
                'city' => 'South Ryegate',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5085',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0939000',
                'longitude' => '-72.1205000',
                'city' => 'West Newbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5060',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9234000',
                'longitude' => '-72.6615000',
                'city' => 'Randolph',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5679',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1241000',
                'longitude' => '-72.5434000',
                'city' => 'Williamstown',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5462',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4049000',
                'longitude' => '-72.9935000',
                'city' => 'Huntington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5487',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4049000',
                'longitude' => '-72.9935000',
                'city' => 'Starksboro',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5465',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4049000',
                'longitude' => '-72.9935000',
                'city' => 'Jericho',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5466',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4049000',
                'longitude' => '-72.9935000',
                'city' => 'Jonesville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5907',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '45.0049000',
                'longitude' => '-71.7995000',
                'city' => 'Norton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5049',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5520000',
                'longitude' => '-72.4268000',
                'city' => 'Hartland Four Corners',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5091',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5520000',
                'longitude' => '-72.4268000',
                'city' => 'Woodstock',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5759',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5981000',
                'longitude' => '-73.0519000',
                'city' => 'North Clarendon',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5086',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0598000',
                'longitude' => '-72.2244000',
                'city' => 'West Topsham',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5040',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0598000',
                'longitude' => '-72.2244000',
                'city' => 'East Corinth',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5076',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0598000',
                'longitude' => '-72.2244000',
                'city' => 'Topsham',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5039',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0598000',
                'longitude' => '-72.2244000',
                'city' => 'Corinth',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5257',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.8821000',
                'longitude' => '-73.1962000',
                'city' => 'North Bennington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5681',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5064000',
                'longitude' => '-72.3745000',
                'city' => 'Woodbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5826',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5064000',
                'longitude' => '-72.3745000',
                'city' => 'Craftsbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5443',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1333000',
                'longitude' => '-73.0772000',
                'city' => 'Bristol',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5663',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1241000',
                'longitude' => '-72.5434000',
                'city' => 'Northfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5053',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6190000',
                'longitude' => '-72.5139000',
                'city' => 'North Pomfret',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5071',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6190000',
                'longitude' => '-72.5139000',
                'city' => 'South Woodstock',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5763',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.6607000',
                'longitude' => '-73.0397000',
                'city' => 'Pittsford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5778',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9630000',
                'longitude' => '-73.2079000',
                'city' => 'Whiting',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5356',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.8663000',
                'longitude' => '-72.8725000',
                'city' => 'West Dover',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5488',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9177000',
                'longitude' => '-73.1233000',
                'city' => 'Swanton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5867',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6435000',
                'longitude' => '-71.9873000',
                'city' => 'Sutton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5837',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6435000',
                'longitude' => '-71.9873000',
                'city' => 'East Haven',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5832',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6435000',
                'longitude' => '-71.9873000',
                'city' => 'East Burke',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5843',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5064000',
                'longitude' => '-72.3745000',
                'city' => 'Hardwick',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5873',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5064000',
                'longitude' => '-72.3745000',
                'city' => 'West Danville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5836',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5064000',
                'longitude' => '-72.3745000',
                'city' => 'East Hardwick',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5680',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5064000',
                'longitude' => '-72.3745000',
                'city' => 'Wolcott',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5491',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1491000',
                'longitude' => '-73.3349000',
                'city' => 'Vergennes',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5654',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1988000',
                'longitude' => '-72.5004000',
                'city' => 'Graniteville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5670',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1988000',
                'longitude' => '-72.5004000',
                'city' => 'South Barre',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5461',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.3301000',
                'longitude' => '-73.1092000',
                'city' => 'Hinesburg',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5737',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.7069000',
                'longitude' => '-73.0293000',
                'city' => 'Chittenden',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5744',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.7069000',
                'longitude' => '-73.0293000',
                'city' => 'Florence',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5037',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4549000',
                'longitude' => '-72.5421000',
                'city' => 'Brownsville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5669',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1498000',
                'longitude' => '-72.6612000',
                'city' => 'Roxbury',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5664',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1498000',
                'longitude' => '-72.6612000',
                'city' => 'Northfield Falls',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5738',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4966000',
                'longitude' => '-72.8819000',
                'city' => 'Cuttingsville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5866',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5764000',
                'longitude' => '-72.2930000',
                'city' => 'Sheffield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5827',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5764000',
                'longitude' => '-72.2930000',
                'city' => 'Craftsbury Common',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5674',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1942000',
                'longitude' => '-72.8231000',
                'city' => 'Warren',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5673',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.1942000',
                'longitude' => '-72.8231000',
                'city' => 'Waitsfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5904',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4886000',
                'longitude' => '-71.6035000',
                'city' => 'Gilman',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5468',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8116000',
                'longitude' => '-73.0782000',
                'city' => 'Milton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5455',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8116000',
                'longitude' => '-73.0782000',
                'city' => 'Fairfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5839',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7495000',
                'longitude' => '-72.1858000',
                'city' => 'Glover',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5860',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7495000',
                'longitude' => '-72.1858000',
                'city' => 'Orleans',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5822',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7495000',
                'longitude' => '-72.1858000',
                'city' => 'Barton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5842',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5764000',
                'longitude' => '-72.2930000',
                'city' => 'Greensboro Bend',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5841',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5764000',
                'longitude' => '-72.2930000',
                'city' => 'Greensboro',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5731',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.7075000',
                'longitude' => '-73.3097000',
                'city' => 'Benson',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5734',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.0770000',
                'longitude' => '-73.2362000',
                'city' => 'Bridport',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5148',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1884000',
                'longitude' => '-72.8180000',
                'city' => 'Londonderry',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5042',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2081000',
                'longitude' => '-72.1877000',
                'city' => 'East Ryegate',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5046',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2081000',
                'longitude' => '-72.1877000',
                'city' => 'Groton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5442',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6347000',
                'longitude' => '-72.6869000',
                'city' => 'Belvidere Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5661',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6347000',
                'longitude' => '-72.6869000',
                'city' => 'Morrisville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5833',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9146000',
                'longitude' => '-72.0123000',
                'city' => 'East Charleston',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5850',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5357000',
                'longitude' => '-72.0036000',
                'city' => 'Lyndon Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5849',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5357000',
                'longitude' => '-72.0036000',
                'city' => 'Lyndon',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5762',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.7740000',
                'longitude' => '-72.8187000',
                'city' => 'Pittsfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5355',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.0452000',
                'longitude' => '-72.7902000',
                'city' => 'Wardsboro',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5050',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2961000',
                'longitude' => '-72.0551000',
                'city' => 'Mc Indoe Falls',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5652',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6347000',
                'longitude' => '-72.6869000',
                'city' => 'Eden',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5653',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6347000',
                'longitude' => '-72.6869000',
                'city' => 'Eden Mills',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5655',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6347000',
                'longitude' => '-72.6869000',
                'city' => 'Hyde Park',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5665',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6347000',
                'longitude' => '-72.6869000',
                'city' => 'North Hyde Park',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5656',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6347000',
                'longitude' => '-72.6869000',
                'city' => 'Johnson',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5444',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6452000',
                'longitude' => '-72.8308000',
                'city' => 'Cambridge',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5492',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6452000',
                'longitude' => '-72.8308000',
                'city' => 'Waterville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5464',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.6452000',
                'longitude' => '-72.8308000',
                'city' => 'Jeffersonville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5775',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5202000',
                'longitude' => '-73.2327000',
                'city' => 'West Pawlet',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5405',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4769000',
                'longitude' => '-73.2066000',
                'city' => 'Burlington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5034',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5905000',
                'longitude' => '-72.6582000',
                'city' => 'Bridgewater',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5035',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5905000',
                'longitude' => '-72.6582000',
                'city' => 'Bridgewater Corners',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5056',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.5905000',
                'longitude' => '-72.6582000',
                'city' => 'Plymouth',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5030',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.4840000',
                'longitude' => '-72.3892000',
                'city' => 'Ascutney',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5077',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9896000',
                'longitude' => '-72.4497000',
                'city' => 'Tunbridge',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5675',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9896000',
                'longitude' => '-72.4497000',
                'city' => 'Washington',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5352',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.6956000',
                'longitude' => '-73.1112000',
                'city' => 'Stamford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5261',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.7679000',
                'longitude' => '-73.2392000',
                'city' => 'Pownal',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5868',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9031000',
                'longitude' => '-72.4066000',
                'city' => 'Troy',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5159',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.0802000',
                'longitude' => '-72.4247000',
                'city' => 'Westminster Station',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5853',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8116000',
                'longitude' => '-71.8825000',
                'city' => 'Morgan',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5846',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8116000',
                'longitude' => '-71.8825000',
                'city' => 'Island Pond',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5847',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9066000',
                'longitude' => '-72.4026000',
                'city' => 'Lowell',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5874',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9066000',
                'longitude' => '-72.4026000',
                'city' => 'Westfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5845',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8091000',
                'longitude' => '-72.2085000',
                'city' => 'Irasburg',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5770',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.9796000',
                'longitude' => '-73.3106000',
                'city' => 'Shoreham',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5065',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8254000',
                'longitude' => '-72.5192000',
                'city' => 'Sharon',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5070',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8381000',
                'longitude' => '-72.3673000',
                'city' => 'South Strafford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5072',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8381000',
                'longitude' => '-72.3673000',
                'city' => 'Strafford',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5748',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8720000',
                'longitude' => '-72.8074000',
                'city' => 'Hancock',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5747',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8720000',
                'longitude' => '-72.8074000',
                'city' => 'Granville',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5767',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.8720000',
                'longitude' => '-72.8074000',
                'city' => 'Rochester',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5440',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4948000',
                'longitude' => '-73.1135000',
                'city' => 'Alburgh',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5150',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.3534000',
                'longitude' => '-72.4048000',
                'city' => 'North Springfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5489',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5224000',
                'longitude' => '-72.9440000',
                'city' => 'Underhill',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5901',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8116000',
                'longitude' => '-71.8825000',
                'city' => 'Averill',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5260',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '42.7651000',
                'longitude' => '-73.2342000',
                'city' => 'North Pownal',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5152',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1919000',
                'longitude' => '-72.8141000',
                'city' => 'Peru',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5161',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1919000',
                'longitude' => '-72.8141000',
                'city' => 'Weston',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5448',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7848000',
                'longitude' => '-72.8623000',
                'city' => 'East Fairfield',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5633',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Montpelier',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5609',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Montpelier',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5620',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Montpelier',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5601',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.2637000',
                'longitude' => '-72.5744000',
                'city' => 'Montpelier',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5146',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1707000',
                'longitude' => '-72.6136000',
                'city' => 'Grafton',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5460',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9177000',
                'longitude' => '-73.1233000',
                'city' => 'Highgate Springs',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5141',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1408000',
                'longitude' => '-72.5103000',
                'city' => 'Cambridgeport',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5451',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.4948000',
                'longitude' => '-73.1135000',
                'city' => 'Essex',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5823',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '45.0012000',
                'longitude' => '-72.1033000',
                'city' => 'Beebe Plain',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5359',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '43.1014000',
                'longitude' => '-72.7770000',
                'city' => 'West Townshend',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5657',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5613000',
                'longitude' => '-72.5975000',
                'city' => 'Lake Elmore',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5490',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.5224000',
                'longitude' => '-72.9440000',
                'city' => 'Underhill Center',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5463',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.8759000',
                'longitude' => '-73.3422000',
                'city' => 'Isle La Motte',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5447',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9057000',
                'longitude' => '-72.8079000',
                'city' => 'East Berkshire',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '5485',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.9057000',
                'longitude' => '-72.8079000',
                'city' => 'Sheldon Springs',
                'full_state' => 'Vermont',
            ],
            [
                'zip' => '3590',
                'country_code' => 'US',
                'state' => 'VT',
                'latitude' => '44.7510000',
                'longitude' => '-71.6310000',
                'city' => 'North Stratford',
                'full_state' => 'Vermont',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
