<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class USVirginIslandsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '802',
                'country_code' => 'US',
                'state' => 'VI',
                'latitude' => '18.3495000',
                'longitude' => '-64.9416000',
                'city' => 'St Thomas',
                'full_state' => 'U.S. Virgin Islands',
            ],
            [
                'zip' => '840',
                'country_code' => 'US',
                'state' => 'VI',
                'latitude' => '17.7473000',
                'longitude' => '-64.7088000',
                'city' => 'Frederiksted',
                'full_state' => 'U.S. Virgin Islands',
            ],
            [
                'zip' => '850',
                'country_code' => 'US',
                'state' => 'VI',
                'latitude' => '17.7473000',
                'longitude' => '-64.7088000',
                'city' => 'Kingshill',
                'full_state' => 'U.S. Virgin Islands',
            ],
            [
                'zip' => '820',
                'country_code' => 'US',
                'state' => 'VI',
                'latitude' => '17.7473000',
                'longitude' => '-64.7088000',
                'city' => 'Christiansted',
                'full_state' => 'U.S. Virgin Islands',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
