<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SouthDakotaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '57623',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0475000',
                'longitude' => '-101.6107000',
                'city' => 'Dupree',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57104',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5470000',
                'longitude' => '-96.7638000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57107',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5470000',
                'longitude' => '-96.7638000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57109',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5470000',
                'longitude' => '-96.7638000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57039',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5470000',
                'longitude' => '-96.7638000',
                'city' => 'Lennox',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57069',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.7840000',
                'longitude' => '-96.9317000',
                'city' => 'Vermillion',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57233',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3694000',
                'longitude' => '-97.3759000',
                'city' => 'Erwin',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57362',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5167000',
                'longitude' => '-98.9931000',
                'city' => 'Miller',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57025',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.6845000',
                'longitude' => '-96.6840000',
                'city' => 'Elk Point',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57785',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4143000',
                'longitude' => '-103.4986000',
                'city' => 'Sturgis',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57369',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3818000',
                'longitude' => '-98.8365000',
                'city' => 'Platte',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57580',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3746000',
                'longitude' => '-99.8614000',
                'city' => 'Winner',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57702',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0835000',
                'longitude' => '-103.2217000',
                'city' => 'Rapid City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57703',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0835000',
                'longitude' => '-103.2217000',
                'city' => 'Rapid City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57717',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6641000',
                'longitude' => '-103.8528000',
                'city' => 'Belle Fourche',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57103',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5409000',
                'longitude' => '-96.7263000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57105',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5409000',
                'longitude' => '-96.7263000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57108',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4412000',
                'longitude' => '-96.7273000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57445',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4743000',
                'longitude' => '-98.5116000',
                'city' => 'Groton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57401',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4743000',
                'longitude' => '-98.5116000',
                'city' => 'Aberdeen',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57219',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4743000',
                'longitude' => '-98.5116000',
                'city' => 'Bristol',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57427',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4743000',
                'longitude' => '-98.5116000',
                'city' => 'Bath',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57438',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4743000',
                'longitude' => '-98.5116000',
                'city' => 'Faulkton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57049',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.4999000',
                'longitude' => '-96.3900000',
                'city' => 'North Sioux City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57501',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3649000',
                'longitude' => '-100.3549000',
                'city' => 'Pierre',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57532',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3649000',
                'longitude' => '-100.3549000',
                'city' => 'Fort Pierre',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57334',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5473000',
                'longitude' => '-97.9790000',
                'city' => 'Ethan',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57311',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5473000',
                'longitude' => '-97.9790000',
                'city' => 'Alexandria',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57363',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5473000',
                'longitude' => '-97.9790000',
                'city' => 'Mount Vernon',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57331',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5473000',
                'longitude' => '-97.9790000',
                'city' => 'Dimock',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57038',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.4992000',
                'longitude' => '-96.4038000',
                'city' => 'Jefferson',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57225',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8733000',
                'longitude' => '-97.7344000',
                'city' => 'Clark',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57325',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8092000',
                'longitude' => '-99.3323000',
                'city' => 'Chamberlain',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57368',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7152000',
                'longitude' => '-98.2556000',
                'city' => 'Plankinton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57201',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8985000',
                'longitude' => '-97.1019000',
                'city' => 'Watertown',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57021',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1738000',
                'longitude' => '-97.0696000',
                'city' => 'Davis',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57070',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1738000',
                'longitude' => '-97.0696000',
                'city' => 'Viborg',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57053',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1738000',
                'longitude' => '-97.0696000',
                'city' => 'Parker',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57036',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1738000',
                'longitude' => '-97.0696000',
                'city' => 'Hurley',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57058',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7235000',
                'longitude' => '-97.3815000',
                'city' => 'Salem',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57344',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4244000',
                'longitude' => '-98.5989000',
                'city' => 'Harrison',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57364',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4244000',
                'longitude' => '-98.5989000',
                'city' => 'New Holland',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57342',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4244000',
                'longitude' => '-98.5989000',
                'city' => 'Geddes',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57328',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4244000',
                'longitude' => '-98.5989000',
                'city' => 'Corsica',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57649',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5208000',
                'longitude' => '-102.4684000',
                'city' => 'Prairie City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57638',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5208000',
                'longitude' => '-102.4684000',
                'city' => 'Lemmon',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57644',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5208000',
                'longitude' => '-102.4684000',
                'city' => 'Meadow',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57640',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5208000',
                'longitude' => '-102.4684000',
                'city' => 'Lodgepole',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57620',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5208000',
                'longitude' => '-102.4684000',
                'city' => 'Bison',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57339',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0546000',
                'longitude' => '-99.4374000',
                'city' => 'Fort Thompson',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57374',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7246000',
                'longitude' => '-97.5918000',
                'city' => 'Spencer',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57048',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8344000',
                'longitude' => '-97.3345000',
                'city' => 'Montrose',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57076',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8344000',
                'longitude' => '-97.3345000',
                'city' => 'Winfred',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57385',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9000000',
                'longitude' => '-98.1370000',
                'city' => 'Woonsocket',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57359',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9000000',
                'longitude' => '-98.1370000',
                'city' => 'Letcher',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57382',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7295000',
                'longitude' => '-98.7171000',
                'city' => 'Wessington Springs',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57383',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7295000',
                'longitude' => '-98.7171000',
                'city' => 'White Lake',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57014',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9838000',
                'longitude' => '-96.7817000',
                'city' => 'Centerville',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57004',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9838000',
                'longitude' => '-96.7817000',
                'city' => 'Beresford',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57010',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9838000',
                'longitude' => '-96.7817000',
                'city' => 'Burbank',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57001',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9838000',
                'longitude' => '-96.7817000',
                'city' => 'Alcester',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57738',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8265000',
                'longitude' => '-103.2003000',
                'city' => 'Fairburn',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57751',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8265000',
                'longitude' => '-103.2003000',
                'city' => 'Keystone',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57730',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8265000',
                'longitude' => '-103.2003000',
                'city' => 'Custer',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57744',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8265000',
                'longitude' => '-103.2003000',
                'city' => 'Hermosa',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57075',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0037000',
                'longitude' => '-97.1113000',
                'city' => 'Wentworth',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57042',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0037000',
                'longitude' => '-97.1113000',
                'city' => 'Madison',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57762',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6748000',
                'longitude' => '-103.5379000',
                'city' => 'Nisland',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57520',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.7083000',
                'longitude' => '-100.0667000',
                'city' => 'Agar',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57564',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.7083000',
                'longitude' => '-100.0667000',
                'city' => 'Onida',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57579',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5651000',
                'longitude' => '-100.7523000',
                'city' => 'White River',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57078',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.8755000',
                'longitude' => '-97.3931000',
                'city' => 'Yankton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57072',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0836000',
                'longitude' => '-97.1525000',
                'city' => 'Volin',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57073',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0836000',
                'longitude' => '-97.1525000',
                'city' => 'Wakonda',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57037',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0836000',
                'longitude' => '-97.1525000',
                'city' => 'Irene',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57442',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.7508000',
                'longitude' => '-100.3258000',
                'city' => 'Gettysburg',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57274',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3249000',
                'longitude' => '-97.5189000',
                'city' => 'Webster',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57348',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6301000',
                'longitude' => '-98.4117000',
                'city' => 'Hitchcock',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57440',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6301000',
                'longitude' => '-98.4117000',
                'city' => 'Frankfort',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57031',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0059000',
                'longitude' => '-97.1065000',
                'city' => 'Gayville',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57262',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.6665000',
                'longitude' => '-97.0526000',
                'city' => 'Sisseton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57793',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4604000',
                'longitude' => '-103.6385000',
                'city' => 'Whitewood',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57237',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.7944000',
                'longitude' => '-96.4517000',
                'city' => 'Gary',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57633',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9229000',
                'longitude' => '-101.3532000',
                'city' => 'Isabel',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57642',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9229000',
                'longitude' => '-101.3532000',
                'city' => 'Mc Laughlin',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57659',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9229000',
                'longitude' => '-101.3532000',
                'city' => 'Walker',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57641',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9229000',
                'longitude' => '-101.3532000',
                'city' => 'Mc Intosh',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57106',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5452000',
                'longitude' => '-96.7240000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57110',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5452000',
                'longitude' => '-96.7240000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57197',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5452000',
                'longitude' => '-96.7240000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57755',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9147000',
                'longitude' => '-103.1690000',
                'city' => 'Ludlow',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '58653',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9147000',
                'longitude' => '-103.1690000',
                'city' => 'Scranton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57650',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9147000',
                'longitude' => '-103.1690000',
                'city' => 'Ralph',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57790',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9909000',
                'longitude' => '-102.2399000',
                'city' => 'Wall',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57522',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3643000',
                'longitude' => '-100.4095000',
                'city' => 'Blunt',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57448',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4490000',
                'longitude' => '-99.6598000',
                'city' => 'Hosmer',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57471',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5721000',
                'longitude' => '-99.4708000',
                'city' => 'Roscoe',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57437',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5721000',
                'longitude' => '-99.4708000',
                'city' => 'Eureka',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57428',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5721000',
                'longitude' => '-99.4708000',
                'city' => 'Bowdle',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57452',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.7742000',
                'longitude' => '-99.6230000',
                'city' => 'Java',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57380',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0038000',
                'longitude' => '-98.0591000',
                'city' => 'Wagner',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57315',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0038000',
                'longitude' => '-98.0591000',
                'city' => 'Avon',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57329',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0038000',
                'longitude' => '-98.0591000',
                'city' => 'Dante',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57062',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0038000',
                'longitude' => '-98.0591000',
                'city' => 'Springfield',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57551',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0342000',
                'longitude' => '-102.2499000',
                'city' => 'Martin',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57716',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0342000',
                'longitude' => '-102.2499000',
                'city' => 'Batesland',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57301',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7085000',
                'longitude' => '-98.0218000',
                'city' => 'Mitchell',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57355',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0314000',
                'longitude' => '-98.9877000',
                'city' => 'Kimball',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57341',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0314000',
                'longitude' => '-98.9877000',
                'city' => 'Gann Valley',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57432',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.6749000',
                'longitude' => '-98.0106000',
                'city' => 'Claremont',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57449',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.6749000',
                'longitude' => '-98.0106000',
                'city' => 'Houghton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57012',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5982000',
                'longitude' => '-97.2935000',
                'city' => 'Canistota',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57043',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3982000',
                'longitude' => '-97.1382000',
                'city' => 'Marion',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57035',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3982000',
                'longitude' => '-97.1382000',
                'city' => 'Humboldt',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57047',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3982000',
                'longitude' => '-97.1382000',
                'city' => 'Monroe',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57422',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4079000',
                'longitude' => '-97.9060000',
                'city' => 'Andover',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57469',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8734000',
                'longitude' => '-98.5226000',
                'city' => 'Redfield',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57435',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1706000',
                'longitude' => '-98.9450000',
                'city' => 'Cresbard',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57465',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1706000',
                'longitude' => '-98.9450000',
                'city' => 'Northville',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57460',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1706000',
                'longitude' => '-98.9450000',
                'city' => 'Mansfield',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57468',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3775000',
                'longitude' => '-97.8320000',
                'city' => 'Pierpont',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57029',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1738000',
                'longitude' => '-97.0696000',
                'city' => 'Freeman',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57045',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1738000',
                'longitude' => '-97.0696000',
                'city' => 'Menno',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57441',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8296000',
                'longitude' => '-98.5078000',
                'city' => 'Frederick',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57433',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8296000',
                'longitude' => '-98.5078000',
                'city' => 'Columbia',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57481',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8296000',
                'longitude' => '-98.5078000',
                'city' => 'Westport',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57426',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8296000',
                'longitude' => '-98.5078000',
                'city' => 'Barnard',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57533',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3818000',
                'longitude' => '-98.8365000',
                'city' => 'Gregory',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57732',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3835000',
                'longitude' => '-103.7054000',
                'city' => 'Deadwood',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57701',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0806000',
                'longitude' => '-103.2296000',
                'city' => 'Rapid City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57552',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8238000',
                'longitude' => '-101.2851000',
                'city' => 'Midland',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57543',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8238000',
                'longitude' => '-101.2851000',
                'city' => 'Kadoka',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57521',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8238000',
                'longitude' => '-101.2851000',
                'city' => 'Belvidere',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57741',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4143000',
                'longitude' => '-103.4986000',
                'city' => 'Fort Meade',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57030',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8501000',
                'longitude' => '-96.3887000',
                'city' => 'Garretson',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57065',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8501000',
                'longitude' => '-96.3887000',
                'city' => 'Trent',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '56164',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8501000',
                'longitude' => '-96.3887000',
                'city' => 'Pipestone',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '56144',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8501000',
                'longitude' => '-96.3887000',
                'city' => 'Jasper',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57032',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5409000',
                'longitude' => '-96.7263000',
                'city' => 'Harrisburg',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57350',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3640000',
                'longitude' => '-98.2166000',
                'city' => 'Huron',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57322',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3640000',
                'longitude' => '-98.2166000',
                'city' => 'Carpenter',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '58439',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8850000',
                'longitude' => '-98.7668000',
                'city' => 'Forbes',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57064',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5470000',
                'longitude' => '-96.7638000',
                'city' => 'Tea',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57101',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5470000',
                'longitude' => '-96.7638000',
                'city' => 'Sioux Falls',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57033',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.6447000',
                'longitude' => '-97.0774000',
                'city' => 'Hartford',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57040',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0434000',
                'longitude' => '-97.5939000',
                'city' => 'Lesterville',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57067',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0434000',
                'longitude' => '-97.5939000',
                'city' => 'Utica',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57059',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0434000',
                'longitude' => '-97.5939000',
                'city' => 'Scotland',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57005',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5409000',
                'longitude' => '-96.7263000',
                'city' => 'Brandon',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57013',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3567000',
                'longitude' => '-96.8964000',
                'city' => 'Canton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57077',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3567000',
                'longitude' => '-96.8964000',
                'city' => 'Worthing',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57634',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9416000',
                'longitude' => '-102.1694000',
                'city' => 'Keldron',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57776',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5820000',
                'longitude' => '-103.5443000',
                'city' => 'Redig',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57720',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5820000',
                'longitude' => '-103.5443000',
                'city' => 'Buffalo',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57651',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5820000',
                'longitude' => '-103.5443000',
                'city' => 'Reva',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57555',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.8751000',
                'longitude' => '-100.5518000',
                'city' => 'Mission',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '69201',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.8751000',
                'longitude' => '-100.5518000',
                'city' => 'Valentine',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57457',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9159000',
                'longitude' => '-99.1639000',
                'city' => 'Long Lake',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57402',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4743000',
                'longitude' => '-98.5116000',
                'city' => 'Aberdeen',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57709',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0863000',
                'longitude' => '-103.2535000',
                'city' => 'Rapid City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57434',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1584000',
                'longitude' => '-98.0986000',
                'city' => 'Conde',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57474',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1584000',
                'longitude' => '-98.0986000',
                'city' => 'Stratford',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57477',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1584000',
                'longitude' => '-98.0986000',
                'city' => 'Turton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57446',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '46.0185000',
                'longitude' => '-98.5258000',
                'city' => 'Hecla',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57361',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0808000',
                'longitude' => '-98.2939000',
                'city' => 'Marty',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57356',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0808000',
                'longitude' => '-98.2939000',
                'city' => 'Lake Andes',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57706',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1405000',
                'longitude' => '-103.0280000',
                'city' => 'Ellsworth Afb',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57567',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9909000',
                'longitude' => '-102.2399000',
                'city' => 'Philip',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57775',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9909000',
                'longitude' => '-102.2399000',
                'city' => 'Quinn',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57052',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.2376000',
                'longitude' => '-97.5772000',
                'city' => 'Olivet',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57769',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0835000',
                'longitude' => '-103.2217000',
                'city' => 'Piedmont',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57467',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.9023000',
                'longitude' => '-99.0864000',
                'city' => 'Orient',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57725',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0521000',
                'longitude' => '-103.1273000',
                'city' => 'Caputa',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57439',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3326000',
                'longitude' => '-98.1008000',
                'city' => 'Ferney',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57251',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3072000',
                'longitude' => '-97.0316000',
                'city' => 'Marvin',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57269',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3072000',
                'longitude' => '-97.0316000',
                'city' => 'Twin Brooks',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57256',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3072000',
                'longitude' => '-97.0316000',
                'city' => 'Ortley',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57263',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3072000',
                'longitude' => '-97.0316000',
                'city' => 'South Shore',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57266',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3072000',
                'longitude' => '-97.0316000',
                'city' => 'Summit',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57782',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4053000',
                'longitude' => '-103.2658000',
                'city' => 'Smithwick',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57766',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4053000',
                'longitude' => '-103.2658000',
                'city' => 'Oral',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57451',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4519000',
                'longitude' => '-99.0331000',
                'city' => 'Ipswich',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57022',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8260000',
                'longitude' => '-96.7105000',
                'city' => 'Dell Rapids',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '69216',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9276000',
                'longitude' => '-100.7519000',
                'city' => 'Kilgore',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '69212',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9276000',
                'longitude' => '-100.7519000',
                'city' => 'Crookston',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57227',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.2263000',
                'longitude' => '-96.6297000',
                'city' => 'Corona',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57216',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.2263000',
                'longitude' => '-96.6297000',
                'city' => 'Big Stone City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57252',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.2263000',
                'longitude' => '-96.6297000',
                'city' => 'Milbank',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57780',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8691000',
                'longitude' => '-102.5817000',
                'city' => 'Scenic',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57750',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8691000',
                'longitude' => '-102.5817000',
                'city' => 'Interior',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57273',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.3324000',
                'longitude' => '-97.2980000',
                'city' => 'Waubay',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57466',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0598000',
                'longitude' => '-99.5086000',
                'city' => 'Onaka',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57345',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0598000',
                'longitude' => '-99.5086000',
                'city' => 'Highmore',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57473',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0598000',
                'longitude' => '-99.5086000',
                'city' => 'Seneca',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57632',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8354000',
                'longitude' => '-100.0725000',
                'city' => 'Herreid',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57456',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.7229000',
                'longitude' => '-98.9378000',
                'city' => 'Leola',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57475',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.2069000',
                'longitude' => '-99.6189000',
                'city' => 'Tolstoy',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57450',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.2069000',
                'longitude' => '-99.6189000',
                'city' => 'Hoven',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57018',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7862000',
                'longitude' => '-96.9309000',
                'city' => 'Colton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57430',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.7933000',
                'longitude' => '-97.7553000',
                'city' => 'Britton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57247',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.7933000',
                'longitude' => '-97.7553000',
                'city' => 'Lake City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57421',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.7933000',
                'longitude' => '-97.7553000',
                'city' => 'Amherst',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57332',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5982000',
                'longitude' => '-97.6195000',
                'city' => 'Emery',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57319',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5982000',
                'longitude' => '-97.6195000',
                'city' => 'Bridgewater',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57585',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4999000',
                'longitude' => '-100.4827000',
                'city' => 'Wood',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57772',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4302000',
                'longitude' => '-102.1760000',
                'city' => 'Porcupine',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57714',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4302000',
                'longitude' => '-102.1760000',
                'city' => 'Allen',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57756',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4302000',
                'longitude' => '-102.1760000',
                'city' => 'Manderson',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57752',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4302000',
                'longitude' => '-102.1760000',
                'city' => 'Kyle',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57788',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.7247000',
                'longitude' => '-103.4155000',
                'city' => 'Vale',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57760',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.7247000',
                'longitude' => '-103.4155000',
                'city' => 'Newell',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57384',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4574000',
                'longitude' => '-98.7025000',
                'city' => 'Wolsey',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57381',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4574000',
                'longitude' => '-98.7025000',
                'city' => 'Wessington',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57735',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0213000',
                'longitude' => '-103.6573000',
                'city' => 'Edgemont',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57577',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4567000',
                'longitude' => '-101.4988000',
                'city' => 'Wanblee',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57566',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4567000',
                'longitude' => '-101.4988000',
                'city' => 'Parmelee',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57547',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4567000',
                'longitude' => '-101.4988000',
                'city' => 'Long Valley',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57560',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4567000',
                'longitude' => '-101.4988000',
                'city' => 'Norris',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57063',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9478000',
                'longitude' => '-97.6591000',
                'city' => 'Tabor',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57066',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9939000',
                'longitude' => '-97.8696000',
                'city' => 'Tyndall',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57424',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8777000',
                'longitude' => '-98.5203000',
                'city' => 'Ashton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57470',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8777000',
                'longitude' => '-98.5203000',
                'city' => 'Rockham',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57569',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8770000',
                'longitude' => '-99.6021000',
                'city' => 'Reliance',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57548',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8770000',
                'longitude' => '-99.6021000',
                'city' => 'Lower Brule',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57068',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4538000',
                'longitude' => '-96.4324000',
                'city' => 'Valley Springs',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57276',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5082000',
                'longitude' => '-96.4142000',
                'city' => 'White',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '56136',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5082000',
                'longitude' => '-96.4142000',
                'city' => 'Hendricks',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57050',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0037000',
                'longitude' => '-97.1113000',
                'city' => 'Nunda',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57051',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1642000',
                'longitude' => '-97.2693000',
                'city' => 'Oldham',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57054',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1642000',
                'longitude' => '-97.2693000',
                'city' => 'Ramona',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57212',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1642000',
                'longitude' => '-97.2693000',
                'city' => 'Arlington',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57057',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9958000',
                'longitude' => '-96.9649000',
                'city' => 'Rutland',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57261',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5010000',
                'longitude' => '-97.4904000',
                'city' => 'Roslyn',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57232',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5010000',
                'longitude' => '-97.4904000',
                'city' => 'Eden',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57239',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5010000',
                'longitude' => '-97.4904000',
                'city' => 'Grenville',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57367',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1563000',
                'longitude' => '-98.5432000',
                'city' => 'Pickstown',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57017',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8944000',
                'longitude' => '-96.9255000',
                'city' => 'Colman',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57016',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8944000',
                'longitude' => '-96.9255000',
                'city' => 'Chester',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57454',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.6015000',
                'longitude' => '-97.8339000',
                'city' => 'Langford',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57324',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0234000',
                'longitude' => '-98.0642000',
                'city' => 'Cavour',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57314',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0234000',
                'longitude' => '-98.0642000',
                'city' => 'Artesian',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57366',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3892000',
                'longitude' => '-97.9821000',
                'city' => 'Parkston',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57791',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9909000',
                'longitude' => '-102.2399000',
                'city' => 'Wasta',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57559',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8848000',
                'longitude' => '-100.7184000',
                'city' => 'Murdo',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57321',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8778000',
                'longitude' => '-97.5017000',
                'city' => 'Canova',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57660',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9335000',
                'longitude' => '-101.7232000',
                'city' => 'Watauga',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57645',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9335000',
                'longitude' => '-101.7232000',
                'city' => 'Morristown',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57015',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5423000',
                'longitude' => '-96.9502000',
                'city' => 'Chancellor',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57349',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0081000',
                'longitude' => '-97.9223000',
                'city' => 'Howard',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57337',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0081000',
                'longitude' => '-97.9223000',
                'city' => 'Fedora',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57003',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7600000',
                'longitude' => '-96.7406000',
                'city' => 'Baltic',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57236',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8733000',
                'longitude' => '-97.7344000',
                'city' => 'Garden City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57258',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8733000',
                'longitude' => '-97.7344000',
                'city' => 'Raymond',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57243',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8733000',
                'longitude' => '-97.7344000',
                'city' => 'Henry',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57224',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '46.0776000',
                'longitude' => '-97.1497000',
                'city' => 'Claire City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57071',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9861000',
                'longitude' => '-96.8127000',
                'city' => 'Volga',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57024',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9861000',
                'longitude' => '-96.8127000',
                'city' => 'Egan',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57747',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1749000',
                'longitude' => '-103.2346000',
                'city' => 'Hot Springs',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57763',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1749000',
                'longitude' => '-103.2346000',
                'city' => 'Oelrichs',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57260',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8652000',
                'longitude' => '-96.7337000',
                'city' => 'Rosholt',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57748',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0475000',
                'longitude' => '-101.6107000',
                'city' => 'Howes',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57625',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0475000',
                'longitude' => '-101.6107000',
                'city' => 'Eagle Butte',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57622',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0475000',
                'longitude' => '-101.6107000',
                'city' => 'Cherry Creek',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57026',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.2329000',
                'longitude' => '-96.4811000',
                'city' => 'Elkton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57055',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.6605000',
                'longitude' => '-96.8097000',
                'city' => 'Renner',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57020',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.6605000',
                'longitude' => '-96.8097000',
                'city' => 'Crooks',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57041',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.6605000',
                'longitude' => '-96.8097000',
                'city' => 'Lyons',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57553',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4254000',
                'longitude' => '-101.6812000',
                'city' => 'Milesville',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57231',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3658000',
                'longitude' => '-97.8521000',
                'city' => 'De Smet',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57353',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3658000',
                'longitude' => '-97.8521000',
                'city' => 'Iroquois',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57528',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1661000',
                'longitude' => '-100.0380000',
                'city' => 'Colome',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57783',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4931000',
                'longitude' => '-103.8665000',
                'city' => 'Spearfish',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '58639',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9978000',
                'longitude' => '-102.6394000',
                'city' => 'Hettinger',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '51001',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.8265000',
                'longitude' => '-96.5586000',
                'city' => 'Akron',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57537',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3694000',
                'longitude' => '-101.0240000',
                'city' => 'Hayes',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57028',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0402000',
                'longitude' => '-96.5902000',
                'city' => 'Flandreau',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57745',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9333000',
                'longitude' => '-103.5748000',
                'city' => 'Hill City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '58623',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9879000',
                'longitude' => '-103.4108000',
                'city' => 'Bowman',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57759',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3764000',
                'longitude' => '-103.6951000',
                'city' => 'Nemo',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57754',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3764000',
                'longitude' => '-103.6951000',
                'city' => 'Lead',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57376',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1494000',
                'longitude' => '-97.7189000',
                'city' => 'Tripp',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57354',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1494000',
                'longitude' => '-97.7189000',
                'city' => 'Kaylor',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57476',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.7414000',
                'longitude' => '-98.5104000',
                'city' => 'Tulare',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57386',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3680000',
                'longitude' => '-98.0361000',
                'city' => 'Yale',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57249',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3694000',
                'longitude' => '-97.3759000',
                'city' => 'Lake Preston',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57246',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0182000',
                'longitude' => '-96.5672000',
                'city' => 'Labolt',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57259',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0182000',
                'longitude' => '-96.5672000',
                'city' => 'Revillo',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57271',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6245000',
                'longitude' => '-97.6420000',
                'city' => 'Vienna',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57221',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6245000',
                'longitude' => '-97.6420000',
                'city' => 'Bryant',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57278',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6245000',
                'longitude' => '-97.6420000',
                'city' => 'Willow Lake',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57220',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3238000',
                'longitude' => '-96.9261000',
                'city' => 'Bruce',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57006',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3238000',
                'longitude' => '-96.9261000',
                'city' => 'Brookings',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57242',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6245000',
                'longitude' => '-97.6420000',
                'city' => 'Hazel',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57002',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4329000',
                'longitude' => '-96.6507000',
                'city' => 'Aurora',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57436',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8906000',
                'longitude' => '-98.0988000',
                'city' => 'Doland',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57255',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8587000',
                'longitude' => '-96.9213000',
                'city' => 'New Effington',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57779',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.4931000',
                'longitude' => '-103.8665000',
                'city' => 'Saint Onge',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57420',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5060000',
                'longitude' => '-100.0344000',
                'city' => 'Akaska',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57472',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5060000',
                'longitude' => '-100.0344000',
                'city' => 'Selby',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57335',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0761000',
                'longitude' => '-98.9464000',
                'city' => 'Fairfax',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57571',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0761000',
                'longitude' => '-98.9464000',
                'city' => 'Saint Charles',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57538',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0761000',
                'longitude' => '-98.9464000',
                'city' => 'Herrick',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57317',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0761000',
                'longitude' => '-98.9464000',
                'city' => 'Bonesteel',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57046',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.8858000',
                'longitude' => '-97.3943000',
                'city' => 'Mission Hill',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57531',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8848000',
                'longitude' => '-100.7184000',
                'city' => 'Draper',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57562',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8848000',
                'longitude' => '-100.7184000',
                'city' => 'Okaton',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57773',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7692000',
                'longitude' => '-103.5985000',
                'city' => 'Pringle',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57265',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1007000',
                'longitude' => '-96.7994000',
                'city' => 'Strandburg',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57264',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1007000',
                'longitude' => '-96.7994000',
                'city' => 'Stockholm',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57576',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9224000',
                'longitude' => '-100.2960000',
                'city' => 'Vivian',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57574',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1761000',
                'longitude' => '-101.7420000',
                'city' => 'Tuthill',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '56219',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5945000',
                'longitude' => '-96.8326000',
                'city' => 'Browns Valley',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57313',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3198000',
                'longitude' => '-98.3503000',
                'city' => 'Armour',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57370',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4545000',
                'longitude' => '-99.0818000',
                'city' => 'Pukwana',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57375',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.5937000',
                'longitude' => '-98.4430000',
                'city' => 'Stickney',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57661',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1367000',
                'longitude' => '-100.6274000',
                'city' => 'Whitehorse',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57652',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1367000',
                'longitude' => '-100.6274000',
                'city' => 'Ridgeview',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57365',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8092000',
                'longitude' => '-99.3323000',
                'city' => 'Oacoma',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57270',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8680000',
                'longitude' => '-97.2904000',
                'city' => 'Veblen',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57626',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0257000',
                'longitude' => '-102.0442000',
                'city' => 'Faith',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57570',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.2287000',
                'longitude' => '-100.8537000',
                'city' => 'Rosebud',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57572',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.2287000',
                'longitude' => '-100.8537000',
                'city' => 'Saint Francis',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57758',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0235000',
                'longitude' => '-102.5880000',
                'city' => 'Mud Butte',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '82701',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.8528000',
                'longitude' => '-104.2006000',
                'city' => 'Newcastle',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57761',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0893000',
                'longitude' => '-102.8304000',
                'city' => 'New Underwood',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57235',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0573000',
                'longitude' => '-97.3259000',
                'city' => 'Florence',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57272',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0573000',
                'longitude' => '-97.3259000',
                'city' => 'Wallace',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57601',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5320000',
                'longitude' => '-100.2707000',
                'city' => 'Mobridge',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57646',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5320000',
                'longitude' => '-100.2707000',
                'city' => 'Mound City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57631',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5320000',
                'longitude' => '-100.2707000',
                'city' => 'Glenham',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57455',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0089000',
                'longitude' => '-99.9560000',
                'city' => 'Lebanon',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57323',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.0091000',
                'longitude' => '-97.5257000',
                'city' => 'Carthage',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57523',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1821000',
                'longitude' => '-99.2942000',
                'city' => 'Burke',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57330',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.2666000',
                'longitude' => '-98.1627000',
                'city' => 'Delmont',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57241',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6538000',
                'longitude' => '-97.2043000',
                'city' => 'Hayti',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57248',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6538000',
                'longitude' => '-97.2043000',
                'city' => 'Lake Norden',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57217',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.0910000',
                'longitude' => '-97.6421000',
                'city' => 'Bradley',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57718',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1479000',
                'longitude' => '-103.2264000',
                'city' => 'Black Hawk',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57226',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6521000',
                'longitude' => '-97.0945000',
                'city' => 'Clear Lake',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57223',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.6521000',
                'longitude' => '-97.0945000',
                'city' => 'Castlewood',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57213',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5738000',
                'longitude' => '-96.6539000',
                'city' => 'Astoria',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57218',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5738000',
                'longitude' => '-96.6539000',
                'city' => 'Brandt',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57268',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5738000',
                'longitude' => '-96.6539000',
                'city' => 'Toronto',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57238',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.8759000',
                'longitude' => '-96.8505000',
                'city' => 'Goodwin',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57724',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5519000',
                'longitude' => '-103.9753000',
                'city' => 'Camp Crook',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57767',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1247000',
                'longitude' => '-102.5726000',
                'city' => 'Owanka',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '69211',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '42.9371000',
                'longitude' => '-101.2446000',
                'city' => 'Cody',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57621',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8158000',
                'longitude' => '-100.8151000',
                'city' => 'Bullhead',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57639',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.8158000',
                'longitude' => '-100.8151000',
                'city' => 'Little Eagle',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57061',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.2441000',
                'longitude' => '-97.0464000',
                'city' => 'Sinai',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57722',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4940000',
                'longitude' => '-103.3130000',
                'city' => 'Buffalo Gap',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57529',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.2293000',
                'longitude' => '-99.4310000',
                'city' => 'Dallas',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57534',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3746000',
                'longitude' => '-99.8614000',
                'city' => 'Hamill',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57541',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3746000',
                'longitude' => '-99.8614000',
                'city' => 'Ideal',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57657',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5346000',
                'longitude' => '-100.4356000',
                'city' => 'Trail City',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57658',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5346000',
                'longitude' => '-100.4356000',
                'city' => 'Wakpala',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57312',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1831000',
                'longitude' => '-98.3679000',
                'city' => 'Alpena',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57379',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1831000',
                'longitude' => '-98.3679000',
                'city' => 'Virgil',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57540',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5199000',
                'longitude' => '-99.4446000',
                'city' => 'Holabird',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57346',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5199000',
                'longitude' => '-99.4446000',
                'city' => 'Stephan',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57373',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5167000',
                'longitude' => '-98.9931000',
                'city' => 'Saint Lawrence',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57563',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.3050000',
                'longitude' => '-100.6572000',
                'city' => 'Okreek',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57656',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4295000',
                'longitude' => '-101.0756000',
                'city' => 'Timber Lake',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57630',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4295000',
                'longitude' => '-101.0756000',
                'city' => 'Glencross',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57764',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0223000',
                'longitude' => '-102.5576000',
                'city' => 'Oglala',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57770',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0223000',
                'longitude' => '-102.5576000',
                'city' => 'Pine Ridge',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57794',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0223000',
                'longitude' => '-102.5576000',
                'city' => 'Wounded Knee',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57544',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9015000',
                'longitude' => '-99.8601000',
                'city' => 'Kennebec',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57568',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.9015000',
                'longitude' => '-99.8601000',
                'city' => 'Presho',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57371',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5172000',
                'longitude' => '-99.4528000',
                'city' => 'Ree Heights',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57234',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5763000',
                'longitude' => '-96.9018000',
                'city' => 'Estelline',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57536',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5251000',
                'longitude' => '-99.7425000',
                'city' => 'Harrold',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57584',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.4346000',
                'longitude' => '-100.0862000',
                'city' => 'Witten',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57429',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1492000',
                'longitude' => '-98.4992000',
                'city' => 'Brentford',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57461',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.1492000',
                'longitude' => '-98.4992000',
                'city' => 'Mellette',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57648',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.9138000',
                'longitude' => '-100.2857000',
                'city' => 'Pollock',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57719',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.1405000',
                'longitude' => '-103.0280000',
                'city' => 'Box Elder',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57257',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.5411000',
                'longitude' => '-96.9623000',
                'city' => 'Peever',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57034',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.0201000',
                'longitude' => '-96.6200000',
                'city' => 'Hudson',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57279',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '45.4065000',
                'longitude' => '-96.8559000',
                'city' => 'Wilmot',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57214',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.3653000',
                'longitude' => '-97.1372000',
                'city' => 'Badger',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57027',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.1292000',
                'longitude' => '-96.4512000',
                'city' => 'Fairview',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57737',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5739000',
                'longitude' => '-102.5572000',
                'city' => 'Enning',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57792',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5739000',
                'longitude' => '-102.5572000',
                'city' => 'White Owl',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57787',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '44.5739000',
                'longitude' => '-102.5572000',
                'city' => 'Union Center',
                'full_state' => 'South Dakota',
            ],
            [
                'zip' => '57340',
                'country_code' => 'US',
                'state' => 'SD',
                'latitude' => '43.7085000',
                'longitude' => '-98.0218000',
                'city' => 'Fulton',
                'full_state' => 'South Dakota',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
