<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SouthCarolinaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '29201',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29860',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5127000',
                'longitude' => '-81.9553000',
                'city' => 'North Augusta',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29842',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5127000',
                'longitude' => '-81.9553000',
                'city' => 'Beech Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29821',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5127000',
                'longitude' => '-81.9553000',
                'city' => 'Clarks Hill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29841',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5127000',
                'longitude' => '-81.9553000',
                'city' => 'North Augusta',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29204',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29734',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9271000',
                'longitude' => '-81.0252000',
                'city' => 'Rock Hill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29706',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7077000',
                'longitude' => '-81.2080000',
                'city' => 'Chester',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29206',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0821000',
                'longitude' => '-80.9875000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29210',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29223',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29203',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29205',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29832',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5008000',
                'longitude' => '-81.9637000',
                'city' => 'Johnston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29802',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5008000',
                'longitude' => '-81.9637000',
                'city' => 'Aiken',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29212',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0486000',
                'longitude' => '-81.1096000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29033',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Cayce',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29113',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4988000',
                'longitude' => '-81.2853000',
                'city' => 'Norway',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29817',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4988000',
                'longitude' => '-81.2853000',
                'city' => 'Blackville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29851',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Warrenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29831',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Jackson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29861',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'North Augusta',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29745',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.1188000',
                'longitude' => '-81.2434000',
                'city' => 'York',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29702',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.1188000',
                'longitude' => '-81.2434000',
                'city' => 'Blacksburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29710',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.1188000',
                'longitude' => '-81.2434000',
                'city' => 'Clover',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29812',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2450000',
                'longitude' => '-81.3666000',
                'city' => 'Barnwell',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29001',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6934000',
                'longitude' => '-80.2169000',
                'city' => 'Alcolu',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29051',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6934000',
                'longitude' => '-80.2169000',
                'city' => 'Gable',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29801',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5588000',
                'longitude' => '-81.7182000',
                'city' => 'Aiken',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29169',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'West Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29229',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29170',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'West Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29115',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Orangeburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29010',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2086000',
                'longitude' => '-80.2608000',
                'city' => 'Bishopville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29730',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9271000',
                'longitude' => '-81.0252000',
                'city' => 'Rock Hill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29847',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5608000',
                'longitude' => '-81.8068000',
                'city' => 'Trenton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29829',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5608000',
                'longitude' => '-81.8068000',
                'city' => 'Graniteville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29601',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7195000',
                'longitude' => '-80.7672000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29150',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9605000',
                'longitude' => '-80.3762000',
                'city' => 'Sumter',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29036',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Chapin',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29250',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29063',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Irmo',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29732',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9271000',
                'longitude' => '-81.0252000',
                'city' => 'Rock Hill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29715',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9271000',
                'longitude' => '-81.0252000',
                'city' => 'Fort Mill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29020',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2494000',
                'longitude' => '-80.6098000',
                'city' => 'Camden',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29003',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3008000',
                'longitude' => '-81.0368000',
                'city' => 'Bamberg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29432',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2968000',
                'longitude' => '-81.0397000',
                'city' => 'Branchville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29720',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7195000',
                'longitude' => '-80.7672000',
                'city' => 'Lancaster',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29107',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6175000',
                'longitude' => '-81.1083000',
                'city' => 'Neeses',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29112',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6175000',
                'longitude' => '-81.1083000',
                'city' => 'North',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29526',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Conway',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29137',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4964000',
                'longitude' => '-81.2806000',
                'city' => 'Salley',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29146',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4964000',
                'longitude' => '-81.2806000',
                'city' => 'Springfield',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29836',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2450000',
                'longitude' => '-81.3666000',
                'city' => 'Martin',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29853',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2450000',
                'longitude' => '-81.3666000',
                'city' => 'Williston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29843',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2450000',
                'longitude' => '-81.3666000',
                'city' => 'Olar',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29038',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4499000',
                'longitude' => '-81.1276000',
                'city' => 'Cope',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29828',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Gloverville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29856',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3999000',
                'longitude' => '-81.4279000',
                'city' => 'Windsor',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29826',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3999000',
                'longitude' => '-81.4279000',
                'city' => 'Elko',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29081',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.1012000',
                'longitude' => '-81.0151000',
                'city' => 'Ehrhardt',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29118',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4958000',
                'longitude' => '-80.8628000',
                'city' => 'Orangeburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29039',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4958000',
                'longitude' => '-80.8628000',
                'city' => 'Cordova',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29108',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2754000',
                'longitude' => '-81.6177000',
                'city' => 'Newberry',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29067',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5915000',
                'longitude' => '-80.6864000',
                'city' => 'Kershaw',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29058',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5915000',
                'longitude' => '-80.6864000',
                'city' => 'Heath Springs',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29133',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2507000',
                'longitude' => '-80.8158000',
                'city' => 'Rowesville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29138',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8304000',
                'longitude' => '-81.7991000',
                'city' => 'Saluda',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29126',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2793000',
                'longitude' => '-81.6148000',
                'city' => 'Pomaria',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29145',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2793000',
                'longitude' => '-81.6148000',
                'city' => 'Silverstreet',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29127',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2793000',
                'longitude' => '-81.6148000',
                'city' => 'Prosperity',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29636',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5008000',
                'longitude' => '-81.9637000',
                'city' => 'Conestee',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29744',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7195000',
                'longitude' => '-80.7672000',
                'city' => 'Van Wyck',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29803',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5588000',
                'longitude' => '-81.7182000',
                'city' => 'Aiken',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29805',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5588000',
                'longitude' => '-81.7182000',
                'city' => 'Aiken',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29220',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29208',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29045',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2190000',
                'longitude' => '-80.6966000',
                'city' => 'Elgin',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29154',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9605000',
                'longitude' => '-80.3762000',
                'city' => 'Sumter',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29006',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9076000',
                'longitude' => '-81.5492000',
                'city' => 'Batesburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29209',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29708',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9232000',
                'longitude' => '-81.0282000',
                'city' => 'Fort Mill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29733',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9232000',
                'longitude' => '-81.0282000',
                'city' => 'Rock Hill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29704',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9232000',
                'longitude' => '-81.0282000',
                'city' => 'Catawba',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29712',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9232000',
                'longitude' => '-81.0282000',
                'city' => 'Edgemoor',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29070',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Leesville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29016',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0572000',
                'longitude' => '-81.0128000',
                'city' => 'Blythewood',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29824',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7924000',
                'longitude' => '-81.9361000',
                'city' => 'Edgefield',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29130',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3092000',
                'longitude' => '-80.9555000',
                'city' => 'Ridgeway',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29180',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3092000',
                'longitude' => '-80.9555000',
                'city' => 'Winnsboro',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29075',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1655000',
                'longitude' => '-81.3489000',
                'city' => 'Little Mountain',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29065',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1655000',
                'longitude' => '-81.3489000',
                'city' => 'Jenkinsville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29810',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8651000',
                'longitude' => '-81.1094000',
                'city' => 'Allendale',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29924',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8651000',
                'longitude' => '-81.1094000',
                'city' => 'Hampton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29044',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8826000',
                'longitude' => '-80.6932000',
                'city' => 'Eastover',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29260',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29052',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8763000',
                'longitude' => '-80.6914000',
                'city' => 'Gadsden',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29073',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9754000',
                'longitude' => '-81.1769000',
                'city' => 'Lexington',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29072',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9754000',
                'longitude' => '-81.1769000',
                'city' => 'Lexington',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29054',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9825000',
                'longitude' => '-81.2433000',
                'city' => 'Gilbert',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29014',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7077000',
                'longitude' => '-81.2080000',
                'city' => 'Blackstock',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29042',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3256000',
                'longitude' => '-81.1474000',
                'city' => 'Denmark',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29215',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29153',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9605000',
                'longitude' => '-80.3762000',
                'city' => 'Sumter',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29078',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2190000',
                'longitude' => '-80.6966000',
                'city' => 'Lugoff',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29102',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6973000',
                'longitude' => '-80.2140000',
                'city' => 'Manning',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29211',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29032',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2494000',
                'longitude' => '-80.6098000',
                'city' => 'Cassatt',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29128',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2494000',
                'longitude' => '-80.6098000',
                'city' => 'Rembert',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29031',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2494000',
                'longitude' => '-80.6098000',
                'city' => 'Carlisle',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29040',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2202000',
                'longitude' => '-80.2520000',
                'city' => 'Dalzell',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29104',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2202000',
                'longitude' => '-80.2520000',
                'city' => 'Mayesville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29046',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2202000',
                'longitude' => '-80.2520000',
                'city' => 'Elliott',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29069',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2202000',
                'longitude' => '-80.2520000',
                'city' => 'Lamar',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29379',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Union',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29080',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0593000',
                'longitude' => '-80.0792000',
                'city' => 'Lynchburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29809',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4263000',
                'longitude' => '-81.7108000',
                'city' => 'New Ellenton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29071',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Lexington',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29125',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7365000',
                'longitude' => '-80.4642000',
                'city' => 'Pinewood',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29135',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6662000',
                'longitude' => '-80.7755000',
                'city' => 'Saint Matthews',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29718',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5607000',
                'longitude' => '-80.5848000',
                'city' => 'Jefferson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29577',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0074000',
                'longitude' => '-81.0294000',
                'city' => 'Myrtle Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29148',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5955000',
                'longitude' => '-80.3291000',
                'city' => 'Summerton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29055',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5672000',
                'longitude' => '-80.9017000',
                'city' => 'Great Falls',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29729',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5672000',
                'longitude' => '-80.9017000',
                'city' => 'Richburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29714',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5672000',
                'longitude' => '-80.9017000',
                'city' => 'Fort Lawn',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29163',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3990000',
                'longitude' => '-80.3457000',
                'city' => 'Vance',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29048',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3990000',
                'longitude' => '-80.3457000',
                'city' => 'Eutawville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29583',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9271000',
                'longitude' => '-81.0252000',
                'city' => 'Pamplico',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29168',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9632000',
                'longitude' => '-80.4640000',
                'city' => 'Wedgefield',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29142',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3237000',
                'longitude' => '-80.4081000',
                'city' => 'Santee',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29059',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3237000',
                'longitude' => '-80.4081000',
                'city' => 'Holly Hill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29062',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9881000',
                'longitude' => '-80.4910000',
                'city' => 'Horatio',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29152',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9881000',
                'longitude' => '-80.4910000',
                'city' => 'Shaw A F B',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29129',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5573000',
                'longitude' => '-81.7258000',
                'city' => 'Ridge Spring',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29303',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0486000',
                'longitude' => '-81.1096000',
                'city' => 'Spartanburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29902',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9271000',
                'longitude' => '-81.0252000',
                'city' => 'Beaufort',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29550',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Hartsville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29488',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2494000',
                'longitude' => '-80.6098000',
                'city' => 'Walterboro',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29455',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2426000',
                'longitude' => '-81.3619000',
                'city' => 'Johns Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29164',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6532000',
                'longitude' => '-81.3663000',
                'city' => 'Wagener',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29717',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9848000',
                'longitude' => '-81.4147000',
                'city' => 'Hickory Grove',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29053',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7324000',
                'longitude' => '-81.1016000',
                'city' => 'Gaston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29123',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7324000',
                'longitude' => '-81.1016000',
                'city' => 'Pelion',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29160',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7324000',
                'longitude' => '-81.1016000',
                'city' => 'Swansea',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29414',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2426000',
                'longitude' => '-81.3619000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29827',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.0057000',
                'longitude' => '-81.3087000',
                'city' => 'Fairfax',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29849',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.0057000',
                'longitude' => '-81.3087000',
                'city' => 'Ulmer',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29945',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3843000',
                'longitude' => '-81.0819000',
                'city' => 'Yemassee',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29822',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5029000',
                'longitude' => '-81.8725000',
                'city' => 'Clearwater',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29834',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5029000',
                'longitude' => '-81.8725000',
                'city' => 'Langley',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29816',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5029000',
                'longitude' => '-81.8725000',
                'city' => 'Bath',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29944',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Varnville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29921',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7544000',
                'longitude' => '-81.2276000',
                'city' => 'Furman',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29922',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7544000',
                'longitude' => '-81.2276000',
                'city' => 'Garnett',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29932',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7544000',
                'longitude' => '-81.2276000',
                'city' => 'Luray',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29923',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7544000',
                'longitude' => '-81.2276000',
                'city' => 'Gifford',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29911',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7544000',
                'longitude' => '-81.2276000',
                'city' => 'Brunson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29934',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7544000',
                'longitude' => '-81.2276000',
                'city' => 'Pineland',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29918',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7544000',
                'longitude' => '-81.2276000',
                'city' => 'Estill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29726',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9952000',
                'longitude' => '-81.2441000',
                'city' => 'Mc Connells',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29846',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.9594000',
                'longitude' => '-81.2397000',
                'city' => 'Sycamore',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29015',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3765000',
                'longitude' => '-81.0878000',
                'city' => 'Blair',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29835',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7900000',
                'longitude' => '-81.9314000',
                'city' => 'Mc Cormick',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29838',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7900000',
                'longitude' => '-81.9314000',
                'city' => 'Modoc',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29061',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9586000',
                'longitude' => '-80.9362000',
                'city' => 'Hopkins',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29743',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9502000',
                'longitude' => '-81.3355000',
                'city' => 'Smyrna',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29742',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9502000',
                'longitude' => '-81.3355000',
                'city' => 'Sharon',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29850',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5608000',
                'longitude' => '-81.8068000',
                'city' => 'Vaucluse',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29116',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4910000',
                'longitude' => '-80.8535000',
                'city' => 'Orangeburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29166',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8517000',
                'longitude' => '-81.6610000',
                'city' => 'Ward',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29105',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8517000',
                'longitude' => '-81.6610000',
                'city' => 'Monetta',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29178',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5039000',
                'longitude' => '-81.6128000',
                'city' => 'Whitmire',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29808',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5127000',
                'longitude' => '-81.9553000',
                'city' => 'Aiken',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29936',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0099000',
                'longitude' => '-81.0341000',
                'city' => 'Ridgeland',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29172',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'West Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29216',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29207',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0189000',
                'longitude' => '-80.9695000',
                'city' => 'Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29536',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9166000',
                'longitude' => '-80.3439000',
                'city' => 'Dillon',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29573',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9166000',
                'longitude' => '-80.3439000',
                'city' => 'Minturn',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29928',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9840000',
                'longitude' => '-81.2356000',
                'city' => 'Hilton Head Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29813',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3295000',
                'longitude' => '-81.1446000',
                'city' => 'Hilda',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29030',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5645000',
                'longitude' => '-80.7147000',
                'city' => 'Cameron',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29047',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5645000',
                'longitude' => '-80.7147000',
                'city' => 'Elloree',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29018',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3475000',
                'longitude' => '-80.6812000',
                'city' => 'Bowman',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29916',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8714000',
                'longitude' => '-81.1113000',
                'city' => 'Early Branch',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29147',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0821000',
                'longitude' => '-80.9875000',
                'city' => 'State Park',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29171',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0011000',
                'longitude' => '-81.0276000',
                'city' => 'West Columbia',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29424',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29425',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29556',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6681000',
                'longitude' => '-79.8204000',
                'city' => 'Kingstree',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29418',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8576000',
                'longitude' => '-79.9859000',
                'city' => 'North Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29405',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8576000',
                'longitude' => '-79.9859000',
                'city' => 'North Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29575',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7006000',
                'longitude' => '-78.8868000',
                'city' => 'Myrtle Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29501',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1994000',
                'longitude' => '-79.7695000',
                'city' => 'Florence',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29505',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1994000',
                'longitude' => '-79.7695000',
                'city' => 'Florence',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29420',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8652000',
                'longitude' => '-80.0511000',
                'city' => 'North Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29404',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8652000',
                'longitude' => '-80.0511000',
                'city' => 'Charleston Afb',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29910',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.2857000',
                'longitude' => '-81.0802000',
                'city' => 'Bluffton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29927',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.2857000',
                'longitude' => '-81.0802000',
                'city' => 'Hardeeville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29464',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Mount Pleasant',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29466',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Mount Pleasant',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29530',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9133000',
                'longitude' => '-79.7526000',
                'city' => 'Coward',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29560',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9133000',
                'longitude' => '-79.7526000',
                'city' => 'Lake City',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29518',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9133000',
                'longitude' => '-79.7526000',
                'city' => 'Cades',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29591',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9133000',
                'longitude' => '-79.7526000',
                'city' => 'Scranton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29541',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9133000',
                'longitude' => '-79.7526000',
                'city' => 'Effingham',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29572',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7405000',
                'longitude' => '-78.8296000',
                'city' => 'Myrtle Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29588',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6276000',
                'longitude' => '-79.0344000',
                'city' => 'Myrtle Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29576',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6276000',
                'longitude' => '-79.0344000',
                'city' => 'Murrells Inlet',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29492',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7937000',
                'longitude' => '-79.8660000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29510',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4969000',
                'longitude' => '-79.5394000',
                'city' => 'Andrews',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29579',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6942000',
                'longitude' => '-78.8851000',
                'city' => 'Myrtle Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29403',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29451',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Isle Of Palms',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29485',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Summerville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29407',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29406',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29412',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29912',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4785000',
                'longitude' => '-80.9862000',
                'city' => 'Coosawhatchie',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29905',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4336000',
                'longitude' => '-80.6744000',
                'city' => 'Beaufort',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29906',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4336000',
                'longitude' => '-80.6744000',
                'city' => 'Beaufort',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29585',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4716000',
                'longitude' => '-79.1091000',
                'city' => 'Pawleys Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29440',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3756000',
                'longitude' => '-79.2928000',
                'city' => 'Georgetown',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29578',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6942000',
                'longitude' => '-78.8851000',
                'city' => 'Myrtle Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29056',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.5799000',
                'longitude' => '-79.9914000',
                'city' => 'Greeleyville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29926',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.1745000',
                'longitude' => '-80.7344000',
                'city' => 'Hilton Head Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29527',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8376000',
                'longitude' => '-79.0499000',
                'city' => 'Conway',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29566',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8484000',
                'longitude' => '-78.6480000',
                'city' => 'Little River',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29582',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8484000',
                'longitude' => '-78.6480000',
                'city' => 'North Myrtle Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29520',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6927000',
                'longitude' => '-79.8927000',
                'city' => 'Cheraw',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29402',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4409000',
                'longitude' => '-80.6883000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29479',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2835000',
                'longitude' => '-79.6883000',
                'city' => 'Saint Stephen',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29453',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2835000',
                'longitude' => '-79.6883000',
                'city' => 'Jamestown',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29943',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4824000',
                'longitude' => '-80.9834000',
                'city' => 'Tillman',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29483',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Summerville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29456',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Ladson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29567',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5382000',
                'longitude' => '-79.2914000',
                'city' => 'Little Rock',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29570',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7555000',
                'longitude' => '-79.6192000',
                'city' => 'Mc Coll',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '28343',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7555000',
                'longitude' => '-79.6192000',
                'city' => 'Gibson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29512',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7555000',
                'longitude' => '-79.6192000',
                'city' => 'Bennettsville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29445',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7809000',
                'longitude' => '-79.9334000',
                'city' => 'Goose Creek',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29401',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7809000',
                'longitude' => '-79.9334000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29563',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3412000',
                'longitude' => '-79.1672000',
                'city' => 'Lake View',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29506',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2181000',
                'longitude' => '-79.7946000',
                'city' => 'Florence',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29457',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Johns Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29565',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1808000',
                'longitude' => '-79.3973000',
                'city' => 'Latta',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29574',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1808000',
                'longitude' => '-79.3973000',
                'city' => 'Mullins',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29571',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1808000',
                'longitude' => '-79.3973000',
                'city' => 'Marion',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29925',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.1745000',
                'longitude' => '-80.7344000',
                'city' => 'Hilton Head Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29461',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.1997000',
                'longitude' => '-80.0089000',
                'city' => 'Moncks Corner',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29525',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5835000',
                'longitude' => '-79.5408000',
                'city' => 'Clio',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29593',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5178000',
                'longitude' => '-79.8492000',
                'city' => 'Society Hill',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29161',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1341000',
                'longitude' => '-79.9446000',
                'city' => 'Timmonsville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29596',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6980000',
                'longitude' => '-79.8820000',
                'city' => 'Wallace',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29935',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4336000',
                'longitude' => '-80.6744000',
                'city' => 'Port Royal',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29540',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3762000',
                'longitude' => '-80.0749000',
                'city' => 'Darlington',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29009',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4180000',
                'longitude' => '-80.3513000',
                'city' => 'Bethune',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29101',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4681000',
                'longitude' => '-80.2615000',
                'city' => 'Mc Bee',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29434',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.1016000',
                'longitude' => '-79.8040000',
                'city' => 'Cordesville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29450',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.1016000',
                'longitude' => '-79.8040000',
                'city' => 'Huger',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29709',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7339000',
                'longitude' => '-80.0856000',
                'city' => 'Chesterfield',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29569',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.7204000',
                'longitude' => '-78.9436000',
                'city' => 'Loris',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29487',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Wadmalaw Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29516',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5170000',
                'longitude' => '-79.6517000',
                'city' => 'Blenheim',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29436',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4240000',
                'longitude' => '-80.1263000',
                'city' => 'Cross',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29468',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.4240000',
                'longitude' => '-80.1263000',
                'city' => 'Pineville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29511',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0001000',
                'longitude' => '-79.2003000',
                'city' => 'Aynor',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29544',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0001000',
                'longitude' => '-79.2003000',
                'city' => 'Galivants Ferry',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29546',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9792000',
                'longitude' => '-79.3544000',
                'city' => 'Gresham',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29590',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6667000',
                'longitude' => '-79.8280000',
                'city' => 'Salters',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29564',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6667000',
                'longitude' => '-79.8280000',
                'city' => 'Lane',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29555',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8185000',
                'longitude' => '-79.4513000',
                'city' => 'Johnsonville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29111',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6681000',
                'longitude' => '-79.8204000',
                'city' => 'New Zion',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29580',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6681000',
                'longitude' => '-79.8204000',
                'city' => 'Nesmith',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29554',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8185000',
                'longitude' => '-79.4513000',
                'city' => 'Hemingway',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29568',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8644000',
                'longitude' => '-78.7277000',
                'city' => 'Longs',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29532',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3009000',
                'longitude' => '-79.8692000',
                'city' => 'Darlington',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29545',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1909000',
                'longitude' => '-79.0598000',
                'city' => 'Green Sea',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29581',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1909000',
                'longitude' => '-79.0598000',
                'city' => 'Nichols',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29114',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.9334000',
                'longitude' => '-79.9326000',
                'city' => 'Olanta',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29470',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7847000',
                'longitude' => '-80.0014000',
                'city' => 'Ravenel',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29449',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7847000',
                'longitude' => '-80.0014000',
                'city' => 'Hollywood',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29551',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8440000',
                'longitude' => '-79.0516000',
                'city' => 'Hartsville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29437',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2154000',
                'longitude' => '-80.4491000',
                'city' => 'Dorchester',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29448',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2154000',
                'longitude' => '-80.4491000',
                'city' => 'Harleyville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29543',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2053000',
                'longitude' => '-79.2597000',
                'city' => 'Fork',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29940',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4611000',
                'longitude' => '-80.7884000',
                'city' => 'Seabrook',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29547',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4152000',
                'longitude' => '-79.3673000',
                'city' => 'Hamer',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29907',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4350000',
                'longitude' => '-80.6670000',
                'city' => 'Ladys Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29435',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.9319000',
                'longitude' => '-80.4847000',
                'city' => 'Cottageville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29584',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5717000',
                'longitude' => '-80.0452000',
                'city' => 'Patrick',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29920',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4030000',
                'longitude' => '-80.5754000',
                'city' => 'Saint Helena Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29909',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.2335000',
                'longitude' => '-80.8571000',
                'city' => 'Okatie',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29482',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Sullivans Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29472',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Ridgeville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29458',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.3693000',
                'longitude' => '-79.2911000',
                'city' => 'Mc Clellanville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29594',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6700000',
                'longitude' => '-79.5398000',
                'city' => 'Tatum',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29474',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.9549000',
                'longitude' => '-80.6723000',
                'city' => 'Round O',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29475',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.9549000',
                'longitude' => '-80.6723000',
                'city' => 'Ruffin',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29162',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.8951000',
                'longitude' => '-80.0141000',
                'city' => 'Turbeville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29477',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.1845000',
                'longitude' => '-80.5755000',
                'city' => 'Saint George',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '30426',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.2004000',
                'longitude' => '-79.2503000',
                'city' => 'Girard',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29493',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.0330000',
                'longitude' => '-80.8528000',
                'city' => 'Williams',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29481',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.0330000',
                'longitude' => '-80.8528000',
                'city' => 'Smoaks',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29471',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.1845000',
                'longitude' => '-80.5755000',
                'city' => 'Reevesville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29431',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.2811000',
                'longitude' => '-79.8768000',
                'city' => 'Bonneau',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29901',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4336000',
                'longitude' => '-80.6744000',
                'city' => 'Beaufort',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29439',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.6559000',
                'longitude' => '-79.9424000',
                'city' => 'Folly Beach',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29438',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4841000',
                'longitude' => '-80.3309000',
                'city' => 'Edisto Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29429',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Awendaw',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29592',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1994000',
                'longitude' => '-79.7695000',
                'city' => 'Sellers',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29741',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7422000',
                'longitude' => '-80.1849000',
                'city' => 'Ruby',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29727',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7422000',
                'longitude' => '-80.1849000',
                'city' => 'Mount Croghan',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29728',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6500000',
                'longitude' => '-80.3927000',
                'city' => 'Pageland',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29607',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29409',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8576000',
                'longitude' => '-79.9859000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29469',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.1997000',
                'longitude' => '-80.0089000',
                'city' => 'Pinopolis',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29915',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.1745000',
                'longitude' => '-80.7344000',
                'city' => 'Daufuskie Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29422',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29416',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29938',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.1745000',
                'longitude' => '-80.7344000',
                'city' => 'Hilton Head Island',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29413',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7922000',
                'longitude' => '-79.9443000',
                'city' => 'Charleston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29446',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8108000',
                'longitude' => '-80.7262000',
                'city' => 'Green Pond',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29941',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.4611000',
                'longitude' => '-80.7884000',
                'city' => 'Sheldon',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29929',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.0673000',
                'longitude' => '-80.9498000',
                'city' => 'Islandton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29082',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.0673000',
                'longitude' => '-80.9498000',
                'city' => 'Lodge',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29426',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.7348000',
                'longitude' => '-80.2440000',
                'city' => 'Adams Run',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29452',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '32.8513000',
                'longitude' => '-80.5876000',
                'city' => 'Jacksonboro',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29502',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1994000',
                'longitude' => '-79.7695000',
                'city' => 'Florence',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29325',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4757000',
                'longitude' => '-81.8873000',
                'city' => 'Clinton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29617',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29611',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29621',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5021000',
                'longitude' => '-82.6513000',
                'city' => 'Anderson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29626',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5021000',
                'longitude' => '-82.6513000',
                'city' => 'Anderson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29301',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9489000',
                'longitude' => '-81.9321000',
                'city' => 'Spartanburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29341',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.0718000',
                'longitude' => '-81.6520000',
                'city' => 'Gaffney',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29330',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.0718000',
                'longitude' => '-81.6520000',
                'city' => 'Cowpens',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29340',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.0718000',
                'longitude' => '-81.6520000',
                'city' => 'Gaffney',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29630',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7243000',
                'longitude' => '-82.7773000',
                'city' => 'Central',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29302',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9543000',
                'longitude' => '-81.9216000',
                'city' => 'Spartanburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29681',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8271000',
                'longitude' => '-82.3020000',
                'city' => 'Simpsonville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29662',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8271000',
                'longitude' => '-82.3020000',
                'city' => 'Mauldin',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29650',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8271000',
                'longitude' => '-82.3020000',
                'city' => 'Greer',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29651',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8271000',
                'longitude' => '-82.3020000',
                'city' => 'Greer',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29615',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8271000',
                'longitude' => '-82.3020000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29673',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8472000',
                'longitude' => '-82.4617000',
                'city' => 'Piedmont',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29605',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8472000',
                'longitude' => '-82.4617000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29640',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8472000',
                'longitude' => '-82.4617000',
                'city' => 'Easley',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29642',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8472000',
                'longitude' => '-82.4617000',
                'city' => 'Easley',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29624',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5021000',
                'longitude' => '-82.6513000',
                'city' => 'Anderson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29625',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5021000',
                'longitude' => '-82.6513000',
                'city' => 'Anderson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29657',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5021000',
                'longitude' => '-82.6513000',
                'city' => 'Liberty',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29622',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5021000',
                'longitude' => '-82.6513000',
                'city' => 'Anderson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29627',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5147000',
                'longitude' => '-82.6552000',
                'city' => 'Belton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29670',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5147000',
                'longitude' => '-82.6552000',
                'city' => 'Pendleton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29646',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1907000',
                'longitude' => '-82.1639000',
                'city' => 'Greenwood',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29649',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1907000',
                'longitude' => '-82.1639000',
                'city' => 'Greenwood',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29819',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1692000',
                'longitude' => '-82.1422000',
                'city' => 'Bradley',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29666',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1692000',
                'longitude' => '-82.1422000',
                'city' => 'Ninety Six',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29848',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1692000',
                'longitude' => '-82.1422000',
                'city' => 'Troy',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29680',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7395000',
                'longitude' => '-82.2549000',
                'city' => 'Simpsonville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29653',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1907000',
                'longitude' => '-82.1639000',
                'city' => 'Hodges',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29388',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Woodruff',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29697',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5147000',
                'longitude' => '-82.6552000',
                'city' => 'Williamston',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29609',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8541000',
                'longitude' => '-82.3997000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29669',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Pelzer',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29654',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Honea Path',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29644',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Fountain Inn',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29687',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9037000',
                'longitude' => '-82.3376000',
                'city' => 'Taylors',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29678',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6912000',
                'longitude' => '-82.9498000',
                'city' => 'Seneca',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29691',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6912000',
                'longitude' => '-82.9498000',
                'city' => 'Walhalla',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29602',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8564000',
                'longitude' => '-82.4045000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29365',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9497000',
                'longitude' => '-82.1277000',
                'city' => 'Lyman',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29306',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9543000',
                'longitude' => '-81.9216000',
                'city' => 'Spartanburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29307',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9543000',
                'longitude' => '-81.9216000',
                'city' => 'Spartanburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29316',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9840000',
                'longitude' => '-82.0241000',
                'city' => 'Boiling Springs',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29672',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6912000',
                'longitude' => '-82.9498000',
                'city' => 'Seneca',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29643',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5283000',
                'longitude' => '-82.8459000',
                'city' => 'Fair Play',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29689',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5283000',
                'longitude' => '-82.8459000',
                'city' => 'Townville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29690',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8541000',
                'longitude' => '-82.3997000',
                'city' => 'Travelers Rest',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29684',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4399000',
                'longitude' => '-82.6118000',
                'city' => 'Starr',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29655',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4399000',
                'longitude' => '-82.6118000',
                'city' => 'Iva',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29620',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.1821000',
                'longitude' => '-82.3830000',
                'city' => 'Abbeville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29037',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Chappells',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29844',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6938000',
                'longitude' => '-82.1979000',
                'city' => 'Parksville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29845',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '33.6938000',
                'longitude' => '-82.1979000',
                'city' => 'Plum Branch',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29360',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4991000',
                'longitude' => '-82.0198000',
                'city' => 'Laurens',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29370',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3594000',
                'longitude' => '-81.9656000',
                'city' => 'Mountville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29374',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9543000',
                'longitude' => '-81.9216000',
                'city' => 'Pauline',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29659',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3072000',
                'longitude' => '-82.6677000',
                'city' => 'Lowndesville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29616',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29608',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9048000',
                'longitude' => '-82.4592000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29628',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.5021000',
                'longitude' => '-82.6513000',
                'city' => 'Calhoun Falls',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29639',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3312000',
                'longitude' => '-82.3924000',
                'city' => 'Due West',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29638',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3312000',
                'longitude' => '-82.3924000',
                'city' => 'Donalds',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29840',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.0431000',
                'longitude' => '-82.5337000',
                'city' => 'Mount Carmel',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29645',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6968000',
                'longitude' => '-82.2013000',
                'city' => 'Gray Court',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29376',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9489000',
                'longitude' => '-81.9321000',
                'city' => 'Roebuck',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29676',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Salem',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29349',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Inman',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29321',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7185000',
                'longitude' => '-81.6125000',
                'city' => 'Buffalo',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29353',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7185000',
                'longitude' => '-81.6125000',
                'city' => 'Jonesville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29323',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9489000',
                'longitude' => '-81.9321000',
                'city' => 'Chesnee',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29369',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9086000',
                'longitude' => '-82.0990000',
                'city' => 'Moore',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29334',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9086000',
                'longitude' => '-82.0990000',
                'city' => 'Duncan',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29375',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9086000',
                'longitude' => '-82.0990000',
                'city' => 'Reidville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29385',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9552000',
                'longitude' => '-82.1172000',
                'city' => 'Wellford',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29692',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3982000',
                'longitude' => '-82.2472000',
                'city' => 'Ware Shoals',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29322',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.1761000',
                'longitude' => '-82.1843000',
                'city' => 'Campobello',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29356',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.1761000',
                'longitude' => '-82.1843000',
                'city' => 'Landrum',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29373',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9197000',
                'longitude' => '-81.7454000',
                'city' => 'Pacolet Mills',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29372',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9197000',
                'longitude' => '-81.7454000',
                'city' => 'Pacolet',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29682',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8070000',
                'longitude' => '-82.8153000',
                'city' => 'Six Mile',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29671',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8847000',
                'longitude' => '-82.7012000',
                'city' => 'Pickens',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29346',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9917000',
                'longitude' => '-81.9857000',
                'city' => 'Glendale',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29324',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9917000',
                'longitude' => '-81.9857000',
                'city' => 'Clifton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29364',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7817000',
                'longitude' => '-81.4605000',
                'city' => 'Lockhart',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29333',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9543000',
                'longitude' => '-81.9216000',
                'city' => 'Drayton',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29319',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9543000',
                'longitude' => '-81.9216000',
                'city' => 'Spartanburg',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29693',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6644000',
                'longitude' => '-83.0916000',
                'city' => 'Westminster',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29378',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.9489000',
                'longitude' => '-81.9321000',
                'city' => 'Una',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29631',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6925000',
                'longitude' => '-82.8323000',
                'city' => 'Clemson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29604',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8501000',
                'longitude' => '-82.4026000',
                'city' => 'Greenville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29696',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7640000',
                'longitude' => '-83.0662000',
                'city' => 'West Union',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29664',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7640000',
                'longitude' => '-83.0662000',
                'city' => 'Mountain Rest',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29667',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.7267000',
                'longitude' => '-82.7821000',
                'city' => 'Norris',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29658',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6628000',
                'longitude' => '-83.0993000',
                'city' => 'Long Creek',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29665',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6925000',
                'longitude' => '-82.8323000',
                'city' => 'Newry',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29652',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8588000',
                'longitude' => '-82.4093000',
                'city' => 'Greer',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29634',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6846000',
                'longitude' => '-82.8380000',
                'city' => 'Clemson',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29685',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8588000',
                'longitude' => '-82.4093000',
                'city' => 'Sunset',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29384',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3574000',
                'longitude' => '-82.0579000',
                'city' => 'Waterloo',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29355',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4169000',
                'longitude' => '-81.8132000',
                'city' => 'Kinards',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29351',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.4169000',
                'longitude' => '-81.8132000',
                'city' => 'Joanna',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29368',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.1482000',
                'longitude' => '-81.8586000',
                'city' => 'Mayo',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29679',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6912000',
                'longitude' => '-82.9498000',
                'city' => 'Seneca',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29661',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.0333000',
                'longitude' => '-82.5029000',
                'city' => 'Marietta',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29635',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.0333000',
                'longitude' => '-82.5029000',
                'city' => 'Cleveland',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29683',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.0333000',
                'longitude' => '-82.5029000',
                'city' => 'Slater',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29686',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.8908000',
                'longitude' => '-82.9759000',
                'city' => 'Tamassee',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29331',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6581000',
                'longitude' => '-81.9624000',
                'city' => 'Cross Anchor',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29335',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.6581000',
                'longitude' => '-81.9624000',
                'city' => 'Enoree',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29688',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '35.0314000',
                'longitude' => '-82.3033000',
                'city' => 'Tigerville',
                'full_state' => 'South Carolina',
            ],
            [
                'zip' => '29332',
                'country_code' => 'US',
                'state' => 'SC',
                'latitude' => '34.3594000',
                'longitude' => '-81.9656000',
                'city' => 'Cross Hill',
                'full_state' => 'South Carolina',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
