<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RhodeIslandSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '2893',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6624000',
                'longitude' => '-71.4526000',
                'city' => 'West Warwick',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2886',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6624000',
                'longitude' => '-71.4526000',
                'city' => 'Warwick',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2904',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8565000',
                'longitude' => '-71.4850000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2919',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8565000',
                'longitude' => '-71.4850000',
                'city' => 'Johnston',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2831',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7085000',
                'longitude' => '-71.5204000',
                'city' => 'Hope',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2816',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7085000',
                'longitude' => '-71.5204000',
                'city' => 'Coventry',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2874',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4401000',
                'longitude' => '-71.4900000',
                'city' => 'Saunderstown',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2879',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4401000',
                'longitude' => '-71.4900000',
                'city' => 'Wakefield',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2812',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4550000',
                'longitude' => '-71.6618000',
                'city' => 'Carolina',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2906',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2907',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2813',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.1724000',
                'longitude' => '-71.5680000',
                'city' => 'Charlestown',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2832',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.5088000',
                'longitude' => '-71.7133000',
                'city' => 'Hope Valley',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2911',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4550000',
                'longitude' => '-71.6618000',
                'city' => 'North Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2909',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8167000',
                'longitude' => '-71.4180000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2895',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '42.0060000',
                'longitude' => '-71.5109000',
                'city' => 'Woonsocket',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2814',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9154000',
                'longitude' => '-71.7914000',
                'city' => 'Chepachet',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2903',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2860',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Pawtucket',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2908',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2920',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Cranston',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2910',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Cranston',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2888',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Warwick',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2914',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'East Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2901',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2905',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2840',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Newport',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2703',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8160000',
                'longitude' => '-71.4266000',
                'city' => 'Attleboro',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2917',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8600000',
                'longitude' => '-71.4811000',
                'city' => 'Smithfield',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2828',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8600000',
                'longitude' => '-71.4811000',
                'city' => 'Greenville',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2824',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '42.0060000',
                'longitude' => '-71.5109000',
                'city' => 'Forestdale',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2896',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '42.0060000',
                'longitude' => '-71.5109000',
                'city' => 'North Smithfield',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2885',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7314000',
                'longitude' => '-71.2748000',
                'city' => 'Warren',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2806',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7314000',
                'longitude' => '-71.2748000',
                'city' => 'Barrington',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2871',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6081000',
                'longitude' => '-71.2443000',
                'city' => 'Portsmouth',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2809',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7314000',
                'longitude' => '-71.2748000',
                'city' => 'Bristol',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2864',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9747000',
                'longitude' => '-71.4582000',
                'city' => 'Cumberland',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2815',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8318000',
                'longitude' => '-71.5908000',
                'city' => 'Clayville',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2889',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8174000',
                'longitude' => '-71.4093000',
                'city' => 'Warwick',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2822',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.5654000',
                'longitude' => '-71.4560000',
                'city' => 'Exeter',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2852',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.5654000',
                'longitude' => '-71.4560000',
                'city' => 'North Kingstown',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2916',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6681000',
                'longitude' => '-71.5014000',
                'city' => 'Rumford',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2915',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6681000',
                'longitude' => '-71.5014000',
                'city' => 'Riverside',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2921',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6681000',
                'longitude' => '-71.5014000',
                'city' => 'Cranston',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2902',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2891',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Westerly',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2859',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Pascoag',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2842',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Middletown',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2882',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Narragansett',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2837',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.5031000',
                'longitude' => '-71.1859000',
                'city' => 'Little Compton',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2892',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4401000',
                'longitude' => '-71.4900000',
                'city' => 'West Kingston',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2861',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Pawtucket',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2835',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4951000',
                'longitude' => '-71.3675000',
                'city' => 'Jamestown',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2880',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Wakefield',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2878',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6681000',
                'longitude' => '-71.5014000',
                'city' => 'Tiverton',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2865',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8775000',
                'longitude' => '-71.3829000',
                'city' => 'Lincoln',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2808',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.3761000',
                'longitude' => '-71.8326000',
                'city' => 'Bradford',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2877',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.5689000',
                'longitude' => '-71.4522000',
                'city' => 'Slocum',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2802',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9385000',
                'longitude' => '-71.4267000',
                'city' => 'Albion',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2838',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9385000',
                'longitude' => '-71.4267000',
                'city' => 'Manville',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2894',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4550000',
                'longitude' => '-71.6618000',
                'city' => 'Wood River Junction',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2875',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4550000',
                'longitude' => '-71.6618000',
                'city' => 'Shannock',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2836',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4550000',
                'longitude' => '-71.6618000',
                'city' => 'Kenyon',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2833',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4223000',
                'longitude' => '-71.7831000',
                'city' => 'Hopkinton',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2804',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4223000',
                'longitude' => '-71.7831000',
                'city' => 'Ashaway',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2827',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7086000',
                'longitude' => '-71.6383000',
                'city' => 'Greene',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2825',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7086000',
                'longitude' => '-71.6383000',
                'city' => 'Foster',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2817',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.7086000',
                'longitude' => '-71.6383000',
                'city' => 'West Greenwich',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2818',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6681000',
                'longitude' => '-71.5014000',
                'city' => 'East Greenwich',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2912',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2807',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.1696000',
                'longitude' => '-71.5632000',
                'city' => 'Block Island',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2863',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8775000',
                'longitude' => '-71.3829000',
                'city' => 'Central Falls',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2898',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.5088000',
                'longitude' => '-71.7133000',
                'city' => 'Wyoming',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2873',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.5088000',
                'longitude' => '-71.7133000',
                'city' => 'Rockville',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2858',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9551000',
                'longitude' => '-71.7008000',
                'city' => 'Oakland',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2830',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9551000',
                'longitude' => '-71.7008000',
                'city' => 'Harrisville',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2826',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9551000',
                'longitude' => '-71.7008000',
                'city' => 'Glendale',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2839',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.9551000',
                'longitude' => '-71.7008000',
                'city' => 'Mapleville',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2823',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6681000',
                'longitude' => '-71.5014000',
                'city' => 'Fiskeville',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2857',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8318000',
                'longitude' => '-71.5908000',
                'city' => 'North Scituate',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2872',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.6202000',
                'longitude' => '-71.2547000',
                'city' => 'Prudence Island',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2881',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4401000',
                'longitude' => '-71.4900000',
                'city' => 'Kingston',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2841',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.4901000',
                'longitude' => '-71.3102000',
                'city' => 'Newport',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2918',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8203000',
                'longitude' => '-71.4141000',
                'city' => 'Providence',
                'full_state' => 'Rhode Island',
            ],
            [
                'zip' => '2829',
                'country_code' => 'US',
                'state' => 'RI',
                'latitude' => '41.8588000',
                'longitude' => '-71.5772000',
                'city' => 'Harmony',
                'full_state' => 'Rhode Island',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
