<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NorthDakotaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '58104',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58103',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58318',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8252000',
                'longitude' => '-100.4363000',
                'city' => 'Bottineau',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58501',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8077000',
                'longitude' => '-100.7869000',
                'city' => 'Bismarck',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58503',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8077000',
                'longitude' => '-100.7869000',
                'city' => 'Bismarck',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58205',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9236000',
                'longitude' => '-97.0310000',
                'city' => 'Grand Forks Afb',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58201',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9236000',
                'longitude' => '-97.0310000',
                'city' => 'Grand Forks',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58623',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1828000',
                'longitude' => '-103.3930000',
                'city' => 'Bowman',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58530',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1158000',
                'longitude' => '-101.2337000',
                'city' => 'Center',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58368',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3674000',
                'longitude' => '-100.0002000',
                'city' => 'Rugby',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58650',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4247000',
                'longitude' => '-102.5515000',
                'city' => 'Regent',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58474',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1386000',
                'longitude' => '-98.0919000',
                'city' => 'Oakes',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58102',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58203',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9154000',
                'longitude' => '-97.0385000',
                'city' => 'Grand Forks',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58852',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3983000',
                'longitude' => '-102.9378000',
                'city' => 'Tioga',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58734',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5897000',
                'longitude' => '-102.1095000',
                'city' => 'Donnybrook',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58621',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9168000',
                'longitude' => '-104.0104000',
                'city' => 'Beach',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58502',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8279000',
                'longitude' => '-100.7696000',
                'city' => 'Bismarck',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58504',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8279000',
                'longitude' => '-100.7696000',
                'city' => 'Bismarck',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58630',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8814000',
                'longitude' => '-102.7865000',
                'city' => 'Gladstone',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58601',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8814000',
                'longitude' => '-102.7865000',
                'city' => 'Dickinson',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58384',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8077000',
                'longitude' => '-100.7869000',
                'city' => 'Willow City',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58783',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8268000',
                'longitude' => '-100.4428000',
                'city' => 'Souris',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58233',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2071000',
                'longitude' => '-97.7906000',
                'city' => 'Forest River',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58231',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2071000',
                'longitude' => '-97.7906000',
                'city' => 'Fordville',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58301',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1074000',
                'longitude' => '-98.8575000',
                'city' => 'Devils Lake',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58105',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8779000',
                'longitude' => '-96.7852000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58122',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8779000',
                'longitude' => '-96.7852000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58106',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '56560',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Moorhead',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58078',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'West Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58107',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58109',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58761',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2337000',
                'longitude' => '-101.2918000',
                'city' => 'Mohall',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58793',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2337000',
                'longitude' => '-101.2918000',
                'city' => 'Westhope',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58703',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2337000',
                'longitude' => '-101.2918000',
                'city' => 'Minot',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58041',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0673000',
                'longitude' => '-96.9003000',
                'city' => 'Hankinson',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58058',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0673000',
                'longitude' => '-96.9003000',
                'city' => 'Mantador',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58030',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0673000',
                'longitude' => '-96.9003000',
                'city' => 'Fairmount',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58316',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8081000',
                'longitude' => '-100.0561000',
                'city' => 'Belcourt',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58369',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8081000',
                'longitude' => '-100.0561000',
                'city' => 'Saint John',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58366',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8081000',
                'longitude' => '-100.0561000',
                'city' => 'Rolette',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58329',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8081000',
                'longitude' => '-100.0561000',
                'city' => 'Dunseith',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58711',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9078000',
                'longitude' => '-101.0180000',
                'city' => 'Antler',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58344',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0391000',
                'longitude' => '-98.3414000',
                'city' => 'Lakota',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58249',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0391000',
                'longitude' => '-98.3414000',
                'city' => 'Langdon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58261',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2877000',
                'longitude' => '-97.3688000',
                'city' => 'Minto',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58237',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2877000',
                'longitude' => '-97.3688000',
                'city' => 'Grafton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58332',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0345000',
                'longitude' => '-99.7643000',
                'city' => 'Esmond',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58420',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9072000',
                'longitude' => '-98.7062000',
                'city' => 'Buchanan',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58401',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9072000',
                'longitude' => '-98.7062000',
                'city' => 'Jamestown',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58552',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2691000',
                'longitude' => '-100.2344000',
                'city' => 'Linton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58236',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6177000',
                'longitude' => '-97.4453000',
                'city' => 'Glasston',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58241',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6177000',
                'longitude' => '-97.4453000',
                'city' => 'Hensel',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58276',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6177000',
                'longitude' => '-97.4453000',
                'city' => 'Saint Thomas',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58321',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0216000',
                'longitude' => '-98.1239000',
                'city' => 'Brocket',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58250',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0216000',
                'longitude' => '-98.1239000',
                'city' => 'Lankin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58259',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0216000',
                'longitude' => '-98.1239000',
                'city' => 'Michigan',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58059',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Mapleton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58108',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Fargo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58380',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8269000',
                'longitude' => '-98.4395000',
                'city' => 'Tolna',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58361',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8269000',
                'longitude' => '-98.4395000',
                'city' => 'Pekin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58464',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8269000',
                'longitude' => '-98.4395000',
                'city' => 'Mchenry',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58238',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7923000',
                'longitude' => '-97.6191000',
                'city' => 'Hamilton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58216',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7923000',
                'longitude' => '-97.6191000',
                'city' => 'Bathgate',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58220',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7923000',
                'longitude' => '-97.6191000',
                'city' => 'Cavalier',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58331',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7862000',
                'longitude' => '-99.2421000',
                'city' => 'Egeland',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58365',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7862000',
                'longitude' => '-99.2421000',
                'city' => 'Rocklake',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58317',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7862000',
                'longitude' => '-99.2421000',
                'city' => 'Bisbee',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58367',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7862000',
                'longitude' => '-99.2421000',
                'city' => 'Rolla',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58339',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7862000',
                'longitude' => '-99.2421000',
                'city' => 'Hansboro',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58352',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7862000',
                'longitude' => '-99.2421000',
                'city' => 'Munich',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58762',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7204000',
                'longitude' => '-101.1370000',
                'city' => 'Newburg',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58760',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7204000',
                'longitude' => '-101.1370000',
                'city' => 'Maxbass',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58497',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9055000',
                'longitude' => '-98.6999000',
                'city' => 'Ypsilanti',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58266',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0216000',
                'longitude' => '-98.1239000',
                'city' => 'Niagara',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58789',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7127000',
                'longitude' => '-100.9143000',
                'city' => 'Upham',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58475',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1186000',
                'longitude' => '-99.5273000',
                'city' => 'Pettibone',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58496',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1186000',
                'longitude' => '-99.5273000',
                'city' => 'Woodworth',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58478',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1186000',
                'longitude' => '-99.5273000',
                'city' => 'Robinson',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58487',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1186000',
                'longitude' => '-99.5273000',
                'city' => 'Tappen',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58061',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2698000',
                'longitude' => '-96.8756000',
                'city' => 'Mooreton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58008',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2698000',
                'longitude' => '-96.8756000',
                'city' => 'Barney',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58075',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2698000',
                'longitude' => '-96.8756000',
                'city' => 'Wahpeton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58649',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1514000',
                'longitude' => '-103.1441000',
                'city' => 'Reeder',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58620',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1514000',
                'longitude' => '-103.1441000',
                'city' => 'Amidon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58647',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1514000',
                'longitude' => '-103.1441000',
                'city' => 'New England',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58653',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1514000',
                'longitude' => '-103.1441000',
                'city' => 'Scranton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58568',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.9229000',
                'longitude' => '-101.3532000',
                'city' => 'Selfridge',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58042',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8710000',
                'longitude' => '-96.9041000',
                'city' => 'Harwood',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58047',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8710000',
                'longitude' => '-96.9041000',
                'city' => 'Horace',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58643',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2308000',
                'longitude' => '-103.6548000',
                'city' => 'Marmarth',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58651',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2308000',
                'longitude' => '-103.6548000',
                'city' => 'Rhame',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58239',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8978000',
                'longitude' => '-98.6031000',
                'city' => 'Hannah',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58323',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8978000',
                'longitude' => '-98.6031000',
                'city' => 'Calvin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58282',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8978000',
                'longitude' => '-98.6031000',
                'city' => 'Walhalla',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58281',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8978000',
                'longitude' => '-98.6031000',
                'city' => 'Wales',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58270',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3940000',
                'longitude' => '-97.7473000',
                'city' => 'Park River',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58273',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3940000',
                'longitude' => '-97.7473000',
                'city' => 'Pisek',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58476',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2476000',
                'longitude' => '-98.9707000',
                'city' => 'Pingree',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58421',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2476000',
                'longitude' => '-98.9707000',
                'city' => 'Carrington',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58579',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1566000',
                'longitude' => '-100.5284000',
                'city' => 'Wilton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58494',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1566000',
                'longitude' => '-100.5284000',
                'city' => 'Wing',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58521',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1566000',
                'longitude' => '-100.5284000',
                'city' => 'Baldwin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58477',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1566000',
                'longitude' => '-100.5284000',
                'city' => 'Regan',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58413',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0349000',
                'longitude' => '-99.3743000',
                'city' => 'Ashley',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58045',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3977000',
                'longitude' => '-97.0584000',
                'city' => 'Hillsboro',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58602',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9211000',
                'longitude' => '-102.7241000',
                'city' => 'Dickinson',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58377',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4487000',
                'longitude' => '-98.8790000',
                'city' => 'Starkweather',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58379',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8520000',
                'longitude' => '-98.7089000',
                'city' => 'Tokio',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58374',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8520000',
                'longitude' => '-98.7089000',
                'city' => 'Sheyenne',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58381',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8520000',
                'longitude' => '-98.7089000',
                'city' => 'Warwick',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58324',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4840000',
                'longitude' => '-99.1966000',
                'city' => 'Cando',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58040',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2264000',
                'longitude' => '-97.6678000',
                'city' => 'Gwinner',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58416',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4387000',
                'longitude' => '-98.1138000',
                'city' => 'Binford',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58448',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4387000',
                'longitude' => '-98.1138000',
                'city' => 'Hannaford',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58721',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7999000',
                'longitude' => '-102.2459000',
                'city' => 'Bowbells',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58770',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9486000',
                'longitude' => '-102.1359000',
                'city' => 'Parshall',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58784',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3177000',
                'longitude' => '-102.3928000',
                'city' => 'Stanley',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58577',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2905000',
                'longitude' => '-101.0226000',
                'city' => 'Washburn',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58482',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8571000',
                'longitude' => '-99.9151000',
                'city' => 'Steele',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58228',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9167000',
                'longitude' => '-97.3733000',
                'city' => 'Emerado',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58012',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9000000',
                'longitude' => '-97.2045000',
                'city' => 'Casselton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58402',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9034000',
                'longitude' => '-98.7297000',
                'city' => 'Jamestown',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58573',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1320000',
                'longitude' => '-100.1577000',
                'city' => 'Strasburg',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58212',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7627000',
                'longitude' => '-98.1766000',
                'city' => 'Aneta',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58254',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7627000',
                'longitude' => '-98.1766000',
                'city' => 'Mcville',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58341',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7802000',
                'longitude' => '-99.9294000',
                'city' => 'Harvey',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58267',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6776000',
                'longitude' => '-97.9854000',
                'city' => 'Northwood',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58467',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8610000',
                'longitude' => '-99.6573000',
                'city' => 'Medina',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58428',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8610000',
                'longitude' => '-99.6573000',
                'city' => 'Dawson',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58505',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8077000',
                'longitude' => '-100.7869000',
                'city' => 'Bismarck',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58202',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9154000',
                'longitude' => '-97.0385000',
                'city' => 'Grand Forks',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58549',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.5464000',
                'longitude' => '-99.9502000',
                'city' => 'Kintyre',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58524',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.5464000',
                'longitude' => '-99.9502000',
                'city' => 'Braddock',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58561',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.5464000',
                'longitude' => '-99.9502000',
                'city' => 'Napoleon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58495',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.5464000',
                'longitude' => '-99.9502000',
                'city' => 'Wishek',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58746',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7999000',
                'longitude' => '-102.2459000',
                'city' => 'Kenmare',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58581',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1320000',
                'longitude' => '-100.1577000',
                'city' => 'Zeeland',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58542',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1320000',
                'longitude' => '-100.1577000',
                'city' => 'Hague',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58716',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6404000',
                'longitude' => '-101.4704000',
                'city' => 'Benedict',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58540',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6404000',
                'longitude' => '-101.4704000',
                'city' => 'Garrison',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58531',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6404000',
                'longitude' => '-101.4704000',
                'city' => 'Coleharbor',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58792',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0609000',
                'longitude' => '-100.9307000',
                'city' => 'Voltaire',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58790',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0609000',
                'longitude' => '-100.9307000',
                'city' => 'Velva',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58772',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7999000',
                'longitude' => '-102.2459000',
                'city' => 'Portal',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58705',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2337000',
                'longitude' => '-101.2918000',
                'city' => 'Minot Afb',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58251',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9058000',
                'longitude' => '-97.6286000',
                'city' => 'Larimore',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58214',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9058000',
                'longitude' => '-97.6286000',
                'city' => 'Arvilla',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58436',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0185000',
                'longitude' => '-98.5258000',
                'city' => 'Ellendale',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58272',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0132000',
                'longitude' => '-97.9973000',
                'city' => 'Petersburg',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58079',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8974000',
                'longitude' => '-97.2132000',
                'city' => 'Wheatland',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58004',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8974000',
                'longitude' => '-97.2132000',
                'city' => 'Amenia',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58563',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8134000',
                'longitude' => '-101.8358000',
                'city' => 'New Salem',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58631',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8134000',
                'longitude' => '-101.8358000',
                'city' => 'Glen Ullin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58533',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8134000',
                'longitude' => '-101.8358000',
                'city' => 'Elgin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58362',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1074000',
                'longitude' => '-98.8575000',
                'city' => 'Penn',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58370',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1074000',
                'longitude' => '-98.8575000',
                'city' => 'Saint Michael',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58439',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.9440000',
                'longitude' => '-98.7841000',
                'city' => 'Forbes',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58748',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6882000',
                'longitude' => '-100.7065000',
                'city' => 'Kramer',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58260',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4199000',
                'longitude' => '-97.4298000',
                'city' => 'Milton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58227',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4199000',
                'longitude' => '-97.4298000',
                'city' => 'Edinburg',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58731',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5092000',
                'longitude' => '-101.2165000',
                'city' => 'Deering',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58740',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5092000',
                'longitude' => '-101.2165000',
                'city' => 'Glenburn',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58559',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4843000',
                'longitude' => '-100.4447000',
                'city' => 'Mercer',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58463',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4843000',
                'longitude' => '-100.4447000',
                'city' => 'Mcclusky',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58545',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8753000',
                'longitude' => '-96.7939000',
                'city' => 'Hazen',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58077',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4680000',
                'longitude' => '-96.8734000',
                'city' => 'Walcott',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58081',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4680000',
                'longitude' => '-96.8734000',
                'city' => 'Wyndmere',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58018',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4680000',
                'longitude' => '-96.8734000',
                'city' => 'Colfax',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58440',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0300000',
                'longitude' => '-99.1664000',
                'city' => 'Fredonia',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58441',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1604000',
                'longitude' => '-98.4271000',
                'city' => 'Fullerton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58639',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.9401000',
                'longitude' => '-102.1633000',
                'city' => 'Hettinger',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '57638',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.9401000',
                'longitude' => '-102.1633000',
                'city' => 'Lemmon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58460',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2816000',
                'longitude' => '-99.3561000',
                'city' => 'Lehr',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58311',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1074000',
                'longitude' => '-98.8575000',
                'city' => 'Alsen',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58327',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1074000',
                'longitude' => '-98.8575000',
                'city' => 'Crary',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58224',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1589000',
                'longitude' => '-97.9283000',
                'city' => 'Dahlen',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58787',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7266000',
                'longitude' => '-101.8305000',
                'city' => 'Tolley',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58782',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7266000',
                'longitude' => '-101.8305000',
                'city' => 'Sherwood',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58725',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.7266000',
                'longitude' => '-101.8305000',
                'city' => 'Carpio',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58572',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8230000',
                'longitude' => '-100.2886000',
                'city' => 'Sterling',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58560',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8230000',
                'longitude' => '-100.2886000',
                'city' => 'Moffit',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58532',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8230000',
                'longitude' => '-100.2886000',
                'city' => 'Driscoll',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58558',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8279000',
                'longitude' => '-100.7696000',
                'city' => 'Menoken',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58554',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8279000',
                'longitude' => '-100.7696000',
                'city' => 'Mandan',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58423',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1425000',
                'longitude' => '-99.7788000',
                'city' => 'Chaseley',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58325',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2198000',
                'longitude' => '-99.0869000',
                'city' => 'Churchs Ferry',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58351',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2198000',
                'longitude' => '-99.0869000',
                'city' => 'Minnewaukan',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58481',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9055000',
                'longitude' => '-98.6999000',
                'city' => 'Spiritwood',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58382',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2805000',
                'longitude' => '-98.8778000',
                'city' => 'Webster',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58433',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2052000',
                'longitude' => '-98.7626000',
                'city' => 'Edgeley',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58257',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4897000',
                'longitude' => '-97.3233000',
                'city' => 'Mayville',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58701',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2395000',
                'longitude' => '-101.2960000',
                'city' => 'Minot',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58763',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9815000',
                'longitude' => '-102.4753000',
                'city' => 'New Town',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58569',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0392000',
                'longitude' => '-100.9266000',
                'city' => 'Shields',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58483',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6569000',
                'longitude' => '-99.3400000',
                'city' => 'Streeter',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58442',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6569000',
                'longitude' => '-99.3400000',
                'city' => 'Gackle',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58060',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2582000',
                'longitude' => '-97.4583000',
                'city' => 'Milnor',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58021',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6477000',
                'longitude' => '-97.0135000',
                'city' => 'Davenport',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58051',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6477000',
                'longitude' => '-97.0135000',
                'city' => 'Kindred',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58219',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3977000',
                'longitude' => '-97.0584000',
                'city' => 'Caledonia',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58009',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3977000',
                'longitude' => '-97.0584000',
                'city' => 'Blanchard',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58490',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.3602000',
                'longitude' => '-98.0678000',
                'city' => 'Verona',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58033',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.3602000',
                'longitude' => '-98.0678000',
                'city' => 'Fort Ransom',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58455',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2221000',
                'longitude' => '-98.5681000',
                'city' => 'Kensal',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58426',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2221000',
                'longitude' => '-98.5681000',
                'city' => 'Courtenay',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58492',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2221000',
                'longitude' => '-98.5681000',
                'city' => 'Wimbledon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58038',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4037000',
                'longitude' => '-97.0621000',
                'city' => 'Grandin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58223',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4037000',
                'longitude' => '-97.0621000',
                'city' => 'Cummings',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58027',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6310000',
                'longitude' => '-97.6024000',
                'city' => 'Enderlin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58348',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9612000',
                'longitude' => '-99.5282000',
                'city' => 'Maddock',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58057',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2657000',
                'longitude' => '-97.1271000',
                'city' => 'Mcleod',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58576',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4554000',
                'longitude' => '-101.1416000',
                'city' => 'Underwood',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58043',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.7916000',
                'longitude' => '-97.7492000',
                'city' => 'Havana',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58017',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.7916000',
                'longitude' => '-97.7492000',
                'city' => 'Cogswell',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58854',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7986000',
                'longitude' => '-103.2773000',
                'city' => 'Watford City',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58566',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6133000',
                'longitude' => '-100.9131000',
                'city' => 'Saint Anthony',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58528',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6133000',
                'longitude' => '-100.9131000',
                'city' => 'Cannon Ball',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58570',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6133000',
                'longitude' => '-100.9131000',
                'city' => 'Solen',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58778',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5187000',
                'longitude' => '-100.8924000',
                'city' => 'Ruso',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58575',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5187000',
                'longitude' => '-100.8924000',
                'city' => 'Turtle Lake',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58771',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3160000',
                'longitude' => '-101.7381000',
                'city' => 'Plaza',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58718',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3160000',
                'longitude' => '-101.7381000',
                'city' => 'Berthold',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58271',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6245000',
                'longitude' => '-97.1745000',
                'city' => 'Pembina',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58225',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6245000',
                'longitude' => '-97.1745000',
                'city' => 'Drayton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58773',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5641000',
                'longitude' => '-102.6490000',
                'city' => 'Powers Lake',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58710',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9259000',
                'longitude' => '-100.3652000',
                'city' => 'Anamoose',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58712',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9259000',
                'longitude' => '-100.3652000',
                'city' => 'Balfour',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58430',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9259000',
                'longitude' => '-100.3652000',
                'city' => 'Denhoff',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58736',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9259000',
                'longitude' => '-100.3652000',
                'city' => 'Drake',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58386',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2898000',
                'longitude' => '-99.4438000',
                'city' => 'York',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58346',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2898000',
                'longitude' => '-99.4438000',
                'city' => 'Leeds',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58015',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.5453000',
                'longitude' => '-96.9357000',
                'city' => 'Christine',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58357',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0686000',
                'longitude' => '-99.2505000',
                'city' => 'Oberon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '59270',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7143000',
                'longitude' => '-104.1546000',
                'city' => 'Sidney',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58838',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7143000',
                'longitude' => '-104.1546000',
                'city' => 'Cartwright',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58802',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7143000',
                'longitude' => '-104.1546000',
                'city' => 'Williston',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58005',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1477000',
                'longitude' => '-96.9658000',
                'city' => 'Argusville',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58036',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1477000',
                'longitude' => '-96.9658000',
                'city' => 'Gardner',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58454',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6260000',
                'longitude' => '-99.1438000',
                'city' => 'Jud',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58016',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2696000',
                'longitude' => '-97.4086000',
                'city' => 'Clifford',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58035',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2696000',
                'longitude' => '-97.4086000',
                'city' => 'Galesburg',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58472',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.7802000',
                'longitude' => '-98.5619000',
                'city' => 'Montpelier',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58031',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9280000',
                'longitude' => '-97.8918000',
                'city' => 'Fingal',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58269',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6250000',
                'longitude' => '-98.0416000',
                'city' => 'Osnabrock',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58756',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0159000',
                'longitude' => '-101.9585000',
                'city' => 'Makoti',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58535',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4595000',
                'longitude' => '-101.2293000',
                'city' => 'Flasher',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58529',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.9379000',
                'longitude' => '-101.7211000',
                'city' => 'Carson',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58230',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5130000',
                'longitude' => '-97.8329000',
                'city' => 'Finley',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58277',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5130000',
                'longitude' => '-97.8329000',
                'city' => 'Sharon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58046',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5130000',
                'longitude' => '-97.8329000',
                'city' => 'Hope',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58744',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0898000',
                'longitude' => '-100.6193000',
                'city' => 'Karlsruhe',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58856',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5807000',
                'longitude' => '-103.4733000',
                'city' => 'Zahl',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58801',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5807000',
                'longitude' => '-103.4733000',
                'city' => 'Williston',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58730',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5807000',
                'longitude' => '-103.4733000',
                'city' => 'Crosby',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58830',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5807000',
                'longitude' => '-103.4733000',
                'city' => 'Alamo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58735',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8582000',
                'longitude' => '-101.5049000',
                'city' => 'Douglas',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58788',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3428000',
                'longitude' => '-100.4067000',
                'city' => 'Towner',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58013',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0776000',
                'longitude' => '-97.1497000',
                'city' => 'Cayuga',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58053',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.0776000',
                'longitude' => '-97.1497000',
                'city' => 'Lidgerwood',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58755',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6300000',
                'longitude' => '-103.1820000',
                'city' => 'Mcgregor',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58795',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6300000',
                'longitude' => '-103.1820000',
                'city' => 'Wildrose',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58313',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1649000',
                'longitude' => '-100.0358000',
                'city' => 'Balta',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58240',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6403000',
                'longitude' => '-97.4547000',
                'city' => 'Hatton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58422',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6460000',
                'longitude' => '-99.6261000',
                'city' => 'Cathay',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58438',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6460000',
                'longitude' => '-99.6261000',
                'city' => 'Fessenden',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58640',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3533000',
                'longitude' => '-102.6208000',
                'city' => 'Killdeer',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58626',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3533000',
                'longitude' => '-102.6208000',
                'city' => 'Dunn Center',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58636',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3533000',
                'longitude' => '-102.6208000',
                'city' => 'Halliday',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58001',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4473000',
                'longitude' => '-96.7285000',
                'city' => 'Abercrombie',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58071',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4473000',
                'longitude' => '-96.7285000',
                'city' => 'Tower City',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58278',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7728000',
                'longitude' => '-97.1001000',
                'city' => 'Thompson',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58622',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8836000',
                'longitude' => '-103.1909000',
                'city' => 'Belfield',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58646',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4203000',
                'longitude' => '-102.5536000',
                'city' => 'Mott',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58645',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4829000',
                'longitude' => '-103.9259000',
                'city' => 'Medora',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58849',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3426000',
                'longitude' => '-103.1733000',
                'city' => 'Ray',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58853',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1483000',
                'longitude' => '-103.6232000',
                'city' => 'Trenton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58642',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2218000',
                'longitude' => '-102.7675000',
                'city' => 'Manning',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58627',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8850000',
                'longitude' => '-103.1973000',
                'city' => 'Fairfield',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58343',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3399000',
                'longitude' => '-99.6866000',
                'city' => 'Knox',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58385',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3399000',
                'longitude' => '-99.6866000',
                'city' => 'Wolford',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58562',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4015000',
                'longitude' => '-101.8456000',
                'city' => 'New Leipzig',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58835',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8090000',
                'longitude' => '-103.4371000',
                'city' => 'Arnegard',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58831',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8090000',
                'longitude' => '-103.4371000',
                'city' => 'Alexander',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58345',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3109000',
                'longitude' => '-97.9213000',
                'city' => 'Lawton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58210',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3109000',
                'longitude' => '-97.9213000',
                'city' => 'Adams',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58258',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9459000',
                'longitude' => '-97.3709000',
                'city' => 'Mekinock',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58204',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9459000',
                'longitude' => '-97.3709000',
                'city' => 'Grand Forks Afb',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58752',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9023000',
                'longitude' => '-102.3980000',
                'city' => 'Lignite',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58737',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9023000',
                'longitude' => '-102.3980000',
                'city' => 'Flaxton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58564',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4523000',
                'longitude' => '-101.2398000',
                'city' => 'Raleigh',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58275',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7728000',
                'longitude' => '-97.1001000',
                'city' => 'Reynolds',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58520',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.4224000',
                'longitude' => '-101.5624000',
                'city' => 'Almont',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58781',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0897000',
                'longitude' => '-101.0532000',
                'city' => 'Sawyer',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58768',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0897000',
                'longitude' => '-101.0532000',
                'city' => 'Norwich',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58741',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0897000',
                'longitude' => '-101.0532000',
                'city' => 'Granville',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58758',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8257000',
                'longitude' => '-100.1146000',
                'city' => 'Martin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58723',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8361000',
                'longitude' => '-100.6644000',
                'city' => 'Butte',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58769',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3163000',
                'longitude' => '-102.3865000',
                'city' => 'Palermo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58007',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9188000',
                'longitude' => '-97.5456000',
                'city' => 'Ayr',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58011',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9188000',
                'longitude' => '-97.5456000',
                'city' => 'Buffalo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58074',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2632000',
                'longitude' => '-96.6078000',
                'city' => 'Wahpeton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58330',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4112000',
                'longitude' => '-98.4597000',
                'city' => 'Edmore',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58052',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6527000',
                'longitude' => '-97.2469000',
                'city' => 'Leonard',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58479',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9426000',
                'longitude' => '-98.2216000',
                'city' => 'Rogers',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58072',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9426000',
                'longitude' => '-98.2216000',
                'city' => 'Valley City',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58480',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9426000',
                'longitude' => '-98.2216000',
                'city' => 'Sanborn',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58456',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.3038000',
                'longitude' => '-98.9493000',
                'city' => 'Kulm',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58565',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4554000',
                'longitude' => '-101.1416000',
                'city' => 'Riverdale',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58353',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6231000',
                'longitude' => '-99.3779000',
                'city' => 'Mylo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58363',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6231000',
                'longitude' => '-99.3779000',
                'city' => 'Perth',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58310',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6231000',
                'longitude' => '-99.3779000',
                'city' => 'Agate',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58243',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5977000',
                'longitude' => '-97.6727000',
                'city' => 'Hoople',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58222',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5977000',
                'longitude' => '-97.6727000',
                'city' => 'Crystal',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58029',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1599000',
                'longitude' => '-97.5728000',
                'city' => 'Erie',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58064',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1599000',
                'longitude' => '-97.5728000',
                'city' => 'Page',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58063',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1599000',
                'longitude' => '-97.5728000',
                'city' => 'Oriska',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58466',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6067000',
                'longitude' => '-98.3371000',
                'city' => 'Marion',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58076',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2640000',
                'longitude' => '-96.5931000',
                'city' => 'Wahpeton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58544',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8211000',
                'longitude' => '-100.4596000',
                'city' => 'Hazelton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58445',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5504000',
                'longitude' => '-98.8041000',
                'city' => 'Grace City',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58356',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5504000',
                'longitude' => '-98.8041000',
                'city' => 'New Rockford',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58443',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5504000',
                'longitude' => '-98.8041000',
                'city' => 'Glenfield',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58847',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9239000',
                'longitude' => '-102.9403000',
                'city' => 'Keene',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58655',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8637000',
                'longitude' => '-102.9908000',
                'city' => 'South Heart',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58054',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2290000',
                'longitude' => '-97.6592000',
                'city' => 'Lisbon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58069',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.2290000',
                'longitude' => '-97.6592000',
                'city' => 'Stirum',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58759',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8242000',
                'longitude' => '-101.2963000',
                'city' => 'Max',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58845',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.6144000',
                'longitude' => '-103.9349000',
                'city' => 'Grenora',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58256',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0735000',
                'longitude' => '-97.1786000',
                'city' => 'Manvel',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58372',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9413000',
                'longitude' => '-98.9930000',
                'city' => 'Sarles',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58213',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1956000',
                'longitude' => '-97.1357000',
                'city' => 'Manvel',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '56744',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1956000',
                'longitude' => '-97.1357000',
                'city' => 'Oslo',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58750',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2148000',
                'longitude' => '-101.3158000',
                'city' => 'Lansford',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58733',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2148000',
                'longitude' => '-101.3158000',
                'city' => 'Des Lacs',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58722',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.0783000',
                'longitude' => '-101.2972000',
                'city' => 'Burlington',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58067',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1064000',
                'longitude' => '-97.6291000',
                'city' => 'Rutland',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58032',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.1064000',
                'longitude' => '-97.6291000',
                'city' => 'Forman',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58779',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9615000',
                'longitude' => '-101.8059000',
                'city' => 'Ryder',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58704',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4164000',
                'longitude' => '-101.3220000',
                'city' => 'Minot Afb',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58785',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3969000',
                'longitude' => '-101.0487000',
                'city' => 'Surrey',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58429',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1907000',
                'longitude' => '-98.2045000',
                'city' => 'Dazey',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58425',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1907000',
                'longitude' => '-98.2045000',
                'city' => 'Cooperstown',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '56721',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8993000',
                'longitude' => '-97.0688000',
                'city' => 'East Grand Forks',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58208',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8993000',
                'longitude' => '-97.0688000',
                'city' => 'Grand Forks',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58775',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7498000',
                'longitude' => '-101.8386000',
                'city' => 'Roseglen',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '59221',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.8504000',
                'longitude' => '-104.0439000',
                'city' => 'Fairview',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58571',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3229000',
                'longitude' => '-101.3861000',
                'city' => 'Stanton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58523',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2962000',
                'longitude' => '-101.6274000',
                'city' => 'Beulah',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58486',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1313000',
                'longitude' => '-99.3061000',
                'city' => 'Sykeston',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58776',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3129000',
                'longitude' => '-102.5461000',
                'city' => 'Ross',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58794',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.3129000',
                'longitude' => '-102.5461000',
                'city' => 'White Earth',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58757',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.7183000',
                'longitude' => '-102.6878000',
                'city' => 'Mandaree',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58049',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6509000',
                'longitude' => '-98.1902000',
                'city' => 'Kathryn',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58461',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6509000',
                'longitude' => '-98.1902000',
                'city' => 'Litchville',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58424',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8955000',
                'longitude' => '-99.0409000',
                'city' => 'Cleveland',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58335',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.9793000',
                'longitude' => '-98.9943000',
                'city' => 'Fort Totten',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58713',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5803000',
                'longitude' => '-100.7265000',
                'city' => 'Bantry',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58484',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3102000',
                'longitude' => '-98.1877000',
                'city' => 'Sutton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58056',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3102000',
                'longitude' => '-98.1877000',
                'city' => 'Luverne',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58431',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.5343000',
                'longitude' => '-98.4554000',
                'city' => 'Dickey',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58274',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.5000000',
                'longitude' => '-97.3245000',
                'city' => 'Portland',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58538',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '45.8158000',
                'longitude' => '-100.8151000',
                'city' => 'Fort Yates',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58702',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2337000',
                'longitude' => '-101.2918000',
                'city' => 'Minot',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58844',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9100000',
                'longitude' => '-103.7772000',
                'city' => 'Fortuna',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58625',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3030000',
                'longitude' => '-102.2062000',
                'city' => 'Dodge',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58218',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.6702000',
                'longitude' => '-97.1087000',
                'city' => 'Buxton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58843',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.2799000',
                'longitude' => '-103.3545000',
                'city' => 'Epping',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58634',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3858000',
                'longitude' => '-103.2489000',
                'city' => 'Grassy Butte',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58244',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1532000',
                'longitude' => '-97.6449000',
                'city' => 'Inkster',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58235',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.1532000',
                'longitude' => '-97.6449000',
                'city' => 'Gilby',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58488',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1427000',
                'longitude' => '-99.9940000',
                'city' => 'Tuttle',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58338',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5410000',
                'longitude' => '-98.6581000',
                'city' => 'Hampden',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58654',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9141000',
                'longitude' => '-103.9977000',
                'city' => 'Sentinel Butte',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58632',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9141000',
                'longitude' => '-103.9977000',
                'city' => 'Golva',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58580',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2648000',
                'longitude' => '-101.7847000',
                'city' => 'Zap',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58048',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1910000',
                'longitude' => '-97.2145000',
                'city' => 'Hunter',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58652',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9014000',
                'longitude' => '-102.0469000',
                'city' => 'Richardton',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58638',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9014000',
                'longitude' => '-102.0469000',
                'city' => 'Hebron',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58068',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.5876000',
                'longitude' => '-97.4986000',
                'city' => 'Sheldon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58415',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.3582000',
                'longitude' => '-98.2970000',
                'city' => 'Berlin',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58458',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.3582000',
                'longitude' => '-98.2970000',
                'city' => 'Lamoure',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58444',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4752000',
                'longitude' => '-100.1268000',
                'city' => 'Goodrich',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58265',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9785000',
                'longitude' => '-97.5512000',
                'city' => 'Neche',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58002',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.9760000',
                'longitude' => '-97.3906000',
                'city' => 'Absaraka',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58062',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.6772000',
                'longitude' => '-97.7904000',
                'city' => 'Nome',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58765',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8856000',
                'longitude' => '-103.0175000',
                'city' => 'Noonan',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58644',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3556000',
                'longitude' => '-102.3287000',
                'city' => 'Marshall',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58727',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9029000',
                'longitude' => '-102.7831000',
                'city' => 'Columbus',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58229',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4212000',
                'longitude' => '-98.0781000',
                'city' => 'Fairdale',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58065',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.3232000',
                'longitude' => '-97.7173000',
                'city' => 'Pillsbury',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58541',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.2869000',
                'longitude' => '-101.9234000',
                'city' => 'Golden Valley',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58355',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.5769000',
                'longitude' => '-98.3725000',
                'city' => 'Nekoma',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58451',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4685000',
                'longitude' => '-99.7055000',
                'city' => 'Hurdsfield',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58418',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.4685000',
                'longitude' => '-99.7055000',
                'city' => 'Bowdon',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58006',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '47.1086000',
                'longitude' => '-97.2203000',
                'city' => 'Arthur',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58656',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '46.8859000',
                'longitude' => '-102.3126000',
                'city' => 'Taylor',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58833',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.9542000',
                'longitude' => '-103.4797000',
                'city' => 'Ambrose',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '59275',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.8651000',
                'longitude' => '-104.0516000',
                'city' => 'Westby',
                'full_state' => 'North Dakota',
            ],
            [
                'zip' => '58262',
                'country_code' => 'US',
                'state' => 'ND',
                'latitude' => '48.4944000',
                'longitude' => '-97.8654000',
                'city' => 'Mountain',
                'full_state' => 'North Dakota',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
