<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NorthCarolinaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '27804',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9398000',
                'longitude' => '-77.7987000',
                'city' => 'Rocky Mount',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27803',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9398000',
                'longitude' => '-77.7987000',
                'city' => 'Rocky Mount',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27923',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3498000',
                'longitude' => '-75.9502000',
                'city' => 'Coinjock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27870',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4596000',
                'longitude' => '-77.6601000',
                'city' => 'Roanoke Rapids',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27563',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4417000',
                'longitude' => '-78.1883000',
                'city' => 'Norlina',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27807',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7245000',
                'longitude' => '-77.9084000',
                'city' => 'Bailey',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27896',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7245000',
                'longitude' => '-77.9084000',
                'city' => 'Wilson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27893',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7245000',
                'longitude' => '-77.9084000',
                'city' => 'Wilson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27880',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7245000',
                'longitude' => '-77.9084000',
                'city' => 'Sims',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27822',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7245000',
                'longitude' => '-77.9084000',
                'city' => 'Elm City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28501',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2565000',
                'longitude' => '-77.5742000',
                'city' => 'Kinston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28551',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2565000',
                'longitude' => '-77.5742000',
                'city' => 'La Grange',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28526',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2565000',
                'longitude' => '-77.5742000',
                'city' => 'Dover',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28504',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2565000',
                'longitude' => '-77.5742000',
                'city' => 'Kinston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27924',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2923000',
                'longitude' => '-76.9821000',
                'city' => 'Colerain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27805',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2923000',
                'longitude' => '-76.9821000',
                'city' => 'Aulander',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27967',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2923000',
                'longitude' => '-76.9821000',
                'city' => 'Powellsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27910',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2923000',
                'longitude' => '-76.9821000',
                'city' => 'Ahoskie',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27801',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9514000',
                'longitude' => '-77.8300000',
                'city' => 'Rocky Mount',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27878',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9398000',
                'longitude' => '-77.7987000',
                'city' => 'Sharpsburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27809',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9398000',
                'longitude' => '-77.7987000',
                'city' => 'Battleboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27537',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Henderson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28590',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5746000',
                'longitude' => '-77.3935000',
                'city' => 'Winterville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27834',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5746000',
                'longitude' => '-77.3935000',
                'city' => 'Greenville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27858',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5746000',
                'longitude' => '-77.3935000',
                'city' => 'Greenville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27954',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9093000',
                'longitude' => '-75.6749000',
                'city' => 'Manteo',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27892',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8493000',
                'longitude' => '-77.0615000',
                'city' => 'Williamston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27932',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2257000',
                'longitude' => '-76.6527000',
                'city' => 'Edenton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27946',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2257000',
                'longitude' => '-76.6527000',
                'city' => 'Hobbsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27980',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2257000',
                'longitude' => '-76.6527000',
                'city' => 'Tyner',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28557',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7252000',
                'longitude' => '-76.7289000',
                'city' => 'Morehead City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28512',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7252000',
                'longitude' => '-76.7289000',
                'city' => 'Atlantic Beach',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28570',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7252000',
                'longitude' => '-76.7289000',
                'city' => 'Newport',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28575',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7252000',
                'longitude' => '-76.7289000',
                'city' => 'Salter Path',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28585',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0054000',
                'longitude' => '-77.2198000',
                'city' => 'Trenton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28573',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0054000',
                'longitude' => '-77.2198000',
                'city' => 'Pollocksville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28562',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0054000',
                'longitude' => '-77.2198000',
                'city' => 'New Bern',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28577',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8831000',
                'longitude' => '-76.3328000',
                'city' => 'Sealevel',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28520',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8831000',
                'longitude' => '-76.3328000',
                'city' => 'Cedar Island',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28581',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8831000',
                'longitude' => '-76.3328000',
                'city' => 'Stacy',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28511',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8831000',
                'longitude' => '-76.3328000',
                'city' => 'Atlantic',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27828',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5911000',
                'longitude' => '-77.5837000',
                'city' => 'Farmville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27958',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4513000',
                'longitude' => '-76.0835000',
                'city' => 'Moyock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27973',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4513000',
                'longitude' => '-76.0835000',
                'city' => 'Shawboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27929',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4513000',
                'longitude' => '-76.0835000',
                'city' => 'Currituck',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27597',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7833000',
                'longitude' => '-78.1180000',
                'city' => 'Zebulon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27557',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7833000',
                'longitude' => '-78.1180000',
                'city' => 'Middlesex',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27883',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6087000',
                'longitude' => '-77.8271000',
                'city' => 'Stantonsburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27888',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6087000',
                'longitude' => '-77.8271000',
                'city' => 'Walstonburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27873',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6087000',
                'longitude' => '-77.8271000',
                'city' => 'Saratoga',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27542',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6422000',
                'longitude' => '-78.0098000',
                'city' => 'Kenly',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27851',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6422000',
                'longitude' => '-78.0098000',
                'city' => 'Lucama',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28530',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2992000',
                'longitude' => '-77.1528000',
                'city' => 'Grifton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28586',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2992000',
                'longitude' => '-77.1528000',
                'city' => 'Vanceboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28527',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2992000',
                'longitude' => '-77.1528000',
                'city' => 'Ernul',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27882',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Spring Hope',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28571',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0254000',
                'longitude' => '-76.7023000',
                'city' => 'Oriental',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28556',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0254000',
                'longitude' => '-76.7023000',
                'city' => 'Merritt',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28510',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0254000',
                'longitude' => '-76.7023000',
                'city' => 'Arapahoe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27589',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Warrenton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27949',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1246000',
                'longitude' => '-75.7299000',
                'city' => 'Kitty Hawk',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27948',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1246000',
                'longitude' => '-75.7299000',
                'city' => 'Kill Devil Hills',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27844',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3985000',
                'longitude' => '-78.1486000',
                'city' => 'Hollister',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27551',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3985000',
                'longitude' => '-78.1486000',
                'city' => 'Macon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27849',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2368000',
                'longitude' => '-76.3252000',
                'city' => 'Lewiston Woodville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27944',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2368000',
                'longitude' => '-76.3252000',
                'city' => 'Hertford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27909',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2368000',
                'longitude' => '-76.3252000',
                'city' => 'Elizabeth City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27864',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Pinetops',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27829',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6739000',
                'longitude' => '-77.6444000',
                'city' => 'Fountain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27885',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3989000',
                'longitude' => '-76.3332000',
                'city' => 'Swanquarter',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27889',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5412000',
                'longitude' => '-77.0538000',
                'city' => 'Washington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28458',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2565000',
                'longitude' => '-77.5742000',
                'city' => 'Rose Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27919',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3143000',
                'longitude' => '-76.5628000',
                'city' => 'Belvidere',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28513',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4657000',
                'longitude' => '-77.4159000',
                'city' => 'Ayden',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27842',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4596000',
                'longitude' => '-77.6601000',
                'city' => 'Henrico',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27832',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4596000',
                'longitude' => '-77.6601000',
                'city' => 'Gaston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27831',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4596000',
                'longitude' => '-77.6601000',
                'city' => 'Garysburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27891',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9398000',
                'longitude' => '-77.7987000',
                'city' => 'Whitakers',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27806',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2990000',
                'longitude' => '-76.7859000',
                'city' => 'Aurora',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27814',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2990000',
                'longitude' => '-76.7859000',
                'city' => 'Blounts Creek',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27821',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2990000',
                'longitude' => '-76.7859000',
                'city' => 'Edward',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27983',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9975000',
                'longitude' => '-76.9502000',
                'city' => 'Windsor',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28584',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4596000',
                'longitude' => '-77.6601000',
                'city' => 'Swansboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27836',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6075000',
                'longitude' => '-77.3730000',
                'city' => 'Greenville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27837',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6075000',
                'longitude' => '-77.3730000',
                'city' => 'Grimesland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27921',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2970000',
                'longitude' => '-76.2246000',
                'city' => 'Camden',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27974',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2703000',
                'longitude' => '-76.0883000',
                'city' => 'Shiloh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27872',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1994000',
                'longitude' => '-77.2409000',
                'city' => 'Roxobel',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27847',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1994000',
                'longitude' => '-77.2409000',
                'city' => 'Kelford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27869',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1994000',
                'longitude' => '-77.2409000',
                'city' => 'Rich Square',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28594',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6663000',
                'longitude' => '-77.0271000',
                'city' => 'Emerald Isle',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27957',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1995000',
                'longitude' => '-76.7648000',
                'city' => 'Merry Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27922',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1995000',
                'longitude' => '-76.7648000',
                'city' => 'Cofield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27942',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1995000',
                'longitude' => '-76.7648000',
                'city' => 'Harrellsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27938',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4084000',
                'longitude' => '-76.7518000',
                'city' => 'Gatesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27935',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4084000',
                'longitude' => '-76.7518000',
                'city' => 'Eure',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27937',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4084000',
                'longitude' => '-76.7518000',
                'city' => 'Gates',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27986',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3994000',
                'longitude' => '-76.9255000',
                'city' => 'Winton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27586',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5412000',
                'longitude' => '-77.0538000',
                'city' => 'Vaughan',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27810',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Belhaven',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27897',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3342000',
                'longitude' => '-77.2085000',
                'city' => 'Woodland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27970',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8691000',
                'longitude' => '-76.3929000',
                'city' => 'Roper',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27925',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8691000',
                'longitude' => '-76.3929000',
                'city' => 'Columbia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27824',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5095000',
                'longitude' => '-75.9995000',
                'city' => 'Engelhard',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27820',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4434000',
                'longitude' => '-77.2262000',
                'city' => 'Conway',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27823',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1815000',
                'longitude' => '-77.6662000',
                'city' => 'Enfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28582',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6938000',
                'longitude' => '-77.1257000',
                'city' => 'Stella',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27855',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4395000',
                'longitude' => '-77.0984000',
                'city' => 'Murfreesboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27818',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4395000',
                'longitude' => '-77.0984000',
                'city' => 'Como',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28553',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7668000',
                'longitude' => '-76.5184000',
                'city' => 'Marshallberg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27985',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1824000',
                'longitude' => '-76.4758000',
                'city' => 'Winfall',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27950',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5076000',
                'longitude' => '-75.9238000',
                'city' => 'Knotts Island',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27565',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Oxford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27536',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Henderson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27544',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Kittrell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27584',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Townsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27959',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0064000',
                'longitude' => '-75.6595000',
                'city' => 'Nags Head',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27856',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9629000',
                'longitude' => '-77.8614000',
                'city' => 'Nashville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28560',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8860000',
                'longitude' => '-76.9266000',
                'city' => 'New Bern',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28533',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8860000',
                'longitude' => '-76.9266000',
                'city' => 'Cherry Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28532',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8860000',
                'longitude' => '-76.9266000',
                'city' => 'Havelock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27839',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1815000',
                'longitude' => '-77.6662000',
                'city' => 'Halifax',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27939',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3498000',
                'longitude' => '-75.9502000',
                'city' => 'Grandy',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27965',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3498000',
                'longitude' => '-75.9502000',
                'city' => 'Poplar Branch',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27917',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3498000',
                'longitude' => '-75.9502000',
                'city' => 'Barco',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27916',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3498000',
                'longitude' => '-75.9502000',
                'city' => 'Aydlett',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27956',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3498000',
                'longitude' => '-75.9502000',
                'city' => 'Maple',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27927',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3498000',
                'longitude' => '-75.9502000',
                'city' => 'Corolla',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27594',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4417000',
                'longitude' => '-78.1883000',
                'city' => 'Wise',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27553',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4417000',
                'longitude' => '-78.1883000',
                'city' => 'Manson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27816',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9658000',
                'longitude' => '-77.9680000',
                'city' => 'Castalia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27926',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4392000',
                'longitude' => '-76.6077000',
                'city' => 'Corapeake',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27979',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4392000',
                'longitude' => '-76.6077000',
                'city' => 'Sunbury',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27981',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9093000',
                'longitude' => '-75.6749000',
                'city' => 'Wanchese',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27953',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9093000',
                'longitude' => '-75.6749000',
                'city' => 'Manns Harbor',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27978',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9093000',
                'longitude' => '-75.6749000',
                'city' => 'Stumpy Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27549',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9411000',
                'longitude' => '-78.1160000',
                'city' => 'Louisburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27845',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Jackson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27964',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1258000',
                'longitude' => '-75.8399000',
                'city' => 'Point Harbor',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27966',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1258000',
                'longitude' => '-75.8399000',
                'city' => 'Powells Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27941',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1258000',
                'longitude' => '-75.8399000',
                'city' => 'Harbinger',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27947',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1258000',
                'longitude' => '-75.8399000',
                'city' => 'Jarvisburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27874',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1342000',
                'longitude' => '-77.4181000',
                'city' => 'Scotland Neck',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28516',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7242000',
                'longitude' => '-76.6486000',
                'city' => 'Beaufort',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28531',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7242000',
                'longitude' => '-76.6486000',
                'city' => 'Harkers Island',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27962',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8658000',
                'longitude' => '-76.7529000',
                'city' => 'Plymouth',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28523',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1168000',
                'longitude' => '-77.0532000',
                'city' => 'Cove City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28572',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0515000',
                'longitude' => '-77.7418000',
                'city' => 'Pink Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28538',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3673000',
                'longitude' => '-77.4355000',
                'city' => 'Hookerton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28525',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2565000',
                'longitude' => '-77.5742000',
                'city' => 'Deep Run',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28580',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2565000',
                'longitude' => '-77.5742000',
                'city' => 'Snow Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27876',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3919000',
                'longitude' => '-77.4144000',
                'city' => 'Seaboard',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27866',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4263000',
                'longitude' => '-77.5987000',
                'city' => 'Pleasant Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27890',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4263000',
                'longitude' => '-77.5987000',
                'city' => 'Weldon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27850',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Littleton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27852',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9398000',
                'longitude' => '-77.7987000',
                'city' => 'Macclesfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28508',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0515000',
                'longitude' => '-77.7418000',
                'city' => 'Albertson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28578',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2027000',
                'longitude' => '-77.7668000',
                'city' => 'Seven Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27877',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4434000',
                'longitude' => '-77.2262000',
                'city' => 'Severn',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27853',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4434000',
                'longitude' => '-77.2262000',
                'city' => 'Margarettsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27862',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4434000',
                'longitude' => '-77.2262000',
                'city' => 'Pendleton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27867',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3342000',
                'longitude' => '-77.2085000',
                'city' => 'Potecasi',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27886',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9042000',
                'longitude' => '-77.5418000',
                'city' => 'Tarboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27840',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9421000',
                'longitude' => '-77.2094000',
                'city' => 'Hamilton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28561',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1168000',
                'longitude' => '-77.0532000',
                'city' => 'New Bern',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27928',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Creswell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27871',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8259000',
                'longitude' => '-77.2589000',
                'city' => 'Robersonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27833',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6075000',
                'longitude' => '-77.3730000',
                'city' => 'Greenville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28528',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7668000',
                'longitude' => '-76.5184000',
                'city' => 'Gloucester',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28589',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7668000',
                'longitude' => '-76.5184000',
                'city' => 'Williston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28524',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7668000',
                'longitude' => '-76.5184000',
                'city' => 'Davis',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28579',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7668000',
                'longitude' => '-76.5184000',
                'city' => 'Smyrna',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27507',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Bullock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28529',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1403000',
                'longitude' => '-76.7691000',
                'city' => 'Grantsboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28537',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1403000',
                'longitude' => '-76.7691000',
                'city' => 'Hobucken',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28552',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1403000',
                'longitude' => '-76.7691000',
                'city' => 'Lowland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28583',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1403000',
                'longitude' => '-76.7691000',
                'city' => 'Stonewall',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28587',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1403000',
                'longitude' => '-76.7691000',
                'city' => 'Vandemere',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28515',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1403000',
                'longitude' => '-76.7691000',
                'city' => 'Bayboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27884',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6075000',
                'longitude' => '-77.3730000',
                'city' => 'Stokes',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27556',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3239000',
                'longitude' => '-78.4085000',
                'city' => 'Middleburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27976',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4433000',
                'longitude' => '-76.3268000',
                'city' => 'South Mills',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27846',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8493000',
                'longitude' => '-77.0615000',
                'city' => 'Jamesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27825',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8493000',
                'longitude' => '-77.0615000',
                'city' => 'Everetts',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27861',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8259000',
                'longitude' => '-77.2589000',
                'city' => 'Parmele',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27841',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8259000',
                'longitude' => '-77.2589000',
                'city' => 'Hassell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27857',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8259000',
                'longitude' => '-77.2589000',
                'city' => 'Oak City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27826',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9165000',
                'longitude' => '-76.2490000',
                'city' => 'Fairfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27843',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9421000',
                'longitude' => '-77.2094000',
                'city' => 'Hobgood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27812',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8079000',
                'longitude' => '-77.3764000',
                'city' => 'Bethel',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27819',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9042000',
                'longitude' => '-77.5418000',
                'city' => 'Conetoe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27865',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4763000',
                'longitude' => '-76.8083000',
                'city' => 'Pinetown',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27808',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4763000',
                'longitude' => '-76.8083000',
                'city' => 'Bath',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27875',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3989000',
                'longitude' => '-76.3332000',
                'city' => 'Scranton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27860',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6100000',
                'longitude' => '-76.8596000',
                'city' => 'Pantego',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27960',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1177000',
                'longitude' => '-75.9845000',
                'city' => 'Ocracoke',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27817',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5412000',
                'longitude' => '-77.0538000',
                'city' => 'Chocowinity',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27943',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2154000',
                'longitude' => '-75.6889000',
                'city' => 'Hatteras',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27936',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2154000',
                'longitude' => '-75.6889000',
                'city' => 'Frisco',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27972',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5607000',
                'longitude' => '-75.4659000',
                'city' => 'Salvo',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27982',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5607000',
                'longitude' => '-75.4659000',
                'city' => 'Waves',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27968',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5607000',
                'longitude' => '-75.4659000',
                'city' => 'Rodanthe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27915',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2588000',
                'longitude' => '-75.5416000',
                'city' => 'Avon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27920',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2588000',
                'longitude' => '-75.5416000',
                'city' => 'Buxton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28668',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4012000',
                'longitude' => '-80.9915000',
                'city' => 'Roaring Gap',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27127',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0979000',
                'longitude' => '-80.2470000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27105',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0979000',
                'longitude' => '-80.2470000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27407',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27410',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27406',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27401',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27052',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Walnut Cove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27320',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3581000',
                'longitude' => '-79.6651000',
                'city' => 'Reidsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27408',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27403',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27455',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27101',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0588000',
                'longitude' => '-80.2238000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27405',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27265',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'High Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27435',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27215',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0893000',
                'longitude' => '-79.4323000',
                'city' => 'Burlington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27217',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0893000',
                'longitude' => '-79.4323000',
                'city' => 'Burlington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27404',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27205',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7064000',
                'longitude' => '-79.8166000',
                'city' => 'Asheboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27409',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0662000',
                'longitude' => '-79.8484000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27282',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0662000',
                'longitude' => '-79.8484000',
                'city' => 'Jamestown',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28640',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3997000',
                'longitude' => '-81.4886000',
                'city' => 'Jefferson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28694',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3997000',
                'longitude' => '-81.4886000',
                'city' => 'West Jefferson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28144',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7904000',
                'longitude' => '-80.4202000',
                'city' => 'Salisbury',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28159',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7904000',
                'longitude' => '-80.4202000',
                'city' => 'Spencer',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27253',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0893000',
                'longitude' => '-79.4323000',
                'city' => 'Graham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27349',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0893000',
                'longitude' => '-79.4323000',
                'city' => 'Snow Camp',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27295',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8258000',
                'longitude' => '-80.2574000',
                'city' => 'Lexington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27292',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8258000',
                'longitude' => '-80.2574000',
                'city' => 'Lexington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27283',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9055000',
                'longitude' => '-79.6653000',
                'city' => 'Julian',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27305',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5373000',
                'longitude' => '-79.2027000',
                'city' => 'Milton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27212',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5373000',
                'longitude' => '-79.2027000',
                'city' => 'Blanch',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27343',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5373000',
                'longitude' => '-79.2027000',
                'city' => 'Semora',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27239',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8258000',
                'longitude' => '-80.2574000',
                'city' => 'Denton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27370',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6934000',
                'longitude' => '-80.0009000',
                'city' => 'Trinity',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27018',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'East Bend',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28642',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Jonesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28669',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Roaring River',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28676',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'State Road',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27011',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Boonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27055',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Yadkinville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28621',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Elkin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27020',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Hamptonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28670',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Ronda',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27017',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2412000',
                'longitude' => '-80.8460000',
                'city' => 'Dobson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27103',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1004000',
                'longitude' => '-80.2518000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27107',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1004000',
                'longitude' => '-80.2518000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27102',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1004000',
                'longitude' => '-80.2518000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27106',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1004000',
                'longitude' => '-80.2518000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27104',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1004000',
                'longitude' => '-80.2518000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27284',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0979000',
                'longitude' => '-80.2470000',
                'city' => 'Kernersville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27023',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0979000',
                'longitude' => '-80.2470000',
                'city' => 'Lewisville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27358',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Summerfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27262',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'High Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27260',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'High Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28659',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1656000',
                'longitude' => '-81.1390000',
                'city' => 'North Wilkesboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28618',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0893000',
                'longitude' => '-79.4323000',
                'city' => 'Deep Gap',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27054',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1025000',
                'longitude' => '-79.5096000',
                'city' => 'Woodleaf',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27244',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1025000',
                'longitude' => '-79.5096000',
                'city' => 'Elon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27021',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3587000',
                'longitude' => '-80.2866000',
                'city' => 'King',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27028',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8157000',
                'longitude' => '-80.5543000',
                'city' => 'Mocksville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27014',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8157000',
                'longitude' => '-80.5543000',
                'city' => 'Cooleemee',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27416',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27415',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27360',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8814000',
                'longitude' => '-80.0803000',
                'city' => 'Thomasville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27402',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27203',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7064000',
                'longitude' => '-79.8166000',
                'city' => 'Asheboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27495',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0662000',
                'longitude' => '-79.8484000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27030',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4841000',
                'longitude' => '-80.6936000',
                'city' => 'Mount Airy',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27024',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4841000',
                'longitude' => '-80.6936000',
                'city' => 'Lowgap',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27583',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3924000',
                'longitude' => '-78.9792000',
                'city' => 'Timberlake',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27291',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3924000',
                'longitude' => '-78.9792000',
                'city' => 'Leasburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27541',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3924000',
                'longitude' => '-78.9792000',
                'city' => 'Hurdle Mills',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27573',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3924000',
                'longitude' => '-78.9792000',
                'city' => 'Roxboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27043',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2759000',
                'longitude' => '-80.5184000',
                'city' => 'Pinnacle',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27350',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7064000',
                'longitude' => '-79.8166000',
                'city' => 'Sophia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27412',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0696000',
                'longitude' => '-79.7919000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27214',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Browns Summit',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27041',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4755000',
                'longitude' => '-80.4517000',
                'city' => 'Pilot Mountain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27053',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4755000',
                'longitude' => '-80.4517000',
                'city' => 'Westfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27301',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1185000',
                'longitude' => '-79.7601000',
                'city' => 'Mc Leansville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27249',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1185000',
                'longitude' => '-79.7601000',
                'city' => 'Gibsonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28663',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4800000',
                'longitude' => '-81.2790000',
                'city' => 'Piney Creek',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28675',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4800000',
                'longitude' => '-81.2790000',
                'city' => 'Sparta',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28672',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4800000',
                'longitude' => '-81.2790000',
                'city' => 'Scottville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28644',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4800000',
                'longitude' => '-81.2790000',
                'city' => 'Laurel Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28627',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4012000',
                'longitude' => '-80.9915000',
                'city' => 'Glade Valley',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27572',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2844000',
                'longitude' => '-78.9508000',
                'city' => 'Rougemont',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27047',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3400000',
                'longitude' => '-80.6232000',
                'city' => 'Siloam',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27007',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3400000',
                'longitude' => '-80.6232000',
                'city' => 'Ararat',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27298',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9599000',
                'longitude' => '-79.3731000',
                'city' => 'Liberty',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27258',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9599000',
                'longitude' => '-79.3731000',
                'city' => 'Haw River',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27302',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9599000',
                'longitude' => '-79.3731000',
                'city' => 'Mebane',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27045',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1966000',
                'longitude' => '-80.2778000',
                'city' => 'Rural Hall',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27371',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5478000',
                'longitude' => '-79.8673000',
                'city' => 'Troy',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27263',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'High Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28643',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5001000',
                'longitude' => '-81.5056000',
                'city' => 'Lansing',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28631',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5001000',
                'longitude' => '-81.5056000',
                'city' => 'Grassy Creek',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28693',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5001000',
                'longitude' => '-81.5056000',
                'city' => 'Warrensville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28684',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4326000',
                'longitude' => '-81.6313000',
                'city' => 'Todd',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28698',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4326000',
                'longitude' => '-81.6313000',
                'city' => 'Zionville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28615',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4326000',
                'longitude' => '-81.6313000',
                'city' => 'Creston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27341',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0696000',
                'longitude' => '-79.7919000',
                'city' => 'Seagrove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27326',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5305000',
                'longitude' => '-79.3987000',
                'city' => 'Ruffin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27315',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5305000',
                'longitude' => '-79.3987000',
                'city' => 'Providence',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27311',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5305000',
                'longitude' => '-79.3987000',
                'city' => 'Pelham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27006',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0979000',
                'longitude' => '-80.2470000',
                'city' => 'Advance',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27235',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0940000',
                'longitude' => '-79.9544000',
                'city' => 'Colfax',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27012',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0979000',
                'longitude' => '-80.2470000',
                'city' => 'Clemmons',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27379',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2673000',
                'longitude' => '-79.3446000',
                'city' => 'Yanceyville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27027',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3922000',
                'longitude' => '-79.9627000',
                'city' => 'Mayodan',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27357',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3922000',
                'longitude' => '-79.9627000',
                'city' => 'Stokesdale',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27048',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3922000',
                'longitude' => '-79.9627000',
                'city' => 'Stoneville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27042',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3922000',
                'longitude' => '-79.9627000',
                'city' => 'Pine Hall',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27025',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3922000',
                'longitude' => '-79.9627000',
                'city' => 'Madison',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27317',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9138000',
                'longitude' => '-79.9745000',
                'city' => 'Randleman',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28697',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3581000',
                'longitude' => '-79.6651000',
                'city' => 'Wilkesboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27377',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1073000',
                'longitude' => '-79.5396000',
                'city' => 'Whitsett',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28127',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5084000',
                'longitude' => '-80.1051000',
                'city' => 'New London',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27259',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0979000',
                'longitude' => '-80.2470000',
                'city' => 'Highfalls',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28689',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1188000',
                'longitude' => '-80.7669000',
                'city' => 'Union Grove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28634',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9314000',
                'longitude' => '-80.6438000',
                'city' => 'Harmony',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27248',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8162000',
                'longitude' => '-79.7974000',
                'city' => 'Franklinville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27516',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3924000',
                'longitude' => '-78.9792000',
                'city' => 'Chapel Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28649',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2467000',
                'longitude' => '-81.1169000',
                'city' => 'Mc Grady',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27310',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Oak Ridge',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27313',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Pleasant Garden',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27231',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2495000',
                'longitude' => '-79.1961000',
                'city' => 'Cedar Grove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27314',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2495000',
                'longitude' => '-79.1961000',
                'city' => 'Prospect Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27288',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4682000',
                'longitude' => '-79.9094000',
                'city' => 'Eden',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27207',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5227000',
                'longitude' => '-79.5592000',
                'city' => 'Bear Creek',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27208',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5227000',
                'longitude' => '-79.5592000',
                'city' => 'Bennett',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27344',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5227000',
                'longitude' => '-79.5592000',
                'city' => 'Siler City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27325',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5227000',
                'longitude' => '-79.5592000',
                'city' => 'Robbins',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27574',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3924000',
                'longitude' => '-78.9792000',
                'city' => 'Roxboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27019',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2937000',
                'longitude' => '-80.1488000',
                'city' => 'Germanton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27022',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4149000',
                'longitude' => '-80.2080000',
                'city' => 'Lawsonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27046',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4149000',
                'longitude' => '-80.2080000',
                'city' => 'Sandy Ridge',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27016',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4149000',
                'longitude' => '-80.2080000',
                'city' => 'Danbury',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27051',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1785000',
                'longitude' => '-80.1576000',
                'city' => 'Walkertown',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27009',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1785000',
                'longitude' => '-80.1576000',
                'city' => 'Belews Creek',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27355',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8522000',
                'longitude' => '-79.5743000',
                'city' => 'Staley',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28651',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1656000',
                'longitude' => '-81.1390000',
                'city' => 'Millers Creek',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28654',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1656000',
                'longitude' => '-81.1390000',
                'city' => 'Moravian Falls',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28623',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.5014000',
                'longitude' => '-80.9753000',
                'city' => 'Ennice',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28665',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1656000',
                'longitude' => '-81.1390000',
                'city' => 'Purlear',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27233',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9616000',
                'longitude' => '-79.7624000',
                'city' => 'Climax',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28635',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2467000',
                'longitude' => '-81.1169000',
                'city' => 'Hays',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27157',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1004000',
                'longitude' => '-80.2518000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27374',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9141000',
                'longitude' => '-80.2491000',
                'city' => 'Welcome',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27316',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7315000',
                'longitude' => '-79.6561000',
                'city' => 'Ramseur',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27299',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7904000',
                'longitude' => '-80.4202000',
                'city' => 'Linwood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27109',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1331000',
                'longitude' => '-80.2598000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27152',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1004000',
                'longitude' => '-80.2518000',
                'city' => 'Winston Salem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27351',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6583000',
                'longitude' => '-80.2689000',
                'city' => 'Southmont',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27361',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9593000',
                'longitude' => '-79.9994000',
                'city' => 'Thomasville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28683',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3213000',
                'longitude' => '-80.8651000',
                'city' => 'Thurmond',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28626',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3332000',
                'longitude' => '-81.5398000',
                'city' => 'Fleetwood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27419',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'Greensboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28606',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0696000',
                'longitude' => '-81.2467000',
                'city' => 'Boomer',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27040',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1636000',
                'longitude' => '-80.3301000',
                'city' => 'Pfafftown',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27050',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1636000',
                'longitude' => '-80.3301000',
                'city' => 'Tobaccoville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28685',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3008000',
                'longitude' => '-81.0076000',
                'city' => 'Traphill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27261',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0748000',
                'longitude' => '-79.7810000',
                'city' => 'High Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28624',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1485000',
                'longitude' => '-81.2995000',
                'city' => 'Ferguson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28629',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4416000',
                'longitude' => '-81.4096000',
                'city' => 'Glendale Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28617',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.4416000',
                'longitude' => '-81.4096000',
                'city' => 'Crumpler',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28280',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28202',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28217',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28277',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28215',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28146',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6636000',
                'longitude' => '-80.4585000',
                'city' => 'Salisbury',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28244',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28174',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9804000',
                'longitude' => '-80.5498000',
                'city' => 'Wingate',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28110',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9804000',
                'longitude' => '-80.5498000',
                'city' => 'Monroe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28138',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5729000',
                'longitude' => '-80.4280000',
                'city' => 'Rockwell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28071',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5729000',
                'longitude' => '-80.4280000',
                'city' => 'Gold Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28072',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5729000',
                'longitude' => '-80.4280000',
                'city' => 'Granite Quarry',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28147',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6636000',
                'longitude' => '-80.4585000',
                'city' => 'Salisbury',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28101',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2606000',
                'longitude' => '-81.1827000',
                'city' => 'Mc Adenville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28056',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2606000',
                'longitude' => '-81.1827000',
                'city' => 'Gastonia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28052',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2606000',
                'longitude' => '-81.1827000',
                'city' => 'Gastonia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28112',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9804000',
                'longitude' => '-80.5498000',
                'city' => 'Monroe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28173',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9804000',
                'longitude' => '-80.5498000',
                'city' => 'Waxhaw',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28246',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28083',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4999000',
                'longitude' => '-80.6239000',
                'city' => 'Kannapolis',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28079',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9804000',
                'longitude' => '-80.5498000',
                'city' => 'Indian Trail',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28211',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2221000',
                'longitude' => '-80.8420000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28203',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2221000',
                'longitude' => '-80.8420000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28216',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2221000',
                'longitude' => '-80.8420000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28273',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2221000',
                'longitude' => '-80.8420000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28086',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1116000',
                'longitude' => '-81.2291000',
                'city' => 'Kings Mountain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28677',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7805000',
                'longitude' => '-80.8878000',
                'city' => 'Statesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28115',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5833000',
                'longitude' => '-80.8192000',
                'city' => 'Mooresville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28226',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6636000',
                'longitude' => '-80.4585000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28103',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9866000',
                'longitude' => '-80.4471000',
                'city' => 'Marshville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28117',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5833000',
                'longitude' => '-80.8192000',
                'city' => 'Mooresville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28209',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28271',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28204',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28213',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28035',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5011000',
                'longitude' => '-80.8489000',
                'city' => 'Davidson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28078',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6636000',
                'longitude' => '-80.4585000',
                'city' => 'Huntersville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28092',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4676000',
                'longitude' => '-81.2522000',
                'city' => 'Lincolnton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28001',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3519000',
                'longitude' => '-80.1993000',
                'city' => 'Albemarle',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28074',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6636000',
                'longitude' => '-80.4585000',
                'city' => 'Harris',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28105',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1802000',
                'longitude' => '-80.7812000',
                'city' => 'Matthews',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28281',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2196000',
                'longitude' => '-80.8372000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28678',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8670000',
                'longitude' => '-81.0481000',
                'city' => 'Stony Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28801',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7829000',
                'longitude' => '-80.8926000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28037',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5359000',
                'longitude' => '-81.0339000',
                'city' => 'Denver',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28205',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28027',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4117000',
                'longitude' => '-80.5786000',
                'city' => 'Concord',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28025',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3976000',
                'longitude' => '-80.5828000',
                'city' => 'Concord',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28120',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3634000',
                'longitude' => '-81.0991000',
                'city' => 'Mount Holly',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28034',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3634000',
                'longitude' => '-81.0991000',
                'city' => 'Dallas',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28006',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3634000',
                'longitude' => '-81.0991000',
                'city' => 'Alexis',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28080',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3634000',
                'longitude' => '-81.0991000',
                'city' => 'Iron Station',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28164',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3634000',
                'longitude' => '-81.0991000',
                'city' => 'Stanley',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28607',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1349000',
                'longitude' => '-80.9152000',
                'city' => 'Boone',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28097',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2556000',
                'longitude' => '-80.4329000',
                'city' => 'Locust',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28091',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9673000',
                'longitude' => '-79.9919000',
                'city' => 'Lilesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28135',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9998000',
                'longitude' => '-80.2318000',
                'city' => 'Polkton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28170',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9998000',
                'longitude' => '-80.2318000',
                'city' => 'Wadesboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28133',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9998000',
                'longitude' => '-80.2318000',
                'city' => 'Peachland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28163',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1420000',
                'longitude' => '-80.5069000',
                'city' => 'Stanfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28021',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5577000',
                'longitude' => '-81.4084000',
                'city' => 'Cherryville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28090',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5577000',
                'longitude' => '-81.4084000',
                'city' => 'Lawndale',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28168',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5577000',
                'longitude' => '-81.4084000',
                'city' => 'Vale',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28212',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28262',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28210',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27013',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7331000',
                'longitude' => '-80.6776000',
                'city' => 'Cleveland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28125',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7331000',
                'longitude' => '-80.6776000',
                'city' => 'Mount Ulla',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28041',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5729000',
                'longitude' => '-80.4280000',
                'city' => 'Faith',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28278',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28224',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28270',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28206',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28208',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28150',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2846000',
                'longitude' => '-81.5398000',
                'city' => 'Shelby',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28227',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28152',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3174000',
                'longitude' => '-81.6600000',
                'city' => 'Shelby',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28214',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2221000',
                'longitude' => '-80.8420000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28104',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1179000',
                'longitude' => '-80.7228000',
                'city' => 'Matthews',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28658',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6673000',
                'longitude' => '-81.2196000',
                'city' => 'Newton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28031',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Cornelius',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28269',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28207',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28134',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Pineville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28255',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28036',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Davidson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28284',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28285',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28242',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28288',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28282',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28904',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Hayesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28016',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2847000',
                'longitude' => '-81.2836000',
                'city' => 'Bessemer City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28630',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2606000',
                'longitude' => '-81.1827000',
                'city' => 'Granite Falls',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28637',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7829000',
                'longitude' => '-80.8926000',
                'city' => 'Hildebran',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28017',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2846000',
                'longitude' => '-81.5398000',
                'city' => 'Boiling Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28650',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Maiden',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28218',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28012',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2437000',
                'longitude' => '-81.0443000',
                'city' => 'Belmont',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28009',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4065000',
                'longitude' => '-80.1178000',
                'city' => 'Badin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28081',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3976000',
                'longitude' => '-80.5828000',
                'city' => 'Kannapolis',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28124',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1894000',
                'longitude' => '-80.9266000',
                'city' => 'Mount Pleasant',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28128',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.1238000',
                'city' => 'Norwood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28040',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2945000',
                'longitude' => '-81.6574000',
                'city' => 'Ellenboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28089',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2945000',
                'longitude' => '-81.6574000',
                'city' => 'Lattimore',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28114',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2945000',
                'longitude' => '-81.6574000',
                'city' => 'Mooresboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28033',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3787000',
                'longitude' => '-81.3846000',
                'city' => 'Crouse',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28655',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7829000',
                'longitude' => '-80.8926000',
                'city' => 'Morganton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27306',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5011000',
                'longitude' => '-80.8489000',
                'city' => 'Mount Gilead',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28625',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7829000',
                'longitude' => '-80.8926000',
                'city' => 'Statesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28107',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3184000',
                'longitude' => '-80.6501000',
                'city' => 'Midland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28075',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3184000',
                'longitude' => '-80.6501000',
                'city' => 'Harrisburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28073',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1648000',
                'longitude' => '-81.4514000',
                'city' => 'Grover',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28602',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5577000',
                'longitude' => '-81.4084000',
                'city' => 'Hickory',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28137',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4406000',
                'longitude' => '-80.2239000',
                'city' => 'Richfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28129',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.1238000',
                'city' => 'Oakboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28609',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2167000',
                'longitude' => '-80.8527000',
                'city' => 'Catawba',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28771',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4676000',
                'longitude' => '-81.2522000',
                'city' => 'Robbinsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28673',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5295000',
                'longitude' => '-81.0321000',
                'city' => 'Sherrills Ford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28222',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28299',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28297',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1753000',
                'longitude' => '-80.8777000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28247',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28166',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7002000',
                'longitude' => '-80.8894000',
                'city' => 'Troutman',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28020',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4182000',
                'longitude' => '-81.5598000',
                'city' => 'Casar',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28136',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4182000',
                'longitude' => '-81.5598000',
                'city' => 'Polkville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28660',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0207000',
                'longitude' => '-80.8624000',
                'city' => 'Olin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '29201',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Columbia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28106',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Matthews',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28636',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8646000',
                'longitude' => '-81.0433000',
                'city' => 'Hiddenite',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '29715',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Fort Mill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28220',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28054',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Gastonia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28716',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2606000',
                'longitude' => '-81.1827000',
                'city' => 'Canton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28236',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2556000',
                'longitude' => '-80.4329000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28223',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2167000',
                'longitude' => '-80.8527000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28791',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5833000',
                'longitude' => '-80.8192000',
                'city' => 'Hendersonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28739',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9804000',
                'longitude' => '-80.5498000',
                'city' => 'Hendersonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28266',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28287',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1179000',
                'longitude' => '-80.7228000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28622',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1894000',
                'longitude' => '-80.9266000',
                'city' => 'Elk Park',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28023',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'China Grove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28645',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6636000',
                'longitude' => '-80.4585000',
                'city' => 'Lenoir',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28070',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Huntersville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28752',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Marion',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28664',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5011000',
                'longitude' => '-80.8489000',
                'city' => 'Plumtree',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28126',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Newell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28098',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2713000',
                'longitude' => '-81.1095000',
                'city' => 'Lowell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28032',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2713000',
                'longitude' => '-81.1095000',
                'city' => 'Cramerton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28007',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1014000',
                'longitude' => '-80.1138000',
                'city' => 'Ansonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28687',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7805000',
                'longitude' => '-80.8878000',
                'city' => 'Statesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28108',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9251000',
                'longitude' => '-80.7376000',
                'city' => 'Mineral Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28102',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8628000',
                'longitude' => '-79.9997000',
                'city' => 'Mc Farlan',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28119',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8628000',
                'longitude' => '-79.9997000',
                'city' => 'Morven',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28088',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5660000',
                'longitude' => '-80.5731000',
                'city' => 'Landis',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28712',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2606000',
                'longitude' => '-81.1827000',
                'city' => 'Brevard',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28729',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2245000',
                'longitude' => '-80.8468000',
                'city' => 'Etowah',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28732',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Fletcher',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28231',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2260000',
                'longitude' => '-80.8390000',
                'city' => 'Charlotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28741',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0584000',
                'longitude' => '-83.2003000',
                'city' => 'Highlands',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28043',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3239000',
                'longitude' => '-81.8662000',
                'city' => 'Forest City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28805',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8021000',
                'longitude' => '-82.6850000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28806',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5962000',
                'longitude' => '-82.5592000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28714',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9152000',
                'longitude' => '-82.2912000',
                'city' => 'Burnsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28803',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5962000',
                'longitude' => '-82.5592000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28804',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5962000',
                'longitude' => '-82.5592000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28802',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5962000',
                'longitude' => '-82.5592000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28704',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4827000',
                'longitude' => '-82.5240000',
                'city' => 'Arden',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28786',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3732000',
                'longitude' => '-83.2229000',
                'city' => 'Waynesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28723',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3151000',
                'longitude' => '-83.1797000',
                'city' => 'Cullowhee',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28738',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Hazelwood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28711',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Black Mountain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28730',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Fairview',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28715',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Candler',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28792',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3162000',
                'longitude' => '-82.4685000',
                'city' => 'Hendersonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28721',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5306000',
                'longitude' => '-82.8418000',
                'city' => 'Clyde',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28761',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6947000',
                'longitude' => '-82.0724000',
                'city' => 'Nebo',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28810',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28610',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7082000',
                'longitude' => '-81.0762000',
                'city' => 'Claremont',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28709',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Barnardsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28018',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3317000',
                'longitude' => '-81.8603000',
                'city' => 'Bostic',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28139',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3317000',
                'longitude' => '-81.8603000',
                'city' => 'Rutherfordton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28785',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4914000',
                'longitude' => '-82.9813000',
                'city' => 'Waynesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28613',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7577000',
                'longitude' => '-81.2705000',
                'city' => 'Conover',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28601',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7577000',
                'longitude' => '-81.2705000',
                'city' => 'Hickory',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28604',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1683000',
                'longitude' => '-81.8779000',
                'city' => 'Banner Elk',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28605',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2178000',
                'longitude' => '-81.6740000',
                'city' => 'Blowing Rock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28779',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3749000',
                'longitude' => '-83.2152000',
                'city' => 'Sylva',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28731',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3776000',
                'longitude' => '-82.3646000',
                'city' => 'Flat Rock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28713',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Bryson City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28160',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3622000',
                'longitude' => '-81.9433000',
                'city' => 'Spindale',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28167',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3622000',
                'longitude' => '-81.9433000',
                'city' => 'Union Mills',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28783',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3151000',
                'longitude' => '-83.1797000',
                'city' => 'Tuckasegee',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28778',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5875000',
                'longitude' => '-82.4867000',
                'city' => 'Swannanoa',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28692',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2430000',
                'longitude' => '-81.7686000',
                'city' => 'Vilas',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28679',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.2430000',
                'longitude' => '-81.7686000',
                'city' => 'Sugar Grove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28612',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7341000',
                'longitude' => '-81.3418000',
                'city' => 'Connellys Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28681',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7341000',
                'longitude' => '-81.3418000',
                'city' => 'Taylorsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28638',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7980000',
                'longitude' => '-81.4264000',
                'city' => 'Hudson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28667',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7980000',
                'longitude' => '-81.4264000',
                'city' => 'Rhodhiss',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28787',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8265000',
                'longitude' => '-82.5483000',
                'city' => 'Weaverville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28781',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2025000',
                'longitude' => '-83.8239000',
                'city' => 'Topton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28901',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2025000',
                'longitude' => '-83.8239000',
                'city' => 'Andrews',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28734',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1841000',
                'longitude' => '-83.3837000',
                'city' => 'Franklin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28763',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1841000',
                'longitude' => '-83.3837000',
                'city' => 'Otto',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28906',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0853000',
                'longitude' => '-84.0351000',
                'city' => 'Murphy',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28902',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0743000',
                'longitude' => '-84.1914000',
                'city' => 'Brasstown',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28905',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0743000',
                'longitude' => '-84.1914000',
                'city' => 'Marble',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28717',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1167000',
                'longitude' => '-83.1003000',
                'city' => 'Cashiers',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28690',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7507000',
                'longitude' => '-81.5679000',
                'city' => 'Valdese',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28657',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0914000',
                'longitude' => '-81.9293000',
                'city' => 'Newland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28777',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9168000',
                'longitude' => '-82.0655000',
                'city' => 'Spruce Pine',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28754',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8265000',
                'longitude' => '-82.5483000',
                'city' => 'Mars Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28909',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0454000',
                'longitude' => '-83.8175000',
                'city' => 'Warne',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28816',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Asheville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28619',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7446000',
                'longitude' => '-81.6853000',
                'city' => 'Drexel',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28719',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7446000',
                'longitude' => '-81.6853000',
                'city' => 'Cherokee',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28745',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4858000',
                'longitude' => '-82.9919000',
                'city' => 'Lake Junaluska',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28682',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6212000',
                'longitude' => '-80.9897000',
                'city' => 'Terrell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28702',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3236000',
                'longitude' => '-83.8101000',
                'city' => 'Almond',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28743',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8189000',
                'longitude' => '-83.1510000',
                'city' => 'Hot Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28789',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4312000',
                'longitude' => '-83.4457000',
                'city' => 'Whittier',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28733',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4339000',
                'longitude' => '-83.8300000',
                'city' => 'Fontana Dam',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28748',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6501000',
                'longitude' => '-82.7025000',
                'city' => 'Leicester',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28775',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0521000',
                'longitude' => '-83.1983000',
                'city' => 'Scaly Mountain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28705',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0166000',
                'longitude' => '-82.1702000',
                'city' => 'Bakersville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28762',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7992000',
                'longitude' => '-82.0340000',
                'city' => 'Old Fort',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28740',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9105000',
                'longitude' => '-82.2165000',
                'city' => 'Green Mountain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28751',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5195000',
                'longitude' => '-83.0395000',
                'city' => 'Maggie Valley',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28725',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3732000',
                'longitude' => '-83.2229000',
                'city' => 'Dillsboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28788',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3732000',
                'longitude' => '-83.2229000',
                'city' => 'Webster',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28735',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4373000',
                'longitude' => '-82.2353000',
                'city' => 'Gerton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28746',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4373000',
                'longitude' => '-82.2353000',
                'city' => 'Lake Lure',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28720',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4373000',
                'longitude' => '-82.2353000',
                'city' => 'Chimney Rock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28756',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4373000',
                'longitude' => '-82.2353000',
                'city' => 'Mill Spring',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28710',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4373000',
                'longitude' => '-82.2353000',
                'city' => 'Bat Cave',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28701',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6956000',
                'longitude' => '-82.5654000',
                'city' => 'Alexander',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28753',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8021000',
                'longitude' => '-82.6850000',
                'city' => 'Marshall',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28757',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6204000',
                'longitude' => '-82.3242000',
                'city' => 'Montreat',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28728',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5505000',
                'longitude' => '-82.6519000',
                'city' => 'Enka',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28755',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9105000',
                'longitude' => '-82.2165000',
                'city' => 'Micaville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28727',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3776000',
                'longitude' => '-82.3646000',
                'city' => 'Edneyville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28790',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3139000',
                'longitude' => '-82.4637000',
                'city' => 'Zirconia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28726',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3139000',
                'longitude' => '-82.4637000',
                'city' => 'East Flat Rock',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28793',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3162000',
                'longitude' => '-82.4685000',
                'city' => 'Hendersonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28776',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5923000',
                'longitude' => '-82.5621000',
                'city' => 'Skyland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28646',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0875000',
                'longitude' => '-81.9322000',
                'city' => 'Linville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28737',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5991000',
                'longitude' => '-82.0311000',
                'city' => 'Glenwood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28774',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1064000',
                'longitude' => '-83.1012000',
                'city' => 'Sapphire',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28736',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1064000',
                'longitude' => '-83.1012000',
                'city' => 'Glenville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28773',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2428000',
                'longitude' => '-82.3518000',
                'city' => 'Saluda',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28611',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9118000',
                'longitude' => '-81.5464000',
                'city' => 'Collettsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28603',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7341000',
                'longitude' => '-81.3418000',
                'city' => 'Hickory',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28722',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2589000',
                'longitude' => '-82.1891000',
                'city' => 'Columbus',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28782',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2086000',
                'longitude' => '-82.2392000',
                'city' => 'Tryon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28750',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2086000',
                'longitude' => '-82.2392000',
                'city' => 'Lynn',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28747',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2334000',
                'longitude' => '-82.7364000',
                'city' => 'Lake Toxaway',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28772',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2334000',
                'longitude' => '-82.7364000',
                'city' => 'Rosman',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28768',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2334000',
                'longitude' => '-82.7364000',
                'city' => 'Pisgah Forest',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28671',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7507000',
                'longitude' => '-81.5679000',
                'city' => 'Rutherford College',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28766',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2334000',
                'longitude' => '-82.7364000',
                'city' => 'Penrose',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28708',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2334000',
                'longitude' => '-82.7364000',
                'city' => 'Balsam Grove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28718',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2334000',
                'longitude' => '-82.7364000',
                'city' => 'Cedar Mountain',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28742',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3652000',
                'longitude' => '-82.5574000',
                'city' => 'Horse Shoe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28412',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Wilmington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28403',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Wilmington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28465',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '33.9114000',
                'longitude' => '-78.1230000',
                'city' => 'Oak Island',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28405',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Wilmington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28363',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8866000',
                'longitude' => '-79.7030000',
                'city' => 'Marston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28345',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8866000',
                'longitude' => '-79.7030000',
                'city' => 'Hamlet',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28379',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8866000',
                'longitude' => '-79.7030000',
                'city' => 'Rockingham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28472',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3362000',
                'longitude' => '-78.7013000',
                'city' => 'Whiteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28468',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '33.9730000',
                'longitude' => '-78.3851000',
                'city' => 'Sunset Beach',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28469',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '33.9730000',
                'longitude' => '-78.3851000',
                'city' => 'Ocean Isle Beach',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28305',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0395000',
                'longitude' => '-78.8646000',
                'city' => 'Fayetteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28306',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0395000',
                'longitude' => '-78.8646000',
                'city' => 'Fayetteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28328',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0024000',
                'longitude' => '-78.3257000',
                'city' => 'Clinton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27376',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1892000',
                'longitude' => '-79.4741000',
                'city' => 'West End',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28315',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1892000',
                'longitude' => '-79.4741000',
                'city' => 'Aberdeen',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27281',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1892000',
                'longitude' => '-79.4741000',
                'city' => 'Jackson Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28374',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1892000',
                'longitude' => '-79.4741000',
                'city' => 'Pinehurst',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28352',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7664000',
                'longitude' => '-79.4648000',
                'city' => 'Laurinburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28401',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Wilmington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28547',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7451000',
                'longitude' => '-77.3662000',
                'city' => 'Camp Lejeune',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28539',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7451000',
                'longitude' => '-77.3662000',
                'city' => 'Hubert',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28543',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7451000',
                'longitude' => '-77.3662000',
                'city' => 'Tarawa Terrace',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28544',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7451000',
                'longitude' => '-77.3662000',
                'city' => 'Midway Park',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28546',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7451000',
                'longitude' => '-77.3662000',
                'city' => 'Jacksonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28301',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0521000',
                'longitude' => '-78.8880000',
                'city' => 'Fayetteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28348',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0521000',
                'longitude' => '-78.8880000',
                'city' => 'Hope Mills',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28303',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0521000',
                'longitude' => '-78.8880000',
                'city' => 'Fayetteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28391',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0546000',
                'longitude' => '-78.8927000',
                'city' => 'Stedman',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28395',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0546000',
                'longitude' => '-78.8927000',
                'city' => 'Wade',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28304',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0546000',
                'longitude' => '-78.8927000',
                'city' => 'Fayetteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28360',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6275000',
                'longitude' => '-79.0094000',
                'city' => 'Lumberton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28398',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0014000',
                'longitude' => '-78.0918000',
                'city' => 'Warsaw',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28377',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8192000',
                'longitude' => '-79.1845000',
                'city' => 'Red Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27521',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3063000',
                'longitude' => '-78.6178000',
                'city' => 'Coats',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28339',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3063000',
                'longitude' => '-78.6178000',
                'city' => 'Erwin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27501',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3063000',
                'longitude' => '-78.6178000',
                'city' => 'Angier',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28334',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3063000',
                'longitude' => '-78.6178000',
                'city' => 'Dunn',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28411',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Wilmington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28366',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2501000',
                'longitude' => '-78.3480000',
                'city' => 'Newton Grove',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28376',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0546000',
                'longitude' => '-78.8927000',
                'city' => 'Raeford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28545',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8052000',
                'longitude' => '-77.4448000',
                'city' => 'Mccutcheon Field',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28480',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2162000',
                'longitude' => '-77.8202000',
                'city' => 'Wrightsville Beach',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28364',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7335000',
                'longitude' => '-79.3512000',
                'city' => 'Maxton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28384',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8084000',
                'longitude' => '-78.9807000',
                'city' => 'Saint Pauls',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27546',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3906000',
                'longitude' => '-78.8258000',
                'city' => 'Lillington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28308',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1391000',
                'longitude' => '-78.9793000',
                'city' => 'Pope A F B',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28350',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2586000',
                'longitude' => '-79.2859000',
                'city' => 'Lakeview',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28394',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2586000',
                'longitude' => '-79.2859000',
                'city' => 'Vass',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28326',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2586000',
                'longitude' => '-79.2859000',
                'city' => 'Cameron',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28327',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2586000',
                'longitude' => '-79.2859000',
                'city' => 'Carthage',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28387',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1722000',
                'longitude' => '-79.4008000',
                'city' => 'Southern Pines',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28337',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6252000',
                'longitude' => '-78.6197000',
                'city' => 'Elizabethtown',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28463',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9820000',
                'longitude' => '-79.2372000',
                'city' => 'Tabor City',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28429',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2354000',
                'longitude' => '-77.9446000',
                'city' => 'Castle Hayne',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28461',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0689000',
                'longitude' => '-78.1504000',
                'city' => 'Southport',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28451',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0689000',
                'longitude' => '-78.1504000',
                'city' => 'Leland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28479',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0689000',
                'longitude' => '-78.1504000',
                'city' => 'Winnabow',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28422',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0689000',
                'longitude' => '-78.1504000',
                'city' => 'Bolivia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28358',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6275000',
                'longitude' => '-79.0094000',
                'city' => 'Lumberton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28457',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5491000',
                'longitude' => '-77.9272000',
                'city' => 'Rocky Point',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28454',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5491000',
                'longitude' => '-77.9272000',
                'city' => 'Maple Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28435',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5491000',
                'longitude' => '-77.9272000',
                'city' => 'Currie',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28425',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5491000',
                'longitude' => '-77.9272000',
                'city' => 'Burgaw',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28390',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0546000',
                'longitude' => '-78.8927000',
                'city' => 'Spring Lake',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28351',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7728000',
                'longitude' => '-79.4665000',
                'city' => 'Laurel Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28341',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1119000',
                'longitude' => '-78.1436000',
                'city' => 'Faison',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28343',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7607000',
                'longitude' => '-79.6085000',
                'city' => 'Gibson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28443',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3950000',
                'longitude' => '-77.6773000',
                'city' => 'Hampstead',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28518',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9594000',
                'longitude' => '-77.9646000',
                'city' => 'Beulaville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28453',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9594000',
                'longitude' => '-77.9646000',
                'city' => 'Magnolia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28349',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9594000',
                'longitude' => '-77.9646000',
                'city' => 'Kenansville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28396',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1091000',
                'longitude' => '-79.4771000',
                'city' => 'Wagram',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28347',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1091000',
                'longitude' => '-79.4771000',
                'city' => 'Hoffman',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28373',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1091000',
                'longitude' => '-79.4771000',
                'city' => 'Pinebluff',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28464',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8324000',
                'longitude' => '-78.0336000',
                'city' => 'Teachey',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28478',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5263000',
                'longitude' => '-78.1056000',
                'city' => 'Willard',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28447',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5263000',
                'longitude' => '-78.1056000',
                'city' => 'Ivanhoe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28421',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5263000',
                'longitude' => '-78.1056000',
                'city' => 'Atkinson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28466',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7321000',
                'longitude' => '-78.0006000',
                'city' => 'Wallace',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28521',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7321000',
                'longitude' => '-78.0006000',
                'city' => 'Chinquapin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28467',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0015000',
                'longitude' => '-78.5477000',
                'city' => 'Calabash',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28452',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0015000',
                'longitude' => '-78.5477000',
                'city' => 'Longwood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28420',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0015000',
                'longitude' => '-78.5477000',
                'city' => 'Ash',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28393',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0024000',
                'longitude' => '-78.3257000',
                'city' => 'Turkey',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28311',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0546000',
                'longitude' => '-78.8927000',
                'city' => 'Fayetteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28409',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2049000',
                'longitude' => '-77.8892000',
                'city' => 'Wilmington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28433',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.4928000',
                'longitude' => '-78.6574000',
                'city' => 'Clarkton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28540',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9009000',
                'longitude' => '-77.5483000',
                'city' => 'Jacksonville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28574',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9009000',
                'longitude' => '-77.5483000',
                'city' => 'Richlands',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28555',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6938000',
                'longitude' => '-77.1257000',
                'city' => 'Maysville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28445',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5651000',
                'longitude' => '-77.3989000',
                'city' => 'Holly Ridge',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28460',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5651000',
                'longitude' => '-77.3989000',
                'city' => 'Sneads Ferry',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28459',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9594000',
                'longitude' => '-77.9646000',
                'city' => 'Shallotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28372',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8192000',
                'longitude' => '-79.1845000',
                'city' => 'Pembroke',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28386',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8192000',
                'longitude' => '-79.1845000',
                'city' => 'Shannon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28314',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0546000',
                'longitude' => '-78.8927000',
                'city' => 'Fayetteville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28310',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1391000',
                'longitude' => '-78.9793000',
                'city' => 'Fort Bragg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28307',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1391000',
                'longitude' => '-78.9793000',
                'city' => 'Fort Bragg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28436',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6275000',
                'longitude' => '-79.0094000',
                'city' => 'Delco',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28340',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5382000',
                'longitude' => '-79.2914000',
                'city' => 'Fairmont',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28383',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5382000',
                'longitude' => '-79.2914000',
                'city' => 'Rowland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28371',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0122000',
                'longitude' => '-78.9665000',
                'city' => 'Parkton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27356',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3467000',
                'longitude' => '-79.7843000',
                'city' => 'Star',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27209',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3467000',
                'longitude' => '-79.7843000',
                'city' => 'Biscoe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28542',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7451000',
                'longitude' => '-77.3662000',
                'city' => 'Camp Lejeune',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28449',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0347000',
                'longitude' => '-77.8990000',
                'city' => 'Kure Beach',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28428',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.0347000',
                'longitude' => '-77.8990000',
                'city' => 'Carolina Beach',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27607',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28356',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1028000',
                'longitude' => '-78.9011000',
                'city' => 'Linden',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28431',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3252000',
                'longitude' => '-78.8226000',
                'city' => 'Chadbourn',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28402',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Wilmington',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28470',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.2227000',
                'longitude' => '-77.9415000',
                'city' => 'Shallotte',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28382',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9510000',
                'longitude' => '-78.5141000',
                'city' => 'Roseboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28385',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9510000',
                'longitude' => '-78.5141000',
                'city' => 'Salemburg',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28318',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.9510000',
                'longitude' => '-78.5141000',
                'city' => 'Autryville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28441',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7850000',
                'longitude' => '-78.3994000',
                'city' => 'Garland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28444',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7358000',
                'longitude' => '-78.2183000',
                'city' => 'Harrells',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28450',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3181000',
                'longitude' => '-78.5166000',
                'city' => 'Lake Waccamaw',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28344',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.1669000',
                'longitude' => '-78.5693000',
                'city' => 'Godwin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27229',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3590000',
                'longitude' => '-79.9014000',
                'city' => 'Candor',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27524',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2501000',
                'longitude' => '-78.3480000',
                'city' => 'Four Oaks',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28365',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2501000',
                'longitude' => '-78.3480000',
                'city' => 'Mount Olive',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28369',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.4994000',
                'longitude' => '-79.1165000',
                'city' => 'Orrum',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28455',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3362000',
                'longitude' => '-78.7013000',
                'city' => 'Nakina',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28442',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3362000',
                'longitude' => '-78.7013000',
                'city' => 'Hallsboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28424',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3362000',
                'longitude' => '-78.7013000',
                'city' => 'Brunswick',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28434',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5162000',
                'longitude' => '-78.5391000',
                'city' => 'Council',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28438',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5165000',
                'longitude' => '-78.7317000',
                'city' => 'Evergreen',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28320',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.5165000',
                'longitude' => '-78.7317000',
                'city' => 'Bladenboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28439',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3183000',
                'longitude' => '-79.0330000',
                'city' => 'Fair Bluff',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28430',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3183000',
                'longitude' => '-79.0330000',
                'city' => 'Cerro Gordo',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28367',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0665000',
                'longitude' => '-79.7557000',
                'city' => 'Norman',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28338',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.0665000',
                'longitude' => '-79.7557000',
                'city' => 'Ellerbe',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28432',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.1506000',
                'longitude' => '-78.8734000',
                'city' => 'Clarendon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28456',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3241000',
                'longitude' => '-78.2063000',
                'city' => 'Riegelwood',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28423',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.3241000',
                'longitude' => '-78.2063000',
                'city' => 'Bolton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28448',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.4612000',
                'longitude' => '-78.3174000',
                'city' => 'Kelly',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27242',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2389000',
                'longitude' => '-79.5685000',
                'city' => 'Eagle Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28462',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '33.9730000',
                'longitude' => '-78.3851000',
                'city' => 'Supply',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28323',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3906000',
                'longitude' => '-78.8258000',
                'city' => 'Bunnlevel',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27505',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3906000',
                'longitude' => '-78.8258000',
                'city' => 'Broadway',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27506',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3906000',
                'longitude' => '-78.8258000',
                'city' => 'Buies Creek',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28357',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.8192000',
                'longitude' => '-79.1845000',
                'city' => 'Lumber Bridge',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28392',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6252000',
                'longitude' => '-78.6197000',
                'city' => 'Tar Heel',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28332',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.6252000',
                'longitude' => '-78.6197000',
                'city' => 'Dublin',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28399',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '34.7493000',
                'longitude' => '-78.7079000',
                'city' => 'White Oak',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27330',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3386000',
                'longitude' => '-79.4166000',
                'city' => 'Sanford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28342',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3063000',
                'longitude' => '-78.6178000',
                'city' => 'Falcon',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27504',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9930000',
                'longitude' => '-78.9087000',
                'city' => 'Benson',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27569',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5383000',
                'longitude' => '-78.2840000',
                'city' => 'Princeton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27577',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5383000',
                'longitude' => '-78.2840000',
                'city' => 'Smithfield',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27576',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5383000',
                'longitude' => '-78.2840000',
                'city' => 'Selma',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27617',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9026000',
                'longitude' => '-78.9138000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27711',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9026000',
                'longitude' => '-78.9138000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27560',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9026000',
                'longitude' => '-78.9138000',
                'city' => 'Morrisville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27592',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3803000',
                'longitude' => '-78.5516000',
                'city' => 'Willow Spring',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27605',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27520',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5153000',
                'longitude' => '-78.3431000',
                'city' => 'Clayton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27603',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27604',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7794000',
                'longitude' => '-78.5803000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27610',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7794000',
                'longitude' => '-78.5803000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27701',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27511',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Cary',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27619',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27517',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9157000',
                'longitude' => '-79.0519000',
                'city' => 'Chapel Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27616',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7987000',
                'longitude' => '-78.4834000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27587',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7987000',
                'longitude' => '-78.4834000',
                'city' => 'Wake Forest',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27591',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7987000',
                'longitude' => '-78.4834000',
                'city' => 'Wendell',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27545',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7987000',
                'longitude' => '-78.4834000',
                'city' => 'Knightdale',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27526',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Fuquay Varina',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27602',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27612',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27613',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27614',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27278',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Hillsborough',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27705',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0261000',
                'longitude' => '-78.8887000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27704',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0261000',
                'longitude' => '-78.8887000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27534',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3848000',
                'longitude' => '-77.9896000',
                'city' => 'Goldsboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27531',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3848000',
                'longitude' => '-77.9896000',
                'city' => 'Goldsboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27702',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9026000',
                'longitude' => '-78.9138000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27713',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9026000',
                'longitude' => '-78.9138000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27709',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9026000',
                'longitude' => '-78.9138000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27715',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9930000',
                'longitude' => '-78.9087000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27707',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9930000',
                'longitude' => '-78.9087000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27609',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7270000',
                'longitude' => '-78.6565000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27615',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7270000',
                'longitude' => '-78.6565000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27606',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7270000',
                'longitude' => '-78.6565000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27529',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7270000',
                'longitude' => '-78.6565000',
                'city' => 'Garner',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27601',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7270000',
                'longitude' => '-78.6565000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27608',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7270000',
                'longitude' => '-78.6565000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27502',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7888000',
                'longitude' => '-78.7823000',
                'city' => 'Apex',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27513',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7888000',
                'longitude' => '-78.7823000',
                'city' => 'Cary',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27514',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9157000',
                'longitude' => '-79.0519000',
                'city' => 'Chapel Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27830',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5419000',
                'longitude' => '-77.9768000',
                'city' => 'Fremont',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27863',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5419000',
                'longitude' => '-77.9768000',
                'city' => 'Pikeville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27243',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0757000',
                'longitude' => '-79.1050000',
                'city' => 'Efland',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27332',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4462000',
                'longitude' => '-79.0634000',
                'city' => 'Sanford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27510',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9080000',
                'longitude' => '-79.0581000',
                'city' => 'Carrboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27515',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9157000',
                'longitude' => '-79.0519000',
                'city' => 'Chapel Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27703',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9930000',
                'longitude' => '-78.9087000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27522',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1135000',
                'longitude' => '-78.6823000',
                'city' => 'Creedmoor',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27555',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5903000',
                'longitude' => '-78.1267000',
                'city' => 'Micro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27530',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2973000',
                'longitude' => '-78.1618000',
                'city' => 'Goldsboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27622',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27712',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27540',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7350000',
                'longitude' => '-78.8661000',
                'city' => 'Holly Springs',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27508',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1002000',
                'longitude' => '-78.2987000',
                'city' => 'Bunn',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27525',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1002000',
                'longitude' => '-78.2987000',
                'city' => 'Franklinton',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27596',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1002000',
                'longitude' => '-78.2987000',
                'city' => 'Youngsville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27562',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7350000',
                'longitude' => '-78.8661000',
                'city' => 'New Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27636',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27312',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Pittsboro',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27519',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7825000',
                'longitude' => '-78.7807000',
                'city' => 'Cary',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27624',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27699',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8981000',
                'longitude' => '-78.8024000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27512',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Cary',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27588',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8315000',
                'longitude' => '-78.6058000',
                'city' => 'Wake Forest',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27503',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.0502000',
                'longitude' => '-78.9031000',
                'city' => 'Bahama',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28368',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3581000',
                'longitude' => '-79.1133000',
                'city' => 'Olivia',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27252',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5990000',
                'longitude' => '-79.3313000',
                'city' => 'Goldston',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27629',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7767000',
                'longitude' => '-78.6366000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27695',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7767000',
                'longitude' => '-78.6366000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27581',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1199000',
                'longitude' => '-78.6839000',
                'city' => 'Stem',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27559',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7175000',
                'longitude' => '-79.1834000',
                'city' => 'Moncure',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27628',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9026000',
                'longitude' => '-78.9138000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27571',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9817000',
                'longitude' => '-78.5178000',
                'city' => 'Rolesville',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27509',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.1336000',
                'longitude' => '-78.7611000',
                'city' => 'Butner',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28333',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.3848000',
                'longitude' => '-77.9896000',
                'city' => 'Dudley',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27543',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8180000',
                'longitude' => '-78.8061000',
                'city' => 'Kipling',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27623',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27708',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9943000',
                'longitude' => '-78.9008000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27722',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8180000',
                'longitude' => '-78.8061000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27658',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '28325',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.2008000',
                'longitude' => '-78.0650000',
                'city' => 'Calypso',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27710',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.9943000',
                'longitude' => '-78.9008000',
                'city' => 'Durham',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27582',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '36.3071000',
                'longitude' => '-78.5928000',
                'city' => 'Stovall',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27697',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7767000',
                'longitude' => '-78.6366000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27331',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.4796000',
                'longitude' => '-79.1777000',
                'city' => 'Sanford',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27599',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.8315000',
                'longitude' => '-78.6058000',
                'city' => 'Chapel Hill',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27213',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.6503000',
                'longitude' => '-79.4182000',
                'city' => 'Bonlee',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27256',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5990000',
                'longitude' => '-79.3313000',
                'city' => 'Gulf',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27539',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7249000',
                'longitude' => '-78.8472000',
                'city' => 'Apex',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27568',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.5383000',
                'longitude' => '-78.2840000',
                'city' => 'Pine Level',
                'full_state' => 'North Carolina',
            ],
            [
                'zip' => '27675',
                'country_code' => 'US',
                'state' => 'NC',
                'latitude' => '35.7843000',
                'longitude' => '-78.6508000',
                'city' => 'Raleigh',
                'full_state' => 'North Carolina',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
