<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MinnesotaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '56762',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.2103000',
                'longitude' => '-96.8035000',
                'city' => 'Warren',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56630',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.7813000',
                'longitude' => '-94.6984000',
                'city' => 'Blackduck',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56627',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.7813000',
                'longitude' => '-94.6984000',
                'city' => 'Big Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56521',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0963000',
                'longitude' => '-95.8453000',
                'city' => 'Callaway',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56589',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0963000',
                'longitude' => '-95.8453000',
                'city' => 'Waubun',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56537',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.2838000',
                'longitude' => '-96.0670000',
                'city' => 'Fergus Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55802',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7875000',
                'longitude' => '-92.1013000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55806',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7875000',
                'longitude' => '-92.1013000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56721',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.9347000',
                'longitude' => '-97.0165000',
                'city' => 'East Grand Forks',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55746',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4259000',
                'longitude' => '-92.9312000',
                'city' => 'Hibbing',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56601',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4646000',
                'longitude' => '-94.8854000',
                'city' => 'Bemidji',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55744',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2350000',
                'longitude' => '-93.5246000',
                'city' => 'Grand Rapids',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55805',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55750',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5177000',
                'longitude' => '-92.1603000',
                'city' => 'Hoyt Lakes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55603',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2981000',
                'longitude' => '-91.2527000',
                'city' => 'Finland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56737',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.4338000',
                'longitude' => '-96.1631000',
                'city' => 'Middle River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56759',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.4338000',
                'longitude' => '-96.1631000',
                'city' => 'Strathcona',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56738',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.4338000',
                'longitude' => '-96.1631000',
                'city' => 'Newfolden',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56711',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '49.3424000',
                'longitude' => '-95.0736000',
                'city' => 'Angle Inlet',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56741',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '49.3424000',
                'longitude' => '-95.0736000',
                'city' => 'Oak Island',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56436',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2132000',
                'longitude' => '-94.7513000',
                'city' => 'Benedict',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56461',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2132000',
                'longitude' => '-94.7513000',
                'city' => 'Laporte',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55601',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2959000',
                'longitude' => '-91.2617000',
                'city' => 'Beaver Bay',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55616',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2959000',
                'longitude' => '-91.2617000',
                'city' => 'Two Harbors',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55614',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2959000',
                'longitude' => '-91.2617000',
                'city' => 'Silver Bay',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56563',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8779000',
                'longitude' => '-96.7852000',
                'city' => 'Moorhead',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56562',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8779000',
                'longitude' => '-96.7852000',
                'city' => 'Moorhead',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56482',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4404000',
                'longitude' => '-95.1341000',
                'city' => 'Wadena',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55705',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5287000',
                'longitude' => '-92.2423000',
                'city' => 'Aurora',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56425',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3496000',
                'longitude' => '-94.2015000',
                'city' => 'Baxter',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56529',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8779000',
                'longitude' => '-96.7852000',
                'city' => 'Dilworth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56547',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8779000',
                'longitude' => '-96.7852000',
                'city' => 'Glyndon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56560',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8779000',
                'longitude' => '-96.7852000',
                'city' => 'Moorhead',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55731',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.9021000',
                'longitude' => '-91.8602000',
                'city' => 'Ely',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56470',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9217000',
                'longitude' => '-95.0590000',
                'city' => 'Park Rapids',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56549',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8892000',
                'longitude' => '-96.1016000',
                'city' => 'Hawley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56511',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8892000',
                'longitude' => '-96.1016000',
                'city' => 'Audubon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56554',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8892000',
                'longitude' => '-96.1016000',
                'city' => 'Lake Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56683',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7337000',
                'longitude' => '-94.5505000',
                'city' => 'Tenstrike',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56649',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.5985000',
                'longitude' => '-93.4008000',
                'city' => 'International Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56714',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.8497000',
                'longitude' => '-95.7685000',
                'city' => 'Badger',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56756',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.8497000',
                'longitude' => '-95.7685000',
                'city' => 'Salol',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56667',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6837000',
                'longitude' => '-94.8937000',
                'city' => 'Puposky',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56676',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6837000',
                'longitude' => '-94.8937000',
                'city' => 'Shevlin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55722',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2933000',
                'longitude' => '-93.4344000',
                'city' => 'Coleraine',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56374',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2933000',
                'longitude' => '-93.4344000',
                'city' => 'Saint Joseph',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55709',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2853000',
                'longitude' => '-93.4249000',
                'city' => 'Bovey',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55786',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2853000',
                'longitude' => '-93.4249000',
                'city' => 'Taconite',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56628',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2853000',
                'longitude' => '-93.4249000',
                'city' => 'Bigfork',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56636',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3346000',
                'longitude' => '-93.7982000',
                'city' => 'Deer River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55764',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3218000',
                'longitude' => '-93.2973000',
                'city' => 'Marble',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55716',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3218000',
                'longitude' => '-93.2973000',
                'city' => 'Calumet',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55775',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3218000',
                'longitude' => '-93.2973000',
                'city' => 'Pengilly',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55792',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5253000',
                'longitude' => '-92.5355000',
                'city' => 'Virginia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56467',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9259000',
                'longitude' => '-95.0564000',
                'city' => 'Nevis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56750',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8794000',
                'longitude' => '-96.2746000',
                'city' => 'Red Lake Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55719',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4912000',
                'longitude' => '-92.8797000',
                'city' => 'Chisholm',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55703',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4912000',
                'longitude' => '-92.8797000',
                'city' => 'Angora',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55781',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4912000',
                'longitude' => '-92.8797000',
                'city' => 'Side Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55721',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2933000',
                'longitude' => '-93.4344000',
                'city' => 'Cohasset',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56455',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3907000',
                'longitude' => '-93.8270000',
                'city' => 'Ironton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56450',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3907000',
                'longitude' => '-93.8270000',
                'city' => 'Garrison',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55713',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4955000',
                'longitude' => '-92.7801000',
                'city' => 'Buhl',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55710',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4955000',
                'longitude' => '-92.7801000',
                'city' => 'Britt',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55768',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4955000',
                'longitude' => '-92.7801000',
                'city' => 'Mountain Iron',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55758',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4955000',
                'longitude' => '-92.7801000',
                'city' => 'Kinney',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56545',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3164000',
                'longitude' => '-95.9662000',
                'city' => 'Gary',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55751',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4278000',
                'longitude' => '-92.9373000',
                'city' => 'Iron',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55612',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7514000',
                'longitude' => '-90.3437000',
                'city' => 'Lutsen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56732',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6629000',
                'longitude' => '-96.5957000',
                'city' => 'Karlstad',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56733',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6629000',
                'longitude' => '-96.5957000',
                'city' => 'Kennedy',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56729',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6629000',
                'longitude' => '-96.5957000',
                'city' => 'Halma',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56458',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9259000',
                'longitude' => '-95.0564000',
                'city' => 'Lake George',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56354',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1257000',
                'longitude' => '-95.5124000',
                'city' => 'Miltona',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56332',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1257000',
                'longitude' => '-95.5124000',
                'city' => 'Garfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56524',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1257000',
                'longitude' => '-95.5124000',
                'city' => 'Clitherall',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56361',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1257000',
                'longitude' => '-95.5124000',
                'city' => 'Parkers Prairie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56588',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1257000',
                'longitude' => '-95.5124000',
                'city' => 'Vining',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56326',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1257000',
                'longitude' => '-95.5124000',
                'city' => 'Evansville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56315',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1257000',
                'longitude' => '-95.5124000',
                'city' => 'Brandon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56684',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7675000',
                'longitude' => '-95.6153000',
                'city' => 'Trail',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56644',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7675000',
                'longitude' => '-95.6153000',
                'city' => 'Gonvick',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56646',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7675000',
                'longitude' => '-95.6153000',
                'city' => 'Gully',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56501',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Detroit Lakes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55783',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4869000',
                'longitude' => '-92.8771000',
                'city' => 'Sturgeon Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55767',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4869000',
                'longitude' => '-92.8771000',
                'city' => 'Moose Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55757',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4869000',
                'longitude' => '-92.8771000',
                'city' => 'Kettle River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56716',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7750000',
                'longitude' => '-96.5999000',
                'city' => 'Crookston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56653',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.3979000',
                'longitude' => '-93.5595000',
                'city' => 'Littlefork',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55811',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7814000',
                'longitude' => '-92.0981000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56722',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7767000',
                'longitude' => '-96.6060000',
                'city' => 'Euclid',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56723',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7767000',
                'longitude' => '-96.6060000',
                'city' => 'Fisher',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56515',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.2812000',
                'longitude' => '-95.7182000',
                'city' => 'Battle Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56654',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6023000',
                'longitude' => '-93.4133000',
                'city' => 'Loman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56668',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6123000',
                'longitude' => '-93.3460000',
                'city' => 'Ranier',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56727',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.3014000',
                'longitude' => '-95.6214000',
                'city' => 'Grygla',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56479',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3510000',
                'longitude' => '-94.7856000',
                'city' => 'Staples',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56573',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.5931000',
                'longitude' => '-95.5661000',
                'city' => 'Perham',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55760',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6084000',
                'longitude' => '-93.3076000',
                'city' => 'Mcgregor',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55607',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6192000',
                'longitude' => '-91.3529000',
                'city' => 'Isabella',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56544',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7279000',
                'longitude' => '-95.7001000',
                'city' => 'Frazee',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56663',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3857000',
                'longitude' => '-94.6197000',
                'city' => 'Pennington',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56633',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3857000',
                'longitude' => '-94.6197000',
                'city' => 'Cass Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56551',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1516000',
                'longitude' => '-95.3300000',
                'city' => 'Henning',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56528',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6584000',
                'longitude' => '-95.8055000',
                'city' => 'Dent',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56587',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6584000',
                'longitude' => '-95.8055000',
                'city' => 'Vergas',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55803',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55801',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55702',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9750000',
                'longitude' => '-92.5705000',
                'city' => 'Alborn',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55717',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9750000',
                'longitude' => '-92.5705000',
                'city' => 'Canyon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55779',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9750000',
                'longitude' => '-92.5705000',
                'city' => 'Saginaw',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56567',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.5949000',
                'longitude' => '-95.5721000',
                'city' => 'New York Mills',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56571',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.5949000',
                'longitude' => '-95.5721000',
                'city' => 'Ottertail',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56576',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.5949000',
                'longitude' => '-95.5721000',
                'city' => 'Richville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55808',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55718',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Carlton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55812',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55810',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55720',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Cloquet',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55604',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Grand Marais',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56466',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3420000',
                'longitude' => '-94.6390000',
                'city' => 'Motley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56514',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6528000',
                'longitude' => '-96.4143000',
                'city' => 'Barnesville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56516',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3715000',
                'longitude' => '-96.2667000',
                'city' => 'Bejou',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56557',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3715000',
                'longitude' => '-96.2667000',
                'city' => 'Mahnomen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55787',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6717000',
                'longitude' => '-93.0090000',
                'city' => 'Tamarack',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55798',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6717000',
                'longitude' => '-93.0090000',
                'city' => 'Wright',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56651',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5180000',
                'longitude' => '-95.6374000',
                'city' => 'Lengby',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56672',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9843000',
                'longitude' => '-94.2098000',
                'city' => 'Remer',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56655',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9843000',
                'longitude' => '-94.2098000',
                'city' => 'Longville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55796',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.9040000',
                'longitude' => '-91.8663000',
                'city' => 'Winton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56565',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0052000',
                'longitude' => '-96.3180000',
                'city' => 'Nashua',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56522',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0052000',
                'longitude' => '-96.3180000',
                'city' => 'Campbell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56583',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0052000',
                'longitude' => '-96.3180000',
                'city' => 'Tintah',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55795',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3827000',
                'longitude' => '-92.8223000',
                'city' => 'Willow River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55725',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.4037000',
                'longitude' => '-92.8160000',
                'city' => 'Crane Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55771',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.4037000',
                'longitude' => '-92.8160000',
                'city' => 'Orr',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55723',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7792000',
                'longitude' => '-93.0185000',
                'city' => 'Cook',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56725',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.1439000',
                'longitude' => '-95.8087000',
                'city' => 'Goodridge',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56728',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.9223000',
                'longitude' => '-97.0945000',
                'city' => 'Hallock',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56731',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.9223000',
                'longitude' => '-97.0945000',
                'city' => 'Humboldt',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56755',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.9223000',
                'longitude' => '-97.0945000',
                'city' => 'Saint Vincent',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55707',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4992000',
                'longitude' => '-92.6926000',
                'city' => 'Barnum',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56444',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4752000',
                'longitude' => '-93.9032000',
                'city' => 'Deerwood',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56763',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4992000',
                'longitude' => '-92.6926000',
                'city' => 'Warroad',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55797',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6638000',
                'longitude' => '-92.4281000',
                'city' => 'Wrenshall',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56518',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.5171000',
                'longitude' => '-95.3744000',
                'city' => 'Bluffton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56673',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.9084000',
                'longitude' => '-95.3177000',
                'city' => 'Roosevelt',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55733',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Esko',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55807',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56431',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Aitkin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55736',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7833000',
                'longitude' => '-92.1041000',
                'city' => 'Floodwood',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56481',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.5278000',
                'longitude' => '-94.6528000',
                'city' => 'Verndale',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55615',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5760000',
                'longitude' => '-90.8353000',
                'city' => 'Tofte',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56751',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.7792000',
                'longitude' => '-95.6780000',
                'city' => 'Roseau',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56724',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6460000',
                'longitude' => '-95.7395000',
                'city' => 'Gatzke',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56761',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6460000',
                'longitude' => '-95.7395000',
                'city' => 'Wannaska',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55765',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0728000',
                'longitude' => '-92.7331000',
                'city' => 'Meadowlands',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55724',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0728000',
                'longitude' => '-92.7331000',
                'city' => 'Cotton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55738',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0728000',
                'longitude' => '-92.7331000',
                'city' => 'Forbes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56623',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.7185000',
                'longitude' => '-94.6039000',
                'city' => 'Baudette',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56542',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5836000',
                'longitude' => '-95.7434000',
                'city' => 'Fosston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56758',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.5759000',
                'longitude' => '-96.5150000',
                'city' => 'Strandquist',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56713',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.3342000',
                'longitude' => '-96.8181000',
                'city' => 'Argyle',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56686',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.8013000',
                'longitude' => '-95.1006000',
                'city' => 'Williams',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56434',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3955000',
                'longitude' => '-95.0169000',
                'city' => 'Aldrich',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56520',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.2665000',
                'longitude' => '-96.5845000',
                'city' => 'Breckenridge',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56701',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.2898000',
                'longitude' => '-96.1858000',
                'city' => 'Thief River Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55711',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8647000',
                'longitude' => '-92.6083000',
                'city' => 'Brookston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56757',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6245000',
                'longitude' => '-97.1745000',
                'city' => 'Stephen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '58225',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.6245000',
                'longitude' => '-97.1745000',
                'city' => 'Drayton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56548',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3484000',
                'longitude' => '-96.8264000',
                'city' => 'Halstad',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56531',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0334000',
                'longitude' => '-96.1019000',
                'city' => 'Elbow Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56590',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0334000',
                'longitude' => '-96.1019000',
                'city' => 'Wendell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56453',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3928000',
                'longitude' => '-95.3286000',
                'city' => 'Hewitt',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56527',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3928000',
                'longitude' => '-95.3286000',
                'city' => 'Deer Creek',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56748',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.9093000',
                'longitude' => '-96.0426000',
                'city' => 'Plummer',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56720',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.5746000',
                'longitude' => '-96.8953000',
                'city' => 'Donaldson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56678',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5230000',
                'longitude' => '-95.1350000',
                'city' => 'Solway',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56478',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6369000',
                'longitude' => '-94.8811000',
                'city' => 'Nimrod',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56464',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6369000',
                'longitude' => '-94.8811000',
                'city' => 'Menahga',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56477',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6369000',
                'longitude' => '-94.8811000',
                'city' => 'Sebeka',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56510',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2966000',
                'longitude' => '-96.5147000',
                'city' => 'Ada',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55605',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8395000',
                'longitude' => '-89.9649000',
                'city' => 'Grand Portage',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55606',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8395000',
                'longitude' => '-89.9649000',
                'city' => 'Hovland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56296',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0518000',
                'longitude' => '-96.6029000',
                'city' => 'Wheaton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55756',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4544000',
                'longitude' => '-92.7601000',
                'city' => 'Kerrick',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55742',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.1303000',
                'longitude' => '-93.2697000',
                'city' => 'Goodland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55784',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.1303000',
                'longitude' => '-93.2697000',
                'city' => 'Swan River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55793',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.1303000',
                'longitude' => '-93.2697000',
                'city' => 'Warba',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56580',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6571000',
                'longitude' => '-96.3761000',
                'city' => 'Sabin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56579',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6571000',
                'longitude' => '-96.3761000',
                'city' => 'Rothsay',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56546',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0799000',
                'longitude' => '-96.5065000',
                'city' => 'Georgetown',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56585',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0799000',
                'longitude' => '-96.5065000',
                'city' => 'Ulen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56536',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0799000',
                'longitude' => '-96.5065000',
                'city' => 'Felton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56519',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0799000',
                'longitude' => '-96.5065000',
                'city' => 'Borup',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56586',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4226000',
                'longitude' => '-95.8406000',
                'city' => 'Underwood',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55749',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4123000',
                'longitude' => '-92.5025000',
                'city' => 'Holyoke',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55712',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4123000',
                'longitude' => '-92.5025000',
                'city' => 'Bruno',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56760',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.2209000',
                'longitude' => '-96.4061000',
                'city' => 'Viking',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55804',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8278000',
                'longitude' => '-92.0367000',
                'city' => 'Duluth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56572',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7346000',
                'longitude' => '-96.0708000',
                'city' => 'Pelican Rapids',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56484',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0973000',
                'longitude' => '-94.5834000',
                'city' => 'Walker',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56570',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8060000',
                'longitude' => '-95.3487000',
                'city' => 'Osage',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56593',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8060000',
                'longitude' => '-95.3487000',
                'city' => 'Wolf Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56442',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6620000',
                'longitude' => '-94.1974000',
                'city' => 'Crosslake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56474',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6620000',
                'longitude' => '-94.1974000',
                'city' => 'Pine River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56472',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6620000',
                'longitude' => '-94.1974000',
                'city' => 'Pequot Lakes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56441',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4733000',
                'longitude' => '-93.9625000',
                'city' => 'Crosby',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56433',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0973000',
                'longitude' => '-94.5834000',
                'city' => 'Akeley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56452',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0973000',
                'longitude' => '-94.5834000',
                'city' => 'Hackensack',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56670',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.0216000',
                'longitude' => '-94.9288000',
                'city' => 'Redby',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56666',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.0216000',
                'longitude' => '-94.9288000',
                'city' => 'Ponemah',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56671',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4646000',
                'longitude' => '-94.8854000',
                'city' => 'Redlake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56594',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4473000',
                'longitude' => '-96.7285000',
                'city' => 'Wolverton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56553',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4473000',
                'longitude' => '-96.7285000',
                'city' => 'Kent',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56556',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6350000',
                'longitude' => '-95.8886000',
                'city' => 'Mcintosh',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55785',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0579000',
                'longitude' => '-93.9208000',
                'city' => 'Swatara',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56541',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.1641000',
                'longitude' => '-96.1358000',
                'city' => 'Flom',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56584',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.1641000',
                'longitude' => '-96.1358000',
                'city' => 'Twin Valley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56468',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6022000',
                'longitude' => '-94.3164000',
                'city' => 'Nisswa',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56456',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6022000',
                'longitude' => '-94.3164000',
                'city' => 'Jenkins',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56575',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9215000',
                'longitude' => '-95.2633000',
                'city' => 'Ponsford',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56535',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6335000',
                'longitude' => '-96.2189000',
                'city' => 'Erskine',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56736',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6335000',
                'longitude' => '-96.2189000',
                'city' => 'Mentor',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56540',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6335000',
                'longitude' => '-96.2189000',
                'city' => 'Fertile',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56443',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.2135000',
                'longitude' => '-94.6481000',
                'city' => 'Cushing',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56525',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6561000',
                'longitude' => '-96.7426000',
                'city' => 'Comstock',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56647',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5851000',
                'longitude' => '-94.7647000',
                'city' => 'Hines',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56435',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7210000',
                'longitude' => '-94.4080000',
                'city' => 'Backus',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56324',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1689000',
                'longitude' => '-95.9145000',
                'city' => 'Dalton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56629',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.7142000',
                'longitude' => '-94.6067000',
                'city' => 'Birchdale',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55763',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3981000',
                'longitude' => '-92.2655000',
                'city' => 'Makinen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56543',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.2614000',
                'longitude' => '-96.6017000',
                'city' => 'Foxhome',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55780',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6791000',
                'longitude' => '-92.8724000',
                'city' => 'Sawyer',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55726',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6791000',
                'longitude' => '-92.8724000',
                'city' => 'Cromwell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56685',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.9419000',
                'longitude' => '-94.4530000',
                'city' => 'Waskish',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56650',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.9419000',
                'longitude' => '-94.4530000',
                'city' => 'Kelliher',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56661',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.9419000',
                'longitude' => '-94.4530000',
                'city' => 'Northome',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56626',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2466000',
                'longitude' => '-94.2243000',
                'city' => 'Bena',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56641',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2466000',
                'longitude' => '-94.2243000',
                'city' => 'Federal Dam',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56621',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3842000',
                'longitude' => '-95.3838000',
                'city' => 'Bagley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56350',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3631000',
                'longitude' => '-92.9518000',
                'city' => 'Mc Grath',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55735',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3631000',
                'longitude' => '-92.9518000',
                'city' => 'Finlayson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56680',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6257000',
                'longitude' => '-94.1396000',
                'city' => 'Spring Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56659',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6257000',
                'longitude' => '-94.1396000',
                'city' => 'Max',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56688',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6257000',
                'longitude' => '-94.1396000',
                'city' => 'Wirt',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56681',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6257000',
                'longitude' => '-94.1396000',
                'city' => 'Squaw Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55613',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5718000',
                'longitude' => '-90.8384000',
                'city' => 'Schroeder',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56311',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.9908000',
                'longitude' => '-95.9775000',
                'city' => 'Barrett',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56309',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.9908000',
                'longitude' => '-95.9775000',
                'city' => 'Ashby',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56634',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5244000',
                'longitude' => '-95.3992000',
                'city' => 'Clearbrook',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56744',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.1938000',
                'longitude' => '-97.1297000',
                'city' => 'Oslo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55748',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9828000',
                'longitude' => '-93.5949000',
                'city' => 'Hill City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56715',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8137000',
                'longitude' => '-96.0056000',
                'city' => 'Brooks',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56538',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.2838000',
                'longitude' => '-96.0670000',
                'city' => 'Fergus Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56534',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.2856000',
                'longitude' => '-96.0731000',
                'city' => 'Erhard',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56437',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1667000',
                'longitude' => '-95.0432000',
                'city' => 'Bertha',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56446',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1667000',
                'longitude' => '-95.0432000',
                'city' => 'Eagle Bend',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55741',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5211000',
                'longitude' => '-92.5383000',
                'city' => 'Gilbert',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55734',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5211000',
                'longitude' => '-92.5383000',
                'city' => 'Eveleth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55732',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5211000',
                'longitude' => '-92.5383000',
                'city' => 'Embarrass',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56639',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7439000',
                'longitude' => '-93.6615000',
                'city' => 'Effie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56473',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3317000',
                'longitude' => '-94.4725000',
                'city' => 'Pillager',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56401',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3317000',
                'longitude' => '-94.4725000',
                'city' => 'Brainerd',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55752',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0022000',
                'longitude' => '-93.2664000',
                'city' => 'Jacobson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55782',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8049000',
                'longitude' => '-92.2750000',
                'city' => 'Soudan',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55790',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8049000',
                'longitude' => '-92.2750000',
                'city' => 'Tower',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56734',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.7346000',
                'longitude' => '-96.7307000',
                'city' => 'Lake Bronson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56438',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1291000',
                'longitude' => '-94.9519000',
                'city' => 'Browerville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56440',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1291000',
                'longitude' => '-94.9519000',
                'city' => 'Clarissa',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55772',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.0563000',
                'longitude' => '-92.8293000',
                'city' => 'Nett Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56735',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.8593000',
                'longitude' => '-96.8041000',
                'city' => 'Lancaster',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56448',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7318000',
                'longitude' => '-93.9635000',
                'city' => 'Fifty Lakes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56447',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.7318000',
                'longitude' => '-93.9635000',
                'city' => 'Emily',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56465',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.5572000',
                'longitude' => '-94.0538000',
                'city' => 'Merrifield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56469',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.6042000',
                'longitude' => '-93.3103000',
                'city' => 'Palisade',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56652',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6929000',
                'longitude' => '-95.4254000',
                'city' => 'Leonard',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55753',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3998000',
                'longitude' => '-93.0749000',
                'city' => 'Keewatin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55708',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5253000',
                'longitude' => '-92.5355000',
                'city' => 'Biwabik',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56726',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.5557000',
                'longitude' => '-96.1697000',
                'city' => 'Greenbush',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56561',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8968000',
                'longitude' => '-96.8531000',
                'city' => 'Moorhead',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56662',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8233000',
                'longitude' => '-93.9483000',
                'city' => 'Outing',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56742',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8372000',
                'longitude' => '-95.8589000',
                'city' => 'Oklee',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55423',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3538000',
                'longitude' => '-94.1988000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56740',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.9678000',
                'longitude' => '-97.2473000',
                'city' => 'Noyes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56449',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3538000',
                'longitude' => '-94.1988000',
                'city' => 'Fort Ripley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55706',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.7133000',
                'longitude' => '-91.9415000',
                'city' => 'Babbitt',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56657',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5919000',
                'longitude' => '-93.6953000',
                'city' => 'Marcell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56631',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5919000',
                'longitude' => '-93.6953000',
                'city' => 'Bowstring',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56637',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5919000',
                'longitude' => '-93.6953000',
                'city' => 'Talmoon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55609',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0212000',
                'longitude' => '-91.6736000',
                'city' => 'Knife River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55387',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.3496000',
                'longitude' => '-94.2015000',
                'city' => 'Waconia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56533',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.4832000',
                'longitude' => '-96.0976000',
                'city' => 'Elizabeth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56578',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8159000',
                'longitude' => '-95.8478000',
                'city' => 'Rochert',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55602',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.2933000',
                'longitude' => '-91.8467000',
                'city' => 'Brimson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56502',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8159000',
                'longitude' => '-95.8478000',
                'city' => 'Detroit Lakes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56569',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.8159000',
                'longitude' => '-95.8478000',
                'city' => 'Ogema',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56523',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.6103000',
                'longitude' => '-96.8176000',
                'city' => 'Climax',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56574',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.1769000',
                'longitude' => '-96.8035000',
                'city' => 'Perley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56550',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.1769000',
                'longitude' => '-96.8035000',
                'city' => 'Hendrum',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56669',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.4383000',
                'longitude' => '-93.0265000',
                'city' => 'Kabetogama',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55769',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3788000',
                'longitude' => '-93.1704000',
                'city' => 'Nashwauk',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56581',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4587000',
                'longitude' => '-96.8266000',
                'city' => 'Shelly',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56568',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.4587000',
                'longitude' => '-96.8266000',
                'city' => 'Nielsville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56660',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.8712000',
                'longitude' => '-94.2835000',
                'city' => 'Mizpah',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56517',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.5400000',
                'longitude' => '-96.5281000',
                'city' => 'Beltrami',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56592',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3697000',
                'longitude' => '-95.9777000',
                'city' => 'Winger',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56566',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.3257000',
                'longitude' => '-95.9462000',
                'city' => 'Naytahwaush',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56552',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.9739000',
                'longitude' => '-96.2591000',
                'city' => 'Hitterdal',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56754',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.0181000',
                'longitude' => '-96.2346000',
                'city' => 'Saint Hilaire',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56710',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '48.1927000',
                'longitude' => '-96.9952000',
                'city' => 'Alvarado',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56591',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '47.0988000',
                'longitude' => '-95.8366000',
                'city' => 'White Earth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56385',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7155000',
                'longitude' => '-95.2674000',
                'city' => 'Villard',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56379',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5627000',
                'longitude' => '-94.1594000',
                'city' => 'Sauk Rapids',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56303',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5627000',
                'longitude' => '-94.1594000',
                'city' => 'Saint Cloud',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56304',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5627000',
                'longitude' => '-94.1594000',
                'city' => 'Saint Cloud',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56387',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5627000',
                'longitude' => '-94.1594000',
                'city' => 'Waite Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56301',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5627000',
                'longitude' => '-94.1594000',
                'city' => 'Saint Cloud',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56377',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5627000',
                'longitude' => '-94.1594000',
                'city' => 'Sartell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55006',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7229000',
                'longitude' => '-93.1767000',
                'city' => 'Braham',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55037',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0060000',
                'longitude' => '-92.9332000',
                'city' => 'Hinckley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56267',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5930000',
                'longitude' => '-95.9155000',
                'city' => 'Morris',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55051',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8769000',
                'longitude' => '-93.2917000',
                'city' => 'Mora',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56358',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8339000',
                'longitude' => '-93.4284000',
                'city' => 'Ogilvie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56201',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1165000',
                'longitude' => '-95.0504000',
                'city' => 'Willmar',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55063',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8271000',
                'longitude' => '-92.9783000',
                'city' => 'Pine City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55069',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6844000',
                'longitude' => '-92.9778000',
                'city' => 'Rush City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55072',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1274000',
                'longitude' => '-92.8678000',
                'city' => 'Sandstone',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56308',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8825000',
                'longitude' => '-95.3740000',
                'city' => 'Alexandria',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55355',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1243000',
                'longitude' => '-94.5211000',
                'city' => 'Litchfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56265',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9495000',
                'longitude' => '-95.7252000',
                'city' => 'Montevideo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56345',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.9737000',
                'longitude' => '-94.3599000',
                'city' => 'Little Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55350',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8901000',
                'longitude' => '-94.3695000',
                'city' => 'Hutchinson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55302',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2918000',
                'longitude' => '-94.2150000',
                'city' => 'Annandale',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55382',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2918000',
                'longitude' => '-94.2150000',
                'city' => 'South Haven',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56388',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5374000',
                'longitude' => '-94.1752000',
                'city' => 'Waite Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55339',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7759000',
                'longitude' => '-94.0409000',
                'city' => 'Hamburg',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55336',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7759000',
                'longitude' => '-94.0409000',
                'city' => 'Glencoe',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55370',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7759000',
                'longitude' => '-94.0409000',
                'city' => 'Plato',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55368',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7759000',
                'longitude' => '-94.0409000',
                'city' => 'Norwood Young America',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56334',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6133000',
                'longitude' => '-95.5282000',
                'city' => 'Glenwood',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56381',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6133000',
                'longitude' => '-95.5282000',
                'city' => 'Starbuck',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56302',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5665000',
                'longitude' => '-94.1713000',
                'city' => 'Saint Cloud',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56362',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3803000',
                'longitude' => '-94.7115000',
                'city' => 'Paynesville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56273',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3803000',
                'longitude' => '-94.7115000',
                'city' => 'New London',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56312',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3803000',
                'longitude' => '-94.7115000',
                'city' => 'Belgrade',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56371',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3803000',
                'longitude' => '-94.7115000',
                'city' => 'Roscoe',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56243',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1498000',
                'longitude' => '-94.6855000',
                'city' => 'Grove City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56248',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6913000',
                'longitude' => '-96.0137000',
                'city' => 'Herman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56235',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6913000',
                'longitude' => '-96.0137000',
                'city' => 'Donnelly',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55319',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5665000',
                'longitude' => '-94.1713000',
                'city' => 'Clear Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56310',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5665000',
                'longitude' => '-94.1713000',
                'city' => 'Avon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56368',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5665000',
                'longitude' => '-94.1713000',
                'city' => 'Richmond',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55320',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5665000',
                'longitude' => '-94.1713000',
                'city' => 'Clearwater',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56367',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5627000',
                'longitude' => '-94.1594000',
                'city' => 'Rice',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56336',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6746000',
                'longitude' => '-94.8169000',
                'city' => 'Grey Eagle',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56356',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6746000',
                'longitude' => '-94.8169000',
                'city' => 'New Munich',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56378',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6746000',
                'longitude' => '-94.8169000',
                'city' => 'Sauk Centre',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56352',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6746000',
                'longitude' => '-94.8169000',
                'city' => 'Melrose',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56307',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5665000',
                'longitude' => '-94.1713000',
                'city' => 'Albany',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56271',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1914000',
                'longitude' => '-95.3153000',
                'city' => 'Murdock',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56279',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1914000',
                'longitude' => '-95.3153000',
                'city' => 'Pennock',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56282',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1914000',
                'longitude' => '-95.3153000',
                'city' => 'Raymond',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56252',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1914000',
                'longitude' => '-95.3153000',
                'city' => 'Kerkhoven',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56289',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1914000',
                'longitude' => '-95.3153000',
                'city' => 'Sunburg',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56225',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5580000',
                'longitude' => '-96.7057000',
                'city' => 'Clinton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56219',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5580000',
                'longitude' => '-96.7057000',
                'city' => 'Browns Valley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56211',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5580000',
                'longitude' => '-96.7057000',
                'city' => 'Beardsley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56316',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5737000',
                'longitude' => '-95.2485000',
                'city' => 'Brooten',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56295',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9435000',
                'longitude' => '-95.7217000',
                'city' => 'Watson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56327',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8480000',
                'longitude' => '-95.5086000',
                'city' => 'Farwell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56276',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2621000',
                'longitude' => '-96.3281000',
                'city' => 'Odessa',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56278',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2621000',
                'longitude' => '-96.3281000',
                'city' => 'Ortonville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56227',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2621000',
                'longitude' => '-96.3281000',
                'city' => 'Correll',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55324',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0789000',
                'longitude' => '-94.3120000',
                'city' => 'Darwin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55325',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0789000',
                'longitude' => '-94.3120000',
                'city' => 'Dassel',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56288',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3323000',
                'longitude' => '-94.7690000',
                'city' => 'Spicer',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56209',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3323000',
                'longitude' => '-94.7690000',
                'city' => 'Atwater',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56364',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1177000',
                'longitude' => '-93.8943000',
                'city' => 'Pierz',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56338',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1177000',
                'longitude' => '-93.8943000',
                'city' => 'Hillman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56343',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7049000',
                'longitude' => '-95.5164000',
                'city' => 'Kensington',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56349',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7049000',
                'longitude' => '-95.5164000',
                'city' => 'Lowry',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56274',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8687000',
                'longitude' => '-96.1924000',
                'city' => 'Norcross',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56318',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8265000',
                'longitude' => '-94.7518000',
                'city' => 'Burtrum',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55349',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0774000',
                'longitude' => '-94.1925000',
                'city' => 'Howard Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55321',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0774000',
                'longitude' => '-94.1925000',
                'city' => 'Cokato',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56208',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2001000',
                'longitude' => '-96.0486000',
                'city' => 'Appleton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56329',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5665000',
                'longitude' => '-94.1713000',
                'city' => 'Foley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56357',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7365000',
                'longitude' => '-93.7132000',
                'city' => 'Oak Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56353',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7365000',
                'longitude' => '-93.7132000',
                'city' => 'Milaca',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56330',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7365000',
                'longitude' => '-93.7132000',
                'city' => 'Foreston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56347',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8840000',
                'longitude' => '-94.3662000',
                'city' => 'Long Prairie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56241',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8132000',
                'longitude' => '-95.5398000',
                'city' => 'Granite Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56215',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3138000',
                'longitude' => '-95.6013000',
                'city' => 'Benson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56221',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5730000',
                'longitude' => '-96.1750000',
                'city' => 'Chokio',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56207',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5730000',
                'longitude' => '-96.1750000',
                'city' => 'Alberta',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56240',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.4593000',
                'longitude' => '-96.4384000',
                'city' => 'Graceville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55381',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9072000',
                'longitude' => '-94.1983000',
                'city' => 'Silver Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55312',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7321000',
                'longitude' => '-94.3489000',
                'city' => 'Brownton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55385',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7321000',
                'longitude' => '-94.3489000',
                'city' => 'Stewart',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56285',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7886000',
                'longitude' => '-95.2119000',
                'city' => 'Sacred Heart',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56284',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7886000',
                'longitude' => '-95.2119000',
                'city' => 'Renville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56230',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Danube',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55342',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7409000',
                'longitude' => '-94.7154000',
                'city' => 'Hector',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56320',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.4515000',
                'longitude' => '-94.4351000',
                'city' => 'Cold Spring',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56360',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7375000',
                'longitude' => '-94.9551000',
                'city' => 'Osakis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56373',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8347000',
                'longitude' => '-93.9447000',
                'city' => 'Royalton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55080',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6867000',
                'longitude' => '-92.9692000',
                'city' => 'Stanchfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55032',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6867000',
                'longitude' => '-92.9692000',
                'city' => 'Harris',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56375',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5632000',
                'longitude' => '-94.3238000',
                'city' => 'Saint Stephen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55310',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7755000',
                'longitude' => '-94.9877000',
                'city' => 'Bird Island',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56277',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7755000',
                'longitude' => '-94.9877000',
                'city' => 'Olivia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56222',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9076000',
                'longitude' => '-95.4701000',
                'city' => 'Clara City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56260',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9076000',
                'longitude' => '-95.4701000',
                'city' => 'Maynard',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55371',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6970000',
                'longitude' => '-93.6524000',
                'city' => 'Princeton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56363',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6970000',
                'longitude' => '-93.6524000',
                'city' => 'Pease',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56253',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1297000',
                'longitude' => '-94.9293000',
                'city' => 'Lake Lillian',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56251',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1297000',
                'longitude' => '-94.9293000',
                'city' => 'Kandiyohi',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56245',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7504000',
                'longitude' => '-95.7175000',
                'city' => 'Hanley Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56223',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7504000',
                'longitude' => '-95.7175000',
                'city' => 'Clarkfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55007',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0140000',
                'longitude' => '-92.9424000',
                'city' => 'Brook Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56333',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7352000',
                'longitude' => '-93.9503000',
                'city' => 'Gilman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55314',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7364000',
                'longitude' => '-94.6191000',
                'city' => 'Buffalo Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56244',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.4973000',
                'longitude' => '-95.7956000',
                'city' => 'Hancock',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56340',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7531000',
                'longitude' => '-94.2188000',
                'city' => 'Holdingford',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56249',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2488000',
                'longitude' => '-95.9077000',
                'city' => 'Holloway',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55354',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8820000',
                'longitude' => '-94.0382000',
                'city' => 'Lester Prairie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55030',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7229000',
                'longitude' => '-93.1767000',
                'city' => 'Grasston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55353',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3094000',
                'longitude' => '-94.3032000',
                'city' => 'Kimball',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56228',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9342000',
                'longitude' => '-94.6900000',
                'city' => 'Cosmos',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55389',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3229000',
                'longitude' => '-94.5433000',
                'city' => 'Watkins',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55329',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3229000',
                'longitude' => '-94.5433000',
                'city' => 'Eden Valley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56317',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.9762000',
                'longitude' => '-94.1063000',
                'city' => 'Buckman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55395',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9604000',
                'longitude' => '-94.0464000',
                'city' => 'Winsted',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56386',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1185000',
                'longitude' => '-93.5249000',
                'city' => 'Wahkon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56359',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1185000',
                'longitude' => '-93.5249000',
                'city' => 'Onamia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56342',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1305000',
                'longitude' => '-93.4666000',
                'city' => 'Isle',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56232',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9322000',
                'longitude' => '-96.0579000',
                'city' => 'Dawson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55390',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0589000',
                'longitude' => '-94.0693000',
                'city' => 'Waverly',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56382',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.9118000',
                'longitude' => '-94.6354000',
                'city' => 'Swanville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56331',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5025000',
                'longitude' => '-94.6667000',
                'city' => 'Freeport',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56376',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5025000',
                'longitude' => '-94.6667000',
                'city' => 'Saint Martin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56313',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.7869000',
                'longitude' => '-93.5520000',
                'city' => 'Bock',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56236',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8066000',
                'longitude' => '-96.4977000',
                'city' => 'Dumont',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56226',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2839000',
                'longitude' => '-95.7527000',
                'city' => 'Clontarf',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56231',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2839000',
                'longitude' => '-95.7527000',
                'city' => 'Danvers',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56256',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1356000',
                'longitude' => '-96.2893000',
                'city' => 'Madison',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56257',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1356000',
                'longitude' => '-96.2893000',
                'city' => 'Marietta',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56212',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1356000',
                'longitude' => '-96.2893000',
                'city' => 'Bellingham',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56314',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8151000',
                'longitude' => '-94.5667000',
                'city' => 'Bowlus',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56384',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8151000',
                'longitude' => '-94.5667000',
                'city' => 'Upsala',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56220',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0147000',
                'longitude' => '-96.1846000',
                'city' => 'Canby',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55367',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8820000',
                'longitude' => '-94.0382000',
                'city' => 'New Germany',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56218',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7916000',
                'longitude' => '-95.8049000',
                'city' => 'Boyd',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56325',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5633000',
                'longitude' => '-94.9471000',
                'city' => 'Elrosa',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56262',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1097000',
                'longitude' => '-95.9122000',
                'city' => 'Milan',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56210',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5675000',
                'longitude' => '-96.4319000',
                'city' => 'Barry',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56475',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.0885000',
                'longitude' => '-94.5033000',
                'city' => 'Randall',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56355',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8825000',
                'longitude' => '-95.3740000',
                'city' => 'Nelson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56323',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6147000',
                'longitude' => '-95.7397000',
                'city' => 'Cyrus',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55704',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '46.1914000',
                'longitude' => '-92.7819000',
                'city' => 'Askov',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56319',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.9286000',
                'longitude' => '-95.3750000',
                'city' => 'Carlos',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56264',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8510000',
                'longitude' => '-95.9028000',
                'city' => 'Minneota',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55366',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7714000',
                'longitude' => '-94.1533000',
                'city' => 'New Auburn',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56341',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8480000',
                'longitude' => '-95.5086000',
                'city' => 'Holmes City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55313',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2308000',
                'longitude' => '-94.0052000',
                'city' => 'Buffalo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55358',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2308000',
                'longitude' => '-94.0052000',
                'city' => 'Maple Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56281',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9358000',
                'longitude' => '-95.1870000',
                'city' => 'Prinsburg',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56216',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9358000',
                'longitude' => '-95.1870000',
                'city' => 'Blomkest',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56263',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8590000',
                'longitude' => '-95.6247000',
                'city' => 'Milroy',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56339',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.8304000',
                'longitude' => '-95.7891000',
                'city' => 'Hoffman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56335',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.6021000',
                'longitude' => '-94.8599000',
                'city' => 'Greenwald',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55975',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Spring Valley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56093',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0747000',
                'longitude' => '-93.4994000',
                'city' => 'Waseca',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55021',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Faribault',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55918',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7437000',
                'longitude' => '-92.8667000',
                'city' => 'Brownsdale',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56144',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8476000',
                'longitude' => '-96.3970000',
                'city' => 'Jasper',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55987',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0489000',
                'longitude' => '-91.6460000',
                'city' => 'Winona',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55906',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Rochester',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55901',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Rochester',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56003',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1668000',
                'longitude' => '-94.0035000',
                'city' => 'Mankato',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55904',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Rochester',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55940',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8932000',
                'longitude' => '-92.8415000',
                'city' => 'Hayfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56175',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2337000',
                'longitude' => '-95.6157000',
                'city' => 'Tracy',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55057',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4578000',
                'longitude' => '-93.1640000',
                'city' => 'Northfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55060',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0840000',
                'longitude' => '-93.2173000',
                'city' => 'Owatonna',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56164',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9906000',
                'longitude' => '-96.3228000',
                'city' => 'Pipestone',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56073',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3163000',
                'longitude' => '-94.4551000',
                'city' => 'New Ulm',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55912',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6662000',
                'longitude' => '-92.9710000',
                'city' => 'Austin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56156',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6506000',
                'longitude' => '-96.2055000',
                'city' => 'Luverne',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56118',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8732000',
                'longitude' => '-95.1158000',
                'city' => 'Bingham Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56291',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7148000',
                'longitude' => '-96.0518000',
                'city' => 'Taunton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56280',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7148000',
                'longitude' => '-96.0518000',
                'city' => 'Porter',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56074',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2764000',
                'longitude' => '-94.1863000',
                'city' => 'Nicollet',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56054',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4490000',
                'longitude' => '-94.3944000',
                'city' => 'Lafayette',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55396',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4490000',
                'longitude' => '-94.3944000',
                'city' => 'Winthrop',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56031',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6497000',
                'longitude' => '-94.4558000',
                'city' => 'Fairmont',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56048',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1208000',
                'longitude' => '-93.7047000',
                'city' => 'Janesville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56078',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1166000',
                'longitude' => '-93.7072000',
                'city' => 'Pemberton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55334',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5561000',
                'longitude' => '-94.2248000',
                'city' => 'Gaylord',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55307',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5561000',
                'longitude' => '-94.2248000',
                'city' => 'Arlington',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56058',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5561000',
                'longitude' => '-94.2248000',
                'city' => 'Le Sueur',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56072',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9328000',
                'longitude' => '-93.6989000',
                'city' => 'New Richland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56097',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9328000',
                'longitude' => '-93.6989000',
                'city' => 'Wells',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56091',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9328000',
                'longitude' => '-93.6989000',
                'city' => 'Waldorf',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56068',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9328000',
                'longitude' => '-93.6989000',
                'city' => 'Minnesota Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55917',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8690000',
                'longitude' => '-93.0600000',
                'city' => 'Blooming Prairie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56050',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2040000',
                'longitude' => '-93.8202000',
                'city' => 'Kasota',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56063',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2040000',
                'longitude' => '-93.8202000',
                'city' => 'Madison Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56080',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0784000',
                'longitude' => '-93.8532000',
                'city' => 'Saint Clair',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56001',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0784000',
                'longitude' => '-93.8532000',
                'city' => 'Mankato',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56082',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3238000',
                'longitude' => '-93.9555000',
                'city' => 'Saint Peter',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56149',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2639000',
                'longitude' => '-96.1321000',
                'city' => 'Lake Benton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56178',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2639000',
                'longitude' => '-96.1321000',
                'city' => 'Tyler',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56170',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2639000',
                'longitude' => '-96.1321000',
                'city' => 'Ruthton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56044',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5238000',
                'longitude' => '-93.9001000',
                'city' => 'Henderson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56283',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4178000',
                'longitude' => '-94.9240000',
                'city' => 'Redwood Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56266',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4178000',
                'longitude' => '-94.9240000',
                'city' => 'Morgan',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55963',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Pine Island',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55902',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Rochester',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55955',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Mantorville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55905',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Rochester',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56007',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7644000',
                'longitude' => '-93.3267000',
                'city' => 'Albert Lea',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56016',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7644000',
                'longitude' => '-93.3267000',
                'city' => 'Clarks Grove',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56045',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7644000',
                'longitude' => '-93.3267000',
                'city' => 'Hollandale',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56043',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7644000',
                'longitude' => '-93.3267000',
                'city' => 'Hayward',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56026',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7644000',
                'longitude' => '-93.3267000',
                'city' => 'Ellendale',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56035',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7644000',
                'longitude' => '-93.3267000',
                'city' => 'Geneva',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56024',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1664000',
                'longitude' => '-93.8902000',
                'city' => 'Eagle Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55903',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Rochester',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55009',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5057000',
                'longitude' => '-92.9074000',
                'city' => 'Cannon Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55018',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5057000',
                'longitude' => '-92.9074000',
                'city' => 'Dennison',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55065',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5057000',
                'longitude' => '-92.9074000',
                'city' => 'Randolph',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55031',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5057000',
                'longitude' => '-92.9074000',
                'city' => 'Hampton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56141',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9171000',
                'longitude' => '-95.7789000',
                'city' => 'Iona',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56172',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9171000',
                'longitude' => '-95.7789000',
                'city' => 'Slayton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56122',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9171000',
                'longitude' => '-95.7789000',
                'city' => 'Chandler',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56020',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6132000',
                'longitude' => '-93.5306000',
                'city' => 'Conger',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56029',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6132000',
                'longitude' => '-93.5306000',
                'city' => 'Emmons',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56009',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6132000',
                'longitude' => '-93.5306000',
                'city' => 'Alden',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56096',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1975000',
                'longitude' => '-93.6746000',
                'city' => 'Waterville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56028',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1975000',
                'longitude' => '-93.6746000',
                'city' => 'Elysian',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55965',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7411000',
                'longitude' => '-92.1353000',
                'city' => 'Preston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55935',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7411000',
                'longitude' => '-92.1353000',
                'city' => 'Fountain',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55934',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Eyota',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55960',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Oronoco',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55087',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0237000',
                'longitude' => '-92.4712000',
                'city' => 'Warsaw',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56114',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Avoca',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56183',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Westbrook',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56131',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Fulda',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56123',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Currie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56125',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Dovray',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56180',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Walnut Grove',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56136',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5082000',
                'longitude' => '-96.4142000',
                'city' => 'Hendricks',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '57237',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7944000',
                'longitude' => '-96.4517000',
                'city' => 'Gary',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56010',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0054000',
                'longitude' => '-94.0672000',
                'city' => 'Amboy',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56037',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0054000',
                'longitude' => '-94.0672000',
                'city' => 'Good Thunder',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56158',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6567000',
                'longitude' => '-96.2089000',
                'city' => 'Magnolia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56147',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6567000',
                'longitude' => '-96.2089000',
                'city' => 'Kenneth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56014',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5352000',
                'longitude' => '-93.7104000',
                'city' => 'Bricelyn',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56051',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5352000',
                'longitude' => '-93.7104000',
                'city' => 'Kiester',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56187',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6236000',
                'longitude' => '-95.5915000',
                'city' => 'Worthington',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55923',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8475000',
                'longitude' => '-92.1925000',
                'city' => 'Chatfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55920',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0341000',
                'longitude' => '-92.6536000',
                'city' => 'Byron',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55961',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5103000',
                'longitude' => '-92.5073000',
                'city' => 'Ostrander',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55951',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5103000',
                'longitude' => '-92.5073000',
                'city' => 'Le Roy',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56036',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5094000',
                'longitude' => '-92.9427000',
                'city' => 'Glenville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55970',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5094000',
                'longitude' => '-92.9427000',
                'city' => 'Rose Creek',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55953',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5094000',
                'longitude' => '-92.9427000',
                'city' => 'Lyle',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55338',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.6721000',
                'longitude' => '-93.9985000',
                'city' => 'Green Isle',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55946',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2954000',
                'longitude' => '-93.2729000',
                'city' => 'Kenyon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56258',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4192000',
                'longitude' => '-95.5488000',
                'city' => 'Marshall',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56294',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4037000',
                'longitude' => '-95.2524000',
                'city' => 'Wanda',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56293',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4037000',
                'longitude' => '-95.2524000',
                'city' => 'Wabasso',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56139',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0892000',
                'longitude' => '-96.1840000',
                'city' => 'Holland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56140',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8476000',
                'longitude' => '-96.3970000',
                'city' => 'Ihlen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56177',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8476000',
                'longitude' => '-96.3970000',
                'city' => 'Trosky',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55990',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7097000',
                'longitude' => '-92.2683000',
                'city' => 'Wykoff',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55956',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2832000',
                'longitude' => '-92.4236000',
                'city' => 'Mazeppa',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55957',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2832000',
                'longitude' => '-92.4236000',
                'city' => 'Millville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56021',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3121000',
                'longitude' => '-94.4577000',
                'city' => 'Courtland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55985',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2017000',
                'longitude' => '-92.6517000',
                'city' => 'West Concord',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56052',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3830000',
                'longitude' => '-93.7288000',
                'city' => 'Kilkenny',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56057',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3830000',
                'longitude' => '-93.7288000',
                'city' => 'Le Center',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56168',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6236000',
                'longitude' => '-95.5915000',
                'city' => 'Rushmore',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56071',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4416000',
                'longitude' => '-93.5813000',
                'city' => 'New Prague',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56069',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4416000',
                'longitude' => '-93.5813000',
                'city' => 'Montgomery',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55976',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9080000',
                'longitude' => '-92.6579000',
                'city' => 'Stewartville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55973',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9080000',
                'longitude' => '-92.6579000',
                'city' => 'Sargeant',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55944',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9080000',
                'longitude' => '-92.6579000',
                'city' => 'Kasson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56151',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0014000',
                'longitude' => '-95.9572000',
                'city' => 'Lake Wilson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55927',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0314000',
                'longitude' => '-92.8589000',
                'city' => 'Dodge Center',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56056',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9825000',
                'longitude' => '-94.6293000',
                'city' => 'La Salle',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56081',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9825000',
                'longitude' => '-94.6293000',
                'city' => 'Saint James',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55967',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7775000',
                'longitude' => '-92.4828000',
                'city' => 'Racine',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56019',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1668000',
                'longitude' => '-94.0035000',
                'city' => 'Comfrey',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56002',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1668000',
                'longitude' => '-94.0035000',
                'city' => 'Mankato',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56129',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.4287000',
                'longitude' => '-96.1675000',
                'city' => 'Ellsworth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56173',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.4287000',
                'longitude' => '-96.1675000',
                'city' => 'Steen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56110',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.4415000',
                'longitude' => '-95.8808000',
                'city' => 'Adrian',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55921',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6317000',
                'longitude' => '-91.4933000',
                'city' => 'Caledonia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55969',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1001000',
                'longitude' => '-91.8096000',
                'city' => 'Rollingstone',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56229',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.6080000',
                'longitude' => '-95.6744000',
                'city' => 'Cottonwood',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55332',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5256000',
                'longitude' => '-94.7189000',
                'city' => 'Fairfax',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56159',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9412000',
                'longitude' => '-94.9306000',
                'city' => 'Mountain Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56239',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5116000',
                'longitude' => '-95.8919000',
                'city' => 'Ghent',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56060',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9235000',
                'longitude' => '-94.4432000',
                'city' => 'Lewisville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56088',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9235000',
                'longitude' => '-94.4432000',
                'city' => 'Truman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56090',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9235000',
                'longitude' => '-94.4432000',
                'city' => 'Vernon Center',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56062',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9235000',
                'longitude' => '-94.4432000',
                'city' => 'Madelia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56039',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7334000',
                'longitude' => '-94.4332000',
                'city' => 'Granada',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56075',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7334000',
                'longitude' => '-94.4332000',
                'city' => 'Northrop',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56041',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1515000',
                'longitude' => '-94.4917000',
                'city' => 'Hanska',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56128',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8742000',
                'longitude' => '-96.1331000',
                'city' => 'Edgerton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56155',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8328000',
                'longitude' => '-96.0127000',
                'city' => 'Lismore',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56153',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8328000',
                'longitude' => '-96.0127000',
                'city' => 'Leota',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55049',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0840000',
                'longitude' => '-93.2173000',
                'city' => 'Medford',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56152',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Lamberton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56137',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Heron Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56174',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0432000',
                'longitude' => '-95.4368000',
                'city' => 'Storden',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55959',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0531000',
                'longitude' => '-91.6433000',
                'city' => 'Minnesota City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56025',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8438000',
                'longitude' => '-93.8315000',
                'city' => 'Easton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56065',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8438000',
                'longitude' => '-93.8315000',
                'city' => 'Mapleton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56098',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6497000',
                'longitude' => '-94.2351000',
                'city' => 'Winnebago',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56013',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6497000',
                'longitude' => '-94.2351000',
                'city' => 'Blue Earth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56270',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5520000',
                'longitude' => '-94.9831000',
                'city' => 'Morton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55949',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7110000',
                'longitude' => '-91.9731000',
                'city' => 'Lanesboro',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56119',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8451000',
                'longitude' => '-95.4629000',
                'city' => 'Brewster',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56138',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.4368000',
                'longitude' => '-96.3263000',
                'city' => 'Hills',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56185',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7471000',
                'longitude' => '-95.9453000',
                'city' => 'Wilmont',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55982',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8890000',
                'longitude' => '-92.8441000',
                'city' => 'Waltham',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56165',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6175000',
                'longitude' => '-95.8004000',
                'city' => 'Reading',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55941',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7004000',
                'longitude' => '-91.2787000',
                'city' => 'Hokah',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55919',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7004000',
                'longitude' => '-91.2787000',
                'city' => 'Brownsville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56297',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.6518000',
                'longitude' => '-95.5374000',
                'city' => 'Wood Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56142',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3837000',
                'longitude' => '-96.1808000',
                'city' => 'Ivanhoe',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56113',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3837000',
                'longitude' => '-96.1808000',
                'city' => 'Arco',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55974',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5284000',
                'longitude' => '-91.7704000',
                'city' => 'Spring Grove',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55954',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5284000',
                'longitude' => '-91.7704000',
                'city' => 'Mabel',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55931',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5123000',
                'longitude' => '-91.4597000',
                'city' => 'Eitzen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55909',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5673000',
                'longitude' => '-92.7206000',
                'city' => 'Adams',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55972',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9658000',
                'longitude' => '-92.0600000',
                'city' => 'Saint Charles',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55952',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9857000',
                'longitude' => '-91.8645000',
                'city' => 'Lewiston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55979',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9857000',
                'longitude' => '-91.8645000',
                'city' => 'Utica',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55910',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9857000',
                'longitude' => '-91.8645000',
                'city' => 'Altura',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55924',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0465000',
                'longitude' => '-92.9960000',
                'city' => 'Claremont',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55964',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1683000',
                'longitude' => '-92.1744000',
                'city' => 'Plainview',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55945',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1683000',
                'longitude' => '-92.1744000',
                'city' => 'Kellogg',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '52160',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.4918000',
                'longitude' => '-91.2846000',
                'city' => 'New Albin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55335',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4490000',
                'longitude' => '-94.3944000',
                'city' => 'Gibbon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56034',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0456000',
                'longitude' => '-94.1606000',
                'city' => 'Garden City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56055',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0456000',
                'longitude' => '-94.1606000',
                'city' => 'Lake Crystal',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '57026',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2329000',
                'longitude' => '-96.4811000',
                'city' => 'Elkton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55947',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8343000',
                'longitude' => '-91.3094000',
                'city' => 'La Crescent',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55333',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5235000',
                'longitude' => '-94.8954000',
                'city' => 'Franklin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56033',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5016000',
                'longitude' => '-93.9166000',
                'city' => 'Frost',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '50465',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5016000',
                'longitude' => '-93.9166000',
                'city' => 'Rake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55933',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5673000',
                'longitude' => '-92.7206000',
                'city' => 'Elkton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55977',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5673000',
                'longitude' => '-92.7206000',
                'city' => 'Taopi',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55926',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7146000',
                'longitude' => '-92.7046000',
                'city' => 'Dexter',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56116',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7134000',
                'longitude' => '-96.5001000',
                'city' => 'Beaver Creek',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '57030',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7134000',
                'longitude' => '-96.5001000',
                'city' => 'Garretson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56120',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0341000',
                'longitude' => '-92.6536000',
                'city' => 'Butterfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56083',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0559000',
                'longitude' => '-95.2014000',
                'city' => 'Sanborn',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56101',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0559000',
                'longitude' => '-95.2014000',
                'city' => 'Windom',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56145',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0559000',
                'longitude' => '-95.2014000',
                'city' => 'Jeffers',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56132',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2337000',
                'longitude' => '-95.6157000',
                'city' => 'Garvin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56121',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5247000',
                'longitude' => '-94.6338000',
                'city' => 'Ceylon',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56127',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5247000',
                'longitude' => '-94.6338000',
                'city' => 'Dunnell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56162',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7575000',
                'longitude' => '-94.7155000',
                'city' => 'Ormsby',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56176',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7575000',
                'longitude' => '-94.7155000',
                'city' => 'Trimont',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56171',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7575000',
                'longitude' => '-94.7155000',
                'city' => 'Sherburn',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56214',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5410000',
                'longitude' => '-95.1918000',
                'city' => 'Belview',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55925',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9163000',
                'longitude' => '-91.3676000',
                'city' => 'Dakota',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55053',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4517000',
                'longitude' => '-93.1609000',
                'city' => 'Nerstrand',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55024',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4517000',
                'longitude' => '-93.1609000',
                'city' => 'Farmington',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55019',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4517000',
                'longitude' => '-93.1609000',
                'city' => 'Dundas',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56087',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2059000',
                'longitude' => '-95.1335000',
                'city' => 'Springfield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56115',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1761000',
                'longitude' => '-96.1066000',
                'city' => 'Balaton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55962',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7815000',
                'longitude' => '-91.8363000',
                'city' => 'Peterson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56150',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6758000',
                'longitude' => '-95.1768000',
                'city' => 'Lakefield',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56143',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6758000',
                'longitude' => '-95.1768000',
                'city' => 'Jackson',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56011',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4611000',
                'longitude' => '-93.9102000',
                'city' => 'Belle Plaine',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55046',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4749000',
                'longitude' => '-93.4338000',
                'city' => 'Lonsdale',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56134',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7734000',
                'longitude' => '-96.1974000',
                'city' => 'Hardwick',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55922',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5236000',
                'longitude' => '-91.9338000',
                'city' => 'Canton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56117',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5028000',
                'longitude' => '-95.6886000',
                'city' => 'Bigelow',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55052',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2262000',
                'longitude' => '-93.4501000',
                'city' => 'Morristown',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55988',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1001000',
                'longitude' => '-91.8096000',
                'city' => 'Stockton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56224',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3814000',
                'longitude' => '-95.0501000',
                'city' => 'Clements',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56111',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5603000',
                'longitude' => '-94.7777000',
                'city' => 'Alpha',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56181',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6662000',
                'longitude' => '-94.6183000',
                'city' => 'Welcome',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55971',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8077000',
                'longitude' => '-91.7492000',
                'city' => 'Rushford',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55992',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2901000',
                'longitude' => '-92.6723000',
                'city' => 'Zumbrota',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56160',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8663000',
                'longitude' => '-94.7403000',
                'city' => 'Odin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55939',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5339000',
                'longitude' => '-91.9341000',
                'city' => 'Harmony',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55088',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4773000',
                'longitude' => '-93.4253000',
                'city' => 'Webster',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56255',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4070000',
                'longitude' => '-95.4102000',
                'city' => 'Lucan',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56166',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2270000',
                'longitude' => '-95.2666000',
                'city' => 'Revere',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55991',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2832000',
                'longitude' => '-92.4236000',
                'city' => 'Zumbro Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55027',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2832000',
                'longitude' => '-92.4236000',
                'city' => 'Goodhue',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55041',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2832000',
                'longitude' => '-92.4236000',
                'city' => 'Lake City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55932',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2832000',
                'longitude' => '-92.4236000',
                'city' => 'Elgin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55936',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7136000',
                'longitude' => '-92.5651000',
                'city' => 'Grand Meadow',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '57068',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5828000',
                'longitude' => '-96.4621000',
                'city' => 'Valley Springs',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56292',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5083000',
                'longitude' => '-95.4130000',
                'city' => 'Vesta',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55981',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3078000',
                'longitude' => '-91.9977000',
                'city' => 'Wabasha',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56027',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5685000',
                'longitude' => '-94.3599000',
                'city' => 'Elmore',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56186',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.0086000',
                'longitude' => '-96.0993000',
                'city' => 'Woodstock',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56085',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2986000',
                'longitude' => '-94.7240000',
                'city' => 'Sleepy Eye',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56287',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5333000',
                'longitude' => '-94.5194000',
                'city' => 'Seaforth',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56169',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3137000',
                'longitude' => '-95.9513000',
                'city' => 'Russell',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55983',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3039000',
                'longitude' => '-92.7900000',
                'city' => 'Wanamingo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55066',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.2912000',
                'longitude' => '-93.2756000',
                'city' => 'Red Wing',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '51347',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.4539000',
                'longitude' => '-95.3202000',
                'city' => 'Lake Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56167',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.6957000',
                'longitude' => '-95.4674000',
                'city' => 'Round Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56042',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8024000',
                'longitude' => '-93.4899000',
                'city' => 'Hartland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56089',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.5626000',
                'longitude' => '-93.4241000',
                'city' => 'Twin Lakes',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56161',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7442000',
                'longitude' => '-95.3155000',
                'city' => 'Okabena',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56023',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7648000',
                'longitude' => '-94.0262000',
                'city' => 'Delavan',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '51360',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.4245000',
                'longitude' => '-95.0978000',
                'city' => 'Spirit Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56032',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7671000',
                'longitude' => '-93.5687000',
                'city' => 'Freeborn',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55943',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.8117000',
                'longitude' => '-91.7606000',
                'city' => 'Houston',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56157',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3853000',
                'longitude' => '-95.8890000',
                'city' => 'Lynd',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56047',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.7365000',
                'longitude' => '-94.2378000',
                'city' => 'Huntley',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56022',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.1082000',
                'longitude' => '-94.9005000',
                'city' => 'Darfur',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56237',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.6182000',
                'longitude' => '-95.4108000',
                'city' => 'Echo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '56017',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3238000',
                'longitude' => '-93.9555000',
                'city' => 'Cleveland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55929',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '43.9677000',
                'longitude' => '-92.0657000',
                'city' => 'Dover',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55421',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55430',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55311',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Osseo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55410',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55416',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55417',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55447',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55330',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Elk River',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55403',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55404',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55405',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55415',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55454',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55402',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55401',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55406',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55441',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9872000',
                'longitude' => '-93.3853000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55426',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9872000',
                'longitude' => '-93.3853000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55407',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55442',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9868000',
                'longitude' => '-93.3997000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55056',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'North Branch',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55124',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55369',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Osseo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55429',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55443',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55016',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Cottage Grove',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55455',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55419',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8845000',
                'longitude' => '-93.2876000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55422',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55431',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55413',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55411',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55449',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55304',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Andover',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55434',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55427',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55068',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Rosemount',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55408',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55344',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Eden Prairie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55014',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Circle Pines',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55409',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55111',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9439000',
                'longitude' => '-93.2358000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55436',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55108',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55418',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55337',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Burnsville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55303',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Anoka',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55424',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9166000',
                'longitude' => '-93.3239000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55412',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0023000',
                'longitude' => '-93.2907000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55414',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55432',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55082',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Stillwater',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55113',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55077',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Inver Grove Heights',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55305',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Hopkins',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55345',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minnetonka',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55343',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Hopkins',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55428',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55448',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55391',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Wayzata',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55433',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55327',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Dayton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55378',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Savage',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55372',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Prior Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55104',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55102',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55487',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55435',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55106',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55362',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Monticello',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55309',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Big Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55008',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Cambridge',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55420',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55123',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55316',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Champlin',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55011',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Cedar',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55437',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55379',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Shakopee',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55425',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55374',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Rogers',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55322',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Cologne',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55364',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Mound',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55044',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Lakeville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55122',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55127',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55306',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Burnsville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55347',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Eden Prairie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55444',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55328',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Delano',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55112',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55317',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Chanhassen',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55116',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55346',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Eden Prairie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55125',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55001',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Afton',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55129',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55439',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9057000',
                'longitude' => '-93.4156000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55076',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Inver Grove Heights',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55360',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Mayer',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55117',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55121',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55020',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Elko New Market',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55040',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Isanti',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55109',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55318',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Chaska',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55101',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55114',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55118',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55479',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55474',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9744000',
                'longitude' => '-93.2517000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55359',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Maple Plain',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55373',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Rockford',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55105',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55438',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55331',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Excelsior',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55043',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Lakeland',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55363',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Montrose',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55450',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.8949000',
                'longitude' => '-93.2102000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55070',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Francis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55120',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55025',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Forest Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55079',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Stacy',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55075',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'South Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55128',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55119',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55033',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Hastings',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55376',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Michael',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55110',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55042',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Lake Elmo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55107',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55357',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Loretto',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55445',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55386',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Victoria',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55103',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55126',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55398',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Zimmerman',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55446',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55375',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Bonifacius',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55340',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Hamel',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55013',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3921000',
                'longitude' => '-92.8465000',
                'city' => 'Chisago City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55012',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3921000',
                'longitude' => '-92.8465000',
                'city' => 'Center City',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55074',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3921000',
                'longitude' => '-92.8465000',
                'city' => 'Shafer',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55045',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3921000',
                'longitude' => '-92.8465000',
                'city' => 'Lindstrom',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55038',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Hugo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55055',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9435000',
                'longitude' => '-93.0943000',
                'city' => 'Newport',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55175',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9435000',
                'longitude' => '-93.0943000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55073',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Scandia',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55089',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4553000',
                'longitude' => '-92.7706000',
                'city' => 'Welch',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55071',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55003',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0539000',
                'longitude' => '-92.8090000',
                'city' => 'Bayport',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55092',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Wyoming',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55155',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9435000',
                'longitude' => '-93.0943000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55146',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9435000',
                'longitude' => '-93.0943000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55026',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.4496000',
                'longitude' => '-92.2653000',
                'city' => 'Frontenac',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55115',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0818000',
                'longitude' => '-93.0186000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55005',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3637000',
                'longitude' => '-92.9936000',
                'city' => 'Bethel',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55047',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.2333000',
                'longitude' => '-92.8281000',
                'city' => 'Marine On Saint Croix',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55084',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.4068000',
                'longitude' => '-92.6579000',
                'city' => 'Taylors Falls',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55090',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Willernie',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55085',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7428000',
                'longitude' => '-92.8546000',
                'city' => 'Vermillion',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55968',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.3816000',
                'longitude' => '-92.0342000',
                'city' => 'Reads Landing',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55144',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55133',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Saint Paul',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55459',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9802000',
                'longitude' => '-93.2693000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55308',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.3941000',
                'longitude' => '-93.8808000',
                'city' => 'Becker',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55356',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9735000',
                'longitude' => '-93.5001000',
                'city' => 'Long Lake',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55341',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Hanover',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55301',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.1192000',
                'longitude' => '-93.4008000',
                'city' => 'Albertville',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55377',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5672000',
                'longitude' => '-93.7707000',
                'city' => 'Santiago',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55017',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.5726000',
                'longitude' => '-93.2308000',
                'city' => 'Dalbo',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55352',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0307000',
                'longitude' => '-93.4569000',
                'city' => 'Jordan',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55054',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.5826000',
                'longitude' => '-93.3594000',
                'city' => 'Elko New Market',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55397',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9439000',
                'longitude' => '-93.6601000',
                'city' => 'Young America',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55315',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.7988000',
                'longitude' => '-93.6038000',
                'city' => 'Carver',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55388',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9060000',
                'longitude' => '-93.7482000',
                'city' => 'Watertown',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55384',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '45.0436000',
                'longitude' => '-93.2928000',
                'city' => 'Spring Park',
                'full_state' => 'Minnesota',
            ],
            [
                'zip' => '55440',
                'country_code' => 'US',
                'state' => 'MN',
                'latitude' => '44.9735000',
                'longitude' => '-93.5001000',
                'city' => 'Minneapolis',
                'full_state' => 'Minnesota',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
