<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MarylandSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '20680',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1151000',
                'longitude' => '-76.3665000',
                'city' => 'Ridge',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20855',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Derwood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20851',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Rockville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20706',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Lanham',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20720',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Bowie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21770',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2904000',
                'longitude' => '-77.2083000',
                'city' => 'Monrovia',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20871',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2904000',
                'longitude' => '-77.2083000',
                'city' => 'Clarksburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20611',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5245000',
                'longitude' => '-76.9728000',
                'city' => 'Bel Alton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20677',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5245000',
                'longitude' => '-76.9728000',
                'city' => 'Port Tobacco',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20640',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6020000',
                'longitude' => '-77.1680000',
                'city' => 'Indian Head',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20603',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6263000',
                'longitude' => '-76.9039000',
                'city' => 'Waldorf',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20602',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6263000',
                'longitude' => '-76.9039000',
                'city' => 'Waldorf',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21550',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4080000',
                'longitude' => '-79.4113000',
                'city' => 'Oakland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20659',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4422000',
                'longitude' => '-76.7391000',
                'city' => 'Mechanicsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21703',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3148000',
                'longitude' => '-77.3288000',
                'city' => 'Frederick',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21701',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3148000',
                'longitude' => '-77.3288000',
                'city' => 'Frederick',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21742',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6425000',
                'longitude' => '-77.7281000',
                'city' => 'Hagerstown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20662',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4503000',
                'longitude' => '-77.2163000',
                'city' => 'Nanjemoy',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20645',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3521000',
                'longitude' => '-76.9322000',
                'city' => 'Issue',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20632',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3521000',
                'longitude' => '-76.9322000',
                'city' => 'Faulkner',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20837',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1419000',
                'longitude' => '-77.4196000',
                'city' => 'Poolesville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20852',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0558000',
                'longitude' => '-77.1230000',
                'city' => 'Rockville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20814',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9047000',
                'longitude' => '-77.0281000',
                'city' => 'Bethesda',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20744',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Fort Washington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20748',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Temple Hills',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21702',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4185000',
                'longitude' => '-77.4089000',
                'city' => 'Frederick',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20723',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1038000',
                'longitude' => '-76.8499000',
                'city' => 'Laurel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20637',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5343000',
                'longitude' => '-76.7856000',
                'city' => 'Hughesville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20782',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9047000',
                'longitude' => '-77.0281000',
                'city' => 'Hyattsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20722',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9047000',
                'longitude' => '-77.0281000',
                'city' => 'Brentwood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20817',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9858000',
                'longitude' => '-77.1065000',
                'city' => 'Bethesda',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20815',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9858000',
                'longitude' => '-77.1065000',
                'city' => 'Chevy Chase',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21793',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Walkersville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21769',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Middletown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21716',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Brunswick',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21774',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'New Market',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21788',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Thurmont',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21773',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Myersville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21727',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Emmitsburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21754',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Ijamsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21762',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Libertytown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21704',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Frederick',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21798',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Woodsboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20620',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2394000',
                'longitude' => '-76.4909000',
                'city' => 'Callaway',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20634',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2394000',
                'longitude' => '-76.4909000',
                'city' => 'Great Mills',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20650',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2926000',
                'longitude' => '-76.6288000',
                'city' => 'Leonardtown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20737',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9458000',
                'longitude' => '-77.0632000',
                'city' => 'Riverdale',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20770',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9458000',
                'longitude' => '-77.0632000',
                'city' => 'Greenbelt',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20902',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0260000',
                'longitude' => '-77.0778000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20879',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1431000',
                'longitude' => '-77.2031000',
                'city' => 'Gaithersburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20877',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1431000',
                'longitude' => '-77.2031000',
                'city' => 'Gaithersburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20623',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8842000',
                'longitude' => '-77.0106000',
                'city' => 'Cheltenham',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20762',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8842000',
                'longitude' => '-77.0106000',
                'city' => 'Andrews Air Force Base',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20910',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9047000',
                'longitude' => '-77.0281000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20901',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9047000',
                'longitude' => '-77.0281000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20613',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7002000',
                'longitude' => '-76.8451000',
                'city' => 'Brandywine',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21719',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.7163000',
                'longitude' => '-77.4889000',
                'city' => 'Cascade',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20882',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1431000',
                'longitude' => '-77.2031000',
                'city' => 'Gaithersburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20712',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9047000',
                'longitude' => '-77.0281000',
                'city' => 'Mount Rainier',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20886',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Montgomery Village',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21114',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Crofton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21403',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Annapolis',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20764',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Shady Side',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20707',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Laurel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20711',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8841000',
                'longitude' => '-76.9175000',
                'city' => 'Lothian',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20774',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8841000',
                'longitude' => '-76.9175000',
                'city' => 'Upper Marlboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20904',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9858000',
                'longitude' => '-77.1065000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21536',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.7030000',
                'longitude' => '-79.1596000',
                'city' => 'Grantsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21075',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1101000',
                'longitude' => '-76.8514000',
                'city' => 'Elkridge',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21227',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1101000',
                'longitude' => '-76.8514000',
                'city' => 'Halethorpe',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21532',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6503000',
                'longitude' => '-78.9266000',
                'city' => 'Frostburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21750',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.7090000',
                'longitude' => '-78.1732000',
                'city' => 'Hancock',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20895',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0526000',
                'longitude' => '-77.0756000',
                'city' => 'Kensington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20853',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0827000',
                'longitude' => '-77.0487000',
                'city' => 'Rockville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20724',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1101000',
                'longitude' => '-76.8514000',
                'city' => 'Laurel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20746',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9021000',
                'longitude' => '-77.0233000',
                'city' => 'Suitland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20747',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9021000',
                'longitude' => '-77.0233000',
                'city' => 'District Heights',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20735',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Clinton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20854',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0815000',
                'longitude' => '-77.1503000',
                'city' => 'Potomac',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20878',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0815000',
                'longitude' => '-77.1503000',
                'city' => 'Gaithersburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20850',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0815000',
                'longitude' => '-77.1503000',
                'city' => 'Rockville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21562',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4507000',
                'longitude' => '-78.9772000',
                'city' => 'Westernport',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20861',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1521000',
                'longitude' => '-77.0225000',
                'city' => 'Ashton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20860',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1521000',
                'longitude' => '-77.0225000',
                'city' => 'Sandy Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20708',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Laurel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21557',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5920000',
                'longitude' => '-78.8341000',
                'city' => 'Rawlings',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21502',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5920000',
                'longitude' => '-78.8341000',
                'city' => 'Cumberland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21795',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5989000',
                'longitude' => '-77.8245000',
                'city' => 'Williamsport',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21771',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3748000',
                'longitude' => '-77.1598000',
                'city' => 'Mount Airy',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21113',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1017000',
                'longitude' => '-76.7221000',
                'city' => 'Odenton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20616',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8841000',
                'longitude' => '-76.9175000',
                'city' => 'Bryans Road',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20721',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8841000',
                'longitude' => '-76.9175000',
                'city' => 'Bowie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20646',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8841000',
                'longitude' => '-76.9175000',
                'city' => 'La Plata',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20874',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Germantown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21740',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6425000',
                'longitude' => '-77.7281000',
                'city' => 'Hagerstown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20745',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Oxon Hill',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21045',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1038000',
                'longitude' => '-76.8499000',
                'city' => 'Columbia',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20906',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0115000',
                'longitude' => '-77.0405000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20816',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9779000',
                'longitude' => '-77.0919000',
                'city' => 'Bethesda',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20740',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9931000',
                'longitude' => '-76.9132000',
                'city' => 'College Park',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20678',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0115000',
                'longitude' => '-77.0405000',
                'city' => 'Prince Frederick',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21046',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1038000',
                'longitude' => '-76.8499000',
                'city' => 'Columbia',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20794',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1038000',
                'longitude' => '-76.8499000',
                'city' => 'Jessup',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20763',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1038000',
                'longitude' => '-76.8499000',
                'city' => 'Savage',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20781',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9567000',
                'longitude' => '-76.9386000',
                'city' => 'Hyattsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20783',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Hyattsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20785',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Hyattsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20912',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9999000',
                'longitude' => '-77.0293000',
                'city' => 'Takoma Park',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20885',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1431000',
                'longitude' => '-77.2031000',
                'city' => 'Gaithersburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20813',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0240000',
                'longitude' => '-77.1155000',
                'city' => 'Bethesda',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20653',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2678000',
                'longitude' => '-76.4512000',
                'city' => 'Lexington Park',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20670',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2678000',
                'longitude' => '-76.4512000',
                'city' => 'Patuxent River',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20619',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2678000',
                'longitude' => '-76.4512000',
                'city' => 'California',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21780',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6550000',
                'longitude' => '-77.5727000',
                'city' => 'Sabillasville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21783',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6550000',
                'longitude' => '-77.5727000',
                'city' => 'Smithsburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20872',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Damascus',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20607',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7111000',
                'longitude' => '-76.9785000',
                'city' => 'Accokeek',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21035',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9147000',
                'longitude' => '-76.5522000',
                'city' => 'Davidsonville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21140',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9147000',
                'longitude' => '-76.5522000',
                'city' => 'Riva',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20776',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9147000',
                'longitude' => '-76.5522000',
                'city' => 'Harwood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21037',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9147000',
                'longitude' => '-76.5522000',
                'city' => 'Edgewater',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20759',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1038000',
                'longitude' => '-76.8499000',
                'city' => 'Fulton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20769',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9980000',
                'longitude' => '-76.9017000',
                'city' => 'Glenn Dale',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20784',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9567000',
                'longitude' => '-76.9386000',
                'city' => 'Hyattsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20710',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9567000',
                'longitude' => '-76.9386000',
                'city' => 'Bladensburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20705',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Beltsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20717',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Bowie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20716',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Bowie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20830',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Olney',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21782',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6077000',
                'longitude' => '-77.8095000',
                'city' => 'Sharpsburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21733',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6077000',
                'longitude' => '-77.8095000',
                'city' => 'Fairplay',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20905',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9733000',
                'longitude' => '-77.1248000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20818',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9733000',
                'longitude' => '-77.1248000',
                'city' => 'Cabin John',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20862',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1521000',
                'longitude' => '-77.0225000',
                'city' => 'Brinklow',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20866',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0794000',
                'longitude' => '-77.0013000',
                'city' => 'Burtonsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20907',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21522',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5883000',
                'longitude' => '-79.2366000',
                'city' => 'Bittinger',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21520',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5883000',
                'longitude' => '-79.2366000',
                'city' => 'Accident',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21561',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5883000',
                'longitude' => '-79.2366000',
                'city' => 'Swanton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20643',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4567000',
                'longitude' => '-77.2178000',
                'city' => 'Ironsides',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20903',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Silver Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20661',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3249000',
                'longitude' => '-76.8923000',
                'city' => 'Mount Victoria',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20664',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3249000',
                'longitude' => '-76.8923000',
                'city' => 'Newburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20625',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3249000',
                'longitude' => '-76.8923000',
                'city' => 'Cobb Island',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20833',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1324000',
                'longitude' => '-77.0689000',
                'city' => 'Brookeville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20832',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1324000',
                'longitude' => '-77.0689000',
                'city' => 'Olney',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21054',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Gambrills',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20751',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Deale',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21401',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Annapolis',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20778',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'West River',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20733',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Churchton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20715',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9705000',
                'longitude' => '-76.7682000',
                'city' => 'Bowie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21545',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.7318000',
                'longitude' => '-78.8491000',
                'city' => 'Mount Savage',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21778',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6216000',
                'longitude' => '-77.4148000',
                'city' => 'Rocky Ridge',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20006',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9858000',
                'longitude' => '-77.1065000',
                'city' => 'Washington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20601',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5343000',
                'longitude' => '-76.7856000',
                'city' => 'Waldorf',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20612',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5343000',
                'longitude' => '-76.7856000',
                'city' => 'Benedict',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20622',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5343000',
                'longitude' => '-76.7856000',
                'city' => 'Charlotte Hall',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20617',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5343000',
                'longitude' => '-76.7856000',
                'city' => 'Bryantown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21213',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9518000',
                'longitude' => '-76.9502000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20771',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9980000',
                'longitude' => '-76.9017000',
                'city' => 'Greenbelt',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20889',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0240000',
                'longitude' => '-77.1155000',
                'city' => 'Bethesda',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21042',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9931000',
                'longitude' => '-76.9132000',
                'city' => 'Ellicott City',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21043',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9931000',
                'longitude' => '-76.9132000',
                'city' => 'Ellicott City',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21029',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9931000',
                'longitude' => '-76.9132000',
                'city' => 'Clarksville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21044',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9931000',
                'longitude' => '-76.9132000',
                'city' => 'Columbia',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21203',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9931000',
                'longitude' => '-76.9132000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21228',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1885000',
                'longitude' => '-76.8313000',
                'city' => 'Catonsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20742',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9291000',
                'longitude' => '-76.8772000',
                'city' => 'College Park',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20743',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9291000',
                'longitude' => '-76.8772000',
                'city' => 'Capitol Heights',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20709',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0888000',
                'longitude' => '-76.8634000',
                'city' => 'Laurel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20772',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Upper Marlboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21111',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9980000',
                'longitude' => '-76.9017000',
                'city' => 'Monkton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21204',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Towson',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20841',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1457000',
                'longitude' => '-77.4163000',
                'city' => 'Boyds',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20842',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1457000',
                'longitude' => '-77.4163000',
                'city' => 'Dickerson',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20839',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1457000',
                'longitude' => '-77.4163000',
                'city' => 'Beallsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20838',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1457000',
                'longitude' => '-77.4163000',
                'city' => 'Barnesville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20876',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1758000',
                'longitude' => '-77.2746000',
                'city' => 'Germantown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21523',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4823000',
                'longitude' => '-79.0498000',
                'city' => 'Bloomington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21540',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4823000',
                'longitude' => '-79.0498000',
                'city' => 'Luke',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20701',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0888000',
                'longitude' => '-76.8634000',
                'city' => 'Annapolis Junction',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21755',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4336000',
                'longitude' => '-77.5107000',
                'city' => 'Jefferson',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20636',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3462000',
                'longitude' => '-76.5739000',
                'city' => 'Hollywood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20695',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6225000',
                'longitude' => '-76.9072000',
                'city' => 'White Plains',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20058',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0240000',
                'longitude' => '-77.1155000',
                'city' => 'Washington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21541',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5014000',
                'longitude' => '-79.3249000',
                'city' => 'Mc Henry',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20693',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5425000',
                'longitude' => '-76.9854000',
                'city' => 'Welcome',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20675',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5425000',
                'longitude' => '-76.9854000',
                'city' => 'Pomfret',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20892',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0023000',
                'longitude' => '-77.1061000',
                'city' => 'Bethesda',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21201',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9291000',
                'longitude' => '-76.8772000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21108',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9980000',
                'longitude' => '-76.9017000',
                'city' => 'Millersville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21756',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6077000',
                'longitude' => '-77.8095000',
                'city' => 'Keedysville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21713',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6077000',
                'longitude' => '-77.8095000',
                'city' => 'Boonsboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20868',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0794000',
                'longitude' => '-77.0013000',
                'city' => 'Spencerville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21779',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4899000',
                'longitude' => '-77.6909000',
                'city' => 'Rohrersville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21758',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4899000',
                'longitude' => '-77.6909000',
                'city' => 'Knoxville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20753',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'District Heights',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20857',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0558000',
                'longitude' => '-77.1230000',
                'city' => 'Rockville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21787',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.7030000',
                'longitude' => '-77.3272000',
                'city' => 'Taneytown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20718',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0023000',
                'longitude' => '-77.1061000',
                'city' => 'Bowie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21538',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3927000',
                'longitude' => '-79.1974000',
                'city' => 'Kitzmiller',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20233',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9999000',
                'longitude' => '-77.0293000',
                'city' => 'Washington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21521',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5689000',
                'longitude' => '-78.9825000',
                'city' => 'Barton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21542',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5689000',
                'longitude' => '-78.9825000',
                'city' => 'Midland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21539',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5689000',
                'longitude' => '-78.9825000',
                'city' => 'Lonaconing',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20627',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2953000',
                'longitude' => '-76.6336000',
                'city' => 'Compton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20656',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2953000',
                'longitude' => '-76.6336000',
                'city' => 'Loveville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20624',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2953000',
                'longitude' => '-76.6336000',
                'city' => 'Clements',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21766',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5438000',
                'longitude' => '-78.6116000',
                'city' => 'Little Orleans',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21555',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5438000',
                'longitude' => '-78.6116000',
                'city' => 'Oldtown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21530',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5438000',
                'longitude' => '-78.6116000',
                'city' => 'Flintstone',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20024',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9980000',
                'longitude' => '-76.9017000',
                'city' => 'Washington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20741',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9980000',
                'longitude' => '-76.9017000',
                'city' => 'College Park',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21737',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9980000',
                'longitude' => '-76.9017000',
                'city' => 'Glenelg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20812',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9779000',
                'longitude' => '-77.0919000',
                'city' => 'Glen Echo',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20732',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Chesapeake Beach',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20639',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Huntingtown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20676',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Port Republic',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20657',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Lusby',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20685',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Saint Leonard',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21060',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0115000',
                'longitude' => '-77.0405000',
                'city' => 'Glen Burnie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20750',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8026000',
                'longitude' => '-76.9830000',
                'city' => 'Oxon Hill',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21230',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4185000',
                'longitude' => '-77.4089000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '23608',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0115000',
                'longitude' => '-77.0405000',
                'city' => 'Newport News',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '22302',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0867000',
                'longitude' => '-77.1600000',
                'city' => 'Alexandria',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21202',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9010000',
                'longitude' => '-77.0315000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20608',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6610000',
                'longitude' => '-76.7727000',
                'city' => 'Aquasco',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21722',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6077000',
                'longitude' => '-77.8095000',
                'city' => 'Clear Spring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21710',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3826000',
                'longitude' => '-77.2682000',
                'city' => 'Adamstown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20500',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4148000',
                'longitude' => '-77.4123000',
                'city' => 'Washington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21032',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Crownsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21144',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Severn',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20755',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Fort George G Meade',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21528',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6542000',
                'longitude' => '-78.9233000',
                'city' => 'Eckhart Mines',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21543',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6542000',
                'longitude' => '-78.9233000',
                'city' => 'Midlothian',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21529',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6531000',
                'longitude' => '-78.7599000',
                'city' => 'Ellerslie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21503',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6531000',
                'longitude' => '-78.7599000',
                'city' => 'Cumberland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21524',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6531000',
                'longitude' => '-78.7599000',
                'city' => 'Corriganville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20775',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0115000',
                'longitude' => '-77.0405000',
                'city' => 'Upper Marlboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21767',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6425000',
                'longitude' => '-77.7281000',
                'city' => 'Maugansville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20658',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6006000',
                'longitude' => '-77.1550000',
                'city' => 'Marbury',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21531',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6272000',
                'longitude' => '-79.3243000',
                'city' => 'Friendsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21061',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0115000',
                'longitude' => '-77.0405000',
                'city' => 'Glen Burnie',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20618',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2899000',
                'longitude' => '-76.7666000',
                'city' => 'Bushwood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20626',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2899000',
                'longitude' => '-76.7666000',
                'city' => 'Coltons Point',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20606',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2899000',
                'longitude' => '-76.7666000',
                'city' => 'Abell',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20609',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2899000',
                'longitude' => '-76.7666000',
                'city' => 'Avenue',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20621',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2899000',
                'longitude' => '-76.7666000',
                'city' => 'Chaptico',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20714',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7046000',
                'longitude' => '-76.5761000',
                'city' => 'North Beach',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20736',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7046000',
                'longitude' => '-76.5761000',
                'city' => 'Owings',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20689',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7046000',
                'longitude' => '-76.5761000',
                'city' => 'Sunderland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20754',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7046000',
                'longitude' => '-76.5761000',
                'city' => 'Dunkirk',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21244',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9550000',
                'longitude' => '-76.9976000',
                'city' => 'Windsor Mill',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21711',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6593000',
                'longitude' => '-77.9293000',
                'city' => 'Big Pool',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21757',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4863000',
                'longitude' => '-77.3483000',
                'city' => 'Keymar',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21784',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2093000',
                'longitude' => '-76.9424000',
                'city' => 'Sykesville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21794',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2093000',
                'longitude' => '-76.9424000',
                'city' => 'West Friendship',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21036',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2093000',
                'longitude' => '-76.9424000',
                'city' => 'Dayton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21738',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2093000',
                'longitude' => '-76.9424000',
                'city' => 'Glenwood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21797',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2093000',
                'longitude' => '-76.9424000',
                'city' => 'Woodbine',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20777',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2093000',
                'longitude' => '-76.9424000',
                'city' => 'Highland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20758',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Friendship',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20779',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8180000',
                'longitude' => '-76.7541000',
                'city' => 'Tracys Landing',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21012',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Arnold',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20686',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2678000',
                'longitude' => '-76.4512000',
                'city' => 'Saint Marys City',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20667',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2678000',
                'longitude' => '-76.4512000',
                'city' => 'Park Hall',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20687',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1178000',
                'longitude' => '-76.3713000',
                'city' => 'Scotland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20684',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1178000',
                'longitude' => '-76.3713000',
                'city' => 'Saint Inigoes',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20628',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1178000',
                'longitude' => '-76.3713000',
                'city' => 'Dameron',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21790',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3300000',
                'longitude' => '-77.4304000',
                'city' => 'Tuscarora',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21717',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3300000',
                'longitude' => '-77.4304000',
                'city' => 'Buckeystown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21777',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3300000',
                'longitude' => '-77.4304000',
                'city' => 'Point Of Rocks',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20765',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9839000',
                'longitude' => '-76.8136000',
                'city' => 'Galesville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21791',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4863000',
                'longitude' => '-77.3483000',
                'city' => 'Union Bridge',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20875',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0115000',
                'longitude' => '-77.0405000',
                'city' => 'Germantown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20896',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0526000',
                'longitude' => '-77.0756000',
                'city' => 'Garrett Park',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21405',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9870000',
                'longitude' => '-76.5517000',
                'city' => 'Annapolis',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20880',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1431000',
                'longitude' => '-77.2031000',
                'city' => 'Washington Grove',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20859',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1431000',
                'longitude' => '-77.2031000',
                'city' => 'Potomac',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20630',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1877000',
                'longitude' => '-76.5085000',
                'city' => 'Drayden',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20674',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1877000',
                'longitude' => '-76.5085000',
                'city' => 'Piney Point',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20692',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1877000',
                'longitude' => '-76.5085000',
                'city' => 'Valley Lee',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20690',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1877000',
                'longitude' => '-76.5085000',
                'city' => 'Tall Timbers',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20703',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0587000',
                'longitude' => '-76.8903000',
                'city' => 'Lanham',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21601',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7717000',
                'longitude' => '-76.0765000',
                'city' => 'Easton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21804',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3579000',
                'longitude' => '-75.5967000',
                'city' => 'Salisbury',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21163',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2747000',
                'longitude' => '-76.8258000',
                'city' => 'Woodstock',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21229',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2635000',
                'longitude' => '-76.6913000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21209',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3680000',
                'longitude' => '-76.7196000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21286',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3002000',
                'longitude' => '-76.6147000',
                'city' => 'Towson',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21811',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3803000',
                'longitude' => '-75.1671000',
                'city' => 'Berlin',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21801',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3579000',
                'longitude' => '-75.5967000',
                'city' => 'Salisbury',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21666',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9847000',
                'longitude' => '-76.4961000',
                'city' => 'Stevensville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21842',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3345000',
                'longitude' => '-75.1158000',
                'city' => 'Ocean City',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21233',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6967000',
                'longitude' => '-76.0596000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21221',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3002000',
                'longitude' => '-76.6147000',
                'city' => 'Essex',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21090',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3002000',
                'longitude' => '-76.6147000',
                'city' => 'Linthicum Heights',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21849',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3642000',
                'longitude' => '-75.5981000',
                'city' => 'Parsonsburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21837',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3642000',
                'longitude' => '-75.5981000',
                'city' => 'Mardela Springs',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21822',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3642000',
                'longitude' => '-75.5981000',
                'city' => 'Eden',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21830',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3642000',
                'longitude' => '-75.5981000',
                'city' => 'Hebron',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21853',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3642000',
                'longitude' => '-75.5981000',
                'city' => 'Princess Anne',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21826',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3642000',
                'longitude' => '-75.5981000',
                'city' => 'Fruitland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21669',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5714000',
                'longitude' => '-76.0785000',
                'city' => 'Taylors Island',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21631',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5714000',
                'longitude' => '-76.0785000',
                'city' => 'East New Market',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21677',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5714000',
                'longitude' => '-76.0785000',
                'city' => 'Woolford',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21648',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5714000',
                'longitude' => '-76.0785000',
                'city' => 'Madison',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21835',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5714000',
                'longitude' => '-76.0785000',
                'city' => 'Linkwood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21613',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5714000',
                'longitude' => '-76.0785000',
                'city' => 'Cambridge',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21146',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1646000',
                'longitude' => '-76.6219000',
                'city' => 'Severna Park',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21122',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1646000',
                'longitude' => '-76.6219000',
                'city' => 'Pasadena',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21225',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1646000',
                'longitude' => '-76.6219000',
                'city' => 'Brooklyn',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21205',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2938000',
                'longitude' => '-76.6132000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21218',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2938000',
                'longitude' => '-76.6132000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21231',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2938000',
                'longitude' => '-76.6132000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21223',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2938000',
                'longitude' => '-76.6132000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21216',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3107000',
                'longitude' => '-76.6341000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21215',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3107000',
                'longitude' => '-76.6341000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21211',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3107000',
                'longitude' => '-76.6341000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21217',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3107000',
                'longitude' => '-76.6341000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21654',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6875000',
                'longitude' => '-76.1674000',
                'city' => 'Oxford',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21622',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5714000',
                'longitude' => '-76.0785000',
                'city' => 'Church Creek',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21120',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Parkton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21208',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Pikesville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21030',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Cockeysville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21093',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Lutherville Timonium',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21031',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Hunt Valley',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21131',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Phoenix',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20688',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3262000',
                'longitude' => '-76.4561000',
                'city' => 'Solomons',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21210',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3268000',
                'longitude' => '-76.6122000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21220',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3138000',
                'longitude' => '-76.4646000',
                'city' => 'Middle River',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21237',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3138000',
                'longitude' => '-76.4646000',
                'city' => 'Rosedale',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21155',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6112000',
                'longitude' => '-76.8522000',
                'city' => 'Upperco',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21136',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6112000',
                'longitude' => '-76.8522000',
                'city' => 'Reisterstown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21157',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6112000',
                'longitude' => '-76.8522000',
                'city' => 'Westminster',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21074',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6112000',
                'longitude' => '-76.8522000',
                'city' => 'Hampstead',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21102',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6112000',
                'longitude' => '-76.8522000',
                'city' => 'Manchester',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21236',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2695000',
                'longitude' => '-76.7438000',
                'city' => 'Nottingham',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21128',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4116000',
                'longitude' => '-76.4697000',
                'city' => 'Perry Hall',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21234',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4116000',
                'longitude' => '-76.4697000',
                'city' => 'Parkville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21802',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3579000',
                'longitude' => '-75.5967000',
                'city' => 'Salisbury',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21117',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4539000',
                'longitude' => '-76.6326000',
                'city' => 'Owings Mills',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21239',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3537000',
                'longitude' => '-76.5588000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21206',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3537000',
                'longitude' => '-76.5588000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21214',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3537000',
                'longitude' => '-76.5588000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21226',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1274000',
                'longitude' => '-76.5328000',
                'city' => 'Curtis Bay',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21056',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1274000',
                'longitude' => '-76.5328000',
                'city' => 'Gibson Island',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21162',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4116000',
                'longitude' => '-76.4697000',
                'city' => 'White Marsh',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21212',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1803000',
                'longitude' => '-76.7232000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21048',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5754000',
                'longitude' => '-76.9934000',
                'city' => 'Finksburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21411',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9783000',
                'longitude' => '-76.4947000',
                'city' => 'Annapolis',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21224',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1803000',
                'longitude' => '-76.7232000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21207',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3238000',
                'longitude' => '-76.7307000',
                'city' => 'Gwynn Oak',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21078',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5091000',
                'longitude' => '-76.1677000',
                'city' => 'Havre De Grace',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21001',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5091000',
                'longitude' => '-76.1677000',
                'city' => 'Aberdeen',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21017',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5091000',
                'longitude' => '-76.1677000',
                'city' => 'Belcamp',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21005',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5091000',
                'longitude' => '-76.1677000',
                'city' => 'Aberdeen Proving Ground',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21913',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4056000',
                'longitude' => '-75.8638000',
                'city' => 'Cecilton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21912',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4056000',
                'longitude' => '-75.8638000',
                'city' => 'Warwick',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21915',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4056000',
                'longitude' => '-75.8638000',
                'city' => 'Chesapeake City',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21919',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4056000',
                'longitude' => '-75.8638000',
                'city' => 'Earleville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21222',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2757000',
                'longitude' => '-76.5283000',
                'city' => 'Dundalk',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21921',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6001000',
                'longitude' => '-75.9446000',
                'city' => 'Elkton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21914',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6001000',
                'longitude' => '-75.9446000',
                'city' => 'Charlestown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21911',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6001000',
                'longitude' => '-75.9446000',
                'city' => 'Rising Sun',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21901',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6001000',
                'longitude' => '-75.9446000',
                'city' => 'North East',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21402',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9783000',
                'longitude' => '-76.4947000',
                'city' => 'Annapolis',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21658',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9941000',
                'longitude' => '-76.1553000',
                'city' => 'Queenstown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21152',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5431000',
                'longitude' => '-76.6529000',
                'city' => 'Sparks Glencoe',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21023',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5431000',
                'longitude' => '-76.6529000',
                'city' => 'Butler',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21076',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9847000',
                'longitude' => '-76.4961000',
                'city' => 'Hanover',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21015',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5346000',
                'longitude' => '-76.3481000',
                'city' => 'Bel Air',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20629',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3379000',
                'longitude' => '-76.4671000',
                'city' => 'Dowell',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21053',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Freeland',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21161',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'White Hall',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21027',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3710000',
                'longitude' => '-76.4052000',
                'city' => 'Chase',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21620',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3002000',
                'longitude' => '-76.6147000',
                'city' => 'Chestertown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21158',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6839000',
                'longitude' => '-77.0402000',
                'city' => 'Westminster',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21645',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3301000',
                'longitude' => '-76.0429000',
                'city' => 'Kennedyville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21610',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3301000',
                'longitude' => '-76.0429000',
                'city' => 'Betterton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21678',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3301000',
                'longitude' => '-76.0429000',
                'city' => 'Worton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21667',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3301000',
                'longitude' => '-76.0429000',
                'city' => 'Still Pond',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21862',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4262000',
                'longitude' => '-75.2184000',
                'city' => 'Showell',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21872',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4262000',
                'longitude' => '-75.2184000',
                'city' => 'Whaleyville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21813',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4262000',
                'longitude' => '-75.2184000',
                'city' => 'Bishopville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21655',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9847000',
                'longitude' => '-76.4961000',
                'city' => 'Preston',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21105',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6281000',
                'longitude' => '-76.6552000',
                'city' => 'Maryland Line',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21629',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9265000',
                'longitude' => '-75.9205000',
                'city' => 'Denton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21625',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9265000',
                'longitude' => '-75.9205000',
                'city' => 'Cordova',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21641',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9265000',
                'longitude' => '-75.9205000',
                'city' => 'Hillsboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21657',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9265000',
                'longitude' => '-75.9205000',
                'city' => 'Queen Anne',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21660',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9265000',
                'longitude' => '-75.9205000',
                'city' => 'Ridgely',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21659',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4867000',
                'longitude' => '-75.8245000',
                'city' => 'Rhodesdale',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21643',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4867000',
                'longitude' => '-75.8245000',
                'city' => 'Hurlock',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21869',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4867000',
                'longitude' => '-75.8245000',
                'city' => 'Vienna',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21903',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5984000',
                'longitude' => '-76.0850000',
                'city' => 'Perryville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21904',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5984000',
                'longitude' => '-76.0850000',
                'city' => 'Port Deposit',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21918',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5984000',
                'longitude' => '-76.0850000',
                'city' => 'Conowingo',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21219',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2554000',
                'longitude' => '-76.4599000',
                'city' => 'Sparrows Point',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21052',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2554000',
                'longitude' => '-76.4599000',
                'city' => 'Fort Howard',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21675',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3481000',
                'longitude' => '-76.2219000',
                'city' => 'Wingate',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21634',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3481000',
                'longitude' => '-76.2219000',
                'city' => 'Fishing Creek',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21627',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3481000',
                'longitude' => '-76.2219000',
                'city' => 'Crocheron',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21626',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3481000',
                'longitude' => '-76.2219000',
                'city' => 'Crapo',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21672',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3481000',
                'longitude' => '-76.2219000',
                'city' => 'Toddville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21154',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5604000',
                'longitude' => '-76.2515000',
                'city' => 'Street',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21160',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5604000',
                'longitude' => '-76.2515000',
                'city' => 'Whiteford',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21132',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5604000',
                'longitude' => '-76.2515000',
                'city' => 'Pylesville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21034',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5604000',
                'longitude' => '-76.2515000',
                'city' => 'Darlington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21028',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5604000',
                'longitude' => '-76.2515000',
                'city' => 'Churchville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21050',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5372000',
                'longitude' => '-76.3530000',
                'city' => 'Forest Hill',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21014',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5372000',
                'longitude' => '-76.3530000',
                'city' => 'Bel Air',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21866',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '37.9961000',
                'longitude' => '-76.0323000',
                'city' => 'Tylerton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21824',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '37.9961000',
                'longitude' => '-76.0323000',
                'city' => 'Ewell',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21020',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4700000',
                'longitude' => '-76.8281000',
                'city' => 'Boring',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21071',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4700000',
                'longitude' => '-76.8281000',
                'city' => 'Glyndon',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21010',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4430000',
                'longitude' => '-76.3320000',
                'city' => 'Gunpowder',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21649',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1873000',
                'longitude' => '-75.8546000',
                'city' => 'Marydel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21651',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1873000',
                'longitude' => '-75.8546000',
                'city' => 'Millington',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21668',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1873000',
                'longitude' => '-75.8546000',
                'city' => 'Sudlersville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21607',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1873000',
                'longitude' => '-75.8546000',
                'city' => 'Barclay',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21104',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3260000',
                'longitude' => '-77.0250000',
                'city' => 'Marriottsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21723',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3260000',
                'longitude' => '-77.0250000',
                'city' => 'Cooksville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21673',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6585000',
                'longitude' => '-76.0641000',
                'city' => 'Trappe',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21133',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2171000',
                'longitude' => '-76.7189000',
                'city' => 'Randallstown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21632',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8861000',
                'longitude' => '-75.8272000',
                'city' => 'Federalsburg',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21639',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.8861000',
                'longitude' => '-75.8272000',
                'city' => 'Greensboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21636',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9754000',
                'longitude' => '-75.7958000',
                'city' => 'Goldsboro',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21640',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9754000',
                'longitude' => '-75.7958000',
                'city' => 'Henderson',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21153',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3680000',
                'longitude' => '-76.7196000',
                'city' => 'Stevenson',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21617',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.0416000',
                'longitude' => '-76.0684000',
                'city' => 'Centreville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20615',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.4757000',
                'longitude' => '-76.5449000',
                'city' => 'Broomes Island',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21287',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2934000',
                'longitude' => '-76.5919000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21051',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4678000',
                'longitude' => '-76.4312000',
                'city' => 'Fork',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21009',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4742000',
                'longitude' => '-76.3090000',
                'city' => 'Abingdon',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21843',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2934000',
                'longitude' => '-76.5919000',
                'city' => 'Ocean City',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21040',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4430000',
                'longitude' => '-76.3320000',
                'city' => 'Edgewood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21085',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4430000',
                'longitude' => '-76.3320000',
                'city' => 'Joppa',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21623',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1410000',
                'longitude' => '-75.9844000',
                'city' => 'Church Hill',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21084',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6057000',
                'longitude' => '-76.4793000',
                'city' => 'Jarrettsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21047',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6057000',
                'longitude' => '-76.4793000',
                'city' => 'Fallston',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21013',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6057000',
                'longitude' => '-76.4793000',
                'city' => 'Baldwin',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21156',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4678000',
                'longitude' => '-76.4312000',
                'city' => 'Upper Falls',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21087',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4678000',
                'longitude' => '-76.4312000',
                'city' => 'Kingsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21057',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4678000',
                'longitude' => '-76.4312000',
                'city' => 'Glen Arm',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21082',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4678000',
                'longitude' => '-76.4312000',
                'city' => 'Hydes',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21619',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9797000',
                'longitude' => '-76.3130000',
                'city' => 'Chester',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21871',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2046000',
                'longitude' => '-75.6936000',
                'city' => 'Westover',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21838',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.0379000',
                'longitude' => '-75.7663000',
                'city' => 'Marion Station',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21841',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1829000',
                'longitude' => '-75.3850000',
                'city' => 'Newark',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21863',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1829000',
                'longitude' => '-75.3850000',
                'city' => 'Snow Hill',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21851',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1829000',
                'longitude' => '-75.3850000',
                'city' => 'Pocomoke City',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21829',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1829000',
                'longitude' => '-75.3850000',
                'city' => 'Girdletree',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21864',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1829000',
                'longitude' => '-75.3850000',
                'city' => 'Stockton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21776',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5466000',
                'longitude' => '-77.1063000',
                'city' => 'New Windsor',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21661',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1352000',
                'longitude' => '-76.2291000',
                'city' => 'Rock Hall',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21902',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5984000',
                'longitude' => '-76.0850000',
                'city' => 'Perry Point',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21635',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3413000',
                'longitude' => '-75.8796000',
                'city' => 'Galena',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21867',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.2046000',
                'longitude' => '-75.6936000',
                'city' => 'Upper Fairmount',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21917',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.6967000',
                'longitude' => '-76.0596000',
                'city' => 'Colora',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21609',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7119000',
                'longitude' => '-75.9073000',
                'city' => 'Bethlehem',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21240',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.1923000',
                'longitude' => '-76.6835000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21252',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2912000',
                'longitude' => '-76.6084000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21647',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Mcdaniel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21663',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Saint Michaels',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21653',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Newcomb',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21652',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Neavitt',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21676',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Wittman',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21612',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Bozman',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21662',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Royal Oak',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21624',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7824000',
                'longitude' => '-76.2181000',
                'city' => 'Claiborne',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21875',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3642000',
                'longitude' => '-75.5981000',
                'city' => 'Delmar',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21821',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.1615000',
                'longitude' => '-75.9475000',
                'city' => 'Deal Island',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21106',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9147000',
                'longitude' => '-76.5522000',
                'city' => 'Mayo',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21638',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9792000',
                'longitude' => '-76.1689000',
                'city' => 'Grasonville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21679',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.9792000',
                'longitude' => '-76.1689000',
                'city' => 'Wye Mills',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21874',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3908000',
                'longitude' => '-75.4153000',
                'city' => 'Willards',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21850',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3908000',
                'longitude' => '-75.4153000',
                'city' => 'Pittsville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21852',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3908000',
                'longitude' => '-75.4153000',
                'city' => 'Powellville',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '20725',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.4948000',
                'longitude' => '-76.6462000',
                'city' => 'Laurel',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21865',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3071000',
                'longitude' => '-75.8872000',
                'city' => 'Tyaskin',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21856',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3071000',
                'longitude' => '-75.8872000',
                'city' => 'Quantico',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21840',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3071000',
                'longitude' => '-75.8872000',
                'city' => 'Nanticoke',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21814',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.3071000',
                'longitude' => '-75.8872000',
                'city' => 'Bivalve',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21861',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.5435000',
                'longitude' => '-75.7150000',
                'city' => 'Sharptown',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21665',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7139000',
                'longitude' => '-76.3378000',
                'city' => 'Sherwood',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21671',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.7139000',
                'longitude' => '-76.3378000',
                'city' => 'Tilghman',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21628',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2617000',
                'longitude' => '-75.8368000',
                'city' => 'Crumpton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21650',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.2617000',
                'longitude' => '-75.8368000',
                'city' => 'Massey',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21664',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '38.6360000',
                'longitude' => '-75.8612000',
                'city' => 'Secretary',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21235',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3238000',
                'longitude' => '-76.7307000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21241',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3238000',
                'longitude' => '-76.7307000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21290',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3238000',
                'longitude' => '-76.7307000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21817',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '37.9880000',
                'longitude' => '-75.8471000',
                'city' => 'Crisfield',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21922',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.5984000',
                'longitude' => '-76.0850000',
                'city' => 'Elkton',
                'full_state' => 'Maryland',
            ],
            [
                'zip' => '21251',
                'country_code' => 'US',
                'state' => 'MD',
                'latitude' => '39.3466000',
                'longitude' => '-76.5870000',
                'city' => 'Baltimore',
                'full_state' => 'Maryland',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
