<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MaineSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '4345',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2297000',
                'longitude' => '-69.7756000',
                'city' => 'Gardiner',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4046',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.3603000',
                'longitude' => '-70.4737000',
                'city' => 'Kennebunkport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4005',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4931000',
                'longitude' => '-70.4586000',
                'city' => 'Biddeford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4073',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4398000',
                'longitude' => '-70.7741000',
                'city' => 'Sanford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4011',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9132000',
                'longitude' => '-69.9634000',
                'city' => 'Brunswick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4102',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4106',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'South Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4240',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0941000',
                'longitude' => '-70.2141000',
                'city' => 'Lewiston',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4619',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1871000',
                'longitude' => '-67.2776000',
                'city' => 'Calais',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4351',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3132000',
                'longitude' => '-69.7757000',
                'city' => 'Manchester',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4348',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3132000',
                'longitude' => '-69.7757000',
                'city' => 'Jefferson',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4090',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.2713000',
                'longitude' => '-70.6013000',
                'city' => 'Wells',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4401',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8022000',
                'longitude' => '-68.7674000',
                'city' => 'Bangor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4915',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4256000',
                'longitude' => '-69.0067000',
                'city' => 'Belfast',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4101',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4038',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6778000',
                'longitude' => '-70.4398000',
                'city' => 'Gorham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4496',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6381000',
                'longitude' => '-68.8532000',
                'city' => 'Winterport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4438',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6381000',
                'longitude' => '-68.8532000',
                'city' => 'Frankfort',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4266',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3389000',
                'longitude' => '-70.2565000',
                'city' => 'North Turner',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4221',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3389000',
                'longitude' => '-70.2565000',
                'city' => 'Canton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4282',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3389000',
                'longitude' => '-70.2565000',
                'city' => 'Turner',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4841',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1035000',
                'longitude' => '-69.1074000',
                'city' => 'Rockland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4769',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.6815000',
                'longitude' => '-68.0110000',
                'city' => 'Presque Isle',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4103',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4112',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4931000',
                'longitude' => '-70.4586000',
                'city' => 'Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4856',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2014000',
                'longitude' => '-69.0716000',
                'city' => 'Rockport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4843',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2014000',
                'longitude' => '-69.0716000',
                'city' => 'Camden',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4743',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.2519000',
                'longitude' => '-68.5941000',
                'city' => 'Fort Kent',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4330',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Augusta',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4530',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Bath',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4094',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'West Kennebunk',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4932',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7081000',
                'longitude' => '-69.0460000',
                'city' => 'Dixmont',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4419',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7081000',
                'longitude' => '-69.0460000',
                'city' => 'Carmel',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4444',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7081000',
                'longitude' => '-69.0460000',
                'city' => 'Hampden',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4947',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0777000',
                'longitude' => '-70.2094000',
                'city' => 'Kingfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4849',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2014000',
                'longitude' => '-69.0716000',
                'city' => 'Lincolnville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4901',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5866000',
                'longitude' => '-69.5953000',
                'city' => 'Waterville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4944',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5866000',
                'longitude' => '-69.5953000',
                'city' => 'Hinckley',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4937',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5866000',
                'longitude' => '-69.5953000',
                'city' => 'Fairfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4982',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1438000',
                'longitude' => '-70.4432000',
                'city' => 'Stratton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4936',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1438000',
                'longitude' => '-70.4432000',
                'city' => 'Eustis',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4970',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1438000',
                'longitude' => '-70.4432000',
                'city' => 'Rangeley',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4945',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1438000',
                'longitude' => '-70.4432000',
                'city' => 'Jackman',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4216',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1438000',
                'longitude' => '-70.4432000',
                'city' => 'Andover',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4660',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2828000',
                'longitude' => '-68.3263000',
                'city' => 'Mount Desert',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4653',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2828000',
                'longitude' => '-68.3263000',
                'city' => 'Bass Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4625',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2828000',
                'longitude' => '-68.3263000',
                'city' => 'Cranberry Isles',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4674',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2828000',
                'longitude' => '-68.3263000',
                'city' => 'Seal Cove',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4612',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2828000',
                'longitude' => '-68.3263000',
                'city' => 'Bernard',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4646',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2828000',
                'longitude' => '-68.3263000',
                'city' => 'Islesford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4679',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2828000',
                'longitude' => '-68.3263000',
                'city' => 'Southwest Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4076',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5375000',
                'longitude' => '-70.7102000',
                'city' => 'Shapleigh',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4042',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5375000',
                'longitude' => '-70.7102000',
                'city' => 'Hollis Center',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4030',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5375000',
                'longitude' => '-70.7102000',
                'city' => 'East Waterboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4002',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5375000',
                'longitude' => '-70.7102000',
                'city' => 'Alfred',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4061',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5375000',
                'longitude' => '-70.7102000',
                'city' => 'North Waterboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4087',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5375000',
                'longitude' => '-70.7102000',
                'city' => 'Waterboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4429',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8022000',
                'longitude' => '-68.7674000',
                'city' => 'Holden',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4412',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8022000',
                'longitude' => '-68.7674000',
                'city' => 'Brewer',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3902',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.2713000',
                'longitude' => '-70.6013000',
                'city' => 'Cape Neddick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4630',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7125000',
                'longitude' => '-67.4621000',
                'city' => 'East Machias',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4655',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7125000',
                'longitude' => '-67.4621000',
                'city' => 'Machiasport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4686',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7125000',
                'longitude' => '-67.4621000',
                'city' => 'Wesley',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4654',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7125000',
                'longitude' => '-67.4621000',
                'city' => 'Machias',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4037',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0147000',
                'longitude' => '-70.9795000',
                'city' => 'Fryeburg',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4969',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7669000',
                'longitude' => '-69.2118000',
                'city' => 'Plymouth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4929',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7669000',
                'longitude' => '-69.2118000',
                'city' => 'Detroit',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4953',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7669000',
                'longitude' => '-69.2118000',
                'city' => 'Newport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4691',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6994000',
                'longitude' => '-67.2969000',
                'city' => 'Whiting',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4626',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6994000',
                'longitude' => '-67.2969000',
                'city' => 'Cutler',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4983',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9650000',
                'longitude' => '-70.1596000',
                'city' => 'Strong',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4609',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5404000',
                'longitude' => '-68.4206000',
                'city' => 'Bar Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4763',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.1294000',
                'longitude' => '-68.1652000',
                'city' => 'Oakfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4259',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1912000',
                'longitude' => '-69.9394000',
                'city' => 'Monmouth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4350',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1912000',
                'longitude' => '-69.9394000',
                'city' => 'Litchfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4434',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8078000',
                'longitude' => '-69.1012000',
                'city' => 'Etna',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4928',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0234000',
                'longitude' => '-69.2866000',
                'city' => 'Corinna',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4939',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0234000',
                'longitude' => '-69.2866000',
                'city' => 'Garland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4864',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1159000',
                'longitude' => '-69.2353000',
                'city' => 'Warren',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4662',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3040000',
                'longitude' => '-68.2827000',
                'city' => 'Northeast Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4675',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3040000',
                'longitude' => '-68.2827000',
                'city' => 'Seal Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4971',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9896000',
                'longitude' => '-69.3799000',
                'city' => 'Saint Albans',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4923',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9896000',
                'longitude' => '-69.3799000',
                'city' => 'Cambridge',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4942',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9896000',
                'longitude' => '-69.3799000',
                'city' => 'Harmony',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4930',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9896000',
                'longitude' => '-69.3799000',
                'city' => 'Dexter',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4443',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9896000',
                'longitude' => '-69.3799000',
                'city' => 'Guilford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4435',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9223000',
                'longitude' => '-69.2583000',
                'city' => 'Exeter',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4414',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.3086000',
                'longitude' => '-69.0325000',
                'city' => 'Brownville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4464',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.4589000',
                'longitude' => '-69.6032000',
                'city' => 'Monson',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4072',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4931000',
                'longitude' => '-70.4586000',
                'city' => 'Saco',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4006',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4931000',
                'longitude' => '-70.4586000',
                'city' => 'Biddeford Pool',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4422',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0015000',
                'longitude' => '-69.0222000',
                'city' => 'Charleston',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4427',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0015000',
                'longitude' => '-69.0222000',
                'city' => 'Corinth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4347',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2999000',
                'longitude' => '-69.7833000',
                'city' => 'Hallowell',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4333',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2999000',
                'longitude' => '-69.7833000',
                'city' => 'Augusta',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4672',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3870000',
                'longitude' => '-68.2124000',
                'city' => 'Salsbury Cove',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4644',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3870000',
                'longitude' => '-68.2124000',
                'city' => 'Hulls Cove',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4062',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5912000',
                'longitude' => '-70.3358000',
                'city' => 'Windham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4457',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.3609000',
                'longitude' => '-68.5058000',
                'city' => 'Lincoln',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4352',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4999000',
                'longitude' => '-69.9878000',
                'city' => 'Mount Vernon',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4360',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4999000',
                'longitude' => '-69.9878000',
                'city' => 'Vienna',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4349',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4999000',
                'longitude' => '-69.9878000',
                'city' => 'Kents Hill',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4963',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4999000',
                'longitude' => '-69.9878000',
                'city' => 'Oakland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4938',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4999000',
                'longitude' => '-69.9878000',
                'city' => 'Farmington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4488',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8896000',
                'longitude' => '-69.1448000',
                'city' => 'Stetson',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4756',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.3551000',
                'longitude' => '-68.3286000',
                'city' => 'Madawaska',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4254',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4751000',
                'longitude' => '-70.1858000',
                'city' => 'Livermore Falls',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4105',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Falmouth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4092',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Westbrook',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4083',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4426000',
                'longitude' => '-70.7789000',
                'city' => 'Springvale',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4750',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.9116000',
                'longitude' => '-67.8268000',
                'city' => 'Limestone',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4421',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3881000',
                'longitude' => '-68.7986000',
                'city' => 'Castine',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4617',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3881000',
                'longitude' => '-68.7986000',
                'city' => 'Brooksville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4476',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3881000',
                'longitude' => '-68.7986000',
                'city' => 'Penobscot',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4642',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3881000',
                'longitude' => '-68.7986000',
                'city' => 'Harborside',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4676',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3881000',
                'longitude' => '-68.7986000',
                'city' => 'Sedgwick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4472',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3881000',
                'longitude' => '-68.7986000',
                'city' => 'Orland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4410',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0532000',
                'longitude' => '-68.9312000',
                'city' => 'Bradford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4449',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0532000',
                'longitude' => '-68.9312000',
                'city' => 'Hudson',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4463',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0532000',
                'longitude' => '-68.9312000',
                'city' => 'Milo',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4736',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.9149000',
                'longitude' => '-67.9126000',
                'city' => 'Caribou',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4751',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.9149000',
                'longitude' => '-67.9126000',
                'city' => 'Limestone',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4104',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4021',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Cumberland Center',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4635',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1178000',
                'longitude' => '-68.3714000',
                'city' => 'Frenchboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4645',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0769000',
                'longitude' => '-68.6255000',
                'city' => 'Isle Au Haut',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4220',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2846000',
                'longitude' => '-70.3548000',
                'city' => 'Buckfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3905',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.1424000',
                'longitude' => '-70.6520000',
                'city' => 'Kittery Point',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4027',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.3007000',
                'longitude' => '-70.9666000',
                'city' => 'Lebanon',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4986',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4254000',
                'longitude' => '-69.1341000',
                'city' => 'Thorndike',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4941',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4254000',
                'longitude' => '-69.1341000',
                'city' => 'Freedom',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4952',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4254000',
                'longitude' => '-69.1341000',
                'city' => 'Morrill',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4973',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4254000',
                'longitude' => '-69.1341000',
                'city' => 'Searsmont',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4406',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1722000',
                'longitude' => '-69.3844000',
                'city' => 'Abbot',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4479',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1722000',
                'longitude' => '-69.3844000',
                'city' => 'Sangerville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4210',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0941000',
                'longitude' => '-70.2141000',
                'city' => 'Auburn',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4258',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1117000',
                'longitude' => '-70.3931000',
                'city' => 'Minot',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4256',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1117000',
                'longitude' => '-70.3931000',
                'city' => 'Mechanic Falls',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4650',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2245000',
                'longitude' => '-68.6794000',
                'city' => 'Little Deer Isle',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4627',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2245000',
                'longitude' => '-68.6794000',
                'city' => 'Deer Isle',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4681',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2245000',
                'longitude' => '-68.6794000',
                'city' => 'Stonington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4683',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2245000',
                'longitude' => '-68.6794000',
                'city' => 'Sunset',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4549',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8535000',
                'longitude' => '-69.6283000',
                'city' => 'Isle Of Springs',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4544',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8535000',
                'longitude' => '-69.6283000',
                'city' => 'East Boothbay',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3909',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.1424000',
                'longitude' => '-70.6520000',
                'city' => 'York',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4222',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0009000',
                'longitude' => '-70.0583000',
                'city' => 'Durham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4252',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0009000',
                'longitude' => '-70.0583000',
                'city' => 'Lisbon Falls',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4287',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0009000',
                'longitude' => '-70.0583000',
                'city' => 'Bowdoin',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4250',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0009000',
                'longitude' => '-70.0583000',
                'city' => 'Lisbon',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4086',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0009000',
                'longitude' => '-70.0583000',
                'city' => 'Topsham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4861',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0806000',
                'longitude' => '-69.1775000',
                'city' => 'Thomaston',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4563',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0806000',
                'longitude' => '-69.1775000',
                'city' => 'Cushing',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4858',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0806000',
                'longitude' => '-69.1775000',
                'city' => 'South Thomaston',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4547',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0806000',
                'longitude' => '-69.1775000',
                'city' => 'Friendship',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4276',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5457000',
                'longitude' => '-70.5459000',
                'city' => 'Rumford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4616',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3074000',
                'longitude' => '-68.6188000',
                'city' => 'Brooklin',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4673',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3074000',
                'longitude' => '-68.6188000',
                'city' => 'Sargentville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3907',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.2684000',
                'longitude' => '-70.5965000',
                'city' => 'Ogunquit',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4957',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6283000',
                'longitude' => '-69.8238000',
                'city' => 'Norridgewock',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4978',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6283000',
                'longitude' => '-69.8238000',
                'city' => 'Smithfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3910',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.1424000',
                'longitude' => '-70.6520000',
                'city' => 'York Beach',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3911',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.1424000',
                'longitude' => '-70.6520000',
                'city' => 'York Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4275',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5521000',
                'longitude' => '-70.5467000',
                'city' => 'Roxbury',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4237',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5521000',
                'longitude' => '-70.5467000',
                'city' => 'Hanover',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4257',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5521000',
                'longitude' => '-70.5467000',
                'city' => 'Mexico',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4777',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.8745000',
                'longitude' => '-68.3845000',
                'city' => 'Stacyville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4733',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.8745000',
                'longitude' => '-68.3845000',
                'city' => 'Benedicta',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4776',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.8745000',
                'longitude' => '-68.3845000',
                'city' => 'Sherman',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4851',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8622000',
                'longitude' => '-68.8900000',
                'city' => 'Matinicus',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4965',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8379000',
                'longitude' => '-69.2775000',
                'city' => 'Palmyra',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4548',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8039000',
                'longitude' => '-69.7527000',
                'city' => 'Georgetown',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4860',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9669000',
                'longitude' => '-69.2069000',
                'city' => 'Tenants Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4855',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9669000',
                'longitude' => '-69.2069000',
                'city' => 'Port Clyde',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4079',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9132000',
                'longitude' => '-69.9634000',
                'city' => 'Harpswell',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4629',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4144000',
                'longitude' => '-68.5873000',
                'city' => 'East Blue Hill',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4614',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4144000',
                'longitude' => '-68.5873000',
                'city' => 'Blue Hill',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4236',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1136000',
                'longitude' => '-70.1075000',
                'city' => 'Greene',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4280',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1136000',
                'longitude' => '-70.1075000',
                'city' => 'Sabattus',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4364',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3050000',
                'longitude' => '-69.9704000',
                'city' => 'Winthrop',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4578',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0015000',
                'longitude' => '-69.6659000',
                'city' => 'Wiscasset',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4219',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4072000',
                'longitude' => '-70.7935000',
                'city' => 'Bryant Pond',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3901',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.2382000',
                'longitude' => '-70.8017000',
                'city' => 'Berwick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3908',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.2382000',
                'longitude' => '-70.8017000',
                'city' => 'South Berwick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4562',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9091000',
                'longitude' => '-69.8185000',
                'city' => 'Phippsburg',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4579',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9091000',
                'longitude' => '-69.8185000',
                'city' => 'Woolwich',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4292',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3571000',
                'longitude' => '-70.3771000',
                'city' => 'Sumner',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4565',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7702000',
                'longitude' => '-69.8346000',
                'city' => 'Sebasco Estates',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4226',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6389000',
                'longitude' => '-70.7450000',
                'city' => 'East Andover',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4270',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2092000',
                'longitude' => '-70.5276000',
                'city' => 'Oxford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4281',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2092000',
                'longitude' => '-70.5276000',
                'city' => 'South Paris',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4468',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0373000',
                'longitude' => '-68.7274000',
                'city' => 'Old Town',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4343',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3226000',
                'longitude' => '-69.8905000',
                'city' => 'East Winthrop',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4074',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5877000',
                'longitude' => '-70.3399000',
                'city' => 'Scarborough',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4918',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5873000',
                'longitude' => '-69.8651000',
                'city' => 'Belgrade Lakes',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4774',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.1689000',
                'longitude' => '-68.8935000',
                'city' => 'Saint Francis',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4976',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7690000',
                'longitude' => '-69.7199000',
                'city' => 'Skowhegan',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4009',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Bridgton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4097',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'North Yarmouth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4664',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5299000',
                'longitude' => '-68.2284000',
                'city' => 'Sullivan',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4640',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5299000',
                'longitude' => '-68.2284000',
                'city' => 'Hancock',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4677',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5299000',
                'longitude' => '-68.2284000',
                'city' => 'Sorrento',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4607',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5299000',
                'longitude' => '-68.2284000',
                'city' => 'Gouldsboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4734',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.5143000',
                'longitude' => '-67.8674000',
                'city' => 'Blaine',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4735',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.5143000',
                'longitude' => '-67.8674000',
                'city' => 'Bridgewater',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4787',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.5143000',
                'longitude' => '-67.8674000',
                'city' => 'Westfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4758',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.5143000',
                'longitude' => '-67.8674000',
                'city' => 'Mars Hill',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4924',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6461000',
                'longitude' => '-69.5055000',
                'city' => 'Canaan',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4927',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6461000',
                'longitude' => '-69.5055000',
                'city' => 'Clinton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4668',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1534000',
                'longitude' => '-67.4181000',
                'city' => 'Princeton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4694',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1534000',
                'longitude' => '-67.4181000',
                'city' => 'Baileyville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4071',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8733000',
                'longitude' => '-70.4005000',
                'city' => 'Raymond',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4039',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8733000',
                'longitude' => '-70.4005000',
                'city' => 'Gray',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3903',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4398000',
                'longitude' => '-70.7741000',
                'city' => 'Eliot',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4648',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6627000',
                'longitude' => '-67.5593000',
                'city' => 'Jonesboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4732',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.6342000',
                'longitude' => '-68.4051000',
                'city' => 'Ashland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4775',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.6342000',
                'longitude' => '-68.4051000',
                'city' => 'Sheridan',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4768',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.6342000',
                'longitude' => '-68.4051000',
                'city' => 'Portage',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4764',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.6342000',
                'longitude' => '-68.4051000',
                'city' => 'Oxbow',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4910',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5336000',
                'longitude' => '-69.4400000',
                'city' => 'Albion',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3904',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.0735000',
                'longitude' => '-70.7636000',
                'city' => 'Kittery',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4268',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3132000',
                'longitude' => '-69.7757000',
                'city' => 'Norway',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4781',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.0423000',
                'longitude' => '-68.5881000',
                'city' => 'Wallagrass',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4739',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.0423000',
                'longitude' => '-68.5881000',
                'city' => 'Eagle Lake',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4989',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3952000',
                'longitude' => '-69.5670000',
                'city' => 'Vassalboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4358',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3952000',
                'longitude' => '-69.5670000',
                'city' => 'South China',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4363',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3952000',
                'longitude' => '-69.5670000',
                'city' => 'Windsor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4430',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6539000',
                'longitude' => '-68.7062000',
                'city' => 'East Millinocket',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4460',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6539000',
                'longitude' => '-68.7062000',
                'city' => 'Medway',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4424',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6588000',
                'longitude' => '-67.8668000',
                'city' => 'Danforth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4497',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6588000',
                'longitude' => '-67.8668000',
                'city' => 'Wytopitlock',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4471',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6588000',
                'longitude' => '-67.8668000',
                'city' => 'Orient',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4413',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6588000',
                'longitude' => '-67.8668000',
                'city' => 'Brookton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4010',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9690000',
                'longitude' => '-70.8014000',
                'city' => 'Brownfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4022',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9690000',
                'longitude' => '-70.8014000',
                'city' => 'Denmark',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4975',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5866000',
                'longitude' => '-69.5953000',
                'city' => 'Shawmut',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4657',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1871000',
                'longitude' => '-67.2776000',
                'city' => 'Meddybemps',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4671',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1871000',
                'longitude' => '-67.2776000',
                'city' => 'Robbinston',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4666',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1871000',
                'longitude' => '-67.2776000',
                'city' => 'Pembroke',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4766',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.7908000',
                'longitude' => '-68.1607000',
                'city' => 'Perham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4738',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.7908000',
                'longitude' => '-68.1607000',
                'city' => 'Crouseville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4786',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.7908000',
                'longitude' => '-68.1607000',
                'city' => 'Washburn',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3906',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4426000',
                'longitude' => '-70.7789000',
                'city' => 'North Berwick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4685',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5404000',
                'longitude' => '-68.4206000',
                'city' => 'Swans Island',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4605',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5404000',
                'longitude' => '-68.4206000',
                'city' => 'Ellsworth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4747',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.0103000',
                'longitude' => '-68.2687000',
                'city' => 'Island Falls',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4917',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5446000',
                'longitude' => '-69.7142000',
                'city' => 'Belgrade',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4043',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.3816000',
                'longitude' => '-70.5390000',
                'city' => 'Kennebunk',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4431',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5707000',
                'longitude' => '-68.7924000',
                'city' => 'East Orland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4981',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5707000',
                'longitude' => '-68.7924000',
                'city' => 'Stockton Springs',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4416',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5707000',
                'longitude' => '-68.7924000',
                'city' => 'Bucksport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4847',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2014000',
                'longitude' => '-69.0716000',
                'city' => 'Hope',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4742',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.7711000',
                'longitude' => '-67.8274000',
                'city' => 'Fort Fairfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4950',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7724000',
                'longitude' => '-69.7157000',
                'city' => 'Madison',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4001',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4975000',
                'longitude' => '-70.9612000',
                'city' => 'Acton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4684',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5404000',
                'longitude' => '-68.4206000',
                'city' => 'Surry',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4643',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6419000',
                'longitude' => '-67.7676000',
                'city' => 'Harrington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4623',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6419000',
                'longitude' => '-67.7676000',
                'city' => 'Columbia Falls',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4606',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6419000',
                'longitude' => '-67.7676000',
                'city' => 'Addison',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4622',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6419000',
                'longitude' => '-67.7676000',
                'city' => 'Cherryfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4785',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.1570000',
                'longitude' => '-67.9282000',
                'city' => 'Van Buren',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4862',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3132000',
                'longitude' => '-69.7757000',
                'city' => 'Union',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '3579',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7825000',
                'longitude' => '-71.1440000',
                'city' => 'Errol',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4967',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7845000',
                'longitude' => '-69.3777000',
                'city' => 'Pittsfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4922',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7845000',
                'longitude' => '-69.3777000',
                'city' => 'Burnham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4740',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.6404000',
                'longitude' => '-67.9136000',
                'city' => 'Easton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4611',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5582000',
                'longitude' => '-67.6250000',
                'city' => 'Beals',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4649',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5582000',
                'longitude' => '-67.6250000',
                'city' => 'Jonesport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4730',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.1228000',
                'longitude' => '-67.8367000',
                'city' => 'Houlton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4263',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3026000',
                'longitude' => '-70.1157000',
                'city' => 'Leeds',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4951',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6137000',
                'longitude' => '-69.0198000',
                'city' => 'Monroe',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4255',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2607000',
                'longitude' => '-70.6249000',
                'city' => 'Greenwood',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4217',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2607000',
                'longitude' => '-70.6249000',
                'city' => 'Bethel',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4765',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.0029000',
                'longitude' => '-68.4459000',
                'city' => 'Patten',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4551',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9952000',
                'longitude' => '-69.4492000',
                'city' => 'Bremen',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4564',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9952000',
                'longitude' => '-69.4492000',
                'city' => 'Round Pond',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4539',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9952000',
                'longitude' => '-69.4492000',
                'city' => 'Bristol',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4761',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.1228000',
                'longitude' => '-67.8367000',
                'city' => 'New Limerick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4261',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6949000',
                'longitude' => '-71.0133000',
                'city' => 'Newry',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4478',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6776000',
                'longitude' => '-69.7416000',
                'city' => 'Rockwood',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4760',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.2599000',
                'longitude' => '-67.8411000',
                'city' => 'Monticello',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4779',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.2809000',
                'longitude' => '-68.3766000',
                'city' => 'Sinclair',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4745',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.2809000',
                'longitude' => '-68.3766000',
                'city' => 'Frenchville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4772',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.2809000',
                'longitude' => '-68.3766000',
                'city' => 'Saint Agatha',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4680',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6273000',
                'longitude' => '-67.8121000',
                'city' => 'Steuben',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4658',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6273000',
                'longitude' => '-67.8121000',
                'city' => 'Milbridge',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4974',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4582000',
                'longitude' => '-68.9324000',
                'city' => 'Searsport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4353',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2210000',
                'longitude' => '-69.5851000',
                'city' => 'Whitefield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4341',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2210000',
                'longitude' => '-69.5851000',
                'city' => 'Coopers Mills',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4290',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5416000',
                'longitude' => '-70.4586000',
                'city' => 'Peru',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4224',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5416000',
                'longitude' => '-70.4586000',
                'city' => 'Dixfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4555',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0318000',
                'longitude' => '-69.5289000',
                'city' => 'Nobleboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4543',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0318000',
                'longitude' => '-69.5289000',
                'city' => 'Damariscotta',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4553',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0318000',
                'longitude' => '-69.5289000',
                'city' => 'Newcastle',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4573',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0318000',
                'longitude' => '-69.5289000',
                'city' => 'Walpole',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4481',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1837000',
                'longitude' => '-69.2240000',
                'city' => 'Sebec',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4426',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1837000',
                'longitude' => '-69.2240000',
                'city' => 'Dover Foxcroft',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4634',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5872000',
                'longitude' => '-68.2330000',
                'city' => 'Franklin',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4958',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9322000',
                'longitude' => '-69.9535000',
                'city' => 'North Anson',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4972',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4907000',
                'longitude' => '-68.8580000',
                'city' => 'Sandy Point',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4988',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5777000',
                'longitude' => '-69.2756000',
                'city' => 'Unity',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4473',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8834000',
                'longitude' => '-68.6737000',
                'city' => 'Orono',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4469',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8834000',
                'longitude' => '-68.6737000',
                'city' => 'Orono',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4344',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2229000',
                'longitude' => '-69.7759000',
                'city' => 'Farmingdale',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4346',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2229000',
                'longitude' => '-69.7759000',
                'city' => 'Randolph',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4267',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1127000',
                'longitude' => '-70.6746000',
                'city' => 'North Waterford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4088',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1127000',
                'longitude' => '-70.6746000',
                'city' => 'Waterford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4040',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1127000',
                'longitude' => '-70.6746000',
                'city' => 'Harrison',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4408',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8610000',
                'longitude' => '-68.3236000',
                'city' => 'Aurora',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4285',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7017000',
                'longitude' => '-70.4182000',
                'city' => 'Weld',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4535',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0812000',
                'longitude' => '-69.5613000',
                'city' => 'Alna',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4949',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3875000',
                'longitude' => '-69.2977000',
                'city' => 'Liberty',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4538',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3132000',
                'longitude' => '-69.7757000',
                'city' => 'Boothbay Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4854',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1065000',
                'longitude' => '-69.1122000',
                'city' => 'Owls Head',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4852',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1065000',
                'longitude' => '-69.1122000',
                'city' => 'Monhegan',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4859',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1065000',
                'longitude' => '-69.1122000',
                'city' => 'Spruce Head',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4047',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8041000',
                'longitude' => '-70.8119000',
                'city' => 'Parsonsfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4041',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8041000',
                'longitude' => '-70.8119000',
                'city' => 'Hiram',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4091',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8041000',
                'longitude' => '-70.8119000',
                'city' => 'West Baldwin',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4068',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8041000',
                'longitude' => '-70.8119000',
                'city' => 'Porter',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4020',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8041000',
                'longitude' => '-70.8119000',
                'city' => 'Cornish',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4015',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9783000',
                'longitude' => '-70.5174000',
                'city' => 'Casco',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4954',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9250000',
                'longitude' => '-70.0217000',
                'city' => 'New Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4961',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9250000',
                'longitude' => '-70.0217000',
                'city' => 'New Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4537',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8604000',
                'longitude' => '-69.6200000',
                'city' => 'Boothbay',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4576',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8604000',
                'longitude' => '-69.6200000',
                'city' => 'Southport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4556',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8604000',
                'longitude' => '-69.6200000',
                'city' => 'Edgecomb',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4575',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8604000',
                'longitude' => '-69.6200000',
                'city' => 'West Boothbay Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4095',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4426000',
                'longitude' => '-70.7789000',
                'city' => 'West Newfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4056',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.4426000',
                'longitude' => '-70.7789000',
                'city' => 'Newfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4049',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7453000',
                'longitude' => '-70.6826000',
                'city' => 'Limington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4966',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8257000',
                'longitude' => '-70.3366000',
                'city' => 'Phillips',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4093',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7381000',
                'longitude' => '-70.5509000',
                'city' => 'Buxton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4085',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7381000',
                'longitude' => '-70.5509000',
                'city' => 'Steep Falls',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4084',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7381000',
                'longitude' => '-70.5509000',
                'city' => 'Standish',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4979',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9507000',
                'longitude' => '-69.8544000',
                'city' => 'Solon',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4568',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8577000',
                'longitude' => '-69.5566000',
                'city' => 'South Bristol',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4225',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5877000',
                'longitude' => '-70.2354000',
                'city' => 'Dryden',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4294',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5877000',
                'longitude' => '-70.2354000',
                'city' => 'Wilton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4234',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5877000',
                'longitude' => '-70.2354000',
                'city' => 'East Wilton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4262',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5877000',
                'longitude' => '-70.2354000',
                'city' => 'North Jay',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4239',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5877000',
                'longitude' => '-70.2354000',
                'city' => 'Jay',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4054',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.2684000',
                'longitude' => '-70.5965000',
                'city' => 'Moody',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4956',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8066000',
                'longitude' => '-70.1232000',
                'city' => 'New Vineyard',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4912',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9257000',
                'longitude' => '-69.6723000',
                'city' => 'Athens',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4260',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8872000',
                'longitude' => '-70.3344000',
                'city' => 'New Gloucester',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4985',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.3422000',
                'longitude' => '-69.9709000',
                'city' => 'West Forks',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4008',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0132000',
                'longitude' => '-69.9023000',
                'city' => 'Bowdoinham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4925',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0587000',
                'longitude' => '-69.8753000',
                'city' => 'Caratunk',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4920',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.0587000',
                'longitude' => '-69.8753000',
                'city' => 'Bingham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4271',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3258000',
                'longitude' => '-70.5646000',
                'city' => 'Paris',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4289',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3258000',
                'longitude' => '-70.5646000',
                'city' => 'West Paris',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4024',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7930000',
                'longitude' => '-70.6435000',
                'city' => 'East Baldwin',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4554',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8706000',
                'longitude' => '-69.4994000',
                'city' => 'New Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4558',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8706000',
                'longitude' => '-69.4994000',
                'city' => 'Pemaquid',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4541',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8706000',
                'longitude' => '-69.4994000',
                'city' => 'Chamberlain',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4284',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3855000',
                'longitude' => '-69.9658000',
                'city' => 'Wayne',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4355',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3855000',
                'longitude' => '-69.9658000',
                'city' => 'Readfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4069',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8963000',
                'longitude' => '-70.1908000',
                'city' => 'Pownal',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4055',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.9695000',
                'longitude' => '-70.6023000',
                'city' => 'Naples',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4485',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.4614000',
                'longitude' => '-69.6173000',
                'city' => 'Shirley Mills',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4441',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.4614000',
                'longitude' => '-69.6173000',
                'city' => 'Greenville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4442',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.4614000',
                'longitude' => '-69.6173000',
                'city' => 'Greenville Junction',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4911',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8014000',
                'longitude' => '-69.8840000',
                'city' => 'Anson',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4051',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1209000',
                'longitude' => '-70.9797000',
                'city' => 'Lovell',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4921',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5478000',
                'longitude' => '-69.1185000',
                'city' => 'Brooks',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4462',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.6539000',
                'longitude' => '-68.7062000',
                'city' => 'Millinocket',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4628',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9485000',
                'longitude' => '-67.1804000',
                'city' => 'Dennysville',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4667',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9485000',
                'longitude' => '-67.1804000',
                'city' => 'Perry',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4773',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.3581000',
                'longitude' => '-68.3336000',
                'city' => 'Saint David',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4475',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2425000',
                'longitude' => '-68.6484000',
                'city' => 'Passadumkeag',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4417',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2425000',
                'longitude' => '-68.6484000',
                'city' => 'Burlington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4453',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2425000',
                'longitude' => '-68.6484000',
                'city' => 'Lagrange',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4493',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2425000',
                'longitude' => '-68.6484000',
                'city' => 'West Enfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4448',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2425000',
                'longitude' => '-68.6484000',
                'city' => 'Howland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4652',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8500000',
                'longitude' => '-66.9953000',
                'city' => 'Lubec',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4848',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2922000',
                'longitude' => '-68.9260000',
                'city' => 'Islesboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4495',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.5112000',
                'longitude' => '-68.3559000',
                'city' => 'Winn',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4459',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.5112000',
                'longitude' => '-68.3559000',
                'city' => 'Mattawamkeag',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4357',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0898000',
                'longitude' => '-69.8022000',
                'city' => 'Richmond',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4342',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0898000',
                'longitude' => '-69.8022000',
                'city' => 'Dresden',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4455',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.3578000',
                'longitude' => '-68.2847000',
                'city' => 'Lee',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4487',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.3578000',
                'longitude' => '-68.2847000',
                'city' => 'Springfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4107',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6381000',
                'longitude' => '-70.2560000',
                'city' => 'Cape Elizabeth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4241',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0941000',
                'longitude' => '-70.2141000',
                'city' => 'Lewiston',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4780',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.1294000',
                'longitude' => '-68.1652000',
                'city' => 'Smyrna Mills',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4757',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.6815000',
                'longitude' => '-68.0110000',
                'city' => 'Mapleton',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4850',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2955000',
                'longitude' => '-69.1079000',
                'city' => 'Lincolnville Center',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4451',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.5467000',
                'longitude' => '-68.1974000',
                'city' => 'Kingman',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4050',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6548000',
                'longitude' => '-70.1950000',
                'city' => 'Long Island',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4109',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6548000',
                'longitude' => '-70.1950000',
                'city' => 'Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4019',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6548000',
                'longitude' => '-70.1950000',
                'city' => 'Cliff Island',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4108',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6548000',
                'longitude' => '-70.1950000',
                'city' => 'Peaks Island',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4122',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6537000',
                'longitude' => '-70.2624000',
                'city' => 'Portland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4984',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6582000',
                'longitude' => '-70.1338000',
                'city' => 'Temple',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4955',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6582000',
                'longitude' => '-70.1338000',
                'city' => 'New Sharon',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4110',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7232000',
                'longitude' => '-70.2301000',
                'city' => 'Cumberland Foreside',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4029',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8574000',
                'longitude' => '-70.6425000',
                'city' => 'Sebago',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4454',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.5928000',
                'longitude' => '-67.3298000',
                'city' => 'Lambert Lake',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4491',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.5928000',
                'longitude' => '-67.3298000',
                'city' => 'Vanceboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4572',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0952000',
                'longitude' => '-69.3781000',
                'city' => 'Waldoboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4048',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6893000',
                'longitude' => '-70.7972000',
                'city' => 'Limerick',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4637',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2201000',
                'longitude' => '-67.5736000',
                'city' => 'Grand Lake Stream',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4490',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2201000',
                'longitude' => '-67.5736000',
                'city' => 'Topsfield',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4492',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.2201000',
                'longitude' => '-67.5736000',
                'city' => 'Waite',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4474',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7256000',
                'longitude' => '-68.8291000',
                'city' => 'Orrington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4418',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.1228000',
                'longitude' => '-68.6115000',
                'city' => 'Greenbush',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4411',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9326000',
                'longitude' => '-68.6459000',
                'city' => 'Bradley',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4461',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9326000',
                'longitude' => '-68.6459000',
                'city' => 'Milford',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4096',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7926000',
                'longitude' => '-70.2553000',
                'city' => 'Yarmouth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4066',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7413000',
                'longitude' => '-69.9935000',
                'city' => 'Orrs Island',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4003',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7413000',
                'longitude' => '-69.9935000',
                'city' => 'Bailey Island',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4286',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4029000',
                'longitude' => '-70.8569000',
                'city' => 'West Bethel',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4428',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.7352000',
                'longitude' => '-68.6288000',
                'city' => 'Eddington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4574',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2683000',
                'longitude' => '-69.3675000',
                'city' => 'Washington',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4017',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.7997000',
                'longitude' => '-70.1895000',
                'city' => 'Chebeague Island',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4631',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9042000',
                'longitude' => '-66.9939000',
                'city' => 'Eastport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4962',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.5527000',
                'longitude' => '-69.6282000',
                'city' => 'North Vassalboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4863',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0534000',
                'longitude' => '-68.8403000',
                'city' => 'Vinalhaven',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4964',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9704000',
                'longitude' => '-70.6436000',
                'city' => 'Oquossoc',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4032',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8563000',
                'longitude' => '-70.1059000',
                'city' => 'Freeport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4853',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1284000',
                'longitude' => '-68.8744000',
                'city' => 'North Haven',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4078',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.8563000',
                'longitude' => '-70.1059000',
                'city' => 'South Freeport',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4456',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9061000',
                'longitude' => '-68.9270000',
                'city' => 'Levant',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4450',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.9061000',
                'longitude' => '-68.9270000',
                'city' => 'Kenduskeag',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4746',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '47.3053000',
                'longitude' => '-68.1532000',
                'city' => 'Grand Isle',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4783',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.9422000',
                'longitude' => '-68.1284000',
                'city' => 'Stockholm',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4762',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '46.9422000',
                'longitude' => '-68.1284000',
                'city' => 'New Sweden',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4253',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4751000',
                'longitude' => '-70.1858000',
                'city' => 'Livermore',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4228',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4751000',
                'longitude' => '-70.1858000',
                'city' => 'East Livermore',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4935',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4482000',
                'longitude' => '-69.6035000',
                'city' => 'East Vassalboro',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4926',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4482000',
                'longitude' => '-69.6035000',
                'city' => 'China Village',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4016',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1469000',
                'longitude' => '-70.8832000',
                'city' => 'Center Lovell',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4231',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2438000',
                'longitude' => '-70.8775000',
                'city' => 'Stoneham',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4004',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.6133000',
                'longitude' => '-70.5399000',
                'city' => 'Bar Mills',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4265',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.2403000',
                'longitude' => '-70.0313000',
                'city' => 'North Monmouth',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4064',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5175000',
                'longitude' => '-70.3808000',
                'city' => 'Old Orchard Beach',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4063',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.5175000',
                'longitude' => '-70.3808000',
                'city' => 'Ocean Park',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4943',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.8837000',
                'longitude' => '-69.4428000',
                'city' => 'Hartland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4987',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.6130000',
                'longitude' => '-69.3339000',
                'city' => 'Troy',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4613',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3925000',
                'longitude' => '-68.0856000',
                'city' => 'Birch Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4669',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3925000',
                'longitude' => '-68.0856000',
                'city' => 'Prospect Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4624',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3925000',
                'longitude' => '-68.0856000',
                'city' => 'Corea',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4693',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.3925000',
                'longitude' => '-68.0856000',
                'city' => 'Winter Harbor',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4415',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '45.3086000',
                'longitude' => '-69.0325000',
                'city' => 'Brownville Junction',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4238',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1918000',
                'longitude' => '-70.3982000',
                'city' => 'Hebron',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4288',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.1918000',
                'longitude' => '-70.3982000',
                'city' => 'West Minot',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4014',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '43.3603000',
                'longitude' => '-70.4737000',
                'city' => 'Cape Porpoise',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4354',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.4071000',
                'longitude' => '-69.4681000',
                'city' => 'Palermo',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4291',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0537000',
                'longitude' => '-70.3952000',
                'city' => 'West Poland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4230',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0537000',
                'longitude' => '-70.3952000',
                'city' => 'East Poland',
                'full_state' => 'Maine',
            ],
            [
                'zip' => '4274',
                'country_code' => 'US',
                'state' => 'ME',
                'latitude' => '44.0537000',
                'longitude' => '-70.3952000',
                'city' => 'Poland',
                'full_state' => 'Maine',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
