<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LouisianaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '70814',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4729000',
                'longitude' => '-91.0783000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70836',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4454000',
                'longitude' => '-91.1107000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70825',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4454000',
                'longitude' => '-91.1107000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70806',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70802',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70723',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0152000',
                'longitude' => '-90.8288000',
                'city' => 'Convent',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70725',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Darrow',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70341',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Belle Rose',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70711',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5010000',
                'longitude' => '-90.5816000',
                'city' => 'Albany',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70744',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5010000',
                'longitude' => '-90.5816000',
                'city' => 'Holden',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70403',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5010000',
                'longitude' => '-90.5816000',
                'city' => 'Hammond',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70401',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5010000',
                'longitude' => '-90.5816000',
                'city' => 'Hammond',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70466',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5010000',
                'longitude' => '-90.5816000',
                'city' => 'Tickfaw',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70443',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5010000',
                'longitude' => '-90.5816000',
                'city' => 'Independence',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70808',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3978000',
                'longitude' => '-91.1071000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70816',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3978000',
                'longitude' => '-91.1071000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70801',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3978000',
                'longitude' => '-91.1071000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70805',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3978000',
                'longitude' => '-91.1071000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70810',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3978000',
                'longitude' => '-91.1071000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70809',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3978000',
                'longitude' => '-91.1071000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70815',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3978000',
                'longitude' => '-91.1071000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70441',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8353000',
                'longitude' => '-90.6689000',
                'city' => 'Greensburg',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70422',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8353000',
                'longitude' => '-90.6689000',
                'city' => 'Amite',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70819',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4595000',
                'longitude' => '-91.0093000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70804',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4454000',
                'longitude' => '-91.1107000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70760',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7022000',
                'longitude' => '-91.4353000',
                'city' => 'New Roads',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70767',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Port Allen',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70706',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4852000',
                'longitude' => '-90.9602000',
                'city' => 'Denham Springs',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70722',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8673000',
                'longitude' => '-91.0167000',
                'city' => 'Clinton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70783',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7736000',
                'longitude' => '-91.3851000',
                'city' => 'Ventress',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70714',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3666000',
                'longitude' => '-91.1182000',
                'city' => 'Baker',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70778',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2249000',
                'longitude' => '-90.9256000',
                'city' => 'Sorrento',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70734',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2249000',
                'longitude' => '-90.9256000',
                'city' => 'Geismar',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70776',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2591000',
                'longitude' => '-91.1060000',
                'city' => 'Saint Gabriel',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70071',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0439000',
                'longitude' => '-90.7022000',
                'city' => 'Lutcher',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70755',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5652000',
                'longitude' => '-91.5499000',
                'city' => 'Livonia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70739',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5457000',
                'longitude' => '-91.0564000',
                'city' => 'Greenwell Springs',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70791',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5457000',
                'longitude' => '-91.0564000',
                'city' => 'Zachary',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70770',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5457000',
                'longitude' => '-91.0564000',
                'city' => 'Pride',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70818',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5457000',
                'longitude' => '-91.0564000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70049',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9980000',
                'longitude' => '-90.7272000',
                'city' => 'Edgard',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70090',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9980000',
                'longitude' => '-90.7272000',
                'city' => 'Vacherie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70086',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9980000',
                'longitude' => '-90.7272000',
                'city' => 'Saint James',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70820',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70462',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4311000',
                'longitude' => '-90.5495000',
                'city' => 'Springfield',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70754',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4311000',
                'longitude' => '-90.5495000',
                'city' => 'Livingston',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70454',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4311000',
                'longitude' => '-90.5495000',
                'city' => 'Ponchatoula',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70827',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4070000',
                'longitude' => '-91.0553000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70764',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2816000',
                'longitude' => '-91.2341000',
                'city' => 'Plaquemine',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70769',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2591000',
                'longitude' => '-90.9831000',
                'city' => 'Prairieville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70737',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2591000',
                'longitude' => '-90.9831000',
                'city' => 'Gonzales',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70817',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70721',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2591000',
                'longitude' => '-91.1060000',
                'city' => 'Carville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70780',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2591000',
                'longitude' => '-91.1060000',
                'city' => 'Sunshine',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70811',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70775',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Saint Francisville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70807',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4923000',
                'longitude' => '-91.1498000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70812',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4923000',
                'longitude' => '-91.1498000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70765',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2816000',
                'longitude' => '-91.2341000',
                'city' => 'Plaquemine',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70803',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70733',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3013000',
                'longitude' => '-90.8022000',
                'city' => 'French Settlement',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70130',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70456',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8353000',
                'longitude' => '-90.6689000',
                'city' => 'Roseland',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70346',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0953000',
                'longitude' => '-90.9957000',
                'city' => 'Donaldsonville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70753',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8649000',
                'longitude' => '-91.6707000',
                'city' => 'Lettsworth',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70747',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8649000',
                'longitude' => '-91.6707000',
                'city' => 'Innis',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70715',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8649000',
                'longitude' => '-91.6707000',
                'city' => 'Batchelor',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70788',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.1673000',
                'longitude' => '-91.1437000',
                'city' => 'White Castle',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70774',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2249000',
                'longitude' => '-90.9256000',
                'city' => 'Saint Amant',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71353',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0439000',
                'longitude' => '-90.7022000',
                'city' => 'Melville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70757',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4851000',
                'longitude' => '-91.5167000',
                'city' => 'Maringouin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70749',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6019000',
                'longitude' => '-91.3779000',
                'city' => 'Jarreau',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70762',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6019000',
                'longitude' => '-91.3779000',
                'city' => 'Oscar',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70752',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6019000',
                'longitude' => '-91.3779000',
                'city' => 'Lakeland',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70773',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6019000',
                'longitude' => '-91.3779000',
                'city' => 'Rougon',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70736',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6019000',
                'longitude' => '-91.3779000',
                'city' => 'Glynn',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70729',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6019000',
                'longitude' => '-91.3779000',
                'city' => 'Erwinville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70789',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9194000',
                'longitude' => '-91.1179000',
                'city' => 'Wilson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70730',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9194000',
                'longitude' => '-91.1179000',
                'city' => 'Ethel',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70761',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9194000',
                'longitude' => '-91.1179000',
                'city' => 'Norwood',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70748',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9194000',
                'longitude' => '-91.1179000',
                'city' => 'Jackson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70732',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5652000',
                'longitude' => '-91.5499000',
                'city' => 'Fordoche',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70756',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5652000',
                'longitude' => '-91.5499000',
                'city' => 'Lottie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70772',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4408000',
                'longitude' => '-91.4585000',
                'city' => 'Rosedale',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70740',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4408000',
                'longitude' => '-91.4585000',
                'city' => 'Grosse Tete',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70777',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6495000',
                'longitude' => '-91.1586000',
                'city' => 'Slaughter',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70782',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9319000',
                'longitude' => '-91.5467000',
                'city' => 'Tunica',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70726',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4583000',
                'longitude' => '-90.9572000',
                'city' => 'Denham Springs',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70785',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4583000',
                'longitude' => '-90.9572000',
                'city' => 'Walker',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70449',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.1824000',
                'longitude' => '-90.8609000',
                'city' => 'Maurepas',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70710',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2878000',
                'longitude' => '-91.2366000',
                'city' => 'Addis',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70759',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7342000',
                'longitude' => '-91.5882000',
                'city' => 'Morganza',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70707',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2249000',
                'longitude' => '-90.9256000',
                'city' => 'Gonzales',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70719',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3847000',
                'longitude' => '-91.2605000',
                'city' => 'Brusly',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70813',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5582000',
                'longitude' => '-91.1728000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70047',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Destrehan',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70453',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6762000',
                'longitude' => '-90.6443000',
                'city' => 'Pine Grove',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70052',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0419000',
                'longitude' => '-90.6975000',
                'city' => 'Gramercy',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70743',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0419000',
                'longitude' => '-90.6975000',
                'city' => 'Hester',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70763',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0419000',
                'longitude' => '-90.6975000',
                'city' => 'Paulina',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70821',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4503000',
                'longitude' => '-91.1842000',
                'city' => 'Baton Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71303',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3067000',
                'longitude' => '-92.4520000',
                'city' => 'Alexandria',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71302',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3067000',
                'longitude' => '-92.4520000',
                'city' => 'Alexandria',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71275',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5239000',
                'longitude' => '-92.6453000',
                'city' => 'Simsboro',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71245',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5239000',
                'longitude' => '-92.6453000',
                'city' => 'Grambling',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71103',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5070000',
                'longitude' => '-93.7541000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71104',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5070000',
                'longitude' => '-93.7541000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71483',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9229000',
                'longitude' => '-92.6333000',
                'city' => 'Winnfield',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71115',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71105',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71111',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Bossier City',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71118',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71120',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71101',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71006',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Benton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71033',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Greenwood',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71129',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71108',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71112',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Bossier City',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71135',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71106',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71456',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7608000',
                'longitude' => '-93.0904000',
                'city' => 'Natchez',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71457',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7608000',
                'longitude' => '-93.0904000',
                'city' => 'Natchitoches',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71463',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8092000',
                'longitude' => '-92.6603000',
                'city' => 'Oakdale',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71375',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8070000',
                'longitude' => '-91.3853000',
                'city' => 'Waterproof',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71107',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5113000',
                'longitude' => '-93.7519000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71069',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9744000',
                'longitude' => '-93.9983000',
                'city' => 'Rodessa',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71082',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9744000',
                'longitude' => '-93.9983000',
                'city' => 'Vivian',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71044',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9744000',
                'longitude' => '-93.9983000',
                'city' => 'Ida',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71040',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7904000',
                'longitude' => '-93.0579000',
                'city' => 'Homer',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70546',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7669000',
                'longitude' => '-93.0931000',
                'city' => 'Jennings',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71346',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0904000',
                'longitude' => '-92.4075000',
                'city' => 'Lecompte',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71270',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5239000',
                'longitude' => '-92.6453000',
                'city' => 'Ruston',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71432',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7644000',
                'longitude' => '-92.3863000',
                'city' => 'Georgetown',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71203',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5015000',
                'longitude' => '-92.1086000',
                'city' => 'Monroe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71202',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5015000',
                'longitude' => '-92.1086000',
                'city' => 'Monroe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71446',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7669000',
                'longitude' => '-93.0931000',
                'city' => 'Leesville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71220',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7733000',
                'longitude' => '-91.9188000',
                'city' => 'Bastrop',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71323',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1267000',
                'longitude' => '-92.0654000',
                'city' => 'Center Point',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71328',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1267000',
                'longitude' => '-92.0654000',
                'city' => 'Deville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71331',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1267000',
                'longitude' => '-92.0654000',
                'city' => 'Effie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71360',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1267000',
                'longitude' => '-92.0654000',
                'city' => 'Pineville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71351',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1267000',
                'longitude' => '-92.0654000',
                'city' => 'Marksville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71235',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5304000',
                'longitude' => '-92.6359000',
                'city' => 'Dubach',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71272',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5304000',
                'longitude' => '-92.6359000',
                'city' => 'Ruston',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71264',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6254000',
                'longitude' => '-91.7779000',
                'city' => 'Oak Ridge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71473',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1095000',
                'longitude' => '-92.3443000',
                'city' => 'Sikes',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71226',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1095000',
                'longitude' => '-92.3443000',
                'city' => 'Chatham',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71435',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1095000',
                'longitude' => '-92.3443000',
                'city' => 'Grayson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71219',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3081000',
                'longitude' => '-91.7788000',
                'city' => 'Baskin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71269',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3081000',
                'longitude' => '-91.7788000',
                'city' => 'Rayville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71418',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3081000',
                'longitude' => '-91.7788000',
                'city' => 'Columbia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71218',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3081000',
                'longitude' => '-91.7788000',
                'city' => 'Archibald',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71259',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3081000',
                'longitude' => '-91.7788000',
                'city' => 'Mangham',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71238',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3095000',
                'longitude' => '-92.4512000',
                'city' => 'Eros',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71292',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3095000',
                'longitude' => '-92.4512000',
                'city' => 'West Monroe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71450',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5681000',
                'longitude' => '-93.4843000',
                'city' => 'Marthaville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71350',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1267000',
                'longitude' => '-92.0654000',
                'city' => 'Mansura',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71406',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5681000',
                'longitude' => '-93.4843000',
                'city' => 'Belmont',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71486',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5681000',
                'longitude' => '-93.4843000',
                'city' => 'Zwolle',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71469',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5681000',
                'longitude' => '-93.4843000',
                'city' => 'Robeline',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71449',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5681000',
                'longitude' => '-93.4843000',
                'city' => 'Many',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71003',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6506000',
                'longitude' => '-93.0247000',
                'city' => 'Athens',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71268',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.2414000',
                'longitude' => '-92.7192000',
                'city' => 'Quitman',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71247',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.2414000',
                'longitude' => '-92.7192000',
                'city' => 'Hodge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71070',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.2414000',
                'longitude' => '-92.7192000',
                'city' => 'Saline',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71251',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.2414000',
                'longitude' => '-92.7192000',
                'city' => 'Jonesboro',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71221',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7733000',
                'longitude' => '-91.9188000',
                'city' => 'Bastrop',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71004',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6905000',
                'longitude' => '-93.7412000',
                'city' => 'Belcher',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71001',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5484000',
                'longitude' => '-92.9180000',
                'city' => 'Arcadia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71008',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5484000',
                'longitude' => '-92.9180000',
                'city' => 'Bienville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71055',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6187000',
                'longitude' => '-93.2855000',
                'city' => 'Minden',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71038',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9657000',
                'longitude' => '-93.1441000',
                'city' => 'Haynesville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71322',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9600000',
                'longitude' => '-92.1833000',
                'city' => 'Bunkie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71282',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5077000',
                'longitude' => '-90.9913000',
                'city' => 'Tallulah',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71417',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3830000',
                'longitude' => '-92.6705000',
                'city' => 'Colfax',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71447',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3830000',
                'longitude' => '-92.6705000',
                'city' => 'Lena',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71325',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0087000',
                'longitude' => '-92.2923000',
                'city' => 'Cheneyville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71295',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1562000',
                'longitude' => '-91.7184000',
                'city' => 'Winnsboro',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71222',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8032000',
                'longitude' => '-92.6570000',
                'city' => 'Bernice',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71256',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8032000',
                'longitude' => '-92.6570000',
                'city' => 'Lillie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71043',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8925000',
                'longitude' => '-93.8741000',
                'city' => 'Hosston',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70508',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9229000',
                'longitude' => '-92.6333000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71260',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9000000',
                'longitude' => '-92.2396000',
                'city' => 'Marion',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71241',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7731000',
                'longitude' => '-92.4100000',
                'city' => 'Farmerville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71064',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8253000',
                'longitude' => '-93.8435000',
                'city' => 'Plain Dealing',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71029',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8253000',
                'longitude' => '-93.8435000',
                'city' => 'Gilliam',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71073',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6187000',
                'longitude' => '-93.2855000',
                'city' => 'Sibley',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71024',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6187000',
                'longitude' => '-93.2855000',
                'city' => 'Dubberly',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71366',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9257000',
                'longitude' => '-91.2369000',
                'city' => 'Saint Joseph',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71433',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0825000',
                'longitude' => '-92.7340000',
                'city' => 'Glenmora',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71438',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0825000',
                'longitude' => '-92.7340000',
                'city' => 'Hineston',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71060',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5849000',
                'longitude' => '-93.8908000',
                'city' => 'Mooringsport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71009',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5849000',
                'longitude' => '-93.8908000',
                'city' => 'Blanchard',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71467',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5235000',
                'longitude' => '-92.4080000',
                'city' => 'Pollock',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71342',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.6824000',
                'longitude' => '-92.1285000',
                'city' => 'Jena',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71201',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5035000',
                'longitude' => '-92.1135000',
                'city' => 'Monroe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71291',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5035000',
                'longitude' => '-92.1135000',
                'city' => 'West Monroe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71018',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9078000',
                'longitude' => '-93.6995000',
                'city' => 'Cotton Valley',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70517',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7669000',
                'longitude' => '-93.0931000',
                'city' => 'Breaux Bridge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71373',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5680000',
                'longitude' => '-91.4266000',
                'city' => 'Vidalia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71343',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.6238000',
                'longitude' => '-91.8169000',
                'city' => 'Jonesville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71333',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9515000',
                'longitude' => '-92.1877000',
                'city' => 'Evergreen',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71356',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9515000',
                'longitude' => '-92.1877000',
                'city' => 'Morrow',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71207',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5015000',
                'longitude' => '-92.1086000',
                'city' => 'Monroe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71048',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7968000',
                'longitude' => '-92.8635000',
                'city' => 'Lisbon',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70656',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9329000',
                'longitude' => '-92.9346000',
                'city' => 'Pitkin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71423',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5759000',
                'longitude' => '-92.5276000',
                'city' => 'Dry Prong',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71039',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6145000',
                'longitude' => '-93.2877000',
                'city' => 'Heflin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71454',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.6681000',
                'longitude' => '-92.8915000',
                'city' => 'Montgomery',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71416',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7669000',
                'longitude' => '-93.0931000',
                'city' => 'Cloutierville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71354',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.4417000',
                'longitude' => '-91.7199000',
                'city' => 'Monterey',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71326',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8449000',
                'longitude' => '-91.6557000',
                'city' => 'Clayton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71368',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8449000',
                'longitude' => '-91.6557000',
                'city' => 'Sicily Island',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71067',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5448000',
                'longitude' => '-93.5439000',
                'city' => 'Princeton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71037',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5448000',
                'longitude' => '-93.5439000',
                'city' => 'Haughton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71225',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5368000',
                'longitude' => '-92.1850000',
                'city' => 'Calhoun',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71367',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8419000',
                'longitude' => '-92.2574000',
                'city' => 'Saint Landry',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71336',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1646000',
                'longitude' => '-91.7138000',
                'city' => 'Gilbert',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71286',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8068000',
                'longitude' => '-91.1852000',
                'city' => 'Transylvania',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71263',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8068000',
                'longitude' => '-91.1852000',
                'city' => 'Oak Grove',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71301',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3067000',
                'longitude' => '-92.4520000',
                'city' => 'Alexandria',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71485',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3067000',
                'longitude' => '-92.4520000',
                'city' => 'Woodworth',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71254',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8571000',
                'longitude' => '-91.3860000',
                'city' => 'Lake Providence',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71266',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8571000',
                'longitude' => '-91.3860000',
                'city' => 'Pioneer',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71439',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3352000',
                'longitude' => '-93.3933000',
                'city' => 'Hornbeck',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71409',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3067000',
                'longitude' => '-92.4520000',
                'city' => 'Boyce',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71306',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3067000',
                'longitude' => '-92.4520000',
                'city' => 'Alexandria',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71110',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5155000',
                'longitude' => '-93.7497000',
                'city' => 'Barksdale Afb',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71052',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.0340000',
                'longitude' => '-93.7088000',
                'city' => 'Mansfield',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71357',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.0727000',
                'longitude' => '-91.2335000',
                'city' => 'Newellton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71468',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.6868000',
                'longitude' => '-93.3055000',
                'city' => 'Provencal',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71411',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8987000',
                'longitude' => '-93.1186000',
                'city' => 'Campti',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71429',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.4425000',
                'longitude' => '-93.4610000',
                'city' => 'Florien',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71232',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.4596000',
                'longitude' => '-91.4917000',
                'city' => 'Delhi',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71419',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7810000',
                'longitude' => '-93.7094000',
                'city' => 'Converse',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71480',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9010000',
                'longitude' => '-92.2424000',
                'city' => 'Urania',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71465',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9010000',
                'longitude' => '-92.2424000',
                'city' => 'Olla',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71261',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7742000',
                'longitude' => '-91.7923000',
                'city' => 'Mer Rouge',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71237',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6007000',
                'longitude' => '-91.4738000',
                'city' => 'Epps',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71016',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.2473000',
                'longitude' => '-93.1667000',
                'city' => 'Castor',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71027',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.4196000',
                'longitude' => '-93.7105000',
                'city' => 'Frierson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71119',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.4764000',
                'longitude' => '-93.7937000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71109',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.4764000',
                'longitude' => '-93.7937000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71378',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8511000',
                'longitude' => '-91.6583000',
                'city' => 'Wisner',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71479',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8156000',
                'longitude' => '-92.3354000',
                'city' => 'Tullos',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71075',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9976000',
                'longitude' => '-93.4677000',
                'city' => 'Springhill',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71002',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.2515000',
                'longitude' => '-93.1645000',
                'city' => 'Ashland',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71276',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6289000',
                'longitude' => '-91.1760000',
                'city' => 'Sondheimer',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71341',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0586000',
                'longitude' => '-92.1369000',
                'city' => 'Hessmer',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71330',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0586000',
                'longitude' => '-92.1369000',
                'city' => 'Echo',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71403',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3267000',
                'longitude' => '-93.3976000',
                'city' => 'Anacoco',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71462',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7848000',
                'longitude' => '-93.6664000',
                'city' => 'Noble',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71031',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1627000',
                'longitude' => '-92.9743000',
                'city' => 'Goldonna',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71327',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9819000',
                'longitude' => '-92.0602000',
                'city' => 'Cottonport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71280',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7010000',
                'longitude' => '-92.0840000',
                'city' => 'Sterlington',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71028',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5440000',
                'longitude' => '-93.0513000',
                'city' => 'Gibsland',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71032',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.0818000',
                'longitude' => '-93.8080000',
                'city' => 'Grand Cane',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71422',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9290000',
                'longitude' => '-92.6360000',
                'city' => 'Dodson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71404',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9290000',
                'longitude' => '-92.6360000',
                'city' => 'Atlanta',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71233',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3599000',
                'longitude' => '-90.8827000',
                'city' => 'Delta',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70638',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8671000',
                'longitude' => '-92.7936000',
                'city' => 'Elizabeth',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71234',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5135000',
                'longitude' => '-92.3587000',
                'city' => 'Downsville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71227',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5135000',
                'longitude' => '-92.3587000',
                'city' => 'Choudrant',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71441',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1043000',
                'longitude' => '-92.0739000',
                'city' => 'Kelly',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71415',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1043000',
                'longitude' => '-92.0739000',
                'city' => 'Clarks',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71424',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0825000',
                'longitude' => '-92.7340000',
                'city' => 'Elmer',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71430',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0825000',
                'longitude' => '-92.7340000',
                'city' => 'Forest Hill',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71166',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5113000',
                'longitude' => '-93.7519000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71049',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9722000',
                'longitude' => '-93.9995000',
                'city' => 'Logansport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71334',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.6232000',
                'longitude' => '-91.5626000',
                'city' => 'Ferriday',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71230',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.2313000',
                'longitude' => '-91.5999000',
                'city' => 'Crowville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71243',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.0483000',
                'longitude' => '-91.8187000',
                'city' => 'Fort Necessity',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71410',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.9682000',
                'longitude' => '-92.7750000',
                'city' => 'Calvin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70662',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8671000',
                'longitude' => '-92.7936000',
                'city' => 'Sugartown',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71023',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5329000',
                'longitude' => '-93.4195000',
                'city' => 'Doyline',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71425',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7664000',
                'longitude' => '-91.8288000',
                'city' => 'Enterprise',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71340',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.7664000',
                'longitude' => '-91.8288000',
                'city' => 'Harrisonburg',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71063',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8832000',
                'longitude' => '-93.5922000',
                'city' => 'Pelican',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71407',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.5235000',
                'longitude' => '-92.4080000',
                'city' => 'Bentley',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71047',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3338000',
                'longitude' => '-93.8317000',
                'city' => 'Keithville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71277',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9396000',
                'longitude' => '-92.6017000',
                'city' => 'Spearsville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71427',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3868000',
                'longitude' => '-92.6802000',
                'city' => 'Flatwoods',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71455',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3868000',
                'longitude' => '-92.6802000',
                'city' => 'Mora',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71466',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3868000',
                'longitude' => '-92.6802000',
                'city' => 'Otis',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71472',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.3868000',
                'longitude' => '-92.6802000',
                'city' => 'Sieper',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71065',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.8136000',
                'longitude' => '-93.5163000',
                'city' => 'Pleasant Hill',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71294',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5183000',
                'longitude' => '-92.0995000',
                'city' => 'West Monroe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71134',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5070000',
                'longitude' => '-93.7541000',
                'city' => 'Shreveport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71250',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9259000',
                'longitude' => '-91.6729000',
                'city' => 'Jones',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71223',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9259000',
                'longitude' => '-91.6729000',
                'city' => 'Bonita',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71080',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.5440000',
                'longitude' => '-93.0513000',
                'city' => 'Taylor',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71072',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9394000',
                'longitude' => '-93.3013000',
                'city' => 'Shongaloo',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71071',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.8904000',
                'longitude' => '-93.4524000',
                'city' => 'Sarepta',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71046',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.0837000',
                'longitude' => '-93.8129000',
                'city' => 'Keatchie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71229',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.6917000',
                'longitude' => '-91.8675000',
                'city' => 'Collinston',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71045',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3238000',
                'longitude' => '-93.2866000',
                'city' => 'Jamestown',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71068',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3238000',
                'longitude' => '-93.2866000',
                'city' => 'Ringgold',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71061',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7394000',
                'longitude' => '-93.9652000',
                'city' => 'Oil City',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71362',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9672000',
                'longitude' => '-91.9859000',
                'city' => 'Plaucheville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71329',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9672000',
                'longitude' => '-91.9859000',
                'city' => 'Dupont',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71078',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.3333000',
                'longitude' => '-93.8438000',
                'city' => 'Stonewall',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71079',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.7885000',
                'longitude' => '-93.0530000',
                'city' => 'Summerfield',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71034',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.0169000',
                'longitude' => '-93.3461000',
                'city' => 'Hall Summit',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71019',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.0169000',
                'longitude' => '-93.3461000',
                'city' => 'Coushatta',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71030',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.1941000',
                'longitude' => '-93.8505000',
                'city' => 'Gloster',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71007',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.4439000',
                'longitude' => '-93.9761000',
                'city' => 'Bethany',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71369',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9819000',
                'longitude' => '-91.8078000',
                'city' => 'Simmesport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71355',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0338000',
                'longitude' => '-91.9739000',
                'city' => 'Moreauville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71339',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0338000',
                'longitude' => '-91.9739000',
                'city' => 'Hamburg',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71749',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '33.0187000',
                'longitude' => '-92.7270000',
                'city' => 'Junction City',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71051',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.4253000',
                'longitude' => '-93.4588000',
                'city' => 'Elm Grove',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71371',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.6824000',
                'longitude' => '-92.1285000',
                'city' => 'Trout',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71021',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '32.9689000',
                'longitude' => '-93.4589000',
                'city' => 'Cullen',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71320',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0996000',
                'longitude' => '-91.9094000',
                'city' => 'Bordelonville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70515',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4921000',
                'longitude' => '-92.5923000',
                'city' => 'Basile',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70560',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9995000',
                'longitude' => '-91.8272000',
                'city' => 'New Iberia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70634',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8496000',
                'longitude' => '-93.2925000',
                'city' => 'Deridder',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70503',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2247000',
                'longitude' => '-92.0166000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70506',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2247000',
                'longitude' => '-92.0166000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70570',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5317000',
                'longitude' => '-92.0820000',
                'city' => 'Opelousas',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71459',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1388000',
                'longitude' => '-93.2663000',
                'city' => 'Fort Polk',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70507',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2454000',
                'longitude' => '-92.0173000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70615',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2328000',
                'longitude' => '-93.2075000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70601',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2328000',
                'longitude' => '-93.2075000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70669',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2327000',
                'longitude' => '-93.3753000',
                'city' => 'Westlake',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70665',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2327000',
                'longitude' => '-93.3753000',
                'city' => 'Sulphur',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70529',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.1756000',
                'longitude' => '-92.0715000',
                'city' => 'Duson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70611',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3118000',
                'longitude' => '-93.2019000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70657',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3118000',
                'longitude' => '-93.2019000',
                'city' => 'Ragley',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70629',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2328000',
                'longitude' => '-93.2075000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70526',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Crowley',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70633',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4482000',
                'longitude' => '-93.4336000',
                'city' => 'Dequincy',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70542',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0263000',
                'longitude' => '-92.5091000',
                'city' => 'Gueydan',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70548',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0019000',
                'longitude' => '-92.2843000',
                'city' => 'Kaplan',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70510',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Abbeville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70525',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4079000',
                'longitude' => '-92.2172000',
                'city' => 'Church Point',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70552',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0826000',
                'longitude' => '-91.7309000',
                'city' => 'Loreauville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70582',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0826000',
                'longitude' => '-91.7309000',
                'city' => 'Saint Martinville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70563',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0826000',
                'longitude' => '-91.7309000',
                'city' => 'New Iberia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70583',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2266000',
                'longitude' => '-92.0214000',
                'city' => 'Scott',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70501',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2266000',
                'longitude' => '-92.0214000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71461',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1430000',
                'longitude' => '-93.2641000',
                'city' => 'Newllano',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70544',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9183000',
                'longitude' => '-91.6667000',
                'city' => 'Jeanerette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70518',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.1473000',
                'longitude' => '-91.9643000',
                'city' => 'Broussard',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70607',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0188000',
                'longitude' => '-93.2183000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70605',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0188000',
                'longitude' => '-93.2183000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70067',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2266000',
                'longitude' => '-92.0214000',
                'city' => 'Lafitte',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70538',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9142000',
                'longitude' => '-91.6690000',
                'city' => 'Franklin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70502',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2247000',
                'longitude' => '-92.0166000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70550',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2247000',
                'longitude' => '-92.0166000',
                'city' => 'Lawtell',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70639',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1222000',
                'longitude' => '-93.4851000',
                'city' => 'Evans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70532',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4807000',
                'longitude' => '-92.6913000',
                'city' => 'Elton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70535',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4933000',
                'longitude' => '-92.4170000',
                'city' => 'Eunice',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70578',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2322000',
                'longitude' => '-92.2743000',
                'city' => 'Rayne',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70750',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5335000',
                'longitude' => '-91.7598000',
                'city' => 'Krotz Springs',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70663',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2328000',
                'longitude' => '-93.2075000',
                'city' => 'Sulphur',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70509',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2247000',
                'longitude' => '-92.0166000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70655',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6233000',
                'longitude' => '-92.7686000',
                'city' => 'Oberlin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70668',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.1914000',
                'longitude' => '-93.5810000',
                'city' => 'Vinton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70520',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3259000',
                'longitude' => '-92.0273000',
                'city' => 'Carencro',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70637',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7725000',
                'longitude' => '-93.0176000',
                'city' => 'Dry Creek',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70516',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2364000',
                'longitude' => '-92.2721000',
                'city' => 'Branch',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70586',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6818000',
                'longitude' => '-92.2774000',
                'city' => 'Ville Platte',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70591',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2400000',
                'longitude' => '-92.8274000',
                'city' => 'Welsh',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70660',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7488000',
                'longitude' => '-93.5418000',
                'city' => 'Singer',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70392',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7618000',
                'longitude' => '-91.4362000',
                'city' => 'Patterson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70514',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7618000',
                'longitude' => '-91.4362000',
                'city' => 'Baldwin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70528',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8070000',
                'longitude' => '-91.8183000',
                'city' => 'Delcambre',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70647',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2335000',
                'longitude' => '-93.0161000',
                'city' => 'Iowa',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70592',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Youngsville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70589',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6818000',
                'longitude' => '-92.2774000',
                'city' => 'Washington',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70537',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2185000',
                'longitude' => '-92.6588000',
                'city' => 'Evangeline',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70581',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2185000',
                'longitude' => '-92.6588000',
                'city' => 'Roanoke',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70653',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7488000',
                'longitude' => '-93.5418000',
                'city' => 'Merryville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70562',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0017000',
                'longitude' => '-91.7330000',
                'city' => 'New Iberia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70648',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Kinder',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71474',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.1388000',
                'longitude' => '-93.2663000',
                'city' => 'Simpson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70645',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0188000',
                'longitude' => '-93.2183000',
                'city' => 'Hackberry',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70658',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5163000',
                'longitude' => '-93.0507000',
                'city' => 'Reeves',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70512',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3134000',
                'longitude' => '-91.7834000',
                'city' => 'Arnaudville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '71358',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6893000',
                'longitude' => '-91.7412000',
                'city' => 'Palmetto',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70659',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8477000',
                'longitude' => '-93.2876000',
                'city' => 'Rosepine',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70585',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8747000',
                'longitude' => '-92.4156000',
                'city' => 'Turkey Creek',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70554',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6321000',
                'longitude' => '-92.4202000',
                'city' => 'Mamou',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70609',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.1764000',
                'longitude' => '-93.2189000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70504',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2266000',
                'longitude' => '-92.0214000',
                'city' => 'Lafayette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70533',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9770000',
                'longitude' => '-92.1349000',
                'city' => 'Erath',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70630',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2328000',
                'longitude' => '-93.2075000',
                'city' => 'Bell City',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70602',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2328000',
                'longitude' => '-93.2075000',
                'city' => 'Lake Charles',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70643',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7624000',
                'longitude' => '-92.9683000',
                'city' => 'Grand Chenier',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70632',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8153000',
                'longitude' => '-93.1142000',
                'city' => 'Creole',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70549',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0832000',
                'longitude' => '-92.6766000',
                'city' => 'Lake Arthur',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70577',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5377000',
                'longitude' => '-91.7576000',
                'city' => 'Port Barre',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70631',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7619000',
                'longitude' => '-93.6359000',
                'city' => 'Cameron',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70650',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2325000',
                'longitude' => '-92.9240000',
                'city' => 'Lacassine',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70576',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7850000',
                'longitude' => '-92.4335000',
                'city' => 'Pine Prairie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70556',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2247000',
                'longitude' => '-92.6614000',
                'city' => 'Mermentau',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70543',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2247000',
                'longitude' => '-92.6614000',
                'city' => 'Iota',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70646',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.1187000',
                'longitude' => '-92.9188000',
                'city' => 'Hayes',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70654',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6233000',
                'longitude' => '-92.7686000',
                'city' => 'Mittie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70541',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4182000',
                'longitude' => '-92.0661000',
                'city' => 'Grand Coteau',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70584',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4182000',
                'longitude' => '-92.0661000',
                'city' => 'Sunset',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70521',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3408000',
                'longitude' => '-91.8505000',
                'city' => 'Cecilia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70652',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5340000',
                'longitude' => '-93.1345000',
                'city' => 'Longville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70661',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3169000',
                'longitude' => '-93.6563000',
                'city' => 'Starks',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70640',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3675000',
                'longitude' => '-92.9183000',
                'city' => 'Fenton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70559',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2149000',
                'longitude' => '-92.3705000',
                'city' => 'Morse',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70531',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2149000',
                'longitude' => '-92.3705000',
                'city' => 'Egan',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70534',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2149000',
                'longitude' => '-92.3705000',
                'city' => 'Estherwood',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70380',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7998000',
                'longitude' => '-91.5031000',
                'city' => 'Morgan City',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70522',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7537000',
                'longitude' => '-91.4289000',
                'city' => 'Centerville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70551',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4701000',
                'longitude' => '-91.9803000',
                'city' => 'Leonville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70524',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5685000',
                'longitude' => '-92.3252000',
                'city' => 'Chataignier',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70555',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9709000',
                'longitude' => '-92.1324000',
                'city' => 'Maurice',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70523',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8382000',
                'longitude' => '-91.5466000',
                'city' => 'Charenton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70149',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70145',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70065',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9729000',
                'longitude' => '-90.2440000',
                'city' => 'Kenner',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70140',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9496000',
                'longitude' => '-90.0694000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70006',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9517000',
                'longitude' => '-90.0742000',
                'city' => 'Metairie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70128',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9517000',
                'longitude' => '-90.0742000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70112',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9517000',
                'longitude' => '-90.0742000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70002',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9517000',
                'longitude' => '-90.0742000',
                'city' => 'Metairie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70001',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Metairie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70118',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9800000',
                'longitude' => '-90.1523000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70124',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9800000',
                'longitude' => '-90.1523000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70122',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0369000',
                'longitude' => '-90.0330000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70126',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0369000',
                'longitude' => '-90.0330000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70121',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9800000',
                'longitude' => '-90.1523000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70005',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9800000',
                'longitude' => '-90.1523000',
                'city' => 'Metairie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70115',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70072',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Marrero',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70053',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Gretna',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70058',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9291000',
                'longitude' => '-90.0456000',
                'city' => 'Harvey',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70056',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9291000',
                'longitude' => '-90.0456000',
                'city' => 'Gretna',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70114',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9291000',
                'longitude' => '-90.0456000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70004',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0059000',
                'longitude' => '-90.2492000',
                'city' => 'Metairie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70003',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0059000',
                'longitude' => '-90.2492000',
                'city' => 'Metairie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70063',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0059000',
                'longitude' => '-90.2492000',
                'city' => 'Kenner',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70094',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0059000',
                'longitude' => '-90.2492000',
                'city' => 'Westwego',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70127',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9584000',
                'longitude' => '-90.0060000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70129',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0357000',
                'longitude' => '-89.9105000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70117',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70113',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9762000',
                'longitude' => '-90.1075000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70116',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9762000',
                'longitude' => '-90.1075000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70170',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9762000',
                'longitude' => '-90.1075000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70125',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70092',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7674000',
                'longitude' => '-89.7897000',
                'city' => 'Violet',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70040',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7674000',
                'longitude' => '-89.7897000',
                'city' => 'Braithwaite',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70032',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9359000',
                'longitude' => '-89.9775000',
                'city' => 'Arabi',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70075',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9359000',
                'longitude' => '-89.9775000',
                'city' => 'Meraux',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70043',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9359000',
                'longitude' => '-89.9775000',
                'city' => 'Chalmette',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70085',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8643000',
                'longitude' => '-89.8589000',
                'city' => 'Saint Bernard',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70139',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70148',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0159000',
                'longitude' => '-90.0680000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70182',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0159000',
                'longitude' => '-90.0680000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70123',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9729000',
                'longitude' => '-90.2440000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70141',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70068',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0059000',
                'longitude' => '-90.2492000',
                'city' => 'La Place',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70119',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70458',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0986000',
                'longitude' => '-89.7698000',
                'city' => 'Slidell',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70062',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9444000',
                'longitude' => '-90.1894000',
                'city' => 'Kenner',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70163',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70083',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5811000',
                'longitude' => '-89.7992000',
                'city' => 'Port Sulphur',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70131',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9291000',
                'longitude' => '-90.0456000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70037',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9004000',
                'longitude' => '-90.0146000',
                'city' => 'Belle Chasse',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70431',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Bush',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70036',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7409000',
                'longitude' => '-90.0265000',
                'city' => 'Barataria',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70031',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9091000',
                'longitude' => '-90.2030000',
                'city' => 'Ama',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70087',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0120000',
                'longitude' => '-90.2635000',
                'city' => 'Saint Rose',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70470',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Mandeville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70091',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.2808000',
                'longitude' => '-89.3588000',
                'city' => 'Venice',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70377',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9729000',
                'longitude' => '-90.2440000',
                'city' => 'Montegut',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70184',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70064',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Kenner',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70460',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Slidell',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70433',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Covington',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70041',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.3568000',
                'longitude' => '-89.5440000',
                'city' => 'Buras',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70434',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0059000',
                'longitude' => '-90.2492000',
                'city' => 'Covington',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70143',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70146',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70360',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Houma',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70059',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0059000',
                'longitude' => '-90.2492000',
                'city' => 'Harvey',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70345',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9800000',
                'longitude' => '-90.1523000',
                'city' => 'Cut Off',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70187',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0044000',
                'longitude' => '-90.1974000',
                'city' => 'New Orleans',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70437',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9475000',
                'longitude' => '-90.0765000',
                'city' => 'Folsom',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70461',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2745000',
                'longitude' => '-89.7835000',
                'city' => 'Slidell',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70427',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7810000',
                'longitude' => '-89.8601000',
                'city' => 'Bogalusa',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70447',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4084000',
                'longitude' => '-90.1563000',
                'city' => 'Madisonville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70438',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.8492000',
                'longitude' => '-90.1532000',
                'city' => 'Franklinton',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70364',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5986000',
                'longitude' => '-90.7162000',
                'city' => 'Houma',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70079',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0654000',
                'longitude' => '-90.4859000',
                'city' => 'Norco',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70084',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0654000',
                'longitude' => '-90.4859000',
                'city' => 'Reserve',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70363',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5964000',
                'longitude' => '-90.7232000',
                'city' => 'Houma',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70445',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3169000',
                'longitude' => '-89.9423000',
                'city' => 'Lacombe',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70471',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3595000',
                'longitude' => '-90.0658000',
                'city' => 'Mandeville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70359',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5964000',
                'longitude' => '-90.7232000',
                'city' => 'Gray',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70397',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5964000',
                'longitude' => '-90.7232000',
                'city' => 'Theriot',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70301',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8000000',
                'longitude' => '-90.8169000',
                'city' => 'Thibodaux',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70465',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9387000',
                'longitude' => '-90.5115000',
                'city' => 'Tangipahoa',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70444',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.9387000',
                'longitude' => '-90.5115000',
                'city' => 'Kentwood',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70446',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5025000',
                'longitude' => '-90.4632000',
                'city' => 'Loranger',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70455',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5025000',
                'longitude' => '-90.4632000',
                'city' => 'Robert',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70435',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.4730000',
                'longitude' => '-90.1028000',
                'city' => 'Covington',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70339',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9652000',
                'longitude' => '-91.2115000',
                'city' => 'Pierre Part',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70070',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9323000',
                'longitude' => '-90.3657000',
                'city' => 'Luling',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70374',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.6404000',
                'longitude' => '-90.5365000',
                'city' => 'Lockport',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70452',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3740000',
                'longitude' => '-89.7515000',
                'city' => 'Pearl River',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70353',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.3874000',
                'longitude' => '-90.7139000',
                'city' => 'Dulac',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70355',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5761000',
                'longitude' => '-90.3735000',
                'city' => 'Gheens',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70420',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3595000',
                'longitude' => '-90.0658000',
                'city' => 'Abita Springs',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70080',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8735000',
                'longitude' => '-90.4329000',
                'city' => 'Paradis',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70358',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.2320000',
                'longitude' => '-89.9912000',
                'city' => 'Grand Isle',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70372',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8330000',
                'longitude' => '-90.9563000',
                'city' => 'Labadieville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70354',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.4773000',
                'longitude' => '-90.3225000',
                'city' => 'Galliano',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70381',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7044000',
                'longitude' => '-91.1997000',
                'city' => 'Morgan City',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70342',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7044000',
                'longitude' => '-91.1997000',
                'city' => 'Berwick',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70039',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9095000',
                'longitude' => '-90.3606000',
                'city' => 'Boutte',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70082',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Pointe A La Hache',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70393',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9395000',
                'longitude' => '-91.0272000',
                'city' => 'Plattenville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70391',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9395000',
                'longitude' => '-91.0272000',
                'city' => 'Paincourtville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70390',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9395000',
                'longitude' => '-91.0272000',
                'city' => 'Napoleonville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70357',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.1286000',
                'longitude' => '-90.2160000',
                'city' => 'Golden Meadow',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70395',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7875000',
                'longitude' => '-90.8237000',
                'city' => 'Schriever',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70394',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.7875000',
                'longitude' => '-90.8237000',
                'city' => 'Raceland',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70356',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.6813000',
                'longitude' => '-90.9855000',
                'city' => 'Gibson',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '39572',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2505000',
                'longitude' => '-89.6085000',
                'city' => 'Pearlington',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70375',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.6466000',
                'longitude' => '-90.5389000',
                'city' => 'Mathews',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70038',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Boothville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70076',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0596000',
                'longitude' => '-90.6177000',
                'city' => 'Mount Airy',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70051',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.0596000',
                'longitude' => '-90.6177000',
                'city' => 'Garyville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70436',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0053000',
                'longitude' => '-90.4746000',
                'city' => 'Fluker',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70450',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '31.0053000',
                'longitude' => '-90.4746000',
                'city' => 'Mount Hermon',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70402',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.5025000',
                'longitude' => '-90.4632000',
                'city' => 'Hammond',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70426',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7810000',
                'longitude' => '-89.8601000',
                'city' => 'Angie',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70343',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5298000',
                'longitude' => '-90.6022000',
                'city' => 'Bourg',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70344',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5298000',
                'longitude' => '-90.6022000',
                'city' => 'Chauvin',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70448',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.3595000',
                'longitude' => '-90.0658000',
                'city' => 'Mandeville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70340',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.6606000',
                'longitude' => '-91.1070000',
                'city' => 'Amelia',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70373',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5761000',
                'longitude' => '-90.3735000',
                'city' => 'Larose',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70459',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.2745000',
                'longitude' => '-89.7835000',
                'city' => 'Slidell',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70078',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9673000',
                'longitude' => '-90.3757000',
                'city' => 'New Sarpy',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70442',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.7254000',
                'longitude' => '-90.5171000',
                'city' => 'Husser',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70030',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.8921000',
                'longitude' => '-90.4403000',
                'city' => 'Des Allemands',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70057',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.9814000',
                'longitude' => '-90.4089000',
                'city' => 'Hahnville',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70361',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '29.5986000',
                'longitude' => '-90.7162000',
                'city' => 'Houma',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70464',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6111000',
                'longitude' => '-89.8961000',
                'city' => 'Talisheek',
                'full_state' => 'Louisiana',
            ],
            [
                'zip' => '70463',
                'country_code' => 'US',
                'state' => 'LA',
                'latitude' => '30.6111000',
                'longitude' => '-89.8961000',
                'city' => 'Sun',
                'full_state' => 'Louisiana',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
