<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class IowaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '52641',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9662000',
                'longitude' => '-91.5518000',
                'city' => 'Mount Pleasant',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52403',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52405',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52601',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8151000',
                'longitude' => '-91.1101000',
                'city' => 'Burlington',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52404',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52738',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2812000',
                'longitude' => '-91.3603000',
                'city' => 'Columbus Junction',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52349',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1658000',
                'longitude' => '-92.0147000',
                'city' => 'Vinton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50703',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Waterloo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50701',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Waterloo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52401',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9773000',
                'longitude' => '-91.6713000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52402',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9773000',
                'longitude' => '-91.6713000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52346',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9950000',
                'longitude' => '-91.9669000',
                'city' => 'Van Horne',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52206',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9950000',
                'longitude' => '-91.9669000',
                'city' => 'Atkins',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52354',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9950000',
                'longitude' => '-91.9669000',
                'city' => 'Watkins',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52315',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9950000',
                'longitude' => '-91.9669000',
                'city' => 'Newhall',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52344',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2892000',
                'longitude' => '-91.6853000',
                'city' => 'Troy Mills',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52352',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2892000',
                'longitude' => '-91.6853000',
                'city' => 'Walker',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52218',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2892000',
                'longitude' => '-91.6853000',
                'city' => 'Coggon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50682',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2892000',
                'longitude' => '-91.6853000',
                'city' => 'Winthrop',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52203',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8086000',
                'longitude' => '-91.8735000',
                'city' => 'Amana',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50702',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4983000',
                'longitude' => '-92.3388000',
                'city' => 'Waterloo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50707',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4983000',
                'longitude' => '-92.3388000',
                'city' => 'Evansdale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52318',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9008000',
                'longitude' => '-91.9174000',
                'city' => 'Norway',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52301',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9008000',
                'longitude' => '-91.9174000',
                'city' => 'Marengo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52249',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0114000',
                'longitude' => '-92.0858000',
                'city' => 'Keystone',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50613',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Cedar Falls',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50662',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6740000',
                'longitude' => '-91.9191000',
                'city' => 'Oelwein',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50441',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Hampton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52147',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Hawkeye',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50704',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Waterloo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52227',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8732000',
                'longitude' => '-91.5941000',
                'city' => 'Ely',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52627',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6325000',
                'longitude' => '-91.3256000',
                'city' => 'Fort Madison',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52241',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6673000',
                'longitude' => '-91.5354000',
                'city' => 'Coralville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52240',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6673000',
                'longitude' => '-91.5354000',
                'city' => 'Iowa City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52650',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9425000',
                'longitude' => '-91.1773000',
                'city' => 'Sperry',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52637',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0005000',
                'longitude' => '-91.1674000',
                'city' => 'Mediapolis',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52630',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8354000',
                'longitude' => '-91.7138000',
                'city' => 'Hillsboro',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52649',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8354000',
                'longitude' => '-91.7138000',
                'city' => 'Salem',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52621',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1338000',
                'longitude' => '-91.5475000',
                'city' => 'Crawfordsville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52652',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1338000',
                'longitude' => '-91.5475000',
                'city' => 'Swedesburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52647',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1338000',
                'longitude' => '-91.5475000',
                'city' => 'Olds',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52659',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1338000',
                'longitude' => '-91.5475000',
                'city' => 'Winfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52654',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1382000',
                'longitude' => '-91.6590000',
                'city' => 'Wayland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52644',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1251000',
                'longitude' => '-91.4386000',
                'city' => 'Mount Union',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52302',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9119000',
                'longitude' => '-91.6308000',
                'city' => 'Marion',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52247',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4827000',
                'longitude' => '-91.7059000',
                'city' => 'Kalona',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50602',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7524000',
                'longitude' => '-92.7972000',
                'city' => 'Allison',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50669',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7524000',
                'longitude' => '-92.7972000',
                'city' => 'Reinbeck',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50636',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7524000',
                'longitude' => '-92.7972000',
                'city' => 'Greene',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50706',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7524000',
                'longitude' => '-92.7972000',
                'city' => 'Allison',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50677',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Waverly',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50643',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4900000',
                'longitude' => '-92.3439000',
                'city' => 'Hudson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50614',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5251000',
                'longitude' => '-92.4446000',
                'city' => 'Cedar Falls',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50631',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8808000',
                'longitude' => '-92.3089000',
                'city' => 'Frederika',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50676',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8808000',
                'longitude' => '-92.3089000',
                'city' => 'Tripoli',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50645',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8808000',
                'longitude' => '-92.3089000',
                'city' => 'Ionia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50630',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8808000',
                'longitude' => '-92.3089000',
                'city' => 'Fredericksburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50674',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8808000',
                'longitude' => '-92.3089000',
                'city' => 'Sumner',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50666',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8808000',
                'longitude' => '-92.3089000',
                'city' => 'Plainfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50658',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8414000',
                'longitude' => '-92.5333000',
                'city' => 'Nashua',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50619',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8414000',
                'longitude' => '-92.5333000',
                'city' => 'Clarksville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50648',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7846000',
                'longitude' => '-92.6666000',
                'city' => 'Jesup',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50668',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7033000',
                'longitude' => '-92.2241000',
                'city' => 'Readlyn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50629',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7033000',
                'longitude' => '-92.2241000',
                'city' => 'Fairbank',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50626',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7033000',
                'longitude' => '-92.2241000',
                'city' => 'Dunkerton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50622',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7033000',
                'longitude' => '-92.2241000',
                'city' => 'Denver',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52316',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5174000',
                'longitude' => '-92.0757000',
                'city' => 'North English',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52565',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7316000',
                'longitude' => '-91.9651000',
                'city' => 'Keosauqua',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52233',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0353000',
                'longitude' => '-91.6623000',
                'city' => 'Hiawatha',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52328',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0353000',
                'longitude' => '-91.6623000',
                'city' => 'Robins',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52411',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0353000',
                'longitude' => '-91.6623000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52498',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9773000',
                'longitude' => '-91.6713000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50634',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4130000',
                'longitude' => '-92.2690000',
                'city' => 'Gilbertville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52632',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.4000000',
                'longitude' => '-91.3909000',
                'city' => 'Keokuk',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50644',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4655000',
                'longitude' => '-91.8950000',
                'city' => 'Independence',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52314',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Mount Vernon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52222',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6673000',
                'longitude' => '-91.5354000',
                'city' => 'Deep River',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52308',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6673000',
                'longitude' => '-91.5354000',
                'city' => 'Millersburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52246',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6570000',
                'longitude' => '-91.5352000',
                'city' => 'Iowa City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52244',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6570000',
                'longitude' => '-91.5352000',
                'city' => 'Iowa City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52242',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6570000',
                'longitude' => '-91.5352000',
                'city' => 'Iowa City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52327',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5598000',
                'longitude' => '-91.5356000',
                'city' => 'Riverside',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52245',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6570000',
                'longitude' => '-91.5352000',
                'city' => 'Iowa City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50651',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3111000',
                'longitude' => '-92.1960000',
                'city' => 'La Porte City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50657',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3230000',
                'longitude' => '-92.5990000',
                'city' => 'Morrison',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50635',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3230000',
                'longitude' => '-92.5990000',
                'city' => 'Gladbrook',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50673',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5769000',
                'longitude' => '-92.7896000',
                'city' => 'Stout',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50665',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5769000',
                'longitude' => '-92.7896000',
                'city' => 'Parkersburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50608',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5847000',
                'longitude' => '-92.8871000',
                'city' => 'Austinville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50604',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5847000',
                'longitude' => '-92.8871000',
                'city' => 'Aplington',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50649',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5847000',
                'longitude' => '-92.8871000',
                'city' => 'Kesley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50601',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5847000',
                'longitude' => '-92.8871000',
                'city' => 'Ackley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52228',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9179000',
                'longitude' => '-91.7758000',
                'city' => 'Fairfax',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52205',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Anamosa',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52623',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9229000',
                'longitude' => '-91.4045000',
                'city' => 'Danville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52645',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9229000',
                'longitude' => '-91.4045000',
                'city' => 'New London',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52658',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6305000',
                'longitude' => '-91.3201000',
                'city' => 'Wever',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52406',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9773000',
                'longitude' => '-91.6713000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52341',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0353000',
                'longitude' => '-91.6623000',
                'city' => 'Toddville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52317',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6570000',
                'longitude' => '-91.5352000',
                'city' => 'North Liberty',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52214',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Central City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52410',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52638',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8581000',
                'longitude' => '-91.3111000',
                'city' => 'Middletown',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52655',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8581000',
                'longitude' => '-91.3111000',
                'city' => 'West Burlington',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52660',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0005000',
                'longitude' => '-91.1674000',
                'city' => 'Yarmouth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52640',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0005000',
                'longitude' => '-91.1674000',
                'city' => 'Morning Sun',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52324',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9765000',
                'longitude' => '-91.7259000',
                'city' => 'Palo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52542',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6510000',
                'longitude' => '-92.0680000',
                'city' => 'Cantril',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52570',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6510000',
                'longitude' => '-92.0680000',
                'city' => 'Milton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50670',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7100000',
                'longitude' => '-92.5828000',
                'city' => 'Shell Rock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52257',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8958000',
                'longitude' => '-92.2799000',
                'city' => 'Luzerne',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52225',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8958000',
                'longitude' => '-92.2799000',
                'city' => 'Elberon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52208',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8958000',
                'longitude' => '-92.2799000',
                'city' => 'Belle Plaine',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52332',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0940000',
                'longitude' => '-91.8695000',
                'city' => 'Shellsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52219',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2364000',
                'longitude' => '-91.4236000',
                'city' => 'Prairieburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52310',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2364000',
                'longitude' => '-91.4236000',
                'city' => 'Monticello',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52213',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2022000',
                'longitude' => '-91.5261000',
                'city' => 'Center Point',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52217',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0025000',
                'longitude' => '-92.3221000',
                'city' => 'Clutier',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52224',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0008000',
                'longitude' => '-92.2010000',
                'city' => 'Dysart',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52345',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2239000',
                'longitude' => '-91.8771000',
                'city' => 'Urbana',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52215',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9000000',
                'longitude' => '-92.2773000',
                'city' => 'Chelsea',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52209',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9081000',
                'longitude' => '-92.0825000',
                'city' => 'Blairstown',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52253',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9215000',
                'longitude' => '-91.3859000',
                'city' => 'Lisbon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52556',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1819000',
                'longitude' => '-91.9946000',
                'city' => 'Fairfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52585',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1819000',
                'longitude' => '-91.9946000',
                'city' => 'Richland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52353',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2989000',
                'longitude' => '-91.6930000',
                'city' => 'Washington',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52639',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.5279000',
                'longitude' => '-91.4178000',
                'city' => 'Montrose',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52625',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7855000',
                'longitude' => '-91.6044000',
                'city' => 'Donnellson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52648',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7855000',
                'longitude' => '-91.6044000',
                'city' => 'Pilot Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52631',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7855000',
                'longitude' => '-91.6044000',
                'city' => 'Houghton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52656',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7855000',
                'longitude' => '-91.6044000',
                'city' => 'West Point',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52657',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7855000',
                'longitude' => '-91.6044000',
                'city' => 'Saint Paul',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52619',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.4000000',
                'longitude' => '-91.3909000',
                'city' => 'Argyle',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52210',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3127000',
                'longitude' => '-91.9985000',
                'city' => 'Brandon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52329',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3127000',
                'longitude' => '-91.9985000',
                'city' => 'Rowley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52313',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2552000',
                'longitude' => '-92.0950000',
                'city' => 'Mount Auburn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50612',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1683000',
                'longitude' => '-92.3004000',
                'city' => 'Buckingham',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50158',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1683000',
                'longitude' => '-92.3004000',
                'city' => 'Marshalltown',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52229',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1427000',
                'longitude' => '-92.1396000',
                'city' => 'Garrison',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50675',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1915000',
                'longitude' => '-92.4696000',
                'city' => 'Traer',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52305',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0210000',
                'longitude' => '-91.3644000',
                'city' => 'Martelle',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52336',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0210000',
                'longitude' => '-91.3644000',
                'city' => 'Springville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52337',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9901000',
                'longitude' => '-91.1371000',
                'city' => 'Stanwood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52323',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9901000',
                'longitude' => '-91.1371000',
                'city' => 'Oxford Junction',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52306',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9901000',
                'longitude' => '-91.1371000',
                'city' => 'Mechanicsville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52320',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9901000',
                'longitude' => '-91.1371000',
                'city' => 'Olin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52312',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0054000',
                'longitude' => '-91.2485000',
                'city' => 'Morley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52573',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6185000',
                'longitude' => '-91.9348000',
                'city' => 'Mount Sterling',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52535',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8810000',
                'longitude' => '-91.9397000',
                'city' => 'Birmingham',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52653',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1698000',
                'longitude' => '-91.1813000',
                'city' => 'Wapello',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52211',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7868000',
                'longitude' => '-92.3475000',
                'city' => 'Brooklyn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52232',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7868000',
                'longitude' => '-92.3475000',
                'city' => 'Hartwick',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52624',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7399000',
                'longitude' => '-91.3385000',
                'city' => 'Denmark',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52151',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Lansing',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52761',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9662000',
                'longitude' => '-91.5518000',
                'city' => 'Muscatine',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52333',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8064000',
                'longitude' => '-91.4938000',
                'city' => 'Solon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52322',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7428000',
                'longitude' => '-91.6030000',
                'city' => 'Oxford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52340',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7428000',
                'longitude' => '-91.6030000',
                'city' => 'Tiffin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52045',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8151000',
                'longitude' => '-91.1101000',
                'city' => 'Epworth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52338',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8408000',
                'longitude' => '-91.6885000',
                'city' => 'Swisher',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50641',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6134000',
                'longitude' => '-91.9078000',
                'city' => 'Hazleton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52620',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6994000',
                'longitude' => '-91.8048000',
                'city' => 'Bonaparte',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52580',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1326000',
                'longitude' => '-92.0855000',
                'city' => 'Packwood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52307',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8086000',
                'longitude' => '-91.8735000',
                'city' => 'Middle Amana',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52334',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8086000',
                'longitude' => '-91.8735000',
                'city' => 'South Amana',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52236',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8086000',
                'longitude' => '-91.8735000',
                'city' => 'Homestead',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52361',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7551000',
                'longitude' => '-92.1846000',
                'city' => 'Williamsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52347',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7551000',
                'longitude' => '-92.1846000',
                'city' => 'Victor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52251',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7551000',
                'longitude' => '-92.1846000',
                'city' => 'Ladora',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52776',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5678000',
                'longitude' => '-91.2582000',
                'city' => 'West Liberty',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52325',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7254000',
                'longitude' => '-91.7834000',
                'city' => 'Parnell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52755',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4849000',
                'longitude' => '-91.4274000',
                'city' => 'Lone Tree',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50671',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6175000',
                'longitude' => '-91.7290000',
                'city' => 'Stanley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50650',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6175000',
                'longitude' => '-91.7290000',
                'city' => 'Lamont',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50607',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6175000',
                'longitude' => '-91.7290000',
                'city' => 'Aurora',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50664',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7014000',
                'longitude' => '-92.0710000',
                'city' => 'Oran',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52248',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4510000',
                'longitude' => '-92.0900000',
                'city' => 'Keota',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52356',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4510000',
                'longitude' => '-92.0900000',
                'city' => 'Wellman',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52335',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4510000',
                'longitude' => '-92.0900000',
                'city' => 'South English',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52358',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6639000',
                'longitude' => '-91.3397000',
                'city' => 'West Branch',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52201',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4805000',
                'longitude' => '-91.5857000',
                'city' => 'Ainsworth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52220',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7510000',
                'longitude' => '-91.9706000',
                'city' => 'Conroy',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52355',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4510000',
                'longitude' => '-92.0900000',
                'city' => 'Webster',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52235',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5475000',
                'longitude' => '-91.5299000',
                'city' => 'Hills',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52221',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6483000',
                'longitude' => '-92.3453000',
                'city' => 'Guernsey',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52540',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1748000',
                'longitude' => '-91.8177000',
                'city' => 'Brighton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52576',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1326000',
                'longitude' => '-92.0855000',
                'city' => 'Ollie',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52533',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1326000',
                'longitude' => '-92.0855000',
                'city' => 'Batavia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52563',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1326000',
                'longitude' => '-92.0855000',
                'city' => 'Hedrick',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52651',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9961000',
                'longitude' => '-91.7477000',
                'city' => 'Stockport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52635',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9961000',
                'longitude' => '-91.7477000',
                'city' => 'Lockridge',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52359',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3424000',
                'longitude' => '-91.8140000',
                'city' => 'West Chester',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52766',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4824000',
                'longitude' => '-91.3071000',
                'city' => 'Nichols',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52739',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3805000',
                'longitude' => '-91.3515000',
                'city' => 'Conesville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52754',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3283000',
                'longitude' => '-91.2359000',
                'city' => 'Letts',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52737',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2770000',
                'longitude' => '-91.3630000',
                'city' => 'Columbus City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52752',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2751000',
                'longitude' => '-91.1886000',
                'city' => 'Grandview',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50136',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4521000',
                'longitude' => '-92.2374000',
                'city' => 'Keswick',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52591',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4521000',
                'longitude' => '-92.2374000',
                'city' => 'Sigourney',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52646',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0991000',
                'longitude' => '-91.0442000',
                'city' => 'Oakville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52747',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9773000',
                'longitude' => '-91.6713000',
                'city' => 'Durant',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50638',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3664000',
                'longitude' => '-92.7695000',
                'city' => 'Grundy Center',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50624',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3622000',
                'longitude' => '-92.7721000',
                'city' => 'Dike',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50642',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3622000',
                'longitude' => '-92.7721000',
                'city' => 'Holland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52626',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6435000',
                'longitude' => '-91.5659000',
                'city' => 'Farmington',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52202',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1474000',
                'longitude' => '-91.6179000',
                'city' => 'Alburnett',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52351',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9157000',
                'longitude' => '-91.7839000',
                'city' => 'Walford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52350',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0571000',
                'longitude' => '-91.4502000',
                'city' => 'Viola',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52326',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3951000',
                'longitude' => '-91.7521000',
                'city' => 'Quasqueton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50654',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3951000',
                'longitude' => '-91.7521000',
                'city' => 'Masonville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52409',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9815000',
                'longitude' => '-91.6687000',
                'city' => 'Cedar Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50660',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5664000',
                'longitude' => '-92.6254000',
                'city' => 'New Hartford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50647',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6486000',
                'longitude' => '-92.4641000',
                'city' => 'Janesville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50511',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0680000',
                'longitude' => '-94.2346000',
                'city' => 'Algona',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50309',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50265',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'West Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50014',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0233000',
                'longitude' => '-93.6175000',
                'city' => 'Ames',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50212',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0322000',
                'longitude' => '-94.0236000',
                'city' => 'Ogden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50266',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'West Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50523',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Callender',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50595',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4658000',
                'longitude' => '-93.8189000',
                'city' => 'Webster City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50036',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0662000',
                'longitude' => '-93.8821000',
                'city' => 'Boone',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50328',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5862000',
                'longitude' => '-93.7506000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50201',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0244000',
                'longitude' => '-93.4548000',
                'city' => 'Nevada',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50046',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9001000',
                'longitude' => '-93.5228000',
                'city' => 'Cambridge',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50325',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5862000',
                'longitude' => '-93.7506000',
                'city' => 'Clive',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50501',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5005000',
                'longitude' => '-94.1850000',
                'city' => 'Fort Dodge',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50244',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8764000',
                'longitude' => '-93.6785000',
                'city' => 'Slater',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50301',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50317',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50111',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Grimes',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50322',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Urbandale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50072',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Earlham',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50315',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50311',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50273',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Winterset',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50263',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Waukee',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50131',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Johnston',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50327',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50314',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50248',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0233000',
                'longitude' => '-93.6175000',
                'city' => 'Story City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50010',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0275000',
                'longitude' => '-93.6150000',
                'city' => 'Ames',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50105',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0275000',
                'longitude' => '-93.6150000',
                'city' => 'Gilbert',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50312',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50313',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50321',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50320',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50021',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Ankeny',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50125',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Indianola',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50229',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Prole',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50035',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Bondurant',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50310',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50003',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Adel',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50319',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50316',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50392',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50009',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Altoona',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50109',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Granger',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50211',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5302000',
                'longitude' => '-93.6298000',
                'city' => 'Norwalk',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50430',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4404000',
                'longitude' => '-94.2951000',
                'city' => 'Corwith',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50237',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6001000',
                'longitude' => '-93.5814000',
                'city' => 'Runnells',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50556',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3842000',
                'longitude' => '-94.3055000',
                'city' => 'Ledyard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50590',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3842000',
                'longitude' => '-94.3055000',
                'city' => 'Swea City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50514',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3842000',
                'longitude' => '-94.3055000',
                'city' => 'Armstrong',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50220',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0383000',
                'longitude' => '-94.0267000',
                'city' => 'Perry',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50031',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0383000',
                'longitude' => '-94.0267000',
                'city' => 'Beaver',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50061',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5302000',
                'longitude' => '-93.6298000',
                'city' => 'Cumming',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50533',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6658000',
                'longitude' => '-93.9027000',
                'city' => 'Eagle Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50011',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0201000',
                'longitude' => '-93.6532000',
                'city' => 'Ames',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50560',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0680000',
                'longitude' => '-94.2346000',
                'city' => 'Lu Verne',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50130',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3060000',
                'longitude' => '-93.6437000',
                'city' => 'Jewell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50395',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5861000',
                'longitude' => '-93.6300000',
                'city' => 'Des Moines',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50034',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4779000',
                'longitude' => '-93.6418000',
                'city' => 'Blairsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50132',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4779000',
                'longitude' => '-93.6418000',
                'city' => 'Kamrar',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50231',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2308000',
                'longitude' => '-93.6009000',
                'city' => 'Randall',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50323',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6289000',
                'longitude' => '-93.7118000',
                'city' => 'Urbandale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50529',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7187000',
                'longitude' => '-94.2181000',
                'city' => 'Dakota City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50582',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7187000',
                'longitude' => '-94.2181000',
                'city' => 'Rutland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50541',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7187000',
                'longitude' => '-94.2181000',
                'city' => 'Gilmore City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50548',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7187000',
                'longitude' => '-94.2181000',
                'city' => 'Humboldt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50075',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3163000',
                'longitude' => '-93.5832000',
                'city' => 'Ellsworth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50543',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2728000',
                'longitude' => '-94.2928000',
                'city' => 'Gowrie',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50530',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1585000',
                'longitude' => '-94.0228000',
                'city' => 'Dayton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50223',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1585000',
                'longitude' => '-94.0228000',
                'city' => 'Pilot Mound',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50544',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2647000',
                'longitude' => '-94.1759000',
                'city' => 'Harcourt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50532',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5934000',
                'longitude' => '-94.0210000',
                'city' => 'Duncombe',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50516',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5934000',
                'longitude' => '-94.0210000',
                'city' => 'Badger',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50594',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5934000',
                'longitude' => '-94.0210000',
                'city' => 'Vincent',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50569',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3580000',
                'longitude' => '-94.0597000',
                'city' => 'Otho',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50557',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3580000',
                'longitude' => '-94.0597000',
                'city' => 'Lehigh',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50521',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3580000',
                'longitude' => '-94.0597000',
                'city' => 'Burnside',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50276',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Woodward',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50398',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Urbandale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50073',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7925000',
                'longitude' => '-93.5201000',
                'city' => 'Elkhart',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50129',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0169000',
                'longitude' => '-94.3759000',
                'city' => 'Jefferson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50225',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3929000',
                'longitude' => '-93.2665000',
                'city' => 'Pleasantville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50520',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7309000',
                'longitude' => '-94.4421000',
                'city' => 'Bradgate',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50570',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7309000',
                'longitude' => '-94.4421000',
                'city' => 'Ottosen',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50545',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6896000',
                'longitude' => '-94.0518000',
                'city' => 'Hardy',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50591',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6896000',
                'longitude' => '-94.0518000',
                'city' => 'Thor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50519',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8614000',
                'longitude' => '-94.2215000',
                'city' => 'Bode',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50558',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8614000',
                'longitude' => '-94.2215000',
                'city' => 'Livermore',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50161',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8894000',
                'longitude' => '-93.4012000',
                'city' => 'Maxwell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50230',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1677000',
                'longitude' => '-93.5035000',
                'city' => 'Radcliffe',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50236',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1677000',
                'longitude' => '-93.5035000',
                'city' => 'Roland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50050',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1516000',
                'longitude' => '-94.4786000',
                'city' => 'Churdan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51462',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1516000',
                'longitude' => '-94.4786000',
                'city' => 'Scranton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51453',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1516000',
                'longitude' => '-94.4786000',
                'city' => 'Lohrville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50277',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8409000',
                'longitude' => '-94.1031000',
                'city' => 'Yale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50066',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8409000',
                'longitude' => '-94.1031000',
                'city' => 'Dawson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50146',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8409000',
                'longitude' => '-94.1031000',
                'city' => 'Linden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50128',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8409000',
                'longitude' => '-94.1031000',
                'city' => 'Jamaica',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50278',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1650000',
                'longitude' => '-93.3900000',
                'city' => 'Zearing',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50154',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1650000',
                'longitude' => '-93.3900000',
                'city' => 'Mc Callsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50235',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9345000',
                'longitude' => '-94.2024000',
                'city' => 'Rippey',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50107',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9345000',
                'longitude' => '-94.2024000',
                'city' => 'Grand Junction',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50517',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2920000',
                'longitude' => '-94.2235000',
                'city' => 'Bancroft',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50218',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3324000',
                'longitude' => '-94.0207000',
                'city' => 'Patterson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50222',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3324000',
                'longitude' => '-94.0207000',
                'city' => 'Peru',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50240',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3324000',
                'longitude' => '-94.0207000',
                'city' => 'Saint Charles',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50586',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4528000',
                'longitude' => '-94.4570000',
                'city' => 'Somers',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50563',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4528000',
                'longitude' => '-94.4570000',
                'city' => 'Manson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50579',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4528000',
                'longitude' => '-94.4570000',
                'city' => 'Rockwell City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50552',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4528000',
                'longitude' => '-94.4570000',
                'city' => 'Knierim',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50538',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3774000',
                'longitude' => '-94.4270000',
                'city' => 'Farnhamville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50261',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Van Meter',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50156',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Madrid',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50070',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5033000',
                'longitude' => '-94.3209000',
                'city' => 'Dexter',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50250',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5033000',
                'longitude' => '-94.3209000',
                'city' => 'Stuart',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50525',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7315000',
                'longitude' => '-93.7336000',
                'city' => 'Clarion',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50451',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3731000',
                'longitude' => '-94.0991000',
                'city' => 'Lakota',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50566',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5082000',
                'longitude' => '-94.3634000',
                'city' => 'Moorland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50518',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5082000',
                'longitude' => '-94.3634000',
                'city' => 'Barnum',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50217',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2746000',
                'longitude' => '-94.4064000',
                'city' => 'Paton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50524',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5877000',
                'longitude' => '-94.3435000',
                'city' => 'Clare',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50032',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6001000',
                'longitude' => '-93.5814000',
                'city' => 'Berwick',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50124',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8913000',
                'longitude' => '-93.6022000',
                'city' => 'Huxley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50134',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8913000',
                'longitude' => '-93.6022000',
                'city' => 'Kelley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50421',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7358000',
                'longitude' => '-93.7310000',
                'city' => 'Belmond',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50577',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8287000',
                'longitude' => '-93.9820000',
                'city' => 'Renwick',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50047',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5903000',
                'longitude' => '-93.6275000',
                'city' => 'Carlisle',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50054',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6750000',
                'longitude' => '-93.2446000',
                'city' => 'Colfax',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50039',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8505000',
                'longitude' => '-94.0101000',
                'city' => 'Bouton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50167',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7565000',
                'longitude' => '-94.0320000',
                'city' => 'Minburn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50423',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0850000',
                'longitude' => '-93.9916000',
                'city' => 'Britt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50483',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0850000',
                'longitude' => '-93.9916000',
                'city' => 'Wesley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50226',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8825000',
                'longitude' => '-93.6816000',
                'city' => 'Polk City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50243',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8825000',
                'longitude' => '-93.6816000',
                'city' => 'Sheldahl',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50007',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8825000',
                'longitude' => '-93.6816000',
                'city' => 'Alleman',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50064',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0307000',
                'longitude' => '-94.2332000',
                'city' => 'Dana',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50069',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5173000',
                'longitude' => '-94.2260000',
                'city' => 'De Soto',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50152',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8737000',
                'longitude' => '-93.8215000',
                'city' => 'Luther',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50542',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8287000',
                'longitude' => '-93.9820000',
                'city' => 'Goldfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50246',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2907000',
                'longitude' => '-93.7952000',
                'city' => 'Stanhope',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50249',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2907000',
                'longitude' => '-93.7952000',
                'city' => 'Stratford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50233',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5907000',
                'longitude' => '-94.2031000',
                'city' => 'Redfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50271',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3163000',
                'longitude' => '-93.5832000',
                'city' => 'Williams',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50599',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5644000',
                'longitude' => '-93.8412000',
                'city' => 'Woolstock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50040',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1743000',
                'longitude' => '-94.1012000',
                'city' => 'Boxholm',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50252',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3867000',
                'longitude' => '-93.2635000',
                'city' => 'Swan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50138',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3867000',
                'longitude' => '-93.2635000',
                'city' => 'Knoxville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50071',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6585000',
                'longitude' => '-93.4962000',
                'city' => 'Dows',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50101',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6585000',
                'longitude' => '-93.4962000',
                'city' => 'Galt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50006',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4182000',
                'longitude' => '-93.3698000',
                'city' => 'Alden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50043',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4182000',
                'longitude' => '-93.3698000',
                'city' => 'Buckeye',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50126',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4182000',
                'longitude' => '-93.3698000',
                'city' => 'Iowa Falls',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50122',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4182000',
                'longitude' => '-93.3698000',
                'city' => 'Hubbard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50227',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5173000',
                'longitude' => '-93.3777000',
                'city' => 'Popejoy',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50597',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0587000',
                'longitude' => '-94.4247000',
                'city' => 'West Bend',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50598',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0587000',
                'longitude' => '-94.4247000',
                'city' => 'Whittemore',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50581',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9502000',
                'longitude' => '-94.4483000',
                'city' => 'Rolfe',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50528',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2160000',
                'longitude' => '-94.4267000',
                'city' => 'Cylinder',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50578',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2160000',
                'longitude' => '-94.4267000',
                'city' => 'Ringsted',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50539',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2160000',
                'longitude' => '-94.4267000',
                'city' => 'Fenton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50102',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2418000',
                'longitude' => '-93.3885000',
                'city' => 'Garden City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50522',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1990000',
                'longitude' => '-94.2176000',
                'city' => 'Burt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50480',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1990000',
                'longitude' => '-94.2176000',
                'city' => 'Titonka',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50559',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2179000',
                'longitude' => '-94.3228000',
                'city' => 'Lone Rock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50424',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2384000',
                'longitude' => '-94.0430000',
                'city' => 'Buffalo Center',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50169',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6473000',
                'longitude' => '-93.4660000',
                'city' => 'Mitchellville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50001',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3604000',
                'longitude' => '-93.5607000',
                'city' => 'Ackworth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50228',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5078000',
                'longitude' => '-93.3524000',
                'city' => 'Prairie City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50063',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6863000',
                'longitude' => '-93.7918000',
                'city' => 'Dallas Center',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50118',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5016000',
                'longitude' => '-93.4834000',
                'city' => 'Hartford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50208',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6007000',
                'longitude' => '-93.2356000',
                'city' => 'Newton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50038',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5335000',
                'longitude' => '-93.9559000',
                'city' => 'Booneville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52136',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3737000',
                'longitude' => '-92.1076000',
                'city' => 'Cresco',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52803',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5223000',
                'longitude' => '-90.5734000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52802',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5223000',
                'longitude' => '-90.5734000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52732',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8597000',
                'longitude' => '-90.1895000',
                'city' => 'Clinton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52002',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5101000',
                'longitude' => '-90.6684000',
                'city' => 'Dubuque',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52003',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5101000',
                'longitude' => '-90.6684000',
                'city' => 'Dubuque',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52070',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0664000',
                'longitude' => '-90.1763000',
                'city' => 'Sabula',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52742',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8250000',
                'longitude' => '-90.5414000',
                'city' => 'De Witt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52362',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0586000',
                'longitude' => '-91.0122000',
                'city' => 'Wyoming',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52730',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7490000',
                'longitude' => '-90.4612000',
                'city' => 'Camanche',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52758',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7490000',
                'longitude' => '-90.4612000',
                'city' => 'Mc Causland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52756',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7490000',
                'longitude' => '-90.4612000',
                'city' => 'Long Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52768',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7490000',
                'longitude' => '-90.4612000',
                'city' => 'Princeton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52060',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Maquoketa',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52033',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Cascade',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52154',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0688000',
                'longitude' => '-92.1571000',
                'city' => 'Lawler',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50659',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0688000',
                'longitude' => '-92.1571000',
                'city' => 'New Hampton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52171',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0688000',
                'longitude' => '-92.1571000',
                'city' => 'Waucoma',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52043',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8559000',
                'longitude' => '-91.4023000',
                'city' => 'Elkader',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52044',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8559000',
                'longitude' => '-91.4023000',
                'city' => 'Elkport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52049',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8559000',
                'longitude' => '-91.4023000',
                'city' => 'Garnavillo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52072',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8559000',
                'longitude' => '-91.4023000',
                'city' => 'Saint Olaf',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52077',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8559000',
                'longitude' => '-91.4023000',
                'city' => 'Volga',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52254',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8233000',
                'longitude' => '-90.7613000',
                'city' => 'Lost Nation',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52037',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8233000',
                'longitude' => '-90.7613000',
                'city' => 'Delmar',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52729',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8233000',
                'longitude' => '-90.7613000',
                'city' => 'Calamus',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52751',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8233000',
                'longitude' => '-90.7613000',
                'city' => 'Grand Mound',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52052',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7831000',
                'longitude' => '-91.0972000',
                'city' => 'Guttenberg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52035',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7831000',
                'longitude' => '-91.0972000',
                'city' => 'Colesburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52048',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7831000',
                'longitude' => '-91.0972000',
                'city' => 'Garber',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52042',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7831000',
                'longitude' => '-91.0972000',
                'city' => 'Edgewood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52749',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4236000',
                'longitude' => '-91.0454000',
                'city' => 'Fruitland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52748',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6934000',
                'longitude' => '-90.6753000',
                'city' => 'Eldridge',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52746',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6934000',
                'longitude' => '-90.6753000',
                'city' => 'Donahue',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52745',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6934000',
                'longitude' => '-90.6753000',
                'city' => 'Dixon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52773',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6934000',
                'longitude' => '-90.6753000',
                'city' => 'Walcott',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52769',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5856000',
                'longitude' => '-90.7730000',
                'city' => 'Stockton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52804',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6552000',
                'longitude' => '-90.5839000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52753',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6132000',
                'longitude' => '-90.3452000',
                'city' => 'Le Claire',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52722',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6132000',
                'longitude' => '-90.3452000',
                'city' => 'Bettendorf',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52801',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5243000',
                'longitude' => '-90.5787000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52805',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5243000',
                'longitude' => '-90.5787000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52807',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5243000',
                'longitude' => '-90.5787000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52809',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5243000',
                'longitude' => '-90.5787000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52172',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Waukon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52806',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5223000',
                'longitude' => '-90.5734000',
                'city' => 'Davenport',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52144',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1411000',
                'longitude' => '-91.9377000',
                'city' => 'Fort Atkinson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52255',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8325000',
                'longitude' => '-90.8443000',
                'city' => 'Lowden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52777',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8325000',
                'longitude' => '-90.8443000',
                'city' => 'Wheatland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52101',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2988000',
                'longitude' => '-91.7880000',
                'city' => 'Decorah',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52728',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5107000',
                'longitude' => '-90.7668000',
                'city' => 'Buffalo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52726',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5107000',
                'longitude' => '-90.7668000',
                'city' => 'Blue Grass',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52175',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'West Union',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52141',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0011000',
                'longitude' => '-91.6541000',
                'city' => 'Elgin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52162',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0011000',
                'longitude' => '-91.6541000',
                'city' => 'Postville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52133',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0011000',
                'longitude' => '-91.6541000',
                'city' => 'Castalia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52135',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0011000',
                'longitude' => '-91.6541000',
                'city' => 'Clermont',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52142',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8437000',
                'longitude' => '-91.8042000',
                'city' => 'Fayette',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52169',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8437000',
                'longitude' => '-91.8042000',
                'city' => 'Wadena',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50606',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8437000',
                'longitude' => '-91.8042000',
                'city' => 'Arlington',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52164',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8629000',
                'longitude' => '-91.8883000',
                'city' => 'Randalia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52054',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2934000',
                'longitude' => '-90.6247000',
                'city' => 'La Motte',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52772',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9170000',
                'longitude' => '-91.2603000',
                'city' => 'Tipton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52216',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5101000',
                'longitude' => '-90.6684000',
                'city' => 'Clarence',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52321',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1061000',
                'longitude' => '-91.0149000',
                'city' => 'Onslow',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52212',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1177000',
                'longitude' => '-91.0903000',
                'city' => 'Center Junction',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52309',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0608000',
                'longitude' => '-91.0041000',
                'city' => 'Monmouth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '55974',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5593000',
                'longitude' => '-91.6385000',
                'city' => 'Spring Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52140',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5593000',
                'longitude' => '-91.6385000',
                'city' => 'Dorchester',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52160',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5123000',
                'longitude' => '-91.4597000',
                'city' => 'New Albin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52757',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8034000',
                'longitude' => '-90.3576000',
                'city' => 'Low Moor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52727',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8034000',
                'longitude' => '-90.3576000',
                'city' => 'Bryant',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52750',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8034000',
                'longitude' => '-90.3576000',
                'city' => 'Goose Lake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52161',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1462000',
                'longitude' => '-91.7614000',
                'city' => 'Ossian',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52132',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1453000',
                'longitude' => '-91.9350000',
                'city' => 'Calmar',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52146',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2065000',
                'longitude' => '-91.2907000',
                'city' => 'Harpers Ferry',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52159',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2065000',
                'longitude' => '-91.2907000',
                'city' => 'Monona',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52156',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2065000',
                'longitude' => '-91.2907000',
                'city' => 'Luana',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52170',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2065000',
                'longitude' => '-91.2907000',
                'city' => 'Waterville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52157',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9535000',
                'longitude' => '-91.3737000',
                'city' => 'Mc Gregor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52047',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9535000',
                'longitude' => '-91.3737000',
                'city' => 'Farmersburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52149',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4431000',
                'longitude' => '-91.6724000',
                'city' => 'Highlandville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52155',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3715000',
                'longitude' => '-92.1160000',
                'city' => 'Lime Springs',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52039',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6044000',
                'longitude' => '-90.7721000',
                'city' => 'Durango',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52001',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6044000',
                'longitude' => '-90.7721000',
                'city' => 'Dubuque',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52053',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6044000',
                'longitude' => '-90.7721000',
                'city' => 'Holy Cross',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52073',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6044000',
                'longitude' => '-90.7721000',
                'city' => 'Sherrill',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52068',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5018000',
                'longitude' => '-90.6738000',
                'city' => 'Peosta',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52168',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1837000',
                'longitude' => '-91.8689000',
                'city' => 'Spillville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52165',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1837000',
                'longitude' => '-91.8689000',
                'city' => 'Ridgeway',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52134',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4907000',
                'longitude' => '-92.3592000',
                'city' => 'Chester',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52163',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2148000',
                'longitude' => '-92.0913000',
                'city' => 'Protivin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52731',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9663000',
                'longitude' => '-90.3796000',
                'city' => 'Charlotte',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50681',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8485000',
                'longitude' => '-92.0974000',
                'city' => 'Westgate',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52057',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4810000',
                'longitude' => '-91.4587000',
                'city' => 'Manchester',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50655',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7741000',
                'longitude' => '-91.8836000',
                'city' => 'Maynard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52720',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5709000',
                'longitude' => '-91.1686000',
                'city' => 'Atalissa',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52030',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1510000',
                'longitude' => '-90.6013000',
                'city' => 'Andrew',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52074',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1510000',
                'longitude' => '-90.6013000',
                'city' => 'Spragueville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52031',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1510000',
                'longitude' => '-90.6013000',
                'city' => 'Bellevue',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52207',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0748000',
                'longitude' => '-90.8438000',
                'city' => 'Baldwin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52701',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0493000',
                'longitude' => '-90.3250000',
                'city' => 'Andover',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52064',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0493000',
                'longitude' => '-90.3250000',
                'city' => 'Miles',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52079',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2392000',
                'longitude' => '-90.6877000',
                'city' => 'Zwingle',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52075',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0510000',
                'longitude' => '-90.3993000',
                'city' => 'Springbrook',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52069',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0510000',
                'longitude' => '-90.3993000',
                'city' => 'Preston',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52778',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5760000',
                'longitude' => '-91.0845000',
                'city' => 'Wilton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52760',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5760000',
                'longitude' => '-91.0845000',
                'city' => 'Moscow',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52040',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4430000',
                'longitude' => '-91.0085000',
                'city' => 'Dyersville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52046',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4430000',
                'longitude' => '-91.0085000',
                'city' => 'Farley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52076',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7981000',
                'longitude' => '-91.5432000',
                'city' => 'Strawberry Point',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52071',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3079000',
                'longitude' => '-90.6221000',
                'city' => 'Saint Donatus',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52166',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0668000',
                'longitude' => '-91.9299000',
                'city' => 'Saint Lucas',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52765',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7443000',
                'longitude' => '-90.7849000',
                'city' => 'New Liberty',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52032',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2964000',
                'longitude' => '-91.0155000',
                'city' => 'Bernard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52065',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6015000',
                'longitude' => '-91.0775000',
                'city' => 'New Vienna',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52056',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6015000',
                'longitude' => '-91.0775000',
                'city' => 'Luxemburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52078',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4007000',
                'longitude' => '-91.1196000',
                'city' => 'Worthington',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52050',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6414000',
                'longitude' => '-91.2032000',
                'city' => 'Greeley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52041',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6414000',
                'longitude' => '-91.2032000',
                'city' => 'Earlville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52066',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6023000',
                'longitude' => '-90.9942000',
                'city' => 'North Buena Vista',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52158',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0177000',
                'longitude' => '-91.1781000',
                'city' => 'Marquette',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '55939',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5553000',
                'longitude' => '-92.0109000',
                'city' => 'Harmony',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52721',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7408000',
                'longitude' => '-90.9723000',
                'city' => 'Bennett',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52036',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4311000',
                'longitude' => '-91.3331000',
                'city' => 'Delaware',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52223',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4311000',
                'longitude' => '-91.3331000',
                'city' => 'Delhi',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52237',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4836000',
                'longitude' => '-91.2651000',
                'city' => 'Hopkinton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52038',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6023000',
                'longitude' => '-91.6418000',
                'city' => 'Dundee',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52330',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3501000',
                'longitude' => '-91.4818000',
                'city' => 'Ryan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '61240',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5223000',
                'longitude' => '-90.5734000',
                'city' => 'Coal Valley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '61254',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5223000',
                'longitude' => '-90.5734000',
                'city' => 'Geneseo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50401',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1491000',
                'longitude' => '-93.2037000',
                'city' => 'Mason City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50801',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0587000',
                'longitude' => '-94.3651000',
                'city' => 'Creston',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50049',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0146000',
                'longitude' => '-93.3063000',
                'city' => 'Chariton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50219',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4090000',
                'longitude' => '-92.9153000',
                'city' => 'Pella',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52537',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7491000',
                'longitude' => '-92.4141000',
                'city' => 'Bloomfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50449',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Klemme',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50460',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2824000',
                'longitude' => '-92.6485000',
                'city' => 'Orchard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52544',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7254000',
                'longitude' => '-92.8671000',
                'city' => 'Centerville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50616',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0673000',
                'longitude' => '-92.6764000',
                'city' => 'Charles City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50849',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3091000',
                'longitude' => '-94.4670000',
                'city' => 'Greenfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50213',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0346000',
                'longitude' => '-93.7663000',
                'city' => 'Osceola',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52553',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1576000',
                'longitude' => '-92.6327000',
                'city' => 'Eddyville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52501',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0223000',
                'longitude' => '-92.4076000',
                'city' => 'Ottumwa',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50234',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8266000',
                'longitude' => '-93.1532000',
                'city' => 'Rhodes',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50055',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8266000',
                'longitude' => '-93.1532000',
                'city' => 'Collins',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50028',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8266000',
                'longitude' => '-93.1532000',
                'city' => 'Baxter',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50428',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1359000',
                'longitude' => '-93.3765000',
                'city' => 'Clear Lake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50143',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3422000',
                'longitude' => '-92.7816000',
                'city' => 'Leighton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52567',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0087000',
                'longitude' => '-91.9678000',
                'city' => 'Libertyville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50854',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7154000',
                'longitude' => '-94.2457000',
                'city' => 'Mount Ayr',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50135',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7450000',
                'longitude' => '-92.7244000',
                'city' => 'Kellogg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50112',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7450000',
                'longitude' => '-92.7244000',
                'city' => 'Grinnell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50447',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7491000',
                'longitude' => '-92.4141000',
                'city' => 'Kanawha',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50436',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2582000',
                'longitude' => '-93.6382000',
                'city' => 'Forest City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50214',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5239000',
                'longitude' => '-93.1007000',
                'city' => 'Otley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50170',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5239000',
                'longitude' => '-93.1007000',
                'city' => 'Monroe',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50454',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3832000',
                'longitude' => '-92.7182000',
                'city' => 'Little Cedar',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50459',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4987000',
                'longitude' => '-93.4898000',
                'city' => 'Northwood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50450',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4987000',
                'longitude' => '-93.4898000',
                'city' => 'Lake Mills',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '56029',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4987000',
                'longitude' => '-93.4898000',
                'city' => 'Emmons',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52577',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2981000',
                'longitude' => '-92.6409000',
                'city' => 'Oskaloosa',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50210',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3072000',
                'longitude' => '-93.7353000',
                'city' => 'New Virginia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50241',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3072000',
                'longitude' => '-93.7353000',
                'city' => 'Saint Marys',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50478',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4737000',
                'longitude' => '-93.6927000',
                'city' => 'Thompson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50653',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9660000',
                'longitude' => '-92.8557000',
                'city' => 'Marble Rock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50841',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9913000',
                'longitude' => '-94.7414000',
                'city' => 'Corning',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50472',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4440000',
                'longitude' => '-93.2185000',
                'city' => 'Saint Ansgar',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50481',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5071000',
                'longitude' => '-92.9361000',
                'city' => 'Toeterville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '55951',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5145000',
                'longitude' => '-92.5047000',
                'city' => 'Le Roy',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50466',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5145000',
                'longitude' => '-92.5047000',
                'city' => 'Riceville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50455',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5145000',
                'longitude' => '-92.5047000',
                'city' => 'Mc Intire',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50115',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6822000',
                'longitude' => '-94.5108000',
                'city' => 'Guthrie Center',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50851',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8827000',
                'longitude' => '-94.5655000',
                'city' => 'Lenox',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50002',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0238000',
                'longitude' => '-94.6105000',
                'city' => 'Adair',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50859',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0238000',
                'longitude' => '-94.6105000',
                'city' => 'Prescott',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50845',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7974000',
                'longitude' => '-94.4757000',
                'city' => 'Diagonal',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50833',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7974000',
                'longitude' => '-94.4757000',
                'city' => 'Bedford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50840',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7974000',
                'longitude' => '-94.4757000',
                'city' => 'Clearfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50858',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1971000',
                'longitude' => '-94.4187000',
                'city' => 'Orient',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50254',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0293000',
                'longitude' => '-94.0506000',
                'city' => 'Thayer',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50174',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0293000',
                'longitude' => '-94.0506000',
                'city' => 'Murray',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50830',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0293000',
                'longitude' => '-94.0506000',
                'city' => 'Afton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50861',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8990000',
                'longitude' => '-94.2653000',
                'city' => 'Shannon City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50275',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0346000',
                'longitude' => '-93.7663000',
                'city' => 'Woodburn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50846',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3030000',
                'longitude' => '-94.4638000',
                'city' => 'Fontanelle',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50831',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9485000',
                'longitude' => '-94.2169000',
                'city' => 'Arispe',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50149',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0321000',
                'longitude' => '-94.1949000',
                'city' => 'Lorimor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50862',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7986000',
                'longitude' => '-94.6465000',
                'city' => 'Sharpsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50448',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3514000',
                'longitude' => '-93.2161000',
                'city' => 'Kensett',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50457',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9096000',
                'longitude' => '-93.4735000',
                'city' => 'Meservey',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50479',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9096000',
                'longitude' => '-93.4735000',
                'city' => 'Thornton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50127',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7690000',
                'longitude' => '-93.2821000',
                'city' => 'Ira',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50168',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7690000',
                'longitude' => '-93.2821000',
                'city' => 'Mingo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50628',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1999000',
                'longitude' => '-92.4197000',
                'city' => 'Elma',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50603',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1999000',
                'longitude' => '-92.4197000',
                'city' => 'Alta Vista',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50609',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2232000',
                'longitude' => '-92.8712000',
                'city' => 'Beaman',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50621',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2232000',
                'longitude' => '-92.8712000',
                'city' => 'Conrad',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50837',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2466000',
                'longitude' => '-94.6756000',
                'city' => 'Bridgewater',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50020',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2466000',
                'longitude' => '-94.6756000',
                'city' => 'Anita',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50469',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9820000',
                'longitude' => '-93.1898000',
                'city' => 'Rockwell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50056',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0189000',
                'longitude' => '-93.3000000',
                'city' => 'Colo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50458',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1281000',
                'longitude' => '-92.9005000',
                'city' => 'Nora Springs',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50435',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1281000',
                'longitude' => '-92.9005000',
                'city' => 'Floyd',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50468',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1281000',
                'longitude' => '-92.9005000',
                'city' => 'Rockford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50471',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1281000',
                'longitude' => '-92.9005000',
                'city' => 'Rudd',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50058',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8471000',
                'longitude' => '-94.4282000',
                'city' => 'Coon Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50029',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8471000',
                'longitude' => '-94.4282000',
                'city' => 'Bayard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50026',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8471000',
                'longitude' => '-94.4282000',
                'city' => 'Bagley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50268',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4000000',
                'longitude' => '-92.3503000',
                'city' => 'What Cheer',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52574',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7254000',
                'longitude' => '-92.8671000',
                'city' => 'Mystic',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50216',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7732000',
                'longitude' => '-94.3574000',
                'city' => 'Panora',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50065',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6341000',
                'longitude' => '-93.8109000',
                'city' => 'Davis City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50067',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6341000',
                'longitude' => '-93.8109000',
                'city' => 'Decatur',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50144',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6341000',
                'longitude' => '-93.8109000',
                'city' => 'Leon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50123',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8228000',
                'longitude' => '-93.6056000',
                'city' => 'Humeston',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50264',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8228000',
                'longitude' => '-93.6056000',
                'city' => 'Weldon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50103',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8228000',
                'longitude' => '-93.6056000',
                'city' => 'Garden Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50262',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8971000',
                'longitude' => '-93.7342000',
                'city' => 'Van Wert',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50108',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0412000',
                'longitude' => '-93.9508000',
                'city' => 'Grand River',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52571',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8188000',
                'longitude' => '-92.6979000',
                'city' => 'Moravia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52594',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8188000',
                'longitude' => '-92.6979000',
                'city' => 'Unionville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52593',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8188000',
                'longitude' => '-92.6979000',
                'city' => 'Udell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50461',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2899000',
                'longitude' => '-93.1985000',
                'city' => 'Osage',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50456',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2899000',
                'longitude' => '-93.1985000',
                'city' => 'Manly',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50453',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3329000',
                'longitude' => '-93.6340000',
                'city' => 'Leland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50633',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7437000',
                'longitude' => '-93.2058000',
                'city' => 'Geneva',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52560',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8649000',
                'longitude' => '-92.3235000',
                'city' => 'Floris',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50145',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2030000',
                'longitude' => '-93.5007000',
                'city' => 'Liberty Center',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50151',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2030000',
                'longitude' => '-93.5007000',
                'city' => 'Lucas',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50139',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2030000',
                'longitude' => '-93.5007000',
                'city' => 'Lacona',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50166',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2030000',
                'longitude' => '-93.5007000',
                'city' => 'Milo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50652',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1922000',
                'longitude' => '-92.7070000',
                'city' => 'Lincoln',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50632',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1922000',
                'longitude' => '-92.7070000',
                'city' => 'Garwin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50162',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9501000',
                'longitude' => '-92.9501000',
                'city' => 'Melbourne',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50141',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9501000',
                'longitude' => '-92.9501000',
                'city' => 'Laurel',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50120',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9501000',
                'longitude' => '-92.9501000',
                'city' => 'Haverhill',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50106',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8847000',
                'longitude' => '-92.9224000',
                'city' => 'Gilman',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50247',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1182000',
                'longitude' => '-93.1588000',
                'city' => 'State Center',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50005',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1182000',
                'longitude' => '-93.1588000',
                'city' => 'Albion',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50206',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1182000',
                'longitude' => '-93.1588000',
                'city' => 'New Providence',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50051',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1182000',
                'longitude' => '-93.1588000',
                'city' => 'Clemons',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50239',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1182000',
                'longitude' => '-93.1588000',
                'city' => 'Saint Anthony',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50078',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9443000',
                'longitude' => '-92.8591000',
                'city' => 'Ferguson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52342',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9443000',
                'longitude' => '-92.8591000',
                'city' => 'Toledo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50142',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0064000',
                'longitude' => '-92.7737000',
                'city' => 'Le Grand',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50173',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0064000',
                'longitude' => '-92.7737000',
                'city' => 'Montour',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52339',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9863000',
                'longitude' => '-92.5830000',
                'city' => 'Tama',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50269',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2513000',
                'longitude' => '-93.0575000',
                'city' => 'Whitten',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50259',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2513000',
                'longitude' => '-93.0575000',
                'city' => 'Gifford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50627',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2513000',
                'longitude' => '-93.0575000',
                'city' => 'Eldora',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50258',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2513000',
                'longitude' => '-93.0575000',
                'city' => 'Union',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52348',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9244000',
                'longitude' => '-92.3909000',
                'city' => 'Vining',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50402',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1514000',
                'longitude' => '-93.1954000',
                'city' => 'Mason City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50439',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9259000',
                'longitude' => '-93.6138000',
                'city' => 'Goodell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50148',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2012000',
                'longitude' => '-92.9999000',
                'city' => 'Liscomb',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50157',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7331000',
                'longitude' => '-92.4415000',
                'city' => 'Malcom',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50164',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5226000',
                'longitude' => '-94.4098000',
                'city' => 'Menlo',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50048',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5226000',
                'longitude' => '-94.4098000',
                'city' => 'Casey',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50242',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5741000',
                'longitude' => '-92.7748000',
                'city' => 'Searsboro',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50153',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5741000',
                'longitude' => '-92.7748000',
                'city' => 'Lynnville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50068',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9291000',
                'longitude' => '-93.4567000',
                'city' => 'Derby',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52569',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9830000',
                'longitude' => '-93.1979000',
                'city' => 'Melrose',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50238',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9830000',
                'longitude' => '-93.1979000',
                'city' => 'Russell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50432',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2223000',
                'longitude' => '-93.7903000',
                'city' => 'Crystal Lake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50465',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4828000',
                'longitude' => '-93.9211000',
                'city' => 'Rake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50473',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4698000',
                'longitude' => '-93.6194000',
                'city' => 'Scarville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50420',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7679000',
                'longitude' => '-93.3685000',
                'city' => 'Alexander',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50452',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7679000',
                'longitude' => '-93.3685000',
                'city' => 'Latimer',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50438',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0071000',
                'longitude' => '-93.5988000',
                'city' => 'Garner',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50444',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3610000',
                'longitude' => '-93.4587000',
                'city' => 'Hanlontown',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50446',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3610000',
                'longitude' => '-93.4587000',
                'city' => 'Joice',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50251',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5765000',
                'longitude' => '-92.8406000',
                'city' => 'Sully',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50171',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5773000',
                'longitude' => '-92.3757000',
                'city' => 'Montezuma',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52550',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3241000',
                'longitude' => '-92.3231000',
                'city' => 'Delta',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50207',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4597000',
                'longitude' => '-92.7974000',
                'city' => 'New Sharon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52561',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3230000',
                'longitude' => '-92.4648000',
                'city' => 'Fremont',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52586',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3230000',
                'longitude' => '-92.4648000',
                'city' => 'Rose Hill',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50104',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4000000',
                'longitude' => '-92.3503000',
                'city' => 'Gibson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50255',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4000000',
                'longitude' => '-92.3503000',
                'city' => 'Thornburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52231',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3607000',
                'longitude' => '-92.0517000',
                'city' => 'Harper',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52572',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6847000',
                'longitude' => '-92.6791000',
                'city' => 'Moulton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50027',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5054000',
                'longitude' => '-92.4469000',
                'city' => 'Barnes City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52583',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7577000',
                'longitude' => '-93.0468000',
                'city' => 'Promise City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52581',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7577000',
                'longitude' => '-93.0468000',
                'city' => 'Plano',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52554',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9189000',
                'longitude' => '-92.2171000',
                'city' => 'Eldon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52555',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6286000',
                'longitude' => '-92.9250000',
                'city' => 'Exline',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52549',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6286000',
                'longitude' => '-92.9250000',
                'city' => 'Cincinnati',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52534',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2981000',
                'longitude' => '-92.6409000',
                'city' => 'Beacon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52568',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1767000',
                'longitude' => '-92.2527000',
                'city' => 'Martinsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52595',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2962000',
                'longitude' => '-92.6354000',
                'city' => 'University Park',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52584',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6985000',
                'longitude' => '-92.2719000',
                'city' => 'Pulaski',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52551',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6985000',
                'longitude' => '-92.2719000',
                'city' => 'Douds',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50464',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2444000',
                'longitude' => '-93.1236000',
                'city' => 'Plymouth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50467',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2444000',
                'longitude' => '-93.1236000',
                'city' => 'Rock Falls',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50476',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4299000',
                'longitude' => '-92.7848000',
                'city' => 'Stacyville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52552',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8014000',
                'longitude' => '-92.4755000',
                'city' => 'Drakesville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52531',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8945000',
                'longitude' => '-92.8120000',
                'city' => 'Albia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50257',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2259000',
                'longitude' => '-93.9299000',
                'city' => 'Truro',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50426',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3742000',
                'longitude' => '-92.9186000',
                'city' => 'Carpenter',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50232',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6038000',
                'longitude' => '-92.9047000',
                'city' => 'Reasnor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50440',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3286000',
                'longitude' => '-93.0691000',
                'city' => 'Grafton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50160',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3711000',
                'longitude' => '-93.7443000',
                'city' => 'Martensdale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50860',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6020000',
                'longitude' => '-94.3898000',
                'city' => 'Redding',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50155',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2164000',
                'longitude' => '-94.1883000',
                'city' => 'Macksburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50863',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8499000',
                'longitude' => '-94.1945000',
                'city' => 'Tingley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50133',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8499000',
                'longitude' => '-94.1945000',
                'city' => 'Kellerton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50074',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8499000',
                'longitude' => '-94.1945000',
                'city' => 'Ellston',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50611',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7745000',
                'longitude' => '-92.9067000',
                'city' => 'Bristow',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50625',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7745000',
                'longitude' => '-92.9067000',
                'city' => 'Dumont',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50140',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7103000',
                'longitude' => '-94.0506000',
                'city' => 'Lamoni',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50835',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7027000',
                'longitude' => '-94.3585000',
                'city' => 'Benton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50836',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7027000',
                'longitude' => '-94.3585000',
                'city' => 'Blockton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50433',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9238000',
                'longitude' => '-93.0474000',
                'city' => 'Dougherty',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50475',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9238000',
                'longitude' => '-93.0474000',
                'city' => 'Sheffield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50434',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2670000',
                'longitude' => '-93.4199000',
                'city' => 'Fertile',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50137',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6038000',
                'longitude' => '-92.9047000',
                'city' => 'Killduff',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52543',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0223000',
                'longitude' => '-92.4076000',
                'city' => 'Cedar',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50482',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1330000',
                'longitude' => '-93.4743000',
                'city' => 'Ventura',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50470',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7418000',
                'longitude' => '-93.5480000',
                'city' => 'Rowan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50605',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7501000',
                'longitude' => '-92.9696000',
                'city' => 'Aredale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50672',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3577000',
                'longitude' => '-93.1011000',
                'city' => 'Steamboat Rock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50272',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0871000',
                'longitude' => '-93.2490000',
                'city' => 'Williamson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50431',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7679000',
                'longitude' => '-93.3685000',
                'city' => 'Coulter',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50680',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4348000',
                'longitude' => '-92.9248000',
                'city' => 'Wellsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50060',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7577000',
                'longitude' => '-93.3127000',
                'city' => 'Corydon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50008',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7554000',
                'longitude' => '-93.3207000',
                'city' => 'Allerton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50052',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7105000',
                'longitude' => '-93.3672000',
                'city' => 'Clio',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52590',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7465000',
                'longitude' => '-93.1463000',
                'city' => 'Seymour',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50147',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.5916000',
                'longitude' => '-93.5232000',
                'city' => 'Lineville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50165',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8511000',
                'longitude' => '-93.3038000',
                'city' => 'Millerton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50484',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2306000',
                'longitude' => '-93.9104000',
                'city' => 'Woden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52566',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2119000',
                'longitude' => '-92.4389000',
                'city' => 'Kirkville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52530',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0736000',
                'longitude' => '-92.2357000',
                'city' => 'Agency',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52548',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0857000',
                'longitude' => '-92.5294000',
                'city' => 'Chillicothe',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52588',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8410000',
                'longitude' => '-92.0846000',
                'city' => 'Selma',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '52536',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9609000',
                'longitude' => '-92.6385000',
                'city' => 'Blakesburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50044',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1955000',
                'longitude' => '-93.0774000',
                'city' => 'Bussey',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50116',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1955000',
                'longitude' => '-93.0774000',
                'city' => 'Hamilton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50057',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1955000',
                'longitude' => '-93.0774000',
                'city' => 'Columbia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50150',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1955000',
                'longitude' => '-93.0774000',
                'city' => 'Lovilia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50163',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2218000',
                'longitude' => '-93.2419000',
                'city' => 'Melcher',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50062',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2218000',
                'longitude' => '-93.2419000',
                'city' => 'Dallas',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '56027',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5041000',
                'longitude' => '-94.0818000',
                'city' => 'Elmore',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50119',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2777000',
                'longitude' => '-92.8742000',
                'city' => 'Harvey',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50256',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2777000',
                'longitude' => '-92.8742000',
                'city' => 'Tracy',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50477',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9742000',
                'longitude' => '-93.3178000',
                'city' => 'Swaledale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51002',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6735000',
                'longitude' => '-95.3024000',
                'city' => 'Alta',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51105',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5009000',
                'longitude' => '-96.4096000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51103',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5009000',
                'longitude' => '-96.4096000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51570',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5164000',
                'longitude' => '-95.4447000',
                'city' => 'Shelby',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51034',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1671000',
                'longitude' => '-95.7853000',
                'city' => 'Mapleton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51334',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4007000',
                'longitude' => '-94.8309000',
                'city' => 'Estherville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51436',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1325000',
                'longitude' => '-94.7925000',
                'city' => 'Breda',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51443',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1325000',
                'longitude' => '-94.7925000',
                'city' => 'Glidden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50588',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6409000',
                'longitude' => '-95.1995000',
                'city' => 'Storm Lake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51601',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7656000',
                'longitude' => '-95.3756000',
                'city' => 'Shenandoah',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51546',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6489000',
                'longitude' => '-95.7820000',
                'city' => 'Logan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51040',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0242000',
                'longitude' => '-96.0988000',
                'city' => 'Onawa',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51552',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0652000',
                'longitude' => '-94.8650000',
                'city' => 'Marne',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51012',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7730000',
                'longitude' => '-95.6510000',
                'city' => 'Cherokee',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51101',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4421000',
                'longitude' => '-96.3483000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51106',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4421000',
                'longitude' => '-96.3483000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51104',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4999000',
                'longitude' => '-96.3900000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51102',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4999000',
                'longitude' => '-96.3900000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51526',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3655000',
                'longitude' => '-95.8534000',
                'city' => 'Crescent',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51054',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4001000',
                'longitude' => '-96.3582000',
                'city' => 'Sergeant Bluff',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51238',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0732000',
                'longitude' => '-95.9068000',
                'city' => 'Hospers',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51109',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4992000',
                'longitude' => '-96.4038000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51537',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6572000',
                'longitude' => '-95.3188000',
                'city' => 'Harlan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51024',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5385000',
                'longitude' => '-96.3687000',
                'city' => 'Hinton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51108',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5385000',
                'longitude' => '-96.3687000',
                'city' => 'Sioux City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51343',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1409000',
                'longitude' => '-95.1405000',
                'city' => 'Greenville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51503',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2664000',
                'longitude' => '-96.0795000',
                'city' => 'Council Bluffs',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50022',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4019000',
                'longitude' => '-95.0116000',
                'city' => 'Atlantic',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51639',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7698000',
                'longitude' => '-95.3732000',
                'city' => 'Farragut',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51510',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2573000',
                'longitude' => '-95.9394000',
                'city' => 'Carter Lake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50025',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4061000',
                'longitude' => '-95.0092000',
                'city' => 'Audubon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51638',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4061000',
                'longitude' => '-95.0092000',
                'city' => 'Essex',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51501',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2614000',
                'longitude' => '-96.0954000',
                'city' => 'Council Bluffs',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51301',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1409000',
                'longitude' => '-95.1405000',
                'city' => 'Spencer',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51441',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0143000',
                'longitude' => '-95.3498000',
                'city' => 'Deloit',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51442',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0143000',
                'longitude' => '-95.3498000',
                'city' => 'Denison',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50042',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5902000',
                'longitude' => '-94.8775000',
                'city' => 'Brayton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50076',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5902000',
                'longitude' => '-94.8775000',
                'city' => 'Exira',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51360',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1409000',
                'longitude' => '-95.1405000',
                'city' => 'Spirit Lake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50568',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6041000',
                'longitude' => '-95.0045000',
                'city' => 'Newell',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51445',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4649000',
                'longitude' => '-95.1525000',
                'city' => 'Ida Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51458',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4649000',
                'longitude' => '-95.1525000',
                'city' => 'Odebolt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50535',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4649000',
                'longitude' => '-95.1525000',
                'city' => 'Early',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51053',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4998000',
                'longitude' => '-95.2942000',
                'city' => 'Schaller',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51023',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9728000',
                'longitude' => '-96.3154000',
                'city' => 'Hawarden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51027',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9728000',
                'longitude' => '-96.3154000',
                'city' => 'Ireton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51031',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9728000',
                'longitude' => '-96.3154000',
                'city' => 'Le Mars',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51020',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5025000',
                'longitude' => '-95.4140000',
                'city' => 'Galva',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51005',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5025000',
                'longitude' => '-95.4140000',
                'city' => 'Aurelia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51025',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5025000',
                'longitude' => '-95.4140000',
                'city' => 'Holstein',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50585',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8919000',
                'longitude' => '-95.1492000',
                'city' => 'Sioux Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50510',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8919000',
                'longitude' => '-95.1492000',
                'city' => 'Albert City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50576',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8268000',
                'longitude' => '-95.1665000',
                'city' => 'Rembrandt',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50593',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5839000',
                'longitude' => '-94.8471000',
                'city' => 'Varina',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50574',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5839000',
                'longitude' => '-94.8471000',
                'city' => 'Pocahontas',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50540',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5839000',
                'longitude' => '-94.8471000',
                'city' => 'Fonda',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50565',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8598000',
                'longitude' => '-94.9846000',
                'city' => 'Marathon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51401',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0652000',
                'longitude' => '-94.8650000',
                'city' => 'Carroll',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51047',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9182000',
                'longitude' => '-95.3444000',
                'city' => 'Peterson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51033',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9182000',
                'longitude' => '-95.3444000',
                'city' => 'Linn Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51058',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9182000',
                'longitude' => '-95.3444000',
                'city' => 'Sutherland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50551',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3940000',
                'longitude' => '-94.6335000',
                'city' => 'Jolley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51632',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7340000',
                'longitude' => '-95.0319000',
                'city' => 'Clarinda',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51521',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4822000',
                'longitude' => '-95.3379000',
                'city' => 'Avoca',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51652',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7497000',
                'longitude' => '-95.6533000',
                'city' => 'Sidney',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51201',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1817000',
                'longitude' => '-95.8519000',
                'city' => 'Sheldon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51566',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0089000',
                'longitude' => '-95.2266000',
                'city' => 'Red Oak',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51355',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4245000',
                'longitude' => '-95.0978000',
                'city' => 'Okoboji',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51331',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4245000',
                'longitude' => '-95.0978000',
                'city' => 'Arnolds Park',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51351',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3717000',
                'longitude' => '-95.1219000',
                'city' => 'Milford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51237',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2418000',
                'longitude' => '-95.9333000',
                'city' => 'George',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51016',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4824000',
                'longitude' => '-95.7821000',
                'city' => 'Correctionville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51345',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4426000',
                'longitude' => '-95.4294000',
                'city' => 'Harris',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51347',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4426000',
                'longitude' => '-95.4294000',
                'city' => 'Lake Park',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51640',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6063000',
                'longitude' => '-95.6602000',
                'city' => 'Hamburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50546',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8345000',
                'longitude' => '-94.7004000',
                'city' => 'Havelock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51502',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2641000',
                'longitude' => '-95.8499000',
                'city' => 'Council Bluffs',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51558',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0714000',
                'longitude' => '-95.9124000',
                'city' => 'Moorhead',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51010',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0714000',
                'longitude' => '-95.9124000',
                'city' => 'Castana',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50575',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6295000',
                'longitude' => '-94.5969000',
                'city' => 'Pomeroy',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50571',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6295000',
                'longitude' => '-94.5969000',
                'city' => 'Palmer',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51041',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9991000',
                'longitude' => '-96.0572000',
                'city' => 'Orange City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51019',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3152000',
                'longitude' => '-95.6012000',
                'city' => 'Danbury',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51006',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3152000',
                'longitude' => '-95.6012000',
                'city' => 'Battle Creek',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51431',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3339000',
                'longitude' => '-95.3421000',
                'city' => 'Arthur',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51573',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0089000',
                'longitude' => '-95.2266000',
                'city' => 'Stanton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51004',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3889000',
                'longitude' => '-95.8684000',
                'city' => 'Anthon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51654',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7497000',
                'longitude' => '-95.6533000',
                'city' => 'Thurman',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51028',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5487000',
                'longitude' => '-95.8658000',
                'city' => 'Kingsley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51061',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5487000',
                'longitude' => '-95.8658000',
                'city' => 'Washta',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51048',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5487000',
                'longitude' => '-95.8658000',
                'city' => 'Pierson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51035',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8255000',
                'longitude' => '-95.8037000',
                'city' => 'Marcus',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51022',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8255000',
                'longitude' => '-95.8037000',
                'city' => 'Granville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51050',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8255000',
                'longitude' => '-95.8037000',
                'city' => 'Remsen',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51018',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4630000',
                'longitude' => '-95.6720000',
                'city' => 'Cushing',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51649',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8745000',
                'longitude' => '-95.4793000',
                'city' => 'Randolph',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51645',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8745000',
                'longitude' => '-95.4793000',
                'city' => 'Imogene',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51650',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6918000',
                'longitude' => '-95.5673000',
                'city' => 'Riverton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51246',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4262000',
                'longitude' => '-96.1757000',
                'city' => 'Rock Rapids',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51553',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4646000',
                'longitude' => '-95.5335000',
                'city' => 'Minden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51055',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2290000',
                'longitude' => '-96.2255000',
                'city' => 'Sloan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50527',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9346000',
                'longitude' => '-94.6823000',
                'city' => 'Curlew',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50562',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9346000',
                'longitude' => '-94.6823000',
                'city' => 'Mallard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50515',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0382000',
                'longitude' => '-94.8326000',
                'city' => 'Ayrshire',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50536',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0382000',
                'longitude' => '-94.8326000',
                'city' => 'Emmetsburg',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51358',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0382000',
                'longitude' => '-94.8326000',
                'city' => 'Ruthven',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51063',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2290000',
                'longitude' => '-96.2255000',
                'city' => 'Whiting',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51052',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2290000',
                'longitude' => '-96.2255000',
                'city' => 'Salix',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51037',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8097000',
                'longitude' => '-95.7045000',
                'city' => 'Meriden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51014',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8097000',
                'longitude' => '-95.7045000',
                'city' => 'Cleghorn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51046',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8592000',
                'longitude' => '-95.5409000',
                'city' => 'Paullina',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51029',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8592000',
                'longitude' => '-95.5409000',
                'city' => 'Larrabee',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51234',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1879000',
                'longitude' => '-96.1336000',
                'city' => 'Boyden',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51235',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1879000',
                'longitude' => '-96.1336000',
                'city' => 'Doon',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51239',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1879000',
                'longitude' => '-96.1336000',
                'city' => 'Hull',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51250',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0757000',
                'longitude' => '-96.1765000',
                'city' => 'Sioux Center',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51003',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0757000',
                'longitude' => '-96.1765000',
                'city' => 'Alton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50554',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.7925000',
                'longitude' => '-95.6332000',
                'city' => 'Laurens',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51049',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.6285000',
                'longitude' => '-95.6388000',
                'city' => 'Quimby',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51245',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9736000',
                'longitude' => '-95.4889000',
                'city' => 'Primghar',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51009',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9736000',
                'longitude' => '-95.4889000',
                'city' => 'Calumet',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51247',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2106000',
                'longitude' => '-96.2904000',
                'city' => 'Rock Valley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51545',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9321000',
                'longitude' => '-96.0766000',
                'city' => 'Little Sioux',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51523',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9321000',
                'longitude' => '-96.0766000',
                'city' => 'Blencoe',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51557',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8301000',
                'longitude' => '-95.9270000',
                'city' => 'Mondamin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51564',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.8301000',
                'longitude' => '-95.9270000',
                'city' => 'Pisgah',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51026',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1270000',
                'longitude' => '-96.1552000',
                'city' => 'Hornick',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51249',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4090000',
                'longitude' => '-95.7425000',
                'city' => 'Sibley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51433',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2655000',
                'longitude' => '-94.7355000',
                'city' => 'Auburn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51449',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2655000',
                'longitude' => '-94.7355000',
                'city' => 'Lake City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50561',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4218000',
                'longitude' => '-94.8603000',
                'city' => 'Lytton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51230',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3319000',
                'longitude' => '-96.3105000',
                'city' => 'Alvord',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51241',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4538000',
                'longitude' => '-96.4324000',
                'city' => 'Larchwood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51242',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4368000',
                'longitude' => '-96.3263000',
                'city' => 'Lester',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51243',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4397000',
                'longitude' => '-95.8750000',
                'city' => 'Little Rock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51525',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3140000',
                'longitude' => '-95.3926000',
                'city' => 'Carson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51560',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3140000',
                'longitude' => '-95.3926000',
                'city' => 'Oakland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51548',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3140000',
                'longitude' => '-95.3926000',
                'city' => 'Mc Clelland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51559',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4682000',
                'longitude' => '-95.5447000',
                'city' => 'Neola',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51536',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4682000',
                'longitude' => '-95.5447000',
                'city' => 'Hancock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51576',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4563000',
                'longitude' => '-95.6177000',
                'city' => 'Underwood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51541',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1906000',
                'longitude' => '-95.4153000',
                'city' => 'Henderson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51571',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1906000',
                'longitude' => '-95.4153000',
                'city' => 'Silver City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51549',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1906000',
                'longitude' => '-95.4153000',
                'city' => 'Macedonia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51575',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2346000',
                'longitude' => '-95.6154000',
                'city' => 'Treynor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51563',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5809000',
                'longitude' => '-95.5678000',
                'city' => 'Persia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51565',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5809000',
                'longitude' => '-95.5678000',
                'city' => 'Portsmouth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51562',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7265000',
                'longitude' => '-95.4726000',
                'city' => 'Panama',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51579',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7265000',
                'longitude' => '-95.4726000',
                'city' => 'Woodbine',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51530',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7265000',
                'longitude' => '-95.4726000',
                'city' => 'Earling',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51529',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7265000',
                'longitude' => '-95.4726000',
                'city' => 'Dunlap',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51534',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0395000',
                'longitude' => '-95.7432000',
                'city' => 'Glenwood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51551',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0498000',
                'longitude' => '-95.7441000',
                'city' => 'Malvern',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51554',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0498000',
                'longitude' => '-95.7441000',
                'city' => 'Mineola',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51561',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0498000',
                'longitude' => '-95.7441000',
                'city' => 'Pacific Junction',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51648',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7517000',
                'longitude' => '-95.8161000',
                'city' => 'Percival',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51001',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8178000',
                'longitude' => '-96.2670000',
                'city' => 'Akron',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51008',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8178000',
                'longitude' => '-96.2670000',
                'city' => 'Brunsville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51636',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6061000',
                'longitude' => '-95.2871000',
                'city' => 'Coin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51647',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6061000',
                'longitude' => '-95.2871000',
                'city' => 'Northboro',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51630',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6061000',
                'longitude' => '-95.2871000',
                'city' => 'Blanchard',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51646',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7612000',
                'longitude' => '-94.7468000',
                'city' => 'New Market',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50848',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7612000',
                'longitude' => '-94.7468000',
                'city' => 'Gravity',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51651',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.7340000',
                'longitude' => '-95.0319000',
                'city' => 'Shambaugh',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51542',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3613000',
                'longitude' => '-95.8557000',
                'city' => 'Honey Creek',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51555',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3613000',
                'longitude' => '-95.8557000',
                'city' => 'Missouri Valley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51011',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.9988000',
                'longitude' => '-96.4833000',
                'city' => 'Chatsworth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51036',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8981000',
                'longitude' => '-96.2018000',
                'city' => 'Maurice',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50117',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7184000',
                'longitude' => '-94.9307000',
                'city' => 'Hamlin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50110',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7184000',
                'longitude' => '-94.9307000',
                'city' => 'Gray',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51062',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8265000',
                'longitude' => '-96.5586000',
                'city' => 'Westfield',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51038',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8265000',
                'longitude' => '-96.5586000',
                'city' => 'Merrill',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51637',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6161000',
                'longitude' => '-95.1176000',
                'city' => 'College Springs',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51631',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.6161000',
                'longitude' => '-95.1176000',
                'city' => 'Braddyville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50864',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8427000',
                'longitude' => '-95.1024000',
                'city' => 'Villisca',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50853',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5009000',
                'longitude' => '-96.4096000',
                'city' => 'Massena',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51577',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4812000',
                'longitude' => '-95.2255000',
                'city' => 'Walnut',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51540',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0040000',
                'longitude' => '-95.5851000',
                'city' => 'Hastings',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51653',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.8723000',
                'longitude' => '-95.5660000',
                'city' => 'Tabor',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51578',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7177000',
                'longitude' => '-95.3977000',
                'city' => 'Westphalia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51527',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7177000',
                'longitude' => '-95.3977000',
                'city' => 'Defiance',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51248',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1829000',
                'longitude' => '-95.6609000',
                'city' => 'Sanborn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50583',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5178000',
                'longitude' => '-95.0815000',
                'city' => 'Sac City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50567',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.5178000',
                'longitude' => '-95.0815000',
                'city' => 'Nemaha',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51556',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6145000',
                'longitude' => '-96.0071000',
                'city' => 'Modale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51550',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6940000',
                'longitude' => '-95.8769000',
                'city' => 'Magnolia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51450',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3058000',
                'longitude' => '-95.0487000',
                'city' => 'Lake View',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51454',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9073000',
                'longitude' => '-95.0630000',
                'city' => 'Manilla',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51432',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9073000',
                'longitude' => '-95.0630000',
                'city' => 'Aspinwall',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51455',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9073000',
                'longitude' => '-95.0630000',
                'city' => 'Manning',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51451',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1803000',
                'longitude' => '-94.6907000',
                'city' => 'Lanesboro',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51430',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0045000',
                'longitude' => '-94.9737000',
                'city' => 'Arcadia',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51444',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0045000',
                'longitude' => '-94.9737000',
                'city' => 'Halbur',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51467',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0737000',
                'longitude' => '-95.0949000',
                'city' => 'Westside',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51466',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2730000',
                'longitude' => '-95.0878000',
                'city' => 'Wall Lake',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51465',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2730000',
                'longitude' => '-95.0878000',
                'city' => 'Vail',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51459',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.0417000',
                'longitude' => '-94.6369000',
                'city' => 'Ralston',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51440',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9171000',
                'longitude' => '-94.9370000',
                'city' => 'Dedham',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51463',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9171000',
                'longitude' => '-94.9370000',
                'city' => 'Templeton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51520',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9251000',
                'longitude' => '-95.4805000',
                'city' => 'Arion',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51528',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9251000',
                'longitude' => '-95.4805000',
                'city' => 'Dow City',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51448',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1936000',
                'longitude' => '-95.3281000',
                'city' => 'Kiron',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51439',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1634000',
                'longitude' => '-95.4391000',
                'city' => 'Charter Oak',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51461',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1634000',
                'longitude' => '-95.4391000',
                'city' => 'Schleswig',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51060',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1258000',
                'longitude' => '-95.5743000',
                'city' => 'Ute',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51460',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1258000',
                'longitude' => '-95.5743000',
                'city' => 'Ricketts',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51231',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1168000',
                'longitude' => '-95.7395000',
                'city' => 'Archer',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51232',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3176000',
                'longitude' => '-95.7880000',
                'city' => 'Ashton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51346',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1831000',
                'longitude' => '-95.4839000',
                'city' => 'Hartley',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51354',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3162000',
                'longitude' => '-95.4752000',
                'city' => 'Ocheyedan',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51350',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3162000',
                'longitude' => '-95.4752000',
                'city' => 'Melvin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51349',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3162000',
                'longitude' => '-95.4752000',
                'city' => 'Melvin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51244',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2418000',
                'longitude' => '-95.9333000',
                'city' => 'Matlock',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51240',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3086000',
                'longitude' => '-96.4322000',
                'city' => 'Inwood',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50274',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.4479000',
                'longitude' => '-94.7661000',
                'city' => 'Wiota',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51532',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1422000',
                'longitude' => '-94.9864000',
                'city' => 'Elliott',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51535',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1422000',
                'longitude' => '-94.9864000',
                'city' => 'Griswold',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50847',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1422000',
                'longitude' => '-94.9864000',
                'city' => 'Grant',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50843',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.1422000',
                'longitude' => '-94.9864000',
                'city' => 'Cumberland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51531',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.5926000',
                'longitude' => '-95.0559000',
                'city' => 'Elk Horn',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51446',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7242000',
                'longitude' => '-95.2608000',
                'city' => 'Irwin',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51447',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.7242000',
                'longitude' => '-95.2608000',
                'city' => 'Kirkman',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51544',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.3034000',
                'longitude' => '-95.0808000',
                'city' => 'Lewis',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51543',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.6273000',
                'longitude' => '-95.0695000',
                'city' => 'Kimballton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '82001',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5828000',
                'longitude' => '-96.4621000',
                'city' => 'Cheyenne',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50857',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '40.9351000',
                'longitude' => '-94.8922000',
                'city' => 'Nodaway',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51045',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8109000',
                'longitude' => '-95.9673000',
                'city' => 'Oyens',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51452',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.1246000',
                'longitude' => '-94.7836000',
                'city' => 'Lidderdale',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51533',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.0376000',
                'longitude' => '-95.4084000',
                'city' => 'Emerson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51044',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2817000',
                'longitude' => '-95.8950000',
                'city' => 'Oto',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51357',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1575000',
                'longitude' => '-95.3216000',
                'city' => 'Royal',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51338',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1575000',
                'longitude' => '-95.3216000',
                'city' => 'Everly',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51333',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0170000',
                'longitude' => '-95.0356000',
                'city' => 'Dickens',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51341',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0170000',
                'longitude' => '-95.0356000',
                'city' => 'Gillett Grove',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51366',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.0170000',
                'longitude' => '-95.0356000',
                'city' => 'Webb',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51364',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1306000',
                'longitude' => '-94.9011000',
                'city' => 'Terril',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '68134',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.2614000',
                'longitude' => '-96.0954000',
                'city' => 'Omaha',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50573',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.8768000',
                'longitude' => '-94.6279000',
                'city' => 'Plover',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51363',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.4288000',
                'longitude' => '-94.9515000',
                'city' => 'Superior',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51342',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.2360000',
                'longitude' => '-94.7570000',
                'city' => 'Graettinger',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '50531',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3923000',
                'longitude' => '-94.4723000',
                'city' => 'Dolliver',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51365',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.3211000',
                'longitude' => '-94.8026000',
                'city' => 'Wallingford',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51039',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4837000',
                'longitude' => '-96.0770000',
                'city' => 'Moville',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51056',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2296000',
                'longitude' => '-96.0981000',
                'city' => 'Smithland',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51007',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3428000',
                'longitude' => '-96.0752000',
                'city' => 'Bronson',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51015',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.3428000',
                'longitude' => '-96.0752000',
                'city' => 'Climbing Hill',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51572',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '41.9934000',
                'longitude' => '-95.7758000',
                'city' => 'Soldier',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51051',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.2280000',
                'longitude' => '-95.9318000',
                'city' => 'Rodney',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '51030',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '42.4761000',
                'longitude' => '-96.1819000',
                'city' => 'Lawton',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '56129',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5175000',
                'longitude' => '-96.0148000',
                'city' => 'Ellsworth',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '56138',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.5306000',
                'longitude' => '-96.3552000',
                'city' => 'Hills',
                'full_state' => 'Iowa',
            ],
            [
                'zip' => '57034',
                'country_code' => 'US',
                'state' => 'IA',
                'latitude' => '43.1292000',
                'longitude' => '-96.4512000',
                'city' => 'Hudson',
                'full_state' => 'Iowa',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
