<?php

namespace Database\Seeders\ImmutableData\USZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GeorgiaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => '31757',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8421000',
                'longitude' => '-83.9825000',
                'city' => 'Thomasville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39845',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1663000',
                'longitude' => '-85.0384000',
                'city' => 'Donalsonville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31702',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9018000',
                'longitude' => '-84.5678000',
                'city' => 'Albany',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31791',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5331000',
                'longitude' => '-83.8490000',
                'city' => 'Sylvester',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39837',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1668000',
                'longitude' => '-84.7338000',
                'city' => 'Colquitt',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39819',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9063000',
                'longitude' => '-84.5771000',
                'city' => 'Bainbridge',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39840',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7700000',
                'longitude' => '-84.7930000',
                'city' => 'Cuthbert',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39813',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4329000',
                'longitude' => '-84.7280000',
                'city' => 'Arlington',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31055',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0630000',
                'longitude' => '-82.9088000',
                'city' => 'Mc Rae',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31779',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1268000',
                'longitude' => '-84.1527000',
                'city' => 'Pelham',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31771',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1792000',
                'longitude' => '-83.7863000',
                'city' => 'Norman Park',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31768',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1792000',
                'longitude' => '-83.7863000',
                'city' => 'Moultrie',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31749',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4091000',
                'longitude' => '-83.3314000',
                'city' => 'Enigma',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31601',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8328000',
                'longitude' => '-83.2831000',
                'city' => 'Valdosta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31645',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8328000',
                'longitude' => '-83.2831000',
                'city' => 'Ray City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31602',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8328000',
                'longitude' => '-83.2831000',
                'city' => 'Valdosta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31605',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8328000',
                'longitude' => '-83.2831000',
                'city' => 'Valdosta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31606',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8328000',
                'longitude' => '-83.2831000',
                'city' => 'Valdosta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39817',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9063000',
                'longitude' => '-84.5771000',
                'city' => 'Bainbridge',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31714',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7003000',
                'longitude' => '-83.6521000',
                'city' => 'Ashburn',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31620',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1416000',
                'longitude' => '-83.4234000',
                'city' => 'Adel',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31792',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8398000',
                'longitude' => '-83.9778000',
                'city' => 'Thomasville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31626',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8398000',
                'longitude' => '-83.9778000',
                'city' => 'Boston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31773',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8398000',
                'longitude' => '-83.9778000',
                'city' => 'Ochlocknee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39824',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9018000',
                'longitude' => '-84.5678000',
                'city' => 'Bluffton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31815',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8833000',
                'longitude' => '-85.1066000',
                'city' => 'Lumpkin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31643',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7858000',
                'longitude' => '-83.5594000',
                'city' => 'Quitman',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31639',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2085000',
                'longitude' => '-83.2487000',
                'city' => 'Nashville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31794',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4494000',
                'longitude' => '-83.5092000',
                'city' => 'Tifton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31015',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9653000',
                'longitude' => '-83.7924000',
                'city' => 'Cordele',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31705',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5853000',
                'longitude' => '-84.1607000',
                'city' => 'Albany',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31707',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5853000',
                'longitude' => '-84.1607000',
                'city' => 'Albany',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31603',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8328000',
                'longitude' => '-83.2831000',
                'city' => 'Valdosta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31765',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0759000',
                'longitude' => '-84.0815000',
                'city' => 'Meigs',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31629',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7858000',
                'longitude' => '-83.5594000',
                'city' => 'Dixie',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31719',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0655000',
                'longitude' => '-84.2346000',
                'city' => 'Americus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31092',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0934000',
                'longitude' => '-83.7941000',
                'city' => 'Vienna',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31793',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4494000',
                'longitude' => '-83.5092000',
                'city' => 'Tifton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31712',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9647000',
                'longitude' => '-83.7804000',
                'city' => 'Arabi',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31648',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.6870000',
                'longitude' => '-83.1829000',
                'city' => 'Statenville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31803',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3158000',
                'longitude' => '-84.5232000',
                'city' => 'Buena Vista',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31730',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2347000',
                'longitude' => '-84.2113000',
                'city' => 'Camilla',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31716',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3772000',
                'longitude' => '-84.1676000',
                'city' => 'Baconton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39862',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4855000',
                'longitude' => '-84.5095000',
                'city' => 'Leary',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31787',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8991000',
                'longitude' => '-84.2513000',
                'city' => 'Smithville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31763',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7322000',
                'longitude' => '-84.1692000',
                'city' => 'Leesburg',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31825',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0910000',
                'longitude' => '-84.6707000',
                'city' => 'Richland',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31721',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5853000',
                'longitude' => '-84.1607000',
                'city' => 'Albany',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31821',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0508000',
                'longitude' => '-84.7959000',
                'city' => 'Omaha',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31647',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1674000',
                'longitude' => '-83.4433000',
                'city' => 'Sparks',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31622',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3843000',
                'longitude' => '-83.2177000',
                'city' => 'Alapaha',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31806',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2443000',
                'longitude' => '-84.3091000',
                'city' => 'Ellaville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39828',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8797000',
                'longitude' => '-84.2091000',
                'city' => 'Cairo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39823',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5151000',
                'longitude' => '-84.8763000',
                'city' => 'Blakely',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39877',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7601000',
                'longitude' => '-84.6082000',
                'city' => 'Parrott',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31701',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5767000',
                'longitude' => '-84.1540000',
                'city' => 'Albany',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31071',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1094000',
                'longitude' => '-83.5021000',
                'city' => 'Pineview',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31077',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9907000',
                'longitude' => '-83.2008000',
                'city' => 'Rhine',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31722',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0718000',
                'longitude' => '-83.6231000',
                'city' => 'Berlin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31747',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0718000',
                'longitude' => '-83.6231000',
                'city' => 'Ellenton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31778',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0718000',
                'longitude' => '-83.6231000',
                'city' => 'Pavo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31750',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7175000',
                'longitude' => '-83.2492000',
                'city' => 'Fitzgerald',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39827',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8751000',
                'longitude' => '-84.1998000',
                'city' => 'Cairo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39897',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8751000',
                'longitude' => '-84.1998000',
                'city' => 'Whigham',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31709',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0655000',
                'longitude' => '-84.2346000',
                'city' => 'Americus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31060',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0149000',
                'longitude' => '-83.0669000',
                'city' => 'Milan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31784',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2307000',
                'longitude' => '-84.2140000',
                'city' => 'Sale City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31735',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9505000',
                'longitude' => '-83.9443000',
                'city' => 'Cobb',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31738',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0078000',
                'longitude' => '-83.8681000',
                'city' => 'Coolidge',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39846',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Edison',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31011',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0251000',
                'longitude' => '-83.0662000',
                'city' => 'Chauncey',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31001',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9480000',
                'longitude' => '-83.4547000',
                'city' => 'Abbeville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31079',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9480000',
                'longitude' => '-83.4547000',
                'city' => 'Rochelle',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39851',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.6104000',
                'longitude' => '-85.0422000',
                'city' => 'Fort Gaines',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39861',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1663000',
                'longitude' => '-85.0384000',
                'city' => 'Jakin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31756',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0655000',
                'longitude' => '-84.2346000',
                'city' => 'Hartsfield',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31744',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0655000',
                'longitude' => '-84.2346000',
                'city' => 'Doerun',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31733',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4557000',
                'longitude' => '-83.5112000',
                'city' => 'Chula',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31795',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4557000',
                'longitude' => '-83.5112000',
                'city' => 'Ty Ty',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31023',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9947000',
                'longitude' => '-83.1981000',
                'city' => 'Eastman',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31070',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1927000',
                'longitude' => '-83.7586000',
                'city' => 'Pinehurst',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31775',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4494000',
                'longitude' => '-83.5092000',
                'city' => 'Omega',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39834',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7633000',
                'longitude' => '-84.3272000',
                'city' => 'Climax',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31774',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5925000',
                'longitude' => '-83.2517000',
                'city' => 'Ocilla',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31637',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2761000',
                'longitude' => '-83.4699000',
                'city' => 'Lenox',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31625',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0678000',
                'longitude' => '-83.6257000',
                'city' => 'Barney',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31635',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0421000',
                'longitude' => '-83.0754000',
                'city' => 'Lakeland',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31788',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1815000',
                'longitude' => '-83.7909000',
                'city' => 'Moultrie',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31072',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9422000',
                'longitude' => '-83.5398000',
                'city' => 'Pitts',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31636',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8328000',
                'longitude' => '-83.2831000',
                'city' => 'Lake Park',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39815',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7495000',
                'longitude' => '-84.4826000',
                'city' => 'Attapulgus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31798',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5965000',
                'longitude' => '-83.2490000',
                'city' => 'Wray',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31641',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0421000',
                'longitude' => '-83.0754000',
                'city' => 'Naylor',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31796',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8259000',
                'longitude' => '-83.9277000',
                'city' => 'Warwick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31772',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8259000',
                'longitude' => '-83.9277000',
                'city' => 'Oakfield',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39826',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7159000',
                'longitude' => '-84.3530000',
                'city' => 'Bronwood',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31790',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7066000',
                'longitude' => '-83.6541000',
                'city' => 'Sycamore',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39842',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7757000',
                'longitude' => '-84.4437000',
                'city' => 'Dawson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31632',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9904000',
                'longitude' => '-83.3757000',
                'city' => 'Hahira',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31783',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7066000',
                'longitude' => '-83.6541000',
                'city' => 'Rebecca',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31091',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1927000',
                'longitude' => '-83.7586000',
                'city' => 'Unadilla',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31084',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9445000',
                'longitude' => '-83.5445000',
                'city' => 'Seville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31801',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3158000',
                'longitude' => '-84.5232000',
                'city' => 'Box Springs',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31058',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3158000',
                'longitude' => '-84.5232000',
                'city' => 'Mauk',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '32324',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7045000',
                'longitude' => '-84.8449000',
                'city' => 'Chattahoochee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39825',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7045000',
                'longitude' => '-84.8449000',
                'city' => 'Brinson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31324',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9018000',
                'longitude' => '-84.5678000',
                'city' => 'Richmond Hill',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31720',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8921000',
                'longitude' => '-83.7413000',
                'city' => 'Barwick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39859',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0131000',
                'longitude' => '-84.8187000',
                'city' => 'Iron City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31638',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9413000',
                'longitude' => '-83.5008000',
                'city' => 'Morven',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31781',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5285000',
                'longitude' => '-83.8397000',
                'city' => 'Poulan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31789',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5285000',
                'longitude' => '-83.8397000',
                'city' => 'Sumner',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31627',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.9881000',
                'longitude' => '-83.3711000',
                'city' => 'Cecil',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31780',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0355000',
                'longitude' => '-84.3909000',
                'city' => 'Plains',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31832',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0647000',
                'longitude' => '-84.5391000',
                'city' => 'Weston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31824',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0647000',
                'longitude' => '-84.5391000',
                'city' => 'Preston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31760',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.6471000',
                'longitude' => '-83.3830000',
                'city' => 'Irwinville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31544',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8118000',
                'longitude' => '-82.9800000',
                'city' => 'Jacksonville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31805',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0571000',
                'longitude' => '-84.7980000',
                'city' => 'Cusseta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31814',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0571000',
                'longitude' => '-84.7980000',
                'city' => 'Louvale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '39866',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5371000',
                'longitude' => '-84.6052000',
                'city' => 'Morgan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31764',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9505000',
                'longitude' => '-83.9443000',
                'city' => 'Leslie',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31037',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0646000',
                'longitude' => '-82.9015000',
                'city' => 'Helena',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31743',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9495000',
                'longitude' => '-84.0940000',
                'city' => 'De Soto',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31711',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0718000',
                'longitude' => '-84.2367000',
                'city' => 'Andersonville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31753',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1999000',
                'longitude' => '-83.8712000',
                'city' => 'Funston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31758',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8421000',
                'longitude' => '-83.9825000',
                'city' => 'Thomasville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30308',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7627000',
                'longitude' => '-84.3866000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30313',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7627000',
                'longitude' => '-84.3866000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30312',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30334',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30349',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30305',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30318',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7815000',
                'longitude' => '-84.3929000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30309',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7815000',
                'longitude' => '-84.3929000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30303',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30354',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6746000',
                'longitude' => '-84.4461000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30315',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6746000',
                'longitude' => '-84.4461000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30311',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6746000',
                'longitude' => '-84.4461000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30344',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6746000',
                'longitude' => '-84.4461000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30337',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6746000',
                'longitude' => '-84.4461000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30083',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Stone Mountain',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30319',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30021',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Clarkston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30336',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30034',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7010000',
                'longitude' => '-84.3015000',
                'city' => 'Decatur',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30316',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7010000',
                'longitude' => '-84.3015000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30294',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7010000',
                'longitude' => '-84.3015000',
                'city' => 'Ellenwood',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30032',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7010000',
                'longitude' => '-84.3015000',
                'city' => 'Decatur',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30288',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7010000',
                'longitude' => '-84.3015000',
                'city' => 'Conley',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30339',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30329',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30314',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30310',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30307',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30324',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30110',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Bremen',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30033',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Decatur',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30328',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30301',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30317',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30306',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30374',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30064',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30030',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8557000',
                'longitude' => '-84.4822000',
                'city' => 'Decatur',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30297',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8557000',
                'longitude' => '-84.4822000',
                'city' => 'Forest Park',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30331',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8557000',
                'longitude' => '-84.4822000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30345',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8557000',
                'longitude' => '-84.4822000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30260',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8557000',
                'longitude' => '-84.4822000',
                'city' => 'Morrow',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30066',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30269',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Peachtree City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30327',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8387000',
                'longitude' => '-84.3795000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30342',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8387000',
                'longitude' => '-84.3795000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30326',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8387000',
                'longitude' => '-84.3795000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30347',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30079',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Scottdale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30071',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Norcross',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30361',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7815000',
                'longitude' => '-84.3929000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30341',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7609000',
                'longitude' => '-84.3941000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30518',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Buford',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30076',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Roswell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30075',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Roswell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30086',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Stone Mountain',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30238',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Jonesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30088',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Stone Mountain',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31419',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30002',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7358000',
                'longitude' => '-84.2525000',
                'city' => 'Avondale Estates',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30035',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7358000',
                'longitude' => '-84.2525000',
                'city' => 'Decatur',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30132',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Dallas',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30501',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8557000',
                'longitude' => '-84.4822000',
                'city' => 'Gainesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30504',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8557000',
                'longitude' => '-84.4822000',
                'city' => 'Gainesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30152',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Kennesaw',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30084',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Tucker',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30080',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Smyrna',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30101',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Acworth',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31146',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30038',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Lithonia',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30375',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30004',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Alpharetta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30045',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Lawrenceville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30014',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7815000',
                'longitude' => '-84.3929000',
                'city' => 'Covington',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30094',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Conyers',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30067',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30047',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Lilburn',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30062',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30340',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30022',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Alpharetta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30096',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Duluth',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30102',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Acworth',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30127',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8987000',
                'longitude' => '-84.3833000',
                'city' => 'Powder Springs',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30362',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30091',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Norcross',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30037',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Decatur',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30060',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30115',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Canton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30356',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30214',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Fayetteville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30330',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30126',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7579000',
                'longitude' => '-84.5102000',
                'city' => 'Mableton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30359',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7547000',
                'longitude' => '-84.3920000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30346',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7547000',
                'longitude' => '-84.3920000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30058',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7867000',
                'longitude' => '-84.2371000',
                'city' => 'Lithonia',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30360',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8221000',
                'longitude' => '-84.2003000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30320',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6746000',
                'longitude' => '-84.4461000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30078',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Snellville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30204',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Barnesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30321',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30097',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Duluth',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30281',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Stockbridge',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30041',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Cumming',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30248',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Locust Grove',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30043',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Lawrenceville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30350',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30039',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Snellville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30506',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Gainesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30322',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7815000',
                'longitude' => '-84.3929000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30135',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Douglasville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30369',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7609000',
                'longitude' => '-84.3941000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30355',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30274',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Riverdale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30068',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30338',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30093',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Norcross',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30044',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Lawrenceville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30092',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Norcross',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30332',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7815000',
                'longitude' => '-84.3929000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30236',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Jonesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30005',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7564000',
                'longitude' => '-84.3845000',
                'city' => 'Alpharetta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30134',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Douglasville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30188',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Woodstock',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30087',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7627000',
                'longitude' => '-84.3866000',
                'city' => 'Stone Mountain',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30122',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8221000',
                'longitude' => '-84.2003000',
                'city' => 'Lithia Springs',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30024',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Suwanee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30252',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7609000',
                'longitude' => '-84.3941000',
                'city' => 'Mcdonough',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30272',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Red Oak',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31211',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31204',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30477',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8589000',
                'longitude' => '-82.3983000',
                'city' => 'Wadley',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31201',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31217',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31093',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6208000',
                'longitude' => '-83.6138000',
                'city' => 'Warner Robins',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31088',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6208000',
                'longitude' => '-83.6138000',
                'city' => 'Warner Robins',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31069',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4555000',
                'longitude' => '-83.7320000',
                'city' => 'Perry',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31036',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4555000',
                'longitude' => '-83.7320000',
                'city' => 'Hawkinsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31047',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4555000',
                'longitude' => '-83.7320000',
                'city' => 'Kathleen',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31005',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4555000',
                'longitude' => '-83.7320000',
                'city' => 'Bonaire',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31032',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0059000',
                'longitude' => '-83.5348000',
                'city' => 'Gray',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31061',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0818000',
                'longitude' => '-83.2238000',
                'city' => 'Milledgeville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30434',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0017000',
                'longitude' => '-82.4062000',
                'city' => 'Louisville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31014',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3891000',
                'longitude' => '-83.3503000',
                'city' => 'Cochran',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31082',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9853000',
                'longitude' => '-82.8108000',
                'city' => 'Sandersville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31031',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8924000',
                'longitude' => '-83.3351000',
                'city' => 'Gordon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31024',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.1661000',
                'longitude' => '-83.3621000',
                'city' => 'Eatonton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31057',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4581000',
                'longitude' => '-83.9425000',
                'city' => 'Marshallville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30441',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5970000',
                'longitude' => '-82.3344000',
                'city' => 'Midville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30401',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5970000',
                'longitude' => '-82.3344000',
                'city' => 'Swainsboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30471',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5970000',
                'longitude' => '-82.3344000',
                'city' => 'Twin City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31089',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9727000',
                'longitude' => '-82.8069000',
                'city' => 'Tennille',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31035',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9727000',
                'longitude' => '-82.8069000',
                'city' => 'Harrison',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31094',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9727000',
                'longitude' => '-82.8069000',
                'city' => 'Warthen',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30413',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9727000',
                'longitude' => '-82.8069000',
                'city' => 'Bartow',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31007',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2002000',
                'longitude' => '-83.9026000',
                'city' => 'Byromville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31063',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3079000',
                'longitude' => '-84.0365000',
                'city' => 'Montezuma',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31021',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5331000',
                'longitude' => '-82.9083000',
                'city' => 'Dublin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30816',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8676000',
                'longitude' => '-82.4050000',
                'city' => 'Keysville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30439',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8676000',
                'longitude' => '-82.4050000',
                'city' => 'Metter',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31030',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5497000',
                'longitude' => '-83.8819000',
                'city' => 'Fort Valley',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31029',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0310000',
                'longitude' => '-83.9342000',
                'city' => 'Forsyth',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31027',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5331000',
                'longitude' => '-82.9083000',
                'city' => 'East Dublin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31096',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7260000',
                'longitude' => '-82.7185000',
                'city' => 'Wrightsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30454',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5394000',
                'longitude' => '-82.9102000',
                'city' => 'Rockledge',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31022',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5331000',
                'longitude' => '-82.9083000',
                'city' => 'Dudley',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31033',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0327000',
                'longitude' => '-83.4271000',
                'city' => 'Haddock',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30456',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9733000',
                'longitude' => '-81.7584000',
                'city' => 'Sardis',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31017',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6002000',
                'longitude' => '-83.2388000',
                'city' => 'Danville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30442',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8106000',
                'longitude' => '-81.9437000',
                'city' => 'Millen',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31210',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31207',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31202',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31006',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Butler',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31206',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8340000',
                'longitude' => '-83.6264000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31098',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6208000',
                'longitude' => '-83.6138000',
                'city' => 'Warner Robins',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31401',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8340000',
                'longitude' => '-83.6264000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31095',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6208000',
                'longitude' => '-83.6138000',
                'city' => 'Warner Robins',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31028',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6208000',
                'longitude' => '-83.6138000',
                'city' => 'Centerville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31018',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9751000',
                'longitude' => '-82.6088000',
                'city' => 'Davisboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31012',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3995000',
                'longitude' => '-83.1558000',
                'city' => 'Chester',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31019',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3995000',
                'longitude' => '-83.1558000',
                'city' => 'Dexter',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31052',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8090000',
                'longitude' => '-83.8261000',
                'city' => 'Lizella',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31020',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5331000',
                'longitude' => '-82.9083000',
                'city' => 'Dry Branch',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31065',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5604000',
                'longitude' => '-83.1589000',
                'city' => 'Montrose',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31076',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5583000',
                'longitude' => '-84.0943000',
                'city' => 'Reynolds',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30233',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0310000',
                'longitude' => '-83.9342000',
                'city' => 'Jackson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31220',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8560000',
                'longitude' => '-83.6934000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31062',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0904000',
                'longitude' => '-83.2305000',
                'city' => 'Milledgeville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31034',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0904000',
                'longitude' => '-83.2305000',
                'city' => 'Hardwick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31075',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2543000',
                'longitude' => '-82.9045000',
                'city' => 'Rentz',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31009',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2543000',
                'longitude' => '-82.9045000',
                'city' => 'Cadwell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30428',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2543000',
                'longitude' => '-82.9045000',
                'city' => 'Glenwood',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30411',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2543000',
                'longitude' => '-82.9045000',
                'city' => 'Alamo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31295',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31002',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6826000',
                'longitude' => '-82.5149000',
                'city' => 'Adrian',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31049',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6826000',
                'longitude' => '-82.5149000',
                'city' => 'Kite',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31046',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8560000',
                'longitude' => '-83.6934000',
                'city' => 'Juliette',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31068',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3016000',
                'longitude' => '-84.0345000',
                'city' => 'Oglethorpe',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31216',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8560000',
                'longitude' => '-83.6934000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30426',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9733000',
                'longitude' => '-81.7584000',
                'city' => 'Girard',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30823',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0041000',
                'longitude' => '-82.4109000',
                'city' => 'Stapleton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31025',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2618000',
                'longitude' => '-83.7372000',
                'city' => 'Elko',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31054',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8821000',
                'longitude' => '-83.3358000',
                'city' => 'Mc Intyre',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31008',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6448000',
                'longitude' => '-83.7611000',
                'city' => 'Byron',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31078',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7234000',
                'longitude' => '-84.0088000',
                'city' => 'Roberta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31042',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5388000',
                'longitude' => '-83.0730000',
                'city' => 'Irwinton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31213',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8363000',
                'longitude' => '-83.6311000',
                'city' => 'Macon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30425',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5671000',
                'longitude' => '-82.1593000',
                'city' => 'Garfield',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31038',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Hillsboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31016',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7234000',
                'longitude' => '-84.0088000',
                'city' => 'Culloden',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31066',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7234000',
                'longitude' => '-84.0088000',
                'city' => 'Musella',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31081',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5588000',
                'longitude' => '-84.2377000',
                'city' => 'Rupert',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31090',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8232000',
                'longitude' => '-83.0743000',
                'city' => 'Toomsboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31044',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6898000',
                'longitude' => '-83.3461000',
                'city' => 'Jeffersonville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31041',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3771000',
                'longitude' => '-84.1900000',
                'city' => 'Ideal',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31003',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6009000',
                'longitude' => '-83.2509000',
                'city' => 'Allentown',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30822',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8043000',
                'longitude' => '-81.9418000',
                'city' => 'Perkins',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30507',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3010000',
                'longitude' => '-83.8272000',
                'city' => 'Gainesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30006',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8061000',
                'longitude' => '-84.1667000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30040',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2073000',
                'longitude' => '-84.1411000',
                'city' => 'Cumming',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30012',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6690000',
                'longitude' => '-84.0260000',
                'city' => 'Conyers',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30013',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6690000',
                'longitude' => '-84.0260000',
                'city' => 'Conyers',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30054',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6012000',
                'longitude' => '-83.8624000',
                'city' => 'Oxford',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30070',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6012000',
                'longitude' => '-83.8624000',
                'city' => 'Porterdale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30016',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6012000',
                'longitude' => '-83.8624000',
                'city' => 'Covington',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30008',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8837000',
                'longitude' => '-84.5078000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30082',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8837000',
                'longitude' => '-84.5078000',
                'city' => 'Smyrna',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30141',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7457000',
                'longitude' => '-84.7526000',
                'city' => 'Hiram',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30019',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9564000',
                'longitude' => '-83.9948000',
                'city' => 'Dacula',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30011',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9564000',
                'longitude' => '-83.9948000',
                'city' => 'Auburn',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30237',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5220000',
                'longitude' => '-84.3592000',
                'city' => 'Jonesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30228',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5220000',
                'longitude' => '-84.3592000',
                'city' => 'Hampton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30106',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8130000',
                'longitude' => '-84.6378000',
                'city' => 'Austell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30168',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8130000',
                'longitude' => '-84.6378000',
                'city' => 'Austell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30048',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8935000',
                'longitude' => '-84.1389000',
                'city' => 'Lilburn',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30680',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9943000',
                'longitude' => '-83.7192000',
                'city' => 'Winder',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30606',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9943000',
                'longitude' => '-83.7192000',
                'city' => 'Athens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30292',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4923000',
                'longitude' => '-84.3855000',
                'city' => 'Williamson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30223',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4923000',
                'longitude' => '-84.3855000',
                'city' => 'Griffin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30205',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6746000',
                'longitude' => '-84.4461000',
                'city' => 'Brooks',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30144',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Kennesaw',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30189',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Woodstock',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30125',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.0109000',
                'longitude' => '-85.2507000',
                'city' => 'Cedartown',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30108',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5406000',
                'longitude' => '-85.2591000',
                'city' => 'Bowdon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30103',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3764000',
                'longitude' => '-84.9367000',
                'city' => 'Adairsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30519',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1267000',
                'longitude' => '-84.0183000',
                'city' => 'Buford',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30273',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5438000',
                'longitude' => '-84.2496000',
                'city' => 'Rex',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30253',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5438000',
                'longitude' => '-84.2496000',
                'city' => 'Mcdonough',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30217',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Franklin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30028',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Cumming',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30527',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Clermont',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30116',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5810000',
                'longitude' => '-85.0753000',
                'city' => 'Carrollton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30263',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3783000',
                'longitude' => '-84.8023000',
                'city' => 'Newnan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30276',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3015000',
                'longitude' => '-84.5513000',
                'city' => 'Senoia',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30145',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2323000',
                'longitude' => '-84.9446000',
                'city' => 'Kingston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30052',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6012000',
                'longitude' => '-83.8624000',
                'city' => 'Loganville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30055',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6012000',
                'longitude' => '-83.8624000',
                'city' => 'Mansfield',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30017',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8547000',
                'longitude' => '-84.0263000',
                'city' => 'Grayson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30656',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7915000',
                'longitude' => '-83.7060000',
                'city' => 'Monroe',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30153',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9206000',
                'longitude' => '-84.8430000',
                'city' => 'Rockmart',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30157',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9206000',
                'longitude' => '-84.8430000',
                'city' => 'Dallas',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30290',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4256000',
                'longitude' => '-84.5565000',
                'city' => 'Tyrone',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30265',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3783000',
                'longitude' => '-84.8023000',
                'city' => 'Newnan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30277',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3743000',
                'longitude' => '-84.8049000',
                'city' => 'Sharpsburg',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30259',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3743000',
                'longitude' => '-84.8049000',
                'city' => 'Moreland',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30620',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9943000',
                'longitude' => '-83.7192000',
                'city' => 'Bethlehem',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30121',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Cartersville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30268',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Palmetto',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30566',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2987000',
                'longitude' => '-83.8224000',
                'city' => 'Oakwood',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30542',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2987000',
                'longitude' => '-83.8224000',
                'city' => 'Flowery Branch',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30543',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2987000',
                'longitude' => '-83.8224000',
                'city' => 'Gillsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30564',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2987000',
                'longitude' => '-83.8224000',
                'city' => 'Murrayville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30148',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4332000',
                'longitude' => '-84.3379000',
                'city' => 'Marble Hill',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30143',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4332000',
                'longitude' => '-84.3379000',
                'city' => 'Jasper',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30540',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3629000',
                'longitude' => '-84.3796000',
                'city' => 'Ellijay',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30175',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3629000',
                'longitude' => '-84.3796000',
                'city' => 'Talking Rock',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30114',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3629000',
                'longitude' => '-84.3796000',
                'city' => 'Canton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30025',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6578000',
                'longitude' => '-83.7153000',
                'city' => 'Social Circle',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30296',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5220000',
                'longitude' => '-84.3592000',
                'city' => 'Riverdale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30183',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2359000',
                'longitude' => '-84.4917000',
                'city' => 'Waleska',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30107',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2359000',
                'longitude' => '-84.4917000',
                'city' => 'Ball Ground',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30179',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7341000',
                'longitude' => '-85.0305000',
                'city' => 'Temple',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30295',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.1001000',
                'longitude' => '-84.3400000',
                'city' => 'Zebulon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30176',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7400000',
                'longitude' => '-85.2912000',
                'city' => 'Tallapoosa',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30220',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2414000',
                'longitude' => '-84.8366000',
                'city' => 'Grantville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30185',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Whitesburg',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30085',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8221000',
                'longitude' => '-84.2003000',
                'city' => 'Tucker',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31064',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6012000',
                'longitude' => '-83.8624000',
                'city' => 'Monticello',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30056',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6012000',
                'longitude' => '-83.8624000',
                'city' => 'Newborn',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30213',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Fairburn',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30113',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8003000',
                'longitude' => '-85.1946000',
                'city' => 'Buchanan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30554',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3830000',
                'longitude' => '-83.6676000',
                'city' => 'Lula',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30622',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9491000',
                'longitude' => '-83.5840000',
                'city' => 'Bogart',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30117',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5810000',
                'longitude' => '-85.0753000',
                'city' => 'Carrollton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30548',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1284000',
                'longitude' => '-84.0107000',
                'city' => 'Hoschton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30187',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7457000',
                'longitude' => '-84.7526000',
                'city' => 'Winston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30184',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1684000',
                'longitude' => '-84.7970000',
                'city' => 'White',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30178',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1684000',
                'longitude' => '-84.7970000',
                'city' => 'Taylorsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30171',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1684000',
                'longitude' => '-84.7970000',
                'city' => 'Rydal',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30120',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1684000',
                'longitude' => '-84.7970000',
                'city' => 'Cartersville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30215',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3010000',
                'longitude' => '-83.8272000',
                'city' => 'Fayetteville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30216',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2928000',
                'longitude' => '-83.9714000',
                'city' => 'Flovilla',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30234',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2928000',
                'longitude' => '-83.9714000',
                'city' => 'Jenkinsburg',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30677',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9484000',
                'longitude' => '-83.5716000',
                'city' => 'Watkinsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30666',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9484000',
                'longitude' => '-83.5716000',
                'city' => 'Statham',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30510',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3010000',
                'longitude' => '-83.8272000',
                'city' => 'Alto',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30180',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7319000',
                'longitude' => '-84.9247000',
                'city' => 'Villa Rica',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30206',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0903000',
                'longitude' => '-84.4409000',
                'city' => 'Concord',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30222',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4923000',
                'longitude' => '-84.3855000',
                'city' => 'Greenville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30170',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4513000',
                'longitude' => '-85.1359000',
                'city' => 'Roopville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30264',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3783000',
                'longitude' => '-84.8023000',
                'city' => 'Newnan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30104',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.0109000',
                'longitude' => '-85.2507000',
                'city' => 'Aragon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30124',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.0109000',
                'longitude' => '-85.2507000',
                'city' => 'Cave Spring',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30258',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0903000',
                'longitude' => '-84.4409000',
                'city' => 'Molena',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30251',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2087000',
                'longitude' => '-84.7452000',
                'city' => 'Luthersville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30534',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2073000',
                'longitude' => '-84.1411000',
                'city' => 'Dawsonville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30528',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6013000',
                'longitude' => '-83.7662000',
                'city' => 'Cleveland',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30662',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Royston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30603',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Athens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30646',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Hull',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30165',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2599000',
                'longitude' => '-85.1737000',
                'city' => 'Rome',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30609',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Athens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30601',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Athens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30605',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Athens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30607',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Athens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30909',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5138000',
                'longitude' => '-82.1274000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30907',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5138000',
                'longitude' => '-82.1274000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30813',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5138000',
                'longitude' => '-82.1274000',
                'city' => 'Grovetown',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30809',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5138000',
                'longitude' => '-82.1274000',
                'city' => 'Evans',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30576',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8769000',
                'longitude' => '-83.3873000',
                'city' => 'Tiger',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30552',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8769000',
                'longitude' => '-83.3873000',
                'city' => 'Lakemont',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30525',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8769000',
                'longitude' => '-83.3873000',
                'city' => 'Clayton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30634',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1130000',
                'longitude' => '-82.8697000',
                'city' => 'Dewy Rose',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30635',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1130000',
                'longitude' => '-82.8697000',
                'city' => 'Elberton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30912',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30901',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30642',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Greensboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30720',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7640000',
                'longitude' => '-84.9750000',
                'city' => 'Dalton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30721',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7640000',
                'longitude' => '-84.9750000',
                'city' => 'Dalton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30719',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7760000',
                'longitude' => '-84.9668000',
                'city' => 'Dalton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30571',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6013000',
                'longitude' => '-83.7662000',
                'city' => 'Sautee Nacoochee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30533',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6013000',
                'longitude' => '-83.7662000',
                'city' => 'Dahlonega',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30903',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31907',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4753000',
                'longitude' => '-84.9890000',
                'city' => 'Columbus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31903',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4753000',
                'longitude' => '-84.9890000',
                'city' => 'Columbus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31909',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4753000',
                'longitude' => '-84.9890000',
                'city' => 'Columbus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31906',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4753000',
                'longitude' => '-84.9890000',
                'city' => 'Columbus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31901',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4753000',
                'longitude' => '-84.9890000',
                'city' => 'Columbus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31904',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4753000',
                'longitude' => '-84.9890000',
                'city' => 'Columbus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30710',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9591000',
                'longitude' => '-84.9515000',
                'city' => 'Cohutta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30740',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7640000',
                'longitude' => '-84.9750000',
                'city' => 'Rocky Face',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30904',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4751000',
                'longitude' => '-85.3538000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30815',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Hephzibah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30105',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2576000',
                'longitude' => '-85.1688000',
                'city' => 'Armuchee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30161',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2576000',
                'longitude' => '-85.1688000',
                'city' => 'Rome',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30173',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2576000',
                'longitude' => '-85.1688000',
                'city' => 'Silver Creek',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30147',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2576000',
                'longitude' => '-85.1688000',
                'city' => 'Lindale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30162',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2576000',
                'longitude' => '-85.1688000',
                'city' => 'Rome',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30149',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2576000',
                'longitude' => '-85.1688000',
                'city' => 'Mount Berry',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30241',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0385000',
                'longitude' => '-85.0317000',
                'city' => 'Lagrange',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31833',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0385000',
                'longitude' => '-85.0317000',
                'city' => 'West Point',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30240',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0385000',
                'longitude' => '-85.0317000',
                'city' => 'Lagrange',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31820',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4995000',
                'longitude' => '-84.9733000',
                'city' => 'Midland',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31902',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4995000',
                'longitude' => '-84.9733000',
                'city' => 'Columbus',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30577',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.5829000',
                'longitude' => '-83.3299000',
                'city' => 'Toccoa',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30624',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2861000',
                'longitude' => '-83.1140000',
                'city' => 'Bowman',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30520',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2861000',
                'longitude' => '-83.1140000',
                'city' => 'Canon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30516',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2861000',
                'longitude' => '-83.1140000',
                'city' => 'Bowersville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30639',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2861000',
                'longitude' => '-83.1140000',
                'city' => 'Franklin Springs',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30513',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8682000',
                'longitude' => '-84.3277000',
                'city' => 'Blue Ridge',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30630',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Crawford',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30648',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Lexington',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30906',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30701',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4987000',
                'longitude' => '-84.9498000',
                'city' => 'Calhoun',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31810',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5833000',
                'longitude' => '-84.5523000',
                'city' => 'Geneva',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30735',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7640000',
                'longitude' => '-84.9750000',
                'city' => 'Resaca',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30673',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7925000',
                'longitude' => '-82.8903000',
                'city' => 'Washington',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30660',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7925000',
                'longitude' => '-82.8903000',
                'city' => 'Rayle',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30522',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6938000',
                'longitude' => '-84.4862000',
                'city' => 'Cherry Log',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30705',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7640000',
                'longitude' => '-84.9750000',
                'city' => 'Chatsworth',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30668',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8681000',
                'longitude' => '-82.7410000',
                'city' => 'Tignall',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30730',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4111000',
                'longitude' => '-85.4092000',
                'city' => 'Lyerly',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30817',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7668000',
                'longitude' => '-82.6012000',
                'city' => 'Lincolnton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30733',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2576000',
                'longitude' => '-85.1688000',
                'city' => 'Plainville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30802',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5510000',
                'longitude' => '-82.3186000',
                'city' => 'Appling',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30824',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5510000',
                'longitude' => '-82.3186000',
                'city' => 'Thomson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30814',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5510000',
                'longitude' => '-82.3186000',
                'city' => 'Harlem',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30621',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8598000',
                'longitude' => '-83.4105000',
                'city' => 'Bishop',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31808',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4691000',
                'longitude' => '-84.9869000',
                'city' => 'Fortson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31804',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4691000',
                'longitude' => '-84.9869000',
                'city' => 'Cataula',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30663',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6331000',
                'longitude' => '-83.6116000',
                'city' => 'Rutledge',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30711',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9834000',
                'longitude' => '-84.7425000',
                'city' => 'Crandall',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30751',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9834000',
                'longitude' => '-84.7425000',
                'city' => 'Tennga',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30734',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.5035000',
                'longitude' => '-84.7120000',
                'city' => 'Ranger',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30530',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2029000',
                'longitude' => '-83.4597000',
                'city' => 'Commerce',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30521',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2029000',
                'longitude' => '-83.4597000',
                'city' => 'Carnesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30529',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2029000',
                'longitude' => '-83.4597000',
                'city' => 'Commerce',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30549',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2029000',
                'longitude' => '-83.4597000',
                'city' => 'Jefferson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30139',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4332000',
                'longitude' => '-84.7086000',
                'city' => 'Fairmount',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30625',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5948000',
                'longitude' => '-83.4666000',
                'city' => 'Buckhead',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30623',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5948000',
                'longitude' => '-83.4666000',
                'city' => 'Bostwick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30650',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5948000',
                'longitude' => '-83.4666000',
                'city' => 'Madison',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30641',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5948000',
                'longitude' => '-83.4666000',
                'city' => 'Good Hope',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30557',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4362000',
                'longitude' => '-83.1047000',
                'city' => 'Martin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30553',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4362000',
                'longitude' => '-83.1047000',
                'city' => 'Lavonia',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30830',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0940000',
                'longitude' => '-82.0168000',
                'city' => 'Waynesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30567',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1158000',
                'longitude' => '-83.5770000',
                'city' => 'Pendergrass',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30643',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3582000',
                'longitude' => '-82.9344000',
                'city' => 'Hartwell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30602',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9545000',
                'longitude' => '-83.4085000',
                'city' => 'Athens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30559',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8859000',
                'longitude' => '-84.2640000',
                'city' => 'Mineral Bluff',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30512',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8859000',
                'longitude' => '-84.2640000',
                'city' => 'Blairsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30560',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8859000',
                'longitude' => '-84.2640000',
                'city' => 'Morganton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30739',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8750000',
                'longitude' => '-85.2836000',
                'city' => 'Rock Spring',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30736',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8750000',
                'longitude' => '-85.2836000',
                'city' => 'Ringgold',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30707',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8750000',
                'longitude' => '-85.2836000',
                'city' => 'Chickamauga',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30582',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9336000',
                'longitude' => '-83.8505000',
                'city' => 'Young Harris',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30747',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6727000',
                'longitude' => '-85.1196000',
                'city' => 'Summerville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30728',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6727000',
                'longitude' => '-85.1196000',
                'city' => 'La Fayette',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30750',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9334000',
                'longitude' => '-85.4106000',
                'city' => 'Lookout Mountain',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30731',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9334000',
                'longitude' => '-85.4106000',
                'city' => 'Menlo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30752',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9334000',
                'longitude' => '-85.4106000',
                'city' => 'Trenton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30738',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9334000',
                'longitude' => '-85.4106000',
                'city' => 'Rising Fawn',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30742',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '35.0453000',
                'longitude' => '-85.3097000',
                'city' => 'Fort Oglethorpe',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31087',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2756000',
                'longitude' => '-82.9770000',
                'city' => 'Sparta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30633',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1274000',
                'longitude' => '-83.2254000',
                'city' => 'Danielsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30286',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8932000',
                'longitude' => '-84.3277000',
                'city' => 'Thomaston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30546',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9491000',
                'longitude' => '-83.7489000',
                'city' => 'Hiawassee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30558',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.2494000',
                'longitude' => '-83.5672000',
                'city' => 'Maysville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30230',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.1743000',
                'longitude' => '-84.9172000',
                'city' => 'Hogansville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30669',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5781000',
                'longitude' => '-83.1803000',
                'city' => 'Union Point',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30664',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5596000',
                'longitude' => '-82.8938000',
                'city' => 'Sharon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30631',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5596000',
                'longitude' => '-82.8938000',
                'city' => 'Crawfordville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31811',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7599000',
                'longitude' => '-84.8776000',
                'city' => 'Hamilton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31822',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7599000',
                'longitude' => '-84.8776000',
                'city' => 'Pine Mountain',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31831',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6923000',
                'longitude' => '-84.7362000',
                'city' => 'Waverly Hall',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30821',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4075000',
                'longitude' => '-82.6624000',
                'city' => 'Norwood',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30820',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4075000',
                'longitude' => '-82.6624000',
                'city' => 'Mitchell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30807',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4075000',
                'longitude' => '-82.6624000',
                'city' => 'Camak',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30828',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4075000',
                'longitude' => '-82.6624000',
                'city' => 'Warrenton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30678',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5112000',
                'longitude' => '-83.0549000',
                'city' => 'White Plains',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30665',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5112000',
                'longitude' => '-83.0549000',
                'city' => 'Siloam',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31085',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3034000',
                'longitude' => '-83.6853000',
                'city' => 'Shady Dale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30517',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1139000',
                'longitude' => '-83.7581000',
                'city' => 'Braselton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31097',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.9178000',
                'longitude' => '-84.0602000',
                'city' => 'Yatesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30683',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9651000',
                'longitude' => '-83.2747000',
                'city' => 'Winterville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30810',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2341000',
                'longitude' => '-82.5930000',
                'city' => 'Gibson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31826',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8684000',
                'longitude' => '-84.8513000',
                'city' => 'Shiloh',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31823',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8684000',
                'longitude' => '-84.8513000',
                'city' => 'Pine Mountain Valley',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30555',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9900000',
                'longitude' => '-84.3725000',
                'city' => 'Mc Caysville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30541',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9900000',
                'longitude' => '-84.3725000',
                'city' => 'Epworth',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31045',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2756000',
                'longitude' => '-82.9770000',
                'city' => 'Jewell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30919',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30523',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6162000',
                'longitude' => '-83.5227000',
                'city' => 'Clarkesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30539',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6938000',
                'longitude' => '-84.4862000',
                'city' => 'East Ellijay',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30746',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.4987000',
                'longitude' => '-84.9498000',
                'city' => 'Sugar Valley',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30755',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8225000',
                'longitude' => '-85.0441000',
                'city' => 'Tunnel Hill',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30293',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0922000',
                'longitude' => '-84.5778000',
                'city' => 'Woodbury',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30218',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.0922000',
                'longitude' => '-84.5778000',
                'city' => 'Gay',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30628',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9571000',
                'longitude' => '-83.3812000',
                'city' => 'Colbert',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31905',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4282000',
                'longitude' => '-84.9453000',
                'city' => 'Fort Benning',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30803',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2069000',
                'longitude' => '-82.3893000',
                'city' => 'Avera',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30833',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2069000',
                'longitude' => '-82.3893000',
                'city' => 'Wrens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30818',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2069000',
                'longitude' => '-82.3893000',
                'city' => 'Matthews',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30808',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4145000',
                'longitude' => '-82.3130000',
                'city' => 'Dearing',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30905',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4040000',
                'longitude' => '-82.0264000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31807',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4931000',
                'longitude' => '-84.9154000',
                'city' => 'Ellerslie',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31829',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4931000',
                'longitude' => '-84.9154000',
                'city' => 'Upatoi',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30805',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.3158000',
                'longitude' => '-82.0956000',
                'city' => 'Blythe',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30753',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7057000',
                'longitude' => '-85.2824000',
                'city' => 'Trion',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30285',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8892000',
                'longitude' => '-84.3304000',
                'city' => 'The Rock',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30256',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8892000',
                'longitude' => '-84.3304000',
                'city' => 'Meansville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31816',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8905000',
                'longitude' => '-84.6866000',
                'city' => 'Manchester',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31830',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8905000',
                'longitude' => '-84.6866000',
                'city' => 'Warm Springs',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30757',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.8689000',
                'longitude' => '-85.5112000',
                'city' => 'Wildwood',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31827',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.6777000',
                'longitude' => '-84.5398000',
                'city' => 'Talbotton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31836',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7880000',
                'longitude' => '-84.5605000',
                'city' => 'Woodland',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30511',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3329000',
                'longitude' => '-83.4973000',
                'city' => 'Baldwin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30547',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3329000',
                'longitude' => '-83.4973000',
                'city' => 'Homer',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30575',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1610000',
                'longitude' => '-83.6810000',
                'city' => 'Talmo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30619',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9720000',
                'longitude' => '-83.2890000',
                'city' => 'Arnoldsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30627',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8865000',
                'longitude' => '-83.1250000',
                'city' => 'Carlton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30568',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9409000',
                'longitude' => '-83.3874000',
                'city' => 'Rabun Gap',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30562',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9409000',
                'longitude' => '-83.3874000',
                'city' => 'Mountain City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30537',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9409000',
                'longitude' => '-83.3874000',
                'city' => 'Dillard',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30572',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7153000',
                'longitude' => '-84.0288000',
                'city' => 'Suches',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30535',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6162000',
                'longitude' => '-83.5227000',
                'city' => 'Demorest',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30563',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6162000',
                'longitude' => '-83.5227000',
                'city' => 'Mount Airy',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30573',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.6162000',
                'longitude' => '-83.5227000',
                'city' => 'Tallulah Falls',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30565',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1147000',
                'longitude' => '-83.4314000',
                'city' => 'Nicholson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30671',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7779000',
                'longitude' => '-83.1752000',
                'city' => 'Maxeys',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30667',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7779000',
                'longitude' => '-83.1752000',
                'city' => 'Stephens',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30172',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.8748000',
                'longitude' => '-85.1763000',
                'city' => 'Shannon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30531',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.5057000',
                'longitude' => '-83.5244000',
                'city' => 'Cornelia',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30538',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.5291000',
                'longitude' => '-83.2518000',
                'city' => 'Eastanollee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30629',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.0641000',
                'longitude' => '-83.1287000',
                'city' => 'Comer',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30647',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1702000',
                'longitude' => '-83.2915000',
                'city' => 'Ila',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30914',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30545',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.7028000',
                'longitude' => '-83.7339000',
                'city' => 'Helen',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30725',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9965000',
                'longitude' => '-85.3298000',
                'city' => 'Flintstone',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30741',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9965000',
                'longitude' => '-85.3298000',
                'city' => 'Rossville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30916',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.4764000',
                'longitude' => '-81.9684000',
                'city' => 'Augusta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30514',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.9491000',
                'longitude' => '-83.7489000',
                'city' => 'Blairsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30655',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7961000',
                'longitude' => '-83.7156000',
                'city' => 'Monroe',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30224',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2431000',
                'longitude' => '-84.2630000',
                'city' => 'Griffin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30257',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2431000',
                'longitude' => '-84.2630000',
                'city' => 'Milner',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30182',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5383000',
                'longitude' => '-85.2543000',
                'city' => 'Waco',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30154',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Douglasville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30156',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9165000',
                'longitude' => '-84.6442000',
                'city' => 'Kennesaw',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30007',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31145',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30072',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Pine Lake',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30291',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.5668000',
                'longitude' => '-84.5755000',
                'city' => 'Union City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30065',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.7501000',
                'longitude' => '-84.3824000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30229',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Haralson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30325',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31119',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Atlanta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30298',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Forest Park',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30003',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Norcross',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30142',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Holly Springs',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30137',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.1684000',
                'longitude' => '-84.7970000',
                'city' => 'Emerson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30018',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.6601000',
                'longitude' => '-83.7201000',
                'city' => 'Jersey',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30063',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9516000',
                'longitude' => '-84.5507000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30090',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.9516000',
                'longitude' => '-84.5507000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30289',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.2975000',
                'longitude' => '-84.5540000',
                'city' => 'Turin',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30077',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Roswell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30503',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Gainesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30081',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Smyrna',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30177',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3835000',
                'longitude' => '-84.3783000',
                'city' => 'Tate',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30151',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '34.3835000',
                'longitude' => '-84.3783000',
                'city' => 'Nelson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30042',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8221000',
                'longitude' => '-84.2003000',
                'city' => 'Lawrenceville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30061',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Marietta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30046',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '33.8907000',
                'longitude' => '-84.1663000',
                'city' => 'Lawrenceville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31513',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7770000',
                'longitude' => '-82.3489000',
                'city' => 'Baxley',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31405',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0644000',
                'longitude' => '-81.0988000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31404',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0644000',
                'longitude' => '-81.0988000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31415',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0644000',
                'longitude' => '-81.0988000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31546',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.6083000',
                'longitude' => '-81.8835000',
                'city' => 'Jesup',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31532',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8685000',
                'longitude' => '-82.5925000',
                'city' => 'Denton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31539',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8685000',
                'longitude' => '-82.5925000',
                'city' => 'Hazlehurst',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31560',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.4853000',
                'longitude' => '-82.0185000',
                'city' => 'Screven',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31516',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3060000',
                'longitude' => '-82.2414000',
                'city' => 'Blackshear',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30460',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4450000',
                'longitude' => '-81.7832000',
                'city' => 'Statesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30461',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4450000',
                'longitude' => '-81.7832000',
                'city' => 'Statesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31537',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.8351000',
                'longitude' => '-82.0105000',
                'city' => 'Folkston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31519',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.6252000',
                'longitude' => '-82.8946000',
                'city' => 'Broxton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30427',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9413000',
                'longitude' => '-81.9280000',
                'city' => 'Glennville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31522',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1582000',
                'longitude' => '-81.4897000',
                'city' => 'Saint Simons Island',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31523',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1582000',
                'longitude' => '-81.4897000',
                'city' => 'Brunswick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31503',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2102000',
                'longitude' => '-82.3565000',
                'city' => 'Waycross',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31557',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1582000',
                'longitude' => '-81.4897000',
                'city' => 'Patterson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31521',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1582000',
                'longitude' => '-81.4897000',
                'city' => 'Brunswick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31319',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1582000',
                'longitude' => '-81.4897000',
                'city' => 'Meridian',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31558',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7254000',
                'longitude' => '-81.5525000',
                'city' => 'Saint Marys',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31520',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1582000',
                'longitude' => '-81.4897000',
                'city' => 'Brunswick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31408',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0644000',
                'longitude' => '-81.0988000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31406',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0644000',
                'longitude' => '-81.0988000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31402',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0644000',
                'longitude' => '-81.0988000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31525',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1582000',
                'longitude' => '-81.4897000',
                'city' => 'Brunswick',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30420',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3587000',
                'longitude' => '-82.3172000',
                'city' => 'Cobbtown',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30474',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3587000',
                'longitude' => '-82.3172000',
                'city' => 'Vidalia',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31535',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1328000',
                'longitude' => '-81.6239000',
                'city' => 'Douglas',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31634',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '0.0000000',
                'longitude' => '0.0000000',
                'city' => 'Homerville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31421',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0644000',
                'longitude' => '-81.0988000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31545',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.6083000',
                'longitude' => '-81.8835000',
                'city' => 'Jesup',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31598',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1669000',
                'longitude' => '-81.4961000',
                'city' => 'Jesup',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31567',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5070000',
                'longitude' => '-82.8502000',
                'city' => 'West Green',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31533',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5070000',
                'longitude' => '-82.8502000',
                'city' => 'Douglas',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31565',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1669000',
                'longitude' => '-81.4961000',
                'city' => 'Waverly',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31527',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1418000',
                'longitude' => '-81.3762000',
                'city' => 'Jekyll Island',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31315',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8479000',
                'longitude' => '-81.5909000',
                'city' => 'Fort Stewart',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31313',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8479000',
                'longitude' => '-81.5909000',
                'city' => 'Hinesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30410',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2165000',
                'longitude' => '-82.3584000',
                'city' => 'Ailey',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31550',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2165000',
                'longitude' => '-82.3584000',
                'city' => 'Manor',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31501',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2165000',
                'longitude' => '-82.3584000',
                'city' => 'Waycross',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31552',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2165000',
                'longitude' => '-82.3584000',
                'city' => 'Millwood',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30417',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1605000',
                'longitude' => '-81.9071000',
                'city' => 'Claxton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31326',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2926000',
                'longitude' => '-81.2276000',
                'city' => 'Rincon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31510',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5430000',
                'longitude' => '-82.4655000',
                'city' => 'Alma',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31316',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7081000',
                'longitude' => '-81.7452000',
                'city' => 'Ludowici',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31549',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9359000',
                'longitude' => '-82.6839000',
                'city' => 'Lumber City',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31312',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3349000',
                'longitude' => '-81.3925000',
                'city' => 'Guyton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30467',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7479000',
                'longitude' => '-81.6322000',
                'city' => 'Sylvania',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31322',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1178000',
                'longitude' => '-81.2429000',
                'city' => 'Pooler',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31554',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5169000',
                'longitude' => '-82.6452000',
                'city' => 'Nicholls',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30458',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0250000',
                'longitude' => '-81.0953000',
                'city' => 'Statesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31512',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.6228000',
                'longitude' => '-82.8900000',
                'city' => 'Ambrose',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31563',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7770000',
                'longitude' => '-82.3489000',
                'city' => 'Surrency',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31518',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7770000',
                'longitude' => '-82.3489000',
                'city' => 'Bristol',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31333',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8401000',
                'longitude' => '-81.5964000',
                'city' => 'Walthourville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31301',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8401000',
                'longitude' => '-81.5964000',
                'city' => 'Allenhurst',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31314',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8401000',
                'longitude' => '-81.5964000',
                'city' => 'Fort Stewart',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31642',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2988000',
                'longitude' => '-82.8482000',
                'city' => 'Pearson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31650',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5070000',
                'longitude' => '-82.8502000',
                'city' => 'Willacoochee',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30436',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.2024000',
                'longitude' => '-82.3249000',
                'city' => 'Lyons',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31310',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.8401000',
                'longitude' => '-81.5964000',
                'city' => 'Hinesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31624',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2988000',
                'longitude' => '-82.8482000',
                'city' => 'Axson',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31555',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.6597000',
                'longitude' => '-82.0356000',
                'city' => 'Odum',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31410',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0762000',
                'longitude' => '-81.0905000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31305',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3747000',
                'longitude' => '-81.4326000',
                'city' => 'Darien',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31542',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1815000',
                'longitude' => '-82.1338000',
                'city' => 'Hoboken',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31553',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2020000',
                'longitude' => '-81.9766000',
                'city' => 'Nahunta',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31411',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0159000',
                'longitude' => '-80.8421000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31543',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3370000',
                'longitude' => '-81.9586000',
                'city' => 'Hortense',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31328',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0762000',
                'longitude' => '-81.0905000',
                'city' => 'Tybee Island',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31331',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3966000',
                'longitude' => '-81.2795000',
                'city' => 'Townsend',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31327',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3966000',
                'longitude' => '-81.2795000',
                'city' => 'Sapelo Island',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31623',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0373000',
                'longitude' => '-82.7520000',
                'city' => 'Argyle',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31630',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.0373000',
                'longitude' => '-82.7520000',
                'city' => 'Du Pont',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30452',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3672000',
                'longitude' => '-81.8822000',
                'city' => 'Register',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31568',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7515000',
                'longitude' => '-81.5718000',
                'city' => 'White Oak',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31547',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7515000',
                'longitude' => '-81.5718000',
                'city' => 'Kings Bay',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31548',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7515000',
                'longitude' => '-81.5718000',
                'city' => 'Kingsland',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31569',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.7515000',
                'longitude' => '-81.5718000',
                'city' => 'Woodbine',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30457',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3761000',
                'longitude' => '-82.5948000',
                'city' => 'Soperton',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30445',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3761000',
                'longitude' => '-82.5948000',
                'city' => 'Mount Vernon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30470',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3761000',
                'longitude' => '-82.5948000',
                'city' => 'Tarrytown',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31308',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0762000',
                'longitude' => '-81.0905000',
                'city' => 'Ellabell',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30453',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0819000',
                'longitude' => '-82.1193000',
                'city' => 'Reidsville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30421',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0819000',
                'longitude' => '-82.1193000',
                'city' => 'Collins',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30464',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4668000',
                'longitude' => '-82.2988000',
                'city' => 'Stillmore',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30448',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4668000',
                'longitude' => '-82.2988000',
                'city' => 'Nunez',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30473',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0667000',
                'longitude' => '-82.2995000',
                'city' => 'Uvalda',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31309',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.9433000',
                'longitude' => '-81.3097000',
                'city' => 'Fleming',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30412',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0409000',
                'longitude' => '-82.5118000',
                'city' => 'Alston',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31321',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1328000',
                'longitude' => '-81.6239000',
                'city' => 'Pembroke',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31551',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.5430000',
                'longitude' => '-82.4655000',
                'city' => 'Mershon',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31561',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.1891000',
                'longitude' => '-81.3745000',
                'city' => 'Sea Island',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31631',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '30.6893000',
                'longitude' => '-82.5600000',
                'city' => 'Fargo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31556',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.3843000',
                'longitude' => '-82.1442000',
                'city' => 'Offerman',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31420',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0762000',
                'longitude' => '-81.0905000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31416',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0762000',
                'longitude' => '-81.0905000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31403',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.0762000',
                'longitude' => '-81.0905000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30459',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4450000',
                'longitude' => '-81.7832000',
                'city' => 'Statesboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30415',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.4450000',
                'longitude' => '-81.7832000',
                'city' => 'Brooklet',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30429',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1503000',
                'longitude' => '-81.9080000',
                'city' => 'Hagan',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30438',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1503000',
                'longitude' => '-81.9080000',
                'city' => 'Manassas',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31302',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1162000',
                'longitude' => '-81.2503000',
                'city' => 'Bloomingdale',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31329',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3666000',
                'longitude' => '-81.3082000',
                'city' => 'Springfield',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31303',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.3666000',
                'longitude' => '-81.3082000',
                'city' => 'Clyo',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31566',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.2318000',
                'longitude' => '-81.8066000',
                'city' => 'Waynesville',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30446',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5840000',
                'longitude' => '-81.5009000',
                'city' => 'Newington',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30449',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5840000',
                'longitude' => '-81.5009000',
                'city' => 'Oliver',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30455',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.7189000',
                'longitude' => '-81.6592000',
                'city' => 'Rocky Ford',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '30450',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.5432000',
                'longitude' => '-81.9230000',
                'city' => 'Portal',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31320',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7909000',
                'longitude' => '-81.3982000',
                'city' => 'Midway',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31323',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '31.7909000',
                'longitude' => '-81.3982000',
                'city' => 'Riceboro',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31418',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1147000',
                'longitude' => '-81.1643000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
            [
                'zip' => '31407',
                'country_code' => 'US',
                'state' => 'GA',
                'latitude' => '32.1147000',
                'longitude' => '-81.1643000',
                'city' => 'Savannah',
                'full_state' => 'Georgia',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
