<?php

namespace Database\Seeders\ImmutableData;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\SalesChannel;
use App\Models\Setting;
use App\Models\Store;
use Illuminate\Database\Seeder;

class SalesChannelsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default store if no store exists
        /** @var Store $store */
        $store = Store::query()->firstOrCreate([], [
            'name' => Store::DEFAULT_SKUIO_STORE_NAME,
            'email' => 'dev@sku.io',
            'logo_url' => '/images/SKUIO_LOGO.png',
        ]);

        // Sets the default store for sales orders if the setting does not already exist
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_SO_DEFAULT_STORE],
            [
                'description' => 'Default Store for Sales Orders',
                'type' => Setting::TYPE_INTEGER,
                'value' => $store->id,
                'default_value' => $store->id,
            ]);

        // Sets the default store for purchase orders if the setting does not already exist
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_PO_DEFAULT_STORE],
            [
                'description' => 'Default Store for Purchase Orders',
                'type' => Setting::TYPE_INTEGER,
                'value' => $store->id,
                'default_value' => $store->id,
            ]);

        // Get the sku integration instance
        /** @var IntegrationInstance $skuIntegrationInstance */
        $skuIntegrationInstance = IntegrationInstance::with([])->whereHas('integration', function ($query) {
            $query->where('name', Integration::NAME_SKU_IO);
        })->firstOrFail();

        // Create local sales channel if it does not exist
        SalesChannel::query()->firstOrCreate(['id' => SalesChannel::LOCAL_CHANNEL_ID], [
            'store_id' => $store->id,
            'integration_instance_id' => $skuIntegrationInstance->id,
        ]);
    }
}
