<?php

namespace Database\Seeders\ImmutableData;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConstantsStatesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $states = collect([
            ['name' => 'Andaman and Nicobar Islands', 'country_code' => 'IN'],
            ['name' => 'Andhra Pradesh', 'country_code' => 'IN'],
            ['name' => 'Arunachal Pradesh', 'country_code' => 'IN'],
            ['name' => 'Assam', 'country_code' => 'IN'],
            ['name' => 'Bihar', 'country_code' => 'IN'],
            ['name' => 'Chandigarh', 'country_code' => 'IN'],
            ['name' => 'Chhattisgarh', 'country_code' => 'IN'],
            ['name' => 'Dadra and Nagar Haveli', 'country_code' => 'IN'],
            ['name' => 'Daman and Diu', 'country_code' => 'IN'],
            ['name' => 'Delhi', 'country_code' => 'IN'],
            ['name' => 'Goa', 'country_code' => 'IN'],
            ['name' => 'Gujarat', 'country_code' => 'IN'],
            ['name' => 'Haryana', 'country_code' => 'IN'],
            ['name' => 'Himachal Pradesh', 'country_code' => 'IN'],
            ['name' => 'Jammu and Kashmir', 'country_code' => 'IN'],
            ['name' => 'Jharkhand', 'country_code' => 'IN'],
            ['name' => 'Karnataka', 'country_code' => 'IN'],
            ['name' => 'Kenmore', 'country_code' => 'IN'],
            ['name' => 'Kerala', 'country_code' => 'IN'],
            ['name' => 'Lakshadweep', 'country_code' => 'IN'],
            ['name' => 'Madhya Pradesh', 'country_code' => 'IN'],
            ['name' => 'Maharashtra', 'country_code' => 'IN'],
            ['name' => 'Manipur', 'country_code' => 'IN'],
            ['name' => 'Meghalaya', 'country_code' => 'IN'],
            ['name' => 'Mizoram', 'country_code' => 'IN'],
            ['name' => 'Nagaland', 'country_code' => 'IN'],
            ['name' => 'Narora', 'country_code' => 'IN'],
            ['name' => 'Natwar', 'country_code' => 'IN'],
            ['name' => 'Odisha', 'country_code' => 'IN'],
            ['name' => 'Paschim Medinipur', 'country_code' => 'IN'],
            ['name' => 'Pondicherry', 'country_code' => 'IN'],
            ['name' => 'Punjab', 'country_code' => 'IN'],
            ['name' => 'Rajasthan', 'country_code' => 'IN'],
            ['name' => 'Sikkim', 'country_code' => 'IN'],
            ['name' => 'Tamil Nadu', 'country_code' => 'IN'],
            ['name' => 'Telangana', 'country_code' => 'IN'],
            ['name' => 'Tripura', 'country_code' => 'IN'],
            ['name' => 'Uttar Pradesh', 'country_code' => 'IN'],
            ['name' => 'Uttarakhand', 'country_code' => 'IN'],
            ['name' => 'Vaishali', 'country_code' => 'IN'],
            ['name' => 'West Bengal', 'country_code' => 'IN'],
            ['name' => 'Badakhshan', 'country_code' => 'AF'],
            ['name' => 'Badgis', 'country_code' => 'AF'],
            ['name' => 'Baglan', 'country_code' => 'AF'],
            ['name' => 'Balkh', 'country_code' => 'AF'],
            ['name' => 'Bamiyan', 'country_code' => 'AF'],
            ['name' => 'Farah', 'country_code' => 'AF'],
            ['name' => 'Faryab', 'country_code' => 'AF'],
            ['name' => 'Gawr', 'country_code' => 'AF'],
            ['name' => 'Gazni', 'country_code' => 'AF'],
            ['name' => 'Herat', 'country_code' => 'AF'],
            ['name' => 'Hilmand', 'country_code' => 'AF'],
            ['name' => 'Jawzjan', 'country_code' => 'AF'],
            ['name' => 'Kabul', 'country_code' => 'AF'],
            ['name' => 'Kapisa', 'country_code' => 'AF'],
            ['name' => 'Khawst', 'country_code' => 'AF'],
            ['name' => 'Kunar', 'country_code' => 'AF'],
            ['name' => 'Lagman', 'country_code' => 'AF'],
            ['name' => 'Lawghar', 'country_code' => 'AF'],
            ['name' => 'Nangarhar', 'country_code' => 'AF'],
            ['name' => 'Nimruz', 'country_code' => 'AF'],
            ['name' => 'Nuristan', 'country_code' => 'AF'],
            ['name' => 'Paktika', 'country_code' => 'AF'],
            ['name' => 'Paktiya', 'country_code' => 'AF'],
            ['name' => 'Parwan', 'country_code' => 'AF'],
            ['name' => 'Qandahar', 'country_code' => 'AF'],
            ['name' => 'Qunduz', 'country_code' => 'AF'],
            ['name' => 'Samangan', 'country_code' => 'AF'],
            ['name' => 'Sar-e Pul', 'country_code' => 'AF'],
            ['name' => 'Takhar', 'country_code' => 'AF'],
            ['name' => 'Uruzgan', 'country_code' => 'AF'],
            ['name' => 'Wardak', 'country_code' => 'AF'],
            ['name' => 'Zabul', 'country_code' => 'AF'],
            ['name' => 'Berat', 'country_code' => 'AL'],
            ['name' => 'Bulqize', 'country_code' => 'AL'],
            ['name' => 'Delvine', 'country_code' => 'AL'],
            ['name' => 'Devoll', 'country_code' => 'AL'],
            ['name' => 'Dibre', 'country_code' => 'AL'],
            ['name' => 'Durres', 'country_code' => 'AL'],
            ['name' => 'Elbasan', 'country_code' => 'AL'],
            ['name' => 'Fier', 'country_code' => 'AL'],
            ['name' => 'Gjirokaster', 'country_code' => 'AL'],
            ['name' => 'Gramsh', 'country_code' => 'AL'],
            ['name' => 'Has', 'country_code' => 'AL'],
            ['name' => 'Kavaje', 'country_code' => 'AL'],
            ['name' => 'Kolonje', 'country_code' => 'AL'],
            ['name' => 'Korce', 'country_code' => 'AL'],
            ['name' => 'Kruje', 'country_code' => 'AL'],
            ['name' => 'Kucove', 'country_code' => 'AL'],
            ['name' => 'Kukes', 'country_code' => 'AL'],
            ['name' => 'Kurbin', 'country_code' => 'AL'],
            ['name' => 'Lezhe', 'country_code' => 'AL'],
            ['name' => 'Librazhd', 'country_code' => 'AL'],
            ['name' => 'Lushnje', 'country_code' => 'AL'],
            ['name' => 'Mallakaster', 'country_code' => 'AL'],
            ['name' => 'Malsi e Madhe', 'country_code' => 'AL'],
            ['name' => 'Mat', 'country_code' => 'AL'],
            ['name' => 'Mirdite', 'country_code' => 'AL'],
            ['name' => 'Peqin', 'country_code' => 'AL'],
            ['name' => 'Permet', 'country_code' => 'AL'],
            ['name' => 'Pogradec', 'country_code' => 'AL'],
            ['name' => 'Puke', 'country_code' => 'AL'],
            ['name' => 'Sarande', 'country_code' => 'AL'],
            ['name' => 'Shkoder', 'country_code' => 'AL'],
            ['name' => 'Skrapar', 'country_code' => 'AL'],
            ['name' => 'Tepelene', 'country_code' => 'AL'],
            ['name' => 'Tirane', 'country_code' => 'AL'],
            ['name' => 'Tropoje', 'country_code' => 'AL'],
            ['name' => 'Vlore', 'country_code' => 'AL'],
            ['name' => "'Ayn Daflah", 'country_code' => 'DZ'],
            ['name' => "'Ayn Tamushanat", 'country_code' => 'DZ'],
            ['name' => 'Adrar', 'country_code' => 'DZ'],
            ['name' => 'Algiers', 'country_code' => 'DZ'],
            ['name' => 'Annabah', 'country_code' => 'DZ'],
            ['name' => 'Bashshar', 'country_code' => 'DZ'],
            ['name' => 'Batnah', 'country_code' => 'DZ'],
            ['name' => 'Bijayah', 'country_code' => 'DZ'],
            ['name' => 'Biskrah', 'country_code' => 'DZ'],
            ['name' => 'Blidah', 'country_code' => 'DZ'],
            ['name' => 'Buirah', 'country_code' => 'DZ'],
            ['name' => 'Bumardas', 'country_code' => 'DZ'],
            ['name' => 'Burj Bu Arririj', 'country_code' => 'DZ'],
            ['name' => 'Ghalizan', 'country_code' => 'DZ'],
            ['name' => 'Ghardayah', 'country_code' => 'DZ'],
            ['name' => 'Ilizi', 'country_code' => 'DZ'],
            ['name' => 'Jijili', 'country_code' => 'DZ'],
            ['name' => 'Jilfah', 'country_code' => 'DZ'],
            ['name' => 'Khanshalah', 'country_code' => 'DZ'],
            ['name' => 'Masilah', 'country_code' => 'DZ'],
            ['name' => 'Midyah', 'country_code' => 'DZ'],
            ['name' => 'Milah', 'country_code' => 'DZ'],
            ['name' => 'Muaskar', 'country_code' => 'DZ'],
            ['name' => 'Mustaghanam', 'country_code' => 'DZ'],
            ['name' => 'Naama', 'country_code' => 'DZ'],
            ['name' => 'Oran', 'country_code' => 'DZ'],
            ['name' => 'Ouargla', 'country_code' => 'DZ'],
            ['name' => 'Qalmah', 'country_code' => 'DZ'],
            ['name' => 'Qustantinah', 'country_code' => 'DZ'],
            ['name' => 'Sakikdah', 'country_code' => 'DZ'],
            ['name' => 'Satif', 'country_code' => 'DZ'],
            ['name' => "Sayda'", 'country_code' => 'DZ'],
            ['name' => "Sidi ban-al-'Abbas", 'country_code' => 'DZ'],
            ['name' => 'Suq Ahras', 'country_code' => 'DZ'],
            ['name' => 'Tamanghasat', 'country_code' => 'DZ'],
            ['name' => 'Tibazah', 'country_code' => 'DZ'],
            ['name' => 'Tibissah', 'country_code' => 'DZ'],
            ['name' => 'Tilimsan', 'country_code' => 'DZ'],
            ['name' => 'Tinduf', 'country_code' => 'DZ'],
            ['name' => 'Tisamsilt', 'country_code' => 'DZ'],
            ['name' => 'Tiyarat', 'country_code' => 'DZ'],
            ['name' => 'Tizi Wazu', 'country_code' => 'DZ'],
            ['name' => 'Umm-al-Bawaghi', 'country_code' => 'DZ'],
            ['name' => 'Wahran', 'country_code' => 'DZ'],
            ['name' => 'Warqla', 'country_code' => 'DZ'],
            ['name' => 'Wilaya d Alger', 'country_code' => 'DZ'],
            ['name' => 'Wilaya de Bejaia', 'country_code' => 'DZ'],
            ['name' => 'Wilaya de Constantine', 'country_code' => 'DZ'],
            ['name' => 'al-Aghwat', 'country_code' => 'DZ'],
            ['name' => 'al-Bayadh', 'country_code' => 'DZ'],
            ['name' => "al-Jaza'ir", 'country_code' => 'DZ'],
            ['name' => 'al-Wad', 'country_code' => 'DZ'],
            ['name' => 'ash-Shalif', 'country_code' => 'DZ'],
            ['name' => 'at-Tarif', 'country_code' => 'DZ'],
            ['name' => 'Eastern', 'country_code' => 'AS'],
            ['name' => "Manu'a", 'country_code' => 'AS'],
            ['name' => 'Swains Island', 'country_code' => 'AS'],
            ['name' => 'Western', 'country_code' => 'AS'],
            ['name' => 'Andorra la Vella', 'country_code' => 'AD'],
            ['name' => 'Canillo', 'country_code' => 'AD'],
            ['name' => 'Encamp', 'country_code' => 'AD'],
            ['name' => 'La Massana', 'country_code' => 'AD'],
            ['name' => 'Les Escaldes', 'country_code' => 'AD'],
            ['name' => 'Ordino', 'country_code' => 'AD'],
            ['name' => 'Sant Julia de Loria', 'country_code' => 'AD'],
            ['name' => 'Bengo', 'country_code' => 'AO'],
            ['name' => 'Benguela', 'country_code' => 'AO'],
            ['name' => 'Bie', 'country_code' => 'AO'],
            ['name' => 'Cabinda', 'country_code' => 'AO'],
            ['name' => 'Cunene', 'country_code' => 'AO'],
            ['name' => 'Huambo', 'country_code' => 'AO'],
            ['name' => 'Huila', 'country_code' => 'AO'],
            ['name' => 'Kuando-Kubango', 'country_code' => 'AO'],
            ['name' => 'Kwanza Norte', 'country_code' => 'AO'],
            ['name' => 'Kwanza Sul', 'country_code' => 'AO'],
            ['name' => 'Luanda', 'country_code' => 'AO'],
            ['name' => 'Lunda Norte', 'country_code' => 'AO'],
            ['name' => 'Lunda Sul', 'country_code' => 'AO'],
            ['name' => 'Malanje', 'country_code' => 'AO'],
            ['name' => 'Moxico', 'country_code' => 'AO'],
            ['name' => 'Namibe', 'country_code' => 'AO'],
            ['name' => 'Uige', 'country_code' => 'AO'],
            ['name' => 'Zaire', 'country_code' => 'AO'],
            ['name' => 'Other Provinces', 'country_code' => 'AI'],
            ['name' => "Sector claimed by Argentina\/Ch", 'country_code' => 'AQ'],
            ['name' => "Sector claimed by Argentina\/UK", 'country_code' => 'AQ'],
            ['name' => 'Sector claimed by Australia', 'country_code' => 'AQ'],
            ['name' => 'Sector claimed by France', 'country_code' => 'AQ'],
            ['name' => 'Sector claimed by New Zealand', 'country_code' => 'AQ'],
            ['name' => 'Sector claimed by Norway', 'country_code' => 'AQ'],
            ['name' => 'Unclaimed Sector', 'country_code' => 'AQ'],
            ['name' => 'Barbuda', 'country_code' => 'AG'],
            ['name' => 'Saint George', 'country_code' => 'AG'],
            ['name' => 'Saint John', 'country_code' => 'AG'],
            ['name' => 'Saint Mary', 'country_code' => 'AG'],
            ['name' => 'Saint Paul', 'country_code' => 'AG'],
            ['name' => 'Saint Peter', 'country_code' => 'AG'],
            ['name' => 'Saint Philip', 'country_code' => 'AG'],
            ['name' => 'Buenos Aires', 'country_code' => 'AR'],
            ['name' => 'Catamarca', 'country_code' => 'AR'],
            ['name' => 'Chaco', 'country_code' => 'AR'],
            ['name' => 'Chubut', 'country_code' => 'AR'],
            ['name' => 'Cordoba', 'country_code' => 'AR'],
            ['name' => 'Corrientes', 'country_code' => 'AR'],
            ['name' => 'Distrito Federal', 'country_code' => 'AR'],
            ['name' => 'Entre Rios', 'country_code' => 'AR'],
            ['name' => 'Formosa', 'country_code' => 'AR'],
            ['name' => 'Jujuy', 'country_code' => 'AR'],
            ['name' => 'La Pampa', 'country_code' => 'AR'],
            ['name' => 'La Rioja', 'country_code' => 'AR'],
            ['name' => 'Mendoza', 'country_code' => 'AR'],
            ['name' => 'Misiones', 'country_code' => 'AR'],
            ['name' => 'Neuquen', 'country_code' => 'AR'],
            ['name' => 'Rio Negro', 'country_code' => 'AR'],
            ['name' => 'Salta', 'country_code' => 'AR'],
            ['name' => 'San Juan', 'country_code' => 'AR'],
            ['name' => 'San Luis', 'country_code' => 'AR'],
            ['name' => 'Santa Cruz', 'country_code' => 'AR'],
            ['name' => 'Santa Fe', 'country_code' => 'AR'],
            ['name' => 'Santiago del Estero', 'country_code' => 'AR'],
            ['name' => 'Tierra del Fuego', 'country_code' => 'AR'],
            ['name' => 'Tucuman', 'country_code' => 'AR'],
            ['name' => 'Aragatsotn', 'country_code' => 'AM'],
            ['name' => 'Ararat', 'country_code' => 'AM'],
            ['name' => 'Armavir', 'country_code' => 'AM'],
            ['name' => 'Gegharkunik', 'country_code' => 'AM'],
            ['name' => 'Kotaik', 'country_code' => 'AM'],
            ['name' => 'Lori', 'country_code' => 'AM'],
            ['name' => 'Shirak', 'country_code' => 'AM'],
            ['name' => 'Stepanakert', 'country_code' => 'AM'],
            ['name' => 'Syunik', 'country_code' => 'AM'],
            ['name' => 'Tavush', 'country_code' => 'AM'],
            ['name' => 'Vayots Dzor', 'country_code' => 'AM'],
            ['name' => 'Yerevan', 'country_code' => 'AM'],
            ['name' => 'Aruba', 'country_code' => 'AW'],
            ['name' => 'Auckland', 'country_code' => 'AU'],
            ['name' => 'Australian Capital Territory', 'country_code' => 'AU'],
            ['name' => 'Balgowlah', 'country_code' => 'AU'],
            ['name' => 'Balmain', 'country_code' => 'AU'],
            ['name' => 'Bankstown', 'country_code' => 'AU'],
            ['name' => 'Baulkham Hills', 'country_code' => 'AU'],
            ['name' => 'Bonnet Bay', 'country_code' => 'AU'],
            ['name' => 'Camberwell', 'country_code' => 'AU'],
            ['name' => 'Carole Park', 'country_code' => 'AU'],
            ['name' => 'Castle Hill', 'country_code' => 'AU'],
            ['name' => 'Caulfield', 'country_code' => 'AU'],
            ['name' => 'Chatswood', 'country_code' => 'AU'],
            ['name' => 'Cheltenham', 'country_code' => 'AU'],
            ['name' => 'Cherrybrook', 'country_code' => 'AU'],
            ['name' => 'Clayton', 'country_code' => 'AU'],
            ['name' => 'Collingwood', 'country_code' => 'AU'],
            ['name' => 'Frenchs Forest', 'country_code' => 'AU'],
            ['name' => 'Hawthorn', 'country_code' => 'AU'],
            ['name' => 'Jannnali', 'country_code' => 'AU'],
            ['name' => 'Knoxfield', 'country_code' => 'AU'],
            ['name' => 'Melbourne', 'country_code' => 'AU'],
            ['name' => 'New South Wales', 'country_code' => 'AU'],
            ['name' => 'Northern Territory', 'country_code' => 'AU'],
            ['name' => 'Perth', 'country_code' => 'AU'],
            ['name' => 'Queensland', 'country_code' => 'AU'],
            ['name' => 'South Australia', 'country_code' => 'AU'],
            ['name' => 'Tasmania', 'country_code' => 'AU'],
            ['name' => 'Templestowe', 'country_code' => 'AU'],
            ['name' => 'Victoria', 'country_code' => 'AU'],
            ['name' => 'Werribee south', 'country_code' => 'AU'],
            ['name' => 'Western Australia', 'country_code' => 'AU'],
            ['name' => 'Wheeler', 'country_code' => 'AU'],
            ['name' => 'Bundesland Salzburg', 'country_code' => 'AT'],
            ['name' => 'Bundesland Steiermark', 'country_code' => 'AT'],
            ['name' => 'Bundesland Tirol', 'country_code' => 'AT'],
            ['name' => 'Burgenland', 'country_code' => 'AT'],
            ['name' => 'Carinthia', 'country_code' => 'AT'],
            ['name' => 'Karnten', 'country_code' => 'AT'],
            ['name' => 'Liezen', 'country_code' => 'AT'],
            ['name' => 'Lower Austria', 'country_code' => 'AT'],
            ['name' => 'Niederosterreich', 'country_code' => 'AT'],
            ['name' => 'Oberosterreich', 'country_code' => 'AT'],
            ['name' => 'Salzburg', 'country_code' => 'AT'],
            ['name' => 'Schleswig-Holstein', 'country_code' => 'AT'],
            ['name' => 'Steiermark', 'country_code' => 'AT'],
            ['name' => 'Styria', 'country_code' => 'AT'],
            ['name' => 'Tirol', 'country_code' => 'AT'],
            ['name' => 'Upper Austria', 'country_code' => 'AT'],
            ['name' => 'Vorarlberg', 'country_code' => 'AT'],
            ['name' => 'Wien', 'country_code' => 'AT'],
            ['name' => 'Abseron', 'country_code' => 'AZ'],
            ['name' => 'Baki Sahari', 'country_code' => 'AZ'],
            ['name' => 'Ganca', 'country_code' => 'AZ'],
            ['name' => 'Ganja', 'country_code' => 'AZ'],
            ['name' => 'Kalbacar', 'country_code' => 'AZ'],
            ['name' => 'Lankaran', 'country_code' => 'AZ'],
            ['name' => 'Mil-Qarabax', 'country_code' => 'AZ'],
            ['name' => 'Mugan-Salyan', 'country_code' => 'AZ'],
            ['name' => 'Nagorni-Qarabax', 'country_code' => 'AZ'],
            ['name' => 'Naxcivan', 'country_code' => 'AZ'],
            ['name' => 'Priaraks', 'country_code' => 'AZ'],
            ['name' => 'Qazax', 'country_code' => 'AZ'],
            ['name' => 'Saki', 'country_code' => 'AZ'],
            ['name' => 'Sirvan', 'country_code' => 'AZ'],
            ['name' => 'Xacmaz', 'country_code' => 'AZ'],
            ['name' => 'Abaco', 'country_code' => 'BS'],
            ['name' => 'Acklins Island', 'country_code' => 'BS'],
            ['name' => 'Andros', 'country_code' => 'BS'],
            ['name' => 'Berry Islands', 'country_code' => 'BS'],
            ['name' => 'Biminis', 'country_code' => 'BS'],
            ['name' => 'Cat Island', 'country_code' => 'BS'],
            ['name' => 'Crooked Island', 'country_code' => 'BS'],
            ['name' => 'Eleuthera', 'country_code' => 'BS'],
            ['name' => 'Exuma and Cays', 'country_code' => 'BS'],
            ['name' => 'Grand Bahama', 'country_code' => 'BS'],
            ['name' => 'Inagua Islands', 'country_code' => 'BS'],
            ['name' => 'Long Island', 'country_code' => 'BS'],
            ['name' => 'Mayaguana', 'country_code' => 'BS'],
            ['name' => 'New Providence', 'country_code' => 'BS'],
            ['name' => 'Ragged Island', 'country_code' => 'BS'],
            ['name' => 'Rum Cay', 'country_code' => 'BS'],
            ['name' => 'San Salvador', 'country_code' => 'BS'],
            ['name' => "'Isa", 'country_code' => 'BH'],
            ['name' => 'Badiyah', 'country_code' => 'BH'],
            ['name' => 'Hidd', 'country_code' => 'BH'],
            ['name' => 'Jidd Hafs', 'country_code' => 'BH'],
            ['name' => 'Mahama', 'country_code' => 'BH'],
            ['name' => 'Manama', 'country_code' => 'BH'],
            ['name' => 'Sitrah', 'country_code' => 'BH'],
            ['name' => 'al-Manamah', 'country_code' => 'BH'],
            ['name' => 'al-Muharraq', 'country_code' => 'BH'],
            ['name' => "ar-Rifa'a", 'country_code' => 'BH'],
            ['name' => 'Bagar Hat', 'country_code' => 'BD'],
            ['name' => 'Bandarban', 'country_code' => 'BD'],
            ['name' => 'Barguna', 'country_code' => 'BD'],
            ['name' => 'Barisal', 'country_code' => 'BD'],
            ['name' => 'Bhola', 'country_code' => 'BD'],
            ['name' => 'Bogora', 'country_code' => 'BD'],
            ['name' => 'Brahman Bariya', 'country_code' => 'BD'],
            ['name' => 'Chandpur', 'country_code' => 'BD'],
            ['name' => 'Chattagam', 'country_code' => 'BD'],
            ['name' => 'Chittagong Division', 'country_code' => 'BD'],
            ['name' => 'Chuadanga', 'country_code' => 'BD'],
            ['name' => 'Dhaka', 'country_code' => 'BD'],
            ['name' => 'Dinajpur', 'country_code' => 'BD'],
            ['name' => 'Faridpur', 'country_code' => 'BD'],
            ['name' => 'Feni', 'country_code' => 'BD'],
            ['name' => 'Gaybanda', 'country_code' => 'BD'],
            ['name' => 'Gazipur', 'country_code' => 'BD'],
            ['name' => 'Gopalganj', 'country_code' => 'BD'],
            ['name' => 'Habiganj', 'country_code' => 'BD'],
            ['name' => 'Jaipur Hat', 'country_code' => 'BD'],
            ['name' => 'Jamalpur', 'country_code' => 'BD'],
            ['name' => 'Jessor', 'country_code' => 'BD'],
            ['name' => 'Jhalakati', 'country_code' => 'BD'],
            ['name' => 'Jhanaydah', 'country_code' => 'BD'],
            ['name' => 'Khagrachhari', 'country_code' => 'BD'],
            ['name' => 'Khulna', 'country_code' => 'BD'],
            ['name' => 'Kishorganj', 'country_code' => 'BD'],
            ['name' => 'Koks Bazar', 'country_code' => 'BD'],
            ['name' => 'Komilla', 'country_code' => 'BD'],
            ['name' => 'Kurigram', 'country_code' => 'BD'],
            ['name' => 'Kushtiya', 'country_code' => 'BD'],
            ['name' => 'Lakshmipur', 'country_code' => 'BD'],
            ['name' => 'Lalmanir Hat', 'country_code' => 'BD'],
            ['name' => 'Madaripur', 'country_code' => 'BD'],
            ['name' => 'Magura', 'country_code' => 'BD'],
            ['name' => 'Maimansingh', 'country_code' => 'BD'],
            ['name' => 'Manikganj', 'country_code' => 'BD'],
            ['name' => 'Maulvi Bazar', 'country_code' => 'BD'],
            ['name' => 'Meherpur', 'country_code' => 'BD'],
            ['name' => 'Munshiganj', 'country_code' => 'BD'],
            ['name' => 'Naral', 'country_code' => 'BD'],
            ['name' => 'Narayanganj', 'country_code' => 'BD'],
            ['name' => 'Narsingdi', 'country_code' => 'BD'],
            ['name' => 'Nator', 'country_code' => 'BD'],
            ['name' => 'Naugaon', 'country_code' => 'BD'],
            ['name' => 'Nawabganj', 'country_code' => 'BD'],
            ['name' => 'Netrakona', 'country_code' => 'BD'],
            ['name' => 'Nilphamari', 'country_code' => 'BD'],
            ['name' => 'Noakhali', 'country_code' => 'BD'],
            ['name' => 'Pabna', 'country_code' => 'BD'],
            ['name' => 'Panchagarh', 'country_code' => 'BD'],
            ['name' => 'Patuakhali', 'country_code' => 'BD'],
            ['name' => 'Pirojpur', 'country_code' => 'BD'],
            ['name' => 'Rajbari', 'country_code' => 'BD'],
            ['name' => 'Rajshahi', 'country_code' => 'BD'],
            ['name' => 'Rangamati', 'country_code' => 'BD'],
            ['name' => 'Rangpur', 'country_code' => 'BD'],
            ['name' => 'Satkhira', 'country_code' => 'BD'],
            ['name' => 'Shariatpur', 'country_code' => 'BD'],
            ['name' => 'Sherpur', 'country_code' => 'BD'],
            ['name' => 'Silhat', 'country_code' => 'BD'],
            ['name' => 'Sirajganj', 'country_code' => 'BD'],
            ['name' => 'Sunamganj', 'country_code' => 'BD'],
            ['name' => 'Tangayal', 'country_code' => 'BD'],
            ['name' => 'Thakurgaon', 'country_code' => 'BD'],
            ['name' => 'Christ Church', 'country_code' => 'BB'],
            ['name' => 'Saint Andrew', 'country_code' => 'BB'],
            ['name' => 'Saint George', 'country_code' => 'BB'],
            ['name' => 'Saint James', 'country_code' => 'BB'],
            ['name' => 'Saint John', 'country_code' => 'BB'],
            ['name' => 'Saint Joseph', 'country_code' => 'BB'],
            ['name' => 'Saint Lucy', 'country_code' => 'BB'],
            ['name' => 'Saint Michael', 'country_code' => 'BB'],
            ['name' => 'Saint Peter', 'country_code' => 'BB'],
            ['name' => 'Saint Philip', 'country_code' => 'BB'],
            ['name' => 'Saint Thomas', 'country_code' => 'BB'],
            ['name' => 'Brest', 'country_code' => 'BY'],
            ['name' => "Homjel'", 'country_code' => 'BY'],
            ['name' => 'Hrodna', 'country_code' => 'BY'],
            ['name' => 'Mahiljow', 'country_code' => 'BY'],
            ['name' => 'Mahilyowskaya Voblasts', 'country_code' => 'BY'],
            ['name' => 'Minsk', 'country_code' => 'BY'],
            ['name' => "Minskaja Voblasts'", 'country_code' => 'BY'],
            ['name' => 'Petrik', 'country_code' => 'BY'],
            ['name' => 'Vicebsk', 'country_code' => 'BY'],
            ['name' => 'Antwerpen', 'country_code' => 'BE'],
            ['name' => 'Berchem', 'country_code' => 'BE'],
            ['name' => 'Brabant', 'country_code' => 'BE'],
            ['name' => 'Brabant Wallon', 'country_code' => 'BE'],
            ['name' => 'Brussel', 'country_code' => 'BE'],
            ['name' => 'East Flanders', 'country_code' => 'BE'],
            ['name' => 'Hainaut', 'country_code' => 'BE'],
            ['name' => 'Liege', 'country_code' => 'BE'],
            ['name' => 'Limburg', 'country_code' => 'BE'],
            ['name' => 'Luxembourg', 'country_code' => 'BE'],
            ['name' => 'Namur', 'country_code' => 'BE'],
            ['name' => 'Ontario', 'country_code' => 'BE'],
            ['name' => 'Oost-Vlaanderen', 'country_code' => 'BE'],
            ['name' => 'Provincie Brabant', 'country_code' => 'BE'],
            ['name' => 'Vlaams-Brabant', 'country_code' => 'BE'],
            ['name' => 'Wallonne', 'country_code' => 'BE'],
            ['name' => 'West-Vlaanderen', 'country_code' => 'BE'],
            ['name' => 'Belize', 'country_code' => 'BZ'],
            ['name' => 'Cayo', 'country_code' => 'BZ'],
            ['name' => 'Corozal', 'country_code' => 'BZ'],
            ['name' => 'Orange Walk', 'country_code' => 'BZ'],
            ['name' => 'Stann Creek', 'country_code' => 'BZ'],
            ['name' => 'Toledo', 'country_code' => 'BZ'],
            ['name' => 'Alibori', 'country_code' => 'BJ'],
            ['name' => 'Atacora', 'country_code' => 'BJ'],
            ['name' => 'Atlantique', 'country_code' => 'BJ'],
            ['name' => 'Borgou', 'country_code' => 'BJ'],
            ['name' => 'Collines', 'country_code' => 'BJ'],
            ['name' => 'Couffo', 'country_code' => 'BJ'],
            ['name' => 'Donga', 'country_code' => 'BJ'],
            ['name' => 'Littoral', 'country_code' => 'BJ'],
            ['name' => 'Mono', 'country_code' => 'BJ'],
            ['name' => 'Oueme', 'country_code' => 'BJ'],
            ['name' => 'Plateau', 'country_code' => 'BJ'],
            ['name' => 'Zou', 'country_code' => 'BJ'],
            ['name' => 'Hamilton', 'country_code' => 'BM'],
            ['name' => 'Saint George', 'country_code' => 'BM'],
            ['name' => 'Bumthang', 'country_code' => 'BT'],
            ['name' => 'Chhukha', 'country_code' => 'BT'],
            ['name' => 'Chirang', 'country_code' => 'BT'],
            ['name' => 'Daga', 'country_code' => 'BT'],
            ['name' => 'Geylegphug', 'country_code' => 'BT'],
            ['name' => 'Ha', 'country_code' => 'BT'],
            ['name' => 'Lhuntshi', 'country_code' => 'BT'],
            ['name' => 'Mongar', 'country_code' => 'BT'],
            ['name' => 'Pemagatsel', 'country_code' => 'BT'],
            ['name' => 'Punakha', 'country_code' => 'BT'],
            ['name' => 'Rinpung', 'country_code' => 'BT'],
            ['name' => 'Samchi', 'country_code' => 'BT'],
            ['name' => 'Samdrup Jongkhar', 'country_code' => 'BT'],
            ['name' => 'Shemgang', 'country_code' => 'BT'],
            ['name' => 'Tashigang', 'country_code' => 'BT'],
            ['name' => 'Timphu', 'country_code' => 'BT'],
            ['name' => 'Tongsa', 'country_code' => 'BT'],
            ['name' => 'Wangdiphodrang', 'country_code' => 'BT'],
            ['name' => 'Beni', 'country_code' => 'BO'],
            ['name' => 'Chuquisaca', 'country_code' => 'BO'],
            ['name' => 'Cochabamba', 'country_code' => 'BO'],
            ['name' => 'La Paz', 'country_code' => 'BO'],
            ['name' => 'Oruro', 'country_code' => 'BO'],
            ['name' => 'Pando', 'country_code' => 'BO'],
            ['name' => 'Potosi', 'country_code' => 'BO'],
            ['name' => 'Santa Cruz', 'country_code' => 'BO'],
            ['name' => 'Tarija', 'country_code' => 'BO'],
            ['name' => 'Federacija Bosna i Hercegovina', 'country_code' => 'BA'],
            ['name' => 'Republika Srpska', 'country_code' => 'BA'],
            ['name' => 'Central Bobonong', 'country_code' => 'BW'],
            ['name' => 'Central Boteti', 'country_code' => 'BW'],
            ['name' => 'Central Mahalapye', 'country_code' => 'BW'],
            ['name' => 'Central Serowe-Palapye', 'country_code' => 'BW'],
            ['name' => 'Central Tutume', 'country_code' => 'BW'],
            ['name' => 'Chobe', 'country_code' => 'BW'],
            ['name' => 'Francistown', 'country_code' => 'BW'],
            ['name' => 'Gaborone', 'country_code' => 'BW'],
            ['name' => 'Ghanzi', 'country_code' => 'BW'],
            ['name' => 'Jwaneng', 'country_code' => 'BW'],
            ['name' => 'Kgalagadi North', 'country_code' => 'BW'],
            ['name' => 'Kgalagadi South', 'country_code' => 'BW'],
            ['name' => 'Kgatleng', 'country_code' => 'BW'],
            ['name' => 'Kweneng', 'country_code' => 'BW'],
            ['name' => 'Lobatse', 'country_code' => 'BW'],
            ['name' => 'Ngamiland', 'country_code' => 'BW'],
            ['name' => 'Ngwaketse', 'country_code' => 'BW'],
            ['name' => 'North East', 'country_code' => 'BW'],
            ['name' => 'Okavango', 'country_code' => 'BW'],
            ['name' => 'Orapa', 'country_code' => 'BW'],
            ['name' => 'Selibe Phikwe', 'country_code' => 'BW'],
            ['name' => 'South East', 'country_code' => 'BW'],
            ['name' => 'Sowa', 'country_code' => 'BW'],
            ['name' => 'Bouvet Island', 'country_code' => 'BV'],
            ['name' => 'Acre', 'country_code' => 'BR'],
            ['name' => 'Alagoas', 'country_code' => 'BR'],
            ['name' => 'Amapa', 'country_code' => 'BR'],
            ['name' => 'Amazonas', 'country_code' => 'BR'],
            ['name' => 'Bahia', 'country_code' => 'BR'],
            ['name' => 'Ceara', 'country_code' => 'BR'],
            ['name' => 'Distrito Federal', 'country_code' => 'BR'],
            ['name' => 'Espirito Santo', 'country_code' => 'BR'],
            ['name' => 'Estado de Sao Paulo', 'country_code' => 'BR'],
            ['name' => 'Goias', 'country_code' => 'BR'],
            ['name' => 'Maranhao', 'country_code' => 'BR'],
            ['name' => 'Mato Grosso', 'country_code' => 'BR'],
            ['name' => 'Mato Grosso do Sul', 'country_code' => 'BR'],
            ['name' => 'Minas Gerais', 'country_code' => 'BR'],
            ['name' => 'Para', 'country_code' => 'BR'],
            ['name' => 'Paraiba', 'country_code' => 'BR'],
            ['name' => 'Parana', 'country_code' => 'BR'],
            ['name' => 'Pernambuco', 'country_code' => 'BR'],
            ['name' => 'Piaui', 'country_code' => 'BR'],
            ['name' => 'Rio Grande do Norte', 'country_code' => 'BR'],
            ['name' => 'Rio Grande do Sul', 'country_code' => 'BR'],
            ['name' => 'Rio de Janeiro', 'country_code' => 'BR'],
            ['name' => 'Rondonia', 'country_code' => 'BR'],
            ['name' => 'Roraima', 'country_code' => 'BR'],
            ['name' => 'Santa Catarina', 'country_code' => 'BR'],
            ['name' => 'Sao Paulo', 'country_code' => 'BR'],
            ['name' => 'Sergipe', 'country_code' => 'BR'],
            ['name' => 'Tocantins', 'country_code' => 'BR'],
            ['name' => 'British Indian Ocean Territory', 'country_code' => 'IO'],
            ['name' => 'Belait', 'country_code' => 'BN'],
            ['name' => 'Brunei-Muara', 'country_code' => 'BN'],
            ['name' => 'Temburong', 'country_code' => 'BN'],
            ['name' => 'Tutong', 'country_code' => 'BN'],
            ['name' => 'Blagoevgrad', 'country_code' => 'BG'],
            ['name' => 'Burgas', 'country_code' => 'BG'],
            ['name' => 'Dobrich', 'country_code' => 'BG'],
            ['name' => 'Gabrovo', 'country_code' => 'BG'],
            ['name' => 'Haskovo', 'country_code' => 'BG'],
            ['name' => 'Jambol', 'country_code' => 'BG'],
            ['name' => 'Kardzhali', 'country_code' => 'BG'],
            ['name' => 'Kjustendil', 'country_code' => 'BG'],
            ['name' => 'Lovech', 'country_code' => 'BG'],
            ['name' => 'Montana', 'country_code' => 'BG'],
            ['name' => 'Oblast Sofiya-Grad', 'country_code' => 'BG'],
            ['name' => 'Pazardzhik', 'country_code' => 'BG'],
            ['name' => 'Pernik', 'country_code' => 'BG'],
            ['name' => 'Pleven', 'country_code' => 'BG'],
            ['name' => 'Plovdiv', 'country_code' => 'BG'],
            ['name' => 'Razgrad', 'country_code' => 'BG'],
            ['name' => 'Ruse', 'country_code' => 'BG'],
            ['name' => 'Shumen', 'country_code' => 'BG'],
            ['name' => 'Silistra', 'country_code' => 'BG'],
            ['name' => 'Sliven', 'country_code' => 'BG'],
            ['name' => 'Smoljan', 'country_code' => 'BG'],
            ['name' => 'Sofija grad', 'country_code' => 'BG'],
            ['name' => 'Sofijska oblast', 'country_code' => 'BG'],
            ['name' => 'Stara Zagora', 'country_code' => 'BG'],
            ['name' => 'Targovishte', 'country_code' => 'BG'],
            ['name' => 'Varna', 'country_code' => 'BG'],
            ['name' => 'Veliko Tarnovo', 'country_code' => 'BG'],
            ['name' => 'Vidin', 'country_code' => 'BG'],
            ['name' => 'Vraca', 'country_code' => 'BG'],
            ['name' => 'Yablaniza', 'country_code' => 'BG'],
            ['name' => 'Bale', 'country_code' => 'BF'],
            ['name' => 'Bam', 'country_code' => 'BF'],
            ['name' => 'Bazega', 'country_code' => 'BF'],
            ['name' => 'Bougouriba', 'country_code' => 'BF'],
            ['name' => 'Boulgou', 'country_code' => 'BF'],
            ['name' => 'Boulkiemde', 'country_code' => 'BF'],
            ['name' => 'Comoe', 'country_code' => 'BF'],
            ['name' => 'Ganzourgou', 'country_code' => 'BF'],
            ['name' => 'Gnagna', 'country_code' => 'BF'],
            ['name' => 'Gourma', 'country_code' => 'BF'],
            ['name' => 'Houet', 'country_code' => 'BF'],
            ['name' => 'Ioba', 'country_code' => 'BF'],
            ['name' => 'Kadiogo', 'country_code' => 'BF'],
            ['name' => 'Kenedougou', 'country_code' => 'BF'],
            ['name' => 'Komandjari', 'country_code' => 'BF'],
            ['name' => 'Kompienga', 'country_code' => 'BF'],
            ['name' => 'Kossi', 'country_code' => 'BF'],
            ['name' => 'Kouritenga', 'country_code' => 'BF'],
            ['name' => 'Kourweogo', 'country_code' => 'BF'],
            ['name' => 'Leraba', 'country_code' => 'BF'],
            ['name' => 'Mouhoun', 'country_code' => 'BF'],
            ['name' => 'Nahouri', 'country_code' => 'BF'],
            ['name' => 'Namentenga', 'country_code' => 'BF'],
            ['name' => 'Noumbiel', 'country_code' => 'BF'],
            ['name' => 'Oubritenga', 'country_code' => 'BF'],
            ['name' => 'Oudalan', 'country_code' => 'BF'],
            ['name' => 'Passore', 'country_code' => 'BF'],
            ['name' => 'Poni', 'country_code' => 'BF'],
            ['name' => 'Sanguie', 'country_code' => 'BF'],
            ['name' => 'Sanmatenga', 'country_code' => 'BF'],
            ['name' => 'Seno', 'country_code' => 'BF'],
            ['name' => 'Sissili', 'country_code' => 'BF'],
            ['name' => 'Soum', 'country_code' => 'BF'],
            ['name' => 'Sourou', 'country_code' => 'BF'],
            ['name' => 'Tapoa', 'country_code' => 'BF'],
            ['name' => 'Tuy', 'country_code' => 'BF'],
            ['name' => 'Yatenga', 'country_code' => 'BF'],
            ['name' => 'Zondoma', 'country_code' => 'BF'],
            ['name' => 'Zoundweogo', 'country_code' => 'BF'],
            ['name' => 'Bubanza', 'country_code' => 'BI'],
            ['name' => 'Bujumbura', 'country_code' => 'BI'],
            ['name' => 'Bururi', 'country_code' => 'BI'],
            ['name' => 'Cankuzo', 'country_code' => 'BI'],
            ['name' => 'Cibitoke', 'country_code' => 'BI'],
            ['name' => 'Gitega', 'country_code' => 'BI'],
            ['name' => 'Karuzi', 'country_code' => 'BI'],
            ['name' => 'Kayanza', 'country_code' => 'BI'],
            ['name' => 'Kirundo', 'country_code' => 'BI'],
            ['name' => 'Makamba', 'country_code' => 'BI'],
            ['name' => 'Muramvya', 'country_code' => 'BI'],
            ['name' => 'Muyinga', 'country_code' => 'BI'],
            ['name' => 'Ngozi', 'country_code' => 'BI'],
            ['name' => 'Rutana', 'country_code' => 'BI'],
            ['name' => 'Ruyigi', 'country_code' => 'BI'],
            ['name' => 'Banteay Mean Chey', 'country_code' => 'KH'],
            ['name' => 'Bat Dambang', 'country_code' => 'KH'],
            ['name' => 'Kampong Cham', 'country_code' => 'KH'],
            ['name' => 'Kampong Chhnang', 'country_code' => 'KH'],
            ['name' => 'Kampong Spoeu', 'country_code' => 'KH'],
            ['name' => 'Kampong Thum', 'country_code' => 'KH'],
            ['name' => 'Kampot', 'country_code' => 'KH'],
            ['name' => 'Kandal', 'country_code' => 'KH'],
            ['name' => 'Kaoh Kong', 'country_code' => 'KH'],
            ['name' => 'Kracheh', 'country_code' => 'KH'],
            ['name' => 'Krong Kaeb', 'country_code' => 'KH'],
            ['name' => 'Krong Pailin', 'country_code' => 'KH'],
            ['name' => 'Krong Preah Sihanouk', 'country_code' => 'KH'],
            ['name' => 'Mondol Kiri', 'country_code' => 'KH'],
            ['name' => 'Otdar Mean Chey', 'country_code' => 'KH'],
            ['name' => 'Phnum Penh', 'country_code' => 'KH'],
            ['name' => 'Pousat', 'country_code' => 'KH'],
            ['name' => 'Preah Vihear', 'country_code' => 'KH'],
            ['name' => 'Prey Veaeng', 'country_code' => 'KH'],
            ['name' => 'Rotanak Kiri', 'country_code' => 'KH'],
            ['name' => 'Siem Reab', 'country_code' => 'KH'],
            ['name' => 'Stueng Traeng', 'country_code' => 'KH'],
            ['name' => 'Svay Rieng', 'country_code' => 'KH'],
            ['name' => 'Takaev', 'country_code' => 'KH'],
            ['name' => 'Adamaoua', 'country_code' => 'CM'],
            ['name' => 'Centre', 'country_code' => 'CM'],
            ['name' => 'Est', 'country_code' => 'CM'],
            ['name' => 'Littoral', 'country_code' => 'CM'],
            ['name' => 'Nord', 'country_code' => 'CM'],
            ['name' => 'Nord Extreme', 'country_code' => 'CM'],
            ['name' => 'Nordouest', 'country_code' => 'CM'],
            ['name' => 'Ouest', 'country_code' => 'CM'],
            ['name' => 'Sud', 'country_code' => 'CM'],
            ['name' => 'Sudouest', 'country_code' => 'CM'],
            ['name' => 'Alberta', 'country_code' => 'CA', 'code' => 'AB'],
            ['name' => 'British Columbia', 'country_code' => 'CA', 'code' => 'BC'],
            ['name' => 'Manitoba', 'country_code' => 'CA', 'code' => 'MB'],
            ['name' => 'New Brunswick', 'country_code' => 'CA', 'code' => 'NB'],
            ['name' => 'Newfoundland and Labrador', 'country_code' => 'CA', 'code' => 'NL'],
            ['name' => 'Northwest Territories', 'country_code' => 'CA', 'code' => 'NT'],
            ['name' => 'Nova Scotia', 'country_code' => 'CA', 'code' => 'NS'],
            ['name' => 'Nunavut', 'country_code' => 'CA', 'code' => 'NU'],
            ['name' => 'Ontario', 'country_code' => 'CA', 'code' => 'ON'],
            ['name' => 'Prince Edward Island', 'country_code' => 'CA', 'code' => 'PE'],
            ['name' => 'Quebec', 'country_code' => 'CA', 'code' => 'QC'],
            ['name' => 'Saskatchewan', 'country_code' => 'CA', 'code' => 'SK'],
            ['name' => 'Yukon', 'country_code' => 'CA', 'code' => 'YT'],
            ['name' => 'Boavista', 'country_code' => 'CV'],
            ['name' => 'Brava', 'country_code' => 'CV'],
            ['name' => 'Fogo', 'country_code' => 'CV'],
            ['name' => 'Maio', 'country_code' => 'CV'],
            ['name' => 'Sal', 'country_code' => 'CV'],
            ['name' => 'Santo Antao', 'country_code' => 'CV'],
            ['name' => 'Sao Nicolau', 'country_code' => 'CV'],
            ['name' => 'Sao Tiago', 'country_code' => 'CV'],
            ['name' => 'Sao Vicente', 'country_code' => 'CV'],
            ['name' => 'Grand Cayman', 'country_code' => 'KY'],
            ['name' => 'Bamingui-Bangoran', 'country_code' => 'CF'],
            ['name' => 'Bangui', 'country_code' => 'CF'],
            ['name' => 'Basse-Kotto', 'country_code' => 'CF'],
            ['name' => 'Haut-Mbomou', 'country_code' => 'CF'],
            ['name' => 'Haute-Kotto', 'country_code' => 'CF'],
            ['name' => 'Kemo', 'country_code' => 'CF'],
            ['name' => 'Lobaye', 'country_code' => 'CF'],
            ['name' => 'Mambere-Kadei', 'country_code' => 'CF'],
            ['name' => 'Mbomou', 'country_code' => 'CF'],
            ['name' => 'Nana-Gribizi', 'country_code' => 'CF'],
            ['name' => 'Nana-Mambere', 'country_code' => 'CF'],
            ['name' => 'Ombella Mpoko', 'country_code' => 'CF'],
            ['name' => 'Ouaka', 'country_code' => 'CF'],
            ['name' => 'Ouham', 'country_code' => 'CF'],
            ['name' => 'Ouham-Pende', 'country_code' => 'CF'],
            ['name' => 'Sangha-Mbaere', 'country_code' => 'CF'],
            ['name' => 'Vakaga', 'country_code' => 'CF'],
            ['name' => 'Batha', 'country_code' => 'TD'],
            ['name' => 'Biltine', 'country_code' => 'TD'],
            ['name' => 'Bourkou-Ennedi-Tibesti', 'country_code' => 'TD'],
            ['name' => 'Chari-Baguirmi', 'country_code' => 'TD'],
            ['name' => 'Guera', 'country_code' => 'TD'],
            ['name' => 'Kanem', 'country_code' => 'TD'],
            ['name' => 'Lac', 'country_code' => 'TD'],
            ['name' => 'Logone Occidental', 'country_code' => 'TD'],
            ['name' => 'Logone Oriental', 'country_code' => 'TD'],
            ['name' => 'Mayo-Kebbi', 'country_code' => 'TD'],
            ['name' => 'Moyen-Chari', 'country_code' => 'TD'],
            ['name' => 'Ouaddai', 'country_code' => 'TD'],
            ['name' => 'Salamat', 'country_code' => 'TD'],
            ['name' => 'Tandjile', 'country_code' => 'TD'],
            ['name' => 'Aisen', 'country_code' => 'CL'],
            ['name' => 'Antofagasta', 'country_code' => 'CL'],
            ['name' => 'Araucania', 'country_code' => 'CL'],
            ['name' => 'Atacama', 'country_code' => 'CL'],
            ['name' => 'Bio Bio', 'country_code' => 'CL'],
            ['name' => 'Coquimbo', 'country_code' => 'CL'],
            ['name' => "Libertador General Bernardo O'", 'country_code' => 'CL'],
            ['name' => 'Los Lagos', 'country_code' => 'CL'],
            ['name' => 'Magellanes', 'country_code' => 'CL'],
            ['name' => 'Maule', 'country_code' => 'CL'],
            ['name' => 'Metropolitana', 'country_code' => 'CL'],
            ['name' => 'Metropolitana de Santiago', 'country_code' => 'CL'],
            ['name' => 'Tarapaca', 'country_code' => 'CL'],
            ['name' => 'Valparaiso', 'country_code' => 'CL'],
            ['name' => 'Anhui', 'country_code' => 'CN'],
            ['name' => 'Anhui Province', 'country_code' => 'CN'],
            ['name' => 'Anhui Sheng', 'country_code' => 'CN'],
            ['name' => 'Aomen', 'country_code' => 'CN'],
            ['name' => 'Beijing', 'country_code' => 'CN'],
            ['name' => 'Beijing Shi', 'country_code' => 'CN'],
            ['name' => 'Chongqing', 'country_code' => 'CN'],
            ['name' => 'Fujian', 'country_code' => 'CN'],
            ['name' => 'Fujian Sheng', 'country_code' => 'CN'],
            ['name' => 'Gansu', 'country_code' => 'CN'],
            ['name' => 'Guangdong', 'country_code' => 'CN'],
            ['name' => 'Guangdong Sheng', 'country_code' => 'CN'],
            ['name' => 'Guangxi', 'country_code' => 'CN'],
            ['name' => 'Guizhou', 'country_code' => 'CN'],
            ['name' => 'Hainan', 'country_code' => 'CN'],
            ['name' => 'Hebei', 'country_code' => 'CN'],
            ['name' => 'Heilongjiang', 'country_code' => 'CN'],
            ['name' => 'Henan', 'country_code' => 'CN'],
            ['name' => 'Hubei', 'country_code' => 'CN'],
            ['name' => 'Hunan', 'country_code' => 'CN'],
            ['name' => 'Jiangsu', 'country_code' => 'CN'],
            ['name' => 'Jiangsu Sheng', 'country_code' => 'CN'],
            ['name' => 'Jiangxi', 'country_code' => 'CN'],
            ['name' => 'Jilin', 'country_code' => 'CN'],
            ['name' => 'Liaoning', 'country_code' => 'CN'],
            ['name' => 'Liaoning Sheng', 'country_code' => 'CN'],
            ['name' => 'Nei Monggol', 'country_code' => 'CN'],
            ['name' => 'Ningxia Hui', 'country_code' => 'CN'],
            ['name' => 'Qinghai', 'country_code' => 'CN'],
            ['name' => 'Shaanxi', 'country_code' => 'CN'],
            ['name' => 'Shandong', 'country_code' => 'CN'],
            ['name' => 'Shandong Sheng', 'country_code' => 'CN'],
            ['name' => 'Shanghai', 'country_code' => 'CN'],
            ['name' => 'Shanxi', 'country_code' => 'CN'],
            ['name' => 'Sichuan', 'country_code' => 'CN'],
            ['name' => 'Tianjin', 'country_code' => 'CN'],
            ['name' => 'Xianggang', 'country_code' => 'CN'],
            ['name' => 'Xinjiang', 'country_code' => 'CN'],
            ['name' => 'Xizang', 'country_code' => 'CN'],
            ['name' => 'Yunnan', 'country_code' => 'CN'],
            ['name' => 'Zhejiang', 'country_code' => 'CN'],
            ['name' => 'Zhejiang Sheng', 'country_code' => 'CN'],
            ['name' => 'Christmas Island', 'country_code' => 'CX'],
            ['name' => 'Cocos (Keeling) Islands', 'country_code' => 'CC'],
            ['name' => 'Amazonas', 'country_code' => 'CO'],
            ['name' => 'Antioquia', 'country_code' => 'CO'],
            ['name' => 'Arauca', 'country_code' => 'CO'],
            ['name' => 'Atlantico', 'country_code' => 'CO'],
            ['name' => 'Bogota', 'country_code' => 'CO'],
            ['name' => 'Bolivar', 'country_code' => 'CO'],
            ['name' => 'Boyaca', 'country_code' => 'CO'],
            ['name' => 'Caldas', 'country_code' => 'CO'],
            ['name' => 'Caqueta', 'country_code' => 'CO'],
            ['name' => 'Casanare', 'country_code' => 'CO'],
            ['name' => 'Cauca', 'country_code' => 'CO'],
            ['name' => 'Cesar', 'country_code' => 'CO'],
            ['name' => 'Choco', 'country_code' => 'CO'],
            ['name' => 'Cordoba', 'country_code' => 'CO'],
            ['name' => 'Cundinamarca', 'country_code' => 'CO'],
            ['name' => 'Guainia', 'country_code' => 'CO'],
            ['name' => 'Guaviare', 'country_code' => 'CO'],
            ['name' => 'Huila', 'country_code' => 'CO'],
            ['name' => 'La Guajira', 'country_code' => 'CO'],
            ['name' => 'Magdalena', 'country_code' => 'CO'],
            ['name' => 'Meta', 'country_code' => 'CO'],
            ['name' => 'Narino', 'country_code' => 'CO'],
            ['name' => 'Norte de Santander', 'country_code' => 'CO'],
            ['name' => 'Putumayo', 'country_code' => 'CO'],
            ['name' => 'Quindio', 'country_code' => 'CO'],
            ['name' => 'Risaralda', 'country_code' => 'CO'],
            ['name' => 'San Andres y Providencia', 'country_code' => 'CO'],
            ['name' => 'Santander', 'country_code' => 'CO'],
            ['name' => 'Sucre', 'country_code' => 'CO'],
            ['name' => 'Tolima', 'country_code' => 'CO'],
            ['name' => 'Valle del Cauca', 'country_code' => 'CO'],
            ['name' => 'Vaupes', 'country_code' => 'CO'],
            ['name' => 'Vichada', 'country_code' => 'CO'],
            ['name' => 'Mwali', 'country_code' => 'KM'],
            ['name' => 'Njazidja', 'country_code' => 'KM'],
            ['name' => 'Nzwani', 'country_code' => 'KM'],
            ['name' => 'Bouenza', 'country_code' => 'CG'],
            ['name' => 'Brazzaville', 'country_code' => 'CG'],
            ['name' => 'Cuvette', 'country_code' => 'CG'],
            ['name' => 'Kouilou', 'country_code' => 'CG'],
            ['name' => 'Lekoumou', 'country_code' => 'CG'],
            ['name' => 'Likouala', 'country_code' => 'CG'],
            ['name' => 'Niari', 'country_code' => 'CG'],
            ['name' => 'Plateaux', 'country_code' => 'CG'],
            ['name' => 'Pool', 'country_code' => 'CG'],
            ['name' => 'Sangha', 'country_code' => 'CG'],
            ['name' => 'Bandundu', 'country_code' => 'CD'],
            ['name' => 'Bas-Congo', 'country_code' => 'CD'],
            ['name' => 'Equateur', 'country_code' => 'CD'],
            ['name' => 'Haut-Congo', 'country_code' => 'CD'],
            ['name' => 'Kasai-Occidental', 'country_code' => 'CD'],
            ['name' => 'Kasai-Oriental', 'country_code' => 'CD'],
            ['name' => 'Katanga', 'country_code' => 'CD'],
            ['name' => 'Kinshasa', 'country_code' => 'CD'],
            ['name' => 'Maniema', 'country_code' => 'CD'],
            ['name' => 'Nord-Kivu', 'country_code' => 'CD'],
            ['name' => 'Sud-Kivu', 'country_code' => 'CD'],
            ['name' => 'Aitutaki', 'country_code' => 'CK'],
            ['name' => 'Atiu', 'country_code' => 'CK'],
            ['name' => 'Mangaia', 'country_code' => 'CK'],
            ['name' => 'Manihiki', 'country_code' => 'CK'],
            ['name' => 'Mauke', 'country_code' => 'CK'],
            ['name' => 'Mitiaro', 'country_code' => 'CK'],
            ['name' => 'Nassau', 'country_code' => 'CK'],
            ['name' => 'Pukapuka', 'country_code' => 'CK'],
            ['name' => 'Rakahanga', 'country_code' => 'CK'],
            ['name' => 'Rarotonga', 'country_code' => 'CK'],
            ['name' => 'Tongareva', 'country_code' => 'CK'],
            ['name' => 'Alajuela', 'country_code' => 'CR'],
            ['name' => 'Cartago', 'country_code' => 'CR'],
            ['name' => 'Guanacaste', 'country_code' => 'CR'],
            ['name' => 'Heredia', 'country_code' => 'CR'],
            ['name' => 'Limon', 'country_code' => 'CR'],
            ['name' => 'Puntarenas', 'country_code' => 'CR'],
            ['name' => 'San Jose', 'country_code' => 'CR'],
            ['name' => 'Abidjan', 'country_code' => 'CI'],
            ['name' => 'Agneby', 'country_code' => 'CI'],
            ['name' => 'Bafing', 'country_code' => 'CI'],
            ['name' => 'Denguele', 'country_code' => 'CI'],
            ['name' => 'Dix-huit Montagnes', 'country_code' => 'CI'],
            ['name' => 'Fromager', 'country_code' => 'CI'],
            ['name' => 'Haut-Sassandra', 'country_code' => 'CI'],
            ['name' => 'Lacs', 'country_code' => 'CI'],
            ['name' => 'Lagunes', 'country_code' => 'CI'],
            ['name' => 'Marahoue', 'country_code' => 'CI'],
            ['name' => 'Moyen-Cavally', 'country_code' => 'CI'],
            ['name' => 'Moyen-Comoe', 'country_code' => 'CI'],
            ['name' => "N'zi-Comoe", 'country_code' => 'CI'],
            ['name' => 'Sassandra', 'country_code' => 'CI'],
            ['name' => 'Savanes', 'country_code' => 'CI'],
            ['name' => 'Sud-Bandama', 'country_code' => 'CI'],
            ['name' => 'Sud-Comoe', 'country_code' => 'CI'],
            ['name' => 'Vallee du Bandama', 'country_code' => 'CI'],
            ['name' => 'Worodougou', 'country_code' => 'CI'],
            ['name' => 'Zanzan', 'country_code' => 'CI'],
            ['name' => 'Bjelovar-Bilogora', 'country_code' => 'HR'],
            ['name' => 'Dubrovnik-Neretva', 'country_code' => 'HR'],
            ['name' => 'Grad Zagreb', 'country_code' => 'HR'],
            ['name' => 'Istra', 'country_code' => 'HR'],
            ['name' => 'Karlovac', 'country_code' => 'HR'],
            ['name' => 'Koprivnica-Krizhevci', 'country_code' => 'HR'],
            ['name' => 'Krapina-Zagorje', 'country_code' => 'HR'],
            ['name' => 'Lika-Senj', 'country_code' => 'HR'],
            ['name' => 'Medhimurje', 'country_code' => 'HR'],
            ['name' => 'Medimurska Zupanija', 'country_code' => 'HR'],
            ['name' => 'Osijek-Baranja', 'country_code' => 'HR'],
            ['name' => 'Osjecko-Baranjska Zupanija', 'country_code' => 'HR'],
            ['name' => 'Pozhega-Slavonija', 'country_code' => 'HR'],
            ['name' => 'Primorje-Gorski Kotar', 'country_code' => 'HR'],
            ['name' => 'Shibenik-Knin', 'country_code' => 'HR'],
            ['name' => 'Sisak-Moslavina', 'country_code' => 'HR'],
            ['name' => 'Slavonski Brod-Posavina', 'country_code' => 'HR'],
            ['name' => 'Split-Dalmacija', 'country_code' => 'HR'],
            ['name' => 'Varazhdin', 'country_code' => 'HR'],
            ['name' => 'Virovitica-Podravina', 'country_code' => 'HR'],
            ['name' => 'Vukovar-Srijem', 'country_code' => 'HR'],
            ['name' => 'Zadar', 'country_code' => 'HR'],
            ['name' => 'Zagreb', 'country_code' => 'HR'],
            ['name' => 'Camaguey', 'country_code' => 'CU'],
            ['name' => 'Ciego de Avila', 'country_code' => 'CU'],
            ['name' => 'Cienfuegos', 'country_code' => 'CU'],
            ['name' => 'Ciudad de la Habana', 'country_code' => 'CU'],
            ['name' => 'Granma', 'country_code' => 'CU'],
            ['name' => 'Guantanamo', 'country_code' => 'CU'],
            ['name' => 'Habana', 'country_code' => 'CU'],
            ['name' => 'Holguin', 'country_code' => 'CU'],
            ['name' => 'Isla de la Juventud', 'country_code' => 'CU'],
            ['name' => 'La Habana', 'country_code' => 'CU'],
            ['name' => 'Las Tunas', 'country_code' => 'CU'],
            ['name' => 'Matanzas', 'country_code' => 'CU'],
            ['name' => 'Pinar del Rio', 'country_code' => 'CU'],
            ['name' => 'Sancti Spiritus', 'country_code' => 'CU'],
            ['name' => 'Santiago de Cuba', 'country_code' => 'CU'],
            ['name' => 'Villa Clara', 'country_code' => 'CU'],
            ['name' => 'Government controlled area', 'country_code' => 'CY'],
            ['name' => 'Limassol', 'country_code' => 'CY'],
            ['name' => 'Nicosia District', 'country_code' => 'CY'],
            ['name' => 'Paphos', 'country_code' => 'CY'],
            ['name' => 'Turkish controlled area', 'country_code' => 'CY'],
            ['name' => 'Central Bohemian', 'country_code' => 'CZ'],
            ['name' => 'Frycovice', 'country_code' => 'CZ'],
            ['name' => 'Jihocesky Kraj', 'country_code' => 'CZ'],
            ['name' => 'Jihochesky', 'country_code' => 'CZ'],
            ['name' => 'Jihomoravsky', 'country_code' => 'CZ'],
            ['name' => 'Karlovarsky', 'country_code' => 'CZ'],
            ['name' => 'Klecany', 'country_code' => 'CZ'],
            ['name' => 'Kralovehradecky', 'country_code' => 'CZ'],
            ['name' => 'Liberecky', 'country_code' => 'CZ'],
            ['name' => 'Lipov', 'country_code' => 'CZ'],
            ['name' => 'Moravskoslezsky', 'country_code' => 'CZ'],
            ['name' => 'Olomoucky', 'country_code' => 'CZ'],
            ['name' => 'Olomoucky Kraj', 'country_code' => 'CZ'],
            ['name' => 'Pardubicky', 'country_code' => 'CZ'],
            ['name' => 'Plzensky', 'country_code' => 'CZ'],
            ['name' => 'Praha', 'country_code' => 'CZ'],
            ['name' => 'Rajhrad', 'country_code' => 'CZ'],
            ['name' => 'Smirice', 'country_code' => 'CZ'],
            ['name' => 'South Moravian', 'country_code' => 'CZ'],
            ['name' => 'Straz nad Nisou', 'country_code' => 'CZ'],
            ['name' => 'Stredochesky', 'country_code' => 'CZ'],
            ['name' => 'Unicov', 'country_code' => 'CZ'],
            ['name' => 'Ustecky', 'country_code' => 'CZ'],
            ['name' => 'Valletta', 'country_code' => 'CZ'],
            ['name' => 'Velesin', 'country_code' => 'CZ'],
            ['name' => 'Vysochina', 'country_code' => 'CZ'],
            ['name' => 'Zlinsky', 'country_code' => 'CZ'],
            ['name' => 'Arhus', 'country_code' => 'DK'],
            ['name' => 'Bornholm', 'country_code' => 'DK'],
            ['name' => 'Frederiksborg', 'country_code' => 'DK'],
            ['name' => 'Fyn', 'country_code' => 'DK'],
            ['name' => 'Hovedstaden', 'country_code' => 'DK'],
            ['name' => 'Kobenhavn', 'country_code' => 'DK'],
            ['name' => 'Kobenhavns Amt', 'country_code' => 'DK'],
            ['name' => 'Kobenhavns Kommune', 'country_code' => 'DK'],
            ['name' => 'Nordjylland', 'country_code' => 'DK'],
            ['name' => 'Ribe', 'country_code' => 'DK'],
            ['name' => 'Ringkobing', 'country_code' => 'DK'],
            ['name' => 'Roervig', 'country_code' => 'DK'],
            ['name' => 'Roskilde', 'country_code' => 'DK'],
            ['name' => 'Roslev', 'country_code' => 'DK'],
            ['name' => 'Sjaelland', 'country_code' => 'DK'],
            ['name' => 'Soeborg', 'country_code' => 'DK'],
            ['name' => 'Sonderjylland', 'country_code' => 'DK'],
            ['name' => 'Storstrom', 'country_code' => 'DK'],
            ['name' => 'Syddanmark', 'country_code' => 'DK'],
            ['name' => 'Toelloese', 'country_code' => 'DK'],
            ['name' => 'Vejle', 'country_code' => 'DK'],
            ['name' => 'Vestsjalland', 'country_code' => 'DK'],
            ['name' => 'Viborg', 'country_code' => 'DK'],
            ['name' => "'Ali Sabih", 'country_code' => 'DJ'],
            ['name' => 'Dikhil', 'country_code' => 'DJ'],
            ['name' => 'Jibuti', 'country_code' => 'DJ'],
            ['name' => 'Tajurah', 'country_code' => 'DJ'],
            ['name' => 'Ubuk', 'country_code' => 'DJ'],
            ['name' => 'Saint Andrew', 'country_code' => 'DM'],
            ['name' => 'Saint David', 'country_code' => 'DM'],
            ['name' => 'Saint George', 'country_code' => 'DM'],
            ['name' => 'Saint John', 'country_code' => 'DM'],
            ['name' => 'Saint Joseph', 'country_code' => 'DM'],
            ['name' => 'Saint Luke', 'country_code' => 'DM'],
            ['name' => 'Saint Mark', 'country_code' => 'DM'],
            ['name' => 'Saint Patrick', 'country_code' => 'DM'],
            ['name' => 'Saint Paul', 'country_code' => 'DM'],
            ['name' => 'Saint Peter', 'country_code' => 'DM'],
            ['name' => 'Azua', 'country_code' => 'DO'],
            ['name' => 'Bahoruco', 'country_code' => 'DO'],
            ['name' => 'Barahona', 'country_code' => 'DO'],
            ['name' => 'Dajabon', 'country_code' => 'DO'],
            ['name' => 'Distrito Nacional', 'country_code' => 'DO'],
            ['name' => 'Duarte', 'country_code' => 'DO'],
            ['name' => 'El Seybo', 'country_code' => 'DO'],
            ['name' => 'Elias Pina', 'country_code' => 'DO'],
            ['name' => 'Espaillat', 'country_code' => 'DO'],
            ['name' => 'Hato Mayor', 'country_code' => 'DO'],
            ['name' => 'Independencia', 'country_code' => 'DO'],
            ['name' => 'La Altagracia', 'country_code' => 'DO'],
            ['name' => 'La Romana', 'country_code' => 'DO'],
            ['name' => 'La Vega', 'country_code' => 'DO'],
            ['name' => 'Maria Trinidad Sanchez', 'country_code' => 'DO'],
            ['name' => 'Monsenor Nouel', 'country_code' => 'DO'],
            ['name' => 'Monte Cristi', 'country_code' => 'DO'],
            ['name' => 'Monte Plata', 'country_code' => 'DO'],
            ['name' => 'Pedernales', 'country_code' => 'DO'],
            ['name' => 'Peravia', 'country_code' => 'DO'],
            ['name' => 'Puerto Plata', 'country_code' => 'DO'],
            ['name' => 'Salcedo', 'country_code' => 'DO'],
            ['name' => 'Samana', 'country_code' => 'DO'],
            ['name' => 'San Cristobal', 'country_code' => 'DO'],
            ['name' => 'San Juan', 'country_code' => 'DO'],
            ['name' => 'San Pedro de Macoris', 'country_code' => 'DO'],
            ['name' => 'Sanchez Ramirez', 'country_code' => 'DO'],
            ['name' => 'Santiago', 'country_code' => 'DO'],
            ['name' => 'Santiago Rodriguez', 'country_code' => 'DO'],
            ['name' => 'Valverde', 'country_code' => 'DO'],
            ['name' => 'Aileu', 'country_code' => 'TP'],
            ['name' => 'Ainaro', 'country_code' => 'TP'],
            ['name' => 'Ambeno', 'country_code' => 'TP'],
            ['name' => 'Baucau', 'country_code' => 'TP'],
            ['name' => 'Bobonaro', 'country_code' => 'TP'],
            ['name' => 'Cova Lima', 'country_code' => 'TP'],
            ['name' => 'Dili', 'country_code' => 'TP'],
            ['name' => 'Ermera', 'country_code' => 'TP'],
            ['name' => 'Lautem', 'country_code' => 'TP'],
            ['name' => 'Liquica', 'country_code' => 'TP'],
            ['name' => 'Manatuto', 'country_code' => 'TP'],
            ['name' => 'Manufahi', 'country_code' => 'TP'],
            ['name' => 'Viqueque', 'country_code' => 'TP'],
            ['name' => 'Azuay', 'country_code' => 'EC'],
            ['name' => 'Bolivar', 'country_code' => 'EC'],
            ['name' => 'Canar', 'country_code' => 'EC'],
            ['name' => 'Carchi', 'country_code' => 'EC'],
            ['name' => 'Chimborazo', 'country_code' => 'EC'],
            ['name' => 'Cotopaxi', 'country_code' => 'EC'],
            ['name' => 'El Oro', 'country_code' => 'EC'],
            ['name' => 'Esmeraldas', 'country_code' => 'EC'],
            ['name' => 'Galapagos', 'country_code' => 'EC'],
            ['name' => 'Guayas', 'country_code' => 'EC'],
            ['name' => 'Imbabura', 'country_code' => 'EC'],
            ['name' => 'Loja', 'country_code' => 'EC'],
            ['name' => 'Los Rios', 'country_code' => 'EC'],
            ['name' => 'Manabi', 'country_code' => 'EC'],
            ['name' => 'Morona Santiago', 'country_code' => 'EC'],
            ['name' => 'Napo', 'country_code' => 'EC'],
            ['name' => 'Orellana', 'country_code' => 'EC'],
            ['name' => 'Pastaza', 'country_code' => 'EC'],
            ['name' => 'Pichincha', 'country_code' => 'EC'],
            ['name' => 'Sucumbios', 'country_code' => 'EC'],
            ['name' => 'Tungurahua', 'country_code' => 'EC'],
            ['name' => 'Zamora Chinchipe', 'country_code' => 'EC'],
            ['name' => 'Aswan', 'country_code' => 'EG'],
            ['name' => 'Asyut', 'country_code' => 'EG'],
            ['name' => 'Bani Suwayf', 'country_code' => 'EG'],
            ['name' => "Bur Sa'id", 'country_code' => 'EG'],
            ['name' => 'Cairo', 'country_code' => 'EG'],
            ['name' => 'Dumyat', 'country_code' => 'EG'],
            ['name' => 'Kafr-ash-Shaykh', 'country_code' => 'EG'],
            ['name' => 'Matruh', 'country_code' => 'EG'],
            ['name' => 'Muhafazat ad Daqahliyah', 'country_code' => 'EG'],
            ['name' => 'Muhafazat al Fayyum', 'country_code' => 'EG'],
            ['name' => 'Muhafazat al Gharbiyah', 'country_code' => 'EG'],
            ['name' => 'Muhafazat al Iskandariyah', 'country_code' => 'EG'],
            ['name' => 'Muhafazat al Qahirah', 'country_code' => 'EG'],
            ['name' => 'Qina', 'country_code' => 'EG'],
            ['name' => 'Sawhaj', 'country_code' => 'EG'],
            ['name' => 'Sina al-Janubiyah', 'country_code' => 'EG'],
            ['name' => 'Sina ash-Shamaliyah', 'country_code' => 'EG'],
            ['name' => 'ad-Daqahliyah', 'country_code' => 'EG'],
            ['name' => 'al-Bahr-al-Ahmar', 'country_code' => 'EG'],
            ['name' => 'al-Buhayrah', 'country_code' => 'EG'],
            ['name' => 'al-Fayyum', 'country_code' => 'EG'],
            ['name' => 'al-Gharbiyah', 'country_code' => 'EG'],
            ['name' => 'al-Iskandariyah', 'country_code' => 'EG'],
            ['name' => 'al-Ismailiyah', 'country_code' => 'EG'],
            ['name' => 'al-Jizah', 'country_code' => 'EG'],
            ['name' => 'al-Minufiyah', 'country_code' => 'EG'],
            ['name' => 'al-Minya', 'country_code' => 'EG'],
            ['name' => 'al-Qahira', 'country_code' => 'EG'],
            ['name' => 'al-Qalyubiyah', 'country_code' => 'EG'],
            ['name' => 'al-Uqsur', 'country_code' => 'EG'],
            ['name' => 'al-Wadi al-Jadid', 'country_code' => 'EG'],
            ['name' => 'as-Suways', 'country_code' => 'EG'],
            ['name' => 'ash-Sharqiyah', 'country_code' => 'EG'],
            ['name' => 'Ahuachapan', 'country_code' => 'SV'],
            ['name' => 'Cabanas', 'country_code' => 'SV'],
            ['name' => 'Chalatenango', 'country_code' => 'SV'],
            ['name' => 'Cuscatlan', 'country_code' => 'SV'],
            ['name' => 'La Libertad', 'country_code' => 'SV'],
            ['name' => 'La Paz', 'country_code' => 'SV'],
            ['name' => 'La Union', 'country_code' => 'SV'],
            ['name' => 'Morazan', 'country_code' => 'SV'],
            ['name' => 'San Miguel', 'country_code' => 'SV'],
            ['name' => 'San Salvador', 'country_code' => 'SV'],
            ['name' => 'San Vicente', 'country_code' => 'SV'],
            ['name' => 'Santa Ana', 'country_code' => 'SV'],
            ['name' => 'Sonsonate', 'country_code' => 'SV'],
            ['name' => 'Usulutan', 'country_code' => 'SV'],
            ['name' => 'Annobon', 'country_code' => 'GQ'],
            ['name' => 'Bioko Norte', 'country_code' => 'GQ'],
            ['name' => 'Bioko Sur', 'country_code' => 'GQ'],
            ['name' => 'Centro Sur', 'country_code' => 'GQ'],
            ['name' => 'Kie-Ntem', 'country_code' => 'GQ'],
            ['name' => 'Litoral', 'country_code' => 'GQ'],
            ['name' => 'Wele-Nzas', 'country_code' => 'GQ'],
            ['name' => 'Anseba', 'country_code' => 'ER'],
            ['name' => 'Debub', 'country_code' => 'ER'],
            ['name' => 'Debub-Keih-Bahri', 'country_code' => 'ER'],
            ['name' => 'Gash-Barka', 'country_code' => 'ER'],
            ['name' => 'Maekel', 'country_code' => 'ER'],
            ['name' => 'Semien-Keih-Bahri', 'country_code' => 'ER'],
            ['name' => 'Harju', 'country_code' => 'EE'],
            ['name' => 'Hiiu', 'country_code' => 'EE'],
            ['name' => 'Ida-Viru', 'country_code' => 'EE'],
            ['name' => 'Jarva', 'country_code' => 'EE'],
            ['name' => 'Jogeva', 'country_code' => 'EE'],
            ['name' => 'Laane', 'country_code' => 'EE'],
            ['name' => 'Laane-Viru', 'country_code' => 'EE'],
            ['name' => 'Parnu', 'country_code' => 'EE'],
            ['name' => 'Polva', 'country_code' => 'EE'],
            ['name' => 'Rapla', 'country_code' => 'EE'],
            ['name' => 'Saare', 'country_code' => 'EE'],
            ['name' => 'Tartu', 'country_code' => 'EE'],
            ['name' => 'Valga', 'country_code' => 'EE'],
            ['name' => 'Viljandi', 'country_code' => 'EE'],
            ['name' => 'Voru', 'country_code' => 'EE'],
            ['name' => 'Addis Abeba', 'country_code' => 'ET'],
            ['name' => 'Afar', 'country_code' => 'ET'],
            ['name' => 'Amhara', 'country_code' => 'ET'],
            ['name' => 'Benishangul', 'country_code' => 'ET'],
            ['name' => 'Diredawa', 'country_code' => 'ET'],
            ['name' => 'Gambella', 'country_code' => 'ET'],
            ['name' => 'Harar', 'country_code' => 'ET'],
            ['name' => 'Jigjiga', 'country_code' => 'ET'],
            ['name' => 'Mekele', 'country_code' => 'ET'],
            ['name' => 'Oromia', 'country_code' => 'ET'],
            ['name' => 'Somali', 'country_code' => 'ET'],
            ['name' => 'Southern', 'country_code' => 'ET'],
            ['name' => 'Tigray', 'country_code' => 'ET'],
            ['name' => 'Christmas Island', 'country_code' => 'XA'],
            ['name' => 'Cocos Islands', 'country_code' => 'XA'],
            ['name' => 'Coral Sea Islands', 'country_code' => 'XA'],
            ['name' => 'Falkland Islands', 'country_code' => 'FK'],
            ['name' => 'South Georgia', 'country_code' => 'FK'],
            ['name' => 'Klaksvik', 'country_code' => 'FO'],
            ['name' => 'Nor ara Eysturoy', 'country_code' => 'FO'],
            ['name' => 'Nor oy', 'country_code' => 'FO'],
            ['name' => 'Sandoy', 'country_code' => 'FO'],
            ['name' => 'Streymoy', 'country_code' => 'FO'],
            ['name' => 'Su uroy', 'country_code' => 'FO'],
            ['name' => 'Sy ra Eysturoy', 'country_code' => 'FO'],
            ['name' => 'Torshavn', 'country_code' => 'FO'],
            ['name' => 'Vaga', 'country_code' => 'FO'],
            ['name' => 'Central', 'country_code' => 'FJ'],
            ['name' => 'Eastern', 'country_code' => 'FJ'],
            ['name' => 'Northern', 'country_code' => 'FJ'],
            ['name' => 'South Pacific', 'country_code' => 'FJ'],
            ['name' => 'Western', 'country_code' => 'FJ'],
            ['name' => 'Ahvenanmaa', 'country_code' => 'FI'],
            ['name' => 'Etela-Karjala', 'country_code' => 'FI'],
            ['name' => 'Etela-Pohjanmaa', 'country_code' => 'FI'],
            ['name' => 'Etela-Savo', 'country_code' => 'FI'],
            ['name' => 'Etela-Suomen Laani', 'country_code' => 'FI'],
            ['name' => 'Ita-Suomen Laani', 'country_code' => 'FI'],
            ['name' => 'Ita-Uusimaa', 'country_code' => 'FI'],
            ['name' => 'Kainuu', 'country_code' => 'FI'],
            ['name' => 'Kanta-Hame', 'country_code' => 'FI'],
            ['name' => 'Keski-Pohjanmaa', 'country_code' => 'FI'],
            ['name' => 'Keski-Suomi', 'country_code' => 'FI'],
            ['name' => 'Kymenlaakso', 'country_code' => 'FI'],
            ['name' => 'Lansi-Suomen Laani', 'country_code' => 'FI'],
            ['name' => 'Lappi', 'country_code' => 'FI'],
            ['name' => 'Northern Savonia', 'country_code' => 'FI'],
            ['name' => 'Ostrobothnia', 'country_code' => 'FI'],
            ['name' => 'Oulun Laani', 'country_code' => 'FI'],
            ['name' => 'Paijat-Hame', 'country_code' => 'FI'],
            ['name' => 'Pirkanmaa', 'country_code' => 'FI'],
            ['name' => 'Pohjanmaa', 'country_code' => 'FI'],
            ['name' => 'Pohjois-Karjala', 'country_code' => 'FI'],
            ['name' => 'Pohjois-Pohjanmaa', 'country_code' => 'FI'],
            ['name' => 'Pohjois-Savo', 'country_code' => 'FI'],
            ['name' => 'Saarijarvi', 'country_code' => 'FI'],
            ['name' => 'Satakunta', 'country_code' => 'FI'],
            ['name' => 'Southern Savonia', 'country_code' => 'FI'],
            ['name' => 'Tavastia Proper', 'country_code' => 'FI'],
            ['name' => 'Uleaborgs Lan', 'country_code' => 'FI'],
            ['name' => 'Uusimaa', 'country_code' => 'FI'],
            ['name' => 'Varsinais-Suomi', 'country_code' => 'FI'],
            ['name' => 'Ain', 'country_code' => 'FR'],
            ['name' => 'Aisne', 'country_code' => 'FR'],
            ['name' => 'Albi Le Sequestre', 'country_code' => 'FR'],
            ['name' => 'Allier', 'country_code' => 'FR'],
            ['name' => 'Alpes-Cote dAzur', 'country_code' => 'FR'],
            ['name' => 'Alpes-Maritimes', 'country_code' => 'FR'],
            ['name' => 'Alpes-de-Haute-Provence', 'country_code' => 'FR'],
            ['name' => 'Alsace', 'country_code' => 'FR'],
            ['name' => 'Aquitaine', 'country_code' => 'FR'],
            ['name' => 'Ardeche', 'country_code' => 'FR'],
            ['name' => 'Ardennes', 'country_code' => 'FR'],
            ['name' => 'Ariege', 'country_code' => 'FR'],
            ['name' => 'Aube', 'country_code' => 'FR'],
            ['name' => 'Aude', 'country_code' => 'FR'],
            ['name' => 'Auvergne', 'country_code' => 'FR'],
            ['name' => 'Aveyron', 'country_code' => 'FR'],
            ['name' => 'Bas-Rhin', 'country_code' => 'FR'],
            ['name' => 'Basse-Normandie', 'country_code' => 'FR'],
            ['name' => 'Bouches-du-Rhone', 'country_code' => 'FR'],
            ['name' => 'Bourgogne', 'country_code' => 'FR'],
            ['name' => 'Bretagne', 'country_code' => 'FR'],
            ['name' => 'Brittany', 'country_code' => 'FR'],
            ['name' => 'Burgundy', 'country_code' => 'FR'],
            ['name' => 'Calvados', 'country_code' => 'FR'],
            ['name' => 'Cantal', 'country_code' => 'FR'],
            ['name' => 'Cedex', 'country_code' => 'FR'],
            ['name' => 'Centre', 'country_code' => 'FR'],
            ['name' => 'Charente', 'country_code' => 'FR'],
            ['name' => 'Charente-Maritime', 'country_code' => 'FR'],
            ['name' => 'Cher', 'country_code' => 'FR'],
            ['name' => 'Correze', 'country_code' => 'FR'],
            ['name' => 'Corse-du-Sud', 'country_code' => 'FR'],
            ['name' => "Cote-d'Or", 'country_code' => 'FR'],
            ['name' => "Cotes-d'Armor", 'country_code' => 'FR'],
            ['name' => 'Creuse', 'country_code' => 'FR'],
            ['name' => 'Crolles', 'country_code' => 'FR'],
            ['name' => 'Deux-Sevres', 'country_code' => 'FR'],
            ['name' => 'Dordogne', 'country_code' => 'FR'],
            ['name' => 'Doubs', 'country_code' => 'FR'],
            ['name' => 'Drome', 'country_code' => 'FR'],
            ['name' => 'Essonne', 'country_code' => 'FR'],
            ['name' => 'Eure', 'country_code' => 'FR'],
            ['name' => 'Eure-et-Loir', 'country_code' => 'FR'],
            ['name' => 'Feucherolles', 'country_code' => 'FR'],
            ['name' => 'Finistere', 'country_code' => 'FR'],
            ['name' => 'Franche-Comte', 'country_code' => 'FR'],
            ['name' => 'Gard', 'country_code' => 'FR'],
            ['name' => 'Gers', 'country_code' => 'FR'],
            ['name' => 'Gironde', 'country_code' => 'FR'],
            ['name' => 'Haut-Rhin', 'country_code' => 'FR'],
            ['name' => 'Haute-Corse', 'country_code' => 'FR'],
            ['name' => 'Haute-Garonne', 'country_code' => 'FR'],
            ['name' => 'Haute-Loire', 'country_code' => 'FR'],
            ['name' => 'Haute-Marne', 'country_code' => 'FR'],
            ['name' => 'Haute-Saone', 'country_code' => 'FR'],
            ['name' => 'Haute-Savoie', 'country_code' => 'FR'],
            ['name' => 'Haute-Vienne', 'country_code' => 'FR'],
            ['name' => 'Hautes-Alpes', 'country_code' => 'FR'],
            ['name' => 'Hautes-Pyrenees', 'country_code' => 'FR'],
            ['name' => 'Hauts-de-Seine', 'country_code' => 'FR'],
            ['name' => 'Herault', 'country_code' => 'FR'],
            ['name' => 'Ile-de-France', 'country_code' => 'FR'],
            ['name' => 'Ille-et-Vilaine', 'country_code' => 'FR'],
            ['name' => 'Indre', 'country_code' => 'FR'],
            ['name' => 'Indre-et-Loire', 'country_code' => 'FR'],
            ['name' => 'Isere', 'country_code' => 'FR'],
            ['name' => 'Jura', 'country_code' => 'FR'],
            ['name' => 'Klagenfurt', 'country_code' => 'FR'],
            ['name' => 'Landes', 'country_code' => 'FR'],
            ['name' => 'Languedoc-Roussillon', 'country_code' => 'FR'],
            ['name' => 'Larcay', 'country_code' => 'FR'],
            ['name' => 'Le Castellet', 'country_code' => 'FR'],
            ['name' => 'Le Creusot', 'country_code' => 'FR'],
            ['name' => 'Limousin', 'country_code' => 'FR'],
            ['name' => 'Loir-et-Cher', 'country_code' => 'FR'],
            ['name' => 'Loire', 'country_code' => 'FR'],
            ['name' => 'Loire-Atlantique', 'country_code' => 'FR'],
            ['name' => 'Loiret', 'country_code' => 'FR'],
            ['name' => 'Lorraine', 'country_code' => 'FR'],
            ['name' => 'Lot', 'country_code' => 'FR'],
            ['name' => 'Lot-et-Garonne', 'country_code' => 'FR'],
            ['name' => 'Lower Normandy', 'country_code' => 'FR'],
            ['name' => 'Lozere', 'country_code' => 'FR'],
            ['name' => 'Maine-et-Loire', 'country_code' => 'FR'],
            ['name' => 'Manche', 'country_code' => 'FR'],
            ['name' => 'Marne', 'country_code' => 'FR'],
            ['name' => 'Mayenne', 'country_code' => 'FR'],
            ['name' => 'Meurthe-et-Moselle', 'country_code' => 'FR'],
            ['name' => 'Meuse', 'country_code' => 'FR'],
            ['name' => 'Midi-Pyrenees', 'country_code' => 'FR'],
            ['name' => 'Morbihan', 'country_code' => 'FR'],
            ['name' => 'Moselle', 'country_code' => 'FR'],
            ['name' => 'Nievre', 'country_code' => 'FR'],
            ['name' => 'Nord', 'country_code' => 'FR'],
            ['name' => 'Nord-Pas-de-Calais', 'country_code' => 'FR'],
            ['name' => 'Oise', 'country_code' => 'FR'],
            ['name' => 'Orne', 'country_code' => 'FR'],
            ['name' => 'Paris', 'country_code' => 'FR'],
            ['name' => 'Pas-de-Calais', 'country_code' => 'FR'],
            ['name' => 'Pays de la Loire', 'country_code' => 'FR'],
            ['name' => 'Pays-de-la-Loire', 'country_code' => 'FR'],
            ['name' => 'Picardy', 'country_code' => 'FR'],
            ['name' => 'Puy-de-Dome', 'country_code' => 'FR'],
            ['name' => 'Pyrenees-Atlantiques', 'country_code' => 'FR'],
            ['name' => 'Pyrenees-Orientales', 'country_code' => 'FR'],
            ['name' => 'Quelmes', 'country_code' => 'FR'],
            ['name' => 'Rhone', 'country_code' => 'FR'],
            ['name' => 'Rhone-Alpes', 'country_code' => 'FR'],
            ['name' => 'Saint Ouen', 'country_code' => 'FR'],
            ['name' => 'Saint Viatre', 'country_code' => 'FR'],
            ['name' => 'Saone-et-Loire', 'country_code' => 'FR'],
            ['name' => 'Sarthe', 'country_code' => 'FR'],
            ['name' => 'Savoie', 'country_code' => 'FR'],
            ['name' => 'Seine-Maritime', 'country_code' => 'FR'],
            ['name' => 'Seine-Saint-Denis', 'country_code' => 'FR'],
            ['name' => 'Seine-et-Marne', 'country_code' => 'FR'],
            ['name' => 'Somme', 'country_code' => 'FR'],
            ['name' => 'Sophia Antipolis', 'country_code' => 'FR'],
            ['name' => 'Souvans', 'country_code' => 'FR'],
            ['name' => 'Tarn', 'country_code' => 'FR'],
            ['name' => 'Tarn-et-Garonne', 'country_code' => 'FR'],
            ['name' => 'Territoire de Belfort', 'country_code' => 'FR'],
            ['name' => 'Treignac', 'country_code' => 'FR'],
            ['name' => 'Upper Normandy', 'country_code' => 'FR'],
            ['name' => "Val-d'Oise", 'country_code' => 'FR'],
            ['name' => 'Val-de-Marne', 'country_code' => 'FR'],
            ['name' => 'Var', 'country_code' => 'FR'],
            ['name' => 'Vaucluse', 'country_code' => 'FR'],
            ['name' => 'Vellise', 'country_code' => 'FR'],
            ['name' => 'Vendee', 'country_code' => 'FR'],
            ['name' => 'Vienne', 'country_code' => 'FR'],
            ['name' => 'Vosges', 'country_code' => 'FR'],
            ['name' => 'Yonne', 'country_code' => 'FR'],
            ['name' => 'Yvelines', 'country_code' => 'FR'],
            ['name' => 'Cayenne', 'country_code' => 'GF'],
            ['name' => 'Saint-Laurent-du-Maroni', 'country_code' => 'GF'],
            ['name' => 'Iles du Vent', 'country_code' => 'PF'],
            ['name' => 'Iles sous le Vent', 'country_code' => 'PF'],
            ['name' => 'Marquesas', 'country_code' => 'PF'],
            ['name' => 'Tuamotu', 'country_code' => 'PF'],
            ['name' => 'Tubuai', 'country_code' => 'PF'],
            ['name' => 'Amsterdam', 'country_code' => 'TF'],
            ['name' => 'Crozet Islands', 'country_code' => 'TF'],
            ['name' => 'Kerguelen', 'country_code' => 'TF'],
            ['name' => 'Estuaire', 'country_code' => 'GA'],
            ['name' => 'Haut-Ogooue', 'country_code' => 'GA'],
            ['name' => 'Moyen-Ogooue', 'country_code' => 'GA'],
            ['name' => 'Ngounie', 'country_code' => 'GA'],
            ['name' => 'Nyanga', 'country_code' => 'GA'],
            ['name' => 'Ogooue-Ivindo', 'country_code' => 'GA'],
            ['name' => 'Ogooue-Lolo', 'country_code' => 'GA'],
            ['name' => 'Ogooue-Maritime', 'country_code' => 'GA'],
            ['name' => 'Woleu-Ntem', 'country_code' => 'GA'],
            ['name' => 'Banjul', 'country_code' => 'GM'],
            ['name' => 'Basse', 'country_code' => 'GM'],
            ['name' => 'Brikama', 'country_code' => 'GM'],
            ['name' => 'Janjanbureh', 'country_code' => 'GM'],
            ['name' => 'Kanifing', 'country_code' => 'GM'],
            ['name' => 'Kerewan', 'country_code' => 'GM'],
            ['name' => 'Kuntaur', 'country_code' => 'GM'],
            ['name' => 'Mansakonko', 'country_code' => 'GM'],
            ['name' => 'Abhasia', 'country_code' => 'GE'],
            ['name' => 'Ajaria', 'country_code' => 'GE'],
            ['name' => 'Guria', 'country_code' => 'GE'],
            ['name' => 'Imereti', 'country_code' => 'GE'],
            ['name' => 'Kaheti', 'country_code' => 'GE'],
            ['name' => 'Kvemo Kartli', 'country_code' => 'GE'],
            ['name' => 'Mcheta-Mtianeti', 'country_code' => 'GE'],
            ['name' => 'Racha', 'country_code' => 'GE'],
            ['name' => 'Samagrelo-Zemo Svaneti', 'country_code' => 'GE'],
            ['name' => 'Samche-Zhavaheti', 'country_code' => 'GE'],
            ['name' => 'Shida Kartli', 'country_code' => 'GE'],
            ['name' => 'Tbilisi', 'country_code' => 'GE'],
            ['name' => 'Auvergne', 'country_code' => 'DE'],
            ['name' => 'Baden-Wurttemberg', 'country_code' => 'DE'],
            ['name' => 'Bavaria', 'country_code' => 'DE'],
            ['name' => 'Bayern', 'country_code' => 'DE'],
            ['name' => 'Beilstein Wurtt', 'country_code' => 'DE'],
            ['name' => 'Berlin', 'country_code' => 'DE'],
            ['name' => 'Brandenburg', 'country_code' => 'DE'],
            ['name' => 'Bremen', 'country_code' => 'DE'],
            ['name' => 'Dreisbach', 'country_code' => 'DE'],
            ['name' => 'Freistaat Bayern', 'country_code' => 'DE'],
            ['name' => 'Hamburg', 'country_code' => 'DE'],
            ['name' => 'Hannover', 'country_code' => 'DE'],
            ['name' => 'Heroldstatt', 'country_code' => 'DE'],
            ['name' => 'Hessen', 'country_code' => 'DE'],
            ['name' => 'Kortenberg', 'country_code' => 'DE'],
            ['name' => 'Laasdorf', 'country_code' => 'DE'],
            ['name' => 'Land Baden-Wurttemberg', 'country_code' => 'DE'],
            ['name' => 'Land Bayern', 'country_code' => 'DE'],
            ['name' => 'Land Brandenburg', 'country_code' => 'DE'],
            ['name' => 'Land Hessen', 'country_code' => 'DE'],
            ['name' => 'Land Mecklenburg-Vorpommern', 'country_code' => 'DE'],
            ['name' => 'Land Nordrhein-Westfalen', 'country_code' => 'DE'],
            ['name' => 'Land Rheinland-Pfalz', 'country_code' => 'DE'],
            ['name' => 'Land Sachsen', 'country_code' => 'DE'],
            ['name' => 'Land Sachsen-Anhalt', 'country_code' => 'DE'],
            ['name' => 'Land Thuringen', 'country_code' => 'DE'],
            ['name' => 'Lower Saxony', 'country_code' => 'DE'],
            ['name' => 'Mecklenburg-Vorpommern', 'country_code' => 'DE'],
            ['name' => 'Mulfingen', 'country_code' => 'DE'],
            ['name' => 'Munich', 'country_code' => 'DE'],
            ['name' => 'Neubeuern', 'country_code' => 'DE'],
            ['name' => 'Niedersachsen', 'country_code' => 'DE'],
            ['name' => 'Noord-Holland', 'country_code' => 'DE'],
            ['name' => 'Nordrhein-Westfalen', 'country_code' => 'DE'],
            ['name' => 'North Rhine-Westphalia', 'country_code' => 'DE'],
            ['name' => 'Osterode', 'country_code' => 'DE'],
            ['name' => 'Rheinland-Pfalz', 'country_code' => 'DE'],
            ['name' => 'Rhineland-Palatinate', 'country_code' => 'DE'],
            ['name' => 'Saarland', 'country_code' => 'DE'],
            ['name' => 'Sachsen', 'country_code' => 'DE'],
            ['name' => 'Sachsen-Anhalt', 'country_code' => 'DE'],
            ['name' => 'Saxony', 'country_code' => 'DE'],
            ['name' => 'Schleswig-Holstein', 'country_code' => 'DE'],
            ['name' => 'Thuringia', 'country_code' => 'DE'],
            ['name' => 'Webling', 'country_code' => 'DE'],
            ['name' => 'Weinstrabe', 'country_code' => 'DE'],
            ['name' => 'schlobborn', 'country_code' => 'DE'],
            ['name' => 'Ashanti', 'country_code' => 'GH'],
            ['name' => 'Brong-Ahafo', 'country_code' => 'GH'],
            ['name' => 'Central', 'country_code' => 'GH'],
            ['name' => 'Eastern', 'country_code' => 'GH'],
            ['name' => 'Greater Accra', 'country_code' => 'GH'],
            ['name' => 'Northern', 'country_code' => 'GH'],
            ['name' => 'Upper East', 'country_code' => 'GH'],
            ['name' => 'Upper West', 'country_code' => 'GH'],
            ['name' => 'Volta', 'country_code' => 'GH'],
            ['name' => 'Western', 'country_code' => 'GH'],
            ['name' => 'Gibraltar', 'country_code' => 'GI'],
            ['name' => 'Acharnes', 'country_code' => 'GR'],
            ['name' => 'Ahaia', 'country_code' => 'GR'],
            ['name' => 'Aitolia kai Akarnania', 'country_code' => 'GR'],
            ['name' => 'Argolis', 'country_code' => 'GR'],
            ['name' => 'Arkadia', 'country_code' => 'GR'],
            ['name' => 'Arta', 'country_code' => 'GR'],
            ['name' => 'Attica', 'country_code' => 'GR'],
            ['name' => 'Attiki', 'country_code' => 'GR'],
            ['name' => 'Ayion Oros', 'country_code' => 'GR'],
            ['name' => 'Crete', 'country_code' => 'GR'],
            ['name' => 'Dodekanisos', 'country_code' => 'GR'],
            ['name' => 'Drama', 'country_code' => 'GR'],
            ['name' => 'Evia', 'country_code' => 'GR'],
            ['name' => 'Evritania', 'country_code' => 'GR'],
            ['name' => 'Evros', 'country_code' => 'GR'],
            ['name' => 'Evvoia', 'country_code' => 'GR'],
            ['name' => 'Florina', 'country_code' => 'GR'],
            ['name' => 'Fokis', 'country_code' => 'GR'],
            ['name' => 'Fthiotis', 'country_code' => 'GR'],
            ['name' => 'Grevena', 'country_code' => 'GR'],
            ['name' => 'Halandri', 'country_code' => 'GR'],
            ['name' => 'Halkidiki', 'country_code' => 'GR'],
            ['name' => 'Hania', 'country_code' => 'GR'],
            ['name' => 'Heraklion', 'country_code' => 'GR'],
            ['name' => 'Hios', 'country_code' => 'GR'],
            ['name' => 'Ilia', 'country_code' => 'GR'],
            ['name' => 'Imathia', 'country_code' => 'GR'],
            ['name' => 'Ioannina', 'country_code' => 'GR'],
            ['name' => 'Iraklion', 'country_code' => 'GR'],
            ['name' => 'Karditsa', 'country_code' => 'GR'],
            ['name' => 'Kastoria', 'country_code' => 'GR'],
            ['name' => 'Kavala', 'country_code' => 'GR'],
            ['name' => 'Kefallinia', 'country_code' => 'GR'],
            ['name' => 'Kerkira', 'country_code' => 'GR'],
            ['name' => 'Kiklades', 'country_code' => 'GR'],
            ['name' => 'Kilkis', 'country_code' => 'GR'],
            ['name' => 'Korinthia', 'country_code' => 'GR'],
            ['name' => 'Kozani', 'country_code' => 'GR'],
            ['name' => 'Lakonia', 'country_code' => 'GR'],
            ['name' => 'Larisa', 'country_code' => 'GR'],
            ['name' => 'Lasithi', 'country_code' => 'GR'],
            ['name' => 'Lesvos', 'country_code' => 'GR'],
            ['name' => 'Levkas', 'country_code' => 'GR'],
            ['name' => 'Magnisia', 'country_code' => 'GR'],
            ['name' => 'Messinia', 'country_code' => 'GR'],
            ['name' => 'Nomos Attikis', 'country_code' => 'GR'],
            ['name' => 'Nomos Zakynthou', 'country_code' => 'GR'],
            ['name' => 'Pella', 'country_code' => 'GR'],
            ['name' => 'Pieria', 'country_code' => 'GR'],
            ['name' => 'Piraios', 'country_code' => 'GR'],
            ['name' => 'Preveza', 'country_code' => 'GR'],
            ['name' => 'Rethimni', 'country_code' => 'GR'],
            ['name' => 'Rodopi', 'country_code' => 'GR'],
            ['name' => 'Samos', 'country_code' => 'GR'],
            ['name' => 'Serrai', 'country_code' => 'GR'],
            ['name' => 'Thesprotia', 'country_code' => 'GR'],
            ['name' => 'Thessaloniki', 'country_code' => 'GR'],
            ['name' => 'Trikala', 'country_code' => 'GR'],
            ['name' => 'Voiotia', 'country_code' => 'GR'],
            ['name' => 'West Greece', 'country_code' => 'GR'],
            ['name' => 'Xanthi', 'country_code' => 'GR'],
            ['name' => 'Zakinthos', 'country_code' => 'GR'],
            ['name' => 'Aasiaat', 'country_code' => 'GL'],
            ['name' => 'Ammassalik', 'country_code' => 'GL'],
            ['name' => 'Illoqqortoormiut', 'country_code' => 'GL'],
            ['name' => 'Ilulissat', 'country_code' => 'GL'],
            ['name' => 'Ivittuut', 'country_code' => 'GL'],
            ['name' => 'Kangaatsiaq', 'country_code' => 'GL'],
            ['name' => 'Maniitsoq', 'country_code' => 'GL'],
            ['name' => 'Nanortalik', 'country_code' => 'GL'],
            ['name' => 'Narsaq', 'country_code' => 'GL'],
            ['name' => 'Nuuk', 'country_code' => 'GL'],
            ['name' => 'Paamiut', 'country_code' => 'GL'],
            ['name' => 'Qaanaaq', 'country_code' => 'GL'],
            ['name' => 'Qaqortoq', 'country_code' => 'GL'],
            ['name' => 'Qasigiannguit', 'country_code' => 'GL'],
            ['name' => 'Qeqertarsuaq', 'country_code' => 'GL'],
            ['name' => 'Sisimiut', 'country_code' => 'GL'],
            ['name' => 'Udenfor kommunal inddeling', 'country_code' => 'GL'],
            ['name' => 'Upernavik', 'country_code' => 'GL'],
            ['name' => 'Uummannaq', 'country_code' => 'GL'],
            ['name' => 'Carriacou-Petite Martinique', 'country_code' => 'GD'],
            ['name' => 'Saint Andrew', 'country_code' => 'GD'],
            ['name' => 'Saint Davids', 'country_code' => 'GD'],
            ['name' => "Saint George's", 'country_code' => 'GD'],
            ['name' => 'Saint John', 'country_code' => 'GD'],
            ['name' => 'Saint Mark', 'country_code' => 'GD'],
            ['name' => 'Saint Patrick', 'country_code' => 'GD'],
            ['name' => 'Basse-Terre', 'country_code' => 'GP'],
            ['name' => 'Grande-Terre', 'country_code' => 'GP'],
            ['name' => 'Iles des Saintes', 'country_code' => 'GP'],
            ['name' => 'La Desirade', 'country_code' => 'GP'],
            ['name' => 'Marie-Galante', 'country_code' => 'GP'],
            ['name' => 'Saint Barthelemy', 'country_code' => 'GP'],
            ['name' => 'Saint Martin', 'country_code' => 'GP'],
            ['name' => 'Agana Heights', 'country_code' => 'GU'],
            ['name' => 'Agat', 'country_code' => 'GU'],
            ['name' => 'Barrigada', 'country_code' => 'GU'],
            ['name' => 'Chalan-Pago-Ordot', 'country_code' => 'GU'],
            ['name' => 'Dededo', 'country_code' => 'GU'],
            ['name' => 'Hagatna', 'country_code' => 'GU'],
            ['name' => 'Inarajan', 'country_code' => 'GU'],
            ['name' => 'Mangilao', 'country_code' => 'GU'],
            ['name' => 'Merizo', 'country_code' => 'GU'],
            ['name' => 'Mongmong-Toto-Maite', 'country_code' => 'GU'],
            ['name' => 'Santa Rita', 'country_code' => 'GU'],
            ['name' => 'Sinajana', 'country_code' => 'GU'],
            ['name' => 'Talofofo', 'country_code' => 'GU'],
            ['name' => 'Tamuning', 'country_code' => 'GU'],
            ['name' => 'Yigo', 'country_code' => 'GU'],
            ['name' => 'Yona', 'country_code' => 'GU'],
            ['name' => 'Alta Verapaz', 'country_code' => 'GT'],
            ['name' => 'Baja Verapaz', 'country_code' => 'GT'],
            ['name' => 'Chimaltenango', 'country_code' => 'GT'],
            ['name' => 'Chiquimula', 'country_code' => 'GT'],
            ['name' => 'El Progreso', 'country_code' => 'GT'],
            ['name' => 'Escuintla', 'country_code' => 'GT'],
            ['name' => 'Guatemala', 'country_code' => 'GT'],
            ['name' => 'Huehuetenango', 'country_code' => 'GT'],
            ['name' => 'Izabal', 'country_code' => 'GT'],
            ['name' => 'Jalapa', 'country_code' => 'GT'],
            ['name' => 'Jutiapa', 'country_code' => 'GT'],
            ['name' => 'Peten', 'country_code' => 'GT'],
            ['name' => 'Quezaltenango', 'country_code' => 'GT'],
            ['name' => 'Quiche', 'country_code' => 'GT'],
            ['name' => 'Retalhuleu', 'country_code' => 'GT'],
            ['name' => 'Sacatepequez', 'country_code' => 'GT'],
            ['name' => 'San Marcos', 'country_code' => 'GT'],
            ['name' => 'Santa Rosa', 'country_code' => 'GT'],
            ['name' => 'Solola', 'country_code' => 'GT'],
            ['name' => 'Suchitepequez', 'country_code' => 'GT'],
            ['name' => 'Totonicapan', 'country_code' => 'GT'],
            ['name' => 'Zacapa', 'country_code' => 'GT'],
            ['name' => 'Alderney', 'country_code' => 'XU'],
            ['name' => 'Castel', 'country_code' => 'XU'],
            ['name' => 'Forest', 'country_code' => 'XU'],
            ['name' => 'Saint Andrew', 'country_code' => 'XU'],
            ['name' => 'Saint Martin', 'country_code' => 'XU'],
            ['name' => 'Saint Peter Port', 'country_code' => 'XU'],
            ['name' => 'Saint Pierre du Bois', 'country_code' => 'XU'],
            ['name' => 'Saint Sampson', 'country_code' => 'XU'],
            ['name' => 'Saint Saviour', 'country_code' => 'XU'],
            ['name' => 'Sark', 'country_code' => 'XU'],
            ['name' => 'Torteval', 'country_code' => 'XU'],
            ['name' => 'Vale', 'country_code' => 'XU'],
            ['name' => 'Beyla', 'country_code' => 'GN'],
            ['name' => 'Boffa', 'country_code' => 'GN'],
            ['name' => 'Boke', 'country_code' => 'GN'],
            ['name' => 'Conakry', 'country_code' => 'GN'],
            ['name' => 'Coyah', 'country_code' => 'GN'],
            ['name' => 'Dabola', 'country_code' => 'GN'],
            ['name' => 'Dalaba', 'country_code' => 'GN'],
            ['name' => 'Dinguiraye', 'country_code' => 'GN'],
            ['name' => 'Faranah', 'country_code' => 'GN'],
            ['name' => 'Forecariah', 'country_code' => 'GN'],
            ['name' => 'Fria', 'country_code' => 'GN'],
            ['name' => 'Gaoual', 'country_code' => 'GN'],
            ['name' => 'Gueckedou', 'country_code' => 'GN'],
            ['name' => 'Kankan', 'country_code' => 'GN'],
            ['name' => 'Kerouane', 'country_code' => 'GN'],
            ['name' => 'Kindia', 'country_code' => 'GN'],
            ['name' => 'Kissidougou', 'country_code' => 'GN'],
            ['name' => 'Koubia', 'country_code' => 'GN'],
            ['name' => 'Koundara', 'country_code' => 'GN'],
            ['name' => 'Kouroussa', 'country_code' => 'GN'],
            ['name' => 'Labe', 'country_code' => 'GN'],
            ['name' => 'Lola', 'country_code' => 'GN'],
            ['name' => 'Macenta', 'country_code' => 'GN'],
            ['name' => 'Mali', 'country_code' => 'GN'],
            ['name' => 'Mamou', 'country_code' => 'GN'],
            ['name' => 'Mandiana', 'country_code' => 'GN'],
            ['name' => 'Nzerekore', 'country_code' => 'GN'],
            ['name' => 'Pita', 'country_code' => 'GN'],
            ['name' => 'Siguiri', 'country_code' => 'GN'],
            ['name' => 'Telimele', 'country_code' => 'GN'],
            ['name' => 'Tougue', 'country_code' => 'GN'],
            ['name' => 'Yomou', 'country_code' => 'GN'],
            ['name' => 'Bafata', 'country_code' => 'GW'],
            ['name' => 'Bissau', 'country_code' => 'GW'],
            ['name' => 'Bolama', 'country_code' => 'GW'],
            ['name' => 'Cacheu', 'country_code' => 'GW'],
            ['name' => 'Gabu', 'country_code' => 'GW'],
            ['name' => 'Oio', 'country_code' => 'GW'],
            ['name' => 'Quinara', 'country_code' => 'GW'],
            ['name' => 'Tombali', 'country_code' => 'GW'],
            ['name' => 'Barima-Waini', 'country_code' => 'GY'],
            ['name' => 'Cuyuni-Mazaruni', 'country_code' => 'GY'],
            ['name' => 'Demerara-Mahaica', 'country_code' => 'GY'],
            ['name' => 'East Berbice-Corentyne', 'country_code' => 'GY'],
            ['name' => 'Essequibo Islands-West Demerar', 'country_code' => 'GY'],
            ['name' => 'Mahaica-Berbice', 'country_code' => 'GY'],
            ['name' => 'Pomeroon-Supenaam', 'country_code' => 'GY'],
            ['name' => 'Potaro-Siparuni', 'country_code' => 'GY'],
            ['name' => 'Upper Demerara-Berbice', 'country_code' => 'GY'],
            ['name' => 'Upper Takutu-Upper Essequibo', 'country_code' => 'GY'],
            ['name' => 'Artibonite', 'country_code' => 'HT'],
            ['name' => 'Centre', 'country_code' => 'HT'],
            ['name' => "Grand'Anse", 'country_code' => 'HT'],
            ['name' => 'Nord', 'country_code' => 'HT'],
            ['name' => 'Nord-Est', 'country_code' => 'HT'],
            ['name' => 'Nord-Ouest', 'country_code' => 'HT'],
            ['name' => 'Ouest', 'country_code' => 'HT'],
            ['name' => 'Sud', 'country_code' => 'HT'],
            ['name' => 'Sud-Est', 'country_code' => 'HT'],
            ['name' => 'Heard and McDonald Islands', 'country_code' => 'HM'],
            ['name' => 'Atlantida', 'country_code' => 'HN'],
            ['name' => 'Choluteca', 'country_code' => 'HN'],
            ['name' => 'Colon', 'country_code' => 'HN'],
            ['name' => 'Comayagua', 'country_code' => 'HN'],
            ['name' => 'Copan', 'country_code' => 'HN'],
            ['name' => 'Cortes', 'country_code' => 'HN'],
            ['name' => 'Distrito Central', 'country_code' => 'HN'],
            ['name' => 'El Paraiso', 'country_code' => 'HN'],
            ['name' => 'Francisco Morazan', 'country_code' => 'HN'],
            ['name' => 'Gracias a Dios', 'country_code' => 'HN'],
            ['name' => 'Intibuca', 'country_code' => 'HN'],
            ['name' => 'Islas de la Bahia', 'country_code' => 'HN'],
            ['name' => 'La Paz', 'country_code' => 'HN'],
            ['name' => 'Lempira', 'country_code' => 'HN'],
            ['name' => 'Ocotepeque', 'country_code' => 'HN'],
            ['name' => 'Olancho', 'country_code' => 'HN'],
            ['name' => 'Santa Barbara', 'country_code' => 'HN'],
            ['name' => 'Valle', 'country_code' => 'HN'],
            ['name' => 'Yoro', 'country_code' => 'HN'],
            ['name' => 'Hong Kong', 'country_code' => 'HK'],
            ['name' => 'Bacs-Kiskun', 'country_code' => 'HU'],
            ['name' => 'Baranya', 'country_code' => 'HU'],
            ['name' => 'Bekes', 'country_code' => 'HU'],
            ['name' => 'Borsod-Abauj-Zemplen', 'country_code' => 'HU'],
            ['name' => 'Budapest', 'country_code' => 'HU'],
            ['name' => 'Csongrad', 'country_code' => 'HU'],
            ['name' => 'Fejer', 'country_code' => 'HU'],
            ['name' => 'Gyor-Moson-Sopron', 'country_code' => 'HU'],
            ['name' => 'Hajdu-Bihar', 'country_code' => 'HU'],
            ['name' => 'Heves', 'country_code' => 'HU'],
            ['name' => 'Jasz-Nagykun-Szolnok', 'country_code' => 'HU'],
            ['name' => 'Komarom-Esztergom', 'country_code' => 'HU'],
            ['name' => 'Nograd', 'country_code' => 'HU'],
            ['name' => 'Pest', 'country_code' => 'HU'],
            ['name' => 'Somogy', 'country_code' => 'HU'],
            ['name' => 'Szabolcs-Szatmar-Bereg', 'country_code' => 'HU'],
            ['name' => 'Tolna', 'country_code' => 'HU'],
            ['name' => 'Vas', 'country_code' => 'HU'],
            ['name' => 'Veszprem', 'country_code' => 'HU'],
            ['name' => 'Zala', 'country_code' => 'HU'],
            ['name' => 'Austurland', 'country_code' => 'IS'],
            ['name' => 'Gullbringusysla', 'country_code' => 'IS'],
            ['name' => 'Hofu borgarsva i', 'country_code' => 'IS'],
            ['name' => 'Nor urland eystra', 'country_code' => 'IS'],
            ['name' => 'Nor urland vestra', 'country_code' => 'IS'],
            ['name' => 'Su urland', 'country_code' => 'IS'],
            ['name' => 'Su urnes', 'country_code' => 'IS'],
            ['name' => 'Vestfir ir', 'country_code' => 'IS'],
            ['name' => 'Vesturland', 'country_code' => 'IS'],
            ['name' => 'Aceh', 'country_code' => 'ID'],
            ['name' => 'Bali', 'country_code' => 'ID'],
            ['name' => 'Bangka-Belitung', 'country_code' => 'ID'],
            ['name' => 'Banten', 'country_code' => 'ID'],
            ['name' => 'Bengkulu', 'country_code' => 'ID'],
            ['name' => 'Gandaria', 'country_code' => 'ID'],
            ['name' => 'Gorontalo', 'country_code' => 'ID'],
            ['name' => 'Jakarta', 'country_code' => 'ID'],
            ['name' => 'Jambi', 'country_code' => 'ID'],
            ['name' => 'Jawa Barat', 'country_code' => 'ID'],
            ['name' => 'Jawa Tengah', 'country_code' => 'ID'],
            ['name' => 'Jawa Timur', 'country_code' => 'ID'],
            ['name' => 'Kalimantan Barat', 'country_code' => 'ID'],
            ['name' => 'Kalimantan Selatan', 'country_code' => 'ID'],
            ['name' => 'Kalimantan Tengah', 'country_code' => 'ID'],
            ['name' => 'Kalimantan Timur', 'country_code' => 'ID'],
            ['name' => 'Kendal', 'country_code' => 'ID'],
            ['name' => 'Lampung', 'country_code' => 'ID'],
            ['name' => 'Maluku', 'country_code' => 'ID'],
            ['name' => 'Maluku Utara', 'country_code' => 'ID'],
            ['name' => 'Nusa Tenggara Barat', 'country_code' => 'ID'],
            ['name' => 'Nusa Tenggara Timur', 'country_code' => 'ID'],
            ['name' => 'Papua', 'country_code' => 'ID'],
            ['name' => 'Riau', 'country_code' => 'ID'],
            ['name' => 'Riau Kepulauan', 'country_code' => 'ID'],
            ['name' => 'Solo', 'country_code' => 'ID'],
            ['name' => 'Sulawesi Selatan', 'country_code' => 'ID'],
            ['name' => 'Sulawesi Tengah', 'country_code' => 'ID'],
            ['name' => 'Sulawesi Tenggara', 'country_code' => 'ID'],
            ['name' => 'Sulawesi Utara', 'country_code' => 'ID'],
            ['name' => 'Sumatera Barat', 'country_code' => 'ID'],
            ['name' => 'Sumatera Selatan', 'country_code' => 'ID'],
            ['name' => 'Sumatera Utara', 'country_code' => 'ID'],
            ['name' => 'Yogyakarta', 'country_code' => 'ID'],
            ['name' => 'Ardabil', 'country_code' => 'IR'],
            ['name' => 'Azarbayjan-e Bakhtari', 'country_code' => 'IR'],
            ['name' => 'Azarbayjan-e Khavari', 'country_code' => 'IR'],
            ['name' => 'Bushehr', 'country_code' => 'IR'],
            ['name' => 'Chahar Mahal-e Bakhtiari', 'country_code' => 'IR'],
            ['name' => 'Esfahan', 'country_code' => 'IR'],
            ['name' => 'Fars', 'country_code' => 'IR'],
            ['name' => 'Gilan', 'country_code' => 'IR'],
            ['name' => 'Golestan', 'country_code' => 'IR'],
            ['name' => 'Hamadan', 'country_code' => 'IR'],
            ['name' => 'Hormozgan', 'country_code' => 'IR'],
            ['name' => 'Ilam', 'country_code' => 'IR'],
            ['name' => 'Kerman', 'country_code' => 'IR'],
            ['name' => 'Kermanshah', 'country_code' => 'IR'],
            ['name' => 'Khorasan', 'country_code' => 'IR'],
            ['name' => 'Khuzestan', 'country_code' => 'IR'],
            ['name' => 'Kohgiluyeh-e Boyerahmad', 'country_code' => 'IR'],
            ['name' => 'Kordestan', 'country_code' => 'IR'],
            ['name' => 'Lorestan', 'country_code' => 'IR'],
            ['name' => 'Markazi', 'country_code' => 'IR'],
            ['name' => 'Mazandaran', 'country_code' => 'IR'],
            ['name' => 'Ostan-e Esfahan', 'country_code' => 'IR'],
            ['name' => 'Qazvin', 'country_code' => 'IR'],
            ['name' => 'Qom', 'country_code' => 'IR'],
            ['name' => 'Semnan', 'country_code' => 'IR'],
            ['name' => 'Sistan-e Baluchestan', 'country_code' => 'IR'],
            ['name' => 'Tehran', 'country_code' => 'IR'],
            ['name' => 'Yazd', 'country_code' => 'IR'],
            ['name' => 'Zanjan', 'country_code' => 'IR'],
            ['name' => 'Babil', 'country_code' => 'IQ'],
            ['name' => 'Baghdad', 'country_code' => 'IQ'],
            ['name' => 'Dahuk', 'country_code' => 'IQ'],
            ['name' => 'Dhi Qar', 'country_code' => 'IQ'],
            ['name' => 'Diyala', 'country_code' => 'IQ'],
            ['name' => 'Erbil', 'country_code' => 'IQ'],
            ['name' => 'Irbil', 'country_code' => 'IQ'],
            ['name' => 'Karbala', 'country_code' => 'IQ'],
            ['name' => 'Kurdistan', 'country_code' => 'IQ'],
            ['name' => 'Maysan', 'country_code' => 'IQ'],
            ['name' => 'Ninawa', 'country_code' => 'IQ'],
            ['name' => 'Salah-ad-Din', 'country_code' => 'IQ'],
            ['name' => 'Wasit', 'country_code' => 'IQ'],
            ['name' => 'al-Anbar', 'country_code' => 'IQ'],
            ['name' => 'al-Basrah', 'country_code' => 'IQ'],
            ['name' => 'al-Muthanna', 'country_code' => 'IQ'],
            ['name' => 'al-Qadisiyah', 'country_code' => 'IQ'],
            ['name' => 'an-Najaf', 'country_code' => 'IQ'],
            ['name' => 'as-Sulaymaniyah', 'country_code' => 'IQ'],
            ['name' => "at-Ta'mim", 'country_code' => 'IQ'],
            ['name' => 'Armagh', 'country_code' => 'IE'],
            ['name' => 'Carlow', 'country_code' => 'IE'],
            ['name' => 'Cavan', 'country_code' => 'IE'],
            ['name' => 'Clare', 'country_code' => 'IE'],
            ['name' => 'Cork', 'country_code' => 'IE'],
            ['name' => 'Donegal', 'country_code' => 'IE'],
            ['name' => 'Dublin', 'country_code' => 'IE'],
            ['name' => 'Galway', 'country_code' => 'IE'],
            ['name' => 'Kerry', 'country_code' => 'IE'],
            ['name' => 'Kildare', 'country_code' => 'IE'],
            ['name' => 'Kilkenny', 'country_code' => 'IE'],
            ['name' => 'Laois', 'country_code' => 'IE'],
            ['name' => 'Leinster', 'country_code' => 'IE'],
            ['name' => 'Leitrim', 'country_code' => 'IE'],
            ['name' => 'Limerick', 'country_code' => 'IE'],
            ['name' => 'Loch Garman', 'country_code' => 'IE'],
            ['name' => 'Longford', 'country_code' => 'IE'],
            ['name' => 'Louth', 'country_code' => 'IE'],
            ['name' => 'Mayo', 'country_code' => 'IE'],
            ['name' => 'Meath', 'country_code' => 'IE'],
            ['name' => 'Monaghan', 'country_code' => 'IE'],
            ['name' => 'Offaly', 'country_code' => 'IE'],
            ['name' => 'Roscommon', 'country_code' => 'IE'],
            ['name' => 'Sligo', 'country_code' => 'IE'],
            ['name' => 'Tipperary North Riding', 'country_code' => 'IE'],
            ['name' => 'Tipperary South Riding', 'country_code' => 'IE'],
            ['name' => 'Ulster', 'country_code' => 'IE'],
            ['name' => 'Waterford', 'country_code' => 'IE'],
            ['name' => 'Westmeath', 'country_code' => 'IE'],
            ['name' => 'Wexford', 'country_code' => 'IE'],
            ['name' => 'Wicklow', 'country_code' => 'IE'],
            ['name' => 'Beit Hanania', 'country_code' => 'IL'],
            ['name' => 'Ben Gurion Airport', 'country_code' => 'IL'],
            ['name' => 'Bethlehem', 'country_code' => 'IL'],
            ['name' => 'Caesarea', 'country_code' => 'IL'],
            ['name' => 'Centre', 'country_code' => 'IL'],
            ['name' => 'Gaza', 'country_code' => 'IL'],
            ['name' => 'Hadaron', 'country_code' => 'IL'],
            ['name' => 'Haifa District', 'country_code' => 'IL'],
            ['name' => 'Hamerkaz', 'country_code' => 'IL'],
            ['name' => 'Hazafon', 'country_code' => 'IL'],
            ['name' => 'Hebron', 'country_code' => 'IL'],
            ['name' => 'Jaffa', 'country_code' => 'IL'],
            ['name' => 'Jerusalem', 'country_code' => 'IL'],
            ['name' => 'Khefa', 'country_code' => 'IL'],
            ['name' => 'Kiryat Yam', 'country_code' => 'IL'],
            ['name' => 'Lower Galilee', 'country_code' => 'IL'],
            ['name' => 'Qalqilya', 'country_code' => 'IL'],
            ['name' => 'Talme Elazar', 'country_code' => 'IL'],
            ['name' => 'Tel Aviv', 'country_code' => 'IL'],
            ['name' => 'Tsafon', 'country_code' => 'IL'],
            ['name' => 'Umm El Fahem', 'country_code' => 'IL'],
            ['name' => 'Yerushalayim', 'country_code' => 'IL'],
            ['name' => 'Abruzzi', 'country_code' => 'IT'],
            ['name' => 'Abruzzo', 'country_code' => 'IT'],
            ['name' => 'Agrigento', 'country_code' => 'IT'],
            ['name' => 'Alessandria', 'country_code' => 'IT'],
            ['name' => 'Ancona', 'country_code' => 'IT'],
            ['name' => 'Arezzo', 'country_code' => 'IT'],
            ['name' => 'Ascoli Piceno', 'country_code' => 'IT'],
            ['name' => 'Asti', 'country_code' => 'IT'],
            ['name' => 'Avellino', 'country_code' => 'IT'],
            ['name' => 'Bari', 'country_code' => 'IT'],
            ['name' => 'Basilicata', 'country_code' => 'IT'],
            ['name' => 'Belluno', 'country_code' => 'IT'],
            ['name' => 'Benevento', 'country_code' => 'IT'],
            ['name' => 'Bergamo', 'country_code' => 'IT'],
            ['name' => 'Biella', 'country_code' => 'IT'],
            ['name' => 'Bologna', 'country_code' => 'IT'],
            ['name' => 'Bolzano', 'country_code' => 'IT'],
            ['name' => 'Brescia', 'country_code' => 'IT'],
            ['name' => 'Brindisi', 'country_code' => 'IT'],
            ['name' => 'Calabria', 'country_code' => 'IT'],
            ['name' => 'Campania', 'country_code' => 'IT'],
            ['name' => 'Cartoceto', 'country_code' => 'IT'],
            ['name' => 'Caserta', 'country_code' => 'IT'],
            ['name' => 'Catania', 'country_code' => 'IT'],
            ['name' => 'Chieti', 'country_code' => 'IT'],
            ['name' => 'Como', 'country_code' => 'IT'],
            ['name' => 'Cosenza', 'country_code' => 'IT'],
            ['name' => 'Cremona', 'country_code' => 'IT'],
            ['name' => 'Cuneo', 'country_code' => 'IT'],
            ['name' => 'Emilia-Romagna', 'country_code' => 'IT'],
            ['name' => 'Ferrara', 'country_code' => 'IT'],
            ['name' => 'Firenze', 'country_code' => 'IT'],
            ['name' => 'Florence', 'country_code' => 'IT'],
            ['name' => 'Forli-Cesena ', 'country_code' => 'IT'],
            ['name' => 'Friuli-Venezia Giulia', 'country_code' => 'IT'],
            ['name' => 'Frosinone', 'country_code' => 'IT'],
            ['name' => 'Genoa', 'country_code' => 'IT'],
            ['name' => 'Gorizia', 'country_code' => 'IT'],
            ['name' => "L'Aquila", 'country_code' => 'IT'],
            ['name' => 'Lazio', 'country_code' => 'IT'],
            ['name' => 'Lecce', 'country_code' => 'IT'],
            ['name' => 'Lecco', 'country_code' => 'IT'],
            ['name' => 'Lecco Province', 'country_code' => 'IT'],
            ['name' => 'Liguria', 'country_code' => 'IT'],
            ['name' => 'Lodi', 'country_code' => 'IT'],
            ['name' => 'Lombardia', 'country_code' => 'IT'],
            ['name' => 'Lombardy', 'country_code' => 'IT'],
            ['name' => 'Macerata', 'country_code' => 'IT'],
            ['name' => 'Mantova', 'country_code' => 'IT'],
            ['name' => 'Marche', 'country_code' => 'IT'],
            ['name' => 'Messina', 'country_code' => 'IT'],
            ['name' => 'Milan', 'country_code' => 'IT'],
            ['name' => 'Modena', 'country_code' => 'IT'],
            ['name' => 'Molise', 'country_code' => 'IT'],
            ['name' => 'Molteno', 'country_code' => 'IT'],
            ['name' => 'Montenegro', 'country_code' => 'IT'],
            ['name' => 'Monza and Brianza', 'country_code' => 'IT'],
            ['name' => 'Naples', 'country_code' => 'IT'],
            ['name' => 'Novara', 'country_code' => 'IT'],
            ['name' => 'Padova', 'country_code' => 'IT'],
            ['name' => 'Parma', 'country_code' => 'IT'],
            ['name' => 'Pavia', 'country_code' => 'IT'],
            ['name' => 'Perugia', 'country_code' => 'IT'],
            ['name' => 'Pesaro-Urbino', 'country_code' => 'IT'],
            ['name' => 'Piacenza', 'country_code' => 'IT'],
            ['name' => 'Piedmont', 'country_code' => 'IT'],
            ['name' => 'Piemonte', 'country_code' => 'IT'],
            ['name' => 'Pisa', 'country_code' => 'IT'],
            ['name' => 'Pordenone', 'country_code' => 'IT'],
            ['name' => 'Potenza', 'country_code' => 'IT'],
            ['name' => 'Puglia', 'country_code' => 'IT'],
            ['name' => 'Reggio Emilia', 'country_code' => 'IT'],
            ['name' => 'Rimini', 'country_code' => 'IT'],
            ['name' => 'Roma', 'country_code' => 'IT'],
            ['name' => 'Salerno', 'country_code' => 'IT'],
            ['name' => 'Sardegna', 'country_code' => 'IT'],
            ['name' => 'Sassari', 'country_code' => 'IT'],
            ['name' => 'Savona', 'country_code' => 'IT'],
            ['name' => 'Sicilia', 'country_code' => 'IT'],
            ['name' => 'Siena', 'country_code' => 'IT'],
            ['name' => 'Sondrio', 'country_code' => 'IT'],
            ['name' => 'South Tyrol', 'country_code' => 'IT'],
            ['name' => 'Taranto', 'country_code' => 'IT'],
            ['name' => 'Teramo', 'country_code' => 'IT'],
            ['name' => 'Torino', 'country_code' => 'IT'],
            ['name' => 'Toscana', 'country_code' => 'IT'],
            ['name' => 'Trapani', 'country_code' => 'IT'],
            ['name' => 'Trentino-Alto Adige', 'country_code' => 'IT'],
            ['name' => 'Trento', 'country_code' => 'IT'],
            ['name' => 'Treviso', 'country_code' => 'IT'],
            ['name' => 'Udine', 'country_code' => 'IT'],
            ['name' => 'Umbria', 'country_code' => 'IT'],
            ['name' => "Valle d'Aosta", 'country_code' => 'IT'],
            ['name' => 'Varese', 'country_code' => 'IT'],
            ['name' => 'Veneto', 'country_code' => 'IT'],
            ['name' => 'Venezia', 'country_code' => 'IT'],
            ['name' => 'Verbano-Cusio-Ossola', 'country_code' => 'IT'],
            ['name' => 'Vercelli', 'country_code' => 'IT'],
            ['name' => 'Verona', 'country_code' => 'IT'],
            ['name' => 'Vicenza', 'country_code' => 'IT'],
            ['name' => 'Viterbo', 'country_code' => 'IT'],
            ['name' => 'Buxoro Viloyati', 'country_code' => 'JM'],
            ['name' => 'Clarendon', 'country_code' => 'JM'],
            ['name' => 'Hanover', 'country_code' => 'JM'],
            ['name' => 'Kingston', 'country_code' => 'JM'],
            ['name' => 'Manchester', 'country_code' => 'JM'],
            ['name' => 'Portland', 'country_code' => 'JM'],
            ['name' => 'Saint Andrews', 'country_code' => 'JM'],
            ['name' => 'Saint Ann', 'country_code' => 'JM'],
            ['name' => 'Saint Catherine', 'country_code' => 'JM'],
            ['name' => 'Saint Elizabeth', 'country_code' => 'JM'],
            ['name' => 'Saint James', 'country_code' => 'JM'],
            ['name' => 'Saint Mary', 'country_code' => 'JM'],
            ['name' => 'Saint Thomas', 'country_code' => 'JM'],
            ['name' => 'Trelawney', 'country_code' => 'JM'],
            ['name' => 'Westmoreland', 'country_code' => 'JM'],
            ['name' => 'Aichi', 'country_code' => 'JP'],
            ['name' => 'Akita', 'country_code' => 'JP'],
            ['name' => 'Aomori', 'country_code' => 'JP'],
            ['name' => 'Chiba', 'country_code' => 'JP'],
            ['name' => 'Ehime', 'country_code' => 'JP'],
            ['name' => 'Fukui', 'country_code' => 'JP'],
            ['name' => 'Fukuoka', 'country_code' => 'JP'],
            ['name' => 'Fukushima', 'country_code' => 'JP'],
            ['name' => 'Gifu', 'country_code' => 'JP'],
            ['name' => 'Gumma', 'country_code' => 'JP'],
            ['name' => 'Hiroshima', 'country_code' => 'JP'],
            ['name' => 'Hokkaido', 'country_code' => 'JP'],
            ['name' => 'Hyogo', 'country_code' => 'JP'],
            ['name' => 'Ibaraki', 'country_code' => 'JP'],
            ['name' => 'Ishikawa', 'country_code' => 'JP'],
            ['name' => 'Iwate', 'country_code' => 'JP'],
            ['name' => 'Kagawa', 'country_code' => 'JP'],
            ['name' => 'Kagoshima', 'country_code' => 'JP'],
            ['name' => 'Kanagawa', 'country_code' => 'JP'],
            ['name' => 'Kanto', 'country_code' => 'JP'],
            ['name' => 'Kochi', 'country_code' => 'JP'],
            ['name' => 'Kumamoto', 'country_code' => 'JP'],
            ['name' => 'Kyoto', 'country_code' => 'JP'],
            ['name' => 'Mie', 'country_code' => 'JP'],
            ['name' => 'Miyagi', 'country_code' => 'JP'],
            ['name' => 'Miyazaki', 'country_code' => 'JP'],
            ['name' => 'Nagano', 'country_code' => 'JP'],
            ['name' => 'Nagasaki', 'country_code' => 'JP'],
            ['name' => 'Nara', 'country_code' => 'JP'],
            ['name' => 'Niigata', 'country_code' => 'JP'],
            ['name' => 'Oita', 'country_code' => 'JP'],
            ['name' => 'Okayama', 'country_code' => 'JP'],
            ['name' => 'Okinawa', 'country_code' => 'JP'],
            ['name' => 'Osaka', 'country_code' => 'JP'],
            ['name' => 'Saga', 'country_code' => 'JP'],
            ['name' => 'Saitama', 'country_code' => 'JP'],
            ['name' => 'Shiga', 'country_code' => 'JP'],
            ['name' => 'Shimane', 'country_code' => 'JP'],
            ['name' => 'Shizuoka', 'country_code' => 'JP'],
            ['name' => 'Tochigi', 'country_code' => 'JP'],
            ['name' => 'Tokushima', 'country_code' => 'JP'],
            ['name' => 'Tokyo', 'country_code' => 'JP'],
            ['name' => 'Tottori', 'country_code' => 'JP'],
            ['name' => 'Toyama', 'country_code' => 'JP'],
            ['name' => 'Wakayama', 'country_code' => 'JP'],
            ['name' => 'Yamagata', 'country_code' => 'JP'],
            ['name' => 'Yamaguchi', 'country_code' => 'JP'],
            ['name' => 'Yamanashi', 'country_code' => 'JP'],
            ['name' => 'Grouville', 'country_code' => 'XJ'],
            ['name' => 'Saint Brelade', 'country_code' => 'XJ'],
            ['name' => 'Saint Clement', 'country_code' => 'XJ'],
            ['name' => 'Saint Helier', 'country_code' => 'XJ'],
            ['name' => 'Saint John', 'country_code' => 'XJ'],
            ['name' => 'Saint Lawrence', 'country_code' => 'XJ'],
            ['name' => 'Saint Martin', 'country_code' => 'XJ'],
            ['name' => 'Saint Mary', 'country_code' => 'XJ'],
            ['name' => 'Saint Peter', 'country_code' => 'XJ'],
            ['name' => 'Saint Saviour', 'country_code' => 'XJ'],
            ['name' => 'Trinity', 'country_code' => 'XJ'],
            ['name' => "'Ajlun", 'country_code' => 'JO'],
            ['name' => 'Amman', 'country_code' => 'JO'],
            ['name' => 'Irbid', 'country_code' => 'JO'],
            ['name' => 'Jarash', 'country_code' => 'JO'],
            ['name' => "Ma'an", 'country_code' => 'JO'],
            ['name' => 'Madaba', 'country_code' => 'JO'],
            ['name' => "al-'Aqabah", 'country_code' => 'JO'],
            ['name' => "al-Balqa'", 'country_code' => 'JO'],
            ['name' => 'al-Karak', 'country_code' => 'JO'],
            ['name' => 'al-Mafraq', 'country_code' => 'JO'],
            ['name' => 'at-Tafilah', 'country_code' => 'JO'],
            ['name' => "az-Zarqa'", 'country_code' => 'JO'],
            ['name' => 'Akmecet', 'country_code' => 'KZ'],
            ['name' => 'Akmola', 'country_code' => 'KZ'],
            ['name' => 'Aktobe', 'country_code' => 'KZ'],
            ['name' => 'Almati', 'country_code' => 'KZ'],
            ['name' => 'Atirau', 'country_code' => 'KZ'],
            ['name' => 'Batis Kazakstan', 'country_code' => 'KZ'],
            ['name' => 'Burlinsky Region', 'country_code' => 'KZ'],
            ['name' => 'Karagandi', 'country_code' => 'KZ'],
            ['name' => 'Kostanay', 'country_code' => 'KZ'],
            ['name' => 'Mankistau', 'country_code' => 'KZ'],
            ['name' => 'Ontustik Kazakstan', 'country_code' => 'KZ'],
            ['name' => 'Pavlodar', 'country_code' => 'KZ'],
            ['name' => 'Sigis Kazakstan', 'country_code' => 'KZ'],
            ['name' => 'Soltustik Kazakstan', 'country_code' => 'KZ'],
            ['name' => 'Taraz', 'country_code' => 'KZ'],
            ['name' => 'Central', 'country_code' => 'KE'],
            ['name' => 'Coast', 'country_code' => 'KE'],
            ['name' => 'Eastern', 'country_code' => 'KE'],
            ['name' => 'Nairobi', 'country_code' => 'KE'],
            ['name' => 'North Eastern', 'country_code' => 'KE'],
            ['name' => 'Nyanza', 'country_code' => 'KE'],
            ['name' => 'Rift Valley', 'country_code' => 'KE'],
            ['name' => 'Western', 'country_code' => 'KE'],
            ['name' => 'Abaiang', 'country_code' => 'KI'],
            ['name' => 'Abemana', 'country_code' => 'KI'],
            ['name' => 'Aranuka', 'country_code' => 'KI'],
            ['name' => 'Arorae', 'country_code' => 'KI'],
            ['name' => 'Banaba', 'country_code' => 'KI'],
            ['name' => 'Beru', 'country_code' => 'KI'],
            ['name' => 'Butaritari', 'country_code' => 'KI'],
            ['name' => 'Kiritimati', 'country_code' => 'KI'],
            ['name' => 'Kuria', 'country_code' => 'KI'],
            ['name' => 'Maiana', 'country_code' => 'KI'],
            ['name' => 'Makin', 'country_code' => 'KI'],
            ['name' => 'Marakei', 'country_code' => 'KI'],
            ['name' => 'Nikunau', 'country_code' => 'KI'],
            ['name' => 'Nonouti', 'country_code' => 'KI'],
            ['name' => 'Onotoa', 'country_code' => 'KI'],
            ['name' => 'Phoenix Islands', 'country_code' => 'KI'],
            ['name' => 'Tabiteuea North', 'country_code' => 'KI'],
            ['name' => 'Tabiteuea South', 'country_code' => 'KI'],
            ['name' => 'Tabuaeran', 'country_code' => 'KI'],
            ['name' => 'Tamana', 'country_code' => 'KI'],
            ['name' => 'Tarawa North', 'country_code' => 'KI'],
            ['name' => 'Tarawa South', 'country_code' => 'KI'],
            ['name' => 'Teraina', 'country_code' => 'KI'],
            ['name' => 'Chagangdo', 'country_code' => 'KP'],
            ['name' => 'Hamgyeongbukto', 'country_code' => 'KP'],
            ['name' => 'Hamgyeongnamdo', 'country_code' => 'KP'],
            ['name' => 'Hwanghaebukto', 'country_code' => 'KP'],
            ['name' => 'Hwanghaenamdo', 'country_code' => 'KP'],
            ['name' => 'Kaeseong', 'country_code' => 'KP'],
            ['name' => 'Kangweon', 'country_code' => 'KP'],
            ['name' => 'Nampo', 'country_code' => 'KP'],
            ['name' => 'Pyeonganbukto', 'country_code' => 'KP'],
            ['name' => 'Pyeongannamdo', 'country_code' => 'KP'],
            ['name' => 'Pyeongyang', 'country_code' => 'KP'],
            ['name' => 'Yanggang', 'country_code' => 'KP'],
            ['name' => 'Busan', 'country_code' => 'KR'],
            ['name' => 'Cheju', 'country_code' => 'KR'],
            ['name' => 'Chollabuk', 'country_code' => 'KR'],
            ['name' => 'Chollanam', 'country_code' => 'KR'],
            ['name' => 'Chungbuk', 'country_code' => 'KR'],
            ['name' => 'Chungcheongbuk', 'country_code' => 'KR'],
            ['name' => 'Chungcheongnam', 'country_code' => 'KR'],
            ['name' => 'Chungnam', 'country_code' => 'KR'],
            ['name' => 'Daegu', 'country_code' => 'KR'],
            ['name' => 'Gangwon-do', 'country_code' => 'KR'],
            ['name' => 'Goyang-si', 'country_code' => 'KR'],
            ['name' => 'Gyeonggi-do', 'country_code' => 'KR'],
            ['name' => 'Gyeongsang ', 'country_code' => 'KR'],
            ['name' => 'Gyeongsangnam-do', 'country_code' => 'KR'],
            ['name' => 'Incheon', 'country_code' => 'KR'],
            ['name' => 'Jeju-Si', 'country_code' => 'KR'],
            ['name' => 'Jeonbuk', 'country_code' => 'KR'],
            ['name' => 'Kangweon', 'country_code' => 'KR'],
            ['name' => 'Kwangju', 'country_code' => 'KR'],
            ['name' => 'Kyeonggi', 'country_code' => 'KR'],
            ['name' => 'Kyeongsangbuk', 'country_code' => 'KR'],
            ['name' => 'Kyeongsangnam', 'country_code' => 'KR'],
            ['name' => 'Kyonggi-do', 'country_code' => 'KR'],
            ['name' => 'Kyungbuk-Do', 'country_code' => 'KR'],
            ['name' => 'Kyunggi-Do', 'country_code' => 'KR'],
            ['name' => 'Kyunggi-do', 'country_code' => 'KR'],
            ['name' => 'Pusan', 'country_code' => 'KR'],
            ['name' => 'Seoul', 'country_code' => 'KR'],
            ['name' => 'Sudogwon', 'country_code' => 'KR'],
            ['name' => 'Taegu', 'country_code' => 'KR'],
            ['name' => 'Taejeon', 'country_code' => 'KR'],
            ['name' => 'Taejon-gwangyoksi', 'country_code' => 'KR'],
            ['name' => 'Ulsan', 'country_code' => 'KR'],
            ['name' => 'Wonju', 'country_code' => 'KR'],
            ['name' => 'gwangyoksi', 'country_code' => 'KR'],
            ['name' => 'Al Asimah', 'country_code' => 'KW'],
            ['name' => 'Hawalli', 'country_code' => 'KW'],
            ['name' => 'Mishref', 'country_code' => 'KW'],
            ['name' => 'Qadesiya', 'country_code' => 'KW'],
            ['name' => 'Safat', 'country_code' => 'KW'],
            ['name' => 'Salmiya', 'country_code' => 'KW'],
            ['name' => 'al-Ahmadi', 'country_code' => 'KW'],
            ['name' => 'al-Farwaniyah', 'country_code' => 'KW'],
            ['name' => 'al-Jahra', 'country_code' => 'KW'],
            ['name' => 'al-Kuwayt', 'country_code' => 'KW'],
            ['name' => 'Batken', 'country_code' => 'KG'],
            ['name' => 'Bishkek', 'country_code' => 'KG'],
            ['name' => 'Chui', 'country_code' => 'KG'],
            ['name' => 'Issyk-Kul', 'country_code' => 'KG'],
            ['name' => 'Jalal-Abad', 'country_code' => 'KG'],
            ['name' => 'Naryn', 'country_code' => 'KG'],
            ['name' => 'Osh', 'country_code' => 'KG'],
            ['name' => 'Talas', 'country_code' => 'KG'],
            ['name' => 'Attopu', 'country_code' => 'LA'],
            ['name' => 'Bokeo', 'country_code' => 'LA'],
            ['name' => 'Bolikhamsay', 'country_code' => 'LA'],
            ['name' => 'Champasak', 'country_code' => 'LA'],
            ['name' => 'Houaphanh', 'country_code' => 'LA'],
            ['name' => 'Khammouane', 'country_code' => 'LA'],
            ['name' => 'Luang Nam Tha', 'country_code' => 'LA'],
            ['name' => 'Luang Prabang', 'country_code' => 'LA'],
            ['name' => 'Oudomxay', 'country_code' => 'LA'],
            ['name' => 'Phongsaly', 'country_code' => 'LA'],
            ['name' => 'Saravan', 'country_code' => 'LA'],
            ['name' => 'Savannakhet', 'country_code' => 'LA'],
            ['name' => 'Sekong', 'country_code' => 'LA'],
            ['name' => 'Viangchan Prefecture', 'country_code' => 'LA'],
            ['name' => 'Viangchan Province', 'country_code' => 'LA'],
            ['name' => 'Xaignabury', 'country_code' => 'LA'],
            ['name' => 'Xiang Khuang', 'country_code' => 'LA'],
            ['name' => 'Aizkraukles', 'country_code' => 'LV'],
            ['name' => 'Aluksnes', 'country_code' => 'LV'],
            ['name' => 'Balvu', 'country_code' => 'LV'],
            ['name' => 'Bauskas', 'country_code' => 'LV'],
            ['name' => 'Cesu', 'country_code' => 'LV'],
            ['name' => 'Daugavpils', 'country_code' => 'LV'],
            ['name' => 'Daugavpils City', 'country_code' => 'LV'],
            ['name' => 'Dobeles', 'country_code' => 'LV'],
            ['name' => 'Gulbenes', 'country_code' => 'LV'],
            ['name' => 'Jekabspils', 'country_code' => 'LV'],
            ['name' => 'Jelgava', 'country_code' => 'LV'],
            ['name' => 'Jelgavas', 'country_code' => 'LV'],
            ['name' => 'Jurmala City', 'country_code' => 'LV'],
            ['name' => 'Kraslavas', 'country_code' => 'LV'],
            ['name' => 'Kuldigas', 'country_code' => 'LV'],
            ['name' => 'Liepaja', 'country_code' => 'LV'],
            ['name' => 'Liepajas', 'country_code' => 'LV'],
            ['name' => 'Limbazhu', 'country_code' => 'LV'],
            ['name' => 'Ludzas', 'country_code' => 'LV'],
            ['name' => 'Madonas', 'country_code' => 'LV'],
            ['name' => 'Ogres', 'country_code' => 'LV'],
            ['name' => 'Preilu', 'country_code' => 'LV'],
            ['name' => 'Rezekne', 'country_code' => 'LV'],
            ['name' => 'Rezeknes', 'country_code' => 'LV'],
            ['name' => 'Riga', 'country_code' => 'LV'],
            ['name' => 'Rigas', 'country_code' => 'LV'],
            ['name' => 'Saldus', 'country_code' => 'LV'],
            ['name' => 'Talsu', 'country_code' => 'LV'],
            ['name' => 'Tukuma', 'country_code' => 'LV'],
            ['name' => 'Valkas', 'country_code' => 'LV'],
            ['name' => 'Valmieras', 'country_code' => 'LV'],
            ['name' => 'Ventspils', 'country_code' => 'LV'],
            ['name' => 'Ventspils City', 'country_code' => 'LV'],
            ['name' => 'Beirut', 'country_code' => 'LB'],
            ['name' => 'Jabal Lubnan', 'country_code' => 'LB'],
            ['name' => 'Mohafazat Liban-Nord', 'country_code' => 'LB'],
            ['name' => 'Mohafazat Mont-Liban', 'country_code' => 'LB'],
            ['name' => 'Sidon', 'country_code' => 'LB'],
            ['name' => 'al-Biqa', 'country_code' => 'LB'],
            ['name' => 'al-Janub', 'country_code' => 'LB'],
            ['name' => 'an-Nabatiyah', 'country_code' => 'LB'],
            ['name' => 'ash-Shamal', 'country_code' => 'LB'],
            ['name' => 'Berea', 'country_code' => 'LS'],
            ['name' => 'Butha-Buthe', 'country_code' => 'LS'],
            ['name' => 'Leribe', 'country_code' => 'LS'],
            ['name' => 'Mafeteng', 'country_code' => 'LS'],
            ['name' => 'Maseru', 'country_code' => 'LS'],
            ['name' => "Mohale's Hoek", 'country_code' => 'LS'],
            ['name' => 'Mokhotlong', 'country_code' => 'LS'],
            ['name' => "Qacha's Nek", 'country_code' => 'LS'],
            ['name' => 'Quthing', 'country_code' => 'LS'],
            ['name' => 'Thaba-Tseka', 'country_code' => 'LS'],
            ['name' => 'Bomi', 'country_code' => 'LR'],
            ['name' => 'Bong', 'country_code' => 'LR'],
            ['name' => 'Grand Bassa', 'country_code' => 'LR'],
            ['name' => 'Grand Cape Mount', 'country_code' => 'LR'],
            ['name' => 'Grand Gedeh', 'country_code' => 'LR'],
            ['name' => 'Loffa', 'country_code' => 'LR'],
            ['name' => 'Margibi', 'country_code' => 'LR'],
            ['name' => 'Maryland and Grand Kru', 'country_code' => 'LR'],
            ['name' => 'Montserrado', 'country_code' => 'LR'],
            ['name' => 'Nimba', 'country_code' => 'LR'],
            ['name' => 'Rivercess', 'country_code' => 'LR'],
            ['name' => 'Sinoe', 'country_code' => 'LR'],
            ['name' => 'Ajdabiya', 'country_code' => 'LY'],
            ['name' => 'Fezzan', 'country_code' => 'LY'],
            ['name' => 'Banghazi', 'country_code' => 'LY'],
            ['name' => 'Darnah', 'country_code' => 'LY'],
            ['name' => 'Ghadamis', 'country_code' => 'LY'],
            ['name' => 'Gharyan', 'country_code' => 'LY'],
            ['name' => 'Misratah', 'country_code' => 'LY'],
            ['name' => 'Murzuq', 'country_code' => 'LY'],
            ['name' => 'Sabha', 'country_code' => 'LY'],
            ['name' => 'Sawfajjin', 'country_code' => 'LY'],
            ['name' => 'Surt', 'country_code' => 'LY'],
            ['name' => 'Tarabulus', 'country_code' => 'LY'],
            ['name' => 'Tarhunah', 'country_code' => 'LY'],
            ['name' => 'Tripolitania', 'country_code' => 'LY'],
            ['name' => 'Tubruq', 'country_code' => 'LY'],
            ['name' => 'Yafran', 'country_code' => 'LY'],
            ['name' => 'Zlitan', 'country_code' => 'LY'],
            ['name' => "al-'Aziziyah", 'country_code' => 'LY'],
            ['name' => 'al-Fatih', 'country_code' => 'LY'],
            ['name' => 'al-Jabal al Akhdar', 'country_code' => 'LY'],
            ['name' => 'al-Jufrah', 'country_code' => 'LY'],
            ['name' => 'al-Khums', 'country_code' => 'LY'],
            ['name' => 'al-Kufrah', 'country_code' => 'LY'],
            ['name' => 'an-Nuqat al-Khams', 'country_code' => 'LY'],
            ['name' => "ash-Shati'", 'country_code' => 'LY'],
            ['name' => 'az-Zawiyah', 'country_code' => 'LY'],
            ['name' => 'Balzers', 'country_code' => 'LI'],
            ['name' => 'Eschen', 'country_code' => 'LI'],
            ['name' => 'Gamprin', 'country_code' => 'LI'],
            ['name' => 'Mauren', 'country_code' => 'LI'],
            ['name' => 'Planken', 'country_code' => 'LI'],
            ['name' => 'Ruggell', 'country_code' => 'LI'],
            ['name' => 'Schaan', 'country_code' => 'LI'],
            ['name' => 'Schellenberg', 'country_code' => 'LI'],
            ['name' => 'Triesen', 'country_code' => 'LI'],
            ['name' => 'Triesenberg', 'country_code' => 'LI'],
            ['name' => 'Vaduz', 'country_code' => 'LI'],
            ['name' => 'Alytaus', 'country_code' => 'LT'],
            ['name' => 'Anyksciai', 'country_code' => 'LT'],
            ['name' => 'Kauno', 'country_code' => 'LT'],
            ['name' => 'Klaipedos', 'country_code' => 'LT'],
            ['name' => 'Marijampoles', 'country_code' => 'LT'],
            ['name' => 'Panevezhio', 'country_code' => 'LT'],
            ['name' => 'Panevezys', 'country_code' => 'LT'],
            ['name' => 'Shiauliu', 'country_code' => 'LT'],
            ['name' => 'Taurages', 'country_code' => 'LT'],
            ['name' => 'Telshiu', 'country_code' => 'LT'],
            ['name' => 'Telsiai', 'country_code' => 'LT'],
            ['name' => 'Utenos', 'country_code' => 'LT'],
            ['name' => 'Vilniaus', 'country_code' => 'LT'],
            ['name' => 'Capellen', 'country_code' => 'LU'],
            ['name' => 'Clervaux', 'country_code' => 'LU'],
            ['name' => 'Diekirch', 'country_code' => 'LU'],
            ['name' => 'Echternach', 'country_code' => 'LU'],
            ['name' => 'Esch-sur-Alzette', 'country_code' => 'LU'],
            ['name' => 'Grevenmacher', 'country_code' => 'LU'],
            ['name' => 'Luxembourg', 'country_code' => 'LU'],
            ['name' => 'Mersch', 'country_code' => 'LU'],
            ['name' => 'Redange', 'country_code' => 'LU'],
            ['name' => 'Remich', 'country_code' => 'LU'],
            ['name' => 'Vianden', 'country_code' => 'LU'],
            ['name' => 'Wiltz', 'country_code' => 'LU'],
            ['name' => 'Macau', 'country_code' => 'MO'],
            ['name' => 'Berovo', 'country_code' => 'MK'],
            ['name' => 'Bitola', 'country_code' => 'MK'],
            ['name' => 'Brod', 'country_code' => 'MK'],
            ['name' => 'Debar', 'country_code' => 'MK'],
            ['name' => 'Delchevo', 'country_code' => 'MK'],
            ['name' => 'Demir Hisar', 'country_code' => 'MK'],
            ['name' => 'Gevgelija', 'country_code' => 'MK'],
            ['name' => 'Gostivar', 'country_code' => 'MK'],
            ['name' => 'Kavadarci', 'country_code' => 'MK'],
            ['name' => 'Kichevo', 'country_code' => 'MK'],
            ['name' => 'Kochani', 'country_code' => 'MK'],
            ['name' => 'Kratovo', 'country_code' => 'MK'],
            ['name' => 'Kriva Palanka', 'country_code' => 'MK'],
            ['name' => 'Krushevo', 'country_code' => 'MK'],
            ['name' => 'Kumanovo', 'country_code' => 'MK'],
            ['name' => 'Negotino', 'country_code' => 'MK'],
            ['name' => 'Ohrid', 'country_code' => 'MK'],
            ['name' => 'Prilep', 'country_code' => 'MK'],
            ['name' => 'Probishtip', 'country_code' => 'MK'],
            ['name' => 'Radovish', 'country_code' => 'MK'],
            ['name' => 'Resen', 'country_code' => 'MK'],
            ['name' => 'Shtip', 'country_code' => 'MK'],
            ['name' => 'Skopje', 'country_code' => 'MK'],
            ['name' => 'Struga', 'country_code' => 'MK'],
            ['name' => 'Strumica', 'country_code' => 'MK'],
            ['name' => 'Sveti Nikole', 'country_code' => 'MK'],
            ['name' => 'Tetovo', 'country_code' => 'MK'],
            ['name' => 'Valandovo', 'country_code' => 'MK'],
            ['name' => 'Veles', 'country_code' => 'MK'],
            ['name' => 'Vinica', 'country_code' => 'MK'],
            ['name' => 'Antananarivo', 'country_code' => 'MG'],
            ['name' => 'Antsiranana', 'country_code' => 'MG'],
            ['name' => 'Fianarantsoa', 'country_code' => 'MG'],
            ['name' => 'Mahajanga', 'country_code' => 'MG'],
            ['name' => 'Toamasina', 'country_code' => 'MG'],
            ['name' => 'Toliary', 'country_code' => 'MG'],
            ['name' => 'Balaka', 'country_code' => 'MW'],
            ['name' => 'Blantyre City', 'country_code' => 'MW'],
            ['name' => 'Chikwawa', 'country_code' => 'MW'],
            ['name' => 'Chiradzulu', 'country_code' => 'MW'],
            ['name' => 'Chitipa', 'country_code' => 'MW'],
            ['name' => 'Dedza', 'country_code' => 'MW'],
            ['name' => 'Dowa', 'country_code' => 'MW'],
            ['name' => 'Karonga', 'country_code' => 'MW'],
            ['name' => 'Kasungu', 'country_code' => 'MW'],
            ['name' => 'Lilongwe City', 'country_code' => 'MW'],
            ['name' => 'Machinga', 'country_code' => 'MW'],
            ['name' => 'Mangochi', 'country_code' => 'MW'],
            ['name' => 'Mchinji', 'country_code' => 'MW'],
            ['name' => 'Mulanje', 'country_code' => 'MW'],
            ['name' => 'Mwanza', 'country_code' => 'MW'],
            ['name' => 'Mzimba', 'country_code' => 'MW'],
            ['name' => 'Mzuzu City', 'country_code' => 'MW'],
            ['name' => 'Nkhata Bay', 'country_code' => 'MW'],
            ['name' => 'Nkhotakota', 'country_code' => 'MW'],
            ['name' => 'Nsanje', 'country_code' => 'MW'],
            ['name' => 'Ntcheu', 'country_code' => 'MW'],
            ['name' => 'Ntchisi', 'country_code' => 'MW'],
            ['name' => 'Phalombe', 'country_code' => 'MW'],
            ['name' => 'Rumphi', 'country_code' => 'MW'],
            ['name' => 'Salima', 'country_code' => 'MW'],
            ['name' => 'Thyolo', 'country_code' => 'MW'],
            ['name' => 'Zomba Municipality', 'country_code' => 'MW'],
            ['name' => 'Johor', 'country_code' => 'MY'],
            ['name' => 'Kedah', 'country_code' => 'MY'],
            ['name' => 'Kelantan', 'country_code' => 'MY'],
            ['name' => 'Kuala Lumpur', 'country_code' => 'MY'],
            ['name' => 'Labuan', 'country_code' => 'MY'],
            ['name' => 'Melaka', 'country_code' => 'MY'],
            ['name' => 'Negeri Johor', 'country_code' => 'MY'],
            ['name' => 'Negeri Sembilan', 'country_code' => 'MY'],
            ['name' => 'Pahang', 'country_code' => 'MY'],
            ['name' => 'Penang', 'country_code' => 'MY'],
            ['name' => 'Perak', 'country_code' => 'MY'],
            ['name' => 'Perlis', 'country_code' => 'MY'],
            ['name' => 'Pulau Pinang', 'country_code' => 'MY'],
            ['name' => 'Sabah', 'country_code' => 'MY'],
            ['name' => 'Sarawak', 'country_code' => 'MY'],
            ['name' => 'Selangor', 'country_code' => 'MY'],
            ['name' => 'Sembilan', 'country_code' => 'MY'],
            ['name' => 'Terengganu', 'country_code' => 'MY'],
            ['name' => 'Alif Alif', 'country_code' => 'MV'],
            ['name' => 'Alif Dhaal', 'country_code' => 'MV'],
            ['name' => 'Baa', 'country_code' => 'MV'],
            ['name' => 'Dhaal', 'country_code' => 'MV'],
            ['name' => 'Faaf', 'country_code' => 'MV'],
            ['name' => 'Gaaf Alif', 'country_code' => 'MV'],
            ['name' => 'Gaaf Dhaal', 'country_code' => 'MV'],
            ['name' => 'Ghaviyani', 'country_code' => 'MV'],
            ['name' => 'Haa Alif', 'country_code' => 'MV'],
            ['name' => 'Haa Dhaal', 'country_code' => 'MV'],
            ['name' => 'Kaaf', 'country_code' => 'MV'],
            ['name' => 'Laam', 'country_code' => 'MV'],
            ['name' => 'Lhaviyani', 'country_code' => 'MV'],
            ['name' => 'Male', 'country_code' => 'MV'],
            ['name' => 'Miim', 'country_code' => 'MV'],
            ['name' => 'Nuun', 'country_code' => 'MV'],
            ['name' => 'Raa', 'country_code' => 'MV'],
            ['name' => 'Shaviyani', 'country_code' => 'MV'],
            ['name' => 'Siin', 'country_code' => 'MV'],
            ['name' => 'Thaa', 'country_code' => 'MV'],
            ['name' => 'Vaav', 'country_code' => 'MV'],
            ['name' => 'Bamako', 'country_code' => 'ML'],
            ['name' => 'Gao', 'country_code' => 'ML'],
            ['name' => 'Kayes', 'country_code' => 'ML'],
            ['name' => 'Kidal', 'country_code' => 'ML'],
            ['name' => 'Koulikoro', 'country_code' => 'ML'],
            ['name' => 'Mopti', 'country_code' => 'ML'],
            ['name' => 'Segou', 'country_code' => 'ML'],
            ['name' => 'Sikasso', 'country_code' => 'ML'],
            ['name' => 'Tombouctou', 'country_code' => 'ML'],
            ['name' => 'Gozo and Comino', 'country_code' => 'MT'],
            ['name' => 'Inner Harbour', 'country_code' => 'MT'],
            ['name' => 'Northern', 'country_code' => 'MT'],
            ['name' => 'Outer Harbour', 'country_code' => 'MT'],
            ['name' => 'South Eastern', 'country_code' => 'MT'],
            ['name' => 'Valletta', 'country_code' => 'MT'],
            ['name' => 'Western', 'country_code' => 'MT'],
            ['name' => 'Castletown', 'country_code' => 'XM'],
            ['name' => 'Douglas', 'country_code' => 'XM'],
            ['name' => 'Laxey', 'country_code' => 'XM'],
            ['name' => 'Onchan', 'country_code' => 'XM'],
            ['name' => 'Peel', 'country_code' => 'XM'],
            ['name' => 'Port Erin', 'country_code' => 'XM'],
            ['name' => 'Port Saint Mary', 'country_code' => 'XM'],
            ['name' => 'Ramsey', 'country_code' => 'XM'],
            ['name' => 'Ailinlaplap', 'country_code' => 'MH'],
            ['name' => 'Ailuk', 'country_code' => 'MH'],
            ['name' => 'Arno', 'country_code' => 'MH'],
            ['name' => 'Aur', 'country_code' => 'MH'],
            ['name' => 'Bikini', 'country_code' => 'MH'],
            ['name' => 'Ebon', 'country_code' => 'MH'],
            ['name' => 'Enewetak', 'country_code' => 'MH'],
            ['name' => 'Jabat', 'country_code' => 'MH'],
            ['name' => 'Jaluit', 'country_code' => 'MH'],
            ['name' => 'Kili', 'country_code' => 'MH'],
            ['name' => 'Kwajalein', 'country_code' => 'MH'],
            ['name' => 'Lae', 'country_code' => 'MH'],
            ['name' => 'Lib', 'country_code' => 'MH'],
            ['name' => 'Likiep', 'country_code' => 'MH'],
            ['name' => 'Majuro', 'country_code' => 'MH'],
            ['name' => 'Maloelap', 'country_code' => 'MH'],
            ['name' => 'Mejit', 'country_code' => 'MH'],
            ['name' => 'Mili', 'country_code' => 'MH'],
            ['name' => 'Namorik', 'country_code' => 'MH'],
            ['name' => 'Namu', 'country_code' => 'MH'],
            ['name' => 'Rongelap', 'country_code' => 'MH'],
            ['name' => 'Ujae', 'country_code' => 'MH'],
            ['name' => 'Utrik', 'country_code' => 'MH'],
            ['name' => 'Wotho', 'country_code' => 'MH'],
            ['name' => 'Wotje', 'country_code' => 'MH'],
            ['name' => 'Fort-de-France', 'country_code' => 'MQ'],
            ['name' => 'La Trinite', 'country_code' => 'MQ'],
            ['name' => 'Le Marin', 'country_code' => 'MQ'],
            ['name' => 'Saint-Pierre', 'country_code' => 'MQ'],
            ['name' => 'Adrar', 'country_code' => 'MR'],
            ['name' => 'Assaba', 'country_code' => 'MR'],
            ['name' => 'Brakna', 'country_code' => 'MR'],
            ['name' => 'Dhakhlat Nawadibu', 'country_code' => 'MR'],
            ['name' => 'Hudh-al-Gharbi', 'country_code' => 'MR'],
            ['name' => 'Hudh-ash-Sharqi', 'country_code' => 'MR'],
            ['name' => 'Inshiri', 'country_code' => 'MR'],
            ['name' => 'Nawakshut', 'country_code' => 'MR'],
            ['name' => 'Qidimagha', 'country_code' => 'MR'],
            ['name' => 'Qurqul', 'country_code' => 'MR'],
            ['name' => 'Taqant', 'country_code' => 'MR'],
            ['name' => 'Tiris Zammur', 'country_code' => 'MR'],
            ['name' => 'Trarza', 'country_code' => 'MR'],
            ['name' => 'Black River', 'country_code' => 'MU'],
            ['name' => 'Eau Coulee', 'country_code' => 'MU'],
            ['name' => 'Flacq', 'country_code' => 'MU'],
            ['name' => 'Floreal', 'country_code' => 'MU'],
            ['name' => 'Grand Port', 'country_code' => 'MU'],
            ['name' => 'Moka', 'country_code' => 'MU'],
            ['name' => 'Pamplempousses', 'country_code' => 'MU'],
            ['name' => 'Plaines Wilhelm', 'country_code' => 'MU'],
            ['name' => 'Port Louis', 'country_code' => 'MU'],
            ['name' => 'Riviere du Rempart', 'country_code' => 'MU'],
            ['name' => 'Rodrigues', 'country_code' => 'MU'],
            ['name' => 'Rose Hill', 'country_code' => 'MU'],
            ['name' => 'Savanne', 'country_code' => 'MU'],
            ['name' => 'Mayotte', 'country_code' => 'YT'],
            ['name' => 'Pamanzi', 'country_code' => 'YT'],
            ['name' => 'Aguascalientes', 'country_code' => 'MX'],
            ['name' => 'Baja California', 'country_code' => 'MX'],
            ['name' => 'Baja California Sur', 'country_code' => 'MX'],
            ['name' => 'Campeche', 'country_code' => 'MX'],
            ['name' => 'Chiapas', 'country_code' => 'MX'],
            ['name' => 'Chihuahua', 'country_code' => 'MX'],
            ['name' => 'Coahuila', 'country_code' => 'MX'],
            ['name' => 'Colima', 'country_code' => 'MX'],
            ['name' => 'Distrito Federal', 'country_code' => 'MX'],
            ['name' => 'Durango', 'country_code' => 'MX'],
            ['name' => 'Estado de Mexico', 'country_code' => 'MX'],
            ['name' => 'Guanajuato', 'country_code' => 'MX'],
            ['name' => 'Guerrero', 'country_code' => 'MX'],
            ['name' => 'Hidalgo', 'country_code' => 'MX'],
            ['name' => 'Jalisco', 'country_code' => 'MX'],
            ['name' => 'Mexico', 'country_code' => 'MX'],
            ['name' => 'Michoacan', 'country_code' => 'MX'],
            ['name' => 'Morelos', 'country_code' => 'MX'],
            ['name' => 'Nayarit', 'country_code' => 'MX'],
            ['name' => 'Nuevo Leon', 'country_code' => 'MX'],
            ['name' => 'Oaxaca', 'country_code' => 'MX'],
            ['name' => 'Puebla', 'country_code' => 'MX'],
            ['name' => 'Queretaro', 'country_code' => 'MX'],
            ['name' => 'Quintana Roo', 'country_code' => 'MX'],
            ['name' => 'San Luis Potosi', 'country_code' => 'MX'],
            ['name' => 'Sinaloa', 'country_code' => 'MX'],
            ['name' => 'Sonora', 'country_code' => 'MX'],
            ['name' => 'Tabasco', 'country_code' => 'MX'],
            ['name' => 'Tamaulipas', 'country_code' => 'MX'],
            ['name' => 'Tlaxcala', 'country_code' => 'MX'],
            ['name' => 'Veracruz', 'country_code' => 'MX'],
            ['name' => 'Yucatan', 'country_code' => 'MX'],
            ['name' => 'Zacatecas', 'country_code' => 'MX'],
            ['name' => 'Chuuk', 'country_code' => 'FM'],
            ['name' => 'Kusaie', 'country_code' => 'FM'],
            ['name' => 'Pohnpei', 'country_code' => 'FM'],
            ['name' => 'Yap', 'country_code' => 'FM'],
            ['name' => 'Balti', 'country_code' => 'MD'],
            ['name' => 'Cahul', 'country_code' => 'MD'],
            ['name' => 'Chisinau', 'country_code' => 'MD'],
            ['name' => 'Chisinau Oras', 'country_code' => 'MD'],
            ['name' => 'Edinet', 'country_code' => 'MD'],
            ['name' => 'Gagauzia', 'country_code' => 'MD'],
            ['name' => 'Lapusna', 'country_code' => 'MD'],
            ['name' => 'Orhei', 'country_code' => 'MD'],
            ['name' => 'Soroca', 'country_code' => 'MD'],
            ['name' => 'Taraclia', 'country_code' => 'MD'],
            ['name' => 'Tighina', 'country_code' => 'MD'],
            ['name' => 'Transnistria', 'country_code' => 'MD'],
            ['name' => 'Ungheni', 'country_code' => 'MD'],
            ['name' => 'Fontvieille', 'country_code' => 'MC'],
            ['name' => 'La Condamine', 'country_code' => 'MC'],
            ['name' => 'Monaco-Ville', 'country_code' => 'MC'],
            ['name' => 'Monte Carlo', 'country_code' => 'MC'],
            ['name' => 'Arhangaj', 'country_code' => 'MN'],
            ['name' => 'Bajan-Olgij', 'country_code' => 'MN'],
            ['name' => 'Bajanhongor', 'country_code' => 'MN'],
            ['name' => 'Bulgan', 'country_code' => 'MN'],
            ['name' => 'Darhan-Uul', 'country_code' => 'MN'],
            ['name' => 'Dornod', 'country_code' => 'MN'],
            ['name' => 'Dornogovi', 'country_code' => 'MN'],
            ['name' => 'Dundgovi', 'country_code' => 'MN'],
            ['name' => 'Govi-Altaj', 'country_code' => 'MN'],
            ['name' => 'Govisumber', 'country_code' => 'MN'],
            ['name' => 'Hentij', 'country_code' => 'MN'],
            ['name' => 'Hovd', 'country_code' => 'MN'],
            ['name' => 'Hovsgol', 'country_code' => 'MN'],
            ['name' => 'Omnogovi', 'country_code' => 'MN'],
            ['name' => 'Orhon', 'country_code' => 'MN'],
            ['name' => 'Ovorhangaj', 'country_code' => 'MN'],
            ['name' => 'Selenge', 'country_code' => 'MN'],
            ['name' => 'Suhbaatar', 'country_code' => 'MN'],
            ['name' => 'Tov', 'country_code' => 'MN'],
            ['name' => 'Ulaanbaatar', 'country_code' => 'MN'],
            ['name' => 'Uvs', 'country_code' => 'MN'],
            ['name' => 'Zavhan', 'country_code' => 'MN'],
            ['name' => 'Montserrat', 'country_code' => 'MS'],
            ['name' => 'Agadir', 'country_code' => 'MA'],
            ['name' => 'Casablanca', 'country_code' => 'MA'],
            ['name' => 'Chaouia-Ouardigha', 'country_code' => 'MA'],
            ['name' => 'Doukkala-Abda', 'country_code' => 'MA'],
            ['name' => 'Fes-Boulemane', 'country_code' => 'MA'],
            ['name' => 'Gharb-Chrarda-Beni Hssen', 'country_code' => 'MA'],
            ['name' => 'Guelmim', 'country_code' => 'MA'],
            ['name' => 'Kenitra', 'country_code' => 'MA'],
            ['name' => 'Marrakech-Tensift-Al Haouz', 'country_code' => 'MA'],
            ['name' => 'Meknes-Tafilalet', 'country_code' => 'MA'],
            ['name' => 'Oriental', 'country_code' => 'MA'],
            ['name' => 'Oujda', 'country_code' => 'MA'],
            ['name' => 'Province de Tanger', 'country_code' => 'MA'],
            ['name' => 'Rabat-Sale-Zammour-Zaer', 'country_code' => 'MA'],
            ['name' => 'Sala Al Jadida', 'country_code' => 'MA'],
            ['name' => 'Settat', 'country_code' => 'MA'],
            ['name' => 'Souss Massa-Draa', 'country_code' => 'MA'],
            ['name' => 'Tadla-Azilal', 'country_code' => 'MA'],
            ['name' => 'Tangier-Tetouan', 'country_code' => 'MA'],
            ['name' => 'Taza-Al Hoceima-Taounate', 'country_code' => 'MA'],
            ['name' => 'Wilaya de Casablanca', 'country_code' => 'MA'],
            ['name' => 'Wilaya de Rabat-Sale', 'country_code' => 'MA'],
            ['name' => 'Cabo Delgado', 'country_code' => 'MZ'],
            ['name' => 'Gaza', 'country_code' => 'MZ'],
            ['name' => 'Inhambane', 'country_code' => 'MZ'],
            ['name' => 'Manica', 'country_code' => 'MZ'],
            ['name' => 'Maputo', 'country_code' => 'MZ'],
            ['name' => 'Maputo Provincia', 'country_code' => 'MZ'],
            ['name' => 'Nampula', 'country_code' => 'MZ'],
            ['name' => 'Niassa', 'country_code' => 'MZ'],
            ['name' => 'Sofala', 'country_code' => 'MZ'],
            ['name' => 'Tete', 'country_code' => 'MZ'],
            ['name' => 'Zambezia', 'country_code' => 'MZ'],
            ['name' => 'Ayeyarwady', 'country_code' => 'MM'],
            ['name' => 'Bago', 'country_code' => 'MM'],
            ['name' => 'Chin', 'country_code' => 'MM'],
            ['name' => 'Kachin', 'country_code' => 'MM'],
            ['name' => 'Kayah', 'country_code' => 'MM'],
            ['name' => 'Kayin', 'country_code' => 'MM'],
            ['name' => 'Magway', 'country_code' => 'MM'],
            ['name' => 'Mandalay', 'country_code' => 'MM'],
            ['name' => 'Mon', 'country_code' => 'MM'],
            ['name' => 'Nay Pyi Taw', 'country_code' => 'MM'],
            ['name' => 'Rakhine', 'country_code' => 'MM'],
            ['name' => 'Sagaing', 'country_code' => 'MM'],
            ['name' => 'Shan', 'country_code' => 'MM'],
            ['name' => 'Tanintharyi', 'country_code' => 'MM'],
            ['name' => 'Yangon', 'country_code' => 'MM'],
            ['name' => 'Caprivi', 'country_code' => 'NA'],
            ['name' => 'Erongo', 'country_code' => 'NA'],
            ['name' => 'Hardap', 'country_code' => 'NA'],
            ['name' => 'Karas', 'country_code' => 'NA'],
            ['name' => 'Kavango', 'country_code' => 'NA'],
            ['name' => 'Khomas', 'country_code' => 'NA'],
            ['name' => 'Kunene', 'country_code' => 'NA'],
            ['name' => 'Ohangwena', 'country_code' => 'NA'],
            ['name' => 'Omaheke', 'country_code' => 'NA'],
            ['name' => 'Omusati', 'country_code' => 'NA'],
            ['name' => 'Oshana', 'country_code' => 'NA'],
            ['name' => 'Oshikoto', 'country_code' => 'NA'],
            ['name' => 'Otjozondjupa', 'country_code' => 'NA'],
            ['name' => 'Yaren', 'country_code' => 'NR'],
            ['name' => 'Bagmati', 'country_code' => 'NP'],
            ['name' => 'Bheri', 'country_code' => 'NP'],
            ['name' => 'Dhawalagiri', 'country_code' => 'NP'],
            ['name' => 'Gandaki', 'country_code' => 'NP'],
            ['name' => 'Janakpur', 'country_code' => 'NP'],
            ['name' => 'Karnali', 'country_code' => 'NP'],
            ['name' => 'Koshi', 'country_code' => 'NP'],
            ['name' => 'Lumbini', 'country_code' => 'NP'],
            ['name' => 'Mahakali', 'country_code' => 'NP'],
            ['name' => 'Mechi', 'country_code' => 'NP'],
            ['name' => 'Narayani', 'country_code' => 'NP'],
            ['name' => 'Rapti', 'country_code' => 'NP'],
            ['name' => 'Sagarmatha', 'country_code' => 'NP'],
            ['name' => 'Seti', 'country_code' => 'NP'],
            ['name' => 'Bonaire', 'country_code' => 'AN'],
            ['name' => 'Curacao', 'country_code' => 'AN'],
            ['name' => 'Saba', 'country_code' => 'AN'],
            ['name' => 'Sint Eustatius', 'country_code' => 'AN'],
            ['name' => 'Sint Maarten', 'country_code' => 'AN'],
            ['name' => 'Amsterdam', 'country_code' => 'NL'],
            ['name' => 'Benelux', 'country_code' => 'NL'],
            ['name' => 'Drenthe', 'country_code' => 'NL'],
            ['name' => 'Flevoland', 'country_code' => 'NL'],
            ['name' => 'Friesland', 'country_code' => 'NL'],
            ['name' => 'Gelderland', 'country_code' => 'NL'],
            ['name' => 'Groningen', 'country_code' => 'NL'],
            ['name' => 'Limburg', 'country_code' => 'NL'],
            ['name' => 'Noord-Brabant', 'country_code' => 'NL'],
            ['name' => 'Noord-Holland', 'country_code' => 'NL'],
            ['name' => 'Overijssel', 'country_code' => 'NL'],
            ['name' => 'South Holland', 'country_code' => 'NL'],
            ['name' => 'Utrecht', 'country_code' => 'NL'],
            ['name' => 'Zeeland', 'country_code' => 'NL'],
            ['name' => 'Zuid-Holland', 'country_code' => 'NL'],
            ['name' => 'Iles', 'country_code' => 'NC'],
            ['name' => 'Nord', 'country_code' => 'NC'],
            ['name' => 'Sud', 'country_code' => 'NC'],
            ['name' => 'Area Outside Region', 'country_code' => 'NZ'],
            ['name' => 'Auckland', 'country_code' => 'NZ'],
            ['name' => 'Bay of Plenty', 'country_code' => 'NZ'],
            ['name' => 'Canterbury', 'country_code' => 'NZ'],
            ['name' => 'Christchurch', 'country_code' => 'NZ'],
            ['name' => 'Gisborne', 'country_code' => 'NZ'],
            ['name' => "Hawke's Bay", 'country_code' => 'NZ'],
            ['name' => 'Manawatu-Wanganui', 'country_code' => 'NZ'],
            ['name' => 'Marlborough', 'country_code' => 'NZ'],
            ['name' => 'Nelson', 'country_code' => 'NZ'],
            ['name' => 'Northland', 'country_code' => 'NZ'],
            ['name' => 'Otago', 'country_code' => 'NZ'],
            ['name' => 'Rodney', 'country_code' => 'NZ'],
            ['name' => 'Southland', 'country_code' => 'NZ'],
            ['name' => 'Taranaki', 'country_code' => 'NZ'],
            ['name' => 'Tasman', 'country_code' => 'NZ'],
            ['name' => 'Waikato', 'country_code' => 'NZ'],
            ['name' => 'Wellington', 'country_code' => 'NZ'],
            ['name' => 'West Coast', 'country_code' => 'NZ'],
            ['name' => 'Atlantico Norte', 'country_code' => 'NI'],
            ['name' => 'Atlantico Sur', 'country_code' => 'NI'],
            ['name' => 'Boaco', 'country_code' => 'NI'],
            ['name' => 'Carazo', 'country_code' => 'NI'],
            ['name' => 'Chinandega', 'country_code' => 'NI'],
            ['name' => 'Chontales', 'country_code' => 'NI'],
            ['name' => 'Esteli', 'country_code' => 'NI'],
            ['name' => 'Granada', 'country_code' => 'NI'],
            ['name' => 'Jinotega', 'country_code' => 'NI'],
            ['name' => 'Leon', 'country_code' => 'NI'],
            ['name' => 'Madriz', 'country_code' => 'NI'],
            ['name' => 'Managua', 'country_code' => 'NI'],
            ['name' => 'Masaya', 'country_code' => 'NI'],
            ['name' => 'Matagalpa', 'country_code' => 'NI'],
            ['name' => 'Nueva Segovia', 'country_code' => 'NI'],
            ['name' => 'Rio San Juan', 'country_code' => 'NI'],
            ['name' => 'Rivas', 'country_code' => 'NI'],
            ['name' => 'Agadez', 'country_code' => 'NE'],
            ['name' => 'Diffa', 'country_code' => 'NE'],
            ['name' => 'Dosso', 'country_code' => 'NE'],
            ['name' => 'Maradi', 'country_code' => 'NE'],
            ['name' => 'Niamey', 'country_code' => 'NE'],
            ['name' => 'Tahoua', 'country_code' => 'NE'],
            ['name' => 'Tillabery', 'country_code' => 'NE'],
            ['name' => 'Zinder', 'country_code' => 'NE'],
            ['name' => 'Abia', 'country_code' => 'NG'],
            ['name' => 'Abuja Federal Capital Territor', 'country_code' => 'NG'],
            ['name' => 'Adamawa', 'country_code' => 'NG'],
            ['name' => 'Akwa Ibom', 'country_code' => 'NG'],
            ['name' => 'Anambra', 'country_code' => 'NG'],
            ['name' => 'Bauchi', 'country_code' => 'NG'],
            ['name' => 'Bayelsa', 'country_code' => 'NG'],
            ['name' => 'Benue', 'country_code' => 'NG'],
            ['name' => 'Borno', 'country_code' => 'NG'],
            ['name' => 'Cross River', 'country_code' => 'NG'],
            ['name' => 'Delta', 'country_code' => 'NG'],
            ['name' => 'Ebonyi', 'country_code' => 'NG'],
            ['name' => 'Edo', 'country_code' => 'NG'],
            ['name' => 'Ekiti', 'country_code' => 'NG'],
            ['name' => 'Enugu', 'country_code' => 'NG'],
            ['name' => 'Gombe', 'country_code' => 'NG'],
            ['name' => 'Imo', 'country_code' => 'NG'],
            ['name' => 'Jigawa', 'country_code' => 'NG'],
            ['name' => 'Kaduna', 'country_code' => 'NG'],
            ['name' => 'Kano', 'country_code' => 'NG'],
            ['name' => 'Katsina', 'country_code' => 'NG'],
            ['name' => 'Kebbi', 'country_code' => 'NG'],
            ['name' => 'Kogi', 'country_code' => 'NG'],
            ['name' => 'Kwara', 'country_code' => 'NG'],
            ['name' => 'Lagos', 'country_code' => 'NG'],
            ['name' => 'Nassarawa', 'country_code' => 'NG'],
            ['name' => 'Niger', 'country_code' => 'NG'],
            ['name' => 'Ogun', 'country_code' => 'NG'],
            ['name' => 'Ondo', 'country_code' => 'NG'],
            ['name' => 'Osun', 'country_code' => 'NG'],
            ['name' => 'Oyo', 'country_code' => 'NG'],
            ['name' => 'Plateau', 'country_code' => 'NG'],
            ['name' => 'Rivers', 'country_code' => 'NG'],
            ['name' => 'Sokoto', 'country_code' => 'NG'],
            ['name' => 'Taraba', 'country_code' => 'NG'],
            ['name' => 'Yobe', 'country_code' => 'NG'],
            ['name' => 'Zamfara', 'country_code' => 'NG'],
            ['name' => 'Niue', 'country_code' => 'NU'],
            ['name' => 'Norfolk Island', 'country_code' => 'NF'],
            ['name' => 'Northern Islands', 'country_code' => 'MP'],
            ['name' => 'Rota', 'country_code' => 'MP'],
            ['name' => 'Saipan', 'country_code' => 'MP'],
            ['name' => 'Tinian', 'country_code' => 'MP'],
            ['name' => 'Akershus', 'country_code' => 'NO'],
            ['name' => 'Aust Agder', 'country_code' => 'NO'],
            ['name' => 'Bergen', 'country_code' => 'NO'],
            ['name' => 'Buskerud', 'country_code' => 'NO'],
            ['name' => 'Finnmark', 'country_code' => 'NO'],
            ['name' => 'Hedmark', 'country_code' => 'NO'],
            ['name' => 'Hordaland', 'country_code' => 'NO'],
            ['name' => 'Moere og Romsdal', 'country_code' => 'NO'],
            ['name' => 'Nord Trondelag', 'country_code' => 'NO'],
            ['name' => 'Nordland', 'country_code' => 'NO'],
            ['name' => 'Oestfold', 'country_code' => 'NO'],
            ['name' => 'Oppland', 'country_code' => 'NO'],
            ['name' => 'Oslo', 'country_code' => 'NO'],
            ['name' => 'Rogaland', 'country_code' => 'NO'],
            ['name' => 'Soer Troendelag', 'country_code' => 'NO'],
            ['name' => 'Sogn og Fjordane', 'country_code' => 'NO'],
            ['name' => 'Stavern', 'country_code' => 'NO'],
            ['name' => 'Sykkylven', 'country_code' => 'NO'],
            ['name' => 'Telemark', 'country_code' => 'NO'],
            ['name' => 'Troms', 'country_code' => 'NO'],
            ['name' => 'Vest Agder', 'country_code' => 'NO'],
            ['name' => 'Vestfold', 'country_code' => 'NO'],
            ['name' => "\u00c3\u0192\u00c2\u02dcstfold", 'country_code' => 'NO'],
            ['name' => 'Al Buraimi', 'country_code' => 'OM'],
            ['name' => 'Dhufar', 'country_code' => 'OM'],
            ['name' => 'Masqat', 'country_code' => 'OM'],
            ['name' => 'Musandam', 'country_code' => 'OM'],
            ['name' => 'Rusayl', 'country_code' => 'OM'],
            ['name' => 'Wadi Kabir', 'country_code' => 'OM'],
            ['name' => 'ad-Dakhiliyah', 'country_code' => 'OM'],
            ['name' => 'adh-Dhahirah', 'country_code' => 'OM'],
            ['name' => 'al-Batinah', 'country_code' => 'OM'],
            ['name' => 'ash-Sharqiyah', 'country_code' => 'OM'],
            ['name' => 'Azad kashmir', 'country_code' => 'PK'],
            ['name' => 'Balochistan', 'country_code' => 'PK'],
            ['name' => 'Fata', 'country_code' => 'PK'],
            ['name' => "Gilgit\u2013baltistan", 'country_code' => 'PK'],
            ['name' => 'Islamabad capital territory', 'country_code' => 'PK'],
            ['name' => 'Khyber Pakhtunkhwa', 'country_code' => 'PK'],
            ['name' => 'Punjab', 'country_code' => 'PK'],
            ['name' => 'Sindh', 'country_code' => 'PK'],
            ['name' => 'Aimeliik', 'country_code' => 'PW'],
            ['name' => 'Airai', 'country_code' => 'PW'],
            ['name' => 'Angaur', 'country_code' => 'PW'],
            ['name' => 'Hatobohei', 'country_code' => 'PW'],
            ['name' => 'Kayangel', 'country_code' => 'PW'],
            ['name' => 'Koror', 'country_code' => 'PW'],
            ['name' => 'Melekeok', 'country_code' => 'PW'],
            ['name' => 'Ngaraard', 'country_code' => 'PW'],
            ['name' => 'Ngardmau', 'country_code' => 'PW'],
            ['name' => 'Ngaremlengui', 'country_code' => 'PW'],
            ['name' => 'Ngatpang', 'country_code' => 'PW'],
            ['name' => 'Ngchesar', 'country_code' => 'PW'],
            ['name' => 'Ngerchelong', 'country_code' => 'PW'],
            ['name' => 'Ngiwal', 'country_code' => 'PW'],
            ['name' => 'Peleliu', 'country_code' => 'PW'],
            ['name' => 'Sonsorol', 'country_code' => 'PW'],
            ['name' => 'Ariha', 'country_code' => 'PS'],
            ['name' => 'Bayt Lahm', 'country_code' => 'PS'],
            ['name' => 'Bethlehem', 'country_code' => 'PS'],
            ['name' => 'Dayr-al-Balah', 'country_code' => 'PS'],
            ['name' => 'Ghazzah', 'country_code' => 'PS'],
            ['name' => 'Ghazzah ash-Shamaliyah', 'country_code' => 'PS'],
            ['name' => 'Janin', 'country_code' => 'PS'],
            ['name' => 'Khan Yunis', 'country_code' => 'PS'],
            ['name' => 'Nabulus', 'country_code' => 'PS'],
            ['name' => 'Qalqilyah', 'country_code' => 'PS'],
            ['name' => 'Rafah', 'country_code' => 'PS'],
            ['name' => 'Ram Allah wal-Birah', 'country_code' => 'PS'],
            ['name' => 'Salfit', 'country_code' => 'PS'],
            ['name' => 'Tubas', 'country_code' => 'PS'],
            ['name' => 'Tulkarm', 'country_code' => 'PS'],
            ['name' => 'al-Khalil', 'country_code' => 'PS'],
            ['name' => 'al-Quds', 'country_code' => 'PS'],
            ['name' => 'Bocas del Toro', 'country_code' => 'PA'],
            ['name' => 'Chiriqui', 'country_code' => 'PA'],
            ['name' => 'Cocle', 'country_code' => 'PA'],
            ['name' => 'Colon', 'country_code' => 'PA'],
            ['name' => 'Darien', 'country_code' => 'PA'],
            ['name' => 'Embera', 'country_code' => 'PA'],
            ['name' => 'Herrera', 'country_code' => 'PA'],
            ['name' => 'Kuna Yala', 'country_code' => 'PA'],
            ['name' => 'Los Santos', 'country_code' => 'PA'],
            ['name' => 'Ngobe Bugle', 'country_code' => 'PA'],
            ['name' => 'Panama', 'country_code' => 'PA'],
            ['name' => 'Veraguas', 'country_code' => 'PA'],
            ['name' => 'East New Britain', 'country_code' => 'PG'],
            ['name' => 'East Sepik', 'country_code' => 'PG'],
            ['name' => 'Eastern Highlands', 'country_code' => 'PG'],
            ['name' => 'Enga', 'country_code' => 'PG'],
            ['name' => 'Fly River', 'country_code' => 'PG'],
            ['name' => 'Gulf', 'country_code' => 'PG'],
            ['name' => 'Madang', 'country_code' => 'PG'],
            ['name' => 'Manus', 'country_code' => 'PG'],
            ['name' => 'Milne Bay', 'country_code' => 'PG'],
            ['name' => 'Morobe', 'country_code' => 'PG'],
            ['name' => 'National Capital District', 'country_code' => 'PG'],
            ['name' => 'New Ireland', 'country_code' => 'PG'],
            ['name' => 'North Solomons', 'country_code' => 'PG'],
            ['name' => 'Oro', 'country_code' => 'PG'],
            ['name' => 'Sandaun', 'country_code' => 'PG'],
            ['name' => 'Simbu', 'country_code' => 'PG'],
            ['name' => 'Southern Highlands', 'country_code' => 'PG'],
            ['name' => 'West New Britain', 'country_code' => 'PG'],
            ['name' => 'Western Highlands', 'country_code' => 'PG'],
            ['name' => 'Alto Paraguay', 'country_code' => 'PY'],
            ['name' => 'Alto Parana', 'country_code' => 'PY'],
            ['name' => 'Amambay', 'country_code' => 'PY'],
            ['name' => 'Asuncion', 'country_code' => 'PY'],
            ['name' => 'Boqueron', 'country_code' => 'PY'],
            ['name' => 'Caaguazu', 'country_code' => 'PY'],
            ['name' => 'Caazapa', 'country_code' => 'PY'],
            ['name' => 'Canendiyu', 'country_code' => 'PY'],
            ['name' => 'Central', 'country_code' => 'PY'],
            ['name' => 'Concepcion', 'country_code' => 'PY'],
            ['name' => 'Cordillera', 'country_code' => 'PY'],
            ['name' => 'Guaira', 'country_code' => 'PY'],
            ['name' => 'Itapua', 'country_code' => 'PY'],
            ['name' => 'Misiones', 'country_code' => 'PY'],
            ['name' => 'Neembucu', 'country_code' => 'PY'],
            ['name' => 'Paraguari', 'country_code' => 'PY'],
            ['name' => 'Presidente Hayes', 'country_code' => 'PY'],
            ['name' => 'San Pedro', 'country_code' => 'PY'],
            ['name' => 'Amazonas', 'country_code' => 'PE'],
            ['name' => 'Ancash', 'country_code' => 'PE'],
            ['name' => 'Apurimac', 'country_code' => 'PE'],
            ['name' => 'Arequipa', 'country_code' => 'PE'],
            ['name' => 'Ayacucho', 'country_code' => 'PE'],
            ['name' => 'Cajamarca', 'country_code' => 'PE'],
            ['name' => 'Cusco', 'country_code' => 'PE'],
            ['name' => 'Huancavelica', 'country_code' => 'PE'],
            ['name' => 'Huanuco', 'country_code' => 'PE'],
            ['name' => 'Ica', 'country_code' => 'PE'],
            ['name' => 'Junin', 'country_code' => 'PE'],
            ['name' => 'La Libertad', 'country_code' => 'PE'],
            ['name' => 'Lambayeque', 'country_code' => 'PE'],
            ['name' => 'Lima y Callao', 'country_code' => 'PE'],
            ['name' => 'Loreto', 'country_code' => 'PE'],
            ['name' => 'Madre de Dios', 'country_code' => 'PE'],
            ['name' => 'Moquegua', 'country_code' => 'PE'],
            ['name' => 'Pasco', 'country_code' => 'PE'],
            ['name' => 'Piura', 'country_code' => 'PE'],
            ['name' => 'Puno', 'country_code' => 'PE'],
            ['name' => 'San Martin', 'country_code' => 'PE'],
            ['name' => 'Tacna', 'country_code' => 'PE'],
            ['name' => 'Tumbes', 'country_code' => 'PE'],
            ['name' => 'Ucayali', 'country_code' => 'PE'],
            ['name' => 'Batangas', 'country_code' => 'PH'],
            ['name' => 'Bicol', 'country_code' => 'PH'],
            ['name' => 'Bulacan', 'country_code' => 'PH'],
            ['name' => 'Cagayan', 'country_code' => 'PH'],
            ['name' => 'Caraga', 'country_code' => 'PH'],
            ['name' => 'Central Luzon', 'country_code' => 'PH'],
            ['name' => 'Central Mindanao', 'country_code' => 'PH'],
            ['name' => 'Central Visayas', 'country_code' => 'PH'],
            ['name' => 'Cordillera', 'country_code' => 'PH'],
            ['name' => 'Davao', 'country_code' => 'PH'],
            ['name' => 'Eastern Visayas', 'country_code' => 'PH'],
            ['name' => 'Greater Metropolitan Area', 'country_code' => 'PH'],
            ['name' => 'Ilocos', 'country_code' => 'PH'],
            ['name' => 'Laguna', 'country_code' => 'PH'],
            ['name' => 'Luzon', 'country_code' => 'PH'],
            ['name' => 'Mactan', 'country_code' => 'PH'],
            ['name' => 'Metropolitan Manila Area', 'country_code' => 'PH'],
            ['name' => 'Muslim Mindanao', 'country_code' => 'PH'],
            ['name' => 'Northern Mindanao', 'country_code' => 'PH'],
            ['name' => 'Southern Mindanao', 'country_code' => 'PH'],
            ['name' => 'Southern Tagalog', 'country_code' => 'PH'],
            ['name' => 'Western Mindanao', 'country_code' => 'PH'],
            ['name' => 'Western Visayas', 'country_code' => 'PH'],
            ['name' => 'Pitcairn Island', 'country_code' => 'PN'],
            ['name' => 'Biale Blota', 'country_code' => 'PL'],
            ['name' => 'Dobroszyce', 'country_code' => 'PL'],
            ['name' => 'Dolnoslaskie', 'country_code' => 'PL'],
            ['name' => 'Dziekanow Lesny', 'country_code' => 'PL'],
            ['name' => 'Hopowo', 'country_code' => 'PL'],
            ['name' => 'Kartuzy', 'country_code' => 'PL'],
            ['name' => 'Koscian', 'country_code' => 'PL'],
            ['name' => 'Krakow', 'country_code' => 'PL'],
            ['name' => 'Kujawsko-Pomorskie', 'country_code' => 'PL'],
            ['name' => 'Lodzkie', 'country_code' => 'PL'],
            ['name' => 'Lubelskie', 'country_code' => 'PL'],
            ['name' => 'Lubuskie', 'country_code' => 'PL'],
            ['name' => 'Malomice', 'country_code' => 'PL'],
            ['name' => 'Malopolskie', 'country_code' => 'PL'],
            ['name' => 'Mazowieckie', 'country_code' => 'PL'],
            ['name' => 'Mirkow', 'country_code' => 'PL'],
            ['name' => 'Opolskie', 'country_code' => 'PL'],
            ['name' => 'Ostrowiec', 'country_code' => 'PL'],
            ['name' => 'Podkarpackie', 'country_code' => 'PL'],
            ['name' => 'Podlaskie', 'country_code' => 'PL'],
            ['name' => 'Polska', 'country_code' => 'PL'],
            ['name' => 'Pomorskie', 'country_code' => 'PL'],
            ['name' => 'Poznan', 'country_code' => 'PL'],
            ['name' => 'Pruszkow', 'country_code' => 'PL'],
            ['name' => 'Rymanowska', 'country_code' => 'PL'],
            ['name' => 'Rzeszow', 'country_code' => 'PL'],
            ['name' => 'Slaskie', 'country_code' => 'PL'],
            ['name' => 'Stare Pole', 'country_code' => 'PL'],
            ['name' => 'Swietokrzyskie', 'country_code' => 'PL'],
            ['name' => 'Warminsko-Mazurskie', 'country_code' => 'PL'],
            ['name' => 'Warsaw', 'country_code' => 'PL'],
            ['name' => 'Wejherowo', 'country_code' => 'PL'],
            ['name' => 'Wielkopolskie', 'country_code' => 'PL'],
            ['name' => 'Wroclaw', 'country_code' => 'PL'],
            ['name' => 'Zachodnio-Pomorskie', 'country_code' => 'PL'],
            ['name' => 'Zukowo', 'country_code' => 'PL'],
            ['name' => 'Abrantes', 'country_code' => 'PT'],
            ['name' => 'Acores', 'country_code' => 'PT'],
            ['name' => 'Alentejo', 'country_code' => 'PT'],
            ['name' => 'Algarve', 'country_code' => 'PT'],
            ['name' => 'Braga', 'country_code' => 'PT'],
            ['name' => 'Centro', 'country_code' => 'PT'],
            ['name' => 'Distrito de Leiria', 'country_code' => 'PT'],
            ['name' => 'Distrito de Viana do Castelo', 'country_code' => 'PT'],
            ['name' => 'Distrito de Vila Real', 'country_code' => 'PT'],
            ['name' => 'Distrito do Porto', 'country_code' => 'PT'],
            ['name' => 'Lisboa e Vale do Tejo', 'country_code' => 'PT'],
            ['name' => 'Madeira', 'country_code' => 'PT'],
            ['name' => 'Norte', 'country_code' => 'PT'],
            ['name' => 'Paivas', 'country_code' => 'PT'],
            ['name' => 'Arecibo', 'country_code' => 'PR'],
            ['name' => 'Bayamon', 'country_code' => 'PR'],
            ['name' => 'Carolina', 'country_code' => 'PR'],
            ['name' => 'Florida', 'country_code' => 'PR'],
            ['name' => 'Guayama', 'country_code' => 'PR'],
            ['name' => 'Humacao', 'country_code' => 'PR'],
            ['name' => 'Mayaguez-Aguadilla', 'country_code' => 'PR'],
            ['name' => 'Ponce', 'country_code' => 'PR'],
            ['name' => 'Salinas', 'country_code' => 'PR'],
            ['name' => 'San Juan', 'country_code' => 'PR'],
            ['name' => 'Doha', 'country_code' => 'QA'],
            ['name' => 'Jarian-al-Batnah', 'country_code' => 'QA'],
            ['name' => 'Umm Salal', 'country_code' => 'QA'],
            ['name' => 'ad-Dawhah', 'country_code' => 'QA'],
            ['name' => 'al-Ghuwayriyah', 'country_code' => 'QA'],
            ['name' => 'al-Jumayliyah', 'country_code' => 'QA'],
            ['name' => 'al-Khawr', 'country_code' => 'QA'],
            ['name' => 'al-Wakrah', 'country_code' => 'QA'],
            ['name' => 'ar-Rayyan', 'country_code' => 'QA'],
            ['name' => 'ash-Shamal', 'country_code' => 'QA'],
            ['name' => 'Saint-Benoit', 'country_code' => 'RE'],
            ['name' => 'Saint-Denis', 'country_code' => 'RE'],
            ['name' => 'Saint-Paul', 'country_code' => 'RE'],
            ['name' => 'Saint-Pierre', 'country_code' => 'RE'],
            ['name' => 'Alba', 'country_code' => 'RO'],
            ['name' => 'Arad', 'country_code' => 'RO'],
            ['name' => 'Arges', 'country_code' => 'RO'],
            ['name' => 'Bacau', 'country_code' => 'RO'],
            ['name' => 'Bihor', 'country_code' => 'RO'],
            ['name' => 'Bistrita-Nasaud', 'country_code' => 'RO'],
            ['name' => 'Botosani', 'country_code' => 'RO'],
            ['name' => 'Braila', 'country_code' => 'RO'],
            ['name' => 'Brasov', 'country_code' => 'RO'],
            ['name' => 'Bucuresti', 'country_code' => 'RO'],
            ['name' => 'Buzau', 'country_code' => 'RO'],
            ['name' => 'Calarasi', 'country_code' => 'RO'],
            ['name' => 'Caras-Severin', 'country_code' => 'RO'],
            ['name' => 'Cluj', 'country_code' => 'RO'],
            ['name' => 'Constanta', 'country_code' => 'RO'],
            ['name' => 'Covasna', 'country_code' => 'RO'],
            ['name' => 'Dambovita', 'country_code' => 'RO'],
            ['name' => 'Dolj', 'country_code' => 'RO'],
            ['name' => 'Galati', 'country_code' => 'RO'],
            ['name' => 'Giurgiu', 'country_code' => 'RO'],
            ['name' => 'Gorj', 'country_code' => 'RO'],
            ['name' => 'Harghita', 'country_code' => 'RO'],
            ['name' => 'Hunedoara', 'country_code' => 'RO'],
            ['name' => 'Ialomita', 'country_code' => 'RO'],
            ['name' => 'Iasi', 'country_code' => 'RO'],
            ['name' => 'Ilfov', 'country_code' => 'RO'],
            ['name' => 'Maramures', 'country_code' => 'RO'],
            ['name' => 'Mehedinti', 'country_code' => 'RO'],
            ['name' => 'Mures', 'country_code' => 'RO'],
            ['name' => 'Neamt', 'country_code' => 'RO'],
            ['name' => 'Olt', 'country_code' => 'RO'],
            ['name' => 'Prahova', 'country_code' => 'RO'],
            ['name' => 'Salaj', 'country_code' => 'RO'],
            ['name' => 'Satu Mare', 'country_code' => 'RO'],
            ['name' => 'Sibiu', 'country_code' => 'RO'],
            ['name' => 'Sondelor', 'country_code' => 'RO'],
            ['name' => 'Suceava', 'country_code' => 'RO'],
            ['name' => 'Teleorman', 'country_code' => 'RO'],
            ['name' => 'Timis', 'country_code' => 'RO'],
            ['name' => 'Tulcea', 'country_code' => 'RO'],
            ['name' => 'Valcea', 'country_code' => 'RO'],
            ['name' => 'Vaslui', 'country_code' => 'RO'],
            ['name' => 'Vrancea', 'country_code' => 'RO'],
            ['name' => 'Adygeja', 'country_code' => 'RU'],
            ['name' => 'Aga', 'country_code' => 'RU'],
            ['name' => 'Alanija', 'country_code' => 'RU'],
            ['name' => 'Altaj', 'country_code' => 'RU'],
            ['name' => 'Amur', 'country_code' => 'RU'],
            ['name' => 'Arhangelsk', 'country_code' => 'RU'],
            ['name' => 'Astrahan', 'country_code' => 'RU'],
            ['name' => 'Bashkortostan', 'country_code' => 'RU'],
            ['name' => 'Belgorod', 'country_code' => 'RU'],
            ['name' => 'Brjansk', 'country_code' => 'RU'],
            ['name' => 'Burjatija', 'country_code' => 'RU'],
            ['name' => 'Chechenija', 'country_code' => 'RU'],
            ['name' => 'Cheljabinsk', 'country_code' => 'RU'],
            ['name' => 'Chita', 'country_code' => 'RU'],
            ['name' => 'Chukotka', 'country_code' => 'RU'],
            ['name' => 'Chuvashija', 'country_code' => 'RU'],
            ['name' => 'Dagestan', 'country_code' => 'RU'],
            ['name' => 'Evenkija', 'country_code' => 'RU'],
            ['name' => 'Gorno-Altaj', 'country_code' => 'RU'],
            ['name' => 'Habarovsk', 'country_code' => 'RU'],
            ['name' => 'Hakasija', 'country_code' => 'RU'],
            ['name' => 'Hanty-Mansija', 'country_code' => 'RU'],
            ['name' => 'Ingusetija', 'country_code' => 'RU'],
            ['name' => 'Irkutsk', 'country_code' => 'RU'],
            ['name' => 'Ivanovo', 'country_code' => 'RU'],
            ['name' => 'Jamalo-Nenets', 'country_code' => 'RU'],
            ['name' => 'Jaroslavl', 'country_code' => 'RU'],
            ['name' => 'Jevrej', 'country_code' => 'RU'],
            ['name' => 'Kabardino-Balkarija', 'country_code' => 'RU'],
            ['name' => 'Kaliningrad', 'country_code' => 'RU'],
            ['name' => 'Kalmykija', 'country_code' => 'RU'],
            ['name' => 'Kaluga', 'country_code' => 'RU'],
            ['name' => 'Kamchatka', 'country_code' => 'RU'],
            ['name' => 'Karachaj-Cherkessija', 'country_code' => 'RU'],
            ['name' => 'Karelija', 'country_code' => 'RU'],
            ['name' => 'Kemerovo', 'country_code' => 'RU'],
            ['name' => 'Khabarovskiy Kray', 'country_code' => 'RU'],
            ['name' => 'Kirov', 'country_code' => 'RU'],
            ['name' => 'Komi', 'country_code' => 'RU'],
            ['name' => 'Komi-Permjakija', 'country_code' => 'RU'],
            ['name' => 'Korjakija', 'country_code' => 'RU'],
            ['name' => 'Kostroma', 'country_code' => 'RU'],
            ['name' => 'Krasnodar', 'country_code' => 'RU'],
            ['name' => 'Krasnojarsk', 'country_code' => 'RU'],
            ['name' => 'Krasnoyarskiy Kray', 'country_code' => 'RU'],
            ['name' => 'Kurgan', 'country_code' => 'RU'],
            ['name' => 'Kursk', 'country_code' => 'RU'],
            ['name' => 'Leningrad', 'country_code' => 'RU'],
            ['name' => 'Lipeck', 'country_code' => 'RU'],
            ['name' => 'Magadan', 'country_code' => 'RU'],
            ['name' => 'Marij El', 'country_code' => 'RU'],
            ['name' => 'Mordovija', 'country_code' => 'RU'],
            ['name' => 'Moscow', 'country_code' => 'RU'],
            ['name' => 'Moskovskaja Oblast', 'country_code' => 'RU'],
            ['name' => 'Moskovskaya Oblast', 'country_code' => 'RU'],
            ['name' => 'Moskva', 'country_code' => 'RU'],
            ['name' => 'Murmansk', 'country_code' => 'RU'],
            ['name' => 'Nenets', 'country_code' => 'RU'],
            ['name' => 'Nizhnij Novgorod', 'country_code' => 'RU'],
            ['name' => 'Novgorod', 'country_code' => 'RU'],
            ['name' => 'Novokusnezk', 'country_code' => 'RU'],
            ['name' => 'Novosibirsk', 'country_code' => 'RU'],
            ['name' => 'Omsk', 'country_code' => 'RU'],
            ['name' => 'Orenburg', 'country_code' => 'RU'],
            ['name' => 'Orjol', 'country_code' => 'RU'],
            ['name' => 'Penza', 'country_code' => 'RU'],
            ['name' => 'Perm', 'country_code' => 'RU'],
            ['name' => 'Primorje', 'country_code' => 'RU'],
            ['name' => 'Pskov', 'country_code' => 'RU'],
            ['name' => 'Pskovskaya Oblast', 'country_code' => 'RU'],
            ['name' => 'Rjazan', 'country_code' => 'RU'],
            ['name' => 'Rostov', 'country_code' => 'RU'],
            ['name' => 'Saha', 'country_code' => 'RU'],
            ['name' => 'Sahalin', 'country_code' => 'RU'],
            ['name' => 'Samara', 'country_code' => 'RU'],
            ['name' => 'Samarskaya', 'country_code' => 'RU'],
            ['name' => 'Sankt-Peterburg', 'country_code' => 'RU'],
            ['name' => 'Saratov', 'country_code' => 'RU'],
            ['name' => 'Smolensk', 'country_code' => 'RU'],
            ['name' => 'Stavropol', 'country_code' => 'RU'],
            ['name' => 'Sverdlovsk', 'country_code' => 'RU'],
            ['name' => 'Tajmyrija', 'country_code' => 'RU'],
            ['name' => 'Tambov', 'country_code' => 'RU'],
            ['name' => 'Tatarstan', 'country_code' => 'RU'],
            ['name' => 'Tjumen', 'country_code' => 'RU'],
            ['name' => 'Tomsk', 'country_code' => 'RU'],
            ['name' => 'Tula', 'country_code' => 'RU'],
            ['name' => 'Tver', 'country_code' => 'RU'],
            ['name' => 'Tyva', 'country_code' => 'RU'],
            ['name' => 'Udmurtija', 'country_code' => 'RU'],
            ['name' => 'Uljanovsk', 'country_code' => 'RU'],
            ['name' => 'Ulyanovskaya Oblast', 'country_code' => 'RU'],
            ['name' => 'Ust-Orda', 'country_code' => 'RU'],
            ['name' => 'Vladimir', 'country_code' => 'RU'],
            ['name' => 'Volgograd', 'country_code' => 'RU'],
            ['name' => 'Vologda', 'country_code' => 'RU'],
            ['name' => 'Voronezh', 'country_code' => 'RU'],
            ['name' => 'Butare', 'country_code' => 'RW'],
            ['name' => 'Byumba', 'country_code' => 'RW'],
            ['name' => 'Cyangugu', 'country_code' => 'RW'],
            ['name' => 'Gikongoro', 'country_code' => 'RW'],
            ['name' => 'Gisenyi', 'country_code' => 'RW'],
            ['name' => 'Gitarama', 'country_code' => 'RW'],
            ['name' => 'Kibungo', 'country_code' => 'RW'],
            ['name' => 'Kibuye', 'country_code' => 'RW'],
            ['name' => 'Kigali-ngali', 'country_code' => 'RW'],
            ['name' => 'Ruhengeri', 'country_code' => 'RW'],
            ['name' => 'Ascension', 'country_code' => 'SH'],
            ['name' => 'Gough Island', 'country_code' => 'SH'],
            ['name' => 'Saint Helena', 'country_code' => 'SH'],
            ['name' => 'Tristan da Cunha', 'country_code' => 'SH'],
            ['name' => 'Christ Church Nichola Town', 'country_code' => 'KN'],
            ['name' => 'Saint Anne Sandy Point', 'country_code' => 'KN'],
            ['name' => 'Saint George Basseterre', 'country_code' => 'KN'],
            ['name' => 'Saint George Gingerland', 'country_code' => 'KN'],
            ['name' => 'Saint James Windward', 'country_code' => 'KN'],
            ['name' => 'Saint John Capesterre', 'country_code' => 'KN'],
            ['name' => 'Saint John Figtree', 'country_code' => 'KN'],
            ['name' => 'Saint Mary Cayon', 'country_code' => 'KN'],
            ['name' => 'Saint Paul Capesterre', 'country_code' => 'KN'],
            ['name' => 'Saint Paul Charlestown', 'country_code' => 'KN'],
            ['name' => 'Saint Peter Basseterre', 'country_code' => 'KN'],
            ['name' => 'Saint Thomas Lowland', 'country_code' => 'KN'],
            ['name' => 'Saint Thomas Middle Island', 'country_code' => 'KN'],
            ['name' => 'Trinity Palmetto Point', 'country_code' => 'KN'],
            ['name' => 'Anse-la-Raye', 'country_code' => 'LC'],
            ['name' => 'Canaries', 'country_code' => 'LC'],
            ['name' => 'Castries', 'country_code' => 'LC'],
            ['name' => 'Choiseul', 'country_code' => 'LC'],
            ['name' => 'Dennery', 'country_code' => 'LC'],
            ['name' => 'Gros Inlet', 'country_code' => 'LC'],
            ['name' => 'Laborie', 'country_code' => 'LC'],
            ['name' => 'Micoud', 'country_code' => 'LC'],
            ['name' => 'Soufriere', 'country_code' => 'LC'],
            ['name' => 'Vieux Fort', 'country_code' => 'LC'],
            ['name' => 'Miquelon-Langlade', 'country_code' => 'PM'],
            ['name' => 'Saint-Pierre', 'country_code' => 'PM'],
            ['name' => 'Charlotte', 'country_code' => 'VC'],
            ['name' => 'Grenadines', 'country_code' => 'VC'],
            ['name' => 'Saint Andrew', 'country_code' => 'VC'],
            ['name' => 'Saint David', 'country_code' => 'VC'],
            ['name' => 'Saint George', 'country_code' => 'VC'],
            ['name' => 'Saint Patrick', 'country_code' => 'VC'],
            ['name' => "A'ana", 'country_code' => 'WS'],
            ['name' => 'Aiga-i-le-Tai', 'country_code' => 'WS'],
            ['name' => 'Atua', 'country_code' => 'WS'],
            ['name' => "Fa'asaleleaga", 'country_code' => 'WS'],
            ['name' => "Gaga'emauga", 'country_code' => 'WS'],
            ['name' => 'Gagaifomauga', 'country_code' => 'WS'],
            ['name' => 'Palauli', 'country_code' => 'WS'],
            ['name' => "Satupa'itea", 'country_code' => 'WS'],
            ['name' => 'Tuamasaga', 'country_code' => 'WS'],
            ['name' => "Va'a-o-Fonoti", 'country_code' => 'WS'],
            ['name' => 'Vaisigano', 'country_code' => 'WS'],
            ['name' => 'Acquaviva', 'country_code' => 'SM'],
            ['name' => 'Borgo Maggiore', 'country_code' => 'SM'],
            ['name' => 'Chiesanuova', 'country_code' => 'SM'],
            ['name' => 'Domagnano', 'country_code' => 'SM'],
            ['name' => 'Faetano', 'country_code' => 'SM'],
            ['name' => 'Fiorentino', 'country_code' => 'SM'],
            ['name' => 'Montegiardino', 'country_code' => 'SM'],
            ['name' => 'San Marino', 'country_code' => 'SM'],
            ['name' => 'Serravalle', 'country_code' => 'SM'],
            ['name' => 'Agua Grande', 'country_code' => 'ST'],
            ['name' => 'Cantagalo', 'country_code' => 'ST'],
            ['name' => 'Lemba', 'country_code' => 'ST'],
            ['name' => 'Lobata', 'country_code' => 'ST'],
            ['name' => 'Me-Zochi', 'country_code' => 'ST'],
            ['name' => 'Pague', 'country_code' => 'ST'],
            ['name' => 'Al Khobar', 'country_code' => 'SA'],
            ['name' => 'Aseer', 'country_code' => 'SA'],
            ['name' => 'Ash Sharqiyah', 'country_code' => 'SA'],
            ['name' => 'Asir', 'country_code' => 'SA'],
            ['name' => 'Central Province', 'country_code' => 'SA'],
            ['name' => 'Eastern Province', 'country_code' => 'SA'],
            ['name' => "Ha'il", 'country_code' => 'SA'],
            ['name' => 'Jawf', 'country_code' => 'SA'],
            ['name' => 'Jizan', 'country_code' => 'SA'],
            ['name' => 'Makkah', 'country_code' => 'SA'],
            ['name' => 'Najran', 'country_code' => 'SA'],
            ['name' => 'Qasim', 'country_code' => 'SA'],
            ['name' => 'Tabuk', 'country_code' => 'SA'],
            ['name' => 'Western Province', 'country_code' => 'SA'],
            ['name' => 'al-Bahah', 'country_code' => 'SA'],
            ['name' => 'al-Hudud-ash-Shamaliyah', 'country_code' => 'SA'],
            ['name' => 'al-Madinah', 'country_code' => 'SA'],
            ['name' => 'ar-Riyad', 'country_code' => 'SA'],
            ['name' => 'Dakar', 'country_code' => 'SN'],
            ['name' => 'Diourbel', 'country_code' => 'SN'],
            ['name' => 'Fatick', 'country_code' => 'SN'],
            ['name' => 'Kaolack', 'country_code' => 'SN'],
            ['name' => 'Kolda', 'country_code' => 'SN'],
            ['name' => 'Louga', 'country_code' => 'SN'],
            ['name' => 'Saint-Louis', 'country_code' => 'SN'],
            ['name' => 'Tambacounda', 'country_code' => 'SN'],
            ['name' => 'Thies', 'country_code' => 'SN'],
            ['name' => 'Ziguinchor', 'country_code' => 'SN'],
            ['name' => 'Central Serbia', 'country_code' => 'RS'],
            ['name' => 'Kosovo and Metohija', 'country_code' => 'RS'],
            ['name' => 'Vojvodina', 'country_code' => 'RS'],
            ['name' => 'Anse Boileau', 'country_code' => 'SC'],
            ['name' => 'Anse Royale', 'country_code' => 'SC'],
            ['name' => 'Cascade', 'country_code' => 'SC'],
            ['name' => 'Takamaka', 'country_code' => 'SC'],
            ['name' => 'Victoria', 'country_code' => 'SC'],
            ['name' => 'Eastern', 'country_code' => 'SL'],
            ['name' => 'Northern', 'country_code' => 'SL'],
            ['name' => 'Southern', 'country_code' => 'SL'],
            ['name' => 'Western', 'country_code' => 'SL'],
            ['name' => 'Singapore', 'country_code' => 'SG'],
            ['name' => 'Banskobystricky', 'country_code' => 'SK'],
            ['name' => 'Bratislavsky', 'country_code' => 'SK'],
            ['name' => 'Kosicky', 'country_code' => 'SK'],
            ['name' => 'Nitriansky', 'country_code' => 'SK'],
            ['name' => 'Presovsky', 'country_code' => 'SK'],
            ['name' => 'Trenciansky', 'country_code' => 'SK'],
            ['name' => 'Trnavsky', 'country_code' => 'SK'],
            ['name' => 'Zilinsky', 'country_code' => 'SK'],
            ['name' => 'Benedikt', 'country_code' => 'SI'],
            ['name' => 'Gorenjska', 'country_code' => 'SI'],
            ['name' => 'Gorishka', 'country_code' => 'SI'],
            ['name' => 'Jugovzhodna Slovenija', 'country_code' => 'SI'],
            ['name' => 'Koroshka', 'country_code' => 'SI'],
            ['name' => 'Notranjsko-krashka', 'country_code' => 'SI'],
            ['name' => 'Obalno-krashka', 'country_code' => 'SI'],
            ['name' => 'Obcina Domzale', 'country_code' => 'SI'],
            ['name' => 'Obcina Vitanje', 'country_code' => 'SI'],
            ['name' => 'Osrednjeslovenska', 'country_code' => 'SI'],
            ['name' => 'Podravska', 'country_code' => 'SI'],
            ['name' => 'Pomurska', 'country_code' => 'SI'],
            ['name' => 'Savinjska', 'country_code' => 'SI'],
            ['name' => 'Slovenian Littoral', 'country_code' => 'SI'],
            ['name' => 'Spodnjeposavska', 'country_code' => 'SI'],
            ['name' => 'Zasavska', 'country_code' => 'SI'],
            ['name' => 'Pitcairn', 'country_code' => 'XG'],
            ['name' => 'Central', 'country_code' => 'SB'],
            ['name' => 'Choiseul', 'country_code' => 'SB'],
            ['name' => 'Guadalcanal', 'country_code' => 'SB'],
            ['name' => 'Isabel', 'country_code' => 'SB'],
            ['name' => 'Makira and Ulawa', 'country_code' => 'SB'],
            ['name' => 'Malaita', 'country_code' => 'SB'],
            ['name' => 'Rennell and Bellona', 'country_code' => 'SB'],
            ['name' => 'Temotu', 'country_code' => 'SB'],
            ['name' => 'Western', 'country_code' => 'SB'],
            ['name' => 'Awdal', 'country_code' => 'SO'],
            ['name' => 'Bakol', 'country_code' => 'SO'],
            ['name' => 'Banadir', 'country_code' => 'SO'],
            ['name' => 'Bari', 'country_code' => 'SO'],
            ['name' => 'Bay', 'country_code' => 'SO'],
            ['name' => 'Galgudug', 'country_code' => 'SO'],
            ['name' => 'Gedo', 'country_code' => 'SO'],
            ['name' => 'Hiran', 'country_code' => 'SO'],
            ['name' => 'Jubbada Hose', 'country_code' => 'SO'],
            ['name' => 'Jubbadha Dexe', 'country_code' => 'SO'],
            ['name' => 'Mudug', 'country_code' => 'SO'],
            ['name' => 'Nugal', 'country_code' => 'SO'],
            ['name' => 'Sanag', 'country_code' => 'SO'],
            ['name' => 'Shabellaha Dhexe', 'country_code' => 'SO'],
            ['name' => 'Shabellaha Hose', 'country_code' => 'SO'],
            ['name' => 'Togdher', 'country_code' => 'SO'],
            ['name' => 'Woqoyi Galbed', 'country_code' => 'SO'],
            ['name' => 'Eastern Cape', 'country_code' => 'ZA'],
            ['name' => 'Free State', 'country_code' => 'ZA'],
            ['name' => 'Gauteng', 'country_code' => 'ZA'],
            ['name' => 'Kempton Park', 'country_code' => 'ZA'],
            ['name' => 'Kramerville', 'country_code' => 'ZA'],
            ['name' => 'KwaZulu Natal', 'country_code' => 'ZA'],
            ['name' => 'Limpopo', 'country_code' => 'ZA'],
            ['name' => 'Mpumalanga', 'country_code' => 'ZA'],
            ['name' => 'North West', 'country_code' => 'ZA'],
            ['name' => 'Northern Cape', 'country_code' => 'ZA'],
            ['name' => 'Parow', 'country_code' => 'ZA'],
            ['name' => 'Table View', 'country_code' => 'ZA'],
            ['name' => 'Umtentweni', 'country_code' => 'ZA'],
            ['name' => 'Western Cape', 'country_code' => 'ZA'],
            ['name' => 'South Georgia', 'country_code' => 'GS'],
            ['name' => 'Central Equatoria', 'country_code' => 'SS'],
            ['name' => 'A Coruna', 'country_code' => 'ES'],
            ['name' => 'Alacant', 'country_code' => 'ES'],
            ['name' => 'Alava', 'country_code' => 'ES'],
            ['name' => 'Albacete', 'country_code' => 'ES'],
            ['name' => 'Almeria', 'country_code' => 'ES'],
            ['name' => 'Andalucia', 'country_code' => 'ES'],
            ['name' => 'Asturias', 'country_code' => 'ES'],
            ['name' => 'Avila', 'country_code' => 'ES'],
            ['name' => 'Badajoz', 'country_code' => 'ES'],
            ['name' => 'Balears', 'country_code' => 'ES'],
            ['name' => 'Barcelona', 'country_code' => 'ES'],
            ['name' => 'Bertamirans', 'country_code' => 'ES'],
            ['name' => 'Biscay', 'country_code' => 'ES'],
            ['name' => 'Burgos', 'country_code' => 'ES'],
            ['name' => 'Caceres', 'country_code' => 'ES'],
            ['name' => 'Cadiz', 'country_code' => 'ES'],
            ['name' => 'Cantabria', 'country_code' => 'ES'],
            ['name' => 'Castello', 'country_code' => 'ES'],
            ['name' => 'Catalunya', 'country_code' => 'ES'],
            ['name' => 'Ceuta', 'country_code' => 'ES'],
            ['name' => 'Ciudad Real', 'country_code' => 'ES'],
            ['name' => 'Comunidad Autonoma de Canarias', 'country_code' => 'ES'],
            ['name' => 'Comunidad Autonoma de Cataluna', 'country_code' => 'ES'],
            ['name' => 'Comunidad Autonoma de Galicia', 'country_code' => 'ES'],
            ['name' => 'Comunidad Autonoma de las Isla', 'country_code' => 'ES'],
            ['name' => 'Comunidad Autonoma del Princip', 'country_code' => 'ES'],
            ['name' => 'Comunidad Valenciana', 'country_code' => 'ES'],
            ['name' => 'Cordoba', 'country_code' => 'ES'],
            ['name' => 'Cuenca', 'country_code' => 'ES'],
            ['name' => 'Gipuzkoa', 'country_code' => 'ES'],
            ['name' => 'Girona', 'country_code' => 'ES'],
            ['name' => 'Granada', 'country_code' => 'ES'],
            ['name' => 'Guadalajara', 'country_code' => 'ES'],
            ['name' => 'Guipuzcoa', 'country_code' => 'ES'],
            ['name' => 'Huelva', 'country_code' => 'ES'],
            ['name' => 'Huesca', 'country_code' => 'ES'],
            ['name' => 'Jaen', 'country_code' => 'ES'],
            ['name' => 'La Rioja', 'country_code' => 'ES'],
            ['name' => 'Las Palmas', 'country_code' => 'ES'],
            ['name' => 'Leon', 'country_code' => 'ES'],
            ['name' => 'Lerida', 'country_code' => 'ES'],
            ['name' => 'Lleida', 'country_code' => 'ES'],
            ['name' => 'Lugo', 'country_code' => 'ES'],
            ['name' => 'Madrid', 'country_code' => 'ES'],
            ['name' => 'Malaga', 'country_code' => 'ES'],
            ['name' => 'Melilla', 'country_code' => 'ES'],
            ['name' => 'Murcia', 'country_code' => 'ES'],
            ['name' => 'Navarra', 'country_code' => 'ES'],
            ['name' => 'Ourense', 'country_code' => 'ES'],
            ['name' => 'Pais Vasco', 'country_code' => 'ES'],
            ['name' => 'Palencia', 'country_code' => 'ES'],
            ['name' => 'Pontevedra', 'country_code' => 'ES'],
            ['name' => 'Salamanca', 'country_code' => 'ES'],
            ['name' => 'Santa Cruz de Tenerife', 'country_code' => 'ES'],
            ['name' => 'Segovia', 'country_code' => 'ES'],
            ['name' => 'Sevilla', 'country_code' => 'ES'],
            ['name' => 'Soria', 'country_code' => 'ES'],
            ['name' => 'Tarragona', 'country_code' => 'ES'],
            ['name' => 'Tenerife', 'country_code' => 'ES'],
            ['name' => 'Teruel', 'country_code' => 'ES'],
            ['name' => 'Toledo', 'country_code' => 'ES'],
            ['name' => 'Valencia', 'country_code' => 'ES'],
            ['name' => 'Valladolid', 'country_code' => 'ES'],
            ['name' => 'Vizcaya', 'country_code' => 'ES'],
            ['name' => 'Zamora', 'country_code' => 'ES'],
            ['name' => 'Zaragoza', 'country_code' => 'ES'],
            ['name' => 'Amparai', 'country_code' => 'LK'],
            ['name' => 'Anuradhapuraya', 'country_code' => 'LK'],
            ['name' => 'Badulla', 'country_code' => 'LK'],
            ['name' => 'Boralesgamuwa', 'country_code' => 'LK'],
            ['name' => 'Colombo', 'country_code' => 'LK'],
            ['name' => 'Galla', 'country_code' => 'LK'],
            ['name' => 'Gampaha', 'country_code' => 'LK'],
            ['name' => 'Hambantota', 'country_code' => 'LK'],
            ['name' => 'Kalatura', 'country_code' => 'LK'],
            ['name' => 'Kegalla', 'country_code' => 'LK'],
            ['name' => 'Kilinochchi', 'country_code' => 'LK'],
            ['name' => 'Kurunegala', 'country_code' => 'LK'],
            ['name' => 'Madakalpuwa', 'country_code' => 'LK'],
            ['name' => 'Maha Nuwara', 'country_code' => 'LK'],
            ['name' => 'Malwana', 'country_code' => 'LK'],
            ['name' => 'Mannarama', 'country_code' => 'LK'],
            ['name' => 'Matale', 'country_code' => 'LK'],
            ['name' => 'Matara', 'country_code' => 'LK'],
            ['name' => 'Monaragala', 'country_code' => 'LK'],
            ['name' => 'Mullaitivu', 'country_code' => 'LK'],
            ['name' => 'North Eastern Province', 'country_code' => 'LK'],
            ['name' => 'North Western Province', 'country_code' => 'LK'],
            ['name' => 'Nuwara Eliya', 'country_code' => 'LK'],
            ['name' => 'Polonnaruwa', 'country_code' => 'LK'],
            ['name' => 'Puttalama', 'country_code' => 'LK'],
            ['name' => 'Ratnapuraya', 'country_code' => 'LK'],
            ['name' => 'Southern Province', 'country_code' => 'LK'],
            ['name' => 'Tirikunamalaya', 'country_code' => 'LK'],
            ['name' => 'Tuscany', 'country_code' => 'LK'],
            ['name' => 'Vavuniyawa', 'country_code' => 'LK'],
            ['name' => 'Western Province', 'country_code' => 'LK'],
            ['name' => 'Yapanaya', 'country_code' => 'LK'],
            ['name' => 'kadawatha', 'country_code' => 'LK'],
            ['name' => "A'ali-an-Nil", 'country_code' => 'SD'],
            ['name' => 'Bahr-al-Jabal', 'country_code' => 'SD'],
            ['name' => 'Central Equatoria', 'country_code' => 'SD'],
            ['name' => 'Gharb Bahr-al-Ghazal', 'country_code' => 'SD'],
            ['name' => 'Gharb Darfur', 'country_code' => 'SD'],
            ['name' => 'Gharb Kurdufan', 'country_code' => 'SD'],
            ['name' => "Gharb-al-Istiwa'iyah", 'country_code' => 'SD'],
            ['name' => 'Janub Darfur', 'country_code' => 'SD'],
            ['name' => 'Janub Kurdufan', 'country_code' => 'SD'],
            ['name' => 'Junqali', 'country_code' => 'SD'],
            ['name' => 'Kassala', 'country_code' => 'SD'],
            ['name' => 'Nahr-an-Nil', 'country_code' => 'SD'],
            ['name' => 'Shamal Bahr-al-Ghazal', 'country_code' => 'SD'],
            ['name' => 'Shamal Darfur', 'country_code' => 'SD'],
            ['name' => 'Shamal Kurdufan', 'country_code' => 'SD'],
            ['name' => "Sharq-al-Istiwa'iyah", 'country_code' => 'SD'],
            ['name' => 'Sinnar', 'country_code' => 'SD'],
            ['name' => 'Warab', 'country_code' => 'SD'],
            ['name' => 'Wilayat al Khartum', 'country_code' => 'SD'],
            ['name' => 'al-Bahr-al-Ahmar', 'country_code' => 'SD'],
            ['name' => 'al-Buhayrat', 'country_code' => 'SD'],
            ['name' => 'al-Jazirah', 'country_code' => 'SD'],
            ['name' => 'al-Khartum', 'country_code' => 'SD'],
            ['name' => 'al-Qadarif', 'country_code' => 'SD'],
            ['name' => 'al-Wahdah', 'country_code' => 'SD'],
            ['name' => 'an-Nil-al-Abyad', 'country_code' => 'SD'],
            ['name' => 'an-Nil-al-Azraq', 'country_code' => 'SD'],
            ['name' => 'ash-Shamaliyah', 'country_code' => 'SD'],
            ['name' => 'Brokopondo', 'country_code' => 'SR'],
            ['name' => 'Commewijne', 'country_code' => 'SR'],
            ['name' => 'Coronie', 'country_code' => 'SR'],
            ['name' => 'Marowijne', 'country_code' => 'SR'],
            ['name' => 'Nickerie', 'country_code' => 'SR'],
            ['name' => 'Para', 'country_code' => 'SR'],
            ['name' => 'Paramaribo', 'country_code' => 'SR'],
            ['name' => 'Saramacca', 'country_code' => 'SR'],
            ['name' => 'Wanica', 'country_code' => 'SR'],
            ['name' => 'Svalbard', 'country_code' => 'SJ'],
            ['name' => 'Hhohho', 'country_code' => 'SZ'],
            ['name' => 'Lubombo', 'country_code' => 'SZ'],
            ['name' => 'Manzini', 'country_code' => 'SZ'],
            ['name' => 'Shiselweni', 'country_code' => 'SZ'],
            ['name' => 'Alvsborgs Lan', 'country_code' => 'SE'],
            ['name' => 'Angermanland', 'country_code' => 'SE'],
            ['name' => 'Blekinge', 'country_code' => 'SE'],
            ['name' => 'Bohuslan', 'country_code' => 'SE'],
            ['name' => 'Dalarna', 'country_code' => 'SE'],
            ['name' => 'Gavleborg', 'country_code' => 'SE'],
            ['name' => 'Gaza', 'country_code' => 'SE'],
            ['name' => 'Gotland', 'country_code' => 'SE'],
            ['name' => 'Halland', 'country_code' => 'SE'],
            ['name' => 'Jamtland', 'country_code' => 'SE'],
            ['name' => 'Jonkoping', 'country_code' => 'SE'],
            ['name' => 'Kalmar', 'country_code' => 'SE'],
            ['name' => 'Kristianstads', 'country_code' => 'SE'],
            ['name' => 'Kronoberg', 'country_code' => 'SE'],
            ['name' => 'Norrbotten', 'country_code' => 'SE'],
            ['name' => 'Orebro', 'country_code' => 'SE'],
            ['name' => 'Ostergotland', 'country_code' => 'SE'],
            ['name' => 'Saltsjo-Boo', 'country_code' => 'SE'],
            ['name' => 'Skane', 'country_code' => 'SE'],
            ['name' => 'Smaland', 'country_code' => 'SE'],
            ['name' => 'Sodermanland', 'country_code' => 'SE'],
            ['name' => 'Stockholm', 'country_code' => 'SE'],
            ['name' => 'Uppsala', 'country_code' => 'SE'],
            ['name' => 'Varmland', 'country_code' => 'SE'],
            ['name' => 'Vasterbotten', 'country_code' => 'SE'],
            ['name' => 'Vastergotland', 'country_code' => 'SE'],
            ['name' => 'Vasternorrland', 'country_code' => 'SE'],
            ['name' => 'Vastmanland', 'country_code' => 'SE'],
            ['name' => 'Vastra Gotaland', 'country_code' => 'SE'],
            ['name' => 'Aargau', 'country_code' => 'CH'],
            ['name' => 'Appenzell Inner-Rhoden', 'country_code' => 'CH'],
            ['name' => 'Appenzell-Ausser Rhoden', 'country_code' => 'CH'],
            ['name' => 'Basel-Landschaft', 'country_code' => 'CH'],
            ['name' => 'Basel-Stadt', 'country_code' => 'CH'],
            ['name' => 'Bern', 'country_code' => 'CH'],
            ['name' => 'Canton Ticino', 'country_code' => 'CH'],
            ['name' => 'Fribourg', 'country_code' => 'CH'],
            ['name' => 'Geneve', 'country_code' => 'CH'],
            ['name' => 'Glarus', 'country_code' => 'CH'],
            ['name' => 'Graubunden', 'country_code' => 'CH'],
            ['name' => 'Heerbrugg', 'country_code' => 'CH'],
            ['name' => 'Jura', 'country_code' => 'CH'],
            ['name' => 'Kanton Aargau', 'country_code' => 'CH'],
            ['name' => 'Luzern', 'country_code' => 'CH'],
            ['name' => 'Morbio Inferiore', 'country_code' => 'CH'],
            ['name' => 'Muhen', 'country_code' => 'CH'],
            ['name' => 'Neuchatel', 'country_code' => 'CH'],
            ['name' => 'Nidwalden', 'country_code' => 'CH'],
            ['name' => 'Obwalden', 'country_code' => 'CH'],
            ['name' => 'Sankt Gallen', 'country_code' => 'CH'],
            ['name' => 'Schaffhausen', 'country_code' => 'CH'],
            ['name' => 'Schwyz', 'country_code' => 'CH'],
            ['name' => 'Solothurn', 'country_code' => 'CH'],
            ['name' => 'Thurgau', 'country_code' => 'CH'],
            ['name' => 'Ticino', 'country_code' => 'CH'],
            ['name' => 'Uri', 'country_code' => 'CH'],
            ['name' => 'Valais', 'country_code' => 'CH'],
            ['name' => 'Vaud', 'country_code' => 'CH'],
            ['name' => 'Vauffelin', 'country_code' => 'CH'],
            ['name' => 'Zug', 'country_code' => 'CH'],
            ['name' => 'Zurich', 'country_code' => 'CH'],
            ['name' => 'Aleppo', 'country_code' => 'SY'],
            ['name' => "Dar'a", 'country_code' => 'SY'],
            ['name' => 'Dayr-az-Zawr', 'country_code' => 'SY'],
            ['name' => 'Dimashq', 'country_code' => 'SY'],
            ['name' => 'Halab', 'country_code' => 'SY'],
            ['name' => 'Hamah', 'country_code' => 'SY'],
            ['name' => 'Hims', 'country_code' => 'SY'],
            ['name' => 'Idlib', 'country_code' => 'SY'],
            ['name' => 'Madinat Dimashq', 'country_code' => 'SY'],
            ['name' => 'Tartus', 'country_code' => 'SY'],
            ['name' => 'al-Hasakah', 'country_code' => 'SY'],
            ['name' => 'al-Ladhiqiyah', 'country_code' => 'SY'],
            ['name' => 'al-Qunaytirah', 'country_code' => 'SY'],
            ['name' => 'ar-Raqqah', 'country_code' => 'SY'],
            ['name' => 'as-Suwayda', 'country_code' => 'SY'],
            ['name' => 'Changhwa', 'country_code' => 'TW'],
            ['name' => 'Chiayi Hsien', 'country_code' => 'TW'],
            ['name' => 'Chiayi Shih', 'country_code' => 'TW'],
            ['name' => 'Eastern Taipei', 'country_code' => 'TW'],
            ['name' => 'Hsinchu Hsien', 'country_code' => 'TW'],
            ['name' => 'Hsinchu Shih', 'country_code' => 'TW'],
            ['name' => 'Hualien', 'country_code' => 'TW'],
            ['name' => 'Ilan', 'country_code' => 'TW'],
            ['name' => 'Kaohsiung Hsien', 'country_code' => 'TW'],
            ['name' => 'Kaohsiung Shih', 'country_code' => 'TW'],
            ['name' => 'Keelung Shih', 'country_code' => 'TW'],
            ['name' => 'Kinmen', 'country_code' => 'TW'],
            ['name' => 'Miaoli', 'country_code' => 'TW'],
            ['name' => 'Nantou', 'country_code' => 'TW'],
            ['name' => 'Northern Taiwan', 'country_code' => 'TW'],
            ['name' => 'Penghu', 'country_code' => 'TW'],
            ['name' => 'Pingtung', 'country_code' => 'TW'],
            ['name' => 'Taichung', 'country_code' => 'TW'],
            ['name' => 'Taichung Hsien', 'country_code' => 'TW'],
            ['name' => 'Taichung Shih', 'country_code' => 'TW'],
            ['name' => 'Tainan Hsien', 'country_code' => 'TW'],
            ['name' => 'Tainan Shih', 'country_code' => 'TW'],
            ['name' => 'Taipei Hsien', 'country_code' => 'TW'],
            ['name' => "Taipei Shih \/ Taipei Hsien", 'country_code' => 'TW'],
            ['name' => 'Taitung', 'country_code' => 'TW'],
            ['name' => 'Taoyuan', 'country_code' => 'TW'],
            ['name' => 'Yilan', 'country_code' => 'TW'],
            ['name' => 'Yun-Lin Hsien', 'country_code' => 'TW'],
            ['name' => 'Yunlin', 'country_code' => 'TW'],
            ['name' => 'Dushanbe', 'country_code' => 'TJ'],
            ['name' => 'Gorno-Badakhshan', 'country_code' => 'TJ'],
            ['name' => 'Karotegin', 'country_code' => 'TJ'],
            ['name' => 'Khatlon', 'country_code' => 'TJ'],
            ['name' => 'Sughd', 'country_code' => 'TJ'],
            ['name' => 'Arusha', 'country_code' => 'TZ'],
            ['name' => 'Dar es Salaam', 'country_code' => 'TZ'],
            ['name' => 'Dodoma', 'country_code' => 'TZ'],
            ['name' => 'Iringa', 'country_code' => 'TZ'],
            ['name' => 'Kagera', 'country_code' => 'TZ'],
            ['name' => 'Kigoma', 'country_code' => 'TZ'],
            ['name' => 'Kilimanjaro', 'country_code' => 'TZ'],
            ['name' => 'Lindi', 'country_code' => 'TZ'],
            ['name' => 'Mara', 'country_code' => 'TZ'],
            ['name' => 'Mbeya', 'country_code' => 'TZ'],
            ['name' => 'Morogoro', 'country_code' => 'TZ'],
            ['name' => 'Mtwara', 'country_code' => 'TZ'],
            ['name' => 'Mwanza', 'country_code' => 'TZ'],
            ['name' => 'Pwani', 'country_code' => 'TZ'],
            ['name' => 'Rukwa', 'country_code' => 'TZ'],
            ['name' => 'Ruvuma', 'country_code' => 'TZ'],
            ['name' => 'Shinyanga', 'country_code' => 'TZ'],
            ['name' => 'Singida', 'country_code' => 'TZ'],
            ['name' => 'Tabora', 'country_code' => 'TZ'],
            ['name' => 'Tanga', 'country_code' => 'TZ'],
            ['name' => 'Zanzibar and Pemba', 'country_code' => 'TZ'],
            ['name' => 'Amnat Charoen', 'country_code' => 'TH'],
            ['name' => 'Ang Thong', 'country_code' => 'TH'],
            ['name' => 'Bangkok', 'country_code' => 'TH'],
            ['name' => 'Buri Ram', 'country_code' => 'TH'],
            ['name' => 'Chachoengsao', 'country_code' => 'TH'],
            ['name' => 'Chai Nat', 'country_code' => 'TH'],
            ['name' => 'Chaiyaphum', 'country_code' => 'TH'],
            ['name' => 'Changwat Chaiyaphum', 'country_code' => 'TH'],
            ['name' => 'Chanthaburi', 'country_code' => 'TH'],
            ['name' => 'Chiang Mai', 'country_code' => 'TH'],
            ['name' => 'Chiang Rai', 'country_code' => 'TH'],
            ['name' => 'Chon Buri', 'country_code' => 'TH'],
            ['name' => 'Chumphon', 'country_code' => 'TH'],
            ['name' => 'Kalasin', 'country_code' => 'TH'],
            ['name' => 'Kamphaeng Phet', 'country_code' => 'TH'],
            ['name' => 'Kanchanaburi', 'country_code' => 'TH'],
            ['name' => 'Khon Kaen', 'country_code' => 'TH'],
            ['name' => 'Krabi', 'country_code' => 'TH'],
            ['name' => 'Krung Thep', 'country_code' => 'TH'],
            ['name' => 'Lampang', 'country_code' => 'TH'],
            ['name' => 'Lamphun', 'country_code' => 'TH'],
            ['name' => 'Loei', 'country_code' => 'TH'],
            ['name' => 'Lop Buri', 'country_code' => 'TH'],
            ['name' => 'Mae Hong Son', 'country_code' => 'TH'],
            ['name' => 'Maha Sarakham', 'country_code' => 'TH'],
            ['name' => 'Mukdahan', 'country_code' => 'TH'],
            ['name' => 'Nakhon Nayok', 'country_code' => 'TH'],
            ['name' => 'Nakhon Pathom', 'country_code' => 'TH'],
            ['name' => 'Nakhon Phanom', 'country_code' => 'TH'],
            ['name' => 'Nakhon Ratchasima', 'country_code' => 'TH'],
            ['name' => 'Nakhon Sawan', 'country_code' => 'TH'],
            ['name' => 'Nakhon Si Thammarat', 'country_code' => 'TH'],
            ['name' => 'Nan', 'country_code' => 'TH'],
            ['name' => 'Narathiwat', 'country_code' => 'TH'],
            ['name' => 'Nong Bua Lam Phu', 'country_code' => 'TH'],
            ['name' => 'Nong Khai', 'country_code' => 'TH'],
            ['name' => 'Nonthaburi', 'country_code' => 'TH'],
            ['name' => 'Pathum Thani', 'country_code' => 'TH'],
            ['name' => 'Pattani', 'country_code' => 'TH'],
            ['name' => 'Phangnga', 'country_code' => 'TH'],
            ['name' => 'Phatthalung', 'country_code' => 'TH'],
            ['name' => 'Phayao', 'country_code' => 'TH'],
            ['name' => 'Phetchabun', 'country_code' => 'TH'],
            ['name' => 'Phetchaburi', 'country_code' => 'TH'],
            ['name' => 'Phichit', 'country_code' => 'TH'],
            ['name' => 'Phitsanulok', 'country_code' => 'TH'],
            ['name' => 'Phra Nakhon Si Ayutthaya', 'country_code' => 'TH'],
            ['name' => 'Phrae', 'country_code' => 'TH'],
            ['name' => 'Phuket', 'country_code' => 'TH'],
            ['name' => 'Prachin Buri', 'country_code' => 'TH'],
            ['name' => 'Prachuap Khiri Khan', 'country_code' => 'TH'],
            ['name' => 'Ranong', 'country_code' => 'TH'],
            ['name' => 'Ratchaburi', 'country_code' => 'TH'],
            ['name' => 'Rayong', 'country_code' => 'TH'],
            ['name' => 'Roi Et', 'country_code' => 'TH'],
            ['name' => 'Sa Kaeo', 'country_code' => 'TH'],
            ['name' => 'Sakon Nakhon', 'country_code' => 'TH'],
            ['name' => 'Samut Prakan', 'country_code' => 'TH'],
            ['name' => 'Samut Sakhon', 'country_code' => 'TH'],
            ['name' => 'Samut Songkhran', 'country_code' => 'TH'],
            ['name' => 'Saraburi', 'country_code' => 'TH'],
            ['name' => 'Satun', 'country_code' => 'TH'],
            ['name' => 'Si Sa Ket', 'country_code' => 'TH'],
            ['name' => 'Sing Buri', 'country_code' => 'TH'],
            ['name' => 'Songkhla', 'country_code' => 'TH'],
            ['name' => 'Sukhothai', 'country_code' => 'TH'],
            ['name' => 'Suphan Buri', 'country_code' => 'TH'],
            ['name' => 'Surat Thani', 'country_code' => 'TH'],
            ['name' => 'Surin', 'country_code' => 'TH'],
            ['name' => 'Tak', 'country_code' => 'TH'],
            ['name' => 'Trang', 'country_code' => 'TH'],
            ['name' => 'Trat', 'country_code' => 'TH'],
            ['name' => 'Ubon Ratchathani', 'country_code' => 'TH'],
            ['name' => 'Udon Thani', 'country_code' => 'TH'],
            ['name' => 'Uthai Thani', 'country_code' => 'TH'],
            ['name' => 'Uttaradit', 'country_code' => 'TH'],
            ['name' => 'Yala', 'country_code' => 'TH'],
            ['name' => 'Yasothon', 'country_code' => 'TH'],
            ['name' => 'Centre', 'country_code' => 'TG'],
            ['name' => 'Kara', 'country_code' => 'TG'],
            ['name' => 'Maritime', 'country_code' => 'TG'],
            ['name' => 'Plateaux', 'country_code' => 'TG'],
            ['name' => 'Savanes', 'country_code' => 'TG'],
            ['name' => 'Atafu', 'country_code' => 'TK'],
            ['name' => 'Fakaofo', 'country_code' => 'TK'],
            ['name' => 'Nukunonu', 'country_code' => 'TK'],
            ['name' => 'Eua', 'country_code' => 'TO'],
            ['name' => "Ha'apai", 'country_code' => 'TO'],
            ['name' => 'Niuas', 'country_code' => 'TO'],
            ['name' => 'Tongatapu', 'country_code' => 'TO'],
            ['name' => "Vava'u", 'country_code' => 'TO'],
            ['name' => 'Arima-Tunapuna-Piarco', 'country_code' => 'TT'],
            ['name' => 'Caroni', 'country_code' => 'TT'],
            ['name' => 'Chaguanas', 'country_code' => 'TT'],
            ['name' => 'Couva-Tabaquite-Talparo', 'country_code' => 'TT'],
            ['name' => 'Diego Martin', 'country_code' => 'TT'],
            ['name' => 'Glencoe', 'country_code' => 'TT'],
            ['name' => 'Penal Debe', 'country_code' => 'TT'],
            ['name' => 'Point Fortin', 'country_code' => 'TT'],
            ['name' => 'Port of Spain', 'country_code' => 'TT'],
            ['name' => 'Princes Town', 'country_code' => 'TT'],
            ['name' => 'Saint George', 'country_code' => 'TT'],
            ['name' => 'San Fernando', 'country_code' => 'TT'],
            ['name' => 'San Juan', 'country_code' => 'TT'],
            ['name' => 'Sangre Grande', 'country_code' => 'TT'],
            ['name' => 'Siparia', 'country_code' => 'TT'],
            ['name' => 'Tobago', 'country_code' => 'TT'],
            ['name' => 'Aryanah', 'country_code' => 'TN'],
            ['name' => 'Bajah', 'country_code' => 'TN'],
            ['name' => "Bin 'Arus", 'country_code' => 'TN'],
            ['name' => 'Binzart', 'country_code' => 'TN'],
            ['name' => 'Gouvernorat de Ariana', 'country_code' => 'TN'],
            ['name' => 'Gouvernorat de Nabeul', 'country_code' => 'TN'],
            ['name' => 'Gouvernorat de Sousse', 'country_code' => 'TN'],
            ['name' => 'Hammamet Yasmine', 'country_code' => 'TN'],
            ['name' => 'Jundubah', 'country_code' => 'TN'],
            ['name' => 'Madaniyin', 'country_code' => 'TN'],
            ['name' => 'Manubah', 'country_code' => 'TN'],
            ['name' => 'Monastir', 'country_code' => 'TN'],
            ['name' => 'Nabul', 'country_code' => 'TN'],
            ['name' => 'Qabis', 'country_code' => 'TN'],
            ['name' => 'Qafsah', 'country_code' => 'TN'],
            ['name' => 'Qibili', 'country_code' => 'TN'],
            ['name' => 'Safaqis', 'country_code' => 'TN'],
            ['name' => 'Sfax', 'country_code' => 'TN'],
            ['name' => 'Sidi Bu Zayd', 'country_code' => 'TN'],
            ['name' => 'Silyanah', 'country_code' => 'TN'],
            ['name' => 'Susah', 'country_code' => 'TN'],
            ['name' => 'Tatawin', 'country_code' => 'TN'],
            ['name' => 'Tawzar', 'country_code' => 'TN'],
            ['name' => 'Tunis', 'country_code' => 'TN'],
            ['name' => 'Zaghwan', 'country_code' => 'TN'],
            ['name' => 'al-Kaf', 'country_code' => 'TN'],
            ['name' => 'al-Mahdiyah', 'country_code' => 'TN'],
            ['name' => 'al-Munastir', 'country_code' => 'TN'],
            ['name' => 'al-Qasrayn', 'country_code' => 'TN'],
            ['name' => 'al-Qayrawan', 'country_code' => 'TN'],
            ['name' => 'Adana', 'country_code' => 'TR'],
            ['name' => 'Adiyaman', 'country_code' => 'TR'],
            ['name' => 'Afyon', 'country_code' => 'TR'],
            ['name' => 'Agri', 'country_code' => 'TR'],
            ['name' => 'Aksaray', 'country_code' => 'TR'],
            ['name' => 'Amasya', 'country_code' => 'TR'],
            ['name' => 'Ankara', 'country_code' => 'TR'],
            ['name' => 'Antalya', 'country_code' => 'TR'],
            ['name' => 'Ardahan', 'country_code' => 'TR'],
            ['name' => 'Artvin', 'country_code' => 'TR'],
            ['name' => 'Aydin', 'country_code' => 'TR'],
            ['name' => 'Balikesir', 'country_code' => 'TR'],
            ['name' => 'Bartin', 'country_code' => 'TR'],
            ['name' => 'Batman', 'country_code' => 'TR'],
            ['name' => 'Bayburt', 'country_code' => 'TR'],
            ['name' => 'Bilecik', 'country_code' => 'TR'],
            ['name' => 'Bingol', 'country_code' => 'TR'],
            ['name' => 'Bitlis', 'country_code' => 'TR'],
            ['name' => 'Bolu', 'country_code' => 'TR'],
            ['name' => 'Burdur', 'country_code' => 'TR'],
            ['name' => 'Bursa', 'country_code' => 'TR'],
            ['name' => 'Canakkale', 'country_code' => 'TR'],
            ['name' => 'Cankiri', 'country_code' => 'TR'],
            ['name' => 'Corum', 'country_code' => 'TR'],
            ['name' => 'Denizli', 'country_code' => 'TR'],
            ['name' => 'Diyarbakir', 'country_code' => 'TR'],
            ['name' => 'Duzce', 'country_code' => 'TR'],
            ['name' => 'Edirne', 'country_code' => 'TR'],
            ['name' => 'Elazig', 'country_code' => 'TR'],
            ['name' => 'Erzincan', 'country_code' => 'TR'],
            ['name' => 'Erzurum', 'country_code' => 'TR'],
            ['name' => 'Eskisehir', 'country_code' => 'TR'],
            ['name' => 'Gaziantep', 'country_code' => 'TR'],
            ['name' => 'Giresun', 'country_code' => 'TR'],
            ['name' => 'Gumushane', 'country_code' => 'TR'],
            ['name' => 'Hakkari', 'country_code' => 'TR'],
            ['name' => 'Hatay', 'country_code' => 'TR'],
            ['name' => 'Icel', 'country_code' => 'TR'],
            ['name' => 'Igdir', 'country_code' => 'TR'],
            ['name' => 'Isparta', 'country_code' => 'TR'],
            ['name' => 'Istanbul', 'country_code' => 'TR'],
            ['name' => 'Izmir', 'country_code' => 'TR'],
            ['name' => 'Kahramanmaras', 'country_code' => 'TR'],
            ['name' => 'Karabuk', 'country_code' => 'TR'],
            ['name' => 'Karaman', 'country_code' => 'TR'],
            ['name' => 'Kars', 'country_code' => 'TR'],
            ['name' => 'Karsiyaka', 'country_code' => 'TR'],
            ['name' => 'Kastamonu', 'country_code' => 'TR'],
            ['name' => 'Kayseri', 'country_code' => 'TR'],
            ['name' => 'Kilis', 'country_code' => 'TR'],
            ['name' => 'Kirikkale', 'country_code' => 'TR'],
            ['name' => 'Kirklareli', 'country_code' => 'TR'],
            ['name' => 'Kirsehir', 'country_code' => 'TR'],
            ['name' => 'Kocaeli', 'country_code' => 'TR'],
            ['name' => 'Konya', 'country_code' => 'TR'],
            ['name' => 'Kutahya', 'country_code' => 'TR'],
            ['name' => 'Lefkosa', 'country_code' => 'TR'],
            ['name' => 'Malatya', 'country_code' => 'TR'],
            ['name' => 'Manisa', 'country_code' => 'TR'],
            ['name' => 'Mardin', 'country_code' => 'TR'],
            ['name' => 'Mugla', 'country_code' => 'TR'],
            ['name' => 'Mus', 'country_code' => 'TR'],
            ['name' => 'Nevsehir', 'country_code' => 'TR'],
            ['name' => 'Nigde', 'country_code' => 'TR'],
            ['name' => 'Ordu', 'country_code' => 'TR'],
            ['name' => 'Osmaniye', 'country_code' => 'TR'],
            ['name' => 'Rize', 'country_code' => 'TR'],
            ['name' => 'Sakarya', 'country_code' => 'TR'],
            ['name' => 'Samsun', 'country_code' => 'TR'],
            ['name' => 'Sanliurfa', 'country_code' => 'TR'],
            ['name' => 'Siirt', 'country_code' => 'TR'],
            ['name' => 'Sinop', 'country_code' => 'TR'],
            ['name' => 'Sirnak', 'country_code' => 'TR'],
            ['name' => 'Sivas', 'country_code' => 'TR'],
            ['name' => 'Tekirdag', 'country_code' => 'TR'],
            ['name' => 'Tokat', 'country_code' => 'TR'],
            ['name' => 'Trabzon', 'country_code' => 'TR'],
            ['name' => 'Tunceli', 'country_code' => 'TR'],
            ['name' => 'Usak', 'country_code' => 'TR'],
            ['name' => 'Van', 'country_code' => 'TR'],
            ['name' => 'Yalova', 'country_code' => 'TR'],
            ['name' => 'Yozgat', 'country_code' => 'TR'],
            ['name' => 'Zonguldak', 'country_code' => 'TR'],
            ['name' => 'Ahal', 'country_code' => 'TM'],
            ['name' => 'Asgabat', 'country_code' => 'TM'],
            ['name' => 'Balkan', 'country_code' => 'TM'],
            ['name' => 'Dasoguz', 'country_code' => 'TM'],
            ['name' => 'Lebap', 'country_code' => 'TM'],
            ['name' => 'Mari', 'country_code' => 'TM'],
            ['name' => 'Grand Turk', 'country_code' => 'TC'],
            ['name' => 'South Caicos and East Caicos', 'country_code' => 'TC'],
            ['name' => 'Funafuti', 'country_code' => 'TV'],
            ['name' => 'Nanumanga', 'country_code' => 'TV'],
            ['name' => 'Nanumea', 'country_code' => 'TV'],
            ['name' => 'Niutao', 'country_code' => 'TV'],
            ['name' => 'Nui', 'country_code' => 'TV'],
            ['name' => 'Nukufetau', 'country_code' => 'TV'],
            ['name' => 'Nukulaelae', 'country_code' => 'TV'],
            ['name' => 'Vaitupu', 'country_code' => 'TV'],
            ['name' => 'Central', 'country_code' => 'UG'],
            ['name' => 'Eastern', 'country_code' => 'UG'],
            ['name' => 'Northern', 'country_code' => 'UG'],
            ['name' => 'Western', 'country_code' => 'UG'],
            ['name' => "Cherkas'ka", 'country_code' => 'UA'],
            ['name' => "Chernihivs'ka", 'country_code' => 'UA'],
            ['name' => "Chernivets'ka", 'country_code' => 'UA'],
            ['name' => 'Crimea', 'country_code' => 'UA'],
            ['name' => 'Dnipropetrovska', 'country_code' => 'UA'],
            ['name' => "Donets'ka", 'country_code' => 'UA'],
            ['name' => "Ivano-Frankivs'ka", 'country_code' => 'UA'],
            ['name' => 'Kharkiv', 'country_code' => 'UA'],
            ['name' => 'Kharkov', 'country_code' => 'UA'],
            ['name' => 'Khersonska', 'country_code' => 'UA'],
            ['name' => "Khmel'nyts'ka", 'country_code' => 'UA'],
            ['name' => 'Kirovohrad', 'country_code' => 'UA'],
            ['name' => 'Krym', 'country_code' => 'UA'],
            ['name' => 'Kyyiv', 'country_code' => 'UA'],
            ['name' => "Kyyivs'ka", 'country_code' => 'UA'],
            ['name' => "L'vivs'ka", 'country_code' => 'UA'],
            ['name' => "Luhans'ka", 'country_code' => 'UA'],
            ['name' => "Mykolayivs'ka", 'country_code' => 'UA'],
            ['name' => "Odes'ka", 'country_code' => 'UA'],
            ['name' => 'Odessa', 'country_code' => 'UA'],
            ['name' => "Poltavs'ka", 'country_code' => 'UA'],
            ['name' => "Rivnens'ka", 'country_code' => 'UA'],
            ['name' => "Sevastopol'", 'country_code' => 'UA'],
            ['name' => "Sums'ka", 'country_code' => 'UA'],
            ['name' => "Ternopil's'ka", 'country_code' => 'UA'],
            ['name' => "Volyns'ka", 'country_code' => 'UA'],
            ['name' => "Vynnyts'ka", 'country_code' => 'UA'],
            ['name' => "Zakarpats'ka", 'country_code' => 'UA'],
            ['name' => 'Zaporizhia', 'country_code' => 'UA'],
            ['name' => "Zhytomyrs'ka", 'country_code' => 'UA'],
            ['name' => 'Abu Zabi', 'country_code' => 'AE'],
            ['name' => 'Ajman', 'country_code' => 'AE'],
            ['name' => 'Dubai', 'country_code' => 'AE'],
            ['name' => 'Ras al-Khaymah', 'country_code' => 'AE'],
            ['name' => 'Sharjah', 'country_code' => 'AE'],
            ['name' => 'Sharjha', 'country_code' => 'AE'],
            ['name' => 'Umm al Qaywayn', 'country_code' => 'AE'],
            ['name' => 'al-Fujayrah', 'country_code' => 'AE'],
            ['name' => 'ash-Shariqah', 'country_code' => 'AE'],
            ['name' => 'Aberdeen', 'country_code' => 'GB'],
            ['name' => 'Aberdeenshire', 'country_code' => 'GB'],
            ['name' => 'Argyll', 'country_code' => 'GB'],
            ['name' => 'Armagh', 'country_code' => 'GB'],
            ['name' => 'Bedfordshire', 'country_code' => 'GB'],
            ['name' => 'Belfast', 'country_code' => 'GB'],
            ['name' => 'Berkshire', 'country_code' => 'GB'],
            ['name' => 'Birmingham', 'country_code' => 'GB'],
            ['name' => 'Brechin', 'country_code' => 'GB'],
            ['name' => 'Bridgnorth', 'country_code' => 'GB'],
            ['name' => 'Bristol', 'country_code' => 'GB'],
            ['name' => 'Buckinghamshire', 'country_code' => 'GB'],
            ['name' => 'Cambridge', 'country_code' => 'GB'],
            ['name' => 'Cambridgeshire', 'country_code' => 'GB'],
            ['name' => 'Channel Islands', 'country_code' => 'GB'],
            ['name' => 'Cheshire', 'country_code' => 'GB'],
            ['name' => 'Cleveland', 'country_code' => 'GB'],
            ['name' => 'Co Fermanagh', 'country_code' => 'GB'],
            ['name' => 'Conwy', 'country_code' => 'GB'],
            ['name' => 'Cornwall', 'country_code' => 'GB'],
            ['name' => 'Coventry', 'country_code' => 'GB'],
            ['name' => 'Craven Arms', 'country_code' => 'GB'],
            ['name' => 'Cumbria', 'country_code' => 'GB'],
            ['name' => 'Denbighshire', 'country_code' => 'GB'],
            ['name' => 'Derby', 'country_code' => 'GB'],
            ['name' => 'Derbyshire', 'country_code' => 'GB'],
            ['name' => 'Devon', 'country_code' => 'GB'],
            ['name' => 'Dial Code Dungannon', 'country_code' => 'GB'],
            ['name' => 'Didcot', 'country_code' => 'GB'],
            ['name' => 'Dorset', 'country_code' => 'GB'],
            ['name' => 'Dunbartonshire', 'country_code' => 'GB'],
            ['name' => 'Durham', 'country_code' => 'GB'],
            ['name' => 'East Dunbartonshire', 'country_code' => 'GB'],
            ['name' => 'East Lothian', 'country_code' => 'GB'],
            ['name' => 'East Midlands', 'country_code' => 'GB'],
            ['name' => 'East Sussex', 'country_code' => 'GB'],
            ['name' => 'East Yorkshire', 'country_code' => 'GB'],
            ['name' => 'England', 'country_code' => 'GB'],
            ['name' => 'Essex', 'country_code' => 'GB'],
            ['name' => 'Fermanagh', 'country_code' => 'GB'],
            ['name' => 'Fife', 'country_code' => 'GB'],
            ['name' => 'Flintshire', 'country_code' => 'GB'],
            ['name' => 'Fulham', 'country_code' => 'GB'],
            ['name' => 'Gainsborough', 'country_code' => 'GB'],
            ['name' => 'Glocestershire', 'country_code' => 'GB'],
            ['name' => 'Gwent', 'country_code' => 'GB'],
            ['name' => 'Hampshire', 'country_code' => 'GB'],
            ['name' => 'Hants', 'country_code' => 'GB'],
            ['name' => 'Herefordshire', 'country_code' => 'GB'],
            ['name' => 'Hertfordshire', 'country_code' => 'GB'],
            ['name' => 'Ireland', 'country_code' => 'GB'],
            ['name' => 'Isle Of Man', 'country_code' => 'GB'],
            ['name' => 'Isle of Wight', 'country_code' => 'GB'],
            ['name' => 'Kenford', 'country_code' => 'GB'],
            ['name' => 'Kent', 'country_code' => 'GB'],
            ['name' => 'Kilmarnock', 'country_code' => 'GB'],
            ['name' => 'Lanarkshire', 'country_code' => 'GB'],
            ['name' => 'Lancashire', 'country_code' => 'GB'],
            ['name' => 'Leicestershire', 'country_code' => 'GB'],
            ['name' => 'Lincolnshire', 'country_code' => 'GB'],
            ['name' => 'Llanymynech', 'country_code' => 'GB'],
            ['name' => 'London', 'country_code' => 'GB'],
            ['name' => 'Ludlow', 'country_code' => 'GB'],
            ['name' => 'Manchester', 'country_code' => 'GB'],
            ['name' => 'Mayfair', 'country_code' => 'GB'],
            ['name' => 'Merseyside', 'country_code' => 'GB'],
            ['name' => 'Mid Glamorgan', 'country_code' => 'GB'],
            ['name' => 'Middlesex', 'country_code' => 'GB'],
            ['name' => 'Mildenhall', 'country_code' => 'GB'],
            ['name' => 'Monmouthshire', 'country_code' => 'GB'],
            ['name' => 'Newton Stewart', 'country_code' => 'GB'],
            ['name' => 'Norfolk', 'country_code' => 'GB'],
            ['name' => 'North Humberside', 'country_code' => 'GB'],
            ['name' => 'North Yorkshire', 'country_code' => 'GB'],
            ['name' => 'Northamptonshire', 'country_code' => 'GB'],
            ['name' => 'Northants', 'country_code' => 'GB'],
            ['name' => 'Northern Ireland', 'country_code' => 'GB'],
            ['name' => 'Northumberland', 'country_code' => 'GB'],
            ['name' => 'Nottinghamshire', 'country_code' => 'GB'],
            ['name' => 'Oxford', 'country_code' => 'GB'],
            ['name' => 'Powys', 'country_code' => 'GB'],
            ['name' => 'Roos-shire', 'country_code' => 'GB'],
            ['name' => 'SUSSEX', 'country_code' => 'GB'],
            ['name' => 'Sark', 'country_code' => 'GB'],
            ['name' => 'Scotland', 'country_code' => 'GB'],
            ['name' => 'Scottish Borders', 'country_code' => 'GB'],
            ['name' => 'Shropshire', 'country_code' => 'GB'],
            ['name' => 'Somerset', 'country_code' => 'GB'],
            ['name' => 'South Glamorgan', 'country_code' => 'GB'],
            ['name' => 'South Wales', 'country_code' => 'GB'],
            ['name' => 'South Yorkshire', 'country_code' => 'GB'],
            ['name' => 'Southwell', 'country_code' => 'GB'],
            ['name' => 'Staffordshire', 'country_code' => 'GB'],
            ['name' => 'Strabane', 'country_code' => 'GB'],
            ['name' => 'Suffolk', 'country_code' => 'GB'],
            ['name' => 'Surrey', 'country_code' => 'GB'],
            ['name' => 'Sussex', 'country_code' => 'GB'],
            ['name' => 'Twickenham', 'country_code' => 'GB'],
            ['name' => 'Tyne and Wear', 'country_code' => 'GB'],
            ['name' => 'Tyrone', 'country_code' => 'GB'],
            ['name' => 'Utah', 'country_code' => 'GB'],
            ['name' => 'Wales', 'country_code' => 'GB'],
            ['name' => 'Warwickshire', 'country_code' => 'GB'],
            ['name' => 'West Lothian', 'country_code' => 'GB'],
            ['name' => 'West Midlands', 'country_code' => 'GB'],
            ['name' => 'West Sussex', 'country_code' => 'GB'],
            ['name' => 'West Yorkshire', 'country_code' => 'GB'],
            ['name' => 'Whissendine', 'country_code' => 'GB'],
            ['name' => 'Wiltshire', 'country_code' => 'GB'],
            ['name' => 'Wokingham', 'country_code' => 'GB'],
            ['name' => 'Worcestershire', 'country_code' => 'GB'],
            ['name' => 'Wrexham', 'country_code' => 'GB'],
            ['name' => 'Wurttemberg', 'country_code' => 'GB'],
            ['name' => 'Yorkshire', 'country_code' => 'GB'],
            ['name' => 'Alabama', 'country_code' => 'US', 'code' => 'AL'],
            ['name' => 'Alaska', 'country_code' => 'US', 'code' => 'AK'],
            ['name' => 'Arizona', 'country_code' => 'US', 'code' => 'AZ'],
            ['name' => 'Arkansas', 'country_code' => 'US', 'code' => 'AR'],
            ['name' => 'California', 'country_code' => 'US', 'code' => 'CA'],
            ['name' => 'Colorado', 'country_code' => 'US', 'code' => 'CO'],
            ['name' => 'Connecticut', 'country_code' => 'US', 'code' => 'CT'],
            ['name' => 'Delaware', 'country_code' => 'US', 'code' => 'DE'],
            ['name' => 'District of Columbia', 'country_code' => 'US', 'code' => 'DC'],
            ['name' => 'Florida', 'country_code' => 'US', 'code' => 'FL'],
            ['name' => 'Georgia', 'country_code' => 'US', 'code' => 'GA'],
            ['name' => 'Hawaii', 'country_code' => 'US', 'code' => 'HI'],
            ['name' => 'Idaho', 'country_code' => 'US', 'code' => 'ID'],
            ['name' => 'Illinois', 'country_code' => 'US', 'code' => 'IL'],
            ['name' => 'Indiana', 'country_code' => 'US', 'code' => 'IN'],
            ['name' => 'Iowa', 'country_code' => 'US', 'code' => 'IA'],
            ['name' => 'Kansas', 'country_code' => 'US', 'code' => 'KS'],
            ['name' => 'Kentucky', 'country_code' => 'US', 'code' => 'KY'],
            ['name' => 'Louisiana', 'country_code' => 'US', 'code' => 'LA'],
            ['name' => 'Maine', 'country_code' => 'US', 'code' => 'ME'],
            ['name' => 'Maryland', 'country_code' => 'US', 'code' => 'MD'],
            ['name' => 'Massachusetts', 'country_code' => 'US', 'code' => 'MA'],
            ['name' => 'Michigan', 'country_code' => 'US', 'code' => 'MI'],
            ['name' => 'Minnesota', 'country_code' => 'US', 'code' => 'MN'],
            ['name' => 'Mississippi', 'country_code' => 'US', 'code' => 'MS'],
            ['name' => 'Missouri', 'country_code' => 'US', 'code' => 'MO'],
            ['name' => 'Montana', 'country_code' => 'US', 'code' => 'MT'],
            ['name' => 'Nebraska', 'country_code' => 'US', 'code' => 'NE'],
            ['name' => 'Nevada', 'country_code' => 'US', 'code' => 'NV'],
            ['name' => 'New Hampshire', 'country_code' => 'US', 'code' => 'NH'],
            ['name' => 'New Jersey', 'country_code' => 'US', 'code' => 'NJ'],
            ['name' => 'New Mexico', 'country_code' => 'US', 'code' => 'NM'],
            ['name' => 'New York', 'country_code' => 'US', 'code' => 'NY'],
            ['name' => 'North Carolina', 'country_code' => 'US', 'code' => 'NC'],
            ['name' => 'North Dakota', 'country_code' => 'US', 'code' => 'ND'],
            ['name' => 'Ohio', 'country_code' => 'US', 'code' => 'OH'],
            ['name' => 'Oklahoma', 'country_code' => 'US', 'code' => 'OK'],
            ['name' => 'Oregon', 'country_code' => 'US', 'code' => 'OR'],
            ['name' => 'Pennsylvania', 'country_code' => 'US', 'code' => 'PA'],
            ['name' => 'Rhode Island', 'country_code' => 'US', 'code' => 'RI'],
            ['name' => 'South Carolina', 'country_code' => 'US', 'code' => 'SC'],
            ['name' => 'South Dakota', 'country_code' => 'US', 'code' => 'SD'],
            ['name' => 'Tennessee', 'country_code' => 'US', 'code' => 'TN'],
            ['name' => 'Texas', 'country_code' => 'US', 'code' => 'TX'],
            ['name' => 'Utah', 'country_code' => 'US', 'code' => 'UT'],
            ['name' => 'Vermont', 'country_code' => 'US', 'code' => 'VT'],
            ['name' => 'Virginia', 'country_code' => 'US', 'code' => 'VA'],
            ['name' => 'Washington', 'country_code' => 'US', 'code' => 'WA'],
            ['name' => 'West Virginia', 'country_code' => 'US', 'code' => 'WV'],
            ['name' => 'Wisconsin', 'country_code' => 'US', 'code' => 'WI'],
            ['name' => 'Wyoming', 'country_code' => 'US', 'code' => 'WY'],
            ['name' => 'United States Minor Outlying I', 'country_code' => 'UM'],
            ['name' => 'Artigas', 'country_code' => 'UY'],
            ['name' => 'Canelones', 'country_code' => 'UY'],
            ['name' => 'Cerro Largo', 'country_code' => 'UY'],
            ['name' => 'Colonia', 'country_code' => 'UY'],
            ['name' => 'Durazno', 'country_code' => 'UY'],
            ['name' => 'FLorida', 'country_code' => 'UY'],
            ['name' => 'Flores', 'country_code' => 'UY'],
            ['name' => 'Lavalleja', 'country_code' => 'UY'],
            ['name' => 'Maldonado', 'country_code' => 'UY'],
            ['name' => 'Montevideo', 'country_code' => 'UY'],
            ['name' => 'Paysandu', 'country_code' => 'UY'],
            ['name' => 'Rio Negro', 'country_code' => 'UY'],
            ['name' => 'Rivera', 'country_code' => 'UY'],
            ['name' => 'Rocha', 'country_code' => 'UY'],
            ['name' => 'Salto', 'country_code' => 'UY'],
            ['name' => 'San Jose', 'country_code' => 'UY'],
            ['name' => 'Soriano', 'country_code' => 'UY'],
            ['name' => 'Tacuarembo', 'country_code' => 'UY'],
            ['name' => 'Treinta y Tres', 'country_code' => 'UY'],
            ['name' => 'Andijon', 'country_code' => 'UZ'],
            ['name' => 'Buhoro', 'country_code' => 'UZ'],
            ['name' => 'Buxoro Viloyati', 'country_code' => 'UZ'],
            ['name' => 'Cizah', 'country_code' => 'UZ'],
            ['name' => 'Fargona', 'country_code' => 'UZ'],
            ['name' => 'Horazm', 'country_code' => 'UZ'],
            ['name' => 'Kaskadar', 'country_code' => 'UZ'],
            ['name' => 'Korakalpogiston', 'country_code' => 'UZ'],
            ['name' => 'Namangan', 'country_code' => 'UZ'],
            ['name' => 'Navoi', 'country_code' => 'UZ'],
            ['name' => 'Samarkand', 'country_code' => 'UZ'],
            ['name' => 'Sirdare', 'country_code' => 'UZ'],
            ['name' => 'Surhondar', 'country_code' => 'UZ'],
            ['name' => 'Toskent', 'country_code' => 'UZ'],
            ['name' => 'Malampa', 'country_code' => 'VU'],
            ['name' => 'Penama', 'country_code' => 'VU'],
            ['name' => 'Sanma', 'country_code' => 'VU'],
            ['name' => 'Shefa', 'country_code' => 'VU'],
            ['name' => 'Tafea', 'country_code' => 'VU'],
            ['name' => 'Torba', 'country_code' => 'VU'],
            ['name' => 'Vatican City State (Holy See)', 'country_code' => 'VA'],
            ['name' => 'Amazonas', 'country_code' => 'VE'],
            ['name' => 'Anzoategui', 'country_code' => 'VE'],
            ['name' => 'Apure', 'country_code' => 'VE'],
            ['name' => 'Aragua', 'country_code' => 'VE'],
            ['name' => 'Barinas', 'country_code' => 'VE'],
            ['name' => 'Bolivar', 'country_code' => 'VE'],
            ['name' => 'Carabobo', 'country_code' => 'VE'],
            ['name' => 'Cojedes', 'country_code' => 'VE'],
            ['name' => 'Delta Amacuro', 'country_code' => 'VE'],
            ['name' => 'Distrito Federal', 'country_code' => 'VE'],
            ['name' => 'Falcon', 'country_code' => 'VE'],
            ['name' => 'Guarico', 'country_code' => 'VE'],
            ['name' => 'Lara', 'country_code' => 'VE'],
            ['name' => 'Merida', 'country_code' => 'VE'],
            ['name' => 'Miranda', 'country_code' => 'VE'],
            ['name' => 'Monagas', 'country_code' => 'VE'],
            ['name' => 'Nueva Esparta', 'country_code' => 'VE'],
            ['name' => 'Portuguesa', 'country_code' => 'VE'],
            ['name' => 'Sucre', 'country_code' => 'VE'],
            ['name' => 'Tachira', 'country_code' => 'VE'],
            ['name' => 'Trujillo', 'country_code' => 'VE'],
            ['name' => 'Vargas', 'country_code' => 'VE'],
            ['name' => 'Yaracuy', 'country_code' => 'VE'],
            ['name' => 'Zulia', 'country_code' => 'VE'],
            ['name' => 'Bac Giang', 'country_code' => 'VN'],
            ['name' => 'Binh Dinh', 'country_code' => 'VN'],
            ['name' => 'Binh Duong', 'country_code' => 'VN'],
            ['name' => 'Da Nang', 'country_code' => 'VN'],
            ['name' => 'Dong Bang Song Cuu Long', 'country_code' => 'VN'],
            ['name' => 'Dong Bang Song Hong', 'country_code' => 'VN'],
            ['name' => 'Dong Nai', 'country_code' => 'VN'],
            ['name' => 'Dong Nam Bo', 'country_code' => 'VN'],
            ['name' => 'Duyen Hai Mien Trung', 'country_code' => 'VN'],
            ['name' => 'Hanoi', 'country_code' => 'VN'],
            ['name' => 'Hung Yen', 'country_code' => 'VN'],
            ['name' => 'Khu Bon Cu', 'country_code' => 'VN'],
            ['name' => 'Long An', 'country_code' => 'VN'],
            ['name' => 'Mien Nui Va Trung Du', 'country_code' => 'VN'],
            ['name' => 'Thai Nguyen', 'country_code' => 'VN'],
            ['name' => 'Thanh Pho Ho Chi Minh', 'country_code' => 'VN'],
            ['name' => 'Thu Do Ha Noi', 'country_code' => 'VN'],
            ['name' => 'Tinh Can Tho', 'country_code' => 'VN'],
            ['name' => 'Tinh Da Nang', 'country_code' => 'VN'],
            ['name' => 'Tinh Gia Lai', 'country_code' => 'VN'],
            ['name' => 'Anegada', 'country_code' => 'VG'],
            ['name' => 'Jost van Dyke', 'country_code' => 'VG'],
            ['name' => 'Tortola', 'country_code' => 'VG'],
            ['name' => 'Saint Croix', 'country_code' => 'VI'],
            ['name' => 'Saint John', 'country_code' => 'VI'],
            ['name' => 'Saint Thomas', 'country_code' => 'VI'],
            ['name' => 'Alo', 'country_code' => 'WF'],
            ['name' => 'Singave', 'country_code' => 'WF'],
            ['name' => 'Wallis', 'country_code' => 'WF'],
            ['name' => 'Bu Jaydur', 'country_code' => 'EH'],
            ['name' => 'Wad-adh-Dhahab', 'country_code' => 'EH'],
            ['name' => "al-'Ayun", 'country_code' => 'EH'],
            ['name' => 'as-Samarah', 'country_code' => 'EH'],
            ['name' => "'Adan", 'country_code' => 'YE'],
            ['name' => 'Abyan', 'country_code' => 'YE'],
            ['name' => 'Dhamar', 'country_code' => 'YE'],
            ['name' => 'Hadramaut', 'country_code' => 'YE'],
            ['name' => 'Hajjah', 'country_code' => 'YE'],
            ['name' => 'Hudaydah', 'country_code' => 'YE'],
            ['name' => 'Ibb', 'country_code' => 'YE'],
            ['name' => 'Lahij', 'country_code' => 'YE'],
            ['name' => "Ma'rib", 'country_code' => 'YE'],
            ['name' => "Madinat San'a", 'country_code' => 'YE'],
            ['name' => "Sa'dah", 'country_code' => 'YE'],
            ['name' => 'Sana', 'country_code' => 'YE'],
            ['name' => 'Shabwah', 'country_code' => 'YE'],
            ['name' => "Ta'izz", 'country_code' => 'YE'],
            ['name' => 'al-Bayda', 'country_code' => 'YE'],
            ['name' => 'al-Hudaydah', 'country_code' => 'YE'],
            ['name' => 'al-Jawf', 'country_code' => 'YE'],
            ['name' => 'al-Mahrah', 'country_code' => 'YE'],
            ['name' => 'al-Mahwit', 'country_code' => 'YE'],
            ['name' => 'Central Serbia', 'country_code' => 'YU'],
            ['name' => 'Kosovo and Metohija', 'country_code' => 'YU'],
            ['name' => 'Montenegro', 'country_code' => 'YU'],
            ['name' => 'Republic of Serbia', 'country_code' => 'YU'],
            ['name' => 'Serbia', 'country_code' => 'YU'],
            ['name' => 'Vojvodina', 'country_code' => 'YU'],
            ['name' => 'Central', 'country_code' => 'ZM'],
            ['name' => 'Copperbelt', 'country_code' => 'ZM'],
            ['name' => 'Eastern', 'country_code' => 'ZM'],
            ['name' => 'Luapala', 'country_code' => 'ZM'],
            ['name' => 'Lusaka', 'country_code' => 'ZM'],
            ['name' => 'North-Western', 'country_code' => 'ZM'],
            ['name' => 'Northern', 'country_code' => 'ZM'],
            ['name' => 'Southern', 'country_code' => 'ZM'],
            ['name' => 'Western', 'country_code' => 'ZM'],
            ['name' => 'Bulawayo', 'country_code' => 'ZW'],
            ['name' => 'Harare', 'country_code' => 'ZW'],
            ['name' => 'Manicaland', 'country_code' => 'ZW'],
            ['name' => 'Mashonaland Central', 'country_code' => 'ZW'],
            ['name' => 'Mashonaland East', 'country_code' => 'ZW'],
            ['name' => 'Mashonaland West', 'country_code' => 'ZW'],
            ['name' => 'Masvingo', 'country_code' => 'ZW'],
            ['name' => 'Matabeleland North', 'country_code' => 'ZW'],
            ['name' => 'Matabeleland South', 'country_code' => 'ZW'],
            ['name' => 'Midlands', 'country_code' => 'ZW'],
        ]);

        DB::table('constants_states')->delete();

        //Split on code as mysql can not insert different column data.
        DB::table('constants_states')->insert(collect($states)->where('code', '!=', null)->values()->all());
        DB::table('constants_states')->insert(collect($states)->where('code', null)->values()->all());
    }
}
