<?php

namespace Database\Seeders\ImmutableData\CAZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NovaScotiaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => 'B2G2K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3Y4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9743000',
                'longitude' => '-74.6357000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'St-joseph-du-moine',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'Cheticamp',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'Cheticamp',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'Cheticamp',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'Cheticamp',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'Petit Etang',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'Grand Etang',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6278000',
                'longitude' => '-61.0114000',
                'city' => 'Pleasant Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5197000',
                'longitude' => '-61.0253000',
                'city' => 'Descousse',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5197000',
                'longitude' => '-61.0253000',
                'city' => 'Sampson Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5197000',
                'longitude' => '-61.0253000',
                'city' => 'Arichat',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5197000',
                'longitude' => '-61.0253000',
                'city' => 'West Arichat',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5197000',
                'longitude' => '-61.0253000',
                'city' => 'Arichat',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5197000',
                'longitude' => '-61.0253000',
                'city' => 'Petit De Grat',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6116000',
                'longitude' => '-61.3601000',
                'city' => 'St Peters',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4914000',
                'longitude' => '-64.1101000',
                'city' => 'Tancook Island',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4914000',
                'longitude' => '-64.1101000',
                'city' => 'Hubbards',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4914000',
                'longitude' => '-64.1101000',
                'city' => 'Chester',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4914000',
                'longitude' => '-64.1101000',
                'city' => 'Blandford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6096000',
                'longitude' => '-61.6197000',
                'city' => 'Monastery',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6096000',
                'longitude' => '-61.6197000',
                'city' => 'Havre Boucher',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6096000',
                'longitude' => '-61.6197000',
                'city' => 'Afton Station',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6096000',
                'longitude' => '-61.6197000',
                'city' => 'Frankville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.4348000',
                'longitude' => '-61.1076000',
                'city' => 'Margaree',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.4348000',
                'longitude' => '-61.1076000',
                'city' => 'Belle Cote',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.4348000',
                'longitude' => '-61.1076000',
                'city' => 'Margaree Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8569000',
                'longitude' => '-63.6583000',
                'city' => 'Port Howe',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8569000',
                'longitude' => '-63.6583000',
                'city' => 'Wallace',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8569000',
                'longitude' => '-63.6583000',
                'city' => 'Pugwash Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8569000',
                'longitude' => '-63.6583000',
                'city' => 'Walton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8569000',
                'longitude' => '-63.6583000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8569000',
                'longitude' => '-63.6583000',
                'city' => 'Pugwash',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0V1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Freeport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0V1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Digby',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Granville Ferry',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Oxford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Bear River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Plympton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Digby',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Barton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Smiths Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6079000',
                'longitude' => '-65.7651000',
                'city' => 'Carleton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1Z0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.3336000',
                'longitude' => '-61.0852000',
                'city' => 'Margaree Centre',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.3336000',
                'longitude' => '-61.0852000',
                'city' => 'Margaree Forks',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.3336000',
                'longitude' => '-61.0852000',
                'city' => 'North East Margaree',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.3336000',
                'longitude' => '-61.0852000',
                'city' => 'Margaree Valley',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.3336000',
                'longitude' => '-61.0852000',
                'city' => 'South West Margaree',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.3336000',
                'longitude' => '-61.0852000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0L1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6916000',
                'longitude' => '-64.3793000',
                'city' => 'Joggins',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0L1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6916000',
                'longitude' => '-64.3793000',
                'city' => 'Maccan',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0L1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6916000',
                'longitude' => '-64.3793000',
                'city' => 'River Hebert',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4105000',
                'longitude' => '-64.3252000',
                'city' => 'Parrsboro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4105000',
                'longitude' => '-64.3252000',
                'city' => 'Five Islands',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4105000',
                'longitude' => '-64.3252000',
                'city' => 'Parrsboro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4105000',
                'longitude' => '-64.3252000',
                'city' => 'Springhill',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4105000',
                'longitude' => '-64.3252000',
                'city' => 'Diligent River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4105000',
                'longitude' => '-64.3252000',
                'city' => 'Lower Five Islands',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8161000',
                'longitude' => '-63.4772000',
                'city' => 'Malagash',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1Z0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8161000',
                'longitude' => '-63.4772000',
                'city' => 'Wentworth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8161000',
                'longitude' => '-63.4772000',
                'city' => 'Tatamagouche',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2339000',
                'longitude' => '-61.2924000',
                'city' => 'Inverness',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2339000',
                'longitude' => '-61.2924000',
                'city' => 'Whycocomagh',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2339000',
                'longitude' => '-61.2924000',
                'city' => 'Scotsville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2339000',
                'longitude' => '-61.2924000',
                'city' => 'Mabou',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3164000',
                'longitude' => '-63.4985000',
                'city' => 'Maitland',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3164000',
                'longitude' => '-63.4985000',
                'city' => 'Upper Kennetcook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1V6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3164000',
                'longitude' => '-63.4985000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5501000',
                'longitude' => '-64.2607000',
                'city' => 'Chester Basin',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5501000',
                'longitude' => '-64.2607000',
                'city' => 'Lunenburg',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6403000',
                'longitude' => '-60.4001000',
                'city' => 'Ingonish Beach',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.6403000',
                'longitude' => '-60.4001000',
                'city' => 'Ingonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1112000',
                'longitude' => '-60.7410000',
                'city' => 'Baddeck',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.2762000',
                'longitude' => '-61.8863000',
                'city' => 'Cross Roads Country Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.2762000',
                'longitude' => '-61.8863000',
                'city' => 'Debert',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.2762000',
                'longitude' => '-61.8863000',
                'city' => 'Goldboro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.8330000',
                'longitude' => '-60.3196000',
                'city' => 'New Haven',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.8330000',
                'longitude' => '-60.3196000',
                'city' => 'Canso',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.8330000',
                'longitude' => '-60.3196000',
                'city' => 'Neils Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6275000',
                'longitude' => '-61.0662000',
                'city' => 'Louisdale',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6275000',
                'longitude' => '-61.0662000',
                'city' => 'Sydney Forks',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6275000',
                'longitude' => '-61.0662000',
                'city' => 'West Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9736000',
                'longitude' => '-62.1755000',
                'city' => 'Marie Joseph',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9736000',
                'longitude' => '-62.1755000',
                'city' => 'Moser River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4178000',
                'longitude' => '-64.5515000',
                'city' => 'Port Greville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7521000',
                'longitude' => '-63.0681000',
                'city' => 'River John',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7521000',
                'longitude' => '-63.0681000',
                'city' => 'Scotsburn',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7521000',
                'longitude' => '-63.0681000',
                'city' => 'Pictou',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Port Mouton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Mill Village',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Liverpool',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2X6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2W9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2W8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Summerville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Hunts Point',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Shelburne',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Crowell',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Glenwood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0V1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Sandy Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Milton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'Brooklyn',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3354000',
                'longitude' => '-61.2652000',
                'city' => 'Larrys River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3354000',
                'longitude' => '-61.2652000',
                'city' => 'Guysborough',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1740000',
                'longitude' => '-63.7254000',
                'city' => 'Noel',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1740000',
                'longitude' => '-63.7254000',
                'city' => 'Kennetcook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1344000',
                'longitude' => '-61.8863000',
                'city' => 'Bickerton West',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1344000',
                'longitude' => '-61.8863000',
                'city' => 'Sherbrooke',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3335000',
                'longitude' => '-61.0022000',
                'city' => 'Little Dover',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3098000',
                'longitude' => '-63.7483000',
                'city' => 'Densmores Mills',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9414000',
                'longitude' => '-60.6159000',
                'city' => 'Eskasoni',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9414000',
                'longitude' => '-60.6159000',
                'city' => 'Eskasoni',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.8929000',
                'longitude' => '-60.4385000',
                'city' => 'Cape North',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.8929000',
                'longitude' => '-60.4385000',
                'city' => 'Capstick',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.8929000',
                'longitude' => '-60.4385000',
                'city' => 'St Margaret Village',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.8929000',
                'longitude' => '-60.4385000',
                'city' => 'Dingwall',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0511000',
                'longitude' => '-63.1508000',
                'city' => 'Upper Musquodoboit',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0511000',
                'longitude' => '-63.1508000',
                'city' => 'Pine Grove.',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0511000',
                'longitude' => '-63.1508000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0511000',
                'longitude' => '-63.1508000',
                'city' => 'Meaghers Grant',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0511000',
                'longitude' => '-63.1508000',
                'city' => 'Middle Musquodoboit',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0511000',
                'longitude' => '-63.1508000',
                'city' => 'Musquodoboit Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0511000',
                'longitude' => '-63.1508000',
                'city' => 'Elderbank',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6029000',
                'longitude' => '-61.8100000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6029000',
                'longitude' => '-61.8100000',
                'city' => 'Heatherton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1842000',
                'longitude' => '-61.6492000',
                'city' => 'Isaacs Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3329000',
                'longitude' => '-64.7635000',
                'city' => 'Advocate Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Merigomish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H5C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Hopewell',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Eureka',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2P5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K2A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Westville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1P2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H5C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Stellarton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Trenton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H5C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H5C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Greenwood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2M2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Arcadia',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1Y6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3R4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1Z8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1Y9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4P7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3K8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1Y2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1S9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3M4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1H1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3T2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1P3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1V4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2H7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4V2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4M2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3N4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1G8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3X8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1Y2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3Z6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2G9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2W3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2Z8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1B9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4K8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1Y5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2Y5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1S2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1Y3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K1E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4S5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3S3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1M5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3Z7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1V7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1M7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1L5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y2N5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3N8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K2A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4B7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3P6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1X5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3M8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1V9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3L8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1R2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1H6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1X8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3V4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1Y9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2G1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3M3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3T1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5L2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1Y6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3Z1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1Z5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1X5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y2N6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1S3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W3E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L2C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3W6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1V8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3G9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A1M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1V7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2A5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4N1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2Y9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1H2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W2X6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2X1S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4X7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W2T6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W5C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4B9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W6A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W1P7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1P6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W6A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lawrencetown.',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W3X7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W2S7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W5Z9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W5Y3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4T7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4V6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W1L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2X2C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2X2G9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2X3E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W2P9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4L5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V2J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1Z8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W5G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3M9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3L7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4L6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M1M4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M1J1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3V3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4L1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3H5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3N7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3R2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M1A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3N3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4P8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M2X6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2J2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3H6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3N1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M1C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0V1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7330000',
                'longitude' => '-63.8680000',
                'city' => 'Little River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3Y2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7330000',
                'longitude' => '-63.8680000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7330000',
                'longitude' => '-63.8680000',
                'city' => 'Oxford Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7330000',
                'longitude' => '-63.8680000',
                'city' => 'Oxford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7330000',
                'longitude' => '-63.8680000',
                'city' => 'River Philip',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1A8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1B7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3S1C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1L7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Windsor',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K4B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W6C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W3Y6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1N4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L3Z8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5V3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4R2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4P3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3S5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4P2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4N9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3H3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L2C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5V4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5N7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L2H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5K2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L3Z7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L3Z9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4R4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3S6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3P9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4P1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3K3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M2K7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K1X9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K2S2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3Y2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L2Z9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3G1J1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Eastern Passage',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A1H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W3E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Middleton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4H7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3N6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4N8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M1A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M3Y7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M2E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L1A8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A3Y7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1H1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A3E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3W6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A1G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A1Y7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4M9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4L9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2X2H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4R2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1Y6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1B9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1S6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V2P5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V2A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1P9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V1B7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V2P9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4T7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A3Z4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3V8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2K8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3M2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4A5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4G4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4M7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2R5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4P5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A1G1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A1B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A1L8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2L9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3G1M4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Eastern Passage',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4L2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4J1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M1P2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R2H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1H3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Shearwater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4W6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3M5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y2M2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A4M7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5662000',
                'longitude' => '-65.6452000',
                'city' => 'Deep Brook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5662000',
                'longitude' => '-65.6452000',
                'city' => 'Clementsvale',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5662000',
                'longitude' => '-65.6452000',
                'city' => 'Clementsport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1T5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1K8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1S4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1S3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1M2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1S8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1S2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1R6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1J4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1L5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3N3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y2N4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A3B7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4P8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4B1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K2P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W6C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1J2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2H6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1H7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1R5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1X4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1W4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N3G1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N3A8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1K7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1R6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N3G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1Z6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P2N8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P2M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N3E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P2R6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P2J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P2M7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P2J6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R2H7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1V1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N3E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1L2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1V5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1T6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1T8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A3Y4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K4X1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K4P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6842000',
                'longitude' => '-62.7119000',
                'city' => 'Pictou',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6842000',
                'longitude' => '-62.7119000',
                'city' => 'St Andrews',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2W3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K2S3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R2J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1L9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A3X6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3B7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3M2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y4P8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3A2J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1S9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1T3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1V1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2N5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3A5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2R4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4J6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2Z9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4K2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4T9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1Y1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4T1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K4P6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W4Y3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1Z9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y3Y8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1W9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W6B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1P6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4J2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1R4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1W7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H4J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P2R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1T8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4P9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H2A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1Z2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H1S4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3H3G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J3L7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K1E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1N1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Sambro Head',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J2R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E1G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C4B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3V3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3T3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W6B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3N1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4S9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2X2Z7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M1Z7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K3M9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K4R9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Ellershouse',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V2C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2V2V2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Head Of Chezzetcook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1M9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1R8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1419000',
                'longitude' => '-61.9872000',
                'city' => 'Aspen',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V3B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2W4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V3J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1M9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2A8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2V6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V3V7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2V4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V3H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2W1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2V9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1N1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0R1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'La Have',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V3J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2V7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0R1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Pleasantville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.2357000',
                'longitude' => '-64.0107000',
                'city' => 'Cambridge',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7336000',
                'longitude' => '-65.5326000',
                'city' => 'Annapolis Royal',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7336000',
                'longitude' => '-65.5326000',
                'city' => 'Bridgetown',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3937000',
                'longitude' => '-61.5083000',
                'city' => 'Boylston',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3937000',
                'longitude' => '-61.5083000',
                'city' => 'Great Village',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3937000',
                'longitude' => '-61.5083000',
                'city' => 'Salmon River.',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3937000',
                'longitude' => '-61.5083000',
                'city' => 'Mulgrave',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6583000',
                'longitude' => '-60.8836000',
                'city' => 'River Bourgeois',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6583000',
                'longitude' => '-60.8836000',
                'city' => 'Church Point',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0575000',
                'longitude' => '-64.7531000',
                'city' => 'Berwick',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0575000',
                'longitude' => '-64.7531000',
                'city' => 'Aylesford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0575000',
                'longitude' => '-64.7531000',
                'city' => 'Berwick',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0575000',
                'longitude' => '-64.7531000',
                'city' => 'Waterville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6L5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5T3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1N7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6T4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S2R9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S2G1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6R4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S3B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6R1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1A8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6S9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1M1A6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0936000',
                'longitude' => '-64.3681000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0936000',
                'longitude' => '-64.3681000',
                'city' => 'Port Williams',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0936000',
                'longitude' => '-64.3681000',
                'city' => 'Avonport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0936000',
                'longitude' => '-64.3681000',
                'city' => 'Greenfield.',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0936000',
                'longitude' => '-64.3681000',
                'city' => 'Grand Pre',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0936000',
                'longitude' => '-64.3681000',
                'city' => 'Wolfville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V3N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1R2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V1B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2W3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V3A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3666000',
                'longitude' => '-64.5257000',
                'city' => 'Bridgewater',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2P3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2Z2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P3Z8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V3B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1W1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1R5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Newcastle',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2L2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2Y7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Newcastle',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1A6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P7A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2P2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1X2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1X4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0L1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7180000',
                'longitude' => '-64.2496000',
                'city' => 'Nappan',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.7180000',
                'longitude' => '-64.2496000',
                'city' => 'Southampton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0R1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6345000',
                'longitude' => '-64.8677000',
                'city' => 'Springfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6770000',
                'longitude' => '-63.5620000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S2G8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S2K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1W1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P3Y5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1G9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1G8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Howie Center',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5L1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S3K4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1V3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6T2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1M1A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1G3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Howie Center',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S2L6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P3G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S2V2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P5E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P4A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A5J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1N7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S3L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1M2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1S7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1R9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1V7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1V2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1S5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1L8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P1P3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1S1L9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1R1S6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1499000',
                'longitude' => '-60.1811000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1596000',
                'longitude' => '-64.4194000',
                'city' => 'Kingston',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1596000',
                'longitude' => '-64.4194000',
                'city' => 'Canning',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1596000',
                'longitude' => '-64.4194000',
                'city' => 'Centreville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8834000',
                'longitude' => '-65.1580000',
                'city' => 'Paradise',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W3T7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8834000',
                'longitude' => '-65.1580000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6081000',
                'longitude' => '-60.7518000',
                'city' => 'Lower Lardoise',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6081000',
                'longitude' => '-60.7518000',
                'city' => 'Grand River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6081000',
                'longitude' => '-60.7518000',
                'city' => 'Lardoise',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9662000',
                'longitude' => '-60.7310000',
                'city' => 'Little Narrows',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9662000',
                'longitude' => '-60.7310000',
                'city' => 'Grand Narrows',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4413000',
                'longitude' => '-64.3682000',
                'city' => 'Mahone Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4413000',
                'longitude' => '-64.3682000',
                'city' => 'Blockhouse',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4413000',
                'longitude' => '-64.3682000',
                'city' => 'Maitland Bridge',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6116000',
                'longitude' => '-61.3601000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6116000',
                'longitude' => '-61.3601000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E3L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6116000',
                'longitude' => '-61.3601000',
                'city' => 'West Bay Road',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6116000',
                'longitude' => '-61.3601000',
                'city' => 'Judique',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6116000',
                'longitude' => '-61.3601000',
                'city' => 'Cleveland',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6116000',
                'longitude' => '-61.3601000',
                'city' => 'Port Hawkesbury Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4413000',
                'longitude' => '-64.3682000',
                'city' => 'Western Shore',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A4A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4413000',
                'longitude' => '-64.3682000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1040000',
                'longitude' => '-63.8264000',
                'city' => 'Scotch Village',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1Z0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1040000',
                'longitude' => '-63.8264000',
                'city' => 'Mount Uniacke',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1040000',
                'longitude' => '-63.8264000',
                'city' => 'Upper Rawdon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1681000',
                'longitude' => '-64.1713000',
                'city' => 'Cheverie',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1681000',
                'longitude' => '-64.1713000',
                'city' => 'Caledonia',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1681000',
                'longitude' => '-64.1713000',
                'city' => 'Kemptville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1681000',
                'longitude' => '-64.1713000',
                'city' => 'Newport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Ingomar',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2T2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Shag Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Barrington',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Port Clyde',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Clyde River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Barrington Passage',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5662000',
                'longitude' => '-65.6452000',
                'city' => 'Cornwallis',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Y1X5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1428000',
                'longitude' => '-63.3476000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1428000',
                'longitude' => '-63.3476000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.1428000',
                'longitude' => '-63.3476000',
                'city' => 'West St Andrews',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0R1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0346000',
                'longitude' => '-64.7174000',
                'city' => 'New Germany',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0R1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5511000',
                'longitude' => '-64.7156000',
                'city' => 'Barss Corner',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Clarks Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Meteghan',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4A5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2Z0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Saulnierville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Pubnico',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Meteghan Centre',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Mavillette',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Meteghan River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A1L1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1946000',
                'longitude' => '-66.1602000',
                'city' => 'Meteghan',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4108000',
                'longitude' => '-63.7851000',
                'city' => 'Economy',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4108000',
                'longitude' => '-63.7851000',
                'city' => 'Bass River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8655000',
                'longitude' => '-65.9776000',
                'city' => 'Ste-anne-du-ruisseau',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M2L8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8655000',
                'longitude' => '-65.9776000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8655000',
                'longitude' => '-65.9776000',
                'city' => 'Tusket',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.9754000',
                'longitude' => '-66.1541000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.9754000',
                'longitude' => '-66.1541000',
                'city' => 'Port Maitland',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.9754000',
                'longitude' => '-66.1541000',
                'city' => 'South Ohio',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6Z3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1847000',
                'longitude' => '-62.5360000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9246000',
                'longitude' => '-62.3507000',
                'city' => 'Port Dufferin',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7013000',
                'longitude' => '-65.1169000',
                'city' => 'Lockeport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7013000',
                'longitude' => '-65.1169000',
                'city' => 'Osborne Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7013000',
                'longitude' => '-65.1169000',
                'city' => 'Lydgate',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7013000',
                'longitude' => '-65.1169000',
                'city' => 'Sable River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0L1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Northport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1K4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H2V3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H2Z4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1Y2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3X9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H2X2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H2J1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H2K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4239000',
                'longitude' => '-63.4609000',
                'city' => 'Belmont',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4239000',
                'longitude' => '-63.4609000',
                'city' => 'Londonderry',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N5B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4239000',
                'longitude' => '-63.4609000',
                'city' => 'Debert',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N5B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4239000',
                'longitude' => '-63.4609000',
                'city' => 'Debert',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7415000',
                'longitude' => '-65.9853000',
                'city' => 'Wedgeport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7415000',
                'longitude' => '-65.9853000',
                'city' => 'Lower Wedgeport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7415000',
                'longitude' => '-65.9853000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8491000',
                'longitude' => '-65.3033000',
                'city' => 'Hampton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H2A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H4B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H4A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3Y3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1Y9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H2J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3A6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H1Y1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3K4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4H3L5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8353000',
                'longitude' => '-64.2082000',
                'city' => 'Amherst',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.2151000',
                'longitude' => '-63.0019000',
                'city' => 'Brookfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.2151000',
                'longitude' => '-63.0019000',
                'city' => 'Upper Stewiacke',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3M1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2852000',
                'longitude' => '-60.4109000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.1401000',
                'longitude' => '-64.6522000',
                'city' => 'Port Medway',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3V8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1Y1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1J6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1K7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N2E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1H7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N2K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1Y2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N2B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N4R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3V7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N4K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N4K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N2C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N1K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1A5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4R1A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'Coldbrook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N4K8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3P7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3R4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3G3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3K4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N5H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N4W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3P9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3H2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N4A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0764000',
                'longitude' => '-64.5010000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3650000',
                'longitude' => '-65.0435000',
                'city' => 'Caledonia',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.3650000',
                'longitude' => '-65.0435000',
                'city' => 'South Brookfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0699000',
                'longitude' => '-64.1843000',
                'city' => 'Falmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0699000',
                'longitude' => '-64.1843000',
                'city' => 'Hantsport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0M1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6093000',
                'longitude' => '-63.9469000',
                'city' => 'Collingwood Corner',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.2926000',
                'longitude' => '-64.3613000',
                'city' => 'La Have',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7349000',
                'longitude' => '-64.4594000',
                'city' => 'New Ross',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5512000',
                'longitude' => '-65.7336000',
                'city' => 'Port Hood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5512000',
                'longitude' => '-65.7336000',
                'city' => 'Lower Woods Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9662000',
                'longitude' => '-60.7310000',
                'city' => 'Grand Narrows',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9244000',
                'longitude' => '-59.9918000',
                'city' => 'Louisbourg',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9244000',
                'longitude' => '-59.9918000',
                'city' => 'Louisbourg',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2X4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2M8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2K8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2R9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2L6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2N7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2P9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1X9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2X1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Newcastle',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V1B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1V2C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Sydney Mines',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1344000',
                'longitude' => '-59.8732000',
                'city' => 'Port Morien',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A5T9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1344000',
                'longitude' => '-59.8732000',
                'city' => 'Port Morien',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1344000',
                'longitude' => '-59.8732000',
                'city' => 'Port Morien',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.1344000',
                'longitude' => '-59.8732000',
                'city' => 'Port Morien',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4G4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A1E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Hebron',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2S7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2Y7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A1K3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A1K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2K9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2T5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4A6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4A8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2M7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.4425000',
                'longitude' => '-65.6350000',
                'city' => 'Mcgray',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.4425000',
                'longitude' => '-65.6350000',
                'city' => 'Stoney Island',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.4425000',
                'longitude' => '-65.6350000',
                'city' => 'North East Point',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.4425000',
                'longitude' => '-65.6350000',
                'city' => 'Clam Point',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4G3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A1Y4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A2Y8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A4C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A3H6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A3W4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.8330000',
                'longitude' => '-66.1244000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H4C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H4C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H3S2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1R8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H3S9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1K7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2J6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'Black Point',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H3Y5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H4R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1M7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2P8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H4S6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1S4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H4A6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H5E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9754000',
                'longitude' => '-61.1142000',
                'city' => 'River Denys',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0E2K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.9754000',
                'longitude' => '-61.1142000',
                'city' => 'Orangedale',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0079000',
                'longitude' => '-64.0187000',
                'city' => 'Ste Croix',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1E0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0079000',
                'longitude' => '-64.0187000',
                'city' => 'Centre Burlington',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0921000',
                'longitude' => '-63.4214000',
                'city' => 'Fletchers Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0921000',
                'longitude' => '-63.4214000',
                'city' => 'Shubenacadie',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0921000',
                'longitude' => '-63.4214000',
                'city' => 'Micmac',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N5H1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0921000',
                'longitude' => '-63.4214000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B5A1H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.0098000',
                'longitude' => '-65.9256000',
                'city' => 'Yarmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3S0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7023000',
                'longitude' => '-65.7852000',
                'city' => 'West Pubnico',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7023000',
                'longitude' => '-65.7852000',
                'city' => 'Lower West Pubnico',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7023000',
                'longitude' => '-65.7852000',
                'city' => 'Middle West Pubnico',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7023000',
                'longitude' => '-65.7852000',
                'city' => 'Lower East Pubnico',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9851000',
                'longitude' => '-64.9442000',
                'city' => 'Wilmot Station',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0P1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9851000',
                'longitude' => '-64.9442000',
                'city' => 'Auburn',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0S1N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9851000',
                'longitude' => '-64.9442000',
                'city' => 'Margaretsville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9851000',
                'longitude' => '-64.9442000',
                'city' => 'New Minas',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N3X9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9851000',
                'longitude' => '-64.9442000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4V2W2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.2995000',
                'longitude' => '-64.3161000',
                'city' => 'Riverport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.2995000',
                'longitude' => '-64.3161000',
                'city' => 'Rose Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.2995000',
                'longitude' => '-64.3161000',
                'city' => 'Riverport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Baccaro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3C0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Smithsville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Thomasville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Cape Negro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'East Baccaro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Upper Port La Tour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W2T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.5582000',
                'longitude' => '-65.5774000',
                'city' => 'Port La Tour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1Z0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.2590000',
                'longitude' => '-66.1270000',
                'city' => 'Little Brook',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8068000',
                'longitude' => '-62.7005000',
                'city' => 'Tangier',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8068000',
                'longitude' => '-62.7005000',
                'city' => 'Mooseland',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.0287000',
                'longitude' => '-62.0089000',
                'city' => 'Liscomb',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3781000',
                'longitude' => '-61.9751000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0H1M0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3781000',
                'longitude' => '-61.9751000',
                'city' => 'Goshen',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A1Y7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3P3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3R3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A2L9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A2P7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A2K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A1A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A1V1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3L7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'Newcastle',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A1Y6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A2G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3K4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A1B7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A1B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A3P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A2A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2A1A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2145000',
                'longitude' => '-60.2421000',
                'city' => 'North Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9913000',
                'longitude' => '-64.1332000',
                'city' => 'Newport Station',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4N4E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9913000',
                'longitude' => '-64.1332000',
                'city' => 'Kentville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9913000',
                'longitude' => '-64.1332000',
                'city' => 'Currys Corner',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3L0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6257000',
                'longitude' => '-63.9202000',
                'city' => 'French Village',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2N0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6257000',
                'longitude' => '-63.9202000',
                'city' => 'French Village',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K5L9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Upper Tantallon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3J1K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Upper Tantallon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Upper Tantallon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Upper Tantallon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Upper Tantallon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Stillwater Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Saint Margarets',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3B0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Sheet Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Upper Tantallon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1H3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Stillwater Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6858000',
                'longitude' => '-63.9161000',
                'city' => 'Upper Tantallon',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1H6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Z1P1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'East Lawrencetown',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1J4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1M1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Z1P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'East Lawrencetown',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1J1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1H7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7510000',
                'longitude' => '-63.2948000',
                'city' => 'Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1P6J4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.0228000',
                'longitude' => '-60.3585000',
                'city' => 'Sydney',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.0228000',
                'longitude' => '-60.3585000',
                'city' => 'Sydney Forks',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1L1E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.0228000',
                'longitude' => '-60.3585000',
                'city' => 'Portage',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lake Echo',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M2G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lake Echo',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Z1J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Mineville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Z1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Mineville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Z1J6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Mineville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1J6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4R7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2X1E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1K2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Z1J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Mineville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3L4J2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W1E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N1N6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1B7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3R1V2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A2X9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A2T3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A3X1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A3Z5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4B1G8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A2Z2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3N2K3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A4B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A3C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4B1G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A3M7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A1V5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A2T4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A2B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A2T6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3Z1H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Hammonds Plains',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A2X4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Bedford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4A3Y1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4182000',
                'longitude' => '-65.9937000',
                'city' => 'Belliveau Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0W3T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4182000',
                'longitude' => '-65.9937000',
                'city' => 'Weymouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0V1G0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.2728000',
                'longitude' => '-66.3179000',
                'city' => 'Tiverton',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0V1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.2728000',
                'longitude' => '-66.3179000',
                'city' => 'Westport',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A3M8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A4W6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A2R2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A4W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A2G8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A5B9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A3T4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A2P6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A5X1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A1K3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A3T8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A1N5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A1L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A3T5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A3M9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A1W6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A4T6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8169000',
                'longitude' => '-62.8877000',
                'city' => 'Head Of Jeddore',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8169000',
                'longitude' => '-62.8877000',
                'city' => 'Lake Charlotte',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8169000',
                'longitude' => '-62.8877000',
                'city' => 'Jeddore Oyster Ponds',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A1N4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A6E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A6E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A4A8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A3B9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A3X5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A2Z7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A5G3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A1E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A4Z6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A4A6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A1C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1A2J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2157000',
                'longitude' => '-59.9652000',
                'city' => 'Glace Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1T4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J3K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Prospect Road',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1S2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1S5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1S7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1T2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1Z5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Prospect Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Hatchet Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1S9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Hatchet Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1S6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1T9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1V2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Hatchet Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1Z4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Prospect Bay',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1T3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1V3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Hatchet Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1T1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1S3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1T8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1T5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.5504000',
                'longitude' => '-63.7640000',
                'city' => 'Brookside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6278000',
                'longitude' => '-64.0614000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Windsor Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1A5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fletchers Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Oakfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1B3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Oakfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Windsor Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1A2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Wellington',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Windsor Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1J4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Wellington',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N2V0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Waverley',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1H7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fletchers Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1J1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fletchers Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C4C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Lakeview',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1G1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Windsor Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Grand Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1G3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Windsor Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1A3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Wellington',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N5B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Waverley',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Fall River',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Windsor Junction',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H2E1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H2Y8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H2Z9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H3A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H1L1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H3C6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H4K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'Scotchtown',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H1N8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H4S9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H1N3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H4K2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H4G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H4C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H3R5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H1N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H1K2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H4G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H1B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'River Ryan',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B1H3J2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.2508000',
                'longitude' => '-60.0846000',
                'city' => 'New Waterford',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2V6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2V7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2W3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G1Z3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G1Y1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G1Z7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G1Y8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G1W5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G1P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2B9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2K8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2L1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4G1E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Beaver Bank',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3H3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E1P1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Beaver Bank',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3G9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C1A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4G1E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Beaver Bank',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E1R8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E2X2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4G1E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Beaver Bank',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C4C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4G1C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Beaver Bank',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2S6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E3A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Middle Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E3C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Upper Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E3B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Middle Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E3B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Middle Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E3B8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Middle Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2K3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E3B6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Middle Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2Y8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C1X1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2S7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C3H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C1N2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2A1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G1M8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2G2K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.6178000',
                'longitude' => '-61.9856000',
                'city' => 'Antigonish',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1K5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Ketch Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1X0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Ketch Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Sambro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J2Y0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Ketch Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Bear Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Portuguese Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1G1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Sambro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Williamswood',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1K6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Ketch Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1K7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Ketch Harbour',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1K2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Portuguese Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1E9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Sambro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1J9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Portuguese Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1L4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Sambro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1L5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Sambro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1L6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Sambro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1H4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Herring Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3V1K4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.4849000',
                'longitude' => '-63.5592000',
                'city' => 'Duncans Cove',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E2H1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E1S1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2S8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E3A4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E2V9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E2R2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E1R6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E1K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Beaver Bank',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4E1G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B4C2R1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7912000',
                'longitude' => '-63.7203000',
                'city' => 'Lower Sackville',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3P1S3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1K2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3K2Y5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3B1P6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1E4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Goffs',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Waverley',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1K3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.8198000',
                'longitude' => '-63.6052000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0T1J0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '43.7669000',
                'longitude' => '-65.3256000',
                'city' => 'Jordan Falls',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1B1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Lakeside',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1G8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1G5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1J7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1E8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1G4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1B9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1E5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1G1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1G3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1C2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1J6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0J1Z0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3T1H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.6524000',
                'longitude' => '-63.5823000',
                'city' => 'Timberlea',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3M4A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Halifax',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2W3Y2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Dartmouth',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1J8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1A7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0N1R0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Elmsdale',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Elmsdale',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1C1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2T1E2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.9753000',
                'longitude' => '-63.5190000',
                'city' => 'Enfield',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0A1K0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.8437000',
                'longitude' => '-60.1327000',
                'city' => 'Gabarus',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B3E1L6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7921000',
                'longitude' => '-63.1530000',
                'city' => 'West Porters Lake',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2Z1L2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '44.7921000',
                'longitude' => '-63.1530000',
                'city' => 'Lawrencetown',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N1G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N5A9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2R9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N3W4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N1E6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N4Z9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2V4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N3H9',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N6L2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N5B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N6P4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2B2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N1L3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N4Z6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N5N6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2T7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2V5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N3J5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N1G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2B5',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N4H2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N3M6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N1G6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N1H8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N6P8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N6K1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N4B4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N4N3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N3M8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N4N4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2S7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N3Z6',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N2J3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2N4G7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.3576000',
                'longitude' => '-63.2814000',
                'city' => 'Truro',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H5C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5570000',
                'longitude' => '-62.5572000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1P0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5570000',
                'longitude' => '-62.5572000',
                'city' => 'Salt Springs',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H5G2',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5570000',
                'longitude' => '-62.5572000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1W0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5570000',
                'longitude' => '-62.5572000',
                'city' => 'Thorburn',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2T8',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4602000',
                'longitude' => '-62.7119000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1T0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.4602000',
                'longitude' => '-62.7119000',
                'city' => 'Sunnybrae',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1A0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5925000',
                'longitude' => '-62.2691000',
                'city' => 'Barneys River Station',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0K1Z0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5431000',
                'longitude' => '-62.8954000',
                'city' => 'West River Station',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H3S4',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1T3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2E7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H3C7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H3T7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H1L7',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H4W3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2E3',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B2H2R1',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '45.5828000',
                'longitude' => '-62.6400000',
                'city' => 'New Glasgow',
                'full_state' => 'Nova Scotia',
            ],
            [
                'zip' => 'B0C1H0',
                'country_code' => 'CA',
                'state' => 'NS',
                'latitude' => '46.3097000',
                'longitude' => '-60.6253000',
                'city' => 'Englishtown',
                'full_state' => 'Nova Scotia',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
