<?php

namespace Database\Seeders\ImmutableData\CAZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NewfoundlandandLabradorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => 'A0K5R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7918000',
                'longitude' => '-56.6341000',
                'city' => 'Westport',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.5241000',
                'longitude' => '-57.3922000',
                'city' => 'River Of Ponds',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Freshwater Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Placentia',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Dunville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Jerseyside',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Fox Harbour Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Ship Harbour Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Garden Cove Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2607000',
                'longitude' => '-53.9836000',
                'city' => 'Winterland',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4337000',
                'longitude' => '-53.8129000',
                'city' => 'Mount Arlington Heights',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4337000',
                'longitude' => '-53.8129000',
                'city' => 'Long Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Chapel Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Harbour Main',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Bay Roberts',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Holyrood',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Harbour Main',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2C1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C3K3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Woodfords',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Brigus Junction',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Colliers Riverhead',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Avondale',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Conception Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'APA2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4254000',
                'longitude' => '-53.1750000',
                'city' => 'Harbour Main',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5421000',
                'longitude' => '-54.5294000',
                'city' => 'Stoneville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5421000',
                'longitude' => '-54.5294000',
                'city' => 'Port Albert',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9198000',
                'longitude' => '-57.8091000',
                'city' => 'Parsons Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9198000',
                'longitude' => '-57.8091000',
                'city' => 'St Pauls',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9198000',
                'longitude' => '-57.8091000',
                'city' => 'Cow Head',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4022000',
                'longitude' => '-54.8570000',
                'city' => 'Lewisporte',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4022000',
                'longitude' => '-54.8570000',
                'city' => 'Comfort Cove-newstead',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6362000',
                'longitude' => '-54.8821000',
                'city' => 'English Harbour East',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.0580000',
                'longitude' => '-56.9276000',
                'city' => 'Plum Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.0580000',
                'longitude' => '-56.9276000',
                'city' => 'Bird Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.0580000',
                'longitude' => '-56.9276000',
                'city' => 'Pound Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.0580000',
                'longitude' => '-56.9276000',
                'city' => 'Reefs Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.0580000',
                'longitude' => '-56.9276000',
                'city' => 'St. Anthony',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.5992000',
                'longitude' => '-57.1737000',
                'city' => 'Hawkes Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.6030000',
                'longitude' => '-55.8743000',
                'city' => 'Cooks Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.6030000',
                'longitude' => '-55.8743000',
                'city' => 'Boat Harbour West',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9853000',
                'longitude' => '-55.8773000',
                'city' => 'Woodstock',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9853000',
                'longitude' => '-55.8773000',
                'city' => 'Pacquet',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7511000',
                'longitude' => '-56.0249000',
                'city' => 'Middle Arm Gb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7511000',
                'longitude' => '-56.0249000',
                'city' => 'Burlington',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.1255000',
                'longitude' => '-56.1297000',
                'city' => 'Coachmans Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.1255000',
                'longitude' => '-56.1297000',
                'city' => 'Fleur De Lys',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9786000',
                'longitude' => '-56.0420000',
                'city' => 'Mings Bight',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7929000',
                'longitude' => '-55.8600000',
                'city' => 'Nippers Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2P8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1B3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1B4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2G1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Benton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1B7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1W2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2H9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2J9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1G4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2B7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1R3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1H6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1Z3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1E7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1A6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1M7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1A8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1422000',
                'longitude' => '-55.3469000',
                'city' => 'Botwood',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H2A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1422000',
                'longitude' => '-55.3469000',
                'city' => 'Point Of Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1422000',
                'longitude' => '-55.3469000',
                'city' => 'Peterview',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1422000',
                'longitude' => '-55.3469000',
                'city' => 'Hillview',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1422000',
                'longitude' => '-55.3469000',
                'city' => 'Bishops Falls',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.2831000',
                'longitude' => '-54.9328000',
                'city' => 'Loon Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.2831000',
                'longitude' => '-54.9328000',
                'city' => 'Campbellton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5335000',
                'longitude' => '-55.6041000',
                'city' => 'Brighton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5335000',
                'longitude' => '-55.6041000',
                'city' => 'Triton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0T1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.6175000',
                'longitude' => '-55.6830000',
                'city' => 'Beaumont',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.6175000',
                'longitude' => '-55.6830000',
                'city' => 'Beaumont',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4993000',
                'longitude' => '-54.2137000',
                'city' => 'Charlottetown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7102000',
                'longitude' => '-54.2891000',
                'city' => 'Island Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7102000',
                'longitude' => '-54.2891000',
                'city' => 'Fogo',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7102000',
                'longitude' => '-54.2891000',
                'city' => 'Deep Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5985000',
                'longitude' => '-55.9487000',
                'city' => 'Little Bay Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5985000',
                'longitude' => '-55.9487000',
                'city' => 'Little Bay Ndb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5985000',
                'longitude' => '-55.9487000',
                'city' => 'Little Bay Islands',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5832000',
                'longitude' => '-56.1832000',
                'city' => 'Rattling Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5832000',
                'longitude' => '-56.1832000',
                'city' => 'Kings Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0659000',
                'longitude' => '-53.5641000',
                'city' => 'Greenspond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.1689000',
                'longitude' => '-55.1515000',
                'city' => 'Marystown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.1689000',
                'longitude' => '-55.1515000',
                'city' => 'Creston',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.1689000',
                'longitude' => '-55.1515000',
                'city' => 'Rocky Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.1689000',
                'longitude' => '-55.1515000',
                'city' => 'Creston North',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1Z6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2H7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2K3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2K5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2V2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0R1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Wabush',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2T5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1W9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5910000',
                'longitude' => '-57.0965000',
                'city' => 'Grey River',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9925000',
                'longitude' => '-56.3436000',
                'city' => 'Wild Cove Wb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Tors Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Mobile',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Parkers Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Bell Island',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1E6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4C1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4S8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1S1G7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Goulds',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Witless Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2838000',
                'longitude' => '-52.8357000',
                'city' => 'Bay Bulls',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1C8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7648000',
                'longitude' => '-52.7624000',
                'city' => 'Flatrock',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7648000',
                'longitude' => '-52.7624000',
                'city' => 'Shoe Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7648000',
                'longitude' => '-52.7624000',
                'city' => 'Pouch Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4N7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7648000',
                'longitude' => '-52.7624000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7648000',
                'longitude' => '-52.7624000',
                'city' => 'Pouch Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7648000',
                'longitude' => '-52.7624000',
                'city' => 'Bauline',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1E4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7648000',
                'longitude' => '-52.7624000',
                'city' => 'Pouch Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.9593000',
                'longitude' => '-54.1537000',
                'city' => 'St Brides',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1A1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8862000',
                'longitude' => '-53.9906000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8862000',
                'longitude' => '-53.9906000',
                'city' => 'Branch',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5758000',
                'longitude' => '-54.4286000',
                'city' => 'Monkstown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.9675000',
                'longitude' => '-52.9590000',
                'city' => 'Cappahayden',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.9675000',
                'longitude' => '-52.9590000',
                'city' => 'Fermeuse',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.9675000',
                'longitude' => '-52.9590000',
                'city' => 'Cape Broyle',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.9675000',
                'longitude' => '-52.9590000',
                'city' => 'Aquaforte',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.9675000',
                'longitude' => '-52.9590000',
                'city' => 'Renews',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.9675000',
                'longitude' => '-52.9590000',
                'city' => 'Ferryland',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1G1M2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N3J5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2Y7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4N7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4S2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1G1G8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N3K6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2L8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2E2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2M3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4M4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1G1G3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4N1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2N7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4N8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2N9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1G1G7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2C5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2J4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1G1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1L1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1V7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1A8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2C6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2E3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1B6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2H2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2L6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Petty Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E3W4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N2B5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2K6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2P5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2Y2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.1020000',
                'longitude' => '-55.7507000',
                'city' => 'St Juliens',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.1020000',
                'longitude' => '-55.7507000',
                'city' => 'Croque',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1747000',
                'longitude' => '-53.9632000',
                'city' => 'Clarenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4015000',
                'longitude' => '-54.6753000',
                'city' => 'Petit Forte',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4015000',
                'longitude' => '-54.6753000',
                'city' => 'Petit Forte',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0890000',
                'longitude' => '-52.9563000',
                'city' => 'Brigus',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0890000',
                'longitude' => '-52.9563000',
                'city' => 'Calvert',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1A4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1A5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1E3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1A6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1C6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Flatrock',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1A9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1B4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1A1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1K1A2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6492000',
                'longitude' => '-52.7307000',
                'city' => 'Torbay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.7315000',
                'longitude' => '-53.4163000',
                'city' => 'Trepassey',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.7315000',
                'longitude' => '-53.4163000',
                'city' => 'St Shotts',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6269000',
                'longitude' => '-53.7337000',
                'city' => 'Bellevue',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.3514000',
                'longitude' => '-54.9163000',
                'city' => 'Baine Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.3514000',
                'longitude' => '-54.9163000',
                'city' => 'Red Harbour Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.3514000',
                'longitude' => '-54.9163000',
                'city' => 'Rushoon',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5938000',
                'longitude' => '-53.1875000',
                'city' => 'Newmans Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5695000',
                'longitude' => '-53.3320000',
                'city' => 'Kings Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5695000',
                'longitude' => '-53.3320000',
                'city' => 'Keels',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5695000',
                'longitude' => '-53.3320000',
                'city' => 'Duntara',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5695000',
                'longitude' => '-53.3320000',
                'city' => 'Knights Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4846000',
                'longitude' => '-58.1275000',
                'city' => 'Trout River',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.5584000',
                'longitude' => '-55.7321000',
                'city' => 'Raleigh',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5022000',
                'longitude' => '-57.9196000',
                'city' => 'Birchy Head',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5022000',
                'longitude' => '-57.9196000',
                'city' => 'Woody Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5022000',
                'longitude' => '-57.9196000',
                'city' => 'Bonne Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.3696000',
                'longitude' => '-55.5917000',
                'city' => 'Saint Anthony',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.3696000',
                'longitude' => '-55.5917000',
                'city' => 'St Anthony East',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5426000',
                'longitude' => '-56.8598000',
                'city' => 'Hampden',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.3030000',
                'longitude' => '-56.7337000',
                'city' => 'Anchor Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.3030000',
                'longitude' => '-56.7337000',
                'city' => 'Sandy Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.3030000',
                'longitude' => '-56.7337000',
                'city' => 'Flowers Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.8654000',
                'longitude' => '-56.1331000',
                'city' => 'Bide Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.8654000',
                'longitude' => '-56.1331000',
                'city' => 'Roddickton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5932000',
                'longitude' => '-57.9207000',
                'city' => 'Norris Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5932000',
                'longitude' => '-57.9207000',
                'city' => 'Sallys Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.8666000',
                'longitude' => '-56.7771000',
                'city' => 'Jacksons Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6817000',
                'longitude' => '-53.8243000',
                'city' => 'Chance Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5518000',
                'longitude' => '-54.8834000',
                'city' => 'St Bernards-jacques Fontaine',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5518000',
                'longitude' => '-54.8834000',
                'city' => 'Harbour Mille',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5518000',
                'longitude' => '-54.8834000',
                'city' => 'Little Bay East',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5518000',
                'longitude' => '-54.8834000',
                'city' => 'Bay Largent',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4179000',
                'longitude' => '-53.5944000',
                'city' => 'Charleston',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4179000',
                'longitude' => '-53.5944000',
                'city' => 'Princeton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4179000',
                'longitude' => '-53.5944000',
                'city' => 'Sweet Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4179000',
                'longitude' => '-53.5944000',
                'city' => 'Summerville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4179000',
                'longitude' => '-53.5944000',
                'city' => 'Southern Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2C7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7757000',
                'longitude' => '-53.9792000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7757000',
                'longitude' => '-53.9792000',
                'city' => 'Come By Chance',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7757000',
                'longitude' => '-53.9792000',
                'city' => 'Arnolds Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7757000',
                'longitude' => '-53.9792000',
                'city' => 'Arnolds Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7757000',
                'longitude' => '-53.9792000',
                'city' => 'Sunnyside',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7757000',
                'longitude' => '-53.9792000',
                'city' => 'Southern Harbour Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4S9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.3944000',
                'longitude' => '-53.3331000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.3944000',
                'longitude' => '-53.3331000',
                'city' => 'Port Rexton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.3944000',
                'longitude' => '-53.3331000',
                'city' => 'Trinity Tb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6503000',
                'longitude' => '-53.9329000',
                'city' => 'Little Harbour East Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3N9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1747000',
                'longitude' => '-53.9632000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3P9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1747000',
                'longitude' => '-53.9632000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1747000',
                'longitude' => '-53.9632000',
                'city' => 'Lethbridge',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0EAJ0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1747000',
                'longitude' => '-53.9632000',
                'city' => 'Clarenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1747000',
                'longitude' => '-53.9632000',
                'city' => 'Clarenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1747000',
                'longitude' => '-53.9632000',
                'city' => 'Bloomfield',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4091000',
                'longitude' => '-53.8877000',
                'city' => 'Bunyans Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4091000',
                'longitude' => '-53.8877000',
                'city' => 'Cannings Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4091000',
                'longitude' => '-53.8877000',
                'city' => 'Burgoynes Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4091000',
                'longitude' => '-53.8877000',
                'city' => 'Musgravetown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0CAB0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6496000',
                'longitude' => '-53.1146000',
                'city' => 'Bonavista',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6496000',
                'longitude' => '-53.1146000',
                'city' => 'Bonavista',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6496000',
                'longitude' => '-53.1146000',
                'city' => 'Elliston',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5182000',
                'longitude' => '-53.0814000',
                'city' => 'Port Union',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5182000',
                'longitude' => '-53.0814000',
                'city' => 'Melrose',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5182000',
                'longitude' => '-53.0814000',
                'city' => 'Catalina',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5182000',
                'longitude' => '-53.0814000',
                'city' => 'Little Catalina',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.4678000',
                'longitude' => '-55.7530000',
                'city' => 'Black Tickle',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.3839000',
                'longitude' => '-56.5763000',
                'city' => 'Green Island Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.3839000',
                'longitude' => '-56.5763000',
                'city' => 'Green Island Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '55.8742000',
                'longitude' => '-60.8585000',
                'city' => 'Natuashish',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '54.9074000',
                'longitude' => '-59.7749000',
                'city' => 'Postville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7757000',
                'longitude' => '-56.8792000',
                'city' => 'Sops Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7757000',
                'longitude' => '-56.8792000',
                'city' => 'Pollards Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4595000',
                'longitude' => '-55.4481000',
                'city' => 'Point Leamington',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4595000',
                'longitude' => '-55.4481000',
                'city' => 'Leading Tickles',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4910000',
                'longitude' => '-55.2807000',
                'city' => 'Cottrells Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6412000',
                'longitude' => '-52.9420000',
                'city' => 'Lance Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2S9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6412000',
                'longitude' => '-52.9420000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6412000',
                'longitude' => '-52.9420000',
                'city' => 'Bell Island Front',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2B1J6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2J2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2S6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2S4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2N7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2K8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1C6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2K9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2B1G3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1L3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2S5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1W1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1W5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1W4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2B1B1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1W3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1Y4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2L2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H2H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A1V9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9268000',
                'longitude' => '-55.6581000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6002000',
                'longitude' => '-58.1433000',
                'city' => 'Grand Bruit',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6844000',
                'longitude' => '-58.3984000',
                'city' => 'La Poile',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.5338000',
                'longitude' => '-60.1548000',
                'city' => 'North West River',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.1421000',
                'longitude' => '-53.4631000',
                'city' => 'Mount Carmel',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.1421000',
                'longitude' => '-53.4631000',
                'city' => 'Colinet',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8919000',
                'longitude' => '-53.6014000',
                'city' => 'St Vincents',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8919000',
                'longitude' => '-53.6014000',
                'city' => 'St Marys',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5330000',
                'longitude' => '-53.2241000',
                'city' => 'Cupids',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5330000',
                'longitude' => '-53.2241000',
                'city' => 'Marysvale',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5330000',
                'longitude' => '-53.2241000',
                'city' => 'Clarkes Beach',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5330000',
                'longitude' => '-53.2241000',
                'city' => 'South River',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5330000',
                'longitude' => '-53.2241000',
                'city' => 'Hearts Delight',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3172000',
                'longitude' => '-53.6098000',
                'city' => 'Deadmans Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3172000',
                'longitude' => '-53.6098000',
                'city' => 'Cape Freels North',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3172000',
                'longitude' => '-53.6098000',
                'city' => 'Lumsden',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9422000',
                'longitude' => '-56.3887000',
                'city' => 'Seal Cove Wb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9262000',
                'longitude' => '-56.1942000',
                'city' => 'Baie Verte',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6748000',
                'longitude' => '-54.0320000',
                'city' => 'Glovertown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2A2J3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6748000',
                'longitude' => '-54.0320000',
                'city' => 'Grand Falls-windsor',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6748000',
                'longitude' => '-54.0320000',
                'city' => 'Glovertown South',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6748000',
                'longitude' => '-54.0320000',
                'city' => 'Traytown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4010000',
                'longitude' => '-54.2945000',
                'city' => 'Frederickton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4010000',
                'longitude' => '-54.2945000',
                'city' => 'Wesleyville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4010000',
                'longitude' => '-54.2945000',
                'city' => 'Carmanville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.2491000',
                'longitude' => '-55.0601000',
                'city' => 'Embree',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.2491000',
                'longitude' => '-55.0601000',
                'city' => 'Little Burnt Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1508000',
                'longitude' => '-53.5691000',
                'city' => 'Templeman',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1508000',
                'longitude' => '-53.5691000',
                'city' => 'Badger',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1508000',
                'longitude' => '-53.5691000',
                'city' => 'Badgers Quay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1508000',
                'longitude' => '-53.5691000',
                'city' => 'Pools Island',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1508000',
                'longitude' => '-53.5691000',
                'city' => 'Newtown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1508000',
                'longitude' => '-53.5691000',
                'city' => 'Brookfield',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.8573000',
                'longitude' => '-54.0064000',
                'city' => 'Dover',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.8573000',
                'longitude' => '-54.0064000',
                'city' => 'Hare Bay Bb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H2E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8650000',
                'longitude' => '-55.9240000',
                'city' => 'St Albans',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.3576000',
                'longitude' => '-54.1651000',
                'city' => 'Port Blandford',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5275000',
                'longitude' => '-53.4904000',
                'city' => 'Plate Cove West',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5275000',
                'longitude' => '-53.4904000',
                'city' => 'Open Hall',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5275000',
                'longitude' => '-53.4904000',
                'city' => 'Tickle Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C2C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5275000',
                'longitude' => '-53.4904000',
                'city' => 'Plate Cove East',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0338000',
                'longitude' => '-53.9247000',
                'city' => 'North West Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1109000',
                'longitude' => '-53.7316000',
                'city' => 'Hickmans Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0C1X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1109000',
                'longitude' => '-53.7316000',
                'city' => 'Hickmans Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0191000',
                'longitude' => '-53.6830000',
                'city' => 'Hodges Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0191000',
                'longitude' => '-53.6830000',
                'city' => 'Gooseberry Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0191000',
                'longitude' => '-53.6830000',
                'city' => 'Little Hearts Ease',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8499000',
                'longitude' => '-54.1540000',
                'city' => 'North Harbour Pb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8499000',
                'longitude' => '-54.1540000',
                'city' => 'Swift Current',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6K4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1G4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1B6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4A4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1B3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3R6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Z3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4X7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4X5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Y7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Z5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5A1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Z6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4X6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1E7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1E6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Y2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4X1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1G7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Y9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Y6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1E9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5G9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Y1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E3E7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1S3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E3H7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1C6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E3H1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1T1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C4V7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1Z9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1A8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4G3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6E9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6E4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2H5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2A2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4L8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1V3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6C9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2Z6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1T3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2J9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5760000',
                'longitude' => '-53.5453000',
                'city' => 'Greens Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5760000',
                'longitude' => '-53.5453000',
                'city' => 'New Harbour Tb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5760000',
                'longitude' => '-53.5453000',
                'city' => 'South Dildo',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5760000',
                'longitude' => '-53.5453000',
                'city' => 'Dildo',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5760000',
                'longitude' => '-53.5453000',
                'city' => 'Hopeall',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5760000',
                'longitude' => '-53.5453000',
                'city' => 'Old Shop',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8945000',
                'longitude' => '-53.3727000',
                'city' => 'Winterton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8945000',
                'longitude' => '-53.3727000',
                'city' => 'New Perlican',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8945000',
                'longitude' => '-53.3727000',
                'city' => 'Turks Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8945000',
                'longitude' => '-53.3727000',
                'city' => 'Hearts Content',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9826000',
                'longitude' => '-53.0050000',
                'city' => 'Northern Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9826000',
                'longitude' => '-53.0050000',
                'city' => 'Jobs Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9826000',
                'longitude' => '-53.0050000',
                'city' => 'Burnt Point Bdv',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2B7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9826000',
                'longitude' => '-53.0050000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9826000',
                'longitude' => '-53.0050000',
                'city' => 'Lower Island Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0241000',
                'longitude' => '-53.2162000',
                'city' => 'Brownsdale',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0241000',
                'longitude' => '-53.2162000',
                'city' => 'New Melbourne',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0241000',
                'longitude' => '-53.2162000',
                'city' => 'Hants Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.0241000',
                'longitude' => '-53.2162000',
                'city' => 'New Chelsea',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1069000',
                'longitude' => '-52.9122000',
                'city' => 'Bay De Verde',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1069000',
                'longitude' => '-52.9122000',
                'city' => 'Grates Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1069000',
                'longitude' => '-52.9122000',
                'city' => 'Red Head Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1069000',
                'longitude' => '-52.9122000',
                'city' => 'Western Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.1069000',
                'longitude' => '-52.9122000',
                'city' => 'Old Perlican',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7698000',
                'longitude' => '-53.4742000',
                'city' => 'Cavendish',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7698000',
                'longitude' => '-53.4742000',
                'city' => 'Whiteway',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7698000',
                'longitude' => '-53.4742000',
                'city' => 'Hearts Desire',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7698000',
                'longitude' => '-53.4742000',
                'city' => 'Islington',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6416000',
                'longitude' => '-53.2146000',
                'city' => 'Harbour Grace',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6416000',
                'longitude' => '-53.2146000',
                'city' => 'Upper Island Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6416000',
                'longitude' => '-53.2146000',
                'city' => 'Spaniards Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5519000',
                'longitude' => '-53.6621000',
                'city' => 'Chapel Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B2T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5519000',
                'longitude' => '-53.6621000',
                'city' => 'Normans Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1C3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1B7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Salmon Cove Bdv',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1B5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1B6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Riverhead Harbour Grace',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1B1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1B3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Victoria Cb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.7143000',
                'longitude' => '-53.2228000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8559000',
                'longitude' => '-53.0981000',
                'city' => 'Ochre Pit Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8559000',
                'longitude' => '-53.0981000',
                'city' => 'Broad Cove Bdv',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.6762000',
                'longitude' => '-54.4082000',
                'city' => 'Change Islands',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.8931000',
                'longitude' => '-55.8997000',
                'city' => 'Conche',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.5266000',
                'longitude' => '-55.4664000',
                'city' => 'St Lunaire-griquet',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7002000',
                'longitude' => '-55.9238000',
                'city' => 'Jacksons Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7002000',
                'longitude' => '-55.9238000',
                'city' => 'Harrys Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5239000',
                'longitude' => '-57.3915000',
                'city' => 'Ramea',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.6161000',
                'longitude' => '-54.1743000',
                'city' => 'Stag Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.6161000',
                'longitude' => '-54.1743000',
                'city' => 'Seldom',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5776000',
                'longitude' => '-54.6981000',
                'city' => 'Hillgrade',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5776000',
                'longitude' => '-54.6981000',
                'city' => 'Herring Neck',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4912000',
                'longitude' => '-54.9134000',
                'city' => 'Summerford',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4912000',
                'longitude' => '-54.9134000',
                'city' => 'Cottlesville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4912000',
                'longitude' => '-54.9134000',
                'city' => 'Carters Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H7K4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4S7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4S8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6Y2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6T6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6A2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4S2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6W3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4P6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4P7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4T3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6R6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6T5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H7J3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H7J2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5Y7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6V4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6W4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5Y8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6N6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6L8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3B1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4X2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6S4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2P3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4X8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6Y5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H7E1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H7C9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2K9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4B5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6S5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6A3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2Y6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2N2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5L8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5Z9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1685000',
                'longitude' => '-57.4319000',
                'city' => 'Blaketown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1685000',
                'longitude' => '-57.4319000',
                'city' => 'Howley',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6M8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1685000',
                'longitude' => '-57.4319000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6C3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.1685000',
                'longitude' => '-57.4319000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6C9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H1E9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6V8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3C5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6H6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2Z3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H1C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5M7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4B4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4W6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5M6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6E3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H7K6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6J7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2P8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2T7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4M6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4C8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2S1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4M5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3A9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4P3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6A1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4N4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4P4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6A6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N2E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6263000',
                'longitude' => '-58.9765000',
                'city' => 'West Bay Centre',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6263000',
                'longitude' => '-58.9765000',
                'city' => 'Lourdes',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6263000',
                'longitude' => '-58.9765000',
                'city' => 'Port Au Port',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6263000',
                'longitude' => '-58.9765000',
                'city' => 'Black Duck Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1T1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2E9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2X7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Kippens',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2T5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2X2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1A4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Kippens',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2W1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N3R6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1J3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2T3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2T1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N3C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2V1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2T7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2S4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1B8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Kippens',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1R9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1B6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Kippens',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2W9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5405000',
                'longitude' => '-58.5940000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5008000',
                'longitude' => '-59.1287000',
                'city' => 'Cape St George',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.2340000',
                'longitude' => '-58.8324000',
                'city' => 'St Davids',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.2340000',
                'longitude' => '-58.8324000',
                'city' => 'Jeffreys',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.2340000',
                'longitude' => '-58.8324000',
                'city' => 'Highlands',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.2340000',
                'longitude' => '-58.8324000',
                'city' => 'Cartyville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.2340000',
                'longitude' => '-58.8324000',
                'city' => 'Heatherton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.2340000',
                'longitude' => '-58.8324000',
                'city' => 'Robinsons',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.2340000',
                'longitude' => '-58.8324000',
                'city' => 'St Fintans',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1S3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2M3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2H5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2A5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1H2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2S1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N2C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville Crossing',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1G1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1S4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1H5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1H8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1H6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1H7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2R9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stpnvlcrsg',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Barachois Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2R3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N1T4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5016000',
                'longitude' => '-58.4321000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4232000',
                'longitude' => '-58.5010000',
                'city' => 'St Georges',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5573000',
                'longitude' => '-58.6901000',
                'city' => 'Aguathuna',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N3R7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.5573000',
                'longitude' => '-58.6901000',
                'city' => 'Kippens',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2P5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2E9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1M9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2L6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2N5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2H2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1X5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1S2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V2B1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1V1M6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9500000',
                'longitude' => '-54.5588000',
                'city' => 'Gander',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4947000',
                'longitude' => '-55.8079000',
                'city' => 'Roberts Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4947000',
                'longitude' => '-55.8079000',
                'city' => 'Pilleys Island',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4947000',
                'longitude' => '-55.8079000',
                'city' => 'Port Anson',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4947000',
                'longitude' => '-55.8079000',
                'city' => 'Miles Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0925000',
                'longitude' => '-55.2671000',
                'city' => 'Norris Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.2607000',
                'longitude' => '-55.1729000',
                'city' => 'Laurenceton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4533000',
                'longitude' => '-53.9501000',
                'city' => 'Boyds Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4533000',
                'longitude' => '-53.9501000',
                'city' => 'Musgrave Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4259000',
                'longitude' => '-56.0823000',
                'city' => 'Springdale',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0J1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4259000',
                'longitude' => '-56.0823000',
                'city' => 'South Brook Gb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7187000',
                'longitude' => '-54.1656000',
                'city' => 'Joe Batts Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.7187000',
                'longitude' => '-54.1656000',
                'city' => 'Tilting',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3608000',
                'longitude' => '-54.7255000',
                'city' => 'Baytona',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3608000',
                'longitude' => '-54.7255000',
                'city' => 'Birchy Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9238000',
                'longitude' => '-55.7172000',
                'city' => 'Brents Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9238000',
                'longitude' => '-55.7172000',
                'city' => 'Snooks Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9238000',
                'longitude' => '-55.7172000',
                'city' => 'Harbour Round',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6674000',
                'longitude' => '-54.7208000',
                'city' => 'Terrenceville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6674000',
                'longitude' => '-54.7208000',
                'city' => 'Grand Le Pierre',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.4348000',
                'longitude' => '-54.0054000',
                'city' => 'Charlottetown Lab',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6741000',
                'longitude' => '-55.4329000',
                'city' => 'Pools Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.8653000',
                'longitude' => '-53.6659000',
                'city' => 'Shalloway Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.8653000',
                'longitude' => '-53.6659000',
                'city' => 'St Brendans',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4757000',
                'longitude' => '-54.0659000',
                'city' => 'Ladle Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4757000',
                'longitude' => '-54.0659000',
                'city' => 'Aspen Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.4573000',
                'longitude' => '-54.5234000',
                'city' => 'Horwood',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.8248000',
                'longitude' => '-56.8573000',
                'city' => 'Buchans',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.7746000',
                'longitude' => '-54.2136000',
                'city' => 'Gambo',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.9585000',
                'longitude' => '-55.5884000',
                'city' => 'La Scie',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3014000',
                'longitude' => '-54.4925000',
                'city' => 'Gander Bay South',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3014000',
                'longitude' => '-54.4925000',
                'city' => 'Gander Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3014000',
                'longitude' => '-54.4925000',
                'city' => 'Wings Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3014000',
                'longitude' => '-54.4925000',
                'city' => 'Rodgers Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3014000',
                'longitude' => '-54.4925000',
                'city' => 'Main Point',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.3014000',
                'longitude' => '-54.4925000',
                'city' => 'Victoria Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6505000',
                'longitude' => '-53.7498000',
                'city' => 'Salvage',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6505000',
                'longitude' => '-53.7498000',
                'city' => 'Eastport',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6505000',
                'longitude' => '-53.7498000',
                'city' => 'Burnside',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6505000',
                'longitude' => '-53.7498000',
                'city' => 'Sandringham',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.6505000',
                'longitude' => '-53.7498000',
                'city' => 'St Chads',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0102000',
                'longitude' => '-53.8920000',
                'city' => 'Trinity Bb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0102000',
                'longitude' => '-53.8920000',
                'city' => 'Indian Bay Bb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0102000',
                'longitude' => '-53.8920000',
                'city' => 'Wareham-centreville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G2K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9906000',
                'longitude' => '-54.8741000',
                'city' => 'Glenwood',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0926000',
                'longitude' => '-58.3878000',
                'city' => 'York Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0926000',
                'longitude' => '-58.3878000',
                'city' => 'Lark Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4S2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Saint Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6K1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1G5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5689000',
                'longitude' => '-54.8664000',
                'city' => 'Bridgeport',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5689000',
                'longitude' => '-54.8664000',
                'city' => 'Valley Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5689000',
                'longitude' => '-54.8664000',
                'city' => 'Tizzards Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G3H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.5689000',
                'longitude' => '-54.8664000',
                'city' => 'Moretons Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1P4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H7G5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0160000',
                'longitude' => '-57.6245000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0160000',
                'longitude' => '-57.6245000',
                'city' => 'Englee',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0160000',
                'longitude' => '-57.6245000',
                'city' => 'Pasadena',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2Z5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0160000',
                'longitude' => '-57.6245000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5V7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0160000',
                'longitude' => '-57.6245000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5V6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0160000',
                'longitude' => '-57.6245000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5V5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0160000',
                'longitude' => '-57.6245000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0762000',
                'longitude' => '-58.1170000',
                'city' => 'Coxs Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5779000',
                'longitude' => '-59.1338000',
                'city' => 'Port Au Choix',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2Z4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5779000',
                'longitude' => '-59.1338000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5779000',
                'longitude' => '-59.1338000',
                'city' => 'Channel-port-aux-basques',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5779000',
                'longitude' => '-59.1338000',
                'city' => 'Epworth',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5779000',
                'longitude' => '-59.1338000',
                'city' => 'Grand Bay East',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5779000',
                'longitude' => '-59.1338000',
                'city' => 'Cape Ray',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5838000',
                'longitude' => '-58.9694000',
                'city' => 'Isle-aux-morts',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5838000',
                'longitude' => '-58.9694000',
                'city' => 'Burnt Islands Blp',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1K4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1X1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1L4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1Z2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1W6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C3G4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3M5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1T8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3G2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1R8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6K3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1W3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2G9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1E3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1X2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1G9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2Y5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Saint Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2B9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2E6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6H6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2B6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5B4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3X2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3B7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1T9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3L6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1A5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2C6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1A1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1R6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3K3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C4C7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Lanse Au Clair',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1H6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3T3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3E4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1E5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4J6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1C1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Saint Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4L6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C5S7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3X5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3V6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2G8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3A3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4A7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B3K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Whitbourne',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4J8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4K7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3P6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3T5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1W9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1R7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3M4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2T8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3C3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3G6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3C7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2V2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3H2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5A2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2C5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1W7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2X1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4B8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1G1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4V4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3K6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3G8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5C6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3C5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3W5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4A9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2J5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1X1H3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1X1G9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A4C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5T5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5C1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5Z7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2N1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4X6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5V8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5X4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5W1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5T7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5V9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4T7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2M8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5V7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5X9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5V2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5W7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5T4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4V9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N3G9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1K8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N3K1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N3G3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4W3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4V7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4R9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4P9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4P5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4R2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N3N4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E3T9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3X4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1B1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1G4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3K4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2X2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1G3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4R1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E4Z4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5E3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1R5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4N9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4H7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5H5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2V2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C3Z7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1A4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4M6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N4Y9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1C3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5J3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1S4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B1W2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3Y8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1C4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1C1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3P8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4397000',
                'longitude' => '-53.5402000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4Z9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Frenchmans Cove Fb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C6J5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2G1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C5V3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1A9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'Portugal Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N3K2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2H6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1R8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C5B8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1P9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C5R3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2H3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A3Z9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2K9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E2Z1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A1R7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E1R2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1C6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1A2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E5W6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C5M5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1C9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1C2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1B2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1A8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1A6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1G1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1B5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1B8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A4X4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1B3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1B7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1B9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1G2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1L1E6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5762000',
                'longitude' => '-52.7251000',
                'city' => 'Paradise',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5W2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2J4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3P9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4L6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4L5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2H4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3V6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3P8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H6B9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5W3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H1C3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H4H3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5K9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H1C5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9748000',
                'longitude' => '-57.9728000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3X1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3W9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3P5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3E2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3M2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3L2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3P1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3G8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3C9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3X3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3J1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3X4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3T8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3L4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3K4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3P6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3K3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Mount Moriah',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H3J7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.9517000',
                'longitude' => '-57.9514000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A2X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'Makinsons',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1A2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1N1L9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'Mount Pearl',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'North Valley',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A1X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'Coleys Point South',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'Shearstown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0A3J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'Port De Grave',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1Y1B8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5812000',
                'longitude' => '-53.2717000',
                'city' => 'Carbonear',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H2J8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0077000',
                'longitude' => '-58.1267000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2H5T1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0077000',
                'longitude' => '-58.1267000',
                'city' => 'Corner Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0077000',
                'longitude' => '-58.1267000',
                'city' => 'Benoits Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0L1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.0077000',
                'longitude' => '-58.1267000',
                'city' => 'Frenchmans Cove Boi',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2247000',
                'longitude' => '-55.3580000',
                'city' => 'Garnish',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2247000',
                'longitude' => '-55.3580000',
                'city' => 'Grand Bank',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1X0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.2247000',
                'longitude' => '-55.3580000',
                'city' => 'Grand Beach',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0913000',
                'longitude' => '-55.7742000',
                'city' => 'Fortune',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => '001W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0913000',
                'longitude' => '-55.7742000',
                'city' => 'Grand Bank',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1Z5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1M8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1H8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1M7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1N1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A2E9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C2T3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B3N2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1M9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1N4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1N5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1N3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1W1M6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5171000',
                'longitude' => '-52.9847000',
                'city' => 'Long Pond',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6073000',
                'longitude' => '-55.9095000',
                'city' => 'Gaultois',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5831000',
                'longitude' => '-56.7499000',
                'city' => 'Francois',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2Z0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.3769000',
                'longitude' => '-56.5191000',
                'city' => 'Great Harbour Deep',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.4319000',
                'longitude' => '-57.2663000',
                'city' => 'Paradise River',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5252000',
                'longitude' => '-56.2276000',
                'city' => 'Mckenzie Portage',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.9861000',
                'longitude' => '-56.9829000',
                'city' => 'Castors River',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.9861000',
                'longitude' => '-56.9829000',
                'city' => 'Bartletts Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H2C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6402000',
                'longitude' => '-55.2256000',
                'city' => 'Rencontre East',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H2G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4863000',
                'longitude' => '-56.0649000',
                'city' => 'Seal Cove Fb',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.8170000',
                'longitude' => '-56.5410000',
                'city' => 'Millertown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '48.8170000',
                'longitude' => '-56.5410000',
                'city' => 'Buchans Junction',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8685000',
                'longitude' => '-55.8104000',
                'city' => 'Lamaline',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.6442000',
                'longitude' => '-57.2990000',
                'city' => 'Port Saunders',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3N0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.1832000',
                'longitude' => '-56.0139000',
                'city' => 'Main Brook',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'AOE2V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8937000',
                'longitude' => '-55.4099000',
                'city' => 'Saint Lawrence',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8937000',
                'longitude' => '-55.4099000',
                'city' => 'Little St Lawrence',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8937000',
                'longitude' => '-55.4099000',
                'city' => 'Lawn',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '46.8937000',
                'longitude' => '-55.4099000',
                'city' => 'St Lawrence',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0B1T0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5279000',
                'longitude' => '-53.8903000',
                'city' => 'Fair Haven',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5258000',
                'longitude' => '-55.4156000',
                'city' => 'Belleoram',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1R0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9074000',
                'longitude' => '-55.7658000',
                'city' => 'Head Bay Despoir',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9074000',
                'longitude' => '-55.7658000',
                'city' => 'Conne River',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.9074000',
                'longitude' => '-55.7658000',
                'city' => 'Milltown',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5585000',
                'longitude' => '-55.9274000',
                'city' => 'Hermitage',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G1Y0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.6489000',
                'longitude' => '-54.7682000',
                'city' => 'Durrell',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0G4M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '49.6489000',
                'longitude' => '-54.7682000',
                'city' => 'Twillingate',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4757000',
                'longitude' => '-55.8157000',
                'city' => 'Harbour Breton',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6081000',
                'longitude' => '-57.6163000',
                'city' => 'Burgeo',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4590000',
                'longitude' => '-55.6206000',
                'city' => 'English Harbour West',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0H1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.4590000',
                'longitude' => '-55.6206000',
                'city' => 'Coombs Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0612000',
                'longitude' => '-55.1753000',
                'city' => 'Burin Bay Arm',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0612000',
                'longitude' => '-55.1753000',
                'city' => 'Burin',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'APE1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0612000',
                'longitude' => '-55.1753000',
                'city' => 'Burin',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0E2G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.0612000',
                'longitude' => '-55.1753000',
                'city' => 'Lewins Cove',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B4G8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5B5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1B2P4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C1G8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1C5W2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1E3Y5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A1A5G6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.5997000',
                'longitude' => '-52.8347000',
                'city' => 'St. Johns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.3165000',
                'longitude' => '-60.3839000',
                'city' => 'Mud Lake',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.3165000',
                'longitude' => '-60.3839000',
                'city' => 'Makkovik',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2N2X1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.3165000',
                'longitude' => '-60.3839000',
                'city' => 'Stephenville',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.3165000',
                'longitude' => '-60.3839000',
                'city' => 'Happy Valley-goose Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.3165000',
                'longitude' => '-60.3839000',
                'city' => 'Happy Valley-goose Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.3165000',
                'longitude' => '-60.3839000',
                'city' => 'Happy Valley-goose Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.2344000',
                'longitude' => '-57.5952000',
                'city' => 'Portland Creek',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2C0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.2344000',
                'longitude' => '-57.5952000',
                'city' => 'Daniels Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '50.2344000',
                'longitude' => '-57.5952000',
                'city' => 'Bellburns',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4K0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.7351000',
                'longitude' => '-56.4245000',
                'city' => 'Red Bay',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4E0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.7351000',
                'longitude' => '-56.4245000',
                'city' => 'Port Hope Simpson',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.3093000',
                'longitude' => '-55.8381000',
                'city' => 'Marys Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '56.5428000',
                'longitude' => '-61.6894000',
                'city' => 'Nain',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.5619000',
                'longitude' => '-55.7677000',
                'city' => 'Williams Harbour',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0R1A0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.5109000',
                'longitude' => '-63.9953000',
                'city' => 'Churchill Falls',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3L0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.5260000',
                'longitude' => '-56.8304000',
                'city' => 'Lanse Au Loup',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K5S0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.5260000',
                'longitude' => '-56.8304000',
                'city' => 'West St Modeste',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K3J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.5260000',
                'longitude' => '-56.8304000',
                'city' => 'Lanse Loup',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K2P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '51.4587000',
                'longitude' => '-56.9590000',
                'city' => 'Forteau',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1G0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '55.4614000',
                'longitude' => '-60.2422000',
                'city' => 'Hopedale',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K1V0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '53.7171000',
                'longitude' => '-57.0040000',
                'city' => 'Cartwright',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0K4W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.3592000',
                'longitude' => '-55.7033000',
                'city' => 'St Lewis',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1K7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1R6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2V4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1B8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2Y3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2X2',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1P7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2A1',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2V6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2W5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1B5',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1G4',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1Y9',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1E8',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2W7',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1E6',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V2V3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A2V1Y3',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '52.9100000',
                'longitude' => '-66.8722000',
                'city' => 'Labrador City',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0P1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '54.0019000',
                'longitude' => '-59.2970000',
                'city' => 'Rigolet',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1W0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8665000',
                'longitude' => '-59.3691000',
                'city' => 'St Andrews',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1H0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8665000',
                'longitude' => '-59.3691000',
                'city' => 'Codroy',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N2B0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8665000',
                'longitude' => '-59.3691000',
                'city' => 'South Branch',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0N1J0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.8665000',
                'longitude' => '-59.3691000',
                'city' => 'Doyles',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1M0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6070000',
                'longitude' => '-58.7018000',
                'city' => 'Rose Blanche',
                'full_state' => 'Newfoundland and Labrador',
            ],
            [
                'zip' => 'A0M1P0',
                'country_code' => 'CA',
                'state' => 'NL',
                'latitude' => '47.6070000',
                'longitude' => '-58.7018000',
                'city' => 'Rose Blanche',
                'full_state' => 'Newfoundland and Labrador',
            ],
        ];

        DB::table('constants_zipcodes')->insert($zip_codes);
    }
}
