<?php

namespace Database\Seeders\ImmutableData\CAZipCodes;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BritishColumbiaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $zip_codes = [
            [
                'zip' => 'V0B1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4542000',
                'longitude' => '-116.7595000',
                'city' => 'Boswell',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.7580000',
                'longitude' => '-116.8549000',
                'city' => 'Riondel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5585000',
                'longitude' => '-117.6551000',
                'city' => 'Winlaw',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G2E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5585000',
                'longitude' => '-117.6551000',
                'city' => 'Slocan Park',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5585000',
                'longitude' => '-117.6551000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6766000',
                'longitude' => '-116.8215000',
                'city' => 'Gray Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6766000',
                'longitude' => '-116.8215000',
                'city' => 'Kootenay Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6766000',
                'longitude' => '-116.8215000',
                'city' => 'Crawford Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6263000',
                'longitude' => '-116.9741000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6263000',
                'longitude' => '-116.9741000',
                'city' => 'Balfour',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L5M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6263000',
                'longitude' => '-116.9741000',
                'city' => 'North Saanich',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6263000',
                'longitude' => '-116.9741000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6263000',
                'longitude' => '-116.9741000',
                'city' => 'Procter',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6263000',
                'longitude' => '-116.9741000',
                'city' => 'Ainsworth Hot Springs',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.8495000',
                'longitude' => '-125.2229000',
                'city' => 'Jade City',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.8495000',
                'longitude' => '-125.2229000',
                'city' => 'Toad River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '57.8373000',
                'longitude' => '-129.9761000',
                'city' => 'Iskut',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '57.8899000',
                'longitude' => '-131.1558000',
                'city' => 'Telegraph Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8444000',
                'longitude' => '-122.8499000',
                'city' => 'Gold Bridge',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '59.2845000',
                'longitude' => '-129.8016000',
                'city' => 'Good Hope Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.1342000',
                'longitude' => '-120.9983000',
                'city' => 'Creston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.1342000',
                'longitude' => '-120.9983000',
                'city' => 'Creston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.1342000',
                'longitude' => '-120.9983000',
                'city' => 'Tumbler Ridge',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4347000',
                'longitude' => '-121.8596000',
                'city' => 'Bridge Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4347000',
                'longitude' => '-121.8596000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4347000',
                'longitude' => '-121.8596000',
                'city' => 'Big Lake Ranch',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4347000',
                'longitude' => '-121.8596000',
                'city' => 'Bella Coola',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4347000',
                'longitude' => '-121.8596000',
                'city' => 'Horsefly',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Cassidy',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R3A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Ladysmith',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9X1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S3B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Cobble Hill',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L6A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Ladysmith',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9929000',
                'longitude' => '-123.8168000',
                'city' => 'Chemainus',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9164000',
                'longitude' => '-123.7107000',
                'city' => 'Chemainus',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9164000',
                'longitude' => '-123.7107000',
                'city' => 'Chemainus',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R3C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9164000',
                'longitude' => '-123.7107000',
                'city' => 'Westholme',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9164000',
                'longitude' => '-123.7107000',
                'city' => 'Thetis Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9164000',
                'longitude' => '-123.7107000',
                'city' => 'Crofton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9164000',
                'longitude' => '-123.7107000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1515000',
                'longitude' => '-123.8198000',
                'city' => 'Gabriola',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Coombs',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Errington',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Bouchie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Bouchie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6892000',
                'longitude' => '-121.9300000',
                'city' => 'Lytton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6892000',
                'longitude' => '-121.9300000',
                'city' => 'Lillooet',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.7312000',
                'longitude' => '-122.2375000',
                'city' => 'Shalalth',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.7312000',
                'longitude' => '-122.2375000',
                'city' => 'Seton Portage',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T5G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T5W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T1W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T5G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T8V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T2T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T3E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1B3T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T4E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1H1X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1H1R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T2V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T9K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J6E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Charlie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J3Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Nakusp',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Nakusp',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G2C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Slocan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Canyon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Kaslo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Crescent Valley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Burton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2421000',
                'longitude' => '-117.8066000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8735000',
                'longitude' => '-118.0669000',
                'city' => 'Edgewood',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8735000',
                'longitude' => '-118.0669000',
                'city' => 'Fauquier',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2999000',
                'longitude' => '-126.7001000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2999000',
                'longitude' => '-126.7001000',
                'city' => 'Woss',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.3656000',
                'longitude' => '-125.9407000',
                'city' => 'Sayward',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.7815000',
                'longitude' => '-126.0512000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.7815000',
                'longitude' => '-126.0512000',
                'city' => 'Gold River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.7815000',
                'longitude' => '-126.0512000',
                'city' => 'Tahsis',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.3870000',
                'longitude' => '-127.4449000',
                'city' => 'Port Alice',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W3M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Quatsino',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W3S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W5T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Quathiaski Cove',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Heriot Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W3S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W5G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W3W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W7Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W3N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W5P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W5T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W5Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W5Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W3S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6670000',
                'longitude' => '-128.0827000',
                'city' => 'Holberg',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.3517000',
                'longitude' => '-127.6795000',
                'city' => 'Ocean Falls',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3556000',
                'longitude' => '-120.0711000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A6Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3556000',
                'longitude' => '-120.0711000',
                'city' => 'Hedley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0X1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3556000',
                'longitude' => '-120.0711000',
                'city' => 'Hedley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0X1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4573000',
                'longitude' => '-120.5085000',
                'city' => 'Coalmont',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0X1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4573000',
                'longitude' => '-120.5085000',
                'city' => 'Princeton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0X2L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4573000',
                'longitude' => '-120.5085000',
                'city' => 'Tulameen',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => '150 Mile House',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => '100 Mile House',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => '150 Mile House',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4273000',
                'longitude' => '-122.3096000',
                'city' => 'Mcleese Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C4H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E1S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E1R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E2P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E2A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E1Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0V1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.9973000',
                'longitude' => '-129.9457000',
                'city' => 'Kincolith',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6932000',
                'longitude' => '-122.6776000',
                'city' => 'Red Rock',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6932000',
                'longitude' => '-122.6776000',
                'city' => 'Red Rock',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6932000',
                'longitude' => '-122.6776000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5Z9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6932000',
                'longitude' => '-122.6776000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6932000',
                'longitude' => '-122.6776000',
                'city' => 'Red Rock',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6932000',
                'longitude' => '-122.6776000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0268000',
                'longitude' => '-127.3772000',
                'city' => 'Kyuquot',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5000000',
                'longitude' => '-124.3465000',
                'city' => 'Lasqueti',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N2L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N1R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N7S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N2G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N5M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N7T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N1A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N6B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N2T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N2G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N8B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N8H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N7J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Royston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N5M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N8Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M2B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R3B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Union Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N7P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Fanny Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Denman Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Hornby Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N2L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6192000',
                'longitude' => '-125.0245000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6192000',
                'longitude' => '-125.0245000',
                'city' => 'Cumberland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N6L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6192000',
                'longitude' => '-125.0245000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6192000',
                'longitude' => '-125.0245000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6192000',
                'longitude' => '-125.0245000',
                'city' => 'Cumberland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Merville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Oyster Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9J1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8653000',
                'longitude' => '-125.1135000',
                'city' => 'Black Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N6C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N9A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N6C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N2E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N5N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M2V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M2J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.4981000',
                'longitude' => '-117.1763000',
                'city' => 'Golden',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Windermere',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Athalmer',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Panorama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Radium Hot Springs',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Invermere',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.3915000',
                'longitude' => '-116.4896000',
                'city' => 'Field',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.3005000',
                'longitude' => '-116.9648000',
                'city' => 'Grand Forks',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N1M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.3005000',
                'longitude' => '-116.9648000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4992000',
                'longitude' => '-116.0224000',
                'city' => 'Fairmont Hot Springs',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8958000',
                'longitude' => '-116.3594000',
                'city' => 'Harrogate',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8958000',
                'longitude' => '-116.3594000',
                'city' => 'Brisco',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8958000',
                'longitude' => '-116.3594000',
                'city' => 'Spillimacheen',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6236000',
                'longitude' => '-116.0677000',
                'city' => 'Edgewater',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6236000',
                'longitude' => '-116.0677000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0A1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.0688000',
                'longitude' => '-116.6376000',
                'city' => 'Parson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.0688000',
                'longitude' => '-116.6376000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1596000',
                'longitude' => '-115.8088000',
                'city' => 'Canal Flats',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1564000',
                'longitude' => '-120.2384000',
                'city' => 'Quilchena',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1564000',
                'longitude' => '-120.2384000',
                'city' => 'Douglas Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L1C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L1C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L6E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L3L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L3K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L3Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L1M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L3Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L4K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L3M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L1S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G2K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1932000',
                'longitude' => '-117.2715000',
                'city' => 'Ymir',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1932000',
                'longitude' => '-117.2715000',
                'city' => 'Meadow Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C4H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1932000',
                'longitude' => '-117.2715000',
                'city' => 'Salmo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1932000',
                'longitude' => '-117.2715000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1932000',
                'longitude' => '-117.2715000',
                'city' => 'Salmo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G2B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.9935000',
                'longitude' => '-117.3728000',
                'city' => 'Silverton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.9935000',
                'longitude' => '-117.3728000',
                'city' => 'New Denver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G2G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4598000',
                'longitude' => '-117.5248000',
                'city' => 'South Slocan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N3L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4598000',
                'longitude' => '-117.5248000',
                'city' => 'So Slocan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A1L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T2M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A1L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A1P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A6T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A5S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A2P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A1H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A6T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A6Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T1E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3X2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A1L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z6E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A4K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0749000',
                'longitude' => '-117.8008000',
                'city' => 'Rossland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J3G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0749000',
                'longitude' => '-117.8008000',
                'city' => 'Bear Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L3H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L1H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'North Saanich',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L1T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z1M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T2W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2Y2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R3N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R3C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R1J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N1J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N3L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N3C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N1H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N4B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Robson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N4H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N3K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N3A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N3H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1977000',
                'longitude' => '-116.9810000',
                'city' => 'Argenta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1162000',
                'longitude' => '-117.5399000',
                'city' => 'Grand Forks',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1162000',
                'longitude' => '-117.5399000',
                'city' => 'Refuge Cove',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1162000',
                'longitude' => '-117.5399000',
                'city' => 'Fruitvale',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1162000',
                'longitude' => '-117.5399000',
                'city' => 'Montrose',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R2X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R3N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P4A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S1X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R3X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T2C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T2C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S3S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P4P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R6T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R6T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T3C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B1Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B4P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7Y2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Logan Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B4X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.7492000',
                'longitude' => '-120.8389000',
                'city' => 'Savona',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E1G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4726000',
                'longitude' => '-119.7707000',
                'city' => 'Monte Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4726000',
                'longitude' => '-119.7707000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E3B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4726000',
                'longitude' => '-119.7707000',
                'city' => 'Westwold',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B5L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B5B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B1M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B1N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B1R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1K1H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1083000',
                'longitude' => '-120.7881000',
                'city' => 'Merritt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4993000',
                'longitude' => '-119.5578000',
                'city' => 'Falkland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A6Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A7G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A7J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V2P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A4G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A2T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T1B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V2Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A2X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A7C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V2Y5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A5B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A7A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V2P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T3S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V2G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A5R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V2P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A2R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T6G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Lantzville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T2N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T2L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T6G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C1J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C3L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C3T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0S1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C1B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9E1C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => '150 Mile House',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => '150 Mile House',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0742000',
                'longitude' => '-120.8373000',
                'city' => 'Canim Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0742000',
                'longitude' => '-120.8373000',
                'city' => 'Eagle Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0748000',
                'longitude' => '-123.2679000',
                'city' => 'Alexis Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0748000',
                'longitude' => '-123.2679000',
                'city' => 'Hanceville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0748000',
                'longitude' => '-123.2679000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6480000',
                'longitude' => '-121.2916000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6480000',
                'longitude' => '-121.2916000',
                'city' => 'Forest Grove',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6480000',
                'longitude' => '-121.2916000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6480000',
                'longitude' => '-121.2916000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6480000',
                'longitude' => '-121.2916000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6480000',
                'longitude' => '-121.2916000',
                'city' => 'Lone Butte',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.8160000',
                'longitude' => '-121.4657000',
                'city' => 'Lac La Hache',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.7653000',
                'longitude' => '-121.1016000',
                'city' => 'Buffalo Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G3W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Summerland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C1C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C6N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C6H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C1T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C6M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8977000',
                'longitude' => '-115.7311000',
                'city' => 'Skookumchuck',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8977000',
                'longitude' => '-115.7311000',
                'city' => 'Ta Ta Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8977000',
                'longitude' => '-115.7311000',
                'city' => 'Wasa',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5076000',
                'longitude' => '-115.0566000',
                'city' => 'Sparwood',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5076000',
                'longitude' => '-115.0566000',
                'city' => 'Fernie',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5076000',
                'longitude' => '-115.0566000',
                'city' => 'Fernie',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5076000',
                'longitude' => '-115.0566000',
                'city' => 'Fernie',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0841000',
                'longitude' => '-116.0887000',
                'city' => 'Kingsgate',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0841000',
                'longitude' => '-116.0887000',
                'city' => 'Yahk',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C6M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C1B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C6J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Fort Steele',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C6H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C4H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C4Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A3C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A2M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A2Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A3B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A2L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A3A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A3B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A2L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A2Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1A1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6825000',
                'longitude' => '-115.9784000',
                'city' => 'Kimberley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Kitchener',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C2V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Wynndel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Erickson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Creston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Creston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Creston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Creston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3758000',
                'longitude' => '-115.2940000',
                'city' => 'Wardner',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3758000',
                'longitude' => '-115.2940000',
                'city' => 'Jaffray',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C4H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3758000',
                'longitude' => '-115.2940000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3758000',
                'longitude' => '-115.2940000',
                'city' => 'Galloway',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.7847000',
                'longitude' => '-122.2447000',
                'city' => 'Dog Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.7847000',
                'longitude' => '-122.2447000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.7847000',
                'longitude' => '-122.2447000',
                'city' => 'Alkali Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8950000',
                'longitude' => '-123.4292000',
                'city' => 'Cluculz Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J3A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8950000',
                'longitude' => '-123.4292000',
                'city' => 'Vanderhoof',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8950000',
                'longitude' => '-123.4292000',
                'city' => 'Cluculz Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0324000',
                'longitude' => '-118.4404000',
                'city' => 'Christina Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0324000',
                'longitude' => '-118.4404000',
                'city' => 'Grand Forks',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T1Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0929000',
                'longitude' => '-118.6767000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0929000',
                'longitude' => '-118.6767000',
                'city' => 'Greenwood',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0580000',
                'longitude' => '-118.9913000',
                'city' => 'Rock Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H2B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0580000',
                'longitude' => '-118.9913000',
                'city' => 'Westbridge',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0580000',
                'longitude' => '-118.9913000',
                'city' => 'Bridesville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0588000',
                'longitude' => '-118.2042000',
                'city' => 'Christina Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0588000',
                'longitude' => '-118.2042000',
                'city' => 'Christina Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0588000',
                'longitude' => '-118.2042000',
                'city' => 'Christina Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0043000',
                'longitude' => '-118.7748000',
                'city' => 'Midway',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3C6H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.7240000',
                'longitude' => '-121.2831000',
                'city' => 'Port Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.7240000',
                'longitude' => '-121.2831000',
                'city' => 'Ashcroft',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.7240000',
                'longitude' => '-121.2831000',
                'city' => 'Cache Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.2986000',
                'longitude' => '-121.3955000',
                'city' => '70 Mile House',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4267000',
                'longitude' => '-121.3381000',
                'city' => 'Spences Bridge',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.0902000',
                'longitude' => '-121.5855000',
                'city' => 'Gang Ranch',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.0902000',
                'longitude' => '-121.5855000',
                'city' => 'Clinton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y3H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y8E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y7S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y5M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y4M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y9R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y9R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y1A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Peachland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y3H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X4K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '57.4301000',
                'longitude' => '-125.6341000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P2Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N6J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P4X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N6K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N5M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N1A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P5K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N5M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P2G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N4P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P5J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N6K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N2A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P5N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N3R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N3R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N6E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N4S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N3R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B4G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C3P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2Y2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B4E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C3N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B4C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B3L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z4C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z6S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X3Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z1G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.9028000',
                'longitude' => '-124.6033000',
                'city' => 'Tatlayoko Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.9028000',
                'longitude' => '-124.6033000',
                'city' => 'Kleena Kleene',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.9028000',
                'longitude' => '-124.6033000',
                'city' => 'Tatla Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P3C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N3G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P5L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P5M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N1C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N3X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N4X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P1X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N6J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P4H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N2A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N5X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8N3L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P4K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C4B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C3X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B3X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C4G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C3Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B4V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X3X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z2E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z5L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z6W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z2K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z5A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9E1J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z5P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9E1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X3X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B4P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z4W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z6T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T2B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T1A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1586000',
                'longitude' => '-124.1998000',
                'city' => 'Puntzi',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1586000',
                'longitude' => '-124.1998000',
                'city' => 'Chilanko Forks',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4321000',
                'longitude' => '-119.0930000',
                'city' => 'Beaverdell',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C5M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C4L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C3N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C1B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1C4P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5125000',
                'longitude' => '-115.7599000',
                'city' => 'Cranbrook',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A6W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A2E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A2T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A6J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A6J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A2N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X2P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X2Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X2G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X5T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X6B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X2J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1V1V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1V1X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X2K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X4K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A6P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A6Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A1B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Summerland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T5J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6Y5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Summerland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Summerland',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3Y5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5980000',
                'longitude' => '-119.6758000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0336000',
                'longitude' => '-119.4579000',
                'city' => 'Osoyoos',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Naramata',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A6Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Naramata',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Naramata',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Okanagan Falls',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A1P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Kaleden',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3659000',
                'longitude' => '-119.5621000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1819000',
                'longitude' => '-119.5476000',
                'city' => 'Oliver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0X1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2007000',
                'longitude' => '-119.8118000',
                'city' => 'Keremeos',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0X1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2007000',
                'longitude' => '-119.8118000',
                'city' => 'Cawston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A5L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2007000',
                'longitude' => '-119.8118000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T5M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3249000',
                'longitude' => '-117.6635000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2955000',
                'longitude' => '-115.1072000',
                'city' => 'Elkford',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2955000',
                'longitude' => '-115.1072000',
                'city' => 'Elko',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0S1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Ganges',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Saturna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Mayne',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Pender Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Galiano',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1H1X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T9G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1B1S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Coldstream',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6X2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1B1Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Coldstream',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T9A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T8B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T9E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T1S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T1S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T2E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z5T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y1V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1B1W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Coldstream',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T2E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T9H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4511000',
                'longitude' => '-119.1974000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4511000',
                'longitude' => '-119.1974000',
                'city' => 'Armstrong',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4511000',
                'longitude' => '-119.1974000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0D1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4511000',
                'longitude' => '-119.1974000',
                'city' => 'Armstrong',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4511000',
                'longitude' => '-119.1974000',
                'city' => 'Enderby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T6N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.4511000',
                'longitude' => '-119.1974000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2509000',
                'longitude' => '-118.9628000',
                'city' => 'Lumby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V2G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.1103000',
                'longitude' => '-119.3567000',
                'city' => 'Oyama',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T8M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T9H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1B3G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Coldstream',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1B3G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Coldstream',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J3E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.7157000',
                'longitude' => '-120.9028000',
                'city' => 'Crescent Spur',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.7157000',
                'longitude' => '-120.9028000',
                'city' => 'Hixon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B4N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B1C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B3P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6845000',
                'longitude' => '-132.1940000',
                'city' => 'Port Clements',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6845000',
                'longitude' => '-132.1940000',
                'city' => 'Juskatla',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.6845000',
                'longitude' => '-132.1940000',
                'city' => 'Tlell',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T7M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T4E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T1K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T9N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.2682000',
                'longitude' => '-119.2617000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.2438000',
                'longitude' => '-132.0148000',
                'city' => 'Sandspit',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.2438000',
                'longitude' => '-132.0148000',
                'city' => 'Queen Charlotte',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.2438000',
                'longitude' => '-132.0148000',
                'city' => 'Queen Charlotte',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8048000',
                'longitude' => '-122.8860000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N6K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8048000',
                'longitude' => '-122.8860000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8048000',
                'longitude' => '-122.8860000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8048000',
                'longitude' => '-122.8860000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8048000',
                'longitude' => '-122.8860000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M2S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8048000',
                'longitude' => '-122.8860000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N6K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.8048000',
                'longitude' => '-122.8860000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N1S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M5N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M5J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L1L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M2R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M6J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M6V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4Y2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M5K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M4P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L1L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N3M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M2K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L5H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N3A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M6W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L5G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L5B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Mcbride',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.8322000',
                'longitude' => '-119.2584000',
                'city' => 'Valemount',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J3C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0672000',
                'longitude' => '-122.3803000',
                'city' => 'Willow River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5Z9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C4X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C4V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8145000',
                'longitude' => '-119.6925000',
                'city' => 'Pritchard',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Heffley Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2H1L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B8N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B6T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2B7L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6489000',
                'longitude' => '-120.0305000',
                'city' => 'Clearwater',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R3A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S5E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S1Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S2N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R6R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S4J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P1P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R2R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S3R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S3S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R4R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T5B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S3G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S2N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S3T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M5L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M1C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L5K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M6P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M5K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G2R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Lantzville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.0404000',
                'longitude' => '-129.5688000',
                'city' => 'Greenville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J4A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J4B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J4A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J3T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J3X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J1C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J3W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J1J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J1M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J3Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J4L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0V1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5567000',
                'longitude' => '-130.4242000',
                'city' => 'Lax Kwalaams',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T2B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0083000',
                'longitude' => '-132.1417000',
                'city' => 'Haisla',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0083000',
                'longitude' => '-132.1417000',
                'city' => 'Masset',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2Y5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J4B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J1E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2Z9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J3Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J2V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J3X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3172000',
                'longitude' => '-130.3262000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0V1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.2286000',
                'longitude' => '-130.2852000',
                'city' => 'Port Edward',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J4P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.2286000',
                'longitude' => '-130.2852000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8J3P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.2286000',
                'longitude' => '-130.2852000',
                'city' => 'Prince Rupert',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Pender Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Pender Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8496000',
                'longitude' => '-123.2911000',
                'city' => 'Pender Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.8330000',
                'longitude' => '-120.9968000',
                'city' => 'Montney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.8330000',
                'longitude' => '-120.9968000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.8330000',
                'longitude' => '-120.9968000',
                'city' => 'Chetwynd',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.8330000',
                'longitude' => '-120.9968000',
                'city' => 'Buick',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.8330000',
                'longitude' => '-120.9968000',
                'city' => 'Rose Prairie',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.8330000',
                'longitude' => '-120.9968000',
                'city' => 'Altona',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.8330000',
                'longitude' => '-120.9968000',
                'city' => 'Prespatou',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C2N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C2N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C2K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C2B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C2P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J3J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.2328000',
                'longitude' => '-129.0297000',
                'city' => 'Nass Camp',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J3T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.2328000',
                'longitude' => '-129.0297000',
                'city' => 'Gitwinksihlkw',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.2328000',
                'longitude' => '-129.0297000',
                'city' => 'Aiyansh',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G2N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G3X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1Y5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G3P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Thornhill',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G3X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G5B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Thornhill',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G2W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G3Z9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G2P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G5L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.9327000',
                'longitude' => '-129.9916000',
                'city' => 'Stewart',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G3M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Thornhill',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G5M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G2E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5159000',
                'longitude' => '-128.5822000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C2G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C2K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8C1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0487000',
                'longitude' => '-128.6425000',
                'city' => 'Kitimat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B4C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Sooke',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C4B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C4C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Sooke',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C4C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Sooke',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A2M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P5M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Sooke',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9C4C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1Y5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0S1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.3777000',
                'longitude' => '-123.7223000',
                'city' => 'Sooke',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0S1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.5567000',
                'longitude' => '-124.4076000',
                'city' => 'Port Renfrew',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.6550000',
                'longitude' => '-124.7377000',
                'city' => 'Fort St. James',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0W1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '59.5886000',
                'longitude' => '-133.7059000',
                'city' => 'Atlin',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M2C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Brentwood Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8M1W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanichton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0S1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Saanich',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0S1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Ganges',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K2A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8K1Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8491000',
                'longitude' => '-123.4999000',
                'city' => 'Salt Spring Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L4X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L4G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L3X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L3X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'North Saanich',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L5Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L5K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'North Saanich',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L3B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L4R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'North Saanich',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L5W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L1Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L4T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L3C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L2W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6094000',
                'longitude' => '-123.4005000',
                'city' => 'Sidney',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y3B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y3E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y3E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y3G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y2X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y2E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X5A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y3C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z7J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y2J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y2N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X5E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z7J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Y2K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X3T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.9692000',
                'longitude' => '-122.5261000',
                'city' => 'Riske Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2861000',
                'longitude' => '-126.0763000',
                'city' => 'Tofino',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2861000',
                'longitude' => '-126.0763000',
                'city' => 'Ahousat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.1843000',
                'longitude' => '-120.1151000',
                'city' => 'Louis Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.1843000',
                'longitude' => '-120.1151000',
                'city' => 'Darfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.1843000',
                'longitude' => '-120.1151000',
                'city' => 'Mclure',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.1843000',
                'longitude' => '-120.1151000',
                'city' => 'Barriere',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0999000',
                'longitude' => '-119.3063000',
                'city' => 'Blue River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6489000',
                'longitude' => '-120.0305000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.6489000',
                'longitude' => '-120.0305000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8814000',
                'longitude' => '-119.4649000',
                'city' => 'Tappen',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8814000',
                'longitude' => '-119.4649000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8814000',
                'longitude' => '-119.4649000',
                'city' => 'Eagle Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8814000',
                'longitude' => '-119.4649000',
                'city' => 'Blind Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8814000',
                'longitude' => '-119.4649000',
                'city' => 'Blind Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8814000',
                'longitude' => '-119.4649000',
                'city' => 'Sorrento',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8814000',
                'longitude' => '-119.4649000',
                'city' => 'Sorrento',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E3A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.5837000',
                'longitude' => '-119.7224000',
                'city' => 'Vavenby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.4312000',
                'longitude' => '-120.1994000',
                'city' => 'Little Fort',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.7857000',
                'longitude' => '-119.3235000',
                'city' => 'Avola',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1M0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8145000',
                'longitude' => '-119.6925000',
                'city' => 'Chase',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8145000',
                'longitude' => '-119.6925000',
                'city' => 'Anglemont',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0555000',
                'longitude' => '-124.5537000',
                'city' => 'Fort Fraser',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.2247000',
                'longitude' => '-125.7574000',
                'city' => 'Burns Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N2W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1N3H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Castlegar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1R4L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Trail',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0G1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0896000',
                'longitude' => '-117.7067000',
                'city' => 'Genelle',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0490000',
                'longitude' => '-125.7559000',
                'city' => 'Southbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0490000',
                'longitude' => '-125.7559000',
                'city' => 'Grassy Plains',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0490000',
                'longitude' => '-125.7559000',
                'city' => 'Francois Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5047000',
                'longitude' => '-126.2920000',
                'city' => 'Houston',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.5047000',
                'longitude' => '-126.2920000',
                'city' => 'Topley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.8820000',
                'longitude' => '-126.1970000',
                'city' => 'Granisle',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0570000',
                'longitude' => '-124.8484000',
                'city' => 'Endako',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0570000',
                'longitude' => '-124.8484000',
                'city' => 'Fraser Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L2P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N5W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N1J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z2C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X4H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X4H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y9S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y9P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X1X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L2X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L2Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L2W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L2Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L3N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Lake Cowichan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L5J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L2Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R2M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R2M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R1J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S4N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R2A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S4E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S2H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R1A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R1X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1V2J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3Z9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X6J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y5W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y7W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X6E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X6A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y4N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1V1N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y2A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y1V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y2E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y8A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y6G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P4H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T3C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3C5Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Port Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R4J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9X1G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9X1H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9X1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9X1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9X1G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S1J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Lantzville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y8G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y8H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y8C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y5K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7Y5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y3Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y6L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y5J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y3T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y8G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y1V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y5B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y8A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R3A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1521000',
                'longitude' => '-125.9047000',
                'city' => 'Ucluelet',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y4C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1521000',
                'longitude' => '-125.9047000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S4P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.9412000',
                'longitude' => '-125.5407000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z6G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X2C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8270000',
                'longitude' => '-125.1281000',
                'city' => 'Bamfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T6A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T2H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S3V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S4K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T2E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T1W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S4N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T1X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T3K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2334000',
                'longitude' => '-124.7960000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R3K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S1E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R2V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R3K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R3X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4134000',
                'longitude' => '-125.2365000',
                'city' => 'Anahim Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.4134000',
                'longitude' => '-125.2365000',
                'city' => 'Nimpo Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Cobble Hill',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Port Hardy',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L3Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L3R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Cowichan Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Mill Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2W0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Shawnigan Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.6898000',
                'longitude' => '-123.5953000',
                'city' => 'Malahat',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z5L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z7H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z7B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R3E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8754000',
                'longitude' => '-124.2007000',
                'city' => 'Youbou',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8754000',
                'longitude' => '-124.2007000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9Y7M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8754000',
                'longitude' => '-124.2007000',
                'city' => 'Port Alberni',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L2W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L3W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J5B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J2M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Bouchie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J4E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J5E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Bouchie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L5K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L3K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L4R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.7803000',
                'longitude' => '-123.7066000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9L1P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8249000',
                'longitude' => '-124.0510000',
                'city' => 'Duncan',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8249000',
                'longitude' => '-124.0510000',
                'city' => 'Mesachie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.8249000',
                'longitude' => '-124.0510000',
                'city' => 'Honeymoon Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.0320000',
                'longitude' => '-123.0338000',
                'city' => 'Mackenzie',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.0320000',
                'longitude' => '-123.0338000',
                'city' => 'Mcleod Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T3H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T4T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T2K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T2H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T3Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T6E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R2T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R3G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R5N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S4S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S2H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S4R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R2R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R3L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S5K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R2X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S1K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T6A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T6A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S1H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S2K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0R1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Bowser',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K1Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9K2C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4002000',
                'longitude' => '-124.6263000',
                'city' => 'Qualicum Beach',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9R6X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S3K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9T5N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9V1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.9379000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Rolla',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P2A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.9863000',
                'longitude' => '-126.8430000',
                'city' => 'Zeballos',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X6X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y9R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y2B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y9A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y5Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y2G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y1R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y8T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y8G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X6Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y7W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y9P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y5Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1V1P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1V1N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y8B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y7R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Okanagan Mission',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W2Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W2Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Okanagan Mission',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y7R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Okanagan Mission',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W1V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W1X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X2A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X3J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X5A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y7R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X2C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X5A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1P1B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X1Y2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H2C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4V1W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0309000',
                'longitude' => '-119.3974000',
                'city' => 'Winfield',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9S3Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.7919000',
                'longitude' => '-119.7040000',
                'city' => 'Nanaimo',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T2L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0H2A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'Westbank',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8227000',
                'longitude' => '-119.6212000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z1Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z2X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z1B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z2Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y8B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z1S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4T1T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z3N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z2T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z2R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z1L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Z2R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'West Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A8P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A3X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A1M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A2J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A2X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A7J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A2G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2A4J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.5011000',
                'longitude' => '-119.5983000',
                'city' => 'Penticton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.4366000',
                'longitude' => '-130.0251000',
                'city' => 'Dease Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J3W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.7335000',
                'longitude' => '-121.8010000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.7335000',
                'longitude' => '-121.8010000',
                'city' => 'Wonowon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.7335000',
                'longitude' => '-121.8010000',
                'city' => 'Pink Mountain',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.0618000',
                'longitude' => '-122.6749000',
                'city' => 'Prophet River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.8087000',
                'longitude' => '-122.6968000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.8087000',
                'longitude' => '-122.6968000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.8087000',
                'longitude' => '-122.6968000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.8087000',
                'longitude' => '-122.6968000',
                'city' => 'Fort Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.9164000',
                'longitude' => '-125.7506000',
                'city' => 'Muncho Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '58.9164000',
                'longitude' => '-125.7506000',
                'city' => 'Muncho Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7828000',
                'longitude' => '-120.9743000',
                'city' => 'Groundbirch',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2773000',
                'longitude' => '-120.2785000',
                'city' => 'Goodlow',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2773000',
                'longitude' => '-120.2785000',
                'city' => 'Clayhurst',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2773000',
                'longitude' => '-120.2785000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2773000',
                'longitude' => '-120.2785000',
                'city' => 'Cecil Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G1P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G1E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G1N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G1X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.0256000',
                'longitude' => '-121.9023000',
                'city' => 'Hudsons Hope',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G1P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Pouce Coupe',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G1Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J6E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J6K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Baldonnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J6A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J6B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J6C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7147000',
                'longitude' => '-120.1318000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7147000',
                'longitude' => '-120.1318000',
                'city' => 'Tomslake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7147000',
                'longitude' => '-120.1318000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G3K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7147000',
                'longitude' => '-120.1318000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.6983000',
                'longitude' => '-121.6527000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J5S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.6983000',
                'longitude' => '-121.6527000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.6983000',
                'longitude' => '-121.6527000',
                'city' => 'Moberly Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G2B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.6983000',
                'longitude' => '-121.6527000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Taylor',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J6L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J3Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J3Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J1V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J3Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J2E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0L1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.6163000',
                'longitude' => '-121.5644000',
                'city' => 'Likely',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '51.7505000',
                'longitude' => '-121.3396000',
                'city' => '108 Mile Ranch',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3728000',
                'longitude' => '-128.5328000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G4A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3728000',
                'longitude' => '-128.5328000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1X2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B5X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L6A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L2R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1L5R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.4896000',
                'longitude' => '-117.2923000',
                'city' => 'Nelson',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'North Pine',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1J4H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '56.2492000',
                'longitude' => '-120.8383000',
                'city' => 'Fort St. John',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E1V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C1K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E2H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E2M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E2C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2888000',
                'longitude' => '-115.8314000',
                'city' => 'Moyie',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W6K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W3X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W4B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E3L1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E2P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E2P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E2R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E2N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E2P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E1P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0072000',
                'longitude' => '-118.5683000',
                'city' => 'Revelstoke',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.0072000',
                'longitude' => '-118.5683000',
                'city' => 'Mica Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6995000',
                'longitude' => '-119.2819000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8343000',
                'longitude' => '-118.9925000',
                'city' => 'Malakwa',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8343000',
                'longitude' => '-118.9925000',
                'city' => 'Mara',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E2V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.8343000',
                'longitude' => '-118.9925000',
                'city' => 'Sicamous',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E3K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9984000',
                'longitude' => '-118.1934000',
                'city' => 'Revelstoke',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S4P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9984000',
                'longitude' => '-118.1934000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1E4R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9984000',
                'longitude' => '-118.1934000',
                'city' => 'Salmon Arm',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S4N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9984000',
                'longitude' => '-118.1934000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S4P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9984000',
                'longitude' => '-118.1934000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S4M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9984000',
                'longitude' => '-118.1934000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.5475000',
                'longitude' => '-119.1391000',
                'city' => 'Canoe',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.5475000',
                'longitude' => '-119.1391000',
                'city' => 'Grindrod',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.5870000',
                'longitude' => '-128.5133000',
                'city' => 'Klemtu',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0X1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0638000',
                'longitude' => '-120.7775000',
                'city' => 'Manning Park',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0V1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.4272000',
                'longitude' => '-129.2511000',
                'city' => 'Hartley Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.2451000',
                'longitude' => '-127.5859000',
                'city' => 'New Hazelton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1Y0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.2451000',
                'longitude' => '-127.5859000',
                'city' => 'Hazelton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.2451000',
                'longitude' => '-127.5859000',
                'city' => 'South Hazelton',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Farmington',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1G4E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Dawson Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Sunset Prairie',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Arras',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0C2E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.7604000',
                'longitude' => '-120.2243000',
                'city' => 'Progress',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N1T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3991000',
                'longitude' => '-126.6574000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2N0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3991000',
                'longitude' => '-126.6574000',
                'city' => 'Smithers',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2X0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.3991000',
                'longitude' => '-126.6574000',
                'city' => 'Telkwa',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J3P0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.7017000',
                'longitude' => '-127.0440000',
                'city' => 'Telkwa',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.7827000',
                'longitude' => '-127.1734000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.7827000',
                'longitude' => '-127.1734000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K1C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.7827000',
                'longitude' => '-127.1734000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.7827000',
                'longitude' => '-127.1734000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8G1V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.7827000',
                'longitude' => '-127.1734000',
                'city' => 'Terrace',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1T1W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.7827000',
                'longitude' => '-127.1734000',
                'city' => 'Vernon',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0V1C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.7955000',
                'longitude' => '-130.4242000',
                'city' => 'Kitkatla',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.1038000',
                'longitude' => '-128.0235000',
                'city' => 'Kitwanga',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1G0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '55.1038000',
                'longitude' => '-128.0235000',
                'city' => 'Cedarvale',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1S1T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C5S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2E2J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6734000',
                'longitude' => '-120.3349000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X5W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y6H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y8B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y4S3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y5V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X5N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X5X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y4B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y8N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W4P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X5G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y5Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1W3R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B2C0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0989000',
                'longitude' => '-116.5154000',
                'city' => 'Sirdar',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X7H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1X1Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1Y3W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.8906000',
                'longitude' => '-119.4829000',
                'city' => 'Kelowna',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X3P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X3Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z2G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z1Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P2L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0B1R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.0879000',
                'longitude' => '-115.0718000',
                'city' => 'Grasmere',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M2Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M2L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M1J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M2N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9M3P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Comox',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N9A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N7M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N9B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N9A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.6906000',
                'longitude' => '-124.9932000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A5S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A6V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W7X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W7H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W7E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9H1H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W1R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W5G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0270000',
                'longitude' => '-125.2638000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.5266000',
                'longitude' => '-126.8574000',
                'city' => 'Port Mcneill',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.5266000',
                'longitude' => '-126.8574000',
                'city' => 'Telegraph Cove',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0608000',
                'longitude' => '-124.9849000',
                'city' => 'Whaletown',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1V0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0608000',
                'longitude' => '-124.9849000',
                'city' => 'Stuart Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0P1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.0608000',
                'longitude' => '-124.9849000',
                'city' => 'Mansons Landing',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N1K0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6884000',
                'longitude' => '-127.4848000',
                'city' => 'Coal Harbour',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6884000',
                'longitude' => '-127.4848000',
                'city' => 'Port Hardy',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6884000',
                'longitude' => '-127.4848000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B2S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6884000',
                'longitude' => '-127.4848000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9N3P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6884000',
                'longitude' => '-127.4848000',
                'city' => 'Courtenay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6884000',
                'longitude' => '-127.4848000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9W2R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6884000',
                'longitude' => '-127.4848000',
                'city' => 'Campbell River',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R5J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A3N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z6T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z5N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S5J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8P5P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W3C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8X4A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z4B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z1E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8R6R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W2B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8L5V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'North Saanich',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9B1J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T4L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8Z3P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P1T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2L4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9P2P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.3181000',
                'longitude' => '-124.3147000',
                'city' => 'Parksville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E3L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9418000',
                'longitude' => '-119.3467000',
                'city' => 'Scotch Creek',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C2J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9418000',
                'longitude' => '-119.3467000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2C6L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9418000',
                'longitude' => '-119.3467000',
                'city' => 'Kamloops',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0E1L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.9418000',
                'longitude' => '-119.3467000',
                'city' => 'Celista',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1713000',
                'longitude' => '-128.1425000',
                'city' => 'Denny Island',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1713000',
                'longitude' => '-128.1425000',
                'city' => 'Bella Bella',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M5G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M4E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M2P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L4R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L3H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N1W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M3A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K3V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K1T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K3A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K2H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K3A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K3A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K4R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K2J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K2H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K3A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N6E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N6E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N6E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N6E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5X6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N6E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N3V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N4Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N5P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.9084000',
                'longitude' => '-122.7402000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2S0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.2849000',
                'longitude' => '-122.6295000',
                'city' => 'Summit Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J2Z0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0970000',
                'longitude' => '-121.8807000',
                'city' => 'Upper Fraser',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2K3H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0119000',
                'longitude' => '-122.9814000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2M4C5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0119000',
                'longitude' => '-122.9814000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2L2Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0119000',
                'longitude' => '-122.9814000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2N2S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '54.0119000',
                'longitude' => '-122.9814000',
                'city' => 'Prince George',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0J1J0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.1554000',
                'longitude' => '-119.8280000',
                'city' => 'Dunster',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3L0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.5368000',
                'longitude' => '-128.0217000',
                'city' => 'Winter Harbour',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3E0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.6405000',
                'longitude' => '-127.0232000',
                'city' => 'Sointula',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N1A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '50.5902000',
                'longitude' => '-126.9222000',
                'city' => 'Alert Bay',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0T1H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.3662000',
                'longitude' => '-126.7537000',
                'city' => 'Hagensborg',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G4P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G1A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2G2V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.1251000',
                'longitude' => '-122.1415000',
                'city' => 'Williams Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3JL',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Bouchie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J5J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Bouchie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J5G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J5E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Bouchie Lake',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J2N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J2V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J2K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J2T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J2W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J5B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J1Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J2M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '52.9745000',
                'longitude' => '-122.4925000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2J3J1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.0981000',
                'longitude' => '-121.5711000',
                'city' => 'Quesnel',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K2R0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.0981000',
                'longitude' => '-121.5711000',
                'city' => 'Wells',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0K1B0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '53.0981000',
                'longitude' => '-121.5711000',
                'city' => 'Barkerville',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A6X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V4C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V1A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T3Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A6N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8S1Z9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V9A4R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8V3N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8T2B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V8W1N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '48.4080000',
                'longitude' => '-123.3544000',
                'city' => 'Victoria',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3M4J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2103000',
                'longitude' => '-122.9261000',
                'city' => 'New Westminster',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3K6X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2103000',
                'longitude' => '-122.9261000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B1R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M4V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B1P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5A2P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G1E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C1Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B1P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4B4X2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2103000',
                'longitude' => '-122.9261000',
                'city' => 'White Rock',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6V2V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6W1J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6V2W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6V1H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7B1A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y4B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6W1H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3X2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y2V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X2A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X1T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6V1J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C1V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X1A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2S5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K3A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K3A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K3C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K1J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A4G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N5R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M1N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M1B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C4H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7H1P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'North Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5J1R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1M1S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Langley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7H1A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'North Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E1K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z4R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z1K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5S3S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2V6H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Mission',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4K1H1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4G1K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3X2N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3W0L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3H4S7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Port Moody',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3C6G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Port Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4P2M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2B8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R4H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R4N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R4R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1N8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2H7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2G2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R3C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T1T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R3A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R3R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R2J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6T2G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R4H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R1K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4A8A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6J1J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6E1T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M1B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4K2G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3T3X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3R8X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3J7V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N2H0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Madeira Park',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4A5V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4M3J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C3W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X1A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6W1H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6V2R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3N4P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5T1Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N1T0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Garibaldi Highlands',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7P3H8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'North Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7P2W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'North Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P2R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6E4N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4N3N9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3M5Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'New Westminster',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3J5A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V1M2H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Langley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A2E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E1V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C1T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4X2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E1S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E1Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C3M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A5H5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A2W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A2W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C3K8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X1M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6V2S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X2G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5T4L3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7W2B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'West Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5R4S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V0N3A0',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Sechelt',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7J2V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'North Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6G2Z6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6G2V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z2M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z1P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X3E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3A7R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Langley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K1S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5H4J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4A6G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3X1M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3E2C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5R3T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L3S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L2B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1Y2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1G9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K1Z3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3Z9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1C8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1P2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N5R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M4V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M4V2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K2R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L2M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L3A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K4X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N5M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L4Y1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M4G6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L4Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A2Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L2T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L2T2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K1Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N1L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6J1A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6C3E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6H3R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X2N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6E4A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6E2K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5H2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L2M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z2N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6G2L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6K4K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6C3L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M2Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5V2T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N4M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6G1Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6E2E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6B1V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A1H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L4Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M4T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K3K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L5C9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M4T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N5K1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5M4T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L1R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6N3E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4J4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z3L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M1R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M1W9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z3S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M2V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M4B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P6R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6N4B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M2B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z3N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M4H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M1R8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6J4B7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P6A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M4E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z3M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4R3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M1T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M1T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4E6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M1W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3E8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P5C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4J2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4M6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P6H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z2P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z4G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M1W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P6G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3V9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z4P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M4C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C6C6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M2A3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6A3Z7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z1K5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5V1Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X2E3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G1J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2Y1A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Langley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5A4S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4C6P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3B6J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5H4L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K1W7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Z2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y2B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X2X9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C3K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5E2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E6J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A1W5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4M5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E2V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3G1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5E7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A3B5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E1Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X1A7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3W1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3M1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A2Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4C3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4L7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A1Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E3N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E3M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E1Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4C2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E3T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C4R5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C3V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4E9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E6J7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E2Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4W6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E4Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X2T1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1M3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A1Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C1W4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E2T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5C4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7E6K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7A4R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X1B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y3Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3G4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5J5J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5S2V8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5A4M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5T1G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B2X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6E4L2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Y2P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5L3X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5H4M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5E1K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3Z5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B3M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B2Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3C3E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Port Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4W1N4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Langley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4G1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3X3G8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Surrey',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3L3T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'New Westminster',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3H4Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Anmore',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3E1X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3C5X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Port Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5A1V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G1G3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B1S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B3A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B3T9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B2X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4P8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3T8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C1M2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B1M4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4E1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2J3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5K4Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C6C7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B3X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B2N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2L5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4H9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B1R1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5Y8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2E5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C6K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5A2P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B4S4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W2J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X2T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X2S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P3P3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W3A4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W2Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W2V1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W2T7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P3K2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P4W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P3K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X2P9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X3H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y2R6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P3X1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P3T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X2T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y2S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P5X8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6Y1Y7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6V2B4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3A8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3Y9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V7C5P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6X3X7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.1648000',
                'longitude' => '-123.1330000',
                'city' => 'Richmond',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5M8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2J5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5G4K4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5A5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C4B2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C4B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5B1S9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C5T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C1S1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3K6A9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C2K3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3T5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3Y6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P4N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P4N6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W4B9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W3A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Y3V4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W4A1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5S1J8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P2P6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3V6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P2W3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X4N5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X4L6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P6P5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5S2M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W3Z4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X4S8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X4M9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P1R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W1W2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P3X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W4C1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X2R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P2S2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W1T4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P4B3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3H2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P6R9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3T3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3Y4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3V5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P2X3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W4B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3K7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P3R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3K6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X1Z8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3N7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3X4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P2X2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3Y3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Y2R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3H3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P2V7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P4N3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5S2J9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W1T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3H4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P2P7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Z3A2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6P3H6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X1L8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P1P4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5W2E4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X1J6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5X3T6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5Y1M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3K2V3',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5H1A6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5P2P1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5N2S6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5C3R2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4R1N1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Maple Ridge',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4K3K9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3Y1Z1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Pitt Meadows',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3A1B1',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Langley',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3N1G7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6H1G5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4E1N2',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Delta',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6M3W8',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6R4L9',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V2X9B6',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Maple Ridge',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V3K2M7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Coquitlam',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V6K3R7',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Vancouver',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V5A4R4',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.1164000',
                'city' => 'Burnaby',
                'full_state' => 'British Columbia',
            ],
            [
                'zip' => 'V4C2X5',
                'country_code' => 'CA',
                'state' => 'BC',
                'latitude' => '49.2820000',
                'longitude' => '-123.116400