<?php

namespace Database\Seeders\DummyData;

use App\Models\Product;
use App\Models\ProductBrand;
use App\Models\ProductPricing;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Product::query()->firstOr(function () {
            /** @var ProductBrand $brand */
            $brand = ProductBrand::query()->create([
                'name' => 'Rolex',
            ]);

            $productOne = Product::query()->create([
                'brand_id' => $brand->id,
                'type' => 'standard',
                'sku' => 'ROLEX_1263310013',
                'name' => 'Rolex Datejust 41 Rolesor - Fluted Jubilee - MOP Diamond Dial',
                'weight' => 0.32,
                'weight_unit' => 'lb',
                'length' => 7.04,
                'width' => 5.04,
                'height' => 3.07,
                'dimension_unit' => 'in',
                'case_dimension_unit' => 'in',
                'daily_average_consumption' => 0.0000,
                'unit_cost' => 0.00,
            ]);

            ProductPricing::query()->create([
                'product_pricing_tier_id' => 1,
                'product_id' => $productOne->id,
                'price' => 19995.00,
            ]);

            $productTwo = Product::query()->create([
                'brand_id' => $brand->id,
                'type' => 'standard',
                'sku' => 'ROLEX_1263340001',
                'name' => 'Rolex Datejust 41 SS - Fluted Oyster - Blue Index Dial',
                'weight' => 0.22,
                'weight_unit' => 'lb',
                'length' => 7.04,
                'width' => 5.04,
                'height' => 3.07,
                'dimension_unit' => 'in',
                'case_dimension_unit' => 'in',
                'daily_average_consumption' => 0.0000,
                'unit_cost' => 0.00,
            ]);

            ProductPricing::query()->create([
                'product_pricing_tier_id' => 1,
                'product_id' => $productTwo->id,
                'price' => 13995.00,
            ]);
        });
    }
}
