<?php

namespace Database\Seeders;

use Database\Seeders\ImmutableData\CAZipCodes\CAZipSeeder;
use Database\Seeders\ImmutableData\ConstantsContinentsSeeder;
use Database\Seeders\ImmutableData\ConstantsCountriesSeeder;
use Database\Seeders\ImmutableData\ConstantsCurrenciesSeeder;
use Database\Seeders\ImmutableData\ConstantsStatesSeeder;
use Database\Seeders\ImmutableData\USZipCodes\USZipSeeder;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DatabaseConstantsSeeder extends Seeder
{
    /**
     * Seed the constants tables
     */
    public function run(): void
    {
        $this->call(ConstantsCurrenciesSeeder::class);
        $this->call(ConstantsCountriesSeeder::class);
        $this->call(ConstantsStatesSeeder::class);
        $this->call(ConstantsContinentsSeeder::class);

        DB::table('constants_zipcodes')->delete();
        $this->call(CAZipSeeder::class);
        $this->call(USZipSeeder::class);
    }
}
