/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accounting_transaction_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_transaction_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_transaction_id` bigint(20) unsigned NOT NULL,
  `type` varchar(255) NOT NULL,
  `nominal_code_id` bigint(20) unsigned NOT NULL,
  `description` varchar(500) NOT NULL,
  `quantity` decimal(9,4) NOT NULL,
  `amount` decimal(12,4) NOT NULL,
  `tax_amount` decimal(12,4) DEFAULT NULL,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_transaction_line` (`accounting_transaction_id`,`type`,`link_id`,`link_type`),
  KEY `accounting_transaction_lines_link_id_link_type_index` (`link_id`,`link_type`),
  KEY `accounting_transaction_lines_accounting_transaction_id_index` (`accounting_transaction_id`),
  KEY `accounting_transaction_lines_nominal_code_id_index` (`nominal_code_id`),
  KEY `accounting_transaction_lines_tax_rate_id_index` (`tax_rate_id`),
  CONSTRAINT `accounting_transaction_lines_accounting_transaction_id_foreign` FOREIGN KEY (`accounting_transaction_id`) REFERENCES `accounting_transactions` (`id`),
  CONSTRAINT `accounting_transaction_lines_nominal_code_id_foreign` FOREIGN KEY (`nominal_code_id`) REFERENCES `nominal_codes` (`id`),
  CONSTRAINT `accounting_transaction_lines_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `accounting_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_date` datetime NOT NULL,
  `type` varchar(255) NOT NULL,
  `name` text DEFAULT NULL,
  `email` text DEFAULT NULL,
  `total` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `currency_code` char(3) DEFAULT NULL,
  `currency_rate` decimal(12,4) DEFAULT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `is_batchable` tinyint(1) NOT NULL DEFAULT 0,
  `reference` varchar(255) NOT NULL,
  `is_tax_included` tinyint(1) DEFAULT NULL,
  `accounting_integration_id` bigint(20) unsigned DEFAULT NULL,
  `accounting_integration_type` varchar(255) DEFAULT NULL,
  `submission_started_at` datetime DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `allocated_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `accounting_transactions_link_id_link_type_unique` (`link_id`,`link_type`),
  KEY `accounting_index` (`accounting_integration_id`,`accounting_integration_type`),
  KEY `accounting_transactions_type_reference_index` (`type`,`reference`),
  KEY `accounting_transactions_type_index` (`type`),
  KEY `accounting_transactions_reference_index` (`reference`),
  KEY `accounting_transactions_parent_id_index` (`parent_id`),
  KEY `accounting_transactions_tax_rate_id_index` (`tax_rate_id`),
  CONSTRAINT `accounting_transactions_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `accounting_transactions` (`id`),
  CONSTRAINT `accounting_transactions_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(255) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_type` varchar(255) DEFAULT NULL,
  `event` varchar(255) DEFAULT NULL,
  `subject_id` bigint(20) unsigned DEFAULT NULL,
  `parent_subject_id` bigint(20) unsigned DEFAULT NULL,
  `causer_type` varchar(255) DEFAULT NULL,
  `causer_id` bigint(20) unsigned DEFAULT NULL,
  `properties` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`properties`)),
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`metadata`)),
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject_type`,`subject_id`),
  KEY `causer` (`causer_type`,`causer_id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `addressables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addressables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `address_id` bigint(20) unsigned NOT NULL,
  `addressable_id` bigint(20) unsigned NOT NULL,
  `addressable_type` varchar(255) NOT NULL,
  `is_default` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `addressables_address_id_addressable_id_addressable_type_unique` (`address_id`,`addressable_id`,`addressable_type`),
  KEY `addressables_address_id_index` (`address_id`),
  KEY `addressables_addresssble_id_index` (`addressable_id`),
  KEY `addressables_addressable_id_addressable_type_address_id` (`addressable_id`,`addressable_type`,`address_id`),
  CONSTRAINT `addressables_address_id_foreign` FOREIGN KEY (`address_id`) REFERENCES `addresses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company` varchar(255) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `email` text DEFAULT NULL,
  `phone` text DEFAULT NULL,
  `fax` text DEFAULT NULL,
  `address1` text DEFAULT NULL,
  `address2` text DEFAULT NULL,
  `address3` text DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `province` varchar(255) DEFAULT NULL,
  `province_code` char(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `country_code` char(255) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `hash` char(32) CHARACTER SET ascii COLLATE ascii_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_inbound_shipment_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_inbound_shipment_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_fba_inbound_shipment_id` bigint(20) unsigned NOT NULL,
  `SellerSKU` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SellerSKU'))) STORED,
  `FulfillmentNetworkSKU` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.FulfillmentNetworkSKU'))) STORED,
  `QuantityShipped` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.QuantityShipped'))) STORED,
  `QuantityReceived` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.QuantityReceived'))) STORED,
  `QuantityInCase` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.QuantityInCase'))) STORED,
  `ReleaseDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ReleaseDate'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `amazon_fba_inbound_shipment_id_index` (`amazon_fba_inbound_shipment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_inbound_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_inbound_shipments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `sku_link_id` bigint(20) unsigned DEFAULT NULL,
  `sku_link_type` varchar(255) DEFAULT NULL,
  `is_before_initial_count` tinyint(1) NOT NULL DEFAULT 0,
  `ShipmentId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShipmentId'))) STORED,
  `ShipmentName` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShipmentName'))) STORED,
  `ShipFromName` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShipFromAddress.Name'))) STORED,
  `DestinationFulfillmentCenterId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.DestinationFulfillmentCenterId'))) STORED,
  `ShipmentStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShipmentStatus'))) STORED,
  `LabelPrepType` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.LabelPrepType'))) STORED,
  `BoxContentsSource` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.BoxContentsSource'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `skuLinkIndex` (`sku_link_id`,`sku_link_type`),
  KEY `integrationInstanceIndex` (`integration_instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_customer_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_customer_returns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` text DEFAULT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `return_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.return_date'))) STORED,
  `event_datetime` datetime NOT NULL,
  `order_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_id'))) STORED,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `asin` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.asin'))) STORED,
  `fnsku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fnsku'))) STORED,
  `product_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_name'))) STORED,
  `quantity` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity'))) STORED,
  `fulfillment_center_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillment_center_id'))) STORED,
  `detailed_disposition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.detailed_disposition'))) STORED,
  `reason` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.reason'))) STORED,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.status'))) STORED,
  `license_plate_number` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.license_plate_number'))) STORED,
  `customer_comments` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer_comments'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `amazon_fba_report_customer_returns_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_fba_report_customer_returns_amazon_report_id_foreign` (`amazon_report_id`),
  CONSTRAINT `amazon_fba_report_customer_returns_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_inventory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` varchar(255) NOT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `fnsku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fnsku'))) STORED,
  `product_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_name'))) STORED,
  `condition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.condition'))) STORED,
  `your_price` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.your_price'))) STORED,
  `mfn_listing_exists` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.mfn_listing_exists'))) STORED,
  `mfn_fulfillable_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.mfn_fulfillable_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.mfn_fulfillable_quantity')) as unsigned) end) STORED,
  `afn_listing_exists` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.afn_listing_exists'))) STORED,
  `afn_warehouse_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_warehouse_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_warehouse_quantity')) as unsigned) end) STORED,
  `afn_fulfillable_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_fulfillable_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_fulfillable_quantity')) as unsigned) end) STORED,
  `afn_unsellable_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_unsellable_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_unsellable_quantity')) as unsigned) end) STORED,
  `afn_reserved_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_reserved_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_reserved_quantity')) as unsigned) end) STORED,
  `afn_total_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_total_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_total_quantity')) as unsigned) end) STORED,
  `per_unit_volume` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.per_unit_volume')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.per_unit_volume')) as decimal(12,4)) end) STORED,
  `afn_inbound_working_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_inbound_working_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_inbound_working_quantity')) as unsigned) end) STORED,
  `afn_inbound_shipped_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_inbound_shipped_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_inbound_shipped_quantity')) as unsigned) end) STORED,
  `afn_inbound_receiving_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_inbound_receiving_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_inbound_receiving_quantity')) as unsigned) end) STORED,
  `afn_researching_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_researching_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_researching_quantity')) as unsigned) end) STORED,
  `afn_reserved_future_supply` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_reserved_future_supply')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_reserved_future_supply')) as unsigned) end) STORED,
  `afn_future_supply_buyable` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.afn_future_supply_buyable')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.afn_future_supply_buyable')) as unsigned) end) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `amazon_fba_report_inventory_integration_instance_id_sku_unique` (`integration_instance_id`,`sku`),
  KEY `amazon_fba_report_inventory_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_fba_report_inventory_amazon_report_id_foreign` (`amazon_report_id`),
  CONSTRAINT `amazon_fba_report_inventory_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_inventory_ledger`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_inventory_ledger` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` text DEFAULT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `sku_link_id` bigint(20) unsigned DEFAULT NULL,
  `sku_link_type` varchar(255) DEFAULT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `amazon_product_id` bigint(20) unsigned DEFAULT NULL,
  `detail_id` bigint(20) unsigned DEFAULT NULL,
  `detail_type` varchar(255) DEFAULT NULL,
  `auditTrailError` varchar(255) DEFAULT NULL,
  `date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.date'))) STORED,
  `event_datetime` datetime NOT NULL,
  `fnsku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fnsku'))) STORED,
  `asin` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.asin'))) STORED,
  `msku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.msku'))) STORED,
  `title` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.title'))) STORED,
  `event_type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.event_type'))) STORED,
  `reference_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.reference_id'))) STORED,
  `quantity` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity'))) STORED,
  `fulfillment_center` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillment_center'))) STORED,
  `disposition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.disposition'))) STORED,
  `reason` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.reason'))) STORED,
  `country` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.country'))) STORED,
  `reconciled_quantity` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.reconciled_quantity'))) STORED,
  `unreconciled_quantity` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.unreconciled_quantity'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `last_processed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sku_link_id_sku_link_type` (`sku_link_id`,`sku_link_type`),
  KEY `msku_index` (`integration_instance_id`,`msku`),
  KEY `amazon_fba_report_inventory_ledger_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_fba_report_inventory_ledger_detail_id_detail_type_index` (`detail_id`,`detail_type`),
  KEY `amazon_fba_report_inventory_ledger_amazon_report_id_foreign` (`amazon_report_id`),
  KEY `amazon_fba_report_inventory_ledger_amazon_product_id_index` (`amazon_product_id`),
  KEY `amazon_fba_report_inventory_ledger_fnsku_index` (`integration_instance_id`,`fnsku`),
  CONSTRAINT `amazon_fba_report_inventory_ledger_amazon_product_id_foreign` FOREIGN KEY (`amazon_product_id`) REFERENCES `amazon_products` (`id`),
  CONSTRAINT `amazon_fba_report_inventory_ledger_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_inventory_ledger_summaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_inventory_ledger_summaries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` text DEFAULT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `amazon_product_id` bigint(20) unsigned DEFAULT NULL,
  `fifo_layer_id` bigint(20) unsigned DEFAULT NULL,
  `sku_product_initialized_at` timestamp NULL DEFAULT NULL,
  `date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.date'))) STORED,
  `fnsku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fnsku'))) STORED,
  `asin` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.asin'))) STORED,
  `msku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.msku'))) STORED,
  `title` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.title'))) STORED,
  `disposition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.disposition'))) STORED,
  `starting_warehouse_balance` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.starting_warehouse_balance'))) STORED,
  `in_transit_between_warehouses` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.in_transit_between_warehouses'))) STORED,
  `receipts` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.receipts'))) STORED,
  `customer_shipments` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer_shipments'))) STORED,
  `customer_returns` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer_returns'))) STORED,
  `vendor_returns` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.vendor_returns'))) STORED,
  `warehouse_transfer_in_out` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.warehouse_transfer_in_out'))) STORED,
  `found` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.found'))) STORED,
  `lost` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.lost'))) STORED,
  `damaged` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.damaged'))) STORED,
  `disposed` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.disposed'))) STORED,
  `other_events` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.other_events'))) STORED,
  `ending_warehouse_balance` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ending_warehouse_balance'))) STORED,
  `unknown_events` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.unknown_events'))) STORED,
  `location` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.location'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `report_id_foreign` (`amazon_report_id`),
  KEY `product_id_foreign` (`amazon_product_id`),
  KEY `fifo_layer_id_foreign` (`fifo_layer_id`),
  KEY `msku_index` (`integration_instance_id`,`msku`),
  KEY `instance_id_foreign` (`integration_instance_id`),
  KEY `amazon_fba_report_inventory_ledger_summaries_fnsku_index` (`integration_instance_id`,`fnsku`),
  CONSTRAINT `fifo_layer_id_foreign` FOREIGN KEY (`fifo_layer_id`) REFERENCES `fifo_layers` (`id`),
  CONSTRAINT `product_id_foreign` FOREIGN KEY (`amazon_product_id`) REFERENCES `amazon_products` (`id`),
  CONSTRAINT `report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_removal_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_removal_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` varchar(255) NOT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `sku_link_id` bigint(20) unsigned DEFAULT NULL,
  `sku_link_type` varchar(255) DEFAULT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `request_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.request_date'))) STORED,
  `order_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_id'))) STORED,
  `order_type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_type'))) STORED,
  `order_status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_status'))) STORED,
  `last_updated_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.last_updated_date'))) STORED,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `fnsku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fnsku'))) STORED,
  `disposition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.disposition'))) STORED,
  `requested_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.requested_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.requested_quantity')) as unsigned) end) STORED,
  `cancelled_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.cancelled_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.cancelled_quantity')) as unsigned) end) STORED,
  `disposed_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.disposed_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.disposed_quantity')) as unsigned) end) STORED,
  `shipped_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.shipped_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.shipped_quantity')) as unsigned) end) STORED,
  `in_process_quantity` int(10) unsigned GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.in_process_quantity')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.in_process_quantity')) as unsigned) end) STORED,
  `removal_fee` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.removal_fee')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.removal_fee')) as decimal(12,4)) end) STORED,
  `currency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.currency'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sku_link_id_sku_link_type` (`sku_link_id`,`sku_link_type`),
  KEY `amazon_fba_report_removal_orders_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_fba_report_removal_orders_amazon_report_id_foreign` (`amazon_report_id`),
  CONSTRAINT `amazon_fba_report_removal_orders_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_removal_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_removal_shipments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` text DEFAULT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `request_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.request_date'))) STORED,
  `order_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_id'))) STORED,
  `shipment_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipment_date'))) STORED,
  `event_datetime` datetime NOT NULL,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `fnsku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fnsku'))) STORED,
  `disposition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.disposition'))) STORED,
  `shipped_quantity` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipped_quantity'))) STORED,
  `carrier` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.carrier'))) STORED,
  `tracking_number` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.tracking_number'))) STORED,
  `removal_order_type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.removal_order_type'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `integrationInstanceIndex` (`integration_instance_id`),
  KEY `amazon_fba_report_removal_shipments_amazon_report_id_foreign` (`amazon_report_id`),
  CONSTRAINT `amazon_fba_report_removal_shipments_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_restock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_restock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` text DEFAULT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `country` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.country'))) STORED,
  `product_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_name'))) STORED,
  `fnsku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fnsku'))) STORED,
  `merchant_sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.merchant_sku'))) STORED,
  `asin` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.asin'))) STORED,
  `condition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.condition'))) STORED,
  `supplier` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.supplier'))) STORED,
  `supplier_part_no` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.supplier_part_no'))) STORED,
  `currency_code` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.currency_code'))) STORED,
  `price` double(12,4) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.price'))) STORED,
  `sales_last_30_days` double(12,4) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sales_last_30_days'))) STORED,
  `units_sold_last_30_days` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.units_sold_last_30_days'))) STORED,
  `total_units` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total_units'))) STORED,
  `inbound` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.inbound'))) STORED,
  `available` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.available'))) STORED,
  `fc_transfer` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fc_transfer'))) STORED,
  `fc_processing` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fc_processing'))) STORED,
  `customer_order` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer_order'))) STORED,
  `unfulfillable` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.unfulfillable'))) STORED,
  `fulfilled_by` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfilled_by'))) STORED,
  `total_days_of_supply` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total_days_of_supply'))) STORED,
  `days_of_supply_at_amazon_fulfillment_network` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.days_of_supply_at_amazon_fulfillment_network'))) STORED,
  `alert` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.alert'))) STORED,
  `recommended_ship_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.recommended_ship_date'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `working` int(11) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.working')) using utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.working')) end) STORED,
  `shipped` int(11) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.shipped')) using utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.shipped')) end) STORED,
  `receiving` int(11) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.receiving')) using utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.receiving')) end) STORED,
  `recommended_replenishment_qty` int(11) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.recommended_replenishment_qty')) using utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.recommended_replenishment_qty')) end) STORED,
  PRIMARY KEY (`id`),
  KEY `amazon_fba_report_restock_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_fba_report_restock_amazon_report_id_foreign` (`amazon_report_id`),
  CONSTRAINT `amazon_fba_report_restock_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fba_report_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fba_report_shipments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` varchar(255) NOT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `amazon_order_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amazon_order_id'))) STORED,
  `merchant_order_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.merchant_order_id'))) STORED,
  `shipment_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipment_id'))) STORED,
  `shipment_item_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipment_item_id'))) STORED,
  `amazon_order_item_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amazon_order_item_id'))) STORED,
  `merchant_order_item_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.merchant_order_item_id'))) STORED,
  `purchase_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.purchase_date'))) STORED,
  `payments_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.payments_date'))) STORED,
  `shipment_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipment_date'))) STORED,
  `reporting_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.reporting_date'))) STORED,
  `event_datetime` datetime NOT NULL,
  `buyer_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.buyer_name'))) STORED,
  `buyer_phone_number` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.buyer_phone_number'))) STORED,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `product_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_name'))) STORED,
  `quantity_shipped` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity_shipped'))) STORED,
  `currency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.currency'))) STORED,
  `item_price` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.item_price')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.item_price')) as decimal(12,4)) end) STORED,
  `shipping_price` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.shipping_price')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.shipping_price')) as decimal(12,4)) end) STORED,
  `shipping_tax` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.shipping_tax')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.shipping_tax')) as decimal(12,4)) end) STORED,
  `gift_wrap_price` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.gift_wrap_price')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.gift_wrap_price')) as decimal(12,4)) end) STORED,
  `gift_wrap_tax` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.gift_wrap_tax')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.gift_wrap_tax')) as decimal(12,4)) end) STORED,
  `item_tax` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.item_tax')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.item_tax')) as decimal(12,4)) end) STORED,
  `ship_service_level` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_service_level'))) STORED,
  `recipient_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.recipient_name'))) STORED,
  `ship_address_1` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_address_1'))) STORED,
  `ship_address_2` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_address_2'))) STORED,
  `ship_address_3` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_address_3'))) STORED,
  `ship_city` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_city'))) STORED,
  `ship_state` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_state'))) STORED,
  `ship_postal_code` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_postal_code'))) STORED,
  `ship_country` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_country'))) STORED,
  `ship_phone_number` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_phone_number'))) STORED,
  `bill_address_1` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.bill_address_1'))) STORED,
  `bill_address_2` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.bill_address_2'))) STORED,
  `bill_address_3` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.bill_address_3'))) STORED,
  `bill_city` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.bill_city'))) STORED,
  `bill_state` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.bill_state'))) STORED,
  `bill_postal_code` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.bill_postal_code'))) STORED,
  `bill_country` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.bill_country'))) STORED,
  `item_promotion_discount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.item_promotion_discount'))) STORED,
  `ship_promotion_discount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ship_promotion_discount'))) STORED,
  `carrier` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.carrier'))) STORED,
  `tracking_number` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.tracking_number'))) STORED,
  `estimated_arrival_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.estimated_arrival_date'))) STORED,
  `fulfillment_center_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillment_center_id'))) STORED,
  `fulfillment_channel` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillment_channel'))) STORED,
  `sales_channel` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sales_channel'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `amazon_fba_report_shipments_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_fba_report_shipments_amazon_report_id_foreign` (`amazon_report_id`),
  CONSTRAINT `amazon_fba_report_shipments_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_feed_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_feed_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `feedType` varchar(255) NOT NULL,
  `marketplaceIds` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`marketplaceIds`)),
  `feedOptions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`feedOptions`)),
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`metadata`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `amazon_feed_requests_integration_instance_id_index` (`integration_instance_id`),
  CONSTRAINT `amazon_feed_requests_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_feed_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_feed_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `feedId` varchar(255) DEFAULT NULL,
  `feedType` varchar(255) DEFAULT NULL,
  `marketplaceIds` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`marketplaceIds`)),
  `inputFeedDocumentId` varchar(255) DEFAULT NULL,
  `feedOptions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`feedOptions`)),
  `createdTime` varchar(255) DEFAULT NULL,
  `processingStatus` varchar(255) DEFAULT NULL,
  `processingStartTime` varchar(255) DEFAULT NULL,
  `processingEndTime` varchar(255) DEFAULT NULL,
  `resultFeedDocumentId` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `compressionAlgorithm` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `amazon_feed_submissions_feedid_unique` (`feedId`),
  KEY `amazon_feed_submissions_integration_instance_id_index` (`integration_instance_id`),
  CONSTRAINT `amazon_feed_submissions_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_financial_event_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_financial_event_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `accounting_status` varchar(255) DEFAULT NULL,
  `FinancialEventGroupId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.FinancialEventGroupId'))) STORED,
  `ProcessingStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ProcessingStatus'))) STORED,
  `FundTransferStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.FundTransferStatus'))) STORED,
  `OriginalTotalCurrencyCode` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.OriginalTotal.CurrencyCode'))) STORED,
  `OriginalTotalCurrencyAmount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.OriginalTotal.CurrencyAmount'))) STORED,
  `ConvertedTotalCurrencyCode` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ConvertedTotal.CurrencyCode'))) STORED,
  `ConvertedTotalCurrencyAmount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ConvertedTotal.CurrencyAmount'))) STORED,
  `FundTransferDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.FundTransferDate'))) STORED,
  `TraceId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.TraceId'))) STORED,
  `AccountTail` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.AccountTail'))) STORED,
  `BeginningBalanceCurrencyCode` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.BeginningBalance.CurrencyCode'))) STORED,
  `BeginningBalanceCurrencyAmount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.BeginningBalance.CurrencyAmount'))) STORED,
  `FinancialEventGroupStart` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.FinancialEventGroupStart'))) STORED,
  `FinancialEventGroupStart_datetime` datetime DEFAULT NULL,
  `FinancialEventGroupEnd` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.FinancialEventGroupEnd'))) STORED,
  `FinancialEventGroupEnd_datetime` datetime DEFAULT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fnsku_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fnsku_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `fnsku` varchar(255) NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `fba_initialized_at` datetime DEFAULT NULL,
  `warehouse_transfer_balance` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `amazon_fnsku_products_integration_instance_id_fnsku_unique` (`integration_instance_id`,`fnsku`),
  KEY `amazon_fnsku_products_product_id_index` (`product_id`),
  CONSTRAINT `amazon_fnsku_products_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`),
  CONSTRAINT `amazon_fnsku_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fulfillment_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fulfillment_order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_fulfillment_order_id` bigint(20) unsigned NOT NULL,
  `sellerSku` varchar(255) NOT NULL,
  `sellerFulfillmentOrderItemId` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL,
  `giftMessage` varchar(255) NOT NULL,
  `displayableComment` varchar(255) NOT NULL,
  `fulfillmentNetworkSku` varchar(255) NOT NULL,
  `orderItemDisposition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.orderItemDisposition'))) STORED,
  `cancelledQuantity` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.cancelledQuantity'))) STORED,
  `unfulfillableQuantity` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.unfulfillableQuantity'))) STORED,
  `estimatedShipDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.estimatedShipDate'))) STORED,
  `estimatedArrivalDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.estimatedArrivalDate'))) STORED,
  `perUnitPriceCurrencyCode` varchar(255) NOT NULL,
  `perUnitPriceCurrencyValue` decimal(12,4) NOT NULL,
  `perUnitTaxCurrencyCode` varchar(255) NOT NULL,
  `perUnitTaxValue` decimal(12,4) NOT NULL,
  `perUnitDeclaredValueCurrencyCode` varchar(255) NOT NULL,
  `perUnitDeclaredValueValue` decimal(12,4) NOT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fulfillmentOrderIndex` (`amazon_fulfillment_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fulfillment_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fulfillment_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `sellerFulfillmentOrderId` varchar(255) NOT NULL,
  `marketplaceId` varchar(255) NOT NULL,
  `displayableOrderId` varchar(255) NOT NULL,
  `displayableOrderDate` varchar(255) NOT NULL,
  `displayableOrderComment` varchar(255) NOT NULL,
  `shippingSpeedCategory` varchar(255) NOT NULL,
  `deliveryWindow` varchar(255) NOT NULL,
  `destinationAddress` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`destinationAddress`)),
  `fulfillmentAction` varchar(255) NOT NULL,
  `fulfillmentPolicy` varchar(255) NOT NULL,
  `codSettings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`codSettings`)),
  `receivedDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.receivedDate'))) STORED,
  `fulfillmentOrderStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillmentOrderStatus'))) STORED,
  `statusUpdatedDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.statusUpdatedDate'))) STORED,
  `notificationEmails` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`notificationEmails`)),
  `featureConstraints` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`featureConstraints`)),
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `integrationInstanceIndex` (`integration_instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fulfillment_return_authorizations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fulfillment_return_authorizations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_fulfillment_order_id` bigint(20) unsigned NOT NULL,
  `returnAuthorizationId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.returnAuthorizationId'))) STORED,
  `fulfillmentCenterId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillmentCenterId'))) STORED,
  `returnToAddress` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.returnToAddress'))) STORED CHECK (json_valid(`returnToAddress`)),
  `amazonRmaId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amazonRmaId'))) STORED,
  `rmaPageURL` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.rmaPageURL'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fulfillmentOrderIndex` (`amazon_fulfillment_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fulfillment_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fulfillment_return_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_fulfillment_shipment_item_id` bigint(20) unsigned NOT NULL,
  `sellerReturnId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sellerReturnId'))) STORED,
  `sellerFulfillmentOrderItemId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sellerFulfillmentOrderItemId'))) STORED,
  `amazonShipmentId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amazonShipmentId'))) STORED,
  `sellerReturnReasonCode` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sellerReturnReasonCode'))) STORED,
  `returnComment` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.returnComment'))) STORED,
  `amazonReturnReasonCode` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amazonReturnReasonCode'))) STORED,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.status'))) STORED,
  `statusChangedDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.statusChangedDate'))) STORED,
  `returnAuthorizationId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.returnAuthorizationId'))) STORED,
  `returnReceivedCondition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.returnReceivedCondition'))) STORED,
  `fulfillmentCenterId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillmentCenterId'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fulfillmentShipmentItemIndex` (`amazon_fulfillment_shipment_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fulfillment_shipment_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fulfillment_shipment_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_fulfillment_shipment_id` bigint(20) unsigned NOT NULL,
  `sellerSku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sellerSku'))) STORED,
  `sellerFulfillmentOrderItemId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sellerFulfillmentOrderItemId'))) STORED,
  `quantity` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity'))) STORED,
  `packageNumber` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.packageNumber'))) STORED,
  `serialNumber` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.serialNumber'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fulfillmentShipmentIndex` (`amazon_fulfillment_shipment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fulfillment_shipment_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fulfillment_shipment_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_fulfillment_shipment_id` bigint(20) unsigned NOT NULL,
  `packageNumber` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.packageNumber'))) STORED,
  `carrierCode` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.carrierCode'))) STORED,
  `trackingNumber` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.trackingNumber'))) STORED,
  `estimatedArrivalDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.estimatedArrivalDate'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fulfillmentShipmentIndex` (`amazon_fulfillment_shipment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_fulfillment_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_fulfillment_shipments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_fulfillment_order_id` bigint(20) unsigned NOT NULL,
  `amazonShipmentId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amazonShipmentId'))) STORED,
  `fulfillmentCenterId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillmentCenterId'))) STORED,
  `fulfillmentShipmentStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillmentShipmentStatus'))) STORED,
  `shippingDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shippingDate'))) STORED,
  `estimatedArrivalDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.estimatedArrivalDate'))) STORED,
  `shippingNotes` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shippingNotes'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fulfillmentOrderIndex` (`amazon_fulfillment_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amazon_order_id` bigint(20) unsigned NOT NULL,
  `ASIN` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ASIN'))) STORED,
  `SellerSKU` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SellerSKU'))) STORED,
  `seller_sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SellerSKU'))) STORED,
  `OrderItemId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.OrderItemId'))) STORED,
  `Title` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Title'))) STORED,
  `QuantityOrdered` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.QuantityOrdered'))) STORED,
  `QuantityShipped` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.QuantityShipped'))) STORED,
  `ItemCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ItemPrice.CurrencyCode'))) STORED,
  `ItemPrice` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ItemPrice.Amount'))) STORED,
  `ShippingPrice` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShippingPrice.Amount'))) STORED,
  `ItemTax` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ItemTax.Amount'))) STORED,
  `ShippingTax` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShippingTax.Amount'))) STORED,
  `ShippingDiscount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShippingDiscount.Amount'))) STORED,
  `ShippingDiscountTax` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShippingDiscountTax.Amount'))) STORED,
  `PromotionDiscount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.PromotionDiscount.Amount'))) STORED,
  `PromotionDiscountTax` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.PromotionDiscountTax.Amount'))) STORED,
  `CODFee` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.CODFee.Amount'))) STORED,
  `CODFeeDiscount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.CODFeeDiscount.Amount'))) STORED,
  `IsGift` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.IsGift'))) STORED,
  `ConditionNote` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ConditionNote'))) STORED,
  `ConditionId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ConditionId'))) STORED,
  `ConditionSubtypeId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ConditionSubtypeId'))) STORED,
  `ScheduledDeliveryStartDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ScheduledDeliveryStartDate'))) STORED,
  `ScheduledDeliveryEndDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ScheduledDeliveryEndDate'))) STORED,
  `PriceDesignation` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.PriceDesignation'))) STORED,
  `SerialNumberRequired` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SerialNumberRequired'))) STORED,
  `IsTransparency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.IsTransparency'))) STORED,
  `IossNumber` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.IossNumber'))) STORED,
  `StoreChainStoreId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.StoreChainStoreId'))) STORED,
  `DeemedResellerCategory` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.DeemedResellerCategory'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `amazon_order_items_amazon_order_id_orderitemid_unique` (`amazon_order_id`,`OrderItemId`),
  KEY `amazon_order_items_amazon_order_id_index` (`amazon_order_id`),
  KEY `amazon_order_items_orderitemid_index` (`OrderItemId`),
  CONSTRAINT `amazon_order_items_amazon_order_id_foreign` FOREIGN KEY (`amazon_order_id`) REFERENCES `amazon_orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `AmazonOrderId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.AmazonOrderId'))) STORED,
  `SellerOrderId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SellerOrderId'))) STORED,
  `PurchaseDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.PurchaseDate'))) STORED,
  `PurchaseDateUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.PurchaseDateUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `AmazonPurchaseDate` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.AmazonPurchaseDate')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `LastUpdateDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.LastUpdateDate'))) STORED,
  `OrderStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.OrderStatus'))) STORED,
  `error_log` varchar(255) DEFAULT NULL,
  `FulfillmentChannel` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.FulfillmentChannel'))) STORED,
  `SalesChannel` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SalesChannel'))) STORED,
  `ShipServiceLevel` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShipServiceLevel'))) STORED,
  `OrderCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.OrderTotal.CurrencyCode'))) STORED,
  `OrderTotal` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.OrderTotal.Amount'))) STORED,
  `NumberOfItemsShipped` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.NumberOfItemsShipped'))) STORED,
  `PaymentMethod` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.PaymentMethod'))) STORED,
  `MarketplaceId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.MarketplaceId'))) STORED,
  `BuyerName` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.BuyerInfo.BuyerName'))) STORED,
  `BuyerEmail` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.BuyerInfo.BuyerEmail'))) STORED,
  `PaymentMethodDetails` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.PaymentMethodDetails'))) STORED,
  `ShipmentServiceLevelCategory` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShipmentServiceLevelCategory'))) STORED,
  `OrderType` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.OrderType'))) STORED,
  `EarliestShipDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.EarliestShipDate'))) STORED,
  `EarliestShipDateUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.EarliestShipDateUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `LatestShipDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.LatestShipDate'))) STORED,
  `LatestShipDateUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.LatestShipDateUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `EarliestDeliveryDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.EarliestDeliveryDate'))) STORED,
  `EarliestDeliveryDateUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.EarliestDeliveryDateUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `LatestDeliveryDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.LatestDeliveryDate'))) STORED,
  `LatestDeliveryDateUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.LatestDeliveryDateUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `IsBusinessOrder` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.IsBusinessOrder'))) STORED,
  `IsPrime` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.IsPrime'))) STORED,
  `IsPremiumOrder` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.IsPremiumOrder'))) STORED,
  `ReplacedOrderId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ReplacedOrderId'))) STORED,
  `IsReplacementOrder` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.IsReplacementOrder'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `errors` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`errors`)),
  `archived_at` datetime DEFAULT NULL,
  `canceled_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `ShippingAddress` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ShippingAddress'))) STORED,
  `BuyerInfo` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin GENERATED ALWAYS AS (if(convert(json_unquote(json_extract(`json_object`,'$.BuyerInfo')) using utf8mb4) = '',NULL,json_unquote(json_extract(`json_object`,'$.BuyerInfo')))) STORED CHECK (json_valid(`BuyerInfo`)),
  PRIMARY KEY (`id`),
  UNIQUE KEY `amazon_orders_integration_instance_id_amazonorderid_unique` (`integration_instance_id`,`AmazonOrderId`),
  KEY `amazon_orders_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_orders_amazonorderid_index` (`AmazonOrderId`),
  CONSTRAINT `amazon_orders_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `item_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.item_name'))) STORED,
  `seller_sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.seller_sku'))) STORED,
  `price` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.price')) using utf8mb4) <> '' and convert(json_unquote(json_extract(`json_object`,'$.price')) using utf8mb4) <> 'null' then json_unquote(json_extract(`json_object`,'$.price')) else NULL end) STORED,
  `quantity` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity'))) STORED,
  `image_url` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.image_url'))) STORED,
  `product_id_type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_id_type'))) STORED,
  `item_note` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.item_note'))) STORED,
  `item_condition` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.item_condition'))) STORED,
  `asin1` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.asin1'))) STORED,
  `product_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_id'))) STORED,
  `fulfillment_channel` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillment_channel'))) STORED,
  `merchant_shipping_group` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.merchant_shipping_group'))) STORED,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.status'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `catalog_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`catalog_data`)),
  `brand` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].brand'))) STORED,
  `manufacturer` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].manufacturer'))) STORED,
  `model` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].modelNumber'))) STORED,
  `part_number` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].partNumber'))) STORED,
  `product_type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.productTypes[0].productType'))) STORED,
  `sales_rank` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.salesRanks[0].displayGroupRanks[0].rank'))) STORED,
  `color` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].color'))) STORED,
  `package_length` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].package.length.value'))) STORED,
  `package_width` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].package.width.value'))) STORED,
  `package_height` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].package.height.value'))) STORED,
  `package_dimensions_unit` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].package.length.unit'))) STORED,
  `package_weight` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].package.weight.value'))) STORED,
  `package_weight_unit` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].package.weight.unit'))) STORED,
  `main_image` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.images[0].images[0].link'))) STORED,
  `browse_classification` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].browseClassification.displayName'))) STORED,
  `open_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.open_date'))) STORED,
  `style` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].style'))) STORED,
  `size` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].size'))) STORED,
  `item_length` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].item.length.value'))) STORED,
  `item_width` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].item.width.value'))) STORED,
  `item_height` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].item.height.value'))) STORED,
  `item_dimensions_unit` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].item.length.unit'))) STORED,
  `item_weight` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].item.weight.value'))) STORED,
  `item_weight_unit` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.dimensions[0].item.weight.unit'))) STORED,
  `number_of_items` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.attributes.number_of_items[0].value'))) STORED,
  `department` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.attributes.department[0].value'))) STORED,
  `item_type_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.attributes.item_type_name[0].value'))) STORED,
  `item_type_keyword` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.attributes.item_type_keyword[0].value'))) STORED,
  `packageQuantity` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].packageQuantity'))) STORED,
  `listing_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.listing_id'))) STORED,
  `item_description` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.item_description'))) STORED,
  `material` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.attributes.material[0].value'))) STORED,
  `website_group_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`catalog_data`,'$.catalog_data.summaries[0].websiteDisplayGroupName'))) STORED,
  `catalog_data_last_sync` datetime DEFAULT NULL,
  `was_catalog_data_sync_attempted` tinyint(1) NOT NULL DEFAULT 0,
  `removed_from_amazon` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `amazon_products_integration_instance_id_seller_sku_unique` (`integration_instance_id`,`seller_sku`),
  KEY `amazon_products_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_products_seller_sku_index` (`seller_sku`),
  KEY `amazon_products_asin1_index` (`asin1`),
  CONSTRAINT `amazon_products_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_report_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_report_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `reportType` varchar(255) NOT NULL,
  `dataStartTime` datetime DEFAULT NULL,
  `dataEndTime` datetime DEFAULT NULL,
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`options`)),
  `marketplaceIds` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`marketplaceIds`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `amazon_report_requests_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_report_requests_reporttype_index` (`reportType`),
  CONSTRAINT `amazon_report_requests_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_report_settlement_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_report_settlement_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `checksum` varchar(255) NOT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `amazon_report_id` bigint(20) unsigned NOT NULL,
  `amazon_financial_event_group_id` bigint(20) unsigned NOT NULL,
  `settlement_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.settlement_id'))) STORED,
  `transaction_type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.transaction_type'))) STORED,
  `order_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_id'))) STORED,
  `merchant_order_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.merchant_order_id'))) STORED,
  `adjustment_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.adjustment_id'))) STORED,
  `shipment_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipment_id'))) STORED,
  `marketplace_name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.marketplace_name'))) STORED,
  `amount_type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amount_type'))) STORED,
  `amount_description` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amount_description'))) STORED,
  `amount` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.amount'))) STORED,
  `fulfillment_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillment_id'))) STORED,
  `posted_date` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.posted_date'))) STORED,
  `posted_date_time` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.posted_date_time'))) STORED,
  `order_item_code` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_item_code'))) STORED,
  `merchant_order_item_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.merchant_order_item_id'))) STORED,
  `merchant_adjustment_item_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.merchant_adjustment_item_id'))) STORED,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `quantity_purchased` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity_purchased'))) STORED,
  `promotion_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.promotion_id'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afeg_findex` (`amazon_financial_event_group_id`),
  KEY `amazon_report_settlement_data_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_report_settlement_data_amazon_report_id_index` (`amazon_report_id`),
  CONSTRAINT `afeg_findex` FOREIGN KEY (`amazon_financial_event_group_id`) REFERENCES `amazon_financial_event_groups` (`id`),
  CONSTRAINT `amazon_report_settlement_data_amazon_report_id_foreign` FOREIGN KEY (`amazon_report_id`) REFERENCES `amazon_reports` (`id`),
  CONSTRAINT `amazon_report_settlement_data_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_report_settlement_type_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_report_settlement_type_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `transaction_type` varchar(255) NOT NULL,
  `amount_type` varchar(255) NOT NULL,
  `amount_description` varchar(255) NOT NULL,
  `financial_code` varchar(255) GENERATED ALWAYS AS (concat(`transaction_type`,': ',`amount_type`,' - ',`amount_description`)) STORED,
  `nominal_code_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `composite_unique` (`integration_instance_id`,`transaction_type`,`amount_type`,`amount_description`),
  UNIQUE KEY `financial_code_unique` (`integration_instance_id`,`financial_code`),
  KEY `nominal_code_id` (`nominal_code_id`),
  CONSTRAINT `arstm_findex_integration_instance_id` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`),
  CONSTRAINT `nominal_code_id` FOREIGN KEY (`nominal_code_id`) REFERENCES `nominal_codes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_reports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `reportId` varchar(255) DEFAULT NULL,
  `reportType` varchar(255) NOT NULL,
  `dataStartTime` datetime DEFAULT NULL,
  `dataEndTime` datetime DEFAULT NULL,
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`options`)),
  `reportScheduledId` varchar(255) DEFAULT NULL,
  `createdTime` datetime DEFAULT NULL,
  `processingStatus` varchar(255) DEFAULT NULL,
  `processingStartTime` datetime DEFAULT NULL,
  `processingEndTime` datetime DEFAULT NULL,
  `reportDocumentId` varchar(255) DEFAULT NULL,
  `marketplaceIds` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`marketplaceIds`)),
  `filename` varchar(255) DEFAULT NULL,
  `processed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `amazon_reports_reportid_unique` (`reportId`),
  KEY `amazon_reports_integration_instance_id_index` (`integration_instance_id`),
  KEY `amazon_reports_reporttype_index` (`reportType`),
  CONSTRAINT `amazon_reports_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `amazon_reports_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amazon_reports_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `ReportRequestId` varchar(255) DEFAULT NULL,
  `ReportType` varchar(255) NOT NULL,
  `ReportProcessingStatus` varchar(255) NOT NULL,
  `Scheduled` tinyint(1) NOT NULL DEFAULT 0,
  `StartDate` timestamp NULL DEFAULT NULL,
  `EndDate` timestamp NULL DEFAULT NULL,
  `StartedProcessingDate` timestamp NULL DEFAULT NULL,
  `CompletedDate` timestamp NULL DEFAULT NULL,
  `SubmittedDate` timestamp NULL DEFAULT NULL,
  `GeneratedReportId` varchar(255) DEFAULT NULL,
  `request_data` longtext DEFAULT NULL,
  `response_data` longtext DEFAULT NULL,
  `is_data_stored` tinyint(1) NOT NULL DEFAULT 0,
  `is_processed` tinyint(1) NOT NULL DEFAULT 0,
  `RequestId` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `record_count` int(11) NOT NULL DEFAULT 0,
  `processed_count` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`metadata`)),
  PRIMARY KEY (`id`),
  KEY `fba_reports_log_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `fba_reports_log_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `api_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `url` varchar(255) NOT NULL,
  `requestHeaders` longtext NOT NULL,
  `requestBody` longtext NOT NULL,
  `responseStatusCode` int(10) unsigned DEFAULT NULL,
  `responseHeaders` longtext DEFAULT NULL,
  `responseBody` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_logs_integration_instance_id_index` (`integration_instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `api_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `token` varchar(255) NOT NULL,
  `last_used_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_tokens_user_id_index` (`user_id`),
  CONSTRAINT `api_tokens_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `attribute_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attribute_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 1,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `attribute_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attribute_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint(20) unsigned NOT NULL,
  `value` varchar(255) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_values_attribute_id_index` (`attribute_id`),
  CONSTRAINT `attribute_values_attribute_id_foreign` FOREIGN KEY (`attribute_id`) REFERENCES `attributes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attributes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `notes` text DEFAULT NULL,
  `type` enum('string','longtext','date','datetime','numeric','integer','checkbox') NOT NULL DEFAULT 'string',
  `attribute_group_id` bigint(20) unsigned DEFAULT NULL,
  `display` longtext DEFAULT NULL,
  `validation` longtext DEFAULT NULL,
  `available_for_templates` tinyint(1) NOT NULL DEFAULT 0,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attributes_name_unique` (`name`),
  KEY `attributes_attribute_group_id_foreign` (`attribute_group_id`),
  CONSTRAINT `attributes_attribute_group_id_foreign` FOREIGN KEY (`attribute_group_id`) REFERENCES `attribute_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `audits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `audits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `event` varchar(255) NOT NULL,
  `auditable_type` varchar(255) NOT NULL,
  `auditable_id` bigint(20) unsigned NOT NULL,
  `old_values` text DEFAULT NULL,
  `new_values` text DEFAULT NULL,
  `url` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` varchar(1023) DEFAULT NULL,
  `tags` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audits_auditable_type_auditable_id_index` (`auditable_type`,`auditable_id`),
  KEY `audits_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `backorder_layers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backorder_layers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `quantity_backordered` int(11) NOT NULL DEFAULT 0,
  `quantity_released` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backorder_layers_product_id_foreign` (`product_id`),
  CONSTRAINT `backorder_layers_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `backorder_queue_coverages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backorder_queue_coverages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `backorder_queue_id` bigint(20) unsigned NOT NULL,
  `purchase_order_line_id` bigint(20) unsigned NOT NULL,
  `covered_quantity` int(11) NOT NULL DEFAULT 0,
  `released_quantity` int(11) NOT NULL DEFAULT 0,
  `unreleased_quantity` int(11) GENERATED ALWAYS AS (`covered_quantity` - `released_quantity`) STORED,
  `is_tight` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_backorder_queue_id_purchase_order_line_id` (`backorder_queue_id`,`purchase_order_line_id`),
  KEY `backorder_queue_coverages_purchase_order_line_id_foreign` (`purchase_order_line_id`),
  CONSTRAINT `backorder_queue_coverages_backorder_queue_id_foreign` FOREIGN KEY (`backorder_queue_id`) REFERENCES `backorder_queues` (`id`) ON DELETE CASCADE,
  CONSTRAINT `backorder_queue_coverages_purchase_order_line_id_foreign` FOREIGN KEY (`purchase_order_line_id`) REFERENCES `purchase_order_lines` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `backorder_queue_releases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backorder_queue_releases` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `backorder_queue_id` bigint(20) unsigned NOT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `released_quantity` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backorder_queue_releases_backorder_queue_id_foreign` (`backorder_queue_id`),
  CONSTRAINT `backorder_queue_releases_backorder_queue_id_foreign` FOREIGN KEY (`backorder_queue_id`) REFERENCES `backorder_queues` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `backorder_queues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backorder_queues` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_line_id` bigint(20) unsigned NOT NULL,
  `backorder_date` datetime NOT NULL,
  `supplier_id` bigint(20) unsigned DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `backordered_quantity` int(11) NOT NULL DEFAULT 0,
  `released_quantity` int(11) NOT NULL DEFAULT 0,
  `shortage_quantity` int(11) GENERATED ALWAYS AS (`backordered_quantity` - `released_quantity`) STORED,
  `scheduled_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `uid` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_order_line_id` (`sales_order_line_id`),
  KEY `backorder_queues_supplier_id_foreign` (`supplier_id`),
  CONSTRAINT `backorder_queues_sales_order_line_id_foreign` FOREIGN KEY (`sales_order_line_id`) REFERENCES `sales_order_lines` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `backorder_queues_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `categories_to_attribute_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories_to_attribute_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `attribute_group_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_to_attribute_groups_category_id_foreign` (`category_id`),
  KEY `categories_to_attribute_groups_attribute_group_id_foreign` (`attribute_group_id`),
  CONSTRAINT `categories_to_attribute_groups_attribute_group_id_foreign` FOREIGN KEY (`attribute_group_id`) REFERENCES `attribute_groups` (`id`),
  CONSTRAINT `categories_to_attribute_groups_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `categories_to_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories_to_attributes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `attribute_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_to_attributes_category_id_foreign` (`category_id`),
  KEY `categories_to_attributes_attribute_id_foreign` (`attribute_id`),
  CONSTRAINT `categories_to_attributes_attribute_id_foreign` FOREIGN KEY (`attribute_id`) REFERENCES `attributes` (`id`),
  CONSTRAINT `categories_to_attributes_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `company_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_profiles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state_province` varchar(255) DEFAULT NULL,
  `address_lines` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`address_lines`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `constants_continents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `constants_continents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `continent_code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `constants_countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `constants_countries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `phone_code` int(11) DEFAULT NULL,
  `continent_name` varchar(255) NOT NULL,
  `continent_code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `constants_countries_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `constants_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `constants_currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `symbol` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `constants_currencies_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `constants_states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `constants_states` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `constants_zipcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `constants_zipcodes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zip` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `latitude` varchar(255) NOT NULL,
  `longitude` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `full_state` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `csv_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `csv_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `model` varchar(255) NOT NULL,
  `columns` longtext NOT NULL,
  `import_count` int(11) NOT NULL DEFAULT 0,
  `export_count` int(11) NOT NULL DEFAULT 0,
  `last_imported_at` datetime DEFAULT NULL,
  `last_exported_at` datetime DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(3) NOT NULL,
  `conversion` decimal(13,4) NOT NULL DEFAULT 0.0000,
  `is_default` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `currencies_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `custom_field_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_field_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint(20) unsigned NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `custom_field_values_custom_field_id_link_type_link_id_unique` (`custom_field_id`,`link_type`,`link_id`),
  KEY `custom_field_values_custom_field_id_index` (`custom_field_id`),
  CONSTRAINT `custom_field_values_custom_field_id_foreign` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `default_shipping_address_id` bigint(20) unsigned DEFAULT NULL,
  `default_billing_address_id` bigint(20) unsigned DEFAULT NULL,
  `name` text DEFAULT NULL,
  `email` text DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `address1` text DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `phone` text DEFAULT NULL,
  `fax` text DEFAULT NULL,
  `sales_channel_origin_id` int(10) unsigned DEFAULT NULL,
  `product_pricing_tier_id` int(10) unsigned DEFAULT NULL,
  `store_id` int(10) unsigned DEFAULT NULL,
  `shipping_method_domestic_id` int(10) unsigned DEFAULT NULL,
  `shipping_method_international_id` int(10) unsigned DEFAULT NULL,
  `warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customers_default_billing_address_id_index` (`default_billing_address_id`),
  KEY `customers_default_shipping_address_id_index` (`default_shipping_address_id`),
  KEY `customers_sales_channel_origin_id_foreign` (`sales_channel_origin_id`),
  KEY `customers_product_pricing_tier_id_foreign` (`product_pricing_tier_id`),
  KEY `customers_store_id_foreign` (`store_id`),
  KEY `customers_shipping_method_domestic_id_foreign` (`shipping_method_domestic_id`),
  KEY `customers_shipping_method_international_id_foreign` (`shipping_method_international_id`),
  KEY `customers_warehouse_id_foreign` (`warehouse_id`),
  FULLTEXT KEY `full` (`address1`),
  CONSTRAINT `customers_default_address_id_foreign` FOREIGN KEY (`default_shipping_address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `customers_default_billing_address_id_foreign` FOREIGN KEY (`default_billing_address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `customers_product_pricing_tier_id_foreign` FOREIGN KEY (`product_pricing_tier_id`) REFERENCES `product_pricing_tiers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `customers_sales_channel_origin_id_foreign` FOREIGN KEY (`sales_channel_origin_id`) REFERENCES `sales_channels` (`id`) ON DELETE SET NULL,
  CONSTRAINT `customers_shipping_method_domestic_id_foreign` FOREIGN KEY (`shipping_method_domestic_id`) REFERENCES `shipping_methods` (`id`) ON DELETE SET NULL,
  CONSTRAINT `customers_shipping_method_international_id_foreign` FOREIGN KEY (`shipping_method_international_id`) REFERENCES `shipping_methods` (`id`) ON DELETE SET NULL,
  CONSTRAINT `customers_store_id_foreign` FOREIGN KEY (`store_id`) REFERENCES `stores` (`id`) ON DELETE SET NULL,
  CONSTRAINT `customers_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `data_feed_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_feed_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `data_feed_type` enum('product_feed') NOT NULL DEFAULT 'product_feed',
  `data_direction` enum('import','export') NOT NULL DEFAULT 'export',
  `connection_settings` mediumtext DEFAULT NULL,
  `field_settings` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `data_feeds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_feeds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('product_feed') NOT NULL DEFAULT 'product_feed',
  `data_direction` enum('import','export') NOT NULL DEFAULT 'export',
  `connection_type` enum('upload_file','download_url','ftp_download','google_sheets','rest_api','downloadable_file') NOT NULL DEFAULT 'upload_file',
  `connection_settings` mediumtext DEFAULT NULL,
  `field_settings` mediumtext DEFAULT NULL,
  `filters` mediumtext DEFAULT NULL,
  `schedule` mediumtext DEFAULT NULL,
  `processed_at` datetime DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ebay_legacy_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ebay_legacy_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `ItemID` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ItemID'))) STORED,
  `SKU` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SKU'))) STORED,
  `ListingDuration` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ListingDuration'))) STORED,
  `ListingType` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ListingType'))) STORED,
  `Title` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Title'))) STORED,
  `QuantityAvailable` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.QuantityAvailable'))) STORED,
  `CurrentPriceValue` decimal(9,2) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SellingStatus.CurrentPrice.value'))) STORED,
  `CurrentPriceCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.SellingStatus.CurrentPrice.currencyID'))) STORED,
  `WatchCount` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.WatchCount'))) STORED,
  `StartTime` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ListingDetails.StartTime'))) STORED,
  `StartTimeUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.StartTimeUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `EndTime` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ListingDetails.EndTime'))) STORED,
  `EndTimeUtc` datetime GENERATED ALWAYS AS (case when json_unquote(json_extract(`json_object`,'$.EndTimeUtc')) is not null then str_to_date(convert(json_unquote(json_extract(`json_object`,'$.EndTimeUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s') else NULL end) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ebay_legacy_products_integration_instance_id_itemid_unique` (`integration_instance_id`,`ItemID`),
  KEY `ebay_legacy_products_integration_instance_id_index` (`integration_instance_id`),
  KEY `ebay_legacy_products_itemid_index` (`ItemID`),
  CONSTRAINT `ebay_legacy_products_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ebay_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ebay_order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ebay_order_id` bigint(20) unsigned NOT NULL,
  `lineItemId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.lineItemId'))) STORED,
  `legacyItemId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.legacyItemId'))) STORED,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `title` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.title'))) STORED,
  `lineItemCostValue` decimal(9,2) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.lineItemCost.value'))) STORED,
  `lineItemCostCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.lineItemCost.currency'))) STORED,
  `quantity` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity'))) STORED,
  `soldFormat` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.soldFormat'))) STORED,
  `listingMarketplaceId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.listingMarketplaceId'))) STORED,
  `purchaseMarketplaceId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.purchaseMarketplaceId'))) STORED,
  `lineItemFulfillmentStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.lineItemFulfillmentStatus'))) STORED,
  `totalValue` decimal(9,2) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total.value'))) STORED,
  `totalCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total.currency'))) STORED,
  `shippingCostValue` decimal(9,2) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.deliveryCost.shippingCost.value'))) STORED,
  `shippingCostCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.deliveryCost.shippingCost.currency'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ebay_order_items_ebay_order_id_index` (`ebay_order_id`),
  KEY `ebay_order_items_lineitemid_index` (`lineItemId`),
  KEY `ebay_order_items_legacyitemid_index` (`legacyItemId`),
  CONSTRAINT `ebay_order_items_ebay_order_id_foreign` FOREIGN KEY (`ebay_order_id`) REFERENCES `ebay_orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `ebay_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ebay_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `orderId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.orderId'))) STORED,
  `legacyOrderId` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.legacyOrderId'))) STORED,
  `creationDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.creationDate'))) STORED,
  `creationDateUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.creationDateUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `lastModifiedDate` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.lastModifiedDate'))) STORED,
  `lastModifiedDateUtc` datetime GENERATED ALWAYS AS (str_to_date(convert(json_unquote(json_extract(`json_object`,'$.lastModifiedDateUtc')) using utf8mb4),'%Y-%m-%d %H:%i:%s')) STORED,
  `orderPaymentStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.orderPaymentStatus'))) STORED,
  `orderFulfillmentStatus` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.orderFulfillmentStatus'))) STORED,
  `totalValue` decimal(9,2) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.pricingSummary.total.value'))) STORED,
  `totalCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.pricingSummary.total.currency'))) STORED,
  `ebayCollectAndRemitTax` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ebayCollectAndRemitTax'))) STORED,
  `salesRecordReference` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.salesRecordReference'))) STORED,
  `totalMarketplaceFeeValue` decimal(9,2) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.totalMarketplaceFee.value'))) STORED,
  `totalMarketplaceFeeCurrency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.totalMarketplaceFee.currency'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ebay_orders_integration_instance_id_index` (`integration_instance_id`),
  KEY `ebay_orders_orderid_index` (`orderId`),
  CONSTRAINT `ebay_orders_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) DEFAULT NULL,
  `connection` mediumtext NOT NULL,
  `queue` mediumtext NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `fba_inventory_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fba_inventory_movements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `product_listing_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `type` enum('sale','purchase_receipt','transfer','adjustment','initial_count','return') NOT NULL,
  `inventory_status` enum('active','in_transit') NOT NULL,
  `metadata` longtext DEFAULT NULL,
  `document_type` varchar(255) DEFAULT NULL,
  `document_id` varchar(255) DEFAULT NULL,
  `layer_id` bigint(20) unsigned DEFAULT NULL,
  `layer_type` varchar(255) DEFAULT NULL,
  `link_id` bigint(20) unsigned DEFAULT NULL,
  `link_type` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `archived_at` timestamp NULL DEFAULT NULL,
  `inventory_movement_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fba_inventory_movements_product_listing_id_foreign` (`product_listing_id`),
  KEY `fba_inventory_movements_product_id_foreign` (`product_id`),
  KEY `fba_inventory_movements_warehouse_id_foreign` (`warehouse_id`),
  KEY `fba_inventory_movements_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `fba_inventory_movements_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fba_inventory_movements_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fba_inventory_movements_product_listing_id_foreign` FOREIGN KEY (`product_listing_id`) REFERENCES `product_listings` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fba_inventory_movements_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `fba_real_time_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fba_real_time_inventory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `product_listing_id` bigint(20) unsigned NOT NULL,
  `inventory_available` int(11) NOT NULL DEFAULT 0,
  `inventory_reserved` int(11) NOT NULL DEFAULT 0,
  `inventory_incoming` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fba_real_time_inventory_integration_instance_id_foreign` (`integration_instance_id`),
  KEY `fba_real_time_inventory_product_listing_id_foreign` (`product_listing_id`),
  CONSTRAINT `fba_real_time_inventory_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fba_real_time_inventory_product_listing_id_foreign` FOREIGN KEY (`product_listing_id`) REFERENCES `product_listings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `fifo_layers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fifo_layers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fifo_layer_date` date NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `original_quantity` int(11) NOT NULL DEFAULT 0,
  `fulfilled_quantity` int(11) NOT NULL DEFAULT 0,
  `available_quantity` int(11) GENERATED ALWAYS AS (`original_quantity` - `fulfilled_quantity`) STORED,
  `total_cost` decimal(8,2) NOT NULL DEFAULT 0.00,
  `warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `link_id` bigint(20) unsigned DEFAULT NULL,
  `link_type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `uid` char(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fifo_layers_product_id_foreign` (`product_id`),
  KEY `fifo_layers_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `fifo_layers_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `fifo_layers_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `financial_allocatables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `financial_allocatables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `allocatable_type` varchar(255) NOT NULL,
  `allocatable_from_id` bigint(20) unsigned NOT NULL,
  `allocatable_from_type` varchar(255) NOT NULL,
  `allocatable_to_id` bigint(20) unsigned NOT NULL,
  `allocatable_to_type` varchar(255) NOT NULL,
  `amount` decimal(12,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `financial_line_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `financial_line_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `classification` varchar(255) NOT NULL,
  `allocate_to_products` tinyint(1) NOT NULL DEFAULT 0,
  `proration_strategy` varchar(255) NOT NULL,
  `nominal_code_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `financial_line_types_nominal_code_id_index` (`nominal_code_id`),
  CONSTRAINT `financial_line_types_nominal_code_id_foreign` FOREIGN KEY (`nominal_code_id`) REFERENCES `nominal_codes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `financial_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `financial_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_id` bigint(20) unsigned NOT NULL,
  `financial_line_type_id` bigint(20) unsigned NOT NULL,
  `nominal_code_id` bigint(20) unsigned DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `amount` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `extended_amount` decimal(12,4) GENERATED ALWAYS AS (`quantity` * `amount`) STORED,
  `tax_allocation` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `tax_rate` decimal(6,4) NOT NULL DEFAULT 0.0000,
  `allocate_to_products` tinyint(1) NOT NULL,
  `proration_strategy` varchar(255) NOT NULL,
  `allocate_to_id` bigint(20) unsigned DEFAULT NULL,
  `allocate_to_type` varchar(255) DEFAULT NULL,
  `sales_channel_line_id` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `financial_lines_sales_order_id_index` (`sales_order_id`),
  KEY `financial_lines_financial_line_type_id_index` (`financial_line_type_id`),
  KEY `financial_lines_nominal_code_id_index` (`nominal_code_id`),
  KEY `financial_lines_tax_rate_id_index` (`tax_rate_id`),
  CONSTRAINT `financial_lines_financial_line_type_id_foreign` FOREIGN KEY (`financial_line_type_id`) REFERENCES `financial_line_types` (`id`),
  CONSTRAINT `financial_lines_nominal_code_id_foreign` FOREIGN KEY (`nominal_code_id`) REFERENCES `nominal_codes` (`id`),
  CONSTRAINT `financial_lines_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`),
  CONSTRAINT `financial_lines_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `generated_report_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `generated_report_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `generated_report_id` bigint(20) unsigned NOT NULL,
  `group_id` bigint(20) unsigned DEFAULT NULL,
  `group_type` varchar(255) DEFAULT NULL,
  `value` decimal(12,2) NOT NULL DEFAULT 0.00,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `generated_report_items_generated_report_id_foreign` (`generated_report_id`),
  CONSTRAINT `generated_report_items_generated_report_id_foreign` FOREIGN KEY (`generated_report_id`) REFERENCES `generated_reports` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `generated_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `generated_reports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` enum('scheduled','in_progress','cancelled','done','done_no_data') NOT NULL,
  `group_by` varchar(255) DEFAULT NULL,
  `time_period` enum('day','week','month','quarter','year') NOT NULL,
  `metric` enum('sales','profit','units_sold') NOT NULL,
  `total_value` decimal(8,2) DEFAULT 0.00,
  `filters` mediumtext DEFAULT NULL,
  `started_processing_at` datetime DEFAULT NULL,
  `processed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `import_last_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `import_last_mapping` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `model` varchar(255) NOT NULL,
  `mapping` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`mapping`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `import_last_mapping_integration_instance_id_model_unique` (`integration_instance_id`,`model`),
  KEY `import_last_mapping_integration_instance_id_index` (`integration_instance_id`),
  CONSTRAINT `import_last_mapping_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inbound_shipment_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inbound_shipment_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `shipment_id` varchar(255) NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inbound_shipment_relations_link_type_link_id_index` (`link_type`,`link_id`),
  KEY `inbound_shipment_relations_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `inbound_shipment_relations_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `incoterms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `incoterms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `incoterms_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `integration_instance_service_disruptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `integration_instance_service_disruptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `status` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `integration_instance_service_disruptions_ii_id_index` (`integration_instance_id`),
  CONSTRAINT `status_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `integration_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `integration_instances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `connection_settings` mediumtext NOT NULL,
  `integration_settings` longtext NOT NULL,
  `connection_status` varchar(255) DEFAULT NULL,
  `is_automatic_sync_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `integration_instances_integration_id_foreign` (`integration_id`),
  CONSTRAINT `integration_instances_integration_id_foreign` FOREIGN KEY (`integration_id`) REFERENCES `integrations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `integration_shipping_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `integration_shipping_methods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `code` varchar(255) NOT NULL,
  `is_domestic` tinyint(1) NOT NULL DEFAULT 1,
  `shipping_method_id` int(10) unsigned NOT NULL,
  `metadata` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `integration_shipping_methods_integration_instance_id_index` (`integration_instance_id`),
  KEY `integration_shipping_methods_shipping_method_id_index` (`shipping_method_id`),
  CONSTRAINT `integration_shipping_methods_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE,
  CONSTRAINT `integration_shipping_methods_shipping_method_id_foreign` FOREIGN KEY (`shipping_method_id`) REFERENCES `shipping_methods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `integrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `integrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `integration_settings_template` mediumtext DEFAULT NULL,
  `image_url` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `supports_multiple_instances` tinyint(1) NOT NULL DEFAULT 0,
  `integration_type` varchar(255) NOT NULL,
  `integration_sub_type` varchar(255) DEFAULT NULL,
  `last_sync` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `integrations_name_unique` (`name`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inventory_adjustments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_adjustments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `adjustment_date` datetime NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `quantity` double(8,2) NOT NULL,
  `is_variable_cost` tinyint(1) NOT NULL DEFAULT 0,
  `assembled_adjustment_id` bigint(20) unsigned DEFAULT NULL,
  `notes` mediumtext DEFAULT NULL,
  `link_id` bigint(20) unsigned DEFAULT NULL,
  `link_type` varchar(255) DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_adjustments_product_id_foreign` (`product_id`),
  KEY `inventory_adjustments_warehouse_id_foreign` (`warehouse_id`),
  KEY `inventory_adjustments_assembled_adjustment_id_foreign` (`assembled_adjustment_id`),
  CONSTRAINT `inventory_adjustments_assembled_adjustment_id_foreign` FOREIGN KEY (`assembled_adjustment_id`) REFERENCES `inventory_adjustments` (`id`),
  CONSTRAINT `inventory_adjustments_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `inventory_adjustments_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inventory_assemblies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_assemblies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `action_date` datetime NOT NULL,
  `action` enum('assemble','disassemble') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_assemblies_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `inventory_assemblies_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inventory_assembly_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_assembly_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inventory_assembly_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `product_type` enum('kit','component') NOT NULL,
  `unit_cost` decimal(9,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_assembly_lines_inventory_assembly_id_foreign` (`inventory_assembly_id`),
  KEY `inventory_assembly_lines_product_id_foreign` (`product_id`),
  CONSTRAINT `inventory_assembly_lines_inventory_assembly_id_foreign` FOREIGN KEY (`inventory_assembly_id`) REFERENCES `inventory_assemblies` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inventory_assembly_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inventory_forecast_summary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_forecast_summary` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `total` int(11) NOT NULL,
  `processed` int(11) NOT NULL DEFAULT 0,
  `forecast_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inventory_forecasts_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_forecasts_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `out_of_stock_date` date DEFAULT NULL,
  `forecast_date` date NOT NULL,
  `suggested_purchase_quantity` double(8,2) NOT NULL,
  `total_cost` double(8,2) NOT NULL,
  `available_stock` int(11) NOT NULL,
  `inbound_stock` int(11) NOT NULL,
  `in_transit_stock` int(11) NOT NULL,
  `complete_for_supplier` tinyint(1) NOT NULL DEFAULT 0,
  `purchase_order_line_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_forecasts_cache_supplier_id_foreign` (`supplier_id`),
  KEY `inventory_forecasts_cache_product_id_foreign` (`product_id`),
  KEY `inventory_forecasts_cache_purchase_order_line_id_foreign` (`purchase_order_line_id`),
  CONSTRAINT `inventory_forecasts_cache_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inventory_forecasts_cache_purchase_order_line_id_foreign` FOREIGN KEY (`purchase_order_line_id`) REFERENCES `purchase_order_lines` (`id`) ON DELETE SET NULL,
  CONSTRAINT `inventory_forecasts_cache_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inventory_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_movements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inventory_movement_date` datetime NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `quantity` decimal(9,4) NOT NULL,
  `type` enum('purchase_receipt','transfer','reclassification','sale','adjustment','initial_count','stock_take','assembly','return') NOT NULL,
  `inventory_status` enum('active','reserved','in_transit') NOT NULL,
  `warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `warehouse_location_id` int(10) unsigned DEFAULT NULL,
  `link_id` bigint(20) unsigned DEFAULT NULL,
  `link_type` varchar(255) DEFAULT NULL,
  `layer_id` bigint(20) unsigned DEFAULT NULL,
  `layer_type` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `uid` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_movements_warehouse_id_foreign` (`warehouse_id`),
  KEY `inventory_movements_warehouse_location_id_foreign` (`warehouse_location_id`),
  KEY `inventory_movements_fifo_layer_id_foreign` (`layer_id`),
  KEY `inventory_movements_layer_type_layer_id_index` (`layer_type`,`layer_id`),
  KEY `inventory_movements_link_id_link_type_index` (`link_id`,`link_type`),
  KEY `inventory_movements_reference_index` (`reference`),
  KEY `inventory_movements_product_id_type_inventory_status_index` (`product_id`,`type`,`inventory_status`),
  CONSTRAINT `inventory_movements_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `inventory_movements_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `inventory_movements_warehouse_location_id_foreign` FOREIGN KEY (`warehouse_location_id`) REFERENCES `warehouse_locations` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `inventory_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventory_snapshots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `is_cache_valid` tinyint(1) NOT NULL,
  `inventory_reserved` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_stock_value` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_in_transit` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_available` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_in_stock` tinyint(1) GENERATED ALWAYS AS (`inventory_available` > 0) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `products_benchmarks_product_id_benchmark_date_unique` (`product_id`,`date`),
  KEY `products_benchmarks_product_id_index` (`product_id`),
  KEY `inventory_snapshots_is_cache_valid_index` (`is_cache_valid`),
  CONSTRAINT `products_benchmarks_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `job_payload`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_payload` (
  `uuid` char(36) NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`payload`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `magento_customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magento_customer_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` varchar(255) NOT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `code` varchar(255) NOT NULL,
  `tax_class_id` varchar(255) DEFAULT NULL,
  `tax_class_name` varchar(255) DEFAULT NULL,
  `product_pricing_tier_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `customer_group_id_integration_instance_id_unique` (`customer_group_id`,`integration_instance_id`),
  KEY `magento_customer_groups_integration_instance_id_foreign` (`integration_instance_id`),
  KEY `magento_customer_groups_product_pricing_tier_id_foreign` (`product_pricing_tier_id`),
  CONSTRAINT `magento_customer_groups_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE,
  CONSTRAINT `magento_customer_groups_product_pricing_tier_id_foreign` FOREIGN KEY (`product_pricing_tier_id`) REFERENCES `product_pricing_tiers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `magento_inventory_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magento_inventory_sources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `source_code` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.source_code'))) STORED,
  `name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.name'))) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `integration_instance_id_source_code_unique` (`integration_instance_id`,`source_code`),
  CONSTRAINT `magento_inventory_sources_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `magento_order_line_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magento_order_line_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `magento_order_id` bigint(20) unsigned NOT NULL,
  `line_item` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`line_item`)),
  `line_id` bigint(20) unsigned GENERATED ALWAYS AS (json_unquote(json_extract(`line_item`,'$.item_id'))) STORED,
  `product_id` bigint(20) unsigned GENERATED ALWAYS AS (json_unquote(json_extract(`line_item`,'$.product_id'))) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `magento_order_line_items_magento_order_id_line_id_unique` (`magento_order_id`,`line_id`),
  KEY `magento_order_line_items_line_id_index` (`line_id`),
  KEY `magento_order_line_items_product_id_index` (`product_id`),
  CONSTRAINT `magento_order_line_items_magento_order_id_foreign` FOREIGN KEY (`magento_order_id`) REFERENCES `magento_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `magento_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magento_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `increment_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.increment_id'))) STORED,
  `sales_order_id` bigint(20) unsigned DEFAULT NULL,
  `downloaded_by` varchar(255) DEFAULT NULL,
  `updated_by` varchar(255) DEFAULT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `errors` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`errors`)),
  `refunds_map` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`refunds_map`)),
  `returns_map` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`returns_map`)),
  `fulfillments_map` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`fulfillments_map`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `sku_updated_at` datetime DEFAULT NULL,
  `sku_created_at` datetime DEFAULT NULL,
  `state` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.state'))) STORED,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.status'))) STORED,
  `store_id` bigint(20) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.store_id'))) STORED,
  `entity_id` bigint(20) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.entity_id'))) STORED,
  `quote_id` bigint(20) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quote_id'))) STORED,
  `customer_email` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer_email'))) STORED,
  `customer_firstname` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer_firstname'))) STORED,
  `customer_lastname` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer_lastname'))) STORED,
  `grand_total` decimal(9,2) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.grand_total'))) STORED,
  `total_qty_ordered` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total_qty_ordered'))) STORED,
  `line_items_ids` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.items[*].item_id'))) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `magento_orders_integration_instance_id_increment_id_unique` (`integration_instance_id`,`increment_id`),
  KEY `magento_orders_sales_order_id_foreign` (`sales_order_id`),
  CONSTRAINT `magento_orders_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`),
  CONSTRAINT `magento_orders_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `magento_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magento_product_attributes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint(20) unsigned NOT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `code` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.attribute_code'))) STORED,
  `type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.backend_type'))) STORED,
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.options'))) STORED CHECK (json_valid(`options`)),
  `label` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.default_frontend_label'))) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attribute_id_integration_instance_id_unique` (`attribute_id`,`integration_instance_id`),
  KEY `magento_product_attributes_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `magento_product_attributes_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `magento_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magento_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `_id` bigint(20) unsigned DEFAULT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `variant_id` bigint(20) NOT NULL,
  `sku` varchar(255) GENERATED ALWAYS AS (trim(json_unquote(json_extract(`json_object`,'$.sku')))) STORED,
  `name` varchar(255) GENERATED ALWAYS AS (trim(json_unquote(json_extract(`json_object`,'$.name')))) STORED,
  `weight` double GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.weight'))) STORED,
  `price` double GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.price'))) STORED,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.status'))) STORED,
  `product` bigint(20) unsigned DEFAULT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `mapped_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image_count` int(11) GENERATED ALWAYS AS (json_length(`json_object`,'$.media_gallery_entries')) STORED,
  `updated_by` varchar(255) NOT NULL DEFAULT 'Job',
  `type_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.type_id'))) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `magento_products_integration_instance_id_variant_id_unique` (`integration_instance_id`,`variant_id`),
  UNIQUE KEY `magento_products_sku_integration_instance_id_unique` (`sku`,`integration_instance_id`),
  KEY `magento_products_image_count_index` (`image_count`),
  KEY `magento_products_product_foreign` (`product`),
  CONSTRAINT `magento_products_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`),
  CONSTRAINT `magento_products_product_foreign` FOREIGN KEY (`product`) REFERENCES `product_listings` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `magento_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `magento_stores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `magento_id` int(11) NOT NULL,
  `name` text NOT NULL,
  `code` varchar(255) NOT NULL,
  `json_object` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `magento_stores_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `magento_stores_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `nominal_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nominal_codes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_type` varchar(255) NOT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `note` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `mongo_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_link_type_link_id_index` (`link_type`,`link_id`),
  KEY `notes_user_id_foreign` (`user_id`),
  CONSTRAINT `notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `order_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_type` varchar(255) NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL,
  `child_type` varchar(255) NOT NULL,
  `child_id` bigint(20) unsigned NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_links_parent_type_parent_id_index` (`parent_type`,`parent_id`),
  KEY `order_links_child_type_child_id_index` (`child_type`,`child_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `packing_slip_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packing_slip_queue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(255) NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `event` varchar(255) NOT NULL,
  `queued_at` datetime DEFAULT NULL,
  `last_error` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `packing_slip_queue_link_type_link_id_index` (`link_type`,`link_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `payment_method_mappings_sales_channel_to_sku`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_method_mappings_sales_channel_to_sku` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_channel_id` int(10) unsigned NOT NULL,
  `sales_channel_method` varchar(255) NOT NULL,
  `payment_type_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_channel_id_sales_channel_method_unique` (`sales_channel_id`,`sales_channel_method`),
  KEY `payment_type_id_foreign` (`payment_type_id`),
  CONSTRAINT `payment_type_id_foreign` FOREIGN KEY (`payment_type_id`) REFERENCES `payment_types` (`id`),
  CONSTRAINT `sales_channel_id_foreign` FOREIGN KEY (`sales_channel_id`) REFERENCES `sales_channels` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `payment_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_terms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `payment_terms_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `payment_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `accounting_integration_id` bigint(20) unsigned DEFAULT NULL,
  `accounting_integration_type` varchar(255) DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_types_user_id_foreign` (`user_id`),
  KEY `payment_types_accounting_integration_index` (`accounting_integration_id`,`accounting_integration_type`),
  CONSTRAINT `payment_types_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_type` varchar(255) NOT NULL,
  `link_id` bigint(20) unsigned NOT NULL,
  `payment_date` datetime NOT NULL,
  `payment_type_id` bigint(20) unsigned NOT NULL,
  `external_reference` varchar(255) DEFAULT NULL,
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT 0.00,
  `cost` decimal(12,4) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `currency_id` bigint(20) unsigned NOT NULL,
  `currency_rate` decimal(13,4) unsigned NOT NULL,
  `currency_id_tenant_snapshot` bigint(20) unsigned NOT NULL,
  `accounting_integration_id` bigint(20) unsigned DEFAULT NULL,
  `accounting_integration_type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_link_type_link_id_index` (`link_type`,`link_id`),
  KEY `payments_payment_type_id_foreign` (`payment_type_id`),
  KEY `payments_currency_id_foreign` (`currency_id`),
  KEY `payments_currency_id_tenant_snapshot_index` (`currency_id_tenant_snapshot`),
  KEY `payments_accounting_integration_index` (`accounting_integration_id`,`accounting_integration_type`),
  CONSTRAINT `payments_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `payments_currency_id_tenant_snapshot_foreign` FOREIGN KEY (`currency_id_tenant_snapshot`) REFERENCES `currencies` (`id`),
  CONSTRAINT `payments_payment_type_id_foreign` FOREIGN KEY (`payment_type_id`) REFERENCES `payment_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_attributes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `attribute_id` bigint(20) unsigned NOT NULL,
  `attribute_group_id` bigint(20) unsigned DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_attributes_product_id_attribute_id_unique` (`product_id`,`attribute_id`),
  KEY `product_attribute_attribute_id_foreign` (`attribute_id`),
  KEY `product_attribute_product_id_foreign` (`product_id`),
  KEY `product_attributes_attribute_group_id_foreign` (`attribute_group_id`),
  CONSTRAINT `product_attribute_attribute_id_foreign` FOREIGN KEY (`attribute_id`) REFERENCES `attributes` (`id`),
  CONSTRAINT `product_attribute_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `product_attributes_attribute_group_id_foreign` FOREIGN KEY (`attribute_group_id`) REFERENCES `attribute_groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_brands` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_brands_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `is_leaf` tinyint(1) NOT NULL DEFAULT 0,
  `path` varchar(300) NOT NULL,
  `level` int(11) NOT NULL,
  `root_id` bigint(20) unsigned DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_categories_parent_id_index` (`parent_id`),
  KEY `product_categories_root_id_foreign` (`root_id`),
  CONSTRAINT `product_categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `product_categories` (`id`),
  CONSTRAINT `product_categories_root_id_foreign` FOREIGN KEY (`root_id`) REFERENCES `product_categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_components` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint(20) unsigned NOT NULL,
  `component_product_id` bigint(20) unsigned NOT NULL,
  `quantity` decimal(9,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_components_parent_product_id_index` (`parent_product_id`),
  KEY `product_components_component_product_id_index` (`component_product_id`),
  CONSTRAINT `product_components_component_product_id_foreign` FOREIGN KEY (`component_product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `product_components_parent_product_id_foreign` FOREIGN KEY (`parent_product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `url` mediumtext NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `resolvable` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `url_key` varchar(255) GENERATED ALWAYS AS (substr(`url`,if(octet_length(`url`) > 200,octet_length(`url`) - 200,1))) STORED COMMENT 'last 200 characters of the url',
  PRIMARY KEY (`id`),
  KEY `product_images_product_id_index` (`product_id`),
  CONSTRAINT `product_images_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_listing_inventory_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_listing_inventory_locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_listing_id` bigint(20) unsigned NOT NULL,
  `sales_channel_location_id` bigint(20) unsigned NOT NULL,
  `master_of_stock` varchar(255) DEFAULT NULL,
  `quantity` int(10) unsigned DEFAULT NULL,
  `sales_channel_qty` double(8,2) DEFAULT NULL,
  `inventory_rules` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`inventory_rules`)),
  `fulfillment_latency` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_listing_location_unique` (`product_listing_id`,`sales_channel_location_id`),
  CONSTRAINT `product_listing_inventory_locations_product_listing_id_foreign` FOREIGN KEY (`product_listing_id`) REFERENCES `product_listings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_listings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_listings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `sales_channel_id` int(10) unsigned NOT NULL,
  `sales_channel_listing_id` varchar(255) NOT NULL,
  `listing_sku` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `product_pricing_tier_id` int(10) unsigned DEFAULT NULL,
  `master_of_price` varchar(255) DEFAULT NULL,
  `quantity` decimal(8,2) DEFAULT NULL,
  `master_of_stock` varchar(255) DEFAULT NULL,
  `sales_channel_qty` bigint(20) DEFAULT NULL,
  `sales_channel_qty_last_updated` datetime DEFAULT NULL,
  `is_fba` tinyint(1) NOT NULL DEFAULT 0,
  `fulfillment_latency` int(11) DEFAULT NULL,
  `proforma_marketplace_cost_percentage` decimal(7,4) DEFAULT NULL,
  `inventory_rules` mediumtext DEFAULT NULL,
  `amazon_fees_estimates` mediumtext DEFAULT NULL,
  `competitive_price` varchar(255) DEFAULT NULL,
  `last_updated_competitive_price` datetime DEFAULT NULL,
  `document_id` varchar(255) DEFAULT NULL COMMENT 'MongoDB document id',
  `archived_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `mysql_document_id` bigint(20) unsigned DEFAULT NULL,
  `document_type` varchar(255) DEFAULT NULL,
  `mongo_document_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_channel_id_sales_channel_listing_id_listing_sku_unique` (`sales_channel_id`,`sales_channel_listing_id`,`listing_sku`),
  UNIQUE KEY `unique_sales_channel_document` (`sales_channel_listing_id`,`document_id`,`document_type`),
  KEY `product_listings_product_id_foreign` (`product_id`),
  KEY `product_listings_sales_channel_id_index` (`sales_channel_id`),
  KEY `product_listings_document_id_index` (`document_id`),
  KEY `product_listings_sales_channel_id_sales_channel_listing_id_index` (`sales_channel_id`,`sales_channel_listing_id`),
  KEY `product_listings_document_id_document_type_index` (`document_id`,`document_type`),
  CONSTRAINT `product_listings_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `product_listings_sales_channel_id_foreign` FOREIGN KEY (`sales_channel_id`) REFERENCES `sales_channels` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_pricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_pricing` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_pricing_tier_id` int(10) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `price` decimal(9,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_pricing_product_id_product_pricing_tier_id_unique` (`product_id`,`product_pricing_tier_id`),
  KEY `product_pricing_product_pricing_tier_id_foreign` (`product_pricing_tier_id`),
  KEY `product_pricing_product_id_index` (`product_id`),
  CONSTRAINT `product_pricing_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `product_pricing_product_pricing_tier_id_foreign` FOREIGN KEY (`product_pricing_tier_id`) REFERENCES `product_pricing_tiers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_pricing_tiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_pricing_tiers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `currency_code` varchar(255) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_pricing_tiers_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `product_to_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_to_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `product_to_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `product_categories` (`id`),
  CONSTRAINT `product_to_categories_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `brand_id` bigint(20) unsigned DEFAULT NULL,
  `type` enum('standard','bundle','kit','matrix','blemished') NOT NULL,
  `sku` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `barcode` varchar(255) DEFAULT NULL,
  `mpn` varchar(255) DEFAULT NULL,
  `weight` decimal(8,2) NOT NULL DEFAULT 0.00,
  `weight_unit` enum('lb','g','kg','oz') DEFAULT 'lb',
  `length` decimal(8,2) NOT NULL DEFAULT 0.00,
  `width` decimal(8,2) NOT NULL DEFAULT 0.00,
  `height` decimal(8,2) NOT NULL DEFAULT 0.00,
  `dimension_unit` enum('in','cm','mm') NOT NULL DEFAULT 'in',
  `fba_prep_instructions` varchar(255) DEFAULT NULL,
  `case_quantity` decimal(8,4) unsigned DEFAULT NULL,
  `case_length` decimal(8,4) unsigned DEFAULT NULL,
  `case_width` decimal(8,4) unsigned DEFAULT NULL,
  `case_height` decimal(8,4) unsigned DEFAULT NULL,
  `case_dimension_unit` enum('in','cm','mm') DEFAULT 'in',
  `case_weight` decimal(10,4) unsigned DEFAULT NULL,
  `case_weight_unit` enum('lb','g','kg','oz') DEFAULT 'lb',
  `sales_nominal_code_id` bigint(20) unsigned DEFAULT NULL,
  `cogs_nominal_code_id` bigint(20) unsigned DEFAULT NULL,
  `proforma_landed_cost_percentage` decimal(12,4) DEFAULT NULL,
  `proforma_shipping_cost` decimal(12,4) DEFAULT NULL,
  `proforma_marketplace_cost_percentage` decimal(12,4) DEFAULT NULL,
  `average_cost` decimal(9,4) DEFAULT NULL,
  `daily_average_consumption` decimal(9,4) DEFAULT 0.0000,
  `shared_children_attributes` longtext DEFAULT NULL,
  `is_dropshippable` tinyint(1) NOT NULL DEFAULT 1,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_cost` decimal(8,2) DEFAULT 0.00,
  `is_taxable` tinyint(1) DEFAULT NULL,
  `default_tax_rate_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `products_sku_unique` (`sku`),
  KEY `products_parent_id_index` (`parent_id`),
  KEY `products_brand_id_index` (`brand_id`),
  KEY `products_type_index` (`type`),
  KEY `products_sku_index` (`sku`),
  KEY `products_name_index` (`name`),
  KEY `products_sales_nominal_code_id_foreign` (`sales_nominal_code_id`),
  KEY `products_cogs_nominal_code_id_foreign` (`cogs_nominal_code_id`),
  KEY `products_is_taxable_index` (`is_taxable`),
  KEY `products_default_tax_rate_id_index` (`default_tax_rate_id`),
  KEY `products_is_dropshippable_index` (`is_dropshippable`),
  FULLTEXT KEY `products_fulltext_index` (`sku`,`barcode`,`mpn`,`name`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `product_brands` (`id`),
  CONSTRAINT `products_cogs_nominal_code_id_foreign` FOREIGN KEY (`cogs_nominal_code_id`) REFERENCES `nominal_codes` (`id`),
  CONSTRAINT `products_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `products` (`id`),
  CONSTRAINT `products_sales_nominal_code_id_foreign` FOREIGN KEY (`sales_nominal_code_id`) REFERENCES `nominal_codes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `products_blemished`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_blemished` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `derived_from_product_id` bigint(20) unsigned NOT NULL,
  `condition` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_blemished_product_id_foreign` (`product_id`),
  KEY `products_blemished_derived_from_product_id_foreign` (`derived_from_product_id`),
  CONSTRAINT `products_blemished_derived_from_product_id_foreign` FOREIGN KEY (`derived_from_product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `products_blemished_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `products_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products_inventory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `warehouse_id` bigint(20) unsigned NOT NULL COMMENT '0 means the total for all warehouses',
  `inventory_total` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_reserved` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_in_transit` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_available` double(8,2) NOT NULL DEFAULT 0.00,
  `inventory_stock_value` double(10,4) DEFAULT NULL COMMENT 'for the total only',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `products_inventory_product_id_warehouse_id_unique` (`product_id`,`warehouse_id`),
  CONSTRAINT `products_inventory_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_invoice_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_invoice_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_invoice_id` bigint(20) unsigned NOT NULL,
  `purchase_order_line_id` bigint(20) unsigned DEFAULT NULL,
  `quantity_invoiced` decimal(9,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_invoice_lines_purchase_invoice_id_foreign` (`purchase_invoice_id`),
  KEY `purchase_invoice_lines_purchase_order_line_id_foreign` (`purchase_order_line_id`),
  CONSTRAINT `purchase_invoice_lines_purchase_invoice_id_foreign` FOREIGN KEY (`purchase_invoice_id`) REFERENCES `purchase_invoices` (`id`),
  CONSTRAINT `purchase_invoice_lines_purchase_order_line_id_foreign` FOREIGN KEY (`purchase_order_line_id`) REFERENCES `purchase_order_lines` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_id` bigint(20) unsigned NOT NULL,
  `purchase_invoice_date` date NOT NULL,
  `supplier_invoice_number` varchar(255) NOT NULL,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `status` enum('unpaid','paid','partially_paid') NOT NULL DEFAULT 'unpaid',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_invoices_purchase_order_id_foreign` (`purchase_order_id`),
  KEY `purchase_invoices_supplier_id_foreign` (`supplier_id`),
  CONSTRAINT `purchase_invoices_purchase_order_id_foreign` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`),
  CONSTRAINT `purchase_invoices_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_order_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_id` bigint(20) unsigned NOT NULL,
  `line_reference` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `quantity` decimal(9,4) NOT NULL,
  `received_quantity` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `unreceived_quantity` decimal(12,4) GENERATED ALWAYS AS (greatest(`quantity` - `received_quantity`,0)) STORED,
  `amount` decimal(12,4) NOT NULL,
  `is_taxable` tinyint(1) DEFAULT NULL,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `tax_rate` decimal(7,4) DEFAULT NULL,
  `tax_allocation` decimal(9,4) NOT NULL DEFAULT 0.0000,
  `discount_rate` decimal(9,4) NOT NULL DEFAULT 0.0000,
  `discount_amount_extended` decimal(10,2) GENERATED ALWAYS AS (`amount` * `discount_rate` * `quantity`) STORED,
  `discount_amount` decimal(10,2) GENERATED ALWAYS AS (`amount` * `discount_rate`) STORED,
  `total_amount` decimal(10,2) GENERATED ALWAYS AS (`amount` * `quantity` - `discount_amount_extended`) STORED,
  `estimated_delivery_date` date DEFAULT NULL,
  `nominal_code_id` bigint(20) unsigned NOT NULL,
  `linked_backorders` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`linked_backorders`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_order_lines_purchase_order_id_foreign` (`purchase_order_id`),
  KEY `purchase_order_lines_product_id_foreign` (`product_id`),
  KEY `purchase_order_lines_nominal_code_id_foreign` (`nominal_code_id`),
  KEY `purchase_order_lines_is_taxable_index` (`is_taxable`),
  KEY `purchase_order_lines_tax_rate_id_index` (`tax_rate_id`),
  CONSTRAINT `purchase_order_lines_nominal_code_id_foreign` FOREIGN KEY (`nominal_code_id`) REFERENCES `nominal_codes` (`id`),
  CONSTRAINT `purchase_order_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `purchase_order_lines_purchase_order_id_foreign` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`),
  CONSTRAINT `purchase_order_lines_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_order_shipment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_shipment_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_shipment_id` bigint(20) unsigned NOT NULL,
  `purchase_order_line_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `uid` char(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_order_shipment_lines_purchase_order_line_id_foreign` (`purchase_order_line_id`),
  KEY `purchase_order_shipment_lines_purchase_order_shipment_id_foreign` (`purchase_order_shipment_id`),
  CONSTRAINT `purchase_order_shipment_lines_purchase_order_line_id_foreign` FOREIGN KEY (`purchase_order_line_id`) REFERENCES `purchase_order_lines` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_order_shipment_lines_purchase_order_shipment_id_foreign` FOREIGN KEY (`purchase_order_shipment_id`) REFERENCES `purchase_order_shipments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_order_shipment_receipt_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_shipment_receipt_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_shipment_receipt_id` bigint(20) unsigned NOT NULL,
  `purchase_order_shipment_line_id` bigint(20) unsigned NOT NULL,
  `purchase_order_line_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `uid` char(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shipment_receipt_lines_shipment_line_id` (`purchase_order_shipment_line_id`),
  KEY `purchase_order_shipment_receipt_id_foreign` (`purchase_order_shipment_receipt_id`),
  KEY `posrl_pol_idx` (`purchase_order_line_id`),
  CONSTRAINT `posrl_pol_fk` FOREIGN KEY (`purchase_order_line_id`) REFERENCES `purchase_order_lines` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_order_shipment_receipt_id_foreign` FOREIGN KEY (`purchase_order_shipment_receipt_id`) REFERENCES `purchase_order_shipment_receipts` (`id`),
  CONSTRAINT `shipment_receipt_lines_shipment_line_id` FOREIGN KEY (`purchase_order_shipment_line_id`) REFERENCES `purchase_order_shipment_lines` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_order_shipment_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_shipment_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_shipment_id` bigint(20) unsigned NOT NULL,
  `received_at` datetime NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_order_shipment_id_foreign` (`purchase_order_shipment_id`),
  KEY `purchase_order_shipment_receipts_user_id_foreign` (`user_id`),
  CONSTRAINT `purchase_order_shipment_id_foreign` FOREIGN KEY (`purchase_order_shipment_id`) REFERENCES `purchase_order_shipments` (`id`),
  CONSTRAINT `purchase_order_shipment_receipts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_order_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_order_shipments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_id` bigint(20) unsigned NOT NULL,
  `shipment_date` datetime NOT NULL,
  `fulfilled_shipping_method_id` int(10) unsigned DEFAULT NULL,
  `fulfilled_shipping_method` varchar(255) DEFAULT NULL,
  `tracking` varchar(255) DEFAULT NULL,
  `sales_order_fulfillment_id` bigint(20) unsigned DEFAULT NULL,
  `fully_received_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_order_shipments_purchase_order_id_foreign` (`purchase_order_id`),
  KEY `purchase_order_shipments_fulfilled_shipping_method_id_foreign` (`fulfilled_shipping_method_id`),
  KEY `purchase_order_shipments_sales_order_fulfillment_id_foreign` (`sales_order_fulfillment_id`),
  CONSTRAINT `purchase_order_shipments_fulfilled_shipping_method_id_foreign` FOREIGN KEY (`fulfilled_shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `purchase_order_shipments_purchase_order_id_foreign` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`),
  CONSTRAINT `purchase_order_shipments_sales_order_fulfillment_id_foreign` FOREIGN KEY (`sales_order_fulfillment_id`) REFERENCES `sales_order_fulfillments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `purchase_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_order_date` datetime NOT NULL,
  `purchase_order_number` varchar(255) NOT NULL,
  `sequence` int(11) NOT NULL,
  `order_status` enum('draft','open','closed') NOT NULL DEFAULT 'draft',
  `submission_status` enum('unsubmitted','submitted','change_buyer','change_supplier','finalized','canceled','voided','queued') NOT NULL DEFAULT 'unsubmitted',
  `receipt_status` enum('unreceived','received','partially_received','dropship') NOT NULL,
  `shipment_status` enum('unshipped','shipped_to_warehouse','shipped_to_customer') NOT NULL DEFAULT 'unshipped',
  `invoice_status` enum('uninvoiced','partially_invoiced','invoiced','invoice_paid') NOT NULL,
  `submission_format` enum('email_pdf_attachment','manual','email_csv_attachment','email_pdf_csv_attachments') DEFAULT NULL,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `tax_rate` decimal(7,4) DEFAULT NULL,
  `tax_total` decimal(9,4) NOT NULL DEFAULT 0.0000,
  `total_cost` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_quantity` decimal(8,2) NOT NULL DEFAULT 0.00,
  `payment_term_id` int(10) unsigned DEFAULT NULL,
  `incoterm_id` int(10) unsigned DEFAULT NULL,
  `store_id` int(10) unsigned DEFAULT NULL,
  `requested_shipping_method_id` int(10) unsigned DEFAULT NULL,
  `requested_shipping_method` varchar(255) DEFAULT NULL,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `supplier_warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `destination_warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `sales_order_id` bigint(20) unsigned DEFAULT NULL,
  `destination_address_id` bigint(20) unsigned DEFAULT NULL,
  `currency_id` bigint(20) unsigned NOT NULL,
  `currency_rate` decimal(13,4) unsigned NOT NULL,
  `currency_id_tenant_snapshot` bigint(20) unsigned NOT NULL,
  `estimated_delivery_date` date DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `last_submitted_at` datetime DEFAULT NULL,
  `last_supplier_confirmed_at` datetime DEFAULT NULL,
  `fully_invoiced_at` datetime DEFAULT NULL,
  `fully_received_at` datetime DEFAULT NULL,
  `fully_shipped_at` datetime DEFAULT NULL,
  `finalized_at` datetime DEFAULT NULL,
  `supplier_notes` mediumtext DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_number` mediumtext DEFAULT NULL,
  `other_date` date DEFAULT NULL,
  `is_tax_included` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `purchase_orders_purchase_order_number_unique` (`purchase_order_number`),
  KEY `purchase_orders_payment_term_id_foreign` (`payment_term_id`),
  KEY `purchase_orders_incoterm_id_foreign` (`incoterm_id`),
  KEY `purchase_orders_vendor_id_foreign` (`supplier_id`),
  KEY `purchase_orders_destination_warehouse_id_foreign` (`destination_warehouse_id`),
  KEY `purchase_orders_store_id_index` (`store_id`),
  KEY `purchase_orders_destination_address_id_foreign` (`destination_address_id`),
  KEY `purchase_orders_sales_order_id_index` (`sales_order_id`),
  KEY `purchase_orders_requested_shipping_method_id_foreign` (`requested_shipping_method_id`),
  KEY `purchase_orders_supplier_warehouse_id_foreign` (`supplier_warehouse_id`),
  KEY `purchase_orders_currency_id_foreign` (`currency_id`),
  KEY `purchase_orders_is_tax_included_index` (`is_tax_included`),
  KEY `purchase_orders_tax_rate_id_index` (`tax_rate_id`),
  KEY `purchase_orders_currency_id_tenant_snapshot_index` (`currency_id_tenant_snapshot`),
  KEY `purchase_orders_order_status_index` (`order_status`),
  CONSTRAINT `purchase_orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `purchase_orders_currency_id_tenant_snapshot_foreign` FOREIGN KEY (`currency_id_tenant_snapshot`) REFERENCES `currencies` (`id`),
  CONSTRAINT `purchase_orders_destination_address_id_foreign` FOREIGN KEY (`destination_address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `purchase_orders_destination_warehouse_id_foreign` FOREIGN KEY (`destination_warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `purchase_orders_incoterm_id_foreign` FOREIGN KEY (`incoterm_id`) REFERENCES `incoterms` (`id`),
  CONSTRAINT `purchase_orders_payment_term_id_foreign` FOREIGN KEY (`payment_term_id`) REFERENCES `payment_terms` (`id`),
  CONSTRAINT `purchase_orders_requested_shipping_method_id_foreign` FOREIGN KEY (`requested_shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `purchase_orders_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`),
  CONSTRAINT `purchase_orders_store_id_foreign` FOREIGN KEY (`store_id`) REFERENCES `stores` (`id`) ON DELETE SET NULL,
  CONSTRAINT `purchase_orders_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`),
  CONSTRAINT `purchase_orders_supplier_warehouse_id_foreign` FOREIGN KEY (`supplier_warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `purchase_orders_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `queue_monitor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_monitor` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `job_uuid` char(36) DEFAULT NULL,
  `job_id` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `queue` varchar(255) DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT 0,
  `queued_at` datetime DEFAULT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `started_at_exact` varchar(255) DEFAULT NULL,
  `finished_at` timestamp NULL DEFAULT NULL,
  `finished_at_exact` varchar(255) DEFAULT NULL,
  `attempt` int(11) NOT NULL DEFAULT 0,
  `retried` tinyint(1) NOT NULL DEFAULT 0,
  `progress` int(11) DEFAULT NULL,
  `exception` longtext DEFAULT NULL,
  `exception_message` text DEFAULT NULL,
  `exception_class` text DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `queue_monitor_job_id_index` (`job_id`),
  KEY `queue_monitor_started_at_index` (`started_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `report_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `report_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `reporting_daily_financials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reporting_daily_financials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `reportable_id` bigint(20) unsigned NOT NULL,
  `reportable_type` varchar(255) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `num_orders` int(10) unsigned NOT NULL,
  `revenue` decimal(12,4) NOT NULL,
  `revenue_allocated` decimal(12,4) NOT NULL,
  `revenue_credits` decimal(12,4) NOT NULL,
  `total_revenue` decimal(12,4) GENERATED ALWAYS AS (`revenue` + `revenue_allocated` - `revenue_credits`) STORED,
  `cost` decimal(12,4) NOT NULL,
  `cost_allocated` decimal(12,4) NOT NULL,
  `cost_invoices` decimal(12,4) NOT NULL,
  `cost_returned` decimal(12,4) NOT NULL,
  `total_cost` decimal(12,4) GENERATED ALWAYS AS (`cost` + `cost_allocated` - `cost_returned`) STORED,
  `profit` decimal(12,4) GENERATED ALWAYS AS (`total_revenue` - `total_cost`) STORED,
  `profit_margin` decimal(9,4) GENERATED ALWAYS AS (if(`total_revenue` = 0,0,`profit` / `total_revenue`)) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_date_reportable_id_reportable_type` (`date`,`reportable_id`,`reportable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `return_reasons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `return_reasons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_channels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_channels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned DEFAULT NULL,
  `store_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_channels_sales_channel_brand_id_index` (`store_id`),
  KEY `sales_channels_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `sales_channels_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`),
  CONSTRAINT `sales_channels_sales_channel_brand_id_foreign` FOREIGN KEY (`store_id`) REFERENCES `stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_credit_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_credit_allocations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_credit_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sales_order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_credit_allocations_sales_credit_id_foreign` (`sales_credit_id`),
  KEY `sales_credit_allocations_sales_order_id_index` (`sales_order_id`),
  CONSTRAINT `sales_credit_allocations_sales_credit_id_foreign` FOREIGN KEY (`sales_credit_id`) REFERENCES `sales_credits` (`id`),
  CONSTRAINT `sales_credit_allocations_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_credit_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_credit_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_credit_id` bigint(20) unsigned NOT NULL,
  `sales_order_line_id` bigint(20) unsigned DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `amount` decimal(9,4) NOT NULL,
  `unit_cost` decimal(9,4) DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `nominal_code_id` bigint(20) unsigned NOT NULL,
  `is_taxable` tinyint(1) DEFAULT NULL,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `tax_rate` decimal(7,4) DEFAULT NULL,
  `tax_allocation` decimal(9,4) DEFAULT NULL,
  `is_product` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `proration` decimal(8,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_credit_lines_sales_credit_id_foreign` (`sales_credit_id`),
  KEY `sales_credit_lines_sales_order_line_id_foreign` (`sales_order_line_id`),
  KEY `sales_credit_lines_product_id_foreign` (`product_id`),
  KEY `sales_credit_lines_nominal_code_id_foreign` (`nominal_code_id`),
  KEY `sales_credit_lines_is_taxable_index` (`is_taxable`),
  KEY `sales_credit_lines_tax_rate_id_index` (`tax_rate_id`),
  CONSTRAINT `sales_credit_lines_nominal_code_id_foreign` FOREIGN KEY (`nominal_code_id`) REFERENCES `nominal_codes` (`id`),
  CONSTRAINT `sales_credit_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `sales_credit_lines_sales_credit_id_foreign` FOREIGN KEY (`sales_credit_id`) REFERENCES `sales_credits` (`id`),
  CONSTRAINT `sales_credit_lines_sales_order_line_id_foreign` FOREIGN KEY (`sales_order_line_id`) REFERENCES `sales_order_lines` (`id`),
  CONSTRAINT `sales_credit_lines_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_credit_return_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_credit_return_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_credit_return_id` bigint(20) unsigned NOT NULL,
  `sales_credit_line_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `action` enum('added_to_stock','discarded','new_blemished_sku','no_restock') NOT NULL,
  `reason_id` bigint(20) unsigned NOT NULL,
  `notes` mediumtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_credit_return_lines_sales_credit_return_id_foreign` (`sales_credit_return_id`),
  KEY `sales_credit_return_lines_sales_credit_line_id_foreign` (`sales_credit_line_id`),
  KEY `sales_credit_return_lines_reason_id_foreign` (`reason_id`),
  CONSTRAINT `sales_credit_return_lines_reason_id_foreign` FOREIGN KEY (`reason_id`) REFERENCES `return_reasons` (`id`),
  CONSTRAINT `sales_credit_return_lines_sales_credit_line_id_foreign` FOREIGN KEY (`sales_credit_line_id`) REFERENCES `sales_credit_lines` (`id`),
  CONSTRAINT `sales_credit_return_lines_sales_credit_return_id_foreign` FOREIGN KEY (`sales_credit_return_id`) REFERENCES `sales_credit_returns` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_credit_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_credit_returns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('open','closed') NOT NULL,
  `sales_credit_id` bigint(20) unsigned NOT NULL,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `shipping_method_id` int(10) unsigned DEFAULT NULL,
  `tracking_number` varchar(255) DEFAULT NULL,
  `shipped_at` datetime DEFAULT NULL,
  `received_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_credit_returns_sales_credit_id_foreign` (`sales_credit_id`),
  KEY `sales_credit_returns_warehouse_id_foreign` (`warehouse_id`),
  KEY `sales_credit_returns_shipping_method_id_foreign` (`shipping_method_id`),
  CONSTRAINT `sales_credit_returns_sales_credit_id_foreign` FOREIGN KEY (`sales_credit_id`) REFERENCES `sales_credits` (`id`),
  CONSTRAINT `sales_credit_returns_shipping_method_id_foreign` FOREIGN KEY (`shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `sales_credit_returns_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_credits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_credits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_credit_number` varchar(255) NOT NULL,
  `credit_status` enum('draft','open','closed') NOT NULL,
  `return_status` enum('not_returned','partially_returned','returned') NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `sales_order_id` bigint(20) unsigned DEFAULT NULL,
  `from_address_id` bigint(20) unsigned DEFAULT NULL,
  `to_warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `total_credit` decimal(8,2) NOT NULL DEFAULT 0.00,
  `currency_id` bigint(20) unsigned NOT NULL,
  `currency_rate` decimal(13,4) unsigned NOT NULL,
  `currency_id_tenant_snapshot` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `tax_rate` decimal(7,4) DEFAULT NULL,
  `payment_status` enum('unpaid','partially_paid','paid') NOT NULL,
  `credit_date` datetime NOT NULL,
  `notes` mediumtext DEFAULT NULL,
  `is_for_overpayment` tinyint(1) NOT NULL DEFAULT 0,
  `store_id` int(10) unsigned DEFAULT NULL,
  `fully_returned_at` datetime DEFAULT NULL,
  `fully_paid_at` datetime DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tax_lines` mediumtext DEFAULT NULL,
  `tax_total` decimal(9,4) NOT NULL DEFAULT 0.0000,
  `is_tax_included` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_credits_customer_id_foreign` (`customer_id`),
  KEY `sales_credits_from_address_id_foreign` (`from_address_id`),
  KEY `sales_credits_to_warehouse_id_foreign` (`to_warehouse_id`),
  KEY `sales_credits_store_id_foreign` (`store_id`),
  KEY `sales_credits_currency_id_foreign` (`currency_id`),
  KEY `sales_credits_is_tax_included_index` (`is_tax_included`),
  KEY `sales_credits_tax_rate_id_index` (`tax_rate_id`),
  KEY `sales_credits_currency_id_tenant_snapshot_index` (`currency_id_tenant_snapshot`),
  KEY `sales_credits_sales_order_id_index` (`sales_order_id`),
  CONSTRAINT `sales_credits_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `sales_credits_currency_id_tenant_snapshot_foreign` FOREIGN KEY (`currency_id_tenant_snapshot`) REFERENCES `currencies` (`id`),
  CONSTRAINT `sales_credits_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`),
  CONSTRAINT `sales_credits_from_address_id_foreign` FOREIGN KEY (`from_address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `sales_credits_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`),
  CONSTRAINT `sales_credits_store_id_foreign` FOREIGN KEY (`store_id`) REFERENCES `stores` (`id`),
  CONSTRAINT `sales_credits_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `sales_credits_to_warehouse_id_foreign` FOREIGN KEY (`to_warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_order_fulfillment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_order_fulfillment_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_fulfillment_id` bigint(20) unsigned NOT NULL,
  `sales_order_line_id` bigint(20) unsigned NOT NULL,
  `quantity` decimal(9,4) NOT NULL,
  `metadata` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_order_fulfillment_lines_sales_order_fulfillment_id_foreign` (`sales_order_fulfillment_id`),
  KEY `sales_order_fulfillment_lines_sales_order_line_id_foreign` (`sales_order_line_id`),
  CONSTRAINT `sales_order_fulfillment_lines_sales_order_fulfillment_id_foreign` FOREIGN KEY (`sales_order_fulfillment_id`) REFERENCES `sales_order_fulfillments` (`id`),
  CONSTRAINT `sales_order_fulfillment_lines_sales_order_line_id_foreign` FOREIGN KEY (`sales_order_line_id`) REFERENCES `sales_order_lines` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_order_fulfillments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_order_fulfillments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_id` bigint(20) unsigned NOT NULL,
  `fulfillment_sequence` int(11) NOT NULL,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `requested_shipping_method_id` int(10) unsigned DEFAULT NULL,
  `requested_shipping_method` varchar(255) DEFAULT NULL,
  `fulfilled_shipping_method_id` int(10) unsigned DEFAULT NULL,
  `fulfilled_shipping_method` varchar(255) DEFAULT NULL,
  `cost` decimal(9,4) DEFAULT NULL,
  `status` enum('submitted','acknowledged','picked','packed','fulfilled','fulfilled_awaiting_info','canceled') NOT NULL,
  `fulfillment_type` enum('manual','shipstation','starshipit','fba','shipmyorders') DEFAULT NULL,
  `tracking_number` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `fulfilled_at` datetime DEFAULT NULL,
  `packing_slip_printed_at` datetime DEFAULT NULL,
  `metadata` longtext DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `submitted_to_sales_channel_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_order_id_fulfillment_sequence_unique` (`sales_order_id`,`fulfillment_sequence`),
  KEY `sales_order_fulfillments_sales_order_id_index` (`sales_order_id`),
  KEY `sales_order_fulfillments_warehouse_id_foreign` (`warehouse_id`),
  KEY `sales_order_fulfillments_requested_shipping_method_id_foreign` (`requested_shipping_method_id`),
  KEY `sales_order_fulfillments_fulfilled_shipping_method_id_foreign` (`fulfilled_shipping_method_id`),
  KEY `sales_order_fulfillments_user_id_foreign` (`user_id`),
  CONSTRAINT `sales_order_fulfillments_fulfilled_shipping_method_id_foreign` FOREIGN KEY (`fulfilled_shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `sales_order_fulfillments_requested_shipping_method_id_foreign` FOREIGN KEY (`requested_shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `sales_order_fulfillments_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`),
  CONSTRAINT `sales_order_fulfillments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `sales_order_fulfillments_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_order_line_financials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_order_line_financials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_line_id` bigint(20) unsigned NOT NULL,
  `revenue` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `revenue_allocated` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `credits` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `total_revenue` decimal(12,4) GENERATED ALWAYS AS (`revenue` + `revenue_allocated` - `credits`) STORED,
  `cogs` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `cost_allocated` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `cogs_returned` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `total_cost` decimal(12,4) GENERATED ALWAYS AS (`cogs` + `cost_allocated` - `cogs_returned`) STORED,
  `profit` decimal(12,4) GENERATED ALWAYS AS (`total_revenue` - `total_cost`) STORED,
  `profit_margin` decimal(9,4) GENERATED ALWAYS AS (if(`total_revenue` = 0,0,`profit` / `total_revenue`)) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_order_line_financials_sales_order_line_id_unique` (`sales_order_line_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_order_line_layers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_order_line_layers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_line_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `layer_id` bigint(20) unsigned NOT NULL,
  `layer_type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_order_line_fifo_layers_sales_order_line_id_foreign` (`sales_order_line_id`),
  KEY `sales_order_line_fifo_layers_fifo_layer_id_foreign` (`layer_id`),
  CONSTRAINT `sales_order_line_fifo_layers_sales_order_line_id_foreign` FOREIGN KEY (`sales_order_line_id`) REFERENCES `sales_order_lines` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_order_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_order_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_id` bigint(20) unsigned NOT NULL,
  `sales_channel_line_id` varchar(255) DEFAULT NULL,
  `product_listing_id` bigint(20) unsigned DEFAULT NULL,
  `split_from_line_id` bigint(20) unsigned DEFAULT NULL,
  `warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `warehouse_routing_method` varchar(255) DEFAULT NULL,
  `description` varchar(300) NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `amount` decimal(12,4) NOT NULL,
  `quantity` decimal(9,4) unsigned NOT NULL,
  `fulfilled_quantity` decimal(8,2) NOT NULL DEFAULT 0.00,
  `externally_fulfilled_quantity` decimal(9,4) unsigned NOT NULL DEFAULT 0.0000,
  `canceled_quantity` decimal(9,4) NOT NULL DEFAULT 0.0000,
  `no_audit_trail` tinyint(1) NOT NULL DEFAULT 0,
  `is_product` tinyint(1) NOT NULL DEFAULT 1,
  `has_backorder` tinyint(1) NOT NULL,
  `nominal_code_id` bigint(20) unsigned NOT NULL,
  `discount_allocation` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `tax_allocation` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `tax_rate` decimal(6,4) NOT NULL DEFAULT 0.0000,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `is_taxable` tinyint(1) NOT NULL DEFAULT 0,
  `bundle_id` bigint(20) unsigned DEFAULT NULL,
  `revenue_allocated` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `revenue_allocated_breakdown` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`revenue_allocated_breakdown`)),
  `subtotal_cache` decimal(12,4) NOT NULL DEFAULT 0.0000 COMMENT 'For canceled orders',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_order_lines_sales_order_id_index` (`sales_order_id`),
  KEY `sales_order_lines_product_id_index` (`product_id`),
  KEY `sales_order_lines_nominal_code_id_index` (`nominal_code_id`),
  KEY `sales_order_lines_product_listing_id_foreign` (`product_listing_id`),
  KEY `sales_order_lines_tax_rate_id_foreign` (`tax_rate_id`),
  KEY `sales_order_lines_is_taxable_index` (`is_taxable`),
  KEY `sales_order_lines_split_from_line_id_foreign` (`split_from_line_id`),
  KEY `sales_order_lines_warehouse_id_foreign` (`warehouse_id`),
  KEY `sales_order_lines_bundle_id_foreign` (`bundle_id`),
  KEY `sales_channel_line_id` (`sales_channel_line_id`),
  KEY `is_product` (`is_product`),
  CONSTRAINT `sales_order_lines_bundle_id_foreign` FOREIGN KEY (`bundle_id`) REFERENCES `products` (`id`),
  CONSTRAINT `sales_order_lines_nominal_code_id_foreign` FOREIGN KEY (`nominal_code_id`) REFERENCES `nominal_codes` (`id`),
  CONSTRAINT `sales_order_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `sales_order_lines_product_listing_id_foreign` FOREIGN KEY (`product_listing_id`) REFERENCES `product_listings` (`id`) ON DELETE SET NULL,
  CONSTRAINT `sales_order_lines_sales_order_id_foreign` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sales_order_lines_split_from_line_id_foreign` FOREIGN KEY (`split_from_line_id`) REFERENCES `sales_order_lines` (`id`),
  CONSTRAINT `sales_order_lines_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `sales_order_lines_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `sales_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sales_order_number` varchar(255) NOT NULL,
  `sales_channel_id` int(10) unsigned NOT NULL,
  `order_status` enum('draft','reserved','open','closed') NOT NULL DEFAULT 'draft',
  `fulfillment_status` enum('unfulfilled','partially_fulfilled','fulfilled','awaiting_tracking','over_fulfilled','out_of_sync') DEFAULT NULL,
  `fulfillment_channel` varchar(255) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `shipping_address_id` bigint(20) unsigned DEFAULT NULL,
  `billing_address_id` bigint(20) unsigned DEFAULT NULL,
  `total_revenue` decimal(12,4) DEFAULT NULL,
  `currency_id` bigint(20) unsigned NOT NULL,
  `currency_rate` decimal(13,4) unsigned NOT NULL,
  `currency_id_tenant_snapshot` bigint(20) unsigned NOT NULL,
  `shipping_method_id` int(10) unsigned DEFAULT NULL,
  `requested_shipping_method` varchar(255) DEFAULT NULL,
  `payment_status` enum('unpaid','partially_paid','paid','refunded','partially_refunded') DEFAULT NULL,
  `order_date` datetime NOT NULL,
  `ship_by_date` datetime DEFAULT NULL,
  `deliver_by_date` datetime DEFAULT NULL,
  `store_id` int(10) unsigned NOT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reserved_at` datetime DEFAULT NULL,
  `fulfilled_at` datetime DEFAULT NULL,
  `fully_paid_at` datetime DEFAULT NULL,
  `discount` double(8,2) DEFAULT NULL,
  `discount_total` decimal(8,2) NOT NULL DEFAULT 0.00,
  `canceled_at` timestamp NULL DEFAULT NULL,
  `is_fba` tinyint(1) DEFAULT 0,
  `sales_channel_order_type` varchar(255) DEFAULT NULL,
  `sales_channel_order_id` bigint(20) unsigned DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `discount_lines` mediumtext DEFAULT NULL,
  `tax_lines` mediumtext DEFAULT NULL,
  `tax_total` double(8,2) DEFAULT NULL,
  `is_tax_included` tinyint(1) DEFAULT NULL,
  `packing_slip_printed_at` datetime DEFAULT NULL,
  `tax_rate_id` bigint(20) unsigned DEFAULT NULL,
  `tax_rate` decimal(7,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_sales_order_number_sales_channel_id` (`sales_order_number`,`sales_channel_id`),
  KEY `sales_orders_sales_channel_id_index` (`sales_channel_id`),
  KEY `sales_orders_customer_id_index` (`customer_id`),
  KEY `sales_orders_shipping_address_id_index` (`shipping_address_id`),
  KEY `sales_orders_billing_address_id_index` (`billing_address_id`),
  KEY `sales_orders_tax_rate_id_foreign` (`tax_rate_id`),
  KEY `sales_orders_currency_id_foreign` (`currency_id`),
  KEY `sales_orders_shipping_method_id_foreign` (`shipping_method_id`),
  KEY `sales_orders_store_id_foreign` (`store_id`),
  KEY `sales_orders_currency_id_tenant_snapshot_index` (`currency_id_tenant_snapshot`),
  KEY `sales_orders_sales_channel_order_id_type_index` (`sales_channel_order_id`,`sales_channel_order_type`),
  CONSTRAINT `sales_orders_billing_address_id_foreign` FOREIGN KEY (`billing_address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `sales_orders_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `sales_orders_currency_id_tenant_snapshot_foreign` FOREIGN KEY (`currency_id_tenant_snapshot`) REFERENCES `currencies` (`id`),
  CONSTRAINT `sales_orders_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`),
  CONSTRAINT `sales_orders_sales_channel_id_foreign` FOREIGN KEY (`sales_channel_id`) REFERENCES `sales_channels` (`id`),
  CONSTRAINT `sales_orders_shipping_address_id_foreign` FOREIGN KEY (`shipping_address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `sales_orders_shipping_method_id_foreign` FOREIGN KEY (`shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `sales_orders_store_id_foreign` FOREIGN KEY (`store_id`) REFERENCES `stores` (`id`),
  CONSTRAINT `sales_orders_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `key` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'string',
  `value` longtext DEFAULT NULL,
  `default_value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_key_in_settings_table` (`key`),
  KEY `settings_user_id_foreign` (`user_id`),
  CONSTRAINT `settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shipping_carriers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipping_carriers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `tracking_link` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shipping_carriers_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shipping_method_mappings_sales_channel_to_sku`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipping_method_mappings_sales_channel_to_sku` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sales_channel_id` int(10) unsigned NOT NULL,
  `sales_channel_method` varchar(255) NOT NULL,
  `shipping_method_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_channel_id_sales_channel_method_unique` (`sales_channel_id`,`sales_channel_method`),
  KEY `sales_channel_to_sku_shipping_method_id_foreign` (`shipping_method_id`),
  CONSTRAINT `sales_channel_to_sku_sales_channel_id_foreign` FOREIGN KEY (`sales_channel_id`) REFERENCES `sales_channels` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sales_channel_to_sku_shipping_method_id_foreign` FOREIGN KEY (`shipping_method_id`) REFERENCES `shipping_methods` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shipping_method_mappings_sku_to_shipping_provider_method`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipping_method_mappings_sku_to_shipping_provider_method` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shipping_method_id` int(10) unsigned DEFAULT NULL,
  `shipping_provider_id` bigint(20) unsigned NOT NULL,
  `shipping_provider_carrier` varchar(255) DEFAULT NULL,
  `shipping_provider_method` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shipping_provider_id_shipping_provider_carrier_method_unique` (`shipping_provider_id`,`shipping_provider_carrier`,`shipping_provider_method`),
  KEY `sku_to_shipping_provider_method_shipping_method_id_foreign` (`shipping_method_id`),
  CONSTRAINT `sku_to_shipping_provider_method_shipping_method_id_foreign` FOREIGN KEY (`shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `sku_to_shipping_provider_method_shipping_provider_id_foreign` FOREIGN KEY (`shipping_provider_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shipping_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipping_methods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shipping_carrier_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `delivery_min` int(11) DEFAULT NULL,
  `delivery_max` int(11) DEFAULT NULL,
  `included_locations` mediumtext DEFAULT NULL,
  `excluded_locations` mediumtext DEFAULT NULL,
  `type` varchar(255) DEFAULT 'domestic',
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shipping_methods_shipping_carrier_id_foreign` (`shipping_carrier_id`),
  CONSTRAINT `shipping_methods_shipping_carrier_id_foreign` FOREIGN KEY (`shipping_carrier_id`) REFERENCES `shipping_carriers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shipping_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipping_providers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `warehouse_ids` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shipping_providers_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shipstation_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipstation_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_data`)),
  `sku_fulfillment_id` bigint(20) unsigned NOT NULL,
  `orderId` bigint(20) unsigned GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.orderId'))) STORED,
  `orderNumber` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.orderNumber'))) STORED,
  `orderKey` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.orderKey'))) STORED,
  `shipment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`shipment`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shipstation_orders_sku_fulfillment_id_unique` (`sku_fulfillment_id`),
  CONSTRAINT `shipstation_orders_sku_fulfillment_id_foreign` FOREIGN KEY (`sku_fulfillment_id`) REFERENCES `sales_order_fulfillments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shipstation_webhooks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipstation_webhooks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_data`)),
  `event` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.event'))) STORED,
  `target_url` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.target_url'))) STORED,
  `shipstation_webhook_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.id'))) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shipstation_webhooks_integration_instance_id_event_unique` (`integration_instance_id`,`event`),
  CONSTRAINT `shipstation_webhooks_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_bulk_operations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_bulk_operations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `admin_graphql_api_id` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `operation_type` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `object_count` int(11) NOT NULL,
  `file_size` int(11) NOT NULL,
  `url` mediumtext DEFAULT NULL,
  `partial_data_url` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `reformatted_filename` varchar(255) DEFAULT NULL,
  `completed_at` datetime DEFAULT NULL,
  `error_code` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shopify_bulk_operations_admin_graphql_api_id_unique` (`admin_graphql_api_id`),
  KEY `shopify_bulk_operations_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `shopify_bulk_operations_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `subject_id` bigint(20) unsigned NOT NULL,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `subject_type` varchar(255) NOT NULL,
  `verb` varchar(255) NOT NULL,
  `body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`body`)),
  `message` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sku_processed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shopify_event_unique` (`subject_id`,`subject_type`,`integration_instance_id`),
  KEY `shopify_events_integration_instance_id_foreign` (`integration_instance_id`),
  CONSTRAINT `shopify_events_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_data`)),
  `shopify_location_id` bigint(20) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.id'))) STORED,
  `name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.name'))) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `integration_instance_shopify_location_unique` (`integration_instance_id`,`shopify_location_id`),
  CONSTRAINT `shopify_locations_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_order_line_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_order_line_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shopify_order_id` bigint(20) unsigned NOT NULL,
  `line_item` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`line_item`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `line_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`line_item`,'$.id'))) STORED,
  `variant_id` bigint(20) GENERATED ALWAYS AS (case when cast(json_type(json_extract(`line_item`,'$.variant_id')) as char charset utf8mb4) = 'null' then NULL else json_unquote(json_extract(`line_item`,'$.variant_id')) end) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shopify_order_line_items_shopify_order_id_line_id_unique` (`shopify_order_id`,`line_id`),
  CONSTRAINT `shopify_order_line_items_shopify_order_id_foreign` FOREIGN KEY (`shopify_order_id`) REFERENCES `shopify_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_order_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_order_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shopify_order_id` bigint(20) unsigned NOT NULL,
  `line_id` varchar(255) NOT NULL,
  `line_type` varchar(255) DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `processed_at` datetime NOT NULL,
  `no_restock_fulfillments_applied` int(11) DEFAULT NULL,
  `link_id` varchar(255) NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `sku_link_id` varchar(255) DEFAULT NULL,
  `sku_link_type` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shopify_order_mappings_shopify_order_id_foreign` (`shopify_order_id`),
  KEY `shopify_order_mappings_link_type_link_id_line_id_index` (`link_type`,`link_id`,`line_id`),
  KEY `shopify_order_mappings_link_type_sku_link_id_index` (`link_type`,`sku_link_id`),
  KEY `shopify_order_mappings_medium_index` (`shopify_order_id`,`link_type`,`link_id`,`sku_link_type`),
  CONSTRAINT `shopify_order_mappings_shopify_order_id_foreign` FOREIGN KEY (`shopify_order_id`) REFERENCES `shopify_orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `_id` bigint(20) unsigned DEFAULT NULL,
  `order_number` varchar(100) NOT NULL,
  `number` bigint(20) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.number'))) STORED,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `sku_sales_order_id` bigint(20) unsigned DEFAULT NULL,
  `error_log` varchar(255) DEFAULT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `updated_by` varchar(255) DEFAULT NULL,
  `downloaded_by` varchar(255) DEFAULT NULL,
  `sku_updated_at` datetime DEFAULT NULL,
  `sku_order_updated_at` timestamp NULL DEFAULT NULL,
  `sku_created_at` datetime DEFAULT NULL,
  `transactions_updated_at` datetime DEFAULT NULL,
  `transactions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`transactions`)),
  `unprocessed_changes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`unprocessed_changes`)),
  `archived_at` datetime DEFAULT NULL,
  `errors` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`errors`)),
  `created_at_utc` datetime DEFAULT NULL,
  `customer` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.customer'))) STORED,
  `shipping_address` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipping_address'))) STORED,
  `email` varchar(200) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.email'))) STORED,
  `billing_address` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.billing_address'))) STORED,
  `line_items` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.line_items'))) STORED,
  `discount_applications` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.discount_applications'))) STORED,
  `total_price` varchar(200) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total_price'))) STORED,
  `taxes_included` char(5) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.taxes_included'))) STORED,
  `currency` varchar(200) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.currency'))) STORED,
  `refunds` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.refunds'))) STORED,
  `refund_lines_count` int(11) GENERATED ALWAYS AS (json_length(json_extract(json_extract(`refunds`,'$[*].refund_line_items','$[*].order_adjustments'),'$[*][*]'))) STORED,
  `processed_at` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.processed_at'))) STORED,
  `name` varchar(200) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.name'))) STORED,
  `fulfillments` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillments'))) STORED,
  `shipping_lines` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipping_lines'))) STORED,
  `updated_at` varchar(255) DEFAULT NULL,
  `updatedAtUtc` datetime DEFAULT NULL,
  `created_at` varchar(255) DEFAULT NULL,
  `createdAtUtc` datetime DEFAULT NULL,
  `shopify_order_id` bigint(20) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.id'))) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shopify_orders_order_number_integration_instance_id_unique` (`order_number`,`integration_instance_id`),
  UNIQUE KEY `shopify_orders_sku_sales_order_id_unique` (`sku_sales_order_id`),
  UNIQUE KEY `shopify_orders_integration_instance_id_shopify_order_id_unique` (`integration_instance_id`,`shopify_order_id`),
  KEY `shopify_orders_integration_instance_id_order_number_index` (`integration_instance_id`,`order_number`),
  KEY `shopify_orders_name_index` (`name`),
  KEY `shopify_orders_updated_at_index` (`updated_at`),
  KEY `shopify_orders_transactions_updated_at_index` (`transactions_updated_at`),
  KEY `shopify_orders_shopify_order_id_index` (`shopify_order_id`),
  KEY `composite_index_for_update_order_query` (`integration_instance_id`,`archived_at`,`sku_sales_order_id`,`sku_order_updated_at`,`updatedAtUtc`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `_id` bigint(20) unsigned DEFAULT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `variant_id` bigint(20) NOT NULL,
  `inventory_item_id` bigint(20) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.inventory_item_id'))) STORED,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `barcode` varchar(255) GENERATED ALWAYS AS (if(convert(json_unquote(json_extract(`json_object`,'$.barcode')) using utf8mb4) = 'null',NULL,json_unquote(json_extract(`json_object`,'$.barcode')))) STORED,
  `has_orders` tinyint(1) DEFAULT NULL,
  `removed_from_shopify` tinyint(1) NOT NULL DEFAULT 0,
  `mapped_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `sku_created_at` timestamp NULL DEFAULT NULL,
  `sku_updated_at` timestamp NULL DEFAULT NULL,
  `product` bigint(20) unsigned DEFAULT NULL,
  `updated_by` varchar(255) DEFAULT NULL,
  `downloaded_by` varchar(255) DEFAULT NULL,
  `images` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.images'))) STORED,
  `image_count` int(11) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.image_count'))) STORED,
  `price` decimal(12,4) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.price'))) STORED,
  `unit_cost` decimal(12,4) DEFAULT NULL,
  `weight` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.weight'))) STORED,
  `weight_unit` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.weight_unit'))) STORED,
  `inventory_quantity` int(10) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.inventory_quantity'))) STORED,
  `image` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.image'))) STORED,
  `handle` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.handle'))) STORED,
  `grams` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.grams'))) STORED,
  `fulfillment_service` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.fulfillment_service'))) STORED,
  `body_html` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.body_html'))) STORED,
  `product_title` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_title'))) STORED,
  `variant_title` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.variant_title'))) STORED,
  `admin_graphql_api_id` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.admin_graphql_api_id'))) STORED,
  `title` varchar(200) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.title'))) STORED,
  `product_id` bigint(20) unsigned GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_id'))) STORED,
  `vendor` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.vendor'))) STORED,
  `was_catalog_data_sync_attempted` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shopify_products_variant_id_integration_instance_id_unique` (`variant_id`,`integration_instance_id`),
  KEY `shopify_products_variant_id_index` (`variant_id`),
  KEY `shopify_products_integration_instance_id_sku_index` (`integration_instance_id`),
  KEY `shopify_products_integration_instance_id_inventory_item_id_index` (`integration_instance_id`,`inventory_item_id`),
  KEY `shopify_products_product_foreign` (`product`),
  KEY `shopify_products_image_count_index` (`image_count`),
  KEY `shopify_products_created_at_index` (`created_at`),
  KEY `shopify_products_sku_index` (`integration_instance_id`,`sku`),
  CONSTRAINT `shopify_products_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`),
  CONSTRAINT `shopify_products_product_foreign` FOREIGN KEY (`product`) REFERENCES `product_listings` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_webhook_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_webhook_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `topic` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `payload_date` datetime NOT NULL,
  `processed_at` datetime DEFAULT NULL,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_data`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shopify_webhook_events_integration_instance_id_unique_id_index` (`integration_instance_id`,`unique_id`),
  KEY `shopify_webhook_events_topic_index` (`topic`),
  KEY `shopify_webhook_events_payload_date_index` (`payload_date`),
  CONSTRAINT `shopify_webhook_events_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `shopify_webhooks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopify_webhooks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_data`)),
  `topic` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.topic'))) STORED,
  `address` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.address'))) STORED,
  `shopify_webhook_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_data`,'$.id'))) STORED,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shopify_webhooks_integration_instance_id_topic_unique` (`integration_instance_id`,`topic`),
  CONSTRAINT `shopify_webhooks_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `starshipit_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `starshipit_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `_id` bigint(20) unsigned DEFAULT NULL,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `rawOrder` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`rawOrder`)),
  `order_id` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_id'))) STORED,
  `sku_fulfillment_id` bigint(20) unsigned DEFAULT NULL,
  `errors` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.currency'))) STORED,
  `packages` longtext GENERATED ALWAYS AS (case when cast(json_type(json_extract(`json_object`,'$.packages')) as char charset utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.packages')) end) STORED,
  `dangerous_goods` varchar(10) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.dangerous_goods'))) STORED,
  `declared_value` decimal(12,4) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.declared_value'))) STORED,
  `destination` longtext GENERATED ALWAYS AS (case when cast(json_type(json_extract(`json_object`,'$.destination')) as char charset utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.destination')) end) STORED,
  `items` longtext GENERATED ALWAYS AS (case when cast(json_type(json_extract(`json_object`,'$.items')) as char charset utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.items')) end) STORED,
  `add_insurance` varchar(10) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.add_insurance'))) STORED,
  `address_validation` varchar(10) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.address_validation'))) STORED,
  `carrier` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.carrier'))) STORED,
  `carrier_name` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.carrier_name'))) STORED,
  `carrier_service_code` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.carrier_service_code'))) STORED,
  `create_return` varchar(10) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.create_return'))) STORED,
  `dtp` varchar(10) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.dtp'))) STORED,
  `events` longtext GENERATED ALWAYS AS (case when cast(json_type(json_extract(`json_object`,'$.events')) as char charset utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.events')) end) STORED,
  `export_type` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.export_type'))) STORED,
  `insurance_value` decimal(12,4) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.insurance_value'))) STORED,
  `order_date` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_date'))) STORED,
  `order_number` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.order_number'))) STORED,
  `plt` varchar(10) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.plt'))) STORED,
  `reference` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.reference'))) STORED,
  `sender_details` longtext GENERATED ALWAYS AS (case when cast(json_type(json_extract(`json_object`,'$.sender_details')) as char charset utf8mb4) = '' then NULL else json_unquote(json_extract(`json_object`,'$.sender_details')) end) STORED,
  `signature_required` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.signature_required'))) STORED,
  `type` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.type'))) STORED,
  `writeback_status` varchar(100) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.writeback_status'))) STORED,
  `shipping_description` text GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.shipping_description'))) STORED,
  `total_shipping_price` decimal(12,4) DEFAULT NULL,
  `writeback_details` longtext GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.writeback_details'))) STORED,
  `shipment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`shipment`)),
  `manifest_number` varchar(50) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.manifest_number'))) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `starshipit_orders_order_id_unique` (`order_id`),
  KEY `starshipit_orders_sku_fulfillment_id_foreign` (`sku_fulfillment_id`),
  KEY `starshipit_orders_order_number_index` (`order_number`),
  CONSTRAINT `starshipit_orders_sku_fulfillment_id_foreign` FOREIGN KEY (`sku_fulfillment_id`) REFERENCES `sales_order_fulfillments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `stock_take_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_take_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stock_take_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `snapshot_inventory` double DEFAULT NULL,
  `qty_counted` double DEFAULT NULL,
  `unit_cost` double(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_take_items_stock_take_id_product_id_unique` (`stock_take_id`,`product_id`),
  KEY `stock_take_items_product_id_foreign` (`product_id`),
  KEY `stock_take_items_stock_take_id_foreign` (`stock_take_id`),
  CONSTRAINT `stock_take_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_take_items_stock_take_id_foreign` FOREIGN KEY (`stock_take_id`) REFERENCES `stock_takes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `stock_takes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_takes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_count` date NOT NULL,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `status` enum('draft','open','closed') NOT NULL DEFAULT 'draft',
  `notes` varchar(255) DEFAULT NULL,
  `value_change` double(8,2) DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_takes_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `stock_takes_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `store_email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `store_email_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `store_id` int(10) unsigned NOT NULL,
  `type` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `html_body` longtext NOT NULL,
  `sent_type` enum('manually','automatically') NOT NULL,
  `attach_pdf` int(11) NOT NULL DEFAULT 0,
  `enabled` int(11) NOT NULL DEFAULT 0,
  `archived_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sales_channel_brand_id_foreign` (`store_id`),
  CONSTRAINT `sales_channel_brand_id_foreign` FOREIGN KEY (`store_id`) REFERENCES `stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `store_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `store_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `sku_store_id` int(10) unsigned NOT NULL,
  `magento_store_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_mappings_integration_instance_id_foreign` (`integration_instance_id`),
  KEY `store_mappings_sku_store_id_foreign` (`sku_store_id`),
  CONSTRAINT `store_mappings_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE CASCADE,
  CONSTRAINT `store_mappings_sku_store_id_foreign` FOREIGN KEY (`sku_store_id`) REFERENCES `stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `po_email` varchar(255) DEFAULT NULL,
  `address_id` bigint(20) unsigned DEFAULT NULL,
  `logo_url` varchar(255) DEFAULT NULL,
  `custom_jrxml_file` varchar(255) DEFAULT NULL,
  `custom_message` mediumtext DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stores_address_id_foreign` (`address_id`),
  CONSTRAINT `stores_address_id_foreign` FOREIGN KEY (`address_id`) REFERENCES `addresses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `supplier_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplier_inventory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `quantity` bigint(20) DEFAULT NULL,
  `in_stock` tinyint(1) DEFAULT NULL,
  `discontinued` tinyint(1) NOT NULL DEFAULT 0,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `eta` date DEFAULT NULL,
  `source` enum('user','api') DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `supplier_inventory_supplier_id_index` (`supplier_id`),
  KEY `supplier_inventory_warehouse_id_index` (`warehouse_id`),
  CONSTRAINT `supplier_inventory_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `supplier_inventory_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`),
  CONSTRAINT `supplier_inventory_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `supplier_pricing_tiers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplier_pricing_tiers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `currency_code` varchar(255) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `supplier_product_pricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplier_product_pricing` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_pricing_tier_id` int(10) unsigned NOT NULL,
  `supplier_product_id` bigint(20) unsigned NOT NULL,
  `price` decimal(9,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_product_pricing_supplier_pricing_tier_id_foreign` (`supplier_pricing_tier_id`),
  KEY `vendor_product_pricing_vendor_product_id_foreign` (`supplier_product_id`),
  CONSTRAINT `supplier_product_pricing_supplier_pricing_tier_id_foreign` FOREIGN KEY (`supplier_pricing_tier_id`) REFERENCES `supplier_pricing_tiers` (`id`),
  CONSTRAINT `vendor_product_pricing_vendor_product_id_foreign` FOREIGN KEY (`supplier_product_id`) REFERENCES `supplier_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `supplier_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplier_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `supplier_sku` varchar(255) DEFAULT NULL,
  `leadtime` int(11) DEFAULT NULL,
  `minimum_order_quantity` decimal(8,2) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `default_tax_rate_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `supplier_products_product_id_vendor_id_unique` (`product_id`,`supplier_id`),
  KEY `supplier_products_vendor_id_foreign` (`supplier_id`),
  KEY `supplier_products_default_tax_rate_id_index` (`default_tax_rate_id`),
  CONSTRAINT `supplier_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `supplier_products_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `supplier_to_pricing_tier`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `supplier_to_pricing_tier` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `supplier_id` bigint(20) unsigned NOT NULL,
  `supplier_pricing_tier_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_to_pricing_tier_supplier_id_foreign` (`supplier_id`),
  KEY `supplier_to_pricing_tier_supplier_pricing_tier_id_foreign` (`supplier_pricing_tier_id`),
  CONSTRAINT `supplier_to_pricing_tier_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`),
  CONSTRAINT `supplier_to_pricing_tier_supplier_pricing_tier_id_foreign` FOREIGN KEY (`supplier_pricing_tier_id`) REFERENCES `supplier_pricing_tiers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `suppliers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `primary_contact_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `purchase_order_email` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `leadtime` int(11) DEFAULT NULL,
  `minimum_order_quantity` int(11) DEFAULT NULL,
  `minimum_purchase_order` decimal(9,4) DEFAULT NULL,
  `address_id` bigint(20) unsigned DEFAULT NULL,
  `purchase_order_format` varchar(255) DEFAULT NULL,
  `default_pricing_tier_id` int(10) unsigned DEFAULT NULL,
  `default_warehouse_id` bigint(20) unsigned DEFAULT NULL,
  `default_shipping_method_id` int(10) unsigned DEFAULT NULL,
  `default_store_id` int(10) unsigned DEFAULT NULL,
  `auto_fulfill_dropship` tinyint(4) NOT NULL DEFAULT 0,
  `auto_submit_dropship_po` tinyint(1) NOT NULL DEFAULT 0,
  `po_processing_method` enum('individually','batch') NOT NULL DEFAULT 'individually',
  `po_batch_schedule` mediumtext DEFAULT NULL,
  `auto_generate_backorder_po` tinyint(1) NOT NULL DEFAULT 0,
  `auto_submit_backorder_po` tinyint(1) NOT NULL DEFAULT 0,
  `auto_split_backorder_po_by_brand` tinyint(1) NOT NULL DEFAULT 0,
  `auto_receive_backorder_po` tinyint(1) NOT NULL DEFAULT 0,
  `backorder_po_schedule` mediumtext DEFAULT NULL,
  `default_stock_level` enum('0','in_stock','not_in_stock') NOT NULL DEFAULT 'in_stock',
  `default_tax_rate_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `vendors_name_unique` (`name`),
  KEY `suppliers_default_store_id_index` (`default_store_id`),
  KEY `suppliers_address_id_foreign` (`address_id`),
  KEY `suppliers_default_pricing_tier_id_foreign` (`default_pricing_tier_id`),
  KEY `suppliers_default_warehouse_id_foreign` (`default_warehouse_id`),
  KEY `suppliers_default_shipping_method_id_foreign` (`default_shipping_method_id`),
  KEY `suppliers_default_tax_rate_id_index` (`default_tax_rate_id`),
  CONSTRAINT `suppliers_address_id_foreign` FOREIGN KEY (`address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `suppliers_default_pricing_tier_id_foreign` FOREIGN KEY (`default_pricing_tier_id`) REFERENCES `supplier_pricing_tiers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `suppliers_default_shipping_method_id_foreign` FOREIGN KEY (`default_shipping_method_id`) REFERENCES `shipping_methods` (`id`) ON DELETE SET NULL,
  CONSTRAINT `suppliers_default_store_id_foreign` FOREIGN KEY (`default_store_id`) REFERENCES `stores` (`id`) ON DELETE SET NULL,
  CONSTRAINT `suppliers_default_warehouse_id_foreign` FOREIGN KEY (`default_warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `table_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `table_views` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `model` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `is_favorite` int(11) NOT NULL DEFAULT 0,
  `is_default` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `taggables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taggables` (
  `tag_id` bigint(20) unsigned NOT NULL,
  `taggable_type` varchar(255) NOT NULL,
  `taggable_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  UNIQUE KEY `taggables_tag_id_taggable_id_taggable_type_unique` (`tag_id`,`taggable_id`,`taggable_type`),
  KEY `taggables_taggable_type_taggable_id_index` (`taggable_type`,`taggable_id`),
  CONSTRAINT `taggables_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `tags` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `taggables_legacy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taggables_legacy` (
  `tag_id` bigint(20) unsigned NOT NULL,
  `taggable_id` bigint(20) unsigned NOT NULL,
  `taggable_type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`tag_id`,`taggable_id`,`taggable_type`),
  KEY `taggable_id` (`taggable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`name`)),
  `slug` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`slug`)),
  `type` varchar(255) DEFAULT NULL,
  `order_column` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tags_legacy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tags_legacy` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `task_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `is_running` tinyint(1) NOT NULL DEFAULT 1,
  `info` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_status_is_running_index` (`is_running`),
  KEY `task_status_user_id_foreign` (`user_id`),
  CONSTRAINT `task_status_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tax_rate_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rate_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `rate` decimal(7,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rate_lines_tax_rate_id_foreign` (`tax_rate_id`),
  KEY `tax_rate_lines_name_index` (`name`),
  CONSTRAINT `tax_rate_lines_tax_rate_id_foreign` FOREIGN KEY (`tax_rate_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `rate` decimal(7,4) NOT NULL,
  `accounting_integration_id` bigint(20) unsigned DEFAULT NULL,
  `accounting_integration_type` varchar(255) DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tax_rates_name_unique` (`name`),
  KEY `tax_rates_name_index` (`name`),
  KEY `accounting_integration_link` (`accounting_integration_id`,`accounting_integration_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tax_rates_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sku_tax_rate_id` int(11) NOT NULL,
  `xero_tax_rate_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `temporary_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `temporary_tables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `tracked_job_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tracked_job_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` varchar(255) DEFAULT NULL,
  `job_type` varchar(255) NOT NULL,
  `queue` varchar(255) NOT NULL,
  `job_name` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `related_model_type` varchar(255) DEFAULT NULL,
  `related_model_id` int(11) DEFAULT NULL,
  `duration` decimal(10,2) GENERATED ALWAYS AS (case when `attempted_at` is null or `completed_at` is null then NULL else round(timestampdiff(SECOND,`attempted_at`,`completed_at`) + (microsecond(`completed_at`) - microsecond(`attempted_at`)) / 1000000,2) end) STORED,
  `messages` text DEFAULT NULL,
  `job_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`job_data`)),
  `attempted_at` datetime(3) DEFAULT NULL,
  `completed_at` datetime(3) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `user_alert_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_alert_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `alert_type` varchar(255) NOT NULL,
  `show_in_ui_notification` tinyint(1) NOT NULL DEFAULT 1,
  `alert_by_email` tinyint(1) NOT NULL DEFAULT 0,
  `priority` tinyint(4) NOT NULL DEFAULT 5,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_alert_settings_user_id_foreign` (`user_id`),
  CONSTRAINT `user_alert_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `user_apis`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_apis` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `key` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_apis_user_id_foreign` (`user_id`),
  CONSTRAINT `user_apis_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `user_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_config` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `key` varchar(255) NOT NULL,
  `value` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_config_user_id_foreign` (`user_id`),
  CONSTRAINT `user_config_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` datetime DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `is_admin` tinyint(1) DEFAULT NULL,
  `is_power_user` tinyint(1) NOT NULL DEFAULT 1,
  `auth_2fa_strategy` varchar(255) NOT NULL DEFAULT 'NONE',
  `auth_2fa_token_email` varchar(255) DEFAULT NULL,
  `auth_2fa_token_email_expiration` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouse_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_id` bigint(20) unsigned NOT NULL,
  `aisle` varchar(255) NOT NULL,
  `bay` varchar(255) DEFAULT NULL,
  `shelf` varchar(255) DEFAULT NULL,
  `bin` varchar(255) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_locations_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `warehouse_locations_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouse_transfer_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_transfer_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_transfer_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `quantity` bigint(20) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_transfer_lines_product_id_foreign` (`product_id`),
  KEY `warehouse_transfer_lines_warehouse_transfer_id_foreign` (`warehouse_transfer_id`),
  CONSTRAINT `warehouse_transfer_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `warehouse_transfer_lines_warehouse_transfer_id_foreign` FOREIGN KEY (`warehouse_transfer_id`) REFERENCES `warehouse_transfers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouse_transfer_shipment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_transfer_shipment_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_transfer_shipment_id` bigint(20) unsigned NOT NULL,
  `warehouse_transfer_line_id` bigint(20) unsigned NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_transfer_shipment_id_foreign` (`warehouse_transfer_shipment_id`),
  KEY `warehouse_transfer_line_id_foreign` (`warehouse_transfer_line_id`),
  CONSTRAINT `warehouse_transfer_line_id_foreign` FOREIGN KEY (`warehouse_transfer_line_id`) REFERENCES `warehouse_transfer_lines` (`id`),
  CONSTRAINT `warehouse_transfer_shipment_id_foreign` FOREIGN KEY (`warehouse_transfer_shipment_id`) REFERENCES `warehouse_transfer_shipments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouse_transfer_shipment_receipt_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_transfer_shipment_receipt_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_transfer_shipment_receipt_id` bigint(20) unsigned NOT NULL,
  `warehouse_transfer_shipment_line_id` bigint(20) unsigned NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_transfer_shipment_receipt_id_foreign` (`warehouse_transfer_shipment_receipt_id`),
  KEY `warehouse_transfer_shipment_line_id_foreign` (`warehouse_transfer_shipment_line_id`),
  CONSTRAINT `warehouse_transfer_shipment_line_id_foreign` FOREIGN KEY (`warehouse_transfer_shipment_line_id`) REFERENCES `warehouse_transfer_shipment_lines` (`id`),
  CONSTRAINT `warehouse_transfer_shipment_receipt_id_foreign` FOREIGN KEY (`warehouse_transfer_shipment_receipt_id`) REFERENCES `warehouse_transfer_shipment_receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouse_transfer_shipment_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_transfer_shipment_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_transfer_shipment_id` bigint(20) unsigned NOT NULL,
  `received_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `receipts_warehouse_transfer_shipment_id_foreign` (`warehouse_transfer_shipment_id`),
  CONSTRAINT `receipts_warehouse_transfer_shipment_id_foreign` FOREIGN KEY (`warehouse_transfer_shipment_id`) REFERENCES `warehouse_transfer_shipments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouse_transfer_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_transfer_shipments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_transfer_id` bigint(20) unsigned NOT NULL,
  `shipping_method_id` int(10) unsigned DEFAULT NULL,
  `cost` decimal(9,4) DEFAULT NULL,
  `tracking_number` varchar(255) DEFAULT NULL,
  `shipped_at` datetime DEFAULT NULL,
  `fully_received_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_transfer_shipments_warehouse_transfer_id_foreign` (`warehouse_transfer_id`),
  KEY `warehouse_transfer_shipments_shipping_method_id_foreign` (`shipping_method_id`),
  CONSTRAINT `warehouse_transfer_shipments_shipping_method_id_foreign` FOREIGN KEY (`shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `warehouse_transfer_shipments_warehouse_transfer_id_foreign` FOREIGN KEY (`warehouse_transfer_id`) REFERENCES `warehouse_transfers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouse_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouse_transfers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `warehouse_transfer_number` varchar(255) DEFAULT NULL,
  `transfer_date` datetime DEFAULT NULL,
  `from_warehouse_id` bigint(20) unsigned NOT NULL,
  `to_warehouse_id` bigint(20) unsigned NOT NULL,
  `eta` datetime DEFAULT NULL,
  `shipping_method_id` int(10) unsigned DEFAULT NULL,
  `transfer_status` enum('draft','open','closed') NOT NULL,
  `shipment_status` enum('unshipped','partially_shipped','shipped') NOT NULL,
  `shipment_id` varchar(255) DEFAULT NULL,
  `receipt_status` enum('unreceived','partially_received','received') NOT NULL,
  `fully_shipped_at` datetime DEFAULT NULL,
  `fully_received_at` datetime DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_transfers_from_warehouse_id_foreign` (`from_warehouse_id`),
  KEY `warehouse_transfers_to_warehouse_id_foreign` (`to_warehouse_id`),
  KEY `warehouse_transfers_shipping_method_id_foreign` (`shipping_method_id`),
  CONSTRAINT `warehouse_transfers_from_warehouse_id_foreign` FOREIGN KEY (`from_warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `warehouse_transfers_shipping_method_id_foreign` FOREIGN KEY (`shipping_method_id`) REFERENCES `shipping_methods` (`id`),
  CONSTRAINT `warehouse_transfers_to_warehouse_id_foreign` FOREIGN KEY (`to_warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `warehouses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warehouses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('direct','3pl','supplier','amazon_fba') NOT NULL,
  `address_id` bigint(20) unsigned DEFAULT NULL,
  `supplier_id` bigint(20) unsigned DEFAULT NULL,
  `integration_instance_id` bigint(20) unsigned DEFAULT NULL,
  `order_fulfillment` varchar(255) DEFAULT NULL,
  `dropship_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `direct_returns` tinyint(1) NOT NULL DEFAULT 0,
  `auto_routing_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `customer_returns` tinyint(1) NOT NULL DEFAULT 0,
  `archived_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouses_integration_instance_id_foreign` (`integration_instance_id`),
  KEY `warehouses_address_id_foreign` (`address_id`),
  KEY `warehouses_supplier_id_index` (`supplier_id`),
  CONSTRAINT `warehouses_address_id_foreign` FOREIGN KEY (`address_id`) REFERENCES `addresses` (`id`),
  CONSTRAINT `warehouses_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`) ON DELETE SET NULL,
  CONSTRAINT `warehouses_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `websockets_statistics_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `websockets_statistics_entries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(255) NOT NULL,
  `peak_connection_count` int(11) NOT NULL,
  `websocket_message_count` int(11) NOT NULL,
  `api_message_count` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `woo_commerce_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `woo_commerce_order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `woo_commerce_order_id` bigint(20) unsigned NOT NULL,
  `line_item_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.id'))) STORED,
  `name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.name'))) STORED,
  `product_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.product_id'))) STORED,
  `quantity` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.quantity'))) STORED,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `woo_commerce_orders_items_line_item_id_composite_unique` (`line_item_id`,`woo_commerce_order_id`),
  KEY `woo_commerce_order_items_woo_commerce_order_id_index` (`woo_commerce_order_id`),
  CONSTRAINT `woo_commerce_order_items_woo_commerce_order_id_foreign` FOREIGN KEY (`woo_commerce_order_id`) REFERENCES `woo_commerce_orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `woo_commerce_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `woo_commerce_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `woo_commerce_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.id'))) STORED,
  `number` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.number'))) STORED,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.status'))) STORED,
  `error_log` varchar(255) DEFAULT NULL,
  `currency` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.currency'))) STORED,
  `date_completed` datetime DEFAULT NULL,
  `date_modified_gmt` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.date_modified_gmt'))) STORED,
  `date_created_gmt` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.date_created_gmt'))) STORED,
  `total` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total'))) STORED,
  `total_tax` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.total_tax'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `archived_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `woo_commerce_orders_woo_commerce_id_composite_unique` (`woo_commerce_id`,`integration_instance_id`),
  KEY `woo_commerce_orders_integration_instance_id_index` (`integration_instance_id`),
  KEY `woo_commerce_orders_woo_commerce_id_index` (`woo_commerce_id`),
  KEY `woo_commerce_orders_number_index` (`number`),
  CONSTRAINT `woo_commerce_orders_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `woo_commerce_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `woo_commerce_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `integration_instance_id` bigint(20) unsigned NOT NULL,
  `woo_commerce_id` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.id'))) STORED,
  `sku` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.sku'))) STORED,
  `name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.name'))) STORED,
  `slug` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.slug'))) STORED,
  `type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.type'))) STORED,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.status'))) STORED,
  `price` decimal(12,4) GENERATED ALWAYS AS (case when convert(json_unquote(json_extract(`json_object`,'$.price')) using utf8mb4) = '' then 0 else cast(json_unquote(json_extract(`json_object`,'$.price')) as decimal(12,4)) end) STORED,
  `weight` varchar(12) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.weight'))) STORED,
  `dimensions_length` varchar(12) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.dimensions.length'))) STORED,
  `dimensions_width` varchar(12) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.dimensions.width'))) STORED,
  `dimensions_height` varchar(12) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.dimensions.height'))) STORED,
  `featured` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.featured'))) STORED,
  `catalog_visibility` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.catalog_visibility'))) STORED,
  `date_created_gmt` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.date_created_gmt'))) STORED,
  `date_modified_gmt` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.date_modified_gmt'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `woo_commerce_products_integration_instance_id_index` (`integration_instance_id`),
  CONSTRAINT `woo_commerce_products_integration_instance_id_foreign` FOREIGN KEY (`integration_instance_id`) REFERENCES `integration_instances` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `xero_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xero_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `AccountID` varchar(255) NOT NULL,
  `Name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Name'))) STORED,
  `Code` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Code'))) STORED,
  `Type` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Type'))) STORED,
  `Status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Status'))) STORED,
  `Class` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Class'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `xero_accounts_accountid_unique` (`AccountID`),
  UNIQUE KEY `xero_accounts_code_unique` (`Code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `xero_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xero_contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ContactID` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.ContactID'))) STORED,
  `Name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Name'))) STORED,
  `link_id` bigint(20) unsigned DEFAULT NULL,
  `link_type` varchar(255) DEFAULT NULL,
  `last_error` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`last_error`)),
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `xero_contacts_link_id_link_type_unique` (`link_id`,`link_type`),
  UNIQUE KEY `xero_contacts_contactid_unique` (`ContactID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `xero_manual_journals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xero_manual_journals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ManualJournalID` varchar(255) DEFAULT NULL,
  `DateUTC` datetime NOT NULL,
  `UpdatedDateUTC` datetime NOT NULL,
  `Status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Status'))) STORED,
  `Narration` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Narration'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `xero_manual_journals_manualjournalid_unique` (`ManualJournalID`),
  KEY `xero_manual_journals_narration_index` (`Narration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `xero_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xero_payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `PaymentID` varchar(255) DEFAULT NULL,
  `last_error` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`last_error`)),
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `xero_payments_paymentid_unique` (`PaymentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `xero_tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xero_tax_rates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Name'))) STORED,
  `TaxType` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.TaxType'))) STORED,
  `EffectiveRate` decimal(12,4) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.EffectiveRate'))) STORED,
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `xero_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `xero_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `xero_uuid` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `status` varchar(255) GENERATED ALWAYS AS (json_unquote(json_extract(`json_object`,'$.Status'))) STORED,
  `last_error` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`last_error`)),
  `json_object` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`json_object`)),
  `request_body` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`request_body`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `xero_transactions_xero_uuid_unique` (`xero_uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
DROP TABLE IF EXISTS `zip_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `zip_locations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zip` varchar(255) NOT NULL,
  `lat` double(10,6) NOT NULL,
  `lng` double(10,6) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `getProductListingQuantity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `getProductListingQuantity`(productListingInventoryRules JSON, integrationInstanceInventoryRules JSON, inventoryAvailable INT) RETURNS int(11)
BEGIN
  IF inventoryAvailable = 0 or inventoryAvailable IS NULL THEN RETURN 0; END IF;

  SET @inventoryRules := IFNULL(productListingInventoryRules, integrationInstanceInventoryRules);

  SET @maxRuleType := JSON_UNQUOTE(JSON_EXTRACT(@inventoryRules, '$.maxRuleType'));
  SET @minRuleType := JSON_UNQUOTE(JSON_EXTRACT(@inventoryRules, '$.minRuleType'));
  SET @maxRuleTypeValue := CAST(JSON_UNQUOTE(JSON_EXTRACT(@inventoryRules, '$.maxRuleTypeValue')) as INTEGER);
  SET @minRuleTypeValue := CAST(JSON_UNQUOTE(JSON_EXTRACT(@inventoryRules, '$.minRuleTypeValue')) as INTEGER);
  SET @substractBufferStock := IFNULL(CAST(JSON_UNQUOTE(JSON_EXTRACT(@inventoryRules, '$.substractBufferStock')) as INTEGER), 0);
  SET @maxQuantityValue := IF(@maxRuleType = 'Fixed Allocation', IF(@maxRuleTypeValue < inventoryAvailable, @maxRuleTypeValue, inventoryAvailable), inventoryAvailable);
  SET @minQuantityValue := IF(@minRuleType = '% of Available', (inventoryAvailable * @minRuleTypeValue / 100), inventoryAvailable);
  SET @maxQuantity := CASE
      WHEN @maxRuleType = '% of Available'
          THEN (inventoryAvailable * @maxRuleTypeValue / 100)
      WHEN @maxRuleType = 'Fixed Allocation'
          THEN IF(@maxRuleTypeValue < inventoryAvailable, @maxRuleTypeValue, inventoryAvailable)
      WHEN @maxRuleType = 'None' or @minRuleType = 'None'
          THEN inventoryAvailable
      END;
  SET @maxSubBuffer := @maxQuantity - @substractBufferStock;
  SET @maxQuantity := IF (@maxSubBuffer < 0, 0, @maxSubBuffer);
  SET @minQuantity := CASE
      WHEN @minRuleType = '% of Available'
          THEN (inventoryAvailable * @minRuleTypeValue / 100)
      WHEN @minRuleType = 'Fixed Allocation'
          THEN if(@minRuleTypeValue > inventoryAvailable, @minRuleTypeValue, inventoryAvailable)
      END;

  return IF(@maxRuleType = @minRuleType AND @maxRuleType != 'None', IF(@minQuantityValue >= @maxQuantityValue, @maxQuantityValue, @minQuantityValue), IF(@minQuantity > 0, @minQuantity, @maxSubBuffer));
END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
/*!50003 DROP FUNCTION IF EXISTS `sum_array_cells` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
DELIMITER ;;
CREATE DEFINER=`root`@`localhost` FUNCTION `sum_array_cells`(input_array json ) RETURNS double
    DETERMINISTIC
begin
    declare array_length integer;
    declare retval double;
    declare cell_value double;
    declare idx int;

    select json_length( input_array ) into array_length;

    set retval = 0.0;

    set idx = 0;
    while idx < array_length do
        select json_extract( input_array, concat( '$[', idx, ']' ) )
        into cell_value;

        set retval = retval + cell_value;
        set idx = idx + 1;
    end while;

    return retval;

end ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1);
INSERT INTO `migrations` VALUES (2,'2014_10_12_100000_create_password_resets_table',1);
INSERT INTO `migrations` VALUES (3,'2018_08_08_100000_create_telescope_entries_table',1);
INSERT INTO `migrations` VALUES (4,'2019_03_14_083639_create_sales_channel_types_table',1);
INSERT INTO `migrations` VALUES (5,'2019_03_14_093741_create_sales_channel_brands_table',1);
INSERT INTO `migrations` VALUES (6,'2019_03_15_055322_create_sales_channels_table',1);
INSERT INTO `migrations` VALUES (7,'2019_03_24_012721_create_products_table',1);
INSERT INTO `migrations` VALUES (8,'2019_03_24_192313_create_sales_orders_table',1);
INSERT INTO `migrations` VALUES (9,'2019_03_24_194734_create_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (10,'2019_03_24_201915_create_nominal_codes_table',1);
INSERT INTO `migrations` VALUES (11,'2019_03_24_202625_create_product_brands_table',1);
INSERT INTO `migrations` VALUES (12,'2019_03_24_211745_create_suppliers_table',1);
INSERT INTO `migrations` VALUES (13,'2019_03_24_212008_create_warehouses_table',1);
INSERT INTO `migrations` VALUES (14,'2019_03_24_220806_create_amazon_orders',1);
INSERT INTO `migrations` VALUES (15,'2019_03_24_223720_create_amazon_feed_submissions',1);
INSERT INTO `migrations` VALUES (16,'2019_03_24_224515_create_amazon_reports',1);
INSERT INTO `migrations` VALUES (17,'2019_03_26_023100_create_addresses_table',1);
INSERT INTO `migrations` VALUES (18,'2019_03_26_024347_create_addressables_table',1);
INSERT INTO `migrations` VALUES (19,'2019_03_28_011521_create_attributes_table',1);
INSERT INTO `migrations` VALUES (20,'2019_03_28_011602_create_attribute_values_table',1);
INSERT INTO `migrations` VALUES (21,'2019_03_28_012136_create_product_attribute_table',1);
INSERT INTO `migrations` VALUES (22,'2019_03_28_014142_create_activity_log',1);
INSERT INTO `migrations` VALUES (23,'2019_03_28_031021_create_tags_table',1);
INSERT INTO `migrations` VALUES (24,'2019_03_28_031104_create_taggables_table',1);
INSERT INTO `migrations` VALUES (25,'2019_03_29_114154_create_product_categories_table',1);
INSERT INTO `migrations` VALUES (26,'2019_03_29_114704_create_customers_table',1);
INSERT INTO `migrations` VALUES (27,'2019_03_29_115330_create_api_tokens',1);
INSERT INTO `migrations` VALUES (28,'2019_04_15_102742_create_user_apis_table',1);
INSERT INTO `migrations` VALUES (29,'2019_05_09_073031_add_integration_options_to_sales_channels_table',1);
INSERT INTO `migrations` VALUES (30,'2019_05_13_031120_rename_product_attributes_table',1);
INSERT INTO `migrations` VALUES (31,'2019_05_13_031140_alter_product_attributes_table',1);
INSERT INTO `migrations` VALUES (32,'2019_05_26_121454_add_email_column_to_addresses_table',1);
INSERT INTO `migrations` VALUES (33,'2019_05_27_082720_add_status_column_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (34,'2019_05_27_083225_alter_columns_nullable_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (35,'2019_05_27_083558_add_address3_column_to_addresses_table',1);
INSERT INTO `migrations` VALUES (36,'2019_05_27_083731_alter_columns_nullable_to_addresses_table',1);
INSERT INTO `migrations` VALUES (37,'2019_06_01_134245_create_product_listings_table',1);
INSERT INTO `migrations` VALUES (38,'2019_06_08_080924_create_ebay_products',1);
INSERT INTO `migrations` VALUES (39,'2019_06_08_091634_create_shopify_products',1);
INSERT INTO `migrations` VALUES (40,'2019_06_08_131757_create_woo-commerce-products',1);
INSERT INTO `migrations` VALUES (41,'2019_06_09_090703_create_amazon_products',1);
INSERT INTO `migrations` VALUES (42,'2019_06_11_132714_alter_columns_nullable_to_products_table',1);
INSERT INTO `migrations` VALUES (43,'2019_06_12_081802_add_name_column_to_products_table',1);
INSERT INTO `migrations` VALUES (44,'2019_06_16_000000_create_user_config_table',1);
INSERT INTO `migrations` VALUES (45,'2019_06_19_132446_add_sales_channel_line_id_column_to_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (46,'2019_06_20_075110_create_incoterms_table',1);
INSERT INTO `migrations` VALUES (47,'2019_06_20_075111_create_payment_terms_table',1);
INSERT INTO `migrations` VALUES (48,'2019_06_20_075112_create_vendors_table',1);
INSERT INTO `migrations` VALUES (49,'2019_06_20_075115_create_warehouse_locations_table',1);
INSERT INTO `migrations` VALUES (50,'2019_06_20_075120_create_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (51,'2019_06_20_081712_create_purchase_order_lines_table',1);
INSERT INTO `migrations` VALUES (52,'2019_06_20_084100_create_activity_logs_table',1);
INSERT INTO `migrations` VALUES (53,'2019_06_20_084146_create_user_alerts_table',1);
INSERT INTO `migrations` VALUES (54,'2019_06_20_085242_create_purchase_invoices_table',1);
INSERT INTO `migrations` VALUES (55,'2019_06_20_085255_create_purchase_invoice_lines_table',1);
INSERT INTO `migrations` VALUES (56,'2019_06_20_091035_create_fifo_layers_table',1);
INSERT INTO `migrations` VALUES (57,'2019_06_20_091043_create_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (58,'2019_06_20_092353_add_average_cost_column_to_products_table',1);
INSERT INTO `migrations` VALUES (59,'2019_06_20_093030_create_sales_channel_quantity_settings_table',1);
INSERT INTO `migrations` VALUES (60,'2019_06_20_093035_alter_to_product_listings_table',1);
INSERT INTO `migrations` VALUES (61,'2019_06_20_095215_alter_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (62,'2019_06_20_100230_alter_to_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (63,'2019_06_20_103332_create_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (64,'2019_06_20_104401_create_sales_order_fulfillment_lines_table',1);
INSERT INTO `migrations` VALUES (65,'2019_06_20_105745_create_product_bundle_components_table',1);
INSERT INTO `migrations` VALUES (66,'2019_06_20_110120_create_product_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (67,'2019_06_20_110125_create_product_pricing_table',1);
INSERT INTO `migrations` VALUES (68,'2019_06_20_110624_create_sales_channel_brand_email_templates_table',1);
INSERT INTO `migrations` VALUES (69,'2019_06_20_111010_create_inventory_bundling_table',1);
INSERT INTO `migrations` VALUES (70,'2019_06_20_111018_create_shipping_carriers_table',1);
INSERT INTO `migrations` VALUES (71,'2019_06_20_131730_create_shipping_providers_table',1);
INSERT INTO `migrations` VALUES (72,'2019_06_20_132043_create_shipping_methods_table',1);
INSERT INTO `migrations` VALUES (73,'2019_06_20_132222_create_shipping_method_mappings_sales_channel_to_sku_table',1);
INSERT INTO `migrations` VALUES (74,'2019_06_20_132351_create_shipping_method_mappings_sku_to_shipping_provider_carrier_table',1);
INSERT INTO `migrations` VALUES (75,'2019_06_20_132520_create_shipping_method_mappings_sku_to_shipping_provider_method_table',1);
INSERT INTO `migrations` VALUES (76,'2019_06_20_132730_create_supplier_products_table',1);
INSERT INTO `migrations` VALUES (77,'2019_06_20_132733_create_supplier_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (78,'2019_06_20_133136_create_supplier_product_pricing_table',1);
INSERT INTO `migrations` VALUES (79,'2019_06_20_134046_create_user_alert_settings_table',1);
INSERT INTO `migrations` VALUES (80,'2019_07_04_093218_create_amazon_fulfilled_shipments',1);
INSERT INTO `migrations` VALUES (81,'2019_07_18_115019_alter_user_alert_settings_table',1);
INSERT INTO `migrations` VALUES (82,'2019_09_19_161725_add_fba_prep_instructions_column_to_products_table',1);
INSERT INTO `migrations` VALUES (83,'2019_09_19_163220_create_warehouse_transfers_table',1);
INSERT INTO `migrations` VALUES (84,'2019_09_21_082736_alter_inventory_status_column_on_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (85,'2019_09_21_104140_create_warehouse_transfer_receipts_table',1);
INSERT INTO `migrations` VALUES (86,'2019_09_21_120704_create_inventory_adjustments_table',1);
INSERT INTO `migrations` VALUES (87,'2019_09_24_082219_add_competitive_price_columns_to_product_listings_table',1);
INSERT INTO `migrations` VALUES (88,'2019_09_28_084135_add_case_fields_to_products_table',1);
INSERT INTO `migrations` VALUES (89,'2019_09_28_091717_create_fba_inventory_adjustments_table',1);
INSERT INTO `migrations` VALUES (90,'2019_09_28_095907_add_amazon_fees_estimates_to_product_listings_table',1);
INSERT INTO `migrations` VALUES (91,'2019_10_03_101750_rename_addresssble_id_column_in_addressables_table',1);
INSERT INTO `migrations` VALUES (92,'2019_10_05_124948_set_warehouse_id_null_on_inventory_mevements_table',1);
INSERT INTO `migrations` VALUES (93,'2019_10_05_141721_create_products_blemished_table',1);
INSERT INTO `migrations` VALUES (94,'2019_10_08_090719_alter_type_column_on_products_table',1);
INSERT INTO `migrations` VALUES (95,'2019_10_08_115137_create_products_deleted_table',1);
INSERT INTO `migrations` VALUES (96,'2019_10_09_093820_create_failed_jobs_table',1);
INSERT INTO `migrations` VALUES (97,'2019_10_14_093423_create_jobs_table',1);
INSERT INTO `migrations` VALUES (98,'2019_10_26_002903_create_amazon_fba_removal_shipments_table',1);
INSERT INTO `migrations` VALUES (99,'2019_11_20_124919_alter_on_products_table',1);
INSERT INTO `migrations` VALUES (100,'2019_11_20_131512_rename_supplier_tables_to_vendor_tables',1);
INSERT INTO `migrations` VALUES (101,'2019_11_20_135246_alter_type_column_on_attributes_table',1);
INSERT INTO `migrations` VALUES (102,'2019_11_21_063220_alter_type_value_on_product_attributes_table',1);
INSERT INTO `migrations` VALUES (103,'2019_11_24_093343_add_default_vendor_pricing_id_on_vendor_products_table',1);
INSERT INTO `migrations` VALUES (104,'2019_11_27_100803_create_product_to_categories_table',1);
INSERT INTO `migrations` VALUES (105,'2019_11_27_101109_add_is_leaf_column_to_product_categories_table',1);
INSERT INTO `migrations` VALUES (106,'2019_11_27_103648_create_product_classifications_table',1);
INSERT INTO `migrations` VALUES (107,'2019_11_27_120514_create_products_to_classifications_table',1);
INSERT INTO `migrations` VALUES (108,'2019_11_27_120646_create_categories_to_classifications_table',1);
INSERT INTO `migrations` VALUES (109,'2019_11_27_120804_create_classifications_to_attributes_table',1);
INSERT INTO `migrations` VALUES (110,'2019_11_27_123750_add_display_validation_columns_to_attributes_table',1);
INSERT INTO `migrations` VALUES (111,'2019_11_27_124307_add_sort_order_column_to_attribute_values_table',1);
INSERT INTO `migrations` VALUES (112,'2019_11_27_130215_add_value_column_to_product_attributes_table',1);
INSERT INTO `migrations` VALUES (113,'2019_12_02_074744_drop_unused_columns_from_warehouses_table',1);
INSERT INTO `migrations` VALUES (114,'2019_12_04_130346_create_table_views_table',1);
INSERT INTO `migrations` VALUES (115,'2019_12_05_042612_altering_sales_orders_table',1);
INSERT INTO `migrations` VALUES (116,'2019_12_05_044109_altering_on_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (117,'2019_12_07_071953_rename_nominal_code_column_in_purchase_invoice_lines_table',1);
INSERT INTO `migrations` VALUES (118,'2019_12_07_072830_altering_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (119,'2019_12_07_081450_altering_integrations_columns_to_sales_channels_table',1);
INSERT INTO `migrations` VALUES (120,'2019_12_07_085252_altering_sales_channel_brands_table',1);
INSERT INTO `migrations` VALUES (121,'2019_12_07_090615_drop_suppliers_table',1);
INSERT INTO `migrations` VALUES (122,'2019_12_07_091503_altering_products_table',1);
INSERT INTO `migrations` VALUES (123,'2019_12_07_092408_add_is_default_column_to_vendor_products_table',1);
INSERT INTO `migrations` VALUES (124,'2019_12_07_093128_add_is_default_column_to_product_pricing_table',1);
INSERT INTO `migrations` VALUES (125,'2019_12_07_093726_add_is_default_column_to_vendor_product_pricing_table',1);
INSERT INTO `migrations` VALUES (126,'2019_12_09_111115_add_is_default_column_to_product_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (127,'2019_12_10_090136_drop_is_default_column_from_product_pricing_table',1);
INSERT INTO `migrations` VALUES (128,'2019_12_11_082106_add_is_default_column_to_vendor_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (129,'2019_12_11_082330_drop_is_default_column_from_vendor_product_pricing_table',1);
INSERT INTO `migrations` VALUES (130,'2019_12_14_073818_add_payment_status_column_in_sales_orders_table',1);
INSERT INTO `migrations` VALUES (131,'2019_12_14_075934_drop_surcharge_column_from_sales_orders_table',1);
INSERT INTO `migrations` VALUES (132,'2019_12_16_121627_add_archived_at_column_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (133,'2019_12_16_130255_add_archived_at_column_to_attributes_table',1);
INSERT INTO `migrations` VALUES (134,'2019_12_17_080006_rename_product_classifications_table_to_attribute_groups_table',1);
INSERT INTO `migrations` VALUES (135,'2019_12_17_082158_rename_products_to_classifications_table_to_products_to_attribute_groups_table',1);
INSERT INTO `migrations` VALUES (136,'2019_12_17_084538_rename_classifications_to_attribute_table_to_attribute_groups_to_attributes_table',1);
INSERT INTO `migrations` VALUES (137,'2019_12_17_092736_rename_categories_to_classifications_table_to_categories_to_attribute_groups_table',1);
INSERT INTO `migrations` VALUES (138,'2019_12_17_114045_create_settings_table',1);
INSERT INTO `migrations` VALUES (139,'2019_12_24_044423_add_is_favorite_column_to_table_views_table',1);
INSERT INTO `migrations` VALUES (140,'2019_12_24_120019_create_products_benchmarks_table',1);
INSERT INTO `migrations` VALUES (141,'2020_01_04_094536_add_archived_at_column_to_product_brands_table',1);
INSERT INTO `migrations` VALUES (142,'2020_01_04_113550_add_archived_at_column_to_nominal_codes_table',1);
INSERT INTO `migrations` VALUES (143,'2020_01_04_113815_alter_type_column_in_nominal_codes_table',1);
INSERT INTO `migrations` VALUES (144,'2020_01_05_063548_add_archived_at_column_to_payment_terms_table',1);
INSERT INTO `migrations` VALUES (145,'2020_01_05_080829_add_archived_at_column_to_incoterms_table',1);
INSERT INTO `migrations` VALUES (146,'2020_01_05_094310_add_archived_at_column_to_product_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (147,'2020_01_06_061721_add_archived_at_column_to_product_categories_table',1);
INSERT INTO `migrations` VALUES (148,'2020_01_06_104817_add_total_column_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (149,'2020_01_06_130209_add_path_column_to_product_categories_table',1);
INSERT INTO `migrations` VALUES (150,'2020_01_07_095418_create_currencies_table',1);
INSERT INTO `migrations` VALUES (151,'2020_01_13_035419_add_archived_at_column_to_warehouses_table',1);
INSERT INTO `migrations` VALUES (152,'2020_01_20_050431_rename__vendor_type_column_to_is_supplier_in_vendors_table',1);
INSERT INTO `migrations` VALUES (153,'2020_01_29_234503_add_archived_at_column_to_vendors_table',1);
INSERT INTO `migrations` VALUES (154,'2020_01_30_014557_add_archived_at_column_to_vendor_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (155,'2020_02_04_031849_create_product_images_table',1);
INSERT INTO `migrations` VALUES (156,'2020_02_05_232940_add_case_weight_columns_to_products_table',1);
INSERT INTO `migrations` VALUES (157,'2020_02_17_034213_drop_deleted_at_column_from_products_table',1);
INSERT INTO `migrations` VALUES (158,'2020_02_25_034808_add_unresolvable_column_to_product_images_table',1);
INSERT INTO `migrations` VALUES (159,'2020_03_05_041338_add_level_column_to_product_categories_table',1);
INSERT INTO `migrations` VALUES (160,'2020_03_07_010247_make_company_name_column_nullable_in_sales_channel_brand_table',1);
INSERT INTO `migrations` VALUES (161,'2020_03_08_232741_add_unique_index_on_name_column_in_vendors_table',1);
INSERT INTO `migrations` VALUES (162,'2020_03_08_233916_set_company_name_column_nullable_in_vendors_table',1);
INSERT INTO `migrations` VALUES (163,'2020_03_09_032751_create_csv_templates_table',1);
INSERT INTO `migrations` VALUES (164,'2020_03_20_233526_cascade_on_delete_vendor_product_pricing_table',1);
INSERT INTO `migrations` VALUES (165,'2020_03_27_205245_add_archived_at_column_to_tags_table',1);
INSERT INTO `migrations` VALUES (166,'2020_03_27_234127_add_archived_at_column_to_sales_channel_brands_table',1);
INSERT INTO `migrations` VALUES (167,'2020_03_28_023148_add_statistics_columns_to_csv_templates_table',1);
INSERT INTO `migrations` VALUES (168,'2020_03_29_222139_add_fax_column_to_addresses_table',1);
INSERT INTO `migrations` VALUES (169,'2020_03_29_232747_add_archived_at_column_to_attribute_groups_table',1);
INSERT INTO `migrations` VALUES (170,'2020_04_01_225742_add_mpn_column_to_products_table',1);
INSERT INTO `migrations` VALUES (171,'2020_04_02_013936_create_constants_countries_table',1);
INSERT INTO `migrations` VALUES (172,'2020_04_02_014000_create_constants_currencies_table',1);
INSERT INTO `migrations` VALUES (173,'2020_04_02_014025_create_constants_states_table',1);
INSERT INTO `migrations` VALUES (174,'2020_04_04_033729_create_zipcodes_table',1);
INSERT INTO `migrations` VALUES (175,'2020_04_05_221507_add_sort_order_column_to_attribute_groups_table',1);
INSERT INTO `migrations` VALUES (176,'2020_04_12_202933_drop_name_column_from_currencies_table',1);
INSERT INTO `migrations` VALUES (177,'2020_04_15_023052_add_is_default_column_to_table_views_table',1);
INSERT INTO `migrations` VALUES (178,'2020_04_18_071304_drop_parent_id_column_from_attribute_groups_table',1);
INSERT INTO `migrations` VALUES (179,'2020_04_22_052122_add_archived_at_column_to_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (180,'2020_04_23_025653_alter_table_customers',1);
INSERT INTO `migrations` VALUES (181,'2020_04_23_082802_create_categories_to_attributes_table',1);
INSERT INTO `migrations` VALUES (182,'2020_04_24_223123_add_archived_at_column_to_customers_table',1);
INSERT INTO `migrations` VALUES (183,'2020_04_26_001517_create_products_inventory_table',1);
INSERT INTO `migrations` VALUES (184,'2020_04_27_013921_drop_product_id_index_on_products_inventory_table',1);
INSERT INTO `migrations` VALUES (185,'2020_04_27_015127_alter_indexes_on_products_benchmarks_table',1);
INSERT INTO `migrations` VALUES (186,'2020_04_27_025003_create_sales_orders_deleted_table',1);
INSERT INTO `migrations` VALUES (187,'2020_04_28_023439_add_is_product_column_to_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (188,'2020_04_28_215322_add_image_url_column_to_sales_channel_types_table',1);
INSERT INTO `migrations` VALUES (189,'2020_04_29_033541_add_sales_channel_brand_id_column_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (190,'2020_05_03_233721_add_index_on_name_column_in_products_table',1);
INSERT INTO `migrations` VALUES (191,'2020_05_04_004959_add_index_on_product_id_column_in_product_images_table',1);
INSERT INTO `migrations` VALUES (192,'2020_05_04_022214_add_index_on_product_id_column_in_product_pricing_table',1);
INSERT INTO `migrations` VALUES (193,'2020_05_04_224003_add_fulltext_index_to_products_table',1);
INSERT INTO `migrations` VALUES (194,'2020_05_05_042446_create_nominal_codes_deleted_table',1);
INSERT INTO `migrations` VALUES (195,'2020_05_05_051201_create_product_brands_deleted_table',1);
INSERT INTO `migrations` VALUES (196,'2020_05_05_214337_renaming_sales_channel_brands_to_stores_table',1);
INSERT INTO `migrations` VALUES (197,'2020_05_06_105925_create_product_categories_deleted_table',1);
INSERT INTO `migrations` VALUES (198,'2020_05_10_002631_add_is_default_column_to_warehouse_locations_table',1);
INSERT INTO `migrations` VALUES (199,'2020_05_10_125714_alter_customers_table',1);
INSERT INTO `migrations` VALUES (200,'2020_05_10_130314_add_type_column_to_addresses_table',1);
INSERT INTO `migrations` VALUES (201,'2020_05_11_064542_add_tracking_link_column_to_shipping_carriers_table',1);
INSERT INTO `migrations` VALUES (202,'2020_05_11_065351_alter_shipping_methods_table',1);
INSERT INTO `migrations` VALUES (203,'2020_05_12_013838_create_attributes_deleted_table',1);
INSERT INTO `migrations` VALUES (204,'2020_05_12_230148_move_constants_tables_to_mongodb',1);
INSERT INTO `migrations` VALUES (205,'2020_05_13_230822_add_root_id_column_for_product_categories_table',1);
INSERT INTO `migrations` VALUES (206,'2020_05_14_032735_create_product_pricing_tiers_deleted_table',1);
INSERT INTO `migrations` VALUES (207,'2020_05_16_005617_create_warehouses_deleted_table',1);
INSERT INTO `migrations` VALUES (208,'2020_05_16_022626_create_attribute_groups_deleted_table',1);
INSERT INTO `migrations` VALUES (209,'2020_05_16_030010_set_nullable_columns_to_addresses_table',1);
INSERT INTO `migrations` VALUES (210,'2020_05_17_235623_add_attribute_group_id_column_to_attributes_table',1);
INSERT INTO `migrations` VALUES (211,'2020_05_19_042147_create_incoterms_deleted_table',1);
INSERT INTO `migrations` VALUES (212,'2020_05_19_045614_create_vendors_deleted_table',1);
INSERT INTO `migrations` VALUES (213,'2020_05_20_231821_create_vendor_pricing_tiers_deleted_table',1);
INSERT INTO `migrations` VALUES (214,'2020_05_21_002057_create_customers_deleted_table',1);
INSERT INTO `migrations` VALUES (215,'2020_05_21_012110_create_stores_deleted_table',1);
INSERT INTO `migrations` VALUES (216,'2020_05_30_011443_add_default_settings_columns_to_customers_table',1);
INSERT INTO `migrations` VALUES (217,'2020_05_30_062502_create_tags_deleted_table',1);
INSERT INTO `migrations` VALUES (218,'2020_06_01_034914_alter_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (219,'2020_06_01_043221_alter_purchase_order_lines_table',1);
INSERT INTO `migrations` VALUES (220,'2020_06_01_044110_create_purchase_order_shipments_table',1);
INSERT INTO `migrations` VALUES (221,'2020_06_01_044653_create_purchase_order_shipment_lines_table',1);
INSERT INTO `migrations` VALUES (222,'2020_06_01_045502_alter_purchase_invoice_lines_table',1);
INSERT INTO `migrations` VALUES (223,'2020_06_02_011140_add_archived_at_column_to_shipping_methods_table',1);
INSERT INTO `migrations` VALUES (224,'2020_06_02_051504_create_shipping_methods_deleted_table',1);
INSERT INTO `migrations` VALUES (225,'2020_06_05_124712_add_address_columns_to_customers_table',1);
INSERT INTO `migrations` VALUES (226,'2020_06_06_024200_add_type_column_to_shipping_methods_table',1);
INSERT INTO `migrations` VALUES (227,'2020_06_09_201314_change_quantity_type_in_fifo_layer_table',1);
INSERT INTO `migrations` VALUES (228,'2020_06_12_080625_add_vendor_id_field_to_vendor_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (229,'2020_06_15_014634_alter_warehouses_table',1);
INSERT INTO `migrations` VALUES (230,'2020_06_15_074502_add_vendor_id_to_warehouses_table',1);
INSERT INTO `migrations` VALUES (231,'2020_06_16_040338_delete_vendor_id_field_from_vendor_pricing_tiers_table',1);
INSERT INTO `migrations` VALUES (232,'2020_06_16_041239_create_vendor_to_pricing_tier_table',1);
INSERT INTO `migrations` VALUES (233,'2020_06_16_063712_alter_sales_orders_table',1);
INSERT INTO `migrations` VALUES (234,'2020_06_16_070318_alter_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (235,'2020_06_17_061913_create_backorder_layers_table',1);
INSERT INTO `migrations` VALUES (236,'2020_06_17_063409_alter_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (237,'2020_06_17_065553_alter_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (238,'2020_06_18_050135_add_address_id_to_vendors_table',1);
INSERT INTO `migrations` VALUES (239,'2020_06_18_060152_add_address_id_to_warehouses_table',1);
INSERT INTO `migrations` VALUES (240,'2020_06_18_062749_make_address_id_field_nullable_on_vendors_table',1);
INSERT INTO `migrations` VALUES (241,'2020_06_23_090508_delete_phone_field_from_vendors_table',1);
INSERT INTO `migrations` VALUES (242,'2020_06_24_191452_add_is_default_field_to_warehouses_table',1);
INSERT INTO `migrations` VALUES (243,'2020_06_25_021927_alter_inventory_adjustments_table',1);
INSERT INTO `migrations` VALUES (244,'2020_06_25_055619_add_po_format_and_currency_code_fields_to_vendors_table',1);
INSERT INTO `migrations` VALUES (245,'2020_06_25_205854_remove_currency_code_field_from_vendors_table',1);
INSERT INTO `migrations` VALUES (246,'2020_06_25_205957_add_default_pricing_tier_id_to_vendors_table',1);
INSERT INTO `migrations` VALUES (247,'2020_06_26_233316_rename_customer_reference_column_to_sales_order_number_in_sales_orders_table',1);
INSERT INTO `migrations` VALUES (248,'2020_07_01_095127_remove_is_default_field_from_warehouses_table',1);
INSERT INTO `migrations` VALUES (249,'2020_07_01_095313_add_default_warehouse_id_field_to_vendors_table',1);
INSERT INTO `migrations` VALUES (250,'2020_07_01_101132_remove_address_id_field_from_warehouses_table',1);
INSERT INTO `migrations` VALUES (251,'2020_07_02_051759_add_address_id_field_to_vendors_table',1);
INSERT INTO `migrations` VALUES (252,'2020_07_02_090413_add_address_id_field_to_warehouses_table',1);
INSERT INTO `migrations` VALUES (253,'2020_07_02_090552_drop_extra_fields_from_warehouses_table',1);
INSERT INTO `migrations` VALUES (254,'2020_07_02_090738_add_extra_fields_to_warehouses_table',1);
INSERT INTO `migrations` VALUES (255,'2020_07_07_074050_add_archived_at_field_to_warehouse_transfers_table',1);
INSERT INTO `migrations` VALUES (256,'2020_07_07_081611_create_warehouse_transfers_deleted_table',1);
INSERT INTO `migrations` VALUES (257,'2020_07_08_010018_create_purchase_order_shipment_receipts_table',1);
INSERT INTO `migrations` VALUES (258,'2020_07_08_010332_create_purchase_order_shipment_receipt_lines_table',1);
INSERT INTO `migrations` VALUES (259,'2020_07_08_152746_refactor_warehouse_transfers_table',1);
INSERT INTO `migrations` VALUES (260,'2020_07_08_160040_create_warehouse_transfer_lines_table',1);
INSERT INTO `migrations` VALUES (261,'2020_07_08_164054_create_warehouse_transfer_shipments_table',1);
INSERT INTO `migrations` VALUES (262,'2020_07_09_064204_alter_type_options_for_warehouses_table',1);
INSERT INTO `migrations` VALUES (263,'2020_07_09_135331_remove_product_id_and_quantity_fields_from_warehouse_transfers_table',1);
INSERT INTO `migrations` VALUES (264,'2020_07_10_054626_create_warehouse_transfer_shipment_lines_table',1);
INSERT INTO `migrations` VALUES (265,'2020_07_11_104130_create_warehouse_transfer_shipment_receipts_table',1);
INSERT INTO `migrations` VALUES (266,'2020_07_11_104150_create_warehouse_transfer_shipment_receipt_lines_table',1);
INSERT INTO `migrations` VALUES (267,'2020_07_14_050926_create_sales_credits_table',1);
INSERT INTO `migrations` VALUES (268,'2020_07_14_051038_create_sales_credit_lines_table',1);
INSERT INTO `migrations` VALUES (269,'2020_07_14_051842_create_order_links_table',1);
INSERT INTO `migrations` VALUES (270,'2020_07_15_024701_create_sales_credit_returns_table',1);
INSERT INTO `migrations` VALUES (271,'2020_07_15_025044_create_sales_credit_return_lines_table',1);
INSERT INTO `migrations` VALUES (272,'2020_07_15_033525_create_return_reasons_table',1);
INSERT INTO `migrations` VALUES (273,'2020_07_15_062235_delete_warehouse_transfer_receipts_table',1);
INSERT INTO `migrations` VALUES (274,'2020_07_15_071011_create_payments_table',1);
INSERT INTO `migrations` VALUES (275,'2020_07_15_144420_make_layer_fields_nullable_in_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (276,'2020_07_15_231341_create_payment_types_table',1);
INSERT INTO `migrations` VALUES (277,'2020_07_17_072145_create_vendor_inventory_table',1);
INSERT INTO `migrations` VALUES (278,'2020_07_18_230919_add_archived_at_column_to_payment_types_table',1);
INSERT INTO `migrations` VALUES (279,'2020_07_18_233559_create_payment_types_deleted_table',1);
INSERT INTO `migrations` VALUES (280,'2020_07_19_010010_add_archived_at_column_to_return_reasons_table',1);
INSERT INTO `migrations` VALUES (281,'2020_07_19_010011_create_return_reasons_deleted_table',1);
INSERT INTO `migrations` VALUES (282,'2020_07_19_043057_add_enums_for_purchase_order_tables',1);
INSERT INTO `migrations` VALUES (283,'2020_07_20_054512_add_archived_at_field_to_inventory_adjustments_table',1);
INSERT INTO `migrations` VALUES (284,'2020_07_20_071839_create_inventory_adjustment_deleted_table',1);
INSERT INTO `migrations` VALUES (285,'2020_07_22_054119_add_archived_at_column_to_fifo_layers_table',1);
INSERT INTO `migrations` VALUES (286,'2020_07_22_060207_move_archived_at_position_in_fifo_layers_table',1);
INSERT INTO `migrations` VALUES (287,'2020_07_22_061728_add_enums_for_submission_format_column_in_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (288,'2020_07_22_065117_add_archived_at_column_to_vendor_inventory_table',1);
INSERT INTO `migrations` VALUES (289,'2020_07_22_230820_remove_seller_reference_table_from_return_reasons_table',1);
INSERT INTO `migrations` VALUES (290,'2020_07_23_044225_make_source_field_nullable_in_vendor_inventory_table',1);
INSERT INTO `migrations` VALUES (291,'2020_07_25_055316_create_purchase_orders_deleted_table',1);
INSERT INTO `migrations` VALUES (292,'2020_07_26_082942_add_default_shipping_method_id_to_vendors_table',1);
INSERT INTO `migrations` VALUES (293,'2020_07_26_084035_reorganize_vendors_table',1);
INSERT INTO `migrations` VALUES (294,'2020_07_28_024812_rename_customer_reference_column_to_sales_credit_number_in_sales_credits_table',1);
INSERT INTO `migrations` VALUES (295,'2020_07_28_050034_add_archived_at_column_to_backorder_layers_table',1);
INSERT INTO `migrations` VALUES (296,'2020_07_28_174715_add_has_backorder_field_to_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (297,'2020_07_29_035044_refactor_vendors_table_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (298,'2020_07_30_060425_modify_inventory_movement_types_options',1);
INSERT INTO `migrations` VALUES (299,'2020_07_30_062606_change_type_field_in_products_table',1);
INSERT INTO `migrations` VALUES (300,'2020_07_30_071520_change_purchase_order_statuses',1);
INSERT INTO `migrations` VALUES (301,'2020_07_30_074828_alter_sales_credit_return_lines_action_options',1);
INSERT INTO `migrations` VALUES (302,'2020_07_30_075259_alter_status_field_in_sales_credit_returns_table',1);
INSERT INTO `migrations` VALUES (303,'2020_07_30_080734_alter_statuses_of_sales_credits_table',1);
INSERT INTO `migrations` VALUES (304,'2020_08_01_073456_alter_sales_order_fulfillment_statuses',1);
INSERT INTO `migrations` VALUES (305,'2020_08_01_074143_alter_warehouse_transfer_statuses',1);
INSERT INTO `migrations` VALUES (306,'2020_08_01_093209_make_link_nullable_in_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (307,'2020_08_01_101539_fix_inventory_movement_enums',1);
INSERT INTO `migrations` VALUES (308,'2020_08_04_042749_add_line_reference_to_purchase_order_lines_table',1);
INSERT INTO `migrations` VALUES (309,'2020_08_04_043647_add_line_reference_field_to_purchase_order_shipment_lines_table',1);
INSERT INTO `migrations` VALUES (310,'2020_08_05_024608_remove_line_reference_from_purchase_order_shipment_lines_table',1);
INSERT INTO `migrations` VALUES (311,'2020_08_05_060144_fix_product_type_enum_types_in_products_table',1);
INSERT INTO `migrations` VALUES (312,'2020_08_06_034015_create_notes_table',1);
INSERT INTO `migrations` VALUES (313,'2020_08_06_155802_alter_warehouse_type_values_in_warehouses_table',1);
INSERT INTO `migrations` VALUES (314,'2020_08_14_223801_create_sales_order_line_fifo_layers_table',1);
INSERT INTO `migrations` VALUES (315,'2020_08_16_032033_create_reporting_queue_table',1);
INSERT INTO `migrations` VALUES (316,'2020_08_16_230527_create_reporting_orders_table',1);
INSERT INTO `migrations` VALUES (317,'2020_08_16_230554_create_reporting_products_table',1);
INSERT INTO `migrations` VALUES (318,'2020_08_22_023142_add_is_dropship_column_to_reporting_orders_table',1);
INSERT INTO `migrations` VALUES (319,'2020_08_25_023446_drop_payment_date_from_sales_orders_table',1);
INSERT INTO `migrations` VALUES (320,'2020_08_25_023913_alter_sales_order_payment_statuses_in_sales_orders_table',1);
INSERT INTO `migrations` VALUES (321,'2020_08_26_031113_create_integrations_table',1);
INSERT INTO `migrations` VALUES (322,'2020_08_26_031733_create_integration_instances_table',1);
INSERT INTO `migrations` VALUES (323,'2020_08_26_032246_refactor_sales_channels_table',1);
INSERT INTO `migrations` VALUES (324,'2020_08_26_034603_update_product_listings_table',1);
INSERT INTO `migrations` VALUES (325,'2020_08_26_040549_drop_sales_channel_quantity_settings_table',1);
INSERT INTO `migrations` VALUES (326,'2020_08_27_062846_add_total_cost_field_to_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (327,'2020_08_27_072556_add_amazon_fba_type_to_warehouses_types',1);
INSERT INTO `migrations` VALUES (328,'2020_08_28_054301_make_transfer_date_nullable_in_warehouse_transfers_table',1);
INSERT INTO `migrations` VALUES (329,'2020_08_30_025729_drop_sales_channel_types_table',1);
INSERT INTO `migrations` VALUES (330,'2020_09_03_040731_restore_nullability_of_layer_in_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (331,'2020_09_04_013933_make_transfer_date_non_nullable_in_warehouse_transfers_table',1);
INSERT INTO `migrations` VALUES (332,'2020_09_04_220511_rename_vendor_supplier_column_in_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (333,'2020_09_15_015348_update_sales_order_line_id_column_in_sales_credit_lines_table',1);
INSERT INTO `migrations` VALUES (334,'2020_09_15_030430_make_shipping_method_id_nullable_in_warehouse_transfer_shipments_table',1);
INSERT INTO `migrations` VALUES (335,'2020_09_16_060843_add_document_id_column_in_product_listings_table',1);
INSERT INTO `migrations` VALUES (336,'2020_09_21_034134_create_integration_instance_communications_table',1);
INSERT INTO `migrations` VALUES (337,'2020_09_21_034134_create_integration_instance_errors_table',1);
INSERT INTO `migrations` VALUES (338,'2020_09_25_222019_update_sales_order_line_fifo_layers_table',1);
INSERT INTO `migrations` VALUES (339,'2020_09_25_230704_drop_sales_order_line_id_column_from_backorder_layers_table',1);
INSERT INTO `migrations` VALUES (340,'2020_09_26_033253_add_sales_channel_id_for_reporting_orders_table',1);
INSERT INTO `migrations` VALUES (341,'2020_09_28_143708_create_sales_credit_allocations_table',1);
INSERT INTO `migrations` VALUES (342,'2020_09_29_051347_add_user_id_column_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (343,'2020_09_30_225130_create_shipstation_shipping_services_table',1);
INSERT INTO `migrations` VALUES (344,'2020_10_02_000901_make_to_warehouse_id_nullable_in_sales_credits_table',1);
INSERT INTO `migrations` VALUES (345,'2020_10_05_034951_create_integration_shipping_methods_table',1);
INSERT INTO `migrations` VALUES (346,'2020_10_06_022326_add_fulfillment_type_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (347,'2020_10_06_035322_create_shipstation_create_order_result_table',1);
INSERT INTO `migrations` VALUES (348,'2020_10_09_235337_create_amazon_shipping_services_table',1);
INSERT INTO `migrations` VALUES (349,'2020_10_12_001133_add_achived_at_to_store_email_templates_table',1);
INSERT INTO `migrations` VALUES (350,'2020_10_12_064440_add_user_id_to_purchase_order_shipment_receipts_table',1);
INSERT INTO `migrations` VALUES (351,'2020_10_13_030336_refactoring_status_type_sales_orders_table',1);
INSERT INTO `migrations` VALUES (352,'2020_10_15_010335_change_total_revenue_column_in_sales_orders_table',1);
INSERT INTO `migrations` VALUES (353,'2020_10_15_034507_add_is_fba_column_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (354,'2020_10_15_035349_add_product_listing_id_column_to_sales_order_lines',1);
INSERT INTO `migrations` VALUES (355,'2020_10_21_045226_create_inventory_forecasts_cache_table',1);
INSERT INTO `migrations` VALUES (356,'2020_10_21_081050_make_out_of_stock_date_nullable_in_inventory_forecast_cache_table',1);
INSERT INTO `migrations` VALUES (357,'2020_10_28_015722_add_archive_at_to_product_listings_table',1);
INSERT INTO `migrations` VALUES (358,'2020_10_30_073820_create_inventory_forecast_summary_table',1);
INSERT INTO `migrations` VALUES (359,'2020_11_07_220211_add_enabled_attach_pdf_columns_to_store_email_templates_table',1);
INSERT INTO `migrations` VALUES (360,'2020_11_08_054107_add_full_name_column_to_shipping_methods_table',1);
INSERT INTO `migrations` VALUES (361,'2020_11_13_050900_add_purchase_order_line_id_to_forecast_cache_table',1);
INSERT INTO `migrations` VALUES (362,'2020_11_18_235800_add_canceled_at_column_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (363,'2020_11_23_143419_create_report_templates_table',1);
INSERT INTO `migrations` VALUES (364,'2020_11_25_080450_add_attribute_group_id_field_to_product_attributes_table',1);
INSERT INTO `migrations` VALUES (365,'2020_11_25_080852_drop_products_to_attribute_groups_table',1);
INSERT INTO `migrations` VALUES (366,'2020_11_25_131101_create_task_status_table',1);
INSERT INTO `migrations` VALUES (367,'2020_11_26_024908_add_fulfillment_latency_column_to_product_listings_table',1);
INSERT INTO `migrations` VALUES (368,'2020_11_26_063334_create_stock_takes_table',1);
INSERT INTO `migrations` VALUES (369,'2020_11_26_063913_create_stock_take_items_table',1);
INSERT INTO `migrations` VALUES (370,'2020_11_29_043807_change_title_column_type_in_product_listings_table',1);
INSERT INTO `migrations` VALUES (371,'2020_11_29_231802_add_store_id_column_to_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (372,'2020_11_30_003616_add_store_id_column_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (373,'2020_12_07_052216_add_product_listing_id_column_to_reporting_orders_table',1);
INSERT INTO `migrations` VALUES (374,'2020_12_08_235705_add_integation_instance_id_column_to_warehouses_table',1);
INSERT INTO `migrations` VALUES (375,'2020_12_09_235010_change_sales_channel_internal_id_column_to_unique_product_listings_table',1);
INSERT INTO `migrations` VALUES (376,'2020_12_10_094031_create_inventory_assemblies',1);
INSERT INTO `migrations` VALUES (377,'2020_12_13_081828_add_unit_cost_to_inventory_assembly_lines',1);
INSERT INTO `migrations` VALUES (378,'2020_12_13_185815_cascade_delete_bundle_components_if_product_is_deleted',1);
INSERT INTO `migrations` VALUES (379,'2020_12_16_072624_create_generated_reports_table',1);
INSERT INTO `migrations` VALUES (380,'2020_12_16_074732_create_generated_report_items_table',1);
INSERT INTO `migrations` VALUES (381,'2020_12_17_060233_add_store_id_to_reporting_orders_table',1);
INSERT INTO `migrations` VALUES (382,'2020_12_17_062145_add_type_fba_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (383,'2020_12_19_002545_add_fulfilled_awaiting_info_status_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (384,'2020_12_19_003438_add_metadata_column_to_sales_order_fulfillment_lines_table',1);
INSERT INTO `migrations` VALUES (385,'2020_12_20_225604_add_metadata_column_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (386,'2020_12_31_074954_create_fba_product_movements_table',1);
INSERT INTO `migrations` VALUES (387,'2021_01_04_041650_add_warehouse_id_field_to_fifo_layers_table',1);
INSERT INTO `migrations` VALUES (388,'2021_01_05_015903_add_sale_as_type_in_fba_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (389,'2021_01_08_232838_add_canceled_to_status_in_sales_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (390,'2021_01_09_010604_add_started_processing_at_field_to_generated_reports_table',1);
INSERT INTO `migrations` VALUES (391,'2021_01_09_011314_add_status_field_to_generated_reports_table',1);
INSERT INTO `migrations` VALUES (392,'2021_01_09_020800_add_archive_at_field_to_generated_reports_table',1);
INSERT INTO `migrations` VALUES (393,'2021_01_10_223029_refactoring_001_fba_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (394,'2021_01_13_030822_create_inbound_shipment_relations_table',1);
INSERT INTO `migrations` VALUES (395,'2021_01_17_220221_add_shipment_id_to_warehouse_transfers_table',1);
INSERT INTO `migrations` VALUES (396,'2021_01_21_060653_change_virtual_type_to_matrix_in_products_table',1);
INSERT INTO `migrations` VALUES (397,'2021_01_22_092526_add_foreign_key_relation_for_sales_order_lines',1);
INSERT INTO `migrations` VALUES (398,'2021_01_23_061912_remove_type_fulfillment_from_inventory_movement',1);
INSERT INTO `migrations` VALUES (399,'2021_02_04_045951_add_shared_children_attributes_to_products_table',1);
INSERT INTO `migrations` VALUES (400,'2021_02_19_130201_add_indexes_to_product_to_categories_table',1);
INSERT INTO `migrations` VALUES (401,'2021_02_22_144612_change_generated_report_profit_metric',1);
INSERT INTO `migrations` VALUES (402,'2021_03_02_223526_add_fulfillment_channel_column_to_sales_orders',1);
INSERT INTO `migrations` VALUES (403,'2021_03_03_004003_create_f_b_a_report_logs_table',1);
INSERT INTO `migrations` VALUES (404,'2021_03_04_154421_add_index_to_name_field_in_integrations_table',1);
INSERT INTO `migrations` VALUES (405,'2021_03_07_145830_add_unique_index_to_customer_email_field',1);
INSERT INTO `migrations` VALUES (406,'2021_03_15_164051_add_sales_order_fulfillment_id_field_to_purchase_order_shipments_table',1);
INSERT INTO `migrations` VALUES (407,'2021_03_16_103727_add_last_sync_field_to_integrations_table',1);
INSERT INTO `migrations` VALUES (408,'2021_03_17_002130_create_fba_real_time_inventories_table',1);
INSERT INTO `migrations` VALUES (409,'2021_03_18_010000_rename_fba_reports_log_table_to_amazon_reports_log',1);
INSERT INTO `migrations` VALUES (410,'2021_03_18_015534_add__report_id_column_to_amazon_reports_log_table',1);
INSERT INTO `migrations` VALUES (411,'2021_03_19_043627_add__records_count_column_to_amazon_reports_log_table',1);
INSERT INTO `migrations` VALUES (412,'2021_03_20_125505_add_bundle_id_column_to_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (413,'2021_03_22_041854_add__request_id_to_amazon_reports_log_table',1);
INSERT INTO `migrations` VALUES (414,'2021_03_23_004402_add_integration_instance_id_to_fba_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (415,'2021_03_29_052552_remove__report_id_from_amazon_reports_log_table',1);
INSERT INTO `migrations` VALUES (416,'2021_04_01_005029_make_document_id_nullable_in_product_listings_table',1);
INSERT INTO `migrations` VALUES (417,'2021_04_14_025811_make_price_nullable_in_product_listings_table',1);
INSERT INTO `migrations` VALUES (418,'2021_04_14_162019_make_shipping_method_id_nullable_in_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (419,'2021_04_26_174719_add_csv_format_to_purchase_order_submission_formats_in_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (420,'2021_05_06_032819_create_data_feed_templates_table',1);
INSERT INTO `migrations` VALUES (421,'2021_05_06_032821_create_data_feeds_table',1);
INSERT INTO `migrations` VALUES (422,'2021_05_12_073229_add_link_id_and_link_type_to_adjustments_table',1);
INSERT INTO `migrations` VALUES (423,'2021_05_17_103036_add_po_settings_field_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (424,'2021_05_24_062814_add_po_processing_method_field_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (425,'2021_05_24_063253_rename_po_settings_field_to_po_batch_schedule_in_suppliers_table',1);
INSERT INTO `migrations` VALUES (426,'2021_05_24_082353_create_datatable_export_batches_table',1);
INSERT INTO `migrations` VALUES (427,'2021_05_24_135104_add_error_field_to_datatable_export_batches_table',1);
INSERT INTO `migrations` VALUES (428,'2021_05_25_032051_add_queued_to_purchase_order_submission_statuses',1);
INSERT INTO `migrations` VALUES (429,'2021_06_03_055625_add_currency_rate_and_currency_from_fields_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (430,'2021_06_03_055951_add_currency_rate_and_currency_from_fields_to_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (431,'2021_06_04_055135_add_auto_fulfill_dropship_field_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (432,'2021_06_04_060151_add_auto_submit_purchase_orders_field_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (433,'2021_06_04_074612_make_currency_from_use_currency_code_in_sales_orders_table',1);
INSERT INTO `migrations` VALUES (434,'2021_06_05_225823_remove_is_active_from_fba_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (435,'2021_06_08_063144_add_tax_value_to_sales_order_lines_table',1);
INSERT INTO `migrations` VALUES (436,'2021_06_15_062409_make_currency_from_use_currency_code_in_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (437,'2021_06_16_134712_create_backorder_queues_table',1);
INSERT INTO `migrations` VALUES (438,'2021_06_17_054901_create_backorder_queue_releases_table',1);
INSERT INTO `migrations` VALUES (439,'2021_06_17_134603_create_backorder_queue_coverages_table',1);
INSERT INTO `migrations` VALUES (440,'2021_06_20_152748_add_archived_at_field_to_backorder_queues_table',1);
INSERT INTO `migrations` VALUES (441,'2021_06_26_043317_add_reference_to_fba_inventory_movements_table',1);
INSERT INTO `migrations` VALUES (442,'2021_06_30_125300_add_auto_generate_backorder_po_field_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (443,'2021_07_01_050033_add_backorder_po_schedule_to_suppliers_table',1);
INSERT INTO `migrations` VALUES (444,'2021_07_13_042651_add_default_value_for_type_in_shipping_methods_table',1);
INSERT INTO `migrations` VALUES (445,'2021_07_19_235642_alter_table_sales_orders_add_discount_column',1);
INSERT INTO `migrations` VALUES (446,'2021_07_23_071314_add_reserved_at_field_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (447,'2021_07_23_072900_add_reserved_to_order_status_in_sales_orders_table',1);
INSERT INTO `migrations` VALUES (448,'2021_07_28_060744_add_released_quantity_to_backorder_queue_coverages_table',1);
INSERT INTO `migrations` VALUES (449,'2021_08_02_030145_add_reporting_date_column_to_reporting_orders_table',1);
INSERT INTO `migrations` VALUES (450,'2021_08_05_031317_alter_table_sales_orders_rename_discount_column',1);
INSERT INTO `migrations` VALUES (451,'2021_08_11_221427_add_starshipit_to_fulfillment_type_in_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (452,'2021_08_12_231013_alter_table_sales_orders_add_discount_lines',1);
INSERT INTO `migrations` VALUES (453,'2021_08_12_232518_alter_table_sales_order_add_tax_lines',1);
INSERT INTO `migrations` VALUES (454,'2021_08_19_025633_add_requested_shipping_method_to_sales_orders_table',1);
INSERT INTO `migrations` VALUES (455,'2021_08_19_030200_add_requested_shipping_method_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (456,'2021_08_24_030812_add_fulfilled_shipping_method_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (457,'2021_08_25_105921_add_index_to_taggables_taggable_id',1);
INSERT INTO `migrations` VALUES (458,'2021_08_31_023817_alter_shipping_method_mappings_sku_to_shipping_provider_method_table',1);
INSERT INTO `migrations` VALUES (459,'2021_09_02_031518_add_shipping_provider_carrier_to_shipping_method_mappings_sku_to_shipping_provider_method_table',1);
INSERT INTO `migrations` VALUES (460,'2021_09_02_064157_add_fulfilled_shipping_method_to_purchase_order_shipments_table',1);
INSERT INTO `migrations` VALUES (461,'2021_09_05_222333_add_requested_shipping_method_id_to_sales_order_fulfillments_table',1);
INSERT INTO `migrations` VALUES (462,'2021_09_06_224708_drop_shipping_method_mappings_sku_to_shipping_provider_carrier_table',1);
INSERT INTO `migrations` VALUES (463,'2021_09_07_142205_add_unique_pair_index_to_sales_orders_for_sales_order_number_and_sales_channel_id',1);
INSERT INTO `migrations` VALUES (464,'2021_09_13_082345_add_index_to_product_id_in_supplier_inventory_table',1);
INSERT INTO `migrations` VALUES (465,'2021_09_13_231018_alter_table_sales_orders_add_tax_total_column',1);
INSERT INTO `migrations` VALUES (466,'2021_09_15_025800_add_requested_shipping_method_to_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (467,'2021_09_17_014223_alter_table_sales_order_lines_add_proration',1);
INSERT INTO `migrations` VALUES (468,'2021_09_17_072748_alter_table_reporting_orders_add_tax_revenue_column',1);
INSERT INTO `migrations` VALUES (469,'2021_09_18_213050_rename_shipping_method_id_in_purchase_orders_table',1);
INSERT INTO `migrations` VALUES (470,'2021_09_18_223400_rename_shipping_method_id_in_purchase_order_shipments_table',1);
INSERT INTO `migrations` VALUES (471,'2021_09_27_033653_add_daily_average_consumption_column_to_products_inventory_table',1);
INSERT INTO `migrations` VALUES (472,'2021_09_28_071734_add_awaiting_tracking_to_fulfillment_status_enum_in_sales_orders_table',1);
INSERT INTO `migrations` VALUES (473,'2021_09_29_064826_alter_table_sales_credits_tax_discount_changes',1);
INSERT INTO `migrations` VALUES (474,'2021_09_29_230837_add_daily_average_consumption_column_to_products_table',1);
INSERT INTO `migrations` VALUES (475,'2021_10_01_063430_alter_table_purchase_orders_add_tracking_number_column',1);
INSERT INTO `migrations` VALUES (476,'2021_10_04_033225_alter_table_purchase_orders_add_other_date',1);
INSERT INTO `migrations` VALUES (477,'2021_10_04_070249_add_custom_columns_to_stores_table',1);
INSERT INTO `migrations` VALUES (478,'2021_10_07_233510_alter_table_sales_orders_add_is_tax_included',1);
INSERT INTO `migrations` VALUES (479,'2021_10_10_213631_add_index_to_sales_order_line_id_in_backorder_queues_table',1);
INSERT INTO `migrations` VALUES (480,'2021_10_10_222025_add_index_to_backorder_queue_id_in_backorder_queue_releases_table',1);
INSERT INTO `migrations` VALUES (481,'2021_10_10_225138_add_index_to_backorder_queue_id_in_backorder_queue_coverages_table',1);
INSERT INTO `migrations` VALUES (482,'2021_10_12_070052_alter_table_sales_orders_add_packing_slip_printed_at_column',1);
INSERT INTO `migrations` VALUES (483,'2021_10_13_174335_add_foreign_index_to_purchase_order_line_id_field_in_backorder_queue_coverages_table',1);
INSERT INTO `migrations` VALUES (484,'2021_10_14_042352_alter_table_purchase_orders_add_purchase_order_number_unique',1);
INSERT INTO `migrations` VALUES (485,'2021_10_19_230921_alter_table_products_add_unit_cost',1);
INSERT INTO `migrations` VALUES (486,'2021_10_21_104147_add_subtotal_cache_to_sales_order_lines_table',2);
INSERT INTO `migrations` VALUES (487,'2021_10_22_111942_add_canceled_quantity_to_sales_order_lines_table',2);
INSERT INTO `migrations` VALUES (488,'2021_10_27_013434_add_sales_channel_qty_column_to_product_listings_table',2);
INSERT INTO `migrations` VALUES (489,'2021_10_29_133328_add_no_restock_option_to_sales_credit_return_lines',2);
INSERT INTO `migrations` VALUES (490,'2021_11_01_110906_add_no_audit_trail_to_sales_order_lines',3);
INSERT INTO `migrations` VALUES (491,'2021_11_03_010127_add_submitted_to_sales_channel_at_to_sales_order_fulfillments',4);
INSERT INTO `migrations` VALUES (492,'2021_11_05_042650_add_document_id_index_to_product_listings',5);
INSERT INTO `migrations` VALUES (493,'2021_11_18_072939_add_reference_to_inventory_movements_table',6);
INSERT INTO `migrations` VALUES (494,'2021_11_21_123718_add_available_for_templates_column_to_attributes_table',7);
INSERT INTO `migrations` VALUES (495,'2021_11_22_080126_seeder_add_purchase_order_cc_outgoing_to_settings_table',8);
INSERT INTO `migrations` VALUES (496,'2021_11_24_054346_add_sales_credit_default_warehouse_seed',9);
INSERT INTO `migrations` VALUES (497,'2021_11_25_000500_add_foreign_index_to_sales_order_lines_on_backorder_queues',10);
INSERT INTO `migrations` VALUES (498,'2021_11_25_110916_alter_table_purchase_orders_add_total_quantity_column',11);
INSERT INTO `migrations` VALUES (499,'2021_11_25_113025_alter_table_users_add_is_admin_column',11);
INSERT INTO `migrations` VALUES (500,'2021_11_26_062119_remove_customer_email_unique_index',12);
INSERT INTO `migrations` VALUES (501,'2021_11_27_223626_add_sequence_to_purchase_orders',13);
INSERT INTO `migrations` VALUES (502,'2021_11_27_194103_create_company_profiles_table',14);
INSERT INTO `migrations` VALUES (503,'2021_11_25_072420_add_auto_submit_backorder_purchase_orders_column_to_suppliers_table',15);
INSERT INTO `migrations` VALUES (504,'2021_12_01_183213_add_discount_total_default_value_for_sales_orders',15);
INSERT INTO `migrations` VALUES (505,'2021_12_01_193242_add_default_values_to_products',15);
INSERT INTO `migrations` VALUES (506,'2021_12_01_194828_add_default_values_to_sales_order_lines',15);
INSERT INTO `migrations` VALUES (507,'2021_12_01_202220_add_no_audit_trail_default_value_to_sales_order_lines',15);
INSERT INTO `migrations` VALUES (508,'2021_12_02_003059_resize_province_code_in_addresses',15);
INSERT INTO `migrations` VALUES (509,'2021_12_02_222001_add_default_values_to_many_tables',15);
INSERT INTO `migrations` VALUES (510,'2021_12_03_001209_add_nullable_to_purchase_order_line_id_in_inventory_forecasts_cache',15);
INSERT INTO `migrations` VALUES (511,'2021_11_23_075927_add_fulfillment_sequence_column_to_sales_order_fulfillments_table',16);
INSERT INTO `migrations` VALUES (512,'2021_12_01_000000_add_uuid_to_failed_jobs_table',17);
INSERT INTO `migrations` VALUES (513,'2021_12_07_014223_allow_nullable_for_address_id_in_warehouses',18);
INSERT INTO `migrations` VALUES (514,'2021_12_11_044700_province_code_extend_addresses',19);
INSERT INTO `migrations` VALUES (515,'2021_12_14_032853_make_link_id_nullable_in_fifo_layers',20);
INSERT INTO `migrations` VALUES (516,'2021_12_14_040122_rename_columns_in_stock_take_items',21);
INSERT INTO `migrations` VALUES (517,'2021_12_15_041842_add_g_to_weight_unit_enum_in_products',22);
INSERT INTO `migrations` VALUES (518,'2019_12_14_000001_create_personal_access_tokens_table',23);
INSERT INTO `migrations` VALUES (519,'2021_12_15_160011_make_csv_null_in_datatable_export_batches',23);
INSERT INTO `migrations` VALUES (520,'2021_12_15_095029_seeder_add_tracking_links_to_shipping_carriers_table',24);
INSERT INTO `migrations` VALUES (521,'2021_12_16_213426_make_queue_id_and_order_line_id_unique_in_backorder_queue_coverages_table',25);
INSERT INTO `migrations` VALUES (522,'2021_12_16_074909_alter_table_sales_orders_add_refunded_status_enums',26);
INSERT INTO `migrations` VALUES (523,'2021_12_20_100000_add_index_to_addressables_id_type_id',27);
INSERT INTO `migrations` VALUES (524,'2021_12_20_100000_add_index_to_addresses_email',27);
INSERT INTO `migrations` VALUES (525,'2021_12_20_100000_add_index_to_addresses_name_zip_address',27);
INSERT INTO `migrations` VALUES (526,'2021_12_20_100000_add_index_to_customers_default_billing_address_id',27);
INSERT INTO `migrations` VALUES (527,'2021_12_20_100000_add_index_to_customers_default_shipping_address_id',27);
INSERT INTO `migrations` VALUES (528,'2021_12_21_074851_add_default_scheduled_value_to_amazon_reports_log_table',28);
INSERT INTO `migrations` VALUES (529,'2021_12_23_134710_alter_decimal_columns_on_reporting_tables',29);
INSERT INTO `migrations` VALUES (530,'2021_12_29_174055_add_link_id_link_type_index_to_inventory_movements',30);
INSERT INTO `migrations` VALUES (531,'2021_12_31_134905_make_sku_not_nullable_in_products',31);
INSERT INTO `migrations` VALUES (532,'2022_01_05_153617_alter_table_sales_orders_add_over_fulfilled_fulfilment_status',32);
INSERT INTO `migrations` VALUES (533,'2021_12_30_090240_alter_table_addressables_add_unique_for_address',33);
INSERT INTO `migrations` VALUES (534,'2022_01_11_061647_alter_tables_add_address_is_foreign_keys',34);
INSERT INTO `migrations` VALUES (535,'2022_01_12_095329_alter_tables_change_decimal_length',35);
INSERT INTO `migrations` VALUES (536,'2022_01_13_144001_alter_table_payments_change_amount_column',35);
INSERT INTO `migrations` VALUES (537,'2021_12_23_094538_add_soft_delete_to_sales_order_fulfillments_table',36);
INSERT INTO `migrations` VALUES (538,'2022_01_11_144153_drop_soft_delete_from_sales_order_fulfillments_table',36);
INSERT INTO `migrations` VALUES (539,'2022_01_25_111147_create_magento_orders_table',37);
INSERT INTO `migrations` VALUES (540,'0000_00_00_000000_create_websockets_statistics_entries_table',38);
INSERT INTO `migrations` VALUES (541,'0000_00_00_000000_rename_statistics_counters',38);
INSERT INTO `migrations` VALUES (542,'2022_02_07_065835_add_index_on_sales_channel_listing_id_to_product_listings_table',39);
INSERT INTO `migrations` VALUES (543,'2022_02_09_023755_add_po_email_to_stores',40);
INSERT INTO `migrations` VALUES (544,'2022_01_29_011913_create_magento_products_table',41);
INSERT INTO `migrations` VALUES (545,'2022_02_08_210756_add_product_to_magento_products',41);
INSERT INTO `migrations` VALUES (547,'2022_02_10_112931_add_user_id_column_to_payment_types_table',41);
INSERT INTO `migrations` VALUES (548,'2022_02_10_142820_revert_statistics_counters_names_in_websockets_statistics',42);
INSERT INTO `migrations` VALUES (549,'2022_02_14_084557_alter_unique_key_for_product_listings_table',43);
INSERT INTO `migrations` VALUES (550,'2021_12_21_122438_create_shopify_orders_table',44);
INSERT INTO `migrations` VALUES (551,'2022_01_13_121652_create_shopify_products_table',44);
INSERT INTO `migrations` VALUES (552,'2022_02_03_074315_alter_table_product_listings_add_mysql_document_id',44);
INSERT INTO `migrations` VALUES (553,'2022_02_04_201434_create_index_order_number_shopify_orders',44);
INSERT INTO `migrations` VALUES (555,'2022_02_08_072240_alter_table_shopify_products_add_product_column',45);
INSERT INTO `migrations` VALUES (556,'2022_02_08_080202_alter_table_product_listings_add_document_type',45);
INSERT INTO `migrations` VALUES (557,'2022_02_11_162141_alter_table_shopify_products_add_updated_by_column',45);
INSERT INTO `migrations` VALUES (558,'2022_02_16_144421_alter_table_shopify_orders_add_fulfillments_map_column',45);
INSERT INTO `migrations` VALUES (559,'2022_02_16_145611_alter_table_shopify_orders_add_refunds_map_column',45);
INSERT INTO `migrations` VALUES (560,'2022_02_18_161733_fix-wrong-migration-merge-into-dev',46);
INSERT INTO `migrations` VALUES (561,'2022_02_22_065958_alter_table_shopify_products_add_product_title',46);
INSERT INTO `migrations` VALUES (562,'2022_02_22_130043_create_job_batches_table',46);
INSERT INTO `migrations` VALUES (563,'2022_02_22_134555_create_table_notes',46);
INSERT INTO `migrations` VALUES (564,'2022_02_23_114509_create_shopify_order_line_items_table',46);
INSERT INTO `migrations` VALUES (565,'2022_02_23_173001_alter_table_shopify_products_add_variant_id_index',46);
INSERT INTO `migrations` VALUES (566,'2022_02_23_173337_alter_table_shopify_orders_add_indexes',46);
INSERT INTO `migrations` VALUES (567,'2022_02_24_084358_add_last_changes_column_to_shopify_orders_table',46);
INSERT INTO `migrations` VALUES (568,'2022_02_28_073428_alter_table_product_listings_add_mongo_document_id',46);
INSERT INTO `migrations` VALUES (569,'2022_03_02_100935_alter_table_shopify_products_add_images_column',47);
INSERT INTO `migrations` VALUES (570,'2022_03_04_025117_add_unique_constraints_to_sku_sales_order_id_in_shopify_orders_table',48);
INSERT INTO `migrations` VALUES (571,'2022_03_09_030027_add_unprocessed_changes_field_to_shopify_orders_table',49);
INSERT INTO `migrations` VALUES (572,'2022_03_10_083054_alter_table_shopify_orders_add_name_index',49);
INSERT INTO `migrations` VALUES (573,'2022_03_10_131426_add_sku_timestamps_to_shopify_products_table',49);
INSERT INTO `migrations` VALUES (574,'2022_03_10_151605_alter_table_shopify_orders_add_shopify_order_id_column',49);
INSERT INTO `migrations` VALUES (575,'2022_03_14_011604_shopify_products_modifications',49);
INSERT INTO `migrations` VALUES (576,'2022_03_17_124020_create_magento_customer_groups_table',50);
INSERT INTO `migrations` VALUES (577,'2022_03_06_114400_add_image_count_generated_column_to_magento_products_table',51);
INSERT INTO `migrations` VALUES (578,'2022_03_06_132239_alter_constrains_on_magento_products_table',51);
INSERT INTO `migrations` VALUES (579,'2022_03_21_120744_create_magento_product_attributes_table',51);
INSERT INTO `migrations` VALUES (580,'2022_03_23_223854_add_indexes_to_purchase_order_shipment_tables',52);
INSERT INTO `migrations` VALUES (581,'2022_03_23_130219_alter_product_constrain_in_sales_channel_products_tables',53);
INSERT INTO `migrations` VALUES (582,'2022_03_23_134251_set_store_id_column_not_null_to_sales_orders_table',53);
INSERT INTO `migrations` VALUES (583,'2022_03_27_023620_drop_data_table_export_batches_table',54);
INSERT INTO `migrations` VALUES (584,'2022_04_28_005358_add_timestamps_to_shopify_orders_table_if_not_exists',55);
INSERT INTO `migrations` VALUES (585,'2022_03_23_104328_create_payment_method_mappings_sales_channel_to_sku_table',56);
INSERT INTO `migrations` VALUES (586,'2022_03_27_132628_create_inventory_sources_table',56);
INSERT INTO `migrations` VALUES (587,'2022_03_30_093945_alter_failed_job_ids_column_to_job_batches_table',56);
INSERT INTO `migrations` VALUES (588,'2022_04_05_060824_add_updated_by_column_to_magento_products_table',56);
INSERT INTO `migrations` VALUES (589,'2022_04_05_091405_add_vendor_column_to_shopify_products_table',56);
INSERT INTO `migrations` VALUES (590,'2022_04_07_225247_create_magento_stores_table',56);
INSERT INTO `migrations` VALUES (591,'2022_04_08_013729_create_store_mappings',56);
INSERT INTO `migrations` VALUES (592,'2022_04_10_111242_add_unique_key_to_product_pricing_table',56);
INSERT INTO `migrations` VALUES (593,'2022_04_17_084110_create_get_product_listing_quantity_function',56);
INSERT INTO `migrations` VALUES (594,'2022_04_17_120757_seeder_add_default_date_format_to_settings_table',56);
INSERT INTO `migrations` VALUES (595,'2022_04_18_081151_add_type_id_column_to_magento_products_table',56);
INSERT INTO `migrations` VALUES (596,'2022_04_25_131801_add_unique_key_on_name_to_product_brands_table',56);
INSERT INTO `migrations` VALUES (597,'2022_04_26_081056_add_unique_key_to_product_images_table',57);
INSERT INTO `migrations` VALUES (598,'2022_04_27_001911_add_foreign_key_constraints_to_product_id_and_stock_take_id_in_stock_take_items_table',58);
INSERT INTO `migrations` VALUES (599,'2022_02_01_033036_create_xero_transactions_table',59);
INSERT INTO `migrations` VALUES (600,'2022_02_07_234355_add_xero_action_to_xero_transactions',59);
INSERT INTO `migrations` VALUES (601,'2022_02_08_014559_change_sync_status_to_enum',59);
INSERT INTO `migrations` VALUES (602,'2022_02_12_011821_add_sku_id_to_transactions',59);
INSERT INTO `migrations` VALUES (603,'2022_02_18_201652_add_xero_contact_id_to_customers',59);
INSERT INTO `migrations` VALUES (604,'2022_02_18_201657_add_xero_contact_id_to_suppliers',59);
INSERT INTO `migrations` VALUES (605,'2022_02_25_004716_add_xero_invoice_id_to_payments',59);
INSERT INTO `migrations` VALUES (606,'2022_03_16_044749_add_failed_status_to_sync_status',59);
INSERT INTO `migrations` VALUES (607,'2022_03_19_030211_add_mapping_id_to_payment_types',59);
INSERT INTO `migrations` VALUES (608,'2022_03_22_034236_add_last_synced_at_to_xero_transactions',59);
INSERT INTO `migrations` VALUES (609,'2022_04_06_033257_add_document_payment_status_to_xero_transactions',59);
INSERT INTO `migrations` VALUES (610,'2022_04_14_074740_alter_table_purchase_order_shipment_lines_add_reference_id',59);
INSERT INTO `migrations` VALUES (611,'2022_04_14_083127_alter_table_purchase_order_shipment_receipt_lines_add_reference_id',59);
INSERT INTO `migrations` VALUES (612,'2022_04_14_114254_alter_table_fifo_layers_add_uid_column',59);
INSERT INTO `migrations` VALUES (613,'2022_04_22_030756_add_helper_model_id_to_xero_transactions',59);
INSERT INTO `migrations` VALUES (614,'2022_05_07_000518_add_invoice_type_to_xero_transactions',59);
INSERT INTO `migrations` VALUES (615,'2022_05_11_132818_drop_unique_key_on_amazon_removal_shipments_collection',59);
INSERT INTO `migrations` VALUES (616,'2022_05_11_132819_drop_unique_key_on_amazon_fba_inventory_adjustments_collection',59);
INSERT INTO `migrations` VALUES (617,'2022_05_14_013518_change_transaction_date_to_datetime_on_xero_transactions',59);
INSERT INTO `migrations` VALUES (618,'2022_03_24_090257_create_magento_order_line_items_table',60);
INSERT INTO `migrations` VALUES (619,'2022_05_16_073930_alter_magento_order_id_foreign_key_to_magento_order_line_items_table',60);
INSERT INTO `migrations` VALUES (620,'2022_05_17_092725_alter_shopify_order_id_foreign_key_to_shopify_order_line_items_table',60);
INSERT INTO `migrations` VALUES (621,'2022_05_17_122617_seeder_add_enabled_table_view_to_magento_products_table',60);
INSERT INTO `migrations` VALUES (622,'2022_05_19_234344_run_timezone_seeder',60);
INSERT INTO `migrations` VALUES (623,'2022_06_02_000959_create_shopify_order_mappings_table',61);
INSERT INTO `migrations` VALUES (624,'2022_06_04_143849_port_shopify_order_mappings_to_new_model',62);
INSERT INTO `migrations` VALUES (625,'2022_05_17_132631_add_unique_key_to_sales_order_id_and_fulfillment_sequence_in_sales_order_fulfillments_table',63);
INSERT INTO `migrations` VALUES (626,'2022_05_18_051426_add_index_to_reference_field_in_inventory_movements_table',63);
INSERT INTO `migrations` VALUES (627,'2022_06_13_185626_port_fifo_layer_links_from_sales_credit_lines_to_sales_credit_return_lines',64);
INSERT INTO `migrations` VALUES (628,'2022_03_17_021421_add_entity_id_to_magento_orders',65);
INSERT INTO `migrations` VALUES (629,'2022_04_08_140101_add_supplier_field_to_magento_products_table',66);
INSERT INTO `migrations` VALUES (630,'2022_04_08_193622_add_image_field_to_magento_products',66);
INSERT INTO `migrations` VALUES (631,'2022_04_12_124037_add_index_to_warehouse_and_supplier_ids_in_supplier_inventory_table',66);
INSERT INTO `migrations` VALUES (632,'2022_04_12_124643_add_index_to_supplier_id_field_in_warehouses_table',66);
INSERT INTO `migrations` VALUES (633,'2022_04_13_030908_add_index_to_image_count_field_in_shopify_products_table',66);
INSERT INTO `migrations` VALUES (634,'2022_04_13_042036_add_foreign_key_to_product_id_in_suppliers_table',66);
INSERT INTO `migrations` VALUES (635,'2022_04_15_020958_add_index_to_line_id_and_product_id_in_magento_order_line_items_table',66);
INSERT INTO `migrations` VALUES (636,'2022_05_11_060707_alter_image_column_to_magento_products_table',66);
INSERT INTO `migrations` VALUES (637,'2022_05_11_063521_alter_supplier_column_to_magento_products_table',66);
INSERT INTO `migrations` VALUES (638,'2022_05_22_091252_alter_magento_orders_table',66);
INSERT INTO `migrations` VALUES (639,'2022_05_28_090702_add_unique_key_to_product_attributes_table',66);
INSERT INTO `migrations` VALUES (640,'2022_05_29_094306_alter_case_weight_column_to_products_table',66);
INSERT INTO `migrations` VALUES (641,'2022_06_01_073723_add_unique_sku_key_to_magento_products_table',66);
INSERT INTO `migrations` VALUES (642,'2022_06_06_062830_seeder_fix_data_in_import_mappings_collection',66);
INSERT INTO `migrations` VALUES (643,'2022_05_19_165025_run_settings_seeder',67);
INSERT INTO `migrations` VALUES (644,'2022_06_10_055420_add_foreign_key_constrains_to_supplier_inventory_table',67);
INSERT INTO `migrations` VALUES (645,'2022_06_14_012801_run_digital_asset_to_link_command',67);
INSERT INTO `migrations` VALUES (646,'2022_06_14_074433_alter_value_column_to_generated_report_items_table',67);
INSERT INTO `migrations` VALUES (647,'2022_06_14_140416_alter_inventory_movements_add_index',67);
INSERT INTO `migrations` VALUES (648,'2022_05_19_001911_add_notes_to_attributes',68);
INSERT INTO `migrations` VALUES (649,'2022_06_15_123524_add_default_stock_level_column_to_suppliers_table',68);
INSERT INTO `migrations` VALUES (650,'2022_06_14_074729_alter_shopify_products_table_add_created_at_index',69);
INSERT INTO `migrations` VALUES (651,'2022_07_08_222038_add_is_power_user_to_users_table',70);
INSERT INTO `migrations` VALUES (652,'2022_05_27_021126_fix_tax_amounts_xero_transactions',71);
INSERT INTO `migrations` VALUES (653,'2022_06_15_112907_add_nominal_codes_columns_to_products_table',72);
INSERT INTO `migrations` VALUES (654,'2022_07_06_104025_alter_table_product_listings_add_index_sales_channel_id_s',72);
INSERT INTO `migrations` VALUES (655,'2022_07_06_104549_alter_table_product_listings_add_index_document_id_document_type',72);
INSERT INTO `migrations` VALUES (656,'2022_07_06_105852_alter_table_purchase_orders_add_index_sales_order_id',72);
INSERT INTO `migrations` VALUES (657,'2022_07_06_110148_alter_table_sales_order_fulfillments_add_index_sales_order_id',72);
INSERT INTO `migrations` VALUES (658,'2022_07_06_110318_alter_table_shopify_orders_add_index_update_at',72);
INSERT INTO `migrations` VALUES (659,'2022_07_06_110541_alter_table_shopify_products_add_index_integration_instance_id_sku',72);
INSERT INTO `migrations` VALUES (660,'2022_07_06_110756_alter_table_shopify_products_add_index_created_at',72);
INSERT INTO `migrations` VALUES (661,'2022_07_07_134755_alter_table_shopify_products_add_inventory_item_sku_index',72);
INSERT INTO `migrations` VALUES (662,'2022_07_05_095918_nullable_cutomer_id_column_to_sales_credits_table',73);
INSERT INTO `migrations` VALUES (663,'2022_06_22_120129_add_discontinued_column_to_supplier_inventory_table',74);
INSERT INTO `migrations` VALUES (664,'2022_07_18_140854_fix_duplicate_shopify_order_shipping_lines',75);
INSERT INTO `migrations` VALUES (665,'2022_07_11_235619_create_tax_rates_table',76);
INSERT INTO `migrations` VALUES (666,'2022_07_12_001350_tax_rate_updates',76);
INSERT INTO `migrations` VALUES (667,'2022_07_12_181317_alter_table_sales_order_lines_add_is_taxable_column',76);
INSERT INTO `migrations` VALUES (668,'2022_07_15_160851_alter_table_sales_orders_link_tax_rate_id_for_existing_tax_lines',76);
INSERT INTO `migrations` VALUES (669,'2022_07_21_194636_add_taxes_included_to_shopify_orders',76);
INSERT INTO `migrations` VALUES (670,'2022_07_21_050509_add_foreign_key_constrains_to_tables',77);
INSERT INTO `migrations` VALUES (671,'2022_07_12_222433_add_sku_type_name_to_xero_transactions',78);
INSERT INTO `migrations` VALUES (672,'2022_07_13_050742_add_sku_type_name_to_xero_transactions_seeder',78);
INSERT INTO `migrations` VALUES (673,'2022_07_17_204755_change_transaction_dates_on_xero_transactions_seeder',78);
INSERT INTO `migrations` VALUES (674,'2022_07_29_064827_drop_product_listings_bk_table',78);
INSERT INTO `migrations` VALUES (675,'2022_07_31_072321_seeder_cleanup_orphan_taggables_table',78);
INSERT INTO `migrations` VALUES (676,'2022_07_12_214305_po_tax_rate_updates',79);
INSERT INTO `migrations` VALUES (677,'2022_07_12_215643_sales_credit_tax_rate_updates',79);
INSERT INTO `migrations` VALUES (678,'2022_08_10_140739_alter_table_purchase_order_lines_drop_tax_column',80);
INSERT INTO `migrations` VALUES (679,'2022_03_08_063101_alter_table_shopify_products_add_vendor_column',81);
INSERT INTO `migrations` VALUES (680,'2022_08_15_011829_add_reference_field_to_backorder_queue_releases_table',82);
INSERT INTO `migrations` VALUES (681,'2022_07_22_163514_cost_estimates',83);
INSERT INTO `migrations` VALUES (682,'2022_08_17_002419_add_tax_columns_to_products_table',84);
INSERT INTO `migrations` VALUES (683,'2022_08_17_002701_add_default_tax_rate_id_to_supplier_products',84);
INSERT INTO `migrations` VALUES (684,'2022_08_18_030901_add_default_tax_rate_id_to_suppliers',84);
INSERT INTO `migrations` VALUES (685,'2022_09_12_040406_create_shopify_bulk_operations_table',84);
INSERT INTO `migrations` VALUES (686,'2022_09_12_221430_add_unique_index_for_integration_instance_id_shopify_order_id_to_shopify_orders',84);
INSERT INTO `migrations` VALUES (687,'2022_09_12_225719_change_json_fields_shopify_orders',84);
INSERT INTO `migrations` VALUES (688,'2022_09_13_160522_create_transactions_updated_at_on_shopify_orders',84);
INSERT INTO `migrations` VALUES (689,'2022_09_15_124835_add_index_to_shopify_orders_transactions_updated_at',84);
INSERT INTO `migrations` VALUES (690,'2022_09_16_203230_create_shopify_webhooks_table',85);
INSERT INTO `migrations` VALUES (691,'2022_09_19_144322_create_audits_table',86);
INSERT INTO `migrations` VALUES (692,'2022_09_19_113615_add_number_as_stored_generated_on_shopify_orders',87);
INSERT INTO `migrations` VALUES (693,'2022_09_20_130553_alter_table_personal_access_tokens_add_expires_at_column',88);
INSERT INTO `migrations` VALUES (694,'2022_01_27_104151_create_starshipit_orders_table',89);
INSERT INTO `migrations` VALUES (695,'2022_04_27_085220_alter_table_starshipit_orders_add_shipment_column',89);
INSERT INTO `migrations` VALUES (696,'2022_07_02_000345_add_mm_to_dimension_unit_enum',89);
INSERT INTO `migrations` VALUES (697,'2022_08_02_014612_create_xero_tax_rates_table',89);
INSERT INTO `migrations` VALUES (698,'2022_08_04_042800_create_tax_rates_mappings_table',89);
INSERT INTO `migrations` VALUES (699,'2022_09_22_034737_fix_currencies_decimal',89);
INSERT INTO `migrations` VALUES (700,'2022_09_25_024954_drop_last_changes_from_shopify_orders',89);
INSERT INTO `migrations` VALUES (701,'2018_02_05_000000_create_queue_monitor_table',90);
INSERT INTO `migrations` VALUES (702,'2022_05_05_073454_create_amazon_orders_table',90);
INSERT INTO `migrations` VALUES (703,'2022_08_29_105846_alter_table_amazon_report_log_add_column_metadata',90);
INSERT INTO `migrations` VALUES (704,'2022_09_18_155117_create_activity_log_table',90);
INSERT INTO `migrations` VALUES (705,'2022_09_18_155118_add_event_column_to_activity_log_table',90);
INSERT INTO `migrations` VALUES (706,'2022_09_18_155119_add_batch_uuid_column_to_activity_log_table',90);
INSERT INTO `migrations` VALUES (707,'2022_09_20_040124_create_amazon_reports_table',90);
INSERT INTO `migrations` VALUES (708,'2022_09_20_161033_update_sales_order_lines',90);
INSERT INTO `migrations` VALUES (709,'2022_09_22_191818_add_proforma_costs_to_products',90);
INSERT INTO `migrations` VALUES (710,'2022_09_22_211057_add_proforma_costs_to_integrations',90);
INSERT INTO `migrations` VALUES (711,'2022_09_23_080602_fix_sales_order_lines',90);
INSERT INTO `migrations` VALUES (712,'2022_09_23_175759_additional_fields_for_sales_order_lines',90);
INSERT INTO `migrations` VALUES (713,'2022_09_28_085925_add_parent_subject_id_column_to_activity_log_table',90);
INSERT INTO `migrations` VALUES (714,'2022_10_01_185737_create_accounting_transactions_table',90);
INSERT INTO `migrations` VALUES (715,'2022_10_01_191326_create_accounting_transaction_lines_table',90);
INSERT INTO `migrations` VALUES (716,'2022_10_01_225439_create_xero_transactions_table',90);
INSERT INTO `migrations` VALUES (717,'2022_10_02_164953_create_api_log_table',90);
INSERT INTO `migrations` VALUES (718,'2022_10_03_102827_create_mysql_shopify_webhooks_table',90);
INSERT INTO `migrations` VALUES (719,'2022_10_06_123552_add_line_type_to_shopify_order_mappings_table',90);
INSERT INTO `migrations` VALUES (720,'2022_10_06_180339_create_xero_payments_table',90);
INSERT INTO `migrations` VALUES (721,'2022_10_06_192734_create_xero_accounts_table',90);
INSERT INTO `migrations` VALUES (722,'2022_10_08_123451_create_xero_contacts',90);
INSERT INTO `migrations` VALUES (723,'2022_10_08_123519_create_xero_tax_rates',90);
INSERT INTO `migrations` VALUES (724,'2022_10_09_105242_add_accounting_integration_link_to_payments',90);
INSERT INTO `migrations` VALUES (725,'2022_10_09_145359_add_accounting_integration_link_to_payment_types',90);
INSERT INTO `migrations` VALUES (726,'2022_10_09_235033_add_is_tax_included_to_accounting_transactions',90);
INSERT INTO `migrations` VALUES (727,'2022_10_12_002419_add_status_column_to_integration_instances_table',90);
INSERT INTO `migrations` VALUES (728,'2022_10_12_041816_add_accounting_integration_link_to_tax_rates_table',90);
INSERT INTO `migrations` VALUES (729,'2022_10_12_113201_create_integration_instance_service_disruptions_table',90);
INSERT INTO `migrations` VALUES (730,'2022_10_12_203547_remove_outdated_xero_tables_and_fields',90);
INSERT INTO `migrations` VALUES (731,'2022_10_17_004500_rename_leagacy_tag_tables',90);
INSERT INTO `migrations` VALUES (732,'2022_10_17_004742_create_tag_tables',90);
INSERT INTO `migrations` VALUES (733,'2022_10_17_004800_migrate_tag_data',90);
INSERT INTO `migrations` VALUES (734,'2022_10_18_210558_add_tax_rate_id_foreign_constraint',90);
INSERT INTO `migrations` VALUES (735,'2022_10_20_103239_create_shopify_locations_table',90);
INSERT INTO `migrations` VALUES (736,'2022_10_20_124425_add_refunds_count_generated_column_to_shopify_orders_table',90);
INSERT INTO `migrations` VALUES (737,'2022_10_22_140042_add_unique_index_to_currencies',90);
INSERT INTO `migrations` VALUES (738,'2022_10_23_133744_add_parent_id_to_accounting_transactions',90);
INSERT INTO `migrations` VALUES (739,'2022_10_23_204217_add_allocated_at_to_accounting_transactions',90);
INSERT INTO `migrations` VALUES (740,'2022_10_24_114102_alter_nominal_codes_add_accrued_purchases',90);
INSERT INTO `migrations` VALUES (741,'2022_10_26_080205_clean_view_table',90);
INSERT INTO `migrations` VALUES (742,'2022_10_26_223029_create_amazon_products_table',90);
INSERT INTO `migrations` VALUES (743,'2022_10_27_110818_create_import_last_mapping_table',90);
INSERT INTO `migrations` VALUES (744,'2022_10_28_232000_fix_suppliers_id',90);
INSERT INTO `migrations` VALUES (745,'2022_10_28_232304_create_reporting_daily_product_proforma_financials_table',90);
INSERT INTO `migrations` VALUES (746,'2022_10_30_002846_add_catalog_data_to_amazon_products_table',90);
INSERT INTO `migrations` VALUES (747,'2022_10_30_041254_create_amazon_order_items_table',90);
INSERT INTO `migrations` VALUES (748,'2022_10_30_122222_create_packing_slip_queue_table',90);
INSERT INTO `migrations` VALUES (749,'2022_10_30_181511_create_amazon_fba_report_inventory_ledger_table',90);
INSERT INTO `migrations` VALUES (750,'2022_10_30_203150_create_amazon_fba_report_restock_table',90);
INSERT INTO `migrations` VALUES (751,'2022_10_30_224241_create_amazon_financial_event_groups_table',90);
INSERT INTO `migrations` VALUES (752,'2022_10_31_072334_create_shipstation_orders_table',90);
INSERT INTO `migrations` VALUES (753,'2022_11_01_135425_update_foreign_for_import_last_mapping_table',90);
INSERT INTO `migrations` VALUES (754,'2022_11_01_142411_add_foreign_for_shopify_location_table',90);
INSERT INTO `migrations` VALUES (755,'2022_11_01_230841_create_amazon_report_requests_table',90);
INSERT INTO `migrations` VALUES (756,'2022_11_02_094721_add_name_unique_on_tax_rates_table',90);
INSERT INTO `migrations` VALUES (757,'2022_11_03_105735_seed_settings_table',90);
INSERT INTO `migrations` VALUES (758,'2022_11_03_214728_add_quantity_to_accounting_transaction_lines_table',90);
INSERT INTO `migrations` VALUES (759,'2022_11_04_125337_fix_currencies',90);
INSERT INTO `migrations` VALUES (760,'2022_11_04_205240_drop_old_currency_columns',90);
INSERT INTO `migrations` VALUES (761,'2022_11_07_144255_drop_old_sync_settings',90);
INSERT INTO `migrations` VALUES (762,'2022_11_09_174419_cache_fulfilled_quantity_in_sales_order_lines',90);
INSERT INTO `migrations` VALUES (763,'2022_11_10_040007_create_table_constant_currencies',90);
INSERT INTO `migrations` VALUES (764,'2022_11_10_041718_create_constants_countries_table',90);
INSERT INTO `migrations` VALUES (765,'2022_11_10_042316_create_constants_states_table',90);
INSERT INTO `migrations` VALUES (766,'2022_11_10_042524_create_constants_zip_codes_table',90);
INSERT INTO `migrations` VALUES (767,'2022_11_10_050102_create_constants_continents_table',90);
INSERT INTO `migrations` VALUES (768,'2022_11_10_142345_add_externally_fulfilled_quantity_field_to_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (769,'2022_11_10_144425_add_warehouse_routing_method_field_to_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (770,'2022_11_11_133237_add_is_dropshippable_field_to_products_table',90);
INSERT INTO `migrations` VALUES (771,'2022_11_12_144143_create_amazon_fba_report_customer_returns_table',90);
INSERT INTO `migrations` VALUES (772,'2022_11_12_144155_create_amazon_fba_report_shipments_table',90);
INSERT INTO `migrations` VALUES (773,'2022_11_12_144201_create_amazon_fba_report_removal_orders_table',90);
INSERT INTO `migrations` VALUES (774,'2022_11_12_144207_create_amazon_fba_report_removal_shipments_table',90);
INSERT INTO `migrations` VALUES (775,'2022_11_13_141414_create_amazon_fulfillment_orders_table',90);
INSERT INTO `migrations` VALUES (776,'2022_11_13_141415_create_amazon_fulfillment_order_items_table',90);
INSERT INTO `migrations` VALUES (777,'2022_11_13_141415_create_amazon_fulfillment_shipments_table',90);
INSERT INTO `migrations` VALUES (778,'2022_11_13_141416_create_amazon_fulfillment_shipment_items_table',90);
INSERT INTO `migrations` VALUES (779,'2022_11_13_141417_create_amazon_fulfillment_shipment_packages_table',90);
INSERT INTO `migrations` VALUES (780,'2022_11_13_141418_create_amazon_fulfillment_return_authorizations_table',90);
INSERT INTO `migrations` VALUES (781,'2022_11_13_141419_create_amazon_fulfillment_return_items_table',90);
INSERT INTO `migrations` VALUES (782,'2022_11_14_101456_alter_table_constants_states_add_code_column',90);
INSERT INTO `migrations` VALUES (783,'2022_11_14_230200_create_amazon_fba_inventory_table',90);
INSERT INTO `migrations` VALUES (784,'2022_11_15_130738_change_purchase_order_date_type',90);
INSERT INTO `migrations` VALUES (785,'2022_11_16_110713_fix_purchase_order_date_timezone',90);
INSERT INTO `migrations` VALUES (786,'2022_11_18_034345_convert_fifo_layers_to_foreign_currency',90);
INSERT INTO `migrations` VALUES (787,'2022_11_18_045137_add_currency_fields_to_accounting_transactions_table',90);
INSERT INTO `migrations` VALUES (788,'2022_11_20_074427_add_is_daily_average_consumption_cache_valid_to_products_table',90);
INSERT INTO `migrations` VALUES (789,'2022_11_23_123735_update_products_benchmarks_table',90);
INSERT INTO `migrations` VALUES (790,'2022_11_24_054911_add_is_for_overpayment_to_sales_credits_table',90);
INSERT INTO `migrations` VALUES (791,'2022_11_24_055944_add_type_field_to_payments_table',90);
INSERT INTO `migrations` VALUES (792,'2022_11_24_124824_add_fields_to_sales_credit_allocations_table',90);
INSERT INTO `migrations` VALUES (793,'2022_11_27_161824_create_amazon_fba_inbound_shipments_table',90);
INSERT INTO `migrations` VALUES (794,'2022_11_27_162023_create_amazon_fba_inbound_shipment_items_table',90);
INSERT INTO `migrations` VALUES (795,'2022_11_28_045525_add_status_to_xero_transactions',90);
INSERT INTO `migrations` VALUES (796,'2022_11_28_062558_fix_movements_without_layer_command',90);
INSERT INTO `migrations` VALUES (797,'2022_11_29_003329_alter_decimal_in_accounting_transactions_table',90);
INSERT INTO `migrations` VALUES (798,'2022_11_29_084447_add_sales_order_id_column_to_sales_credits_table',90);
INSERT INTO `migrations` VALUES (799,'2022_11_29_105201_add_cost_column_to_payments_table',90);
INSERT INTO `migrations` VALUES (800,'2022_12_01_005732_add_index_to_shopify_order_id_in_shopify_orders',90);
INSERT INTO `migrations` VALUES (801,'2022_12_01_114432_add_meta_data_to_activity_log_table',90);
INSERT INTO `migrations` VALUES (802,'2022_12_04_112700_woocommerce_orders',90);
INSERT INTO `migrations` VALUES (803,'2022_12_04_115700_woocommerce_order_items',90);
INSERT INTO `migrations` VALUES (804,'2022_12_07_221508_fix_starshipit_orders',90);
INSERT INTO `migrations` VALUES (805,'2022_12_09_134114_add_tax_fields_to_accounting_transactions',90);
INSERT INTO `migrations` VALUES (806,'2022_12_14_101017_alter_table_amazon_products_add_catalog_columns',90);
INSERT INTO `migrations` VALUES (807,'2022_12_15_121431_add_2fa_to_users_table',90);
INSERT INTO `migrations` VALUES (808,'2022_12_15_143806_add_default_value_to_is_daily_average_consumption_cache_valid_field_in_products_table',90);
INSERT INTO `migrations` VALUES (809,'2022_12_16_025718_add_default_values_to_cached_fields',90);
INSERT INTO `migrations` VALUES (810,'2022_12_16_031906_set_default_values_for_accounting_fields_in_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (811,'2022_12_16_042052_set_default_values_for_accounting_transactions_table',90);
INSERT INTO `migrations` VALUES (812,'2022_12_16_042951_set_default_values_in_reporting_daily_product_proforma_financials_table',90);
INSERT INTO `migrations` VALUES (813,'2022_12_16_090945_alter_table_amazon_orders_add_utc_date_columns',90);
INSERT INTO `migrations` VALUES (814,'2022_12_21_010535_add_polymorphic_link_to_amazon_fba_report_inventory_ledger_table',90);
INSERT INTO `migrations` VALUES (815,'2022_12_21_021551_add_amazon_report_id_to_processed_reports_tables',90);
INSERT INTO `migrations` VALUES (816,'2022_12_21_054340_add_sku_link_to_amazon_fba_report_inventory_ledger',90);
INSERT INTO `migrations` VALUES (817,'2022_12_21_134712_add_default_value_to_tax_amount_field_in_accounting_transactions_table',90);
INSERT INTO `migrations` VALUES (818,'2022_12_21_184936_add_amazon_product_id_to_amazon_fba_report_inventory_ledger',90);
INSERT INTO `migrations` VALUES (819,'2022_12_25_132222_add_sku_link_to_amazon_fba_report_removal_orders_table',90);
INSERT INTO `migrations` VALUES (820,'2022_12_26_114027_add_default_value_to_is_for_overpayment_field_in_sales_credits_table',90);
INSERT INTO `migrations` VALUES (821,'2022_12_27_080124_alter_table_sales_orders_add_polymorphic_relation',90);
INSERT INTO `migrations` VALUES (822,'2022_12_28_033241_make_response_fields_nullable_in_api_logs_table',90);
INSERT INTO `migrations` VALUES (823,'2022_12_30_025800_add_default_value_to_is_proforma_marketplace_cost_cache_valid_in_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (824,'2022_12_30_192601_create_amazon_feed_submissions_table',90);
INSERT INTO `migrations` VALUES (825,'2022_12_30_194949_create_amazon_feed_requests_table',90);
INSERT INTO `migrations` VALUES (826,'2022_12_31_085321_create_jobs_table',90);
INSERT INTO `migrations` VALUES (827,'2023_01_05_093827_seeder_add_po_builder_keys_to_settings_table',90);
INSERT INTO `migrations` VALUES (828,'2023_01_05_093828_seeder_add_po_builder_keys_to_settings_table',90);
INSERT INTO `migrations` VALUES (829,'2023_01_08_011129_add_indexes_to_payments',90);
INSERT INTO `migrations` VALUES (830,'2023_01_08_011134_add_indexes_to_payment_types',90);
INSERT INTO `migrations` VALUES (831,'2023_01_12_142903_create_amazon_report_settlement_data_table',90);
INSERT INTO `migrations` VALUES (832,'2023_01_13_194504_convert_quantity_to_string_in_amazon_products_table',90);
INSERT INTO `migrations` VALUES (833,'2023_01_14_211838_create_amazon_report_settlement_type_mappings_table',90);
INSERT INTO `migrations` VALUES (834,'2023_01_16_075956_transfer_refunds_to_positive_amount',90);
INSERT INTO `migrations` VALUES (835,'2023_01_26_073855_alter_amazon_feed_requests_add_metadata_column',90);
INSERT INTO `migrations` VALUES (836,'2023_02_02_112929_fix_sales_credit_relation_with_sales_order',90);
INSERT INTO `migrations` VALUES (837,'2023_02_06_163145_create_amazon_fba_report_inventory_ledger_summaries',90);
INSERT INTO `migrations` VALUES (838,'2023_02_07_011541_drop_tax_amount_field_from_accounting_transactions_table',90);
INSERT INTO `migrations` VALUES (839,'2023_02_07_123155_change_amount_type_payments_table',90);
INSERT INTO `migrations` VALUES (840,'2023_02_09_140439_fix_duplicate_sku_in_sotck_take',90);
INSERT INTO `migrations` VALUES (841,'2023_02_16_094626_add_request_body_field_to_xero_transactions_table',90);
INSERT INTO `migrations` VALUES (842,'2023_02_16_231718_add_shipmyorders_fulfillment_type_to_sales_order_fulfillments_table',90);
INSERT INTO `migrations` VALUES (843,'2023_02_21_090006_alter_table_amazon_orders_add__shipping_address_column',90);
INSERT INTO `migrations` VALUES (844,'2023_02_23_104632_alter_table_amazon_fba_report_inventory_ledger_add_checksum_column',90);
INSERT INTO `migrations` VALUES (845,'2023_02_25_175931_seed_ship_my_orders_integration_to_integrations_table',90);
INSERT INTO `migrations` VALUES (846,'2023_02_26_043832_create_woocommerce_products',90);
INSERT INTO `migrations` VALUES (847,'2023_02_26_080337_alter_table_amazon_reports__add_checksum_column',90);
INSERT INTO `migrations` VALUES (848,'2023_03_01_000000_update_queue_monitor_table',90);
INSERT INTO `migrations` VALUES (849,'2023_03_01_000913_alter_proforma_prorated_revenue_in_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (850,'2023_03_03_031011_add_submission_started_at_to_accounting_transactions',90);
INSERT INTO `migrations` VALUES (851,'2023_03_07_044904_create_xero_manual_journals_table',90);
INSERT INTO `migrations` VALUES (852,'2023_03_08_084331_alter_table_amazon_fba_report_inventory_ledger_add_date_datetime_column',90);
INSERT INTO `migrations` VALUES (853,'2023_03_08_084908_alter_table_amazon_fba_report_removal_shipments_add_date_datetime_column',90);
INSERT INTO `migrations` VALUES (854,'2023_03_08_092743_alter_table_amazon_fba_report_shipments_add_reporting_date_datetime_column',90);
INSERT INTO `migrations` VALUES (855,'2023_03_08_142224_alter_table_amazon_fba_report_shipments_add_checksum_column',90);
INSERT INTO `migrations` VALUES (856,'2023_03_10_102428_alter_table_amazon_fba_report_inventory_add_checksum_column',90);
INSERT INTO `migrations` VALUES (857,'2023_03_10_103008_alter_table_amazon_fba_report_removal_orders_add_checksum_column',90);
INSERT INTO `migrations` VALUES (858,'2023_03_13_132503_alter_table_amazon_financial_event_groups_add_datetime_columns',90);
INSERT INTO `migrations` VALUES (859,'2023_03_13_134459_alter_table_amazon_report_settlement_data_add_checksum_column',90);
INSERT INTO `migrations` VALUES (860,'2023_03_16_155115_alter_shopify_product_fields',90);
INSERT INTO `migrations` VALUES (861,'2023_03_16_155116_alter_shopify_product_fields',90);
INSERT INTO `migrations` VALUES (862,'2023_03_16_223820_add_woo_commerce_integration',90);
INSERT INTO `migrations` VALUES (863,'2023_03_19_113103_extend_description_to_300_chars_in_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (864,'2023_03_19_130752_extend_accounting_transaction_lines_description',90);
INSERT INTO `migrations` VALUES (865,'2023_03_23_101017_alter_table_amazon_products_add_catalog_columns',90);
INSERT INTO `migrations` VALUES (866,'2023_03_29_003911_add_out_of_sync_to_fulfillment_status_enum_for_sales_orders',90);
INSERT INTO `migrations` VALUES (867,'2023_03_30_092600_add_fields_to_amazon_products',90);
INSERT INTO `migrations` VALUES (868,'2023_03_30_152544_fix_amazon_products_price',90);
INSERT INTO `migrations` VALUES (869,'2023_04_06_085956_alter_table_customers_make_default_shipping_address_id_nullable',90);
INSERT INTO `migrations` VALUES (870,'2023_04_06_090954_alter_table_amazon_orders_add_buyer_info_stored_column',90);
INSERT INTO `migrations` VALUES (871,'2023_04_11_121417_create_product_listing_inventory_table',90);
INSERT INTO `migrations` VALUES (872,'2023_04_12_053554_alter_table_integration_shipping_methods_make_is_domestic_default_true',90);
INSERT INTO `migrations` VALUES (873,'2023_04_12_154945_alter_table_amazon_products_change_price_column',90);
INSERT INTO `migrations` VALUES (874,'2023_04_21_073218_alter_table_amazon_orders_add_sync_status_column',90);
INSERT INTO `migrations` VALUES (875,'2023_04_21_123842_alter_table_woo_commerce_orders_add_sync_status_column',90);
INSERT INTO `migrations` VALUES (876,'2023_04_22_023037_alter_table_starshipit_orders_total_shipping_price',90);
INSERT INTO `migrations` VALUES (877,'2023_04_23_174904_fix_datetime_for_reports',90);
INSERT INTO `migrations` VALUES (878,'2023_04_24_114116_create_shopify_events_table',90);
INSERT INTO `migrations` VALUES (879,'2023_04_25_013319_add_archived_at_to_woo_commerce_orders',90);
INSERT INTO `migrations` VALUES (880,'2023_04_25_053554_create_zip_locations',90);
INSERT INTO `migrations` VALUES (881,'2023_04_25_153850_alter_table_amazon_orders_add__amazon_purchase_order_date',90);
INSERT INTO `migrations` VALUES (882,'2023_04_27_110222_add_integration_instance_id_index_to_import_last_mapping_table',90);
INSERT INTO `migrations` VALUES (883,'2023_04_27_135115_add_sku_processed_at_to_shopify_event',90);
INSERT INTO `migrations` VALUES (884,'2023_04_29_011530_fix_financial_event_group_dates',90);
INSERT INTO `migrations` VALUES (885,'2023_04_29_013423_alter_table_amazon_reports_add_column_processed_at',90);
INSERT INTO `migrations` VALUES (886,'2023_04_29_045720_add_financial_code_to_amazon_report_settlement_type_mappings_table',90);
INSERT INTO `migrations` VALUES (887,'2023_04_29_233008_alter_table_accounting_transactions_add_is_batchable',90);
INSERT INTO `migrations` VALUES (888,'2023_04_30_140747_add_accounting_status_to_amazon_financial_event_groups_table',90);
INSERT INTO `migrations` VALUES (889,'2023_05_02_082111_convert_product_id_on_shopify_as_generated_stored',90);
INSERT INTO `migrations` VALUES (890,'2023_05_03_144452_add_job_uuid_and_retried_to_queue_monitor_table',90);
INSERT INTO `migrations` VALUES (891,'2023_05_09_190206_seeder_warehouse_locations_options',90);
INSERT INTO `migrations` VALUES (892,'2023_05_14_122459_add_is_automatic_sync_enabled_to_integration_instances_table',90);
INSERT INTO `migrations` VALUES (893,'2023_05_15_083522_create_shipstation_webhooks_tabele',90);
INSERT INTO `migrations` VALUES (894,'2023_05_15_145622_add_sync_status_to_shopify_orders_table',90);
INSERT INTO `migrations` VALUES (895,'2023_05_16_103918_alter_table_shopify_products_add_was_catalog_data_sync_attempted_column',90);
INSERT INTO `migrations` VALUES (896,'2023_05_27_152043_alter_table_amazon_report_requests_add_marketplace_ids_column',90);
INSERT INTO `migrations` VALUES (897,'2023_05_28_144836_create_amazon_fnsku_products_table',90);
INSERT INTO `migrations` VALUES (898,'2023_05_28_170323_add_fnsku_indexes_to_ledger_tables',90);
INSERT INTO `migrations` VALUES (899,'2023_05_29_072811_seed_settings_table',90);
INSERT INTO `migrations` VALUES (900,'2023_05_30_092313_add_auto_routing_enabled_column_to_warehouses',90);
INSERT INTO `migrations` VALUES (901,'2023_05_31_162934_add_auditTrailError_to_amazon_fba_report_inventory_ledger_table',90);
INSERT INTO `migrations` VALUES (902,'2023_06_02_141018_make_product_id_nullable_for_warehouse_transfer_lines_table',90);
INSERT INTO `migrations` VALUES (903,'2023_06_02_143752_sanitize_integers_in_amazon_fba_report_removal_orders_table',90);
INSERT INTO `migrations` VALUES (904,'2023_06_07_114223_seed_setting_table_auto_split_sales_order_option',90);
INSERT INTO `migrations` VALUES (905,'2023_06_08_115302_create_product_kit_components_table',90);
INSERT INTO `migrations` VALUES (906,'2023_06_08_120208_add_type_enum_to_products',90);
INSERT INTO `migrations` VALUES (907,'2023_06_08_124930_add_kit_product_id_to_products_table',90);
INSERT INTO `migrations` VALUES (908,'2023_06_09_154845_fix_amazon_removal_order_fields',90);
INSERT INTO `migrations` VALUES (909,'2023_06_10_011646_add_auto_receive_backorder_purchase_orders_column_to_suppliers_table',90);
INSERT INTO `migrations` VALUES (910,'2023_06_12_130615_alter_table_inventory_movements_add_uid_column',90);
INSERT INTO `migrations` VALUES (911,'2023_06_13_143728_alter_table_backorder_queues_add_uid_column',90);
INSERT INTO `migrations` VALUES (912,'2023_06_14_095627_convert_bundles_to_kits',90);
INSERT INTO `migrations` VALUES (913,'2023_06_14_120299_add_type_enum_to_inventory_assembly_lines',90);
INSERT INTO `migrations` VALUES (914,'2023_06_16_134054_seed_uuid_to_backorder_queue_table',90);
INSERT INTO `migrations` VALUES (915,'2023_06_16_162338_alter_table_amazon_order_items_add_seller_sku_column',90);
INSERT INTO `migrations` VALUES (916,'2023_06_17_135540_fix_amazon_fnsku_products_primary_key',90);
INSERT INTO `migrations` VALUES (917,'2023_06_18_015307_add_is_before_initial_count_to_amazon_fba_inbound_shipments',90);
INSERT INTO `migrations` VALUES (918,'2023_06_19_133707_remove_duplicate_detailed_disposition_from_amazon_fba_report_removal_shipments_table',90);
INSERT INTO `migrations` VALUES (919,'2023_06_20_170806_create_temporary_tables_table',90);
INSERT INTO `migrations` VALUES (920,'2023_06_20_184955_alter_table_amazon_fba_report_restock_recreate_columns',90);
INSERT INTO `migrations` VALUES (921,'2023_06_20_191602_make_key_unique_in_settings_table',90);
INSERT INTO `migrations` VALUES (922,'2023_06_21_021557_add_auto_split_backorder_po_by_brand_to_suppliers_table',90);
INSERT INTO `migrations` VALUES (923,'2023_06_22_123229_convert_no_audit_trail_to_externally_fulfilled_in_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (924,'2023_06_26_044519_remove_reporting_products_and_reporting_orders_tables',90);
INSERT INTO `migrations` VALUES (925,'2023_06_26_075843_remove_kit_product_id',90);
INSERT INTO `migrations` VALUES (926,'2023_06_26_172009_fix_constants_countries_table',90);
INSERT INTO `migrations` VALUES (927,'2023_07_02_034828_create_sales_order_line_financials_table',90);
INSERT INTO `migrations` VALUES (928,'2023_07_02_125636_remove_financials_from_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (929,'2023_07_02_161439_add_sales_order_line_non_product_revenue_allocations_table',90);
INSERT INTO `migrations` VALUES (930,'2023_07_03_115713_create_financial_line_types_table',90);
INSERT INTO `migrations` VALUES (931,'2023_07_03_115951_create_financial_lines_table',90);
INSERT INTO `migrations` VALUES (932,'2023_07_04_135122_create_product_components_table',90);
INSERT INTO `migrations` VALUES (933,'2023_07_04_162053_adjust_subtotal_cache_decimal_size_in_sales_order_lines_table',90);
INSERT INTO `migrations` VALUES (934,'2023_07_05_005545_remove_financial_from_sales_orders_table',90);
INSERT INTO `migrations` VALUES (935,'2023_07_05_074004_fix_products_components_data',90);
INSERT INTO `migrations` VALUES (936,'2023_07_07_013619_drop_reporting_daily_product_proforma_financials_table',90);
INSERT INTO `migrations` VALUES (937,'2023_07_07_013700_create_reporting_daily_financials_table',90);
INSERT INTO `migrations` VALUES (938,'2023_07_07_135538_add_sku_order_updated_at_to_shopify_orders_table',90);
INSERT INTO `migrations` VALUES (939,'2023_07_09_013321_drop_is_daily_average_consumption_cache_valid_in_products_table',90);
INSERT INTO `migrations` VALUES (940,'2023_07_09_174929_add_updated_at_utc_and_created_at_utc_to_shopify_orders_table',90);
INSERT INTO `migrations` VALUES (941,'2023_07_11_050057_fix_lengths_of_pii_fields',90);
INSERT INTO `migrations` VALUES (942,'2023_07_12_015108_dispatch_job_to_seed_sales_order_line_financials',90);
INSERT INTO `migrations` VALUES (943,'2023_07_13_144452_add_queued_at_column_to_queue_monitor_table',90);
INSERT INTO `migrations` VALUES (944,'2023_07_15_010838_add_shortage_quantity_to_backorder_queues_table',90);
INSERT INTO `migrations` VALUES (945,'2023_07_15_013439_add_unreleased_quantity_to_backorder_queue_coverages_table',90);
INSERT INTO `migrations` VALUES (946,'2023_07_17_182434_add_index_for_sku_for_shopify_products',90);
INSERT INTO `migrations` VALUES (947,'2023_07_24_123319_remove_duplicates_and_add_unique_constraint_to_product_listings',90);
INSERT INTO `migrations` VALUES (948,'2023_07_28_145355_add_available_quantity_to_fifo_layers',90);
INSERT INTO `migrations` VALUES (949,'2023_08_04_004320_make_sales_channel_line_id_nullable',90);
INSERT INTO `migrations` VALUES (950,'2023_08_12_050537_fix_amazon_fba_report_inventory_fields',90);
INSERT INTO `migrations` VALUES (951,'2023_08_12_112504_convert_accounting_transacitons_pii_fields_to_text',90);
INSERT INTO `migrations` VALUES (952,'2023_08_14_145103_alter_table_shopify_order_line_items_make_line_id_varchar',90);
INSERT INTO `migrations` VALUES (953,'2023_08_23_103036_change_receive_by_date_to_deliver_by_date_in_sales_orders_table',90);
INSERT INTO `migrations` VALUES (954,'2023_08_23_121041_add_amount_field_to_sales_credit_allocations_table',90);
INSERT INTO `migrations` VALUES (955,'2023_08_24_060953_alter_table_sales_orders_is_fba_column_nullable',90);
INSERT INTO `migrations` VALUES (956,'2023_08_24_075306_add_sales_channel_qty_to_product_listing_inventory_locations',90);
INSERT INTO `migrations` VALUES (957,'2023_08_27_012920_drop_inventory_bundling',90);
INSERT INTO `migrations` VALUES (958,'2023_08_29_114234_add_unreceived_quantity_to_purchase_order_lines',90);
INSERT INTO `migrations` VALUES (959,'2023_08_29_115846_add_purchase_order_line_id_to_purchase_order_shipment_receipt_lines',90);
INSERT INTO `migrations` VALUES (960,'2023_08_31_174940_remove_inventory_incoming_from_products_inventory',90);
INSERT INTO `migrations` VALUES (961,'2023_09_06_125348_fix_unreceived_quantity_in_purchase_order_lines_to_have_min_0',90);
INSERT INTO `migrations` VALUES (962,'2023_09_11_060015_alter_table_amazon_fba_report_shipments_fix_item_price_column',90);
INSERT INTO `migrations` VALUES (963,'2023_09_15_222938_increase_size_of_po_amount_fields',90);
INSERT INTO `migrations` VALUES (964,'2023_09_18_145835_alter_tables_orders_add_error_log_column',90);
INSERT INTO `migrations` VALUES (965,'2023_09_19_150245_alter_table_orders_drop_sync_status_column',90);
INSERT INTO `migrations` VALUES (966,'2023_09_20_162912_add_composite_index_for_shopify_order_updates',90);
INSERT INTO `migrations` VALUES (967,'2023_09_21_124529_alter_table_woo_commerce_products_alter_decimal_columns',90);
INSERT INTO `migrations` VALUES (968,'2023_09_24_143739_update_purchase_order_lines_table',90);
INSERT INTO `migrations` VALUES (969,'2023_09_25_100446_alter_table_woo_commerce_orders_add_date_completed_column',90);
INSERT INTO `migrations` VALUES (970,'2023_09_25_172912_add_warehouse_transfer_balance_to_amazon_fnsku_products',90);
INSERT INTO `migrations` VALUES (971,'2023_09_25_184323_make_product_id_nullable_in_amazon_product_fnsku_table',90);
INSERT INTO `migrations` VALUES (972,'2023_09_25_220606_add_last_processed_at_to_amazon_fba_report_inventory_ledger',90);
INSERT INTO `migrations` VALUES (973,'2023_09_26_201637_add_nominal_code_id_to_financial_line_types',90);
INSERT INTO `migrations` VALUES (974,'2023_09_26_201949_add_nominal_code_id_to_financial_lines',90);
INSERT INTO `migrations` VALUES (975,'2023_09_28_163031_enable_accounting_setting',90);
INSERT INTO `migrations` VALUES (976,'2023_09_28_165630_add_tax_rate_and_tax_rate_id_to_financial_lines_table',90);
INSERT INTO `migrations` VALUES (977,'2023_09_28_333246_update_purchase_order_lines',90);
INSERT INTO `migrations` VALUES (978,'2023_10_04_100614_add_linked_backorders_field_to_purchase_order_lines_table',90);
INSERT INTO `migrations` VALUES (979,'2023_10_04_104212_add_is_tight_field_to_backorder_queue_coverages_table',90);
INSERT INTO `migrations` VALUES (980,'2023_10_13_151530_seed_new_warehouse_setting_key',90);
INSERT INTO `migrations` VALUES (981,'2023_10_23_124108_create_tracked_job_logs_table',90);
INSERT INTO `migrations` VALUES (982,'2023_10_23_173435_add_duration_to_tracked_job_logs_table',90);
INSERT INTO `migrations` VALUES (983,'2023_10_24_102218_add_order_number_index_to_starshipit_orders',90);
INSERT INTO `migrations` VALUES (984,'2023_10_24_163226_add_indexes_to_shopify_order_mappings',90);
INSERT INTO `migrations` VALUES (985,'2023_10_27_163043_create_ebay_orders_table',90);
INSERT INTO `migrations` VALUES (986,'2023_10_27_164417_create_ebay_order_items_table',90);
INSERT INTO `migrations` VALUES (987,'2023_10_27_200115_add_index_to_order_status_field_in_purchase_orders_table',90);
INSERT INTO `migrations` VALUES (988,'2023_10_28_173049_create_ebay_legacy_products_table',90);
INSERT INTO `migrations` VALUES (989,'2023_10_30_091530_create_custom_fields_table',90);
INSERT INTO `migrations` VALUES (990,'2023_10_30_091854_create_custom_field_values_table',90);
INSERT INTO `migrations` VALUES (991,'2023_11_05_100615_alter_table_shopify_products_fix_created_at_updated_at_column',90);
INSERT INTO `migrations` VALUES (992,'2023_11_08_081709_alter_table_shopify_products_alter_removed_from_shopify_products_make_non_nullable',90);
INSERT INTO `migrations` VALUES (993,'2023_11_13_110254_alter_table_shopify_products_make_removed_from_shopify_not_nullable',90);
INSERT INTO `migrations` VALUES (994,'2023_11_16_135453_add_unique_index_to_custom_field_values_table',90);
