<?php

use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Services\Accounting\AccountingTransactionManager;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        $integrationInstances = IntegrationInstance::with('salesChannel')
            ->whereHas('integration', function (Builder $query) {
                $query->where('integration_type', Integration::TYPE_SALES_CHANNEL);
            })->get();

        foreach ($integrationInstances as $integrationInstance) {
            DB::transaction(function () use ($integrationInstance) {
                $settings = $integrationInstance->integration_settings;
                $settings['sync_sales_order_invoices_to_accounting'] = true;
                $integrationInstance->integration_settings = $settings;
                $integrationInstance->save();
                app(AccountingTransactionManager::class)->syncAccountingTransactionsSalesOrderIsSyncEnabledStatus($integrationInstance);
            });
        }
    }

    public function down(): void
    {

    }
};
