<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_financial_event_type_nominal_code_mappings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained('integration_instances')->cascadeOnDelete()->index('afetncm_integration_instance_id_foreign');
            $table->string('name');
            $table->foreignId('nominal_code_id')->nullable()->constrained('nominal_codes')->onDelete('set null')->index('afetncm_nominal_code_id_foreign');
            $table->timestamps();

            $table->unique(['integration_instance_id', 'name'], 'afetncm_integration_instance_id_name_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('table_amazon_financial_event_type_nominal_code_mappings');
    }
};
