<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('financial_lines', function (Blueprint $table) {
            $table->integer('external_source_id')->nullable()->after('hash');
            $table->string('external_source_type')->nullable()->after('hash');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('financial_lines', function (Blueprint $table) {
            $table->dropColumn('external_source_id');
            $table->dropColumn('external_source_type');
        });
    }
};
