<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('accounting_transactions', function (Blueprint $table) {
            $table->boolean('is_sync_enabled')->default(true)->after('is_batchable');
        });
    }

    public function down(): void
    {
        Schema::table('accounting_transactions', function (Blueprint $table) {
            $table->dropColumn('is_sync_enabled');
        });
    }
};
