<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        // Add the generated column after the 'amount' column using a raw SQL statement
        DB::statement('
            ALTER TABLE `financial_allocatables`
            ADD COLUMN `unique_hash` CHAR(32) GENERATED ALWAYS AS (
                MD5(CONCAT_WS(\'#\', `allocatable_type`, `allocatable_from_id`, `allocatable_from_type`, `allocatable_to_id`, `allocatable_to_type`))
            ) STORED
            AFTER `amount`
        ');

        // Add the unique index on the generated column
        Schema::table('financial_allocatables', function (Blueprint $table) {
            $table->unique('unique_hash', 'unique_allocatables');
        });
    }

    public function down()
    {
        // Remove the unique index
        Schema::table('financial_allocatables', function (Blueprint $table) {
            $table->dropUnique('unique_allocatables');
        });

        // Remove the generated column using a raw SQL statement
        DB::statement('ALTER TABLE `financial_allocatables` DROP COLUMN `unique_hash`');
    }
};
