<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('financial_alerts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_order_line_financial_id');
            $table->foreignId('financial_alert_classification_id')->nullable();
            $table->string('alert_type');
            $table->string('note')->nullable();
            $table->unsignedBigInteger('archived_by_user_id')->nullable();
            $table->timestamps();
            $table->dateTime('archived_at')->nullable();
            $table->foreign('archived_by_user_id')->references('id')->on('users')->onDelete('restrict');
            $table->unique('sales_order_line_financial_id');
        });

        Artisan::call('sku:setup --skip-constants');
    }

    public function down(): void
    {
        Schema::dropIfExists('financial_alerts');
    }
};
