<?php

use App\Models\Shopify\ShopifyOrder;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shopify_orders', function (Blueprint $table) {
            $table->dateTime('processedAtUtc')->nullable()->after('processed_at')->index();
            $table->index('sku_order_updated_at');
        });

        // By default, MariaDB is creating timestamp column and thats why added DATETIME
        DB::statement("ALTER TABLE `shopify_orders` MODIFY `processedAtUtc` DATETIME NULL AFTER `processed_at`");
        DB::statement("ALTER TABLE `shopify_orders` MODIFY `sku_order_updated_at` DATETIME NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('shopify_orders', function (Blueprint $table) {
            $table->dropColumn('processedAtUtc');
            $table->dropIndex('shopify_orders_sku_order_updated_at_index');
        });

         DB::statement("ALTER TABLE `shopify_orders` MODIFY `sku_order_updated_at` TIMESTAMP NULL");
    }
};
