<?php

use App\Models\Setting;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ASN_FILE_FORMAT],
            [
                'description' => 'Advanced shipment notices file format',
                'type' => Setting::TYPE_STRING,
                'value' => 'csv',
                'default_value' => 'csv',
            ]);
    }

    public function down(): void
    {
        Setting::query()->where('key', Setting::KEY_ASN_FILE_FORMAT)->delete();
    }
};
