<?php

use App\Models\Setting;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Setting::with([])->firstOrCreate(['key' => Setting::KEY_ASN_CC_EMAIL],
            [
                'description' => 'Advanced shipment notices CC email address',
                'type' => Setting::TYPE_EMAIL,
                'value' => null,
                'default_value' => null,
            ]);
    }

    public function down(): void
    {
        Setting::query()->where('key', Setting::KEY_ASN_CC_EMAIL)->delete();
    }
};
