<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ship_my_orders_invoice_lines', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ship_my_orders_invoice_id')->constrained();
            $table->date('date');
            $table->string('reference');
            $table->string('description');
            $table->decimal('amount', 10, 4);
            $table->integer('quantity');
            $table->decimal('subtotal', 10, 4);
            $table->decimal('tax', 10, 4);
            $table->decimal('total', 10, 4);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ship_my_orders_invoice_lines');
    }
};
