<?php

use App\Models\StoreEmailTemplate;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {

    public function up(): void
    {
        StoreEmailTemplate::create([
            'store_id' => 1,
            'type' => StoreEmailTemplate::TYPE_ASN_NOTES,
            'subject' => 'Advanced Shipment Notice (ASN) #{{reference_number}}',
            'html_body' => '<p>We are expecting an incoming shipment and have included an ASN to help with receiving.</p>',
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true

        ]);

        StoreEmailTemplate::create([
            'store_id' => 1,
            'type' => StoreEmailTemplate::TYPE_ASN_NOTES_FBA,
            'subject' => 'Advanced Shipment Notice (ASN) for Amazon FBA Removal Order #{{warehouse_transfer_number}}, Tracking #s {{amazon_removal_shipment_carrier}} {{amazon_removal_shipment_tracking_number}}',
            'html_body' => '<p>We are expecting a return of goods from Amazon FBA with tracking numbers {{amazon_removal_shipment_carrier}} {{amazon_removal_shipment_tracking_number}}, Shipped from Amazon on {{amazon_removal_shipment_shipment_date}}.  We have included an ASN to help with receiving.</p>',
            'sent_type' => StoreEmailTemplate::SENT_TYPE_MANUALLY,
            'attach_pdf' => true,
            'enabled' => true
        ]);
    }

    public function down(): void
    {
        StoreEmailTemplate::whereIn('type',
            [StoreEmailTemplate::TYPE_ASN_NOTES, StoreEmailTemplate::TYPE_ASN_NOTES_FBA])->delete();
    }
};
