<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->softDeletes();
            $table->string('activation_token')->nullable()->after('auth_2fa_token_email_expiration');
            $table->timestamp('activated_at')->nullable()->after('activation_token');
        });
        DB::update('UPDATE users SET activated_at = created_at');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropSoftDeletes();
            $table->dropColumn('activation_token');
            $table->dropColumn('activated_at');
        });
    }
};
