<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_financial_refund_events', function (Blueprint $table) {
            $table->id();
            $table->string('checksum');
            $table->foreignId('integration_instance_id')->constrained()->index('afrset_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->nullable()->constrained()->index('afrset_amazon_financial_event_group_index');
            $table->string('AmazonOrderId')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.AmazonOrderId"))');
            $table->string('SellerOrderId')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.SellerOrderId"))');
            $table->string('MarketplaceName')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.MarketplaceName"))');
            $table->string('PostedDate')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.PostedDate"))');
            $table->json('json_object');
            $table->timestamps();

            $table->unique(['checksum', 'integration_instance_id'], 'amazon_refund_events_checksum_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_refund_events');
    }
};
