<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        // Rename the parent table
        Schema::rename('inventory_forecast_summary', 'inventory_forecasts');


        // Drop the existing foreign key constraint
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->dropForeign(['summary_id']);
        });

        // Rename the foreign key column in the child table
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->renameColumn('summary_id', 'inventory_forecast_id');
        });


        // Add the new foreign key constraint
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->foreign('inventory_forecast_id')->references('id')
                ->on('inventory_forecasts')
                ->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        // Rename the foreign key column back in the child table
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->renameColumn('inventory_forecast_id', 'summary_id');
        });


        // Drop the new foreign key constraint
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->dropForeign(['inventory_forecast_id']);
        });

        // Add the old foreign key constraint back
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->foreign('summary_id')->references('id')
                ->on('inventory_forecasts')
                ->cascadeOnDelete();
        });

        // Rename the parent table back
        Schema::rename('inventory_forecasts', 'inventory_forecast_summary');
    }
};
