<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('inventory_forecasts_cache', function (Blueprint $table) {
            $table->dropForeign(['summary_id']);
        });

        Schema::rename('inventory_forecasts_cache', 'inventory_forecast_items');

        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->foreign('summary_id')
                ->references('id')
                ->on('inventory_forecast_summary')
                ->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('inventory_forecast_items', function (Blueprint $table) {
            $table->dropForeign(['summary_id']);
        });

        Schema::rename('inventory_forecast_items', 'inventory_forecasts_cache');

        Schema::table('inventory_forecasts_cache', function (Blueprint $table) {
            $table->foreign('summary_id')
                ->references('id')
                ->on('inventory_forecast_summary')
                ->cascadeOnDelete();
        });
    }
};
