<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('sales_channel_field_definitions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_id')->index();
            $table->string('field_name');
            $table->string('data_type');
            $table->json('validation_rules');
            $table->unsignedInteger('sort_order')->default(0);
            $table->timestamps();
            $table->unique(['integration_id', 'field_name'], 'unique_integration_field_name');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales_channel_field_definitions');
    }
};
