<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_financial_shipment_events', function (Blueprint $table) {
            $table->string('checksum');
            $table->unique(['checksum', 'integration_instance_id'], 'amazon_shipment_events_checksum_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_financial_shipment_events', function (Blueprint $table) {
            $table->dropColumn('amazon_shipment_events_checksum_unique');
            $table->dropColumn('checksum');
        });
    }
};
