<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Setting;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Setting::query()->firstOrCreate([
            'key' => Setting::KEY_AUTO_FULFILLMENT_FAILURE_NOTIFICATIONS
        ], [
            'value' => false,
            'description' => 'Auto fulfillment failure notifications.',
            'type' => 'checkbox',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Setting::query()->where('key', Setting::KEY_AUTO_FULFILLMENT_FAILURE_NOTIFICATIONS)->delete();
    }
};
