<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Setting;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Setting::query()->firstOrCreate([
            'key' => Setting::KEY_FULFILL_ON_MAPPED_SHIPPING_METHOD
        ], [
            'value' => false,
            'description' => 'Only fulfill orders when a shipping method is mapped.',
            'type' => 'checkbox',
        ]);
        Setting::query()->firstOrCreate([
            'key' => Setting::KEY_AUTO_FULFILLMENT_EMAIL
        ], [
            'value' => null,
            'description' => 'Shipping providers that are automated for fulfillment.',
            'type' => 'string',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Setting::query()->whereIn('key', [
            Setting::KEY_FULFILL_ON_MAPPED_SHIPPING_METHOD,
            Setting::KEY_AUTO_FULFILLMENT_EMAIL,
        ])->delete();
    }
};
