<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('smo_orders', function (Blueprint $table) {

            DB::unprepared("ALTER TABLE smo_orders DROP COLUMN `smo_id`");
            DB::unprepared("ALTER TABLE smo_orders DROP COLUMN `OrderStatus`");

            $table->unsignedBigInteger('smo_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_data`, '$.ID'))")->after('sku_fulfillment_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('smo_orders', function (Blueprint $table) {

            DB::unprepared("ALTER TABLE smo_orders DROP COLUMN `smo_id`");

            $table->unsignedBigInteger('smo_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_data`, '$.Order.OrderId'))")->after('sku_fulfillment_id');
            $table->string('OrderStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(`json_data`, '$.Order.OrderStatus'))")->after('smo_id');
        });
    }
};
