<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('amazon_fba_initial_inventory', function (Blueprint $table) {
            $table->integer('adjustments')->storedAs('`found` + `lost` + `damaged` + `disposed` + `other_events`')->after('other_events');
        });
    }

    public function down(): void
    {
        Schema::table('amazon_initial_inventory', function (Blueprint $table) {
            $table->dropColumn('adjustments');
        });
    }
};
