<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('amazon_fba_report_inventory_ledger_summaries', function (Blueprint $table) {
            $table->id();
            $table->text('checksum')->nullable();
            $table->foreignId('integration_instance_id');
            $table->foreignId('amazon_report_id');
            $table->foreignId('inventory_adjustment_id')->nullable();
            $table->dateTime('reconciled_at')->nullable();
            $table->string('errorLog')->nullable();
            $table->string('date')->storedAs("json_unquote(json_extract(`json_object`,'$.date'))");
            $table->dateTime('event_datetime');
            $table->string('fnsku')->storedAs("json_unquote(json_extract(`json_object`,'$.fnsku'))");
            $table->string('asin')->storedAs("json_unquote(json_extract(`json_object`,'$.asin'))");
            $table->string('msku')->storedAs("json_unquote(json_extract(`json_object`,'$.msku'))");
            $table->string('title')->storedAs("json_unquote(json_extract(`json_object`,'$.title'))");
            $table->string('disposition')->storedAs("json_unquote(json_extract(`json_object`,'$.disposition'))");
            $table->integer('starting_warehouse_balance')->storedAs("json_unquote(json_extract(`json_object`,'$.starting_warehouse_balance'))");
            $table->integer('in_transit_between_warehouses')->storedAs("json_unquote(json_extract(`json_object`,'$.in_transit_between_warehouses'))");
            $table->integer('receipts')->storedAs("json_unquote(json_extract(`json_object`,'$.receipts'))");
            $table->integer('customer_shipments')->storedAs("json_unquote(json_extract(`json_object`,'$.customer_shipments'))");
            $table->integer('customer_returns')->storedAs("json_unquote(json_extract(`json_object`,'$.customer_returns'))");
            $table->integer('vendor_returns')->storedAs("json_unquote(json_extract(`json_object`,'$.vendor_returns'))");
            $table->integer('warehouse_transfer_in_out')->storedAs("json_unquote(json_extract(`json_object`,'$.warehouse_transfer_in_out'))");
            $table->integer('found')->storedAs("json_unquote(json_extract(`json_object`,'$.found'))");
            $table->integer('lost')->storedAs("json_unquote(json_extract(`json_object`,'$.lost'))");
            $table->integer('damaged')->storedAs("json_unquote(json_extract(`json_object`,'$.damaged'))");
            $table->integer('disposed')->storedAs("json_unquote(json_extract(`json_object`,'$.disposed'))");
            $table->integer('other_events')->storedAs("json_unquote(json_extract(`json_object`,'$.other_events'))");
            $table->integer('adjustments')->storedAs('`found` + `lost` + `damaged` + `disposed` + `other_events`');
            $table->integer('ending_warehouse_balance')->storedAs("json_unquote(json_extract(`json_object`,'$.ending_warehouse_balance'))");
            $table->integer('total_inventory_quantity')->storedAs("`in_transit_between_warehouses` + `ending_warehouse_balance`");
            $table->integer('unknown_events')->storedAs("json_unquote(json_extract(`json_object`,'$.unknown_events'))");
            $table->string('location')->storedAs("json_unquote(json_extract(`json_object`,'$.location'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_inventory_ledger_summaries');
    }
};
