<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_feed_requests', function (Blueprint $table) {
            $table->longText('requestFeedDocumentXml')->nullable()->change();
        });

        Schema::table('amazon_feed_submissions', function (Blueprint $table) {
            $table->longText('resultFeedDocumentXml')->nullable()->change();
            $table->longText('requestFeedDocumentXml')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_feed_requests', function (Blueprint $table) {
            $table->text('requestFeedDocumentXml')->nullable()->change();
        });

        Schema::table('amazon_feed_submissions', function (Blueprint $table) {
            $table->text('resultFeedDocumentXml')->nullable()->change();
            $table->text('requestFeedDocumentXml')->nullable()->change();
        });
    }
};
