<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('qbo_tax_rates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained();
            $table->string('QboId')->unique()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Id'))");
            $table->string('Name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Name'))");
            $table->string('Description')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Description'))");
            $table->boolean('Active')->storedAs("(
                CASE 
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Active')) = 'true' THEN true
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Active')) = 'false' THEN false
                    ELSE NULL
                END
            )");
            $table->decimal('RateValue')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.RateValue'))");
            $table->json('AgencyRef')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.AgencyRef'))");
            $table->string('SpecialTaxType')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.SpecialTaxType'))");
            $table->string('DisplayType')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.DisplayType'))");
            $table->string('domain')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.domain'))");
            $table->boolean('sparse')->storedAs("(
                CASE 
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sparse')) = 'true' THEN true
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sparse')) = 'false' THEN false
                    ELSE NULL
                END
            )");
            $table->string('SyncToken')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.SyncToken'))");
            $table->json('MetaData')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.MetaData'))");
            $table->dateTime('LastUpdatedTimeUtc')->storedAs("STR_TO_DATE(JSON_UNQUOTE(json_extract(json_object,'$.LastUpdatedTimeUtc')),'%Y-%m-%d %H:%i:%s')");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('qbo_tax_rates');
    }
};
