<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('qbo_accounts', function (Blueprint $table) {
            $table->unsignedBigInteger('integration_instance_id')->after('id');
            $table->foreign('integration_instance_id')
                ->references('id')
                ->on('integration_instances')
                ->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('qbo_accounts', function (Blueprint $table) {
            $table->dropForeign('qbo_accounts_integration_instance_id_foreign');
            $table->dropColumn('integration_instance_id');
        });
    }
};
