<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('product_components', function (Blueprint $table) {
            $table->unique(['parent_product_id', 'component_product_id'], 'product_components_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::table('product_components', function (Blueprint $table) {
            $table->dropUnique('product_components_unique_idx');
        });
    }
};
