<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('supplier_inventory', function (Blueprint $table) {
            $table->unique(['product_id', 'supplier_id', 'warehouse_id'], 'supplier_inventory_unique_idx');
        });
    }

    public function down(): void
    {
        Schema::table('supplier_inventory', function (Blueprint $table) {
            $table->dropUnique('supplier_inventory_unique_idx');
        });
    }
};
